# -*- coding: utf-8 -*-
#
# Author: Ingelrest François (Athropos@gmail.com)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

# Pages in the main notebook
(
    PAGE_CHECK,
    PAGE_CREATE,
) = range(2)

# Possible action when checking a par2 file
(
    CHECK_VERIFY,
    CHECK_REPAIR,
) = range(2)

# "Blocks" group
(
    BLOCKS_DYNAMIC,
    BLOCKS_COUNT,
    BLOCKS_SIZE,
) = range(3)

# "Redundancy" group
(
    REDUNDANCY_REDUNDANCY,
    REDUNDANCY_BLOCK_COUNT,
) = range(2)

# "Recovery files" group
(
    RECOVERY_LIMIT_SIZE,
    RECOVERY_NUMBER_OF_FILES,
) = range(2)

# ---======---
# Preferences : store all preferences of the application
# ---======---
class Preferences :

    def __init__(self) :
        self.outputDlgHeight = 400
        self.outputDlgWidth =  500
        self.mainPage = PAGE_CHECK
        self.checkAction = CHECK_REPAIR
        self.showAdvSettings = False

        self.resetAdvancedSettings()


    def resetAdvancedSettings(self) :
        # Memory
        self.advMemoryUsage = 64
        # Blocks
        self.advBlocksSetting = BLOCKS_DYNAMIC
        self.advBlocksCount   = 1
        self.advBlocksSize    = 1
        # Redundancy
        self.advRedundancySetting = REDUNDANCY_REDUNDANCY
        self.advRedundancyLvl     = 5
        self.advRedundancyCount   = 100
        # Recovery
        self.advRecoverySetting = RECOVERY_NUMBER_OF_FILES
        self.advRecoveryNumber  = 7
        self.advRecoveryUniform = False
        # Beginning
        self.advBeginningFirst = 0
