#include <Python.h>

typedef struct PoolElement {
  char *key;
  PyObject *data;
  struct PoolElement *next;
} PoolElement;

typedef struct PoolBucket {
  int size;
  PoolElement *head, *tail;
} PoolBucket;

typedef struct StringPool {
  int size;
  PoolBucket **buckets;
} StringPool;

StringPool *string_pool_create(void);

void string_pool_destroy(StringPool *pool);

PoolElement *string_pool_insert(StringPool *pool, const char *key, const PyObject *data);

PyObject *string_pool_lookup(StringPool *pool, const char *key);

PyObject *pystring_from_pool(StringPool *pool, const char *cstr);
