
import time

NUM_STATEMENT = 10000

REDUNDANT_FACTOR=10
BLOCK_SIZE = 500
        

def test(driver, init):


    from Ft.Rdf import Model
    from Ft.Rdf import Statement

    if init:
        if driver.ExistsDb('test'):
            try:
                driver.DestroyDb('test')
            except:
                pass
        db = driver.CreateDb('test')
    else:
        db = driver.GetDb('test')

    m = Model.Model(db)

    if init:
        if init > NUM_STATEMENT:
            num_statements = init
        else:
            num_statements = NUM_STATEMENT
        print "Creating statements..."
        print "Using block size %d to create %d statements" % (
            BLOCK_SIZE,
            num_statements)
        blocks = num_statements / BLOCK_SIZE
        count = 0
        total = 0.0
        for block in range(blocks):
            db.begin()
            s = time.time()
            stmts = map(lambda c, b=block, klass=Statement.Statement:
                        klass('sub%d' % (c % REDUNDANT_FACTOR),
                              'pred%d' % (c % REDUNDANT_FACTOR),
                              'obj%d' % (c % REDUNDANT_FACTOR),
                              'uri%d' % b),
                        range(count,BLOCK_SIZE+count)
                        )
            count = count + BLOCK_SIZE
            m.add(stmts, 0)
            db.commit()
            e = time.time() - s
            total = total + e
            seconds = int(e / BLOCK_SIZE * num_statements - total)
            print 'Time remaining %d:%0.2d.  Blocks remaining %d.' % (
                seconds / 60,
                seconds % 60,
                blocks - block - 1
                )
        db.begin()
        m.add(Statement.Statement('sub-unique',
                                  'pred-unique',
                                  'obj-unique',
                                  'uri'))
        db.commit()
        print "Create Time %0.4f (%d statements)" % (total, num_statements)

    db.begin()
    s = time.time()
    m.complete('','','')
    print "Load Complete All %f" % (time.time()-s)

    s = time.time()
    m.complete('','pred6','')
    print "Load Complete with predicate %f" % (time.time()-s)

    s = time.time()
    m.complete('sub8','pred8','')
    print "Load Complete with predicate and subject %f" % (time.time()-s)
    
    s = time.time()
    m.complete('sub1','pred1','obj1')
    print "Load Complete with predicate object and subject %f" % (time.time()-s)

    s = time.time()
    m.complete('sub-unique','pred-unique','obj-unique')
    print "Load Complete Unique %f" % (time.time()-s)

    
    s = time.time()
    m.complete('sub1','pred2','obj8')
    print "Load Complete with empty resaults %f" % (time.time()-s)
    
    db.commit()



if __name__ == '__main__':
    import sys
    init = 0
    if len(sys.argv) > 1:
        init = int(sys.argv[1])

    from Ft.Rdf.Drivers import Postgres
    from Ft.Rdf.Drivers import Dbm
    print 'Postgres'
    test(Postgres, init)

    print '-'*50
    print 'Dbm'
    test(Dbm, init)
