#!/usr/bin/env python

import os, sys, glob, string

import distutils
from distutils.core import setup, Extension
from distutils import version, util, file_util
from admin import DistExt
from admin.DistExt import Document, PyModules, CommandLineApp, Localization
from admin import Data_Files, install_Data_Files

g = {}
execfile('__init__.py', g)
__version__ = g['__version__']
__pyxml_version__ = g['__pyxml_version__']

############################################################
#
# Validate/Install PyXML
#
############################################################

pyxml_required = version.StrictVersion(__pyxml_version__)
try:
    import xml
    xml_version = xml.version_info
except:
    xml_version = (0, 0, 0)

if xml_version < pyxml_required.version:
    print """
    PyXML v%s is required for 4Suite.  It is available at
    http://sourceforge.net/projects/pyxml.
    """ % str(pyxml_required)
    sys.exit(1)

#    saved_argv = sys.argv[:]
#
#    while 'sdist' in sys.argv:
#        sys.argv.remove('sdist')
#
#    for arg in sys.argv[1:]:
#        if arg[:7] == 'install' or arg[:5] in ['build', 'bdist']:
#            pos = sys.argv.index(arg)
#            sys.argv.insert(pos, '--build-base=' + os.getcwd() + os.sep + 'build')
#            sys.argv.insert(pos, 'build')
#            break
#
#    if os.access('PyXML', os.F_OK):
#        cwd = os.getcwd()
#        os.chdir('PyXML')
#        script_name = 'setup.py'
#        try:    
#            sys.argv[0] = script_name
#            execfile(script_name, {})
#        except SystemExit:
#            pass
#        except:
#            raise
#        os.chdir(cwd)
#    else:
#        print """
#        PyXML v%s is required for 4Suite.  It is available at
#        http://sourceforge.net/projects/pyxml.  If you have it in a
#        directory called "PyXML" in the 4Suite installation directory,
#        the 4Suite installer will set it up for you.
#        """ % str(pyxml_required)
#        sys.exit(1)
#    sys.argv = saved_argv

############################################################
#
#  Overriding/extending functionality of DistUtils
#
############################################################

DistExt.InstallSubCommands()

PYTHON_VERSION = float(sys.version[:3])

def xml(package):
    """Create the package name for Python 2.x/1.5.2"""
    if PYTHON_VERSION <= 1.5:
        root = 'xml'
    else:
        root = '_xmlplus'
    return package and '%s.%s' % (root, package) or root

def get_files(file_spec):
    path = os.path.normpath(file_spec)
    return glob.glob(path)

############################################################
#
#  4Suite Setup Code
#
############################################################

longDesc = """4Suite is a collection of Python tools for XML processing and object-databases.

4Suite is an integrated packaging of 4DOM, 4XPath, 4XSLT, 4RDF, and 4ODS.
"""

############################################################
#
#  4Suite Extension Modules
#
############################################################

ext_modules = [Extension('Ft.Lib.routines',
                         include_dirs=['Lib/src'],
                         sources=['Lib/src/routines.c'],
                         ),

               Extension('Ft.Lib.number',
                         include_dirs=['Lib/src'],
                         sources=['Lib/src/number.c'],
                         ),

               Extension(xml('xpath.XPathParserc'),
                         sources=['XPath/XPathParser.c'],
                         ),
               
               Extension(xml('xslt.XPatternParserc'),
                         sources=['Xslt/XPatternParser.c'],
                         ),
               
               Extension('Ft.XPointer.XPointerParserc',
                         sources=['XPointer/XPointerParser.c'],
                         ),
               Extension('Ft.XPointer.XPtrExprParserc',
                         sources=['XPointer/XPtrExprParser.c'],
                         ),
               
               #Extension('Ft.Ods.Parsers.Odl.OdlParserc',
               #          sources=['Ods/Parsers/Odl/OdlParser.c'],
               #          ),
               
               Extension('Ft.Ods.Parsers.Oql.Oqlc',
                         sources=['Ods/Parsers/Oql/Oql.tab.c',
                                  'Ods/Parsers/Oql/OqlSwig.c',
                                  'Ods/Parsers/Oql/Oql_wrap.c',
                                  'Ods/Parsers/Oql/lex.Oql.c',
                                  ],
                         include_dirs=['Ods/Parsers/Oql'],
                         ),
               
               Extension('Ft.Ods.Parsers.Oif.Oifc',
                         sources=['Ods/Parsers/Oif/Oif.tab.c',
                                  'Ods/Parsers/Oif/OifSwig.c',
                                  'Ods/Parsers/Oif/Oif_wrap.c',
                                  'Ods/Parsers/Oif/lex.Oif.c',
                                  ],
                         include_dirs=['Ods/Parsers/Oif'],
                         ),
               ]
               
cDomlette = Extension('Ft.Lib.cDomlettec',
                      define_macros=[('XML_NS', None)],
                      include_dirs=['Lib/src',
                                    'Lib/src/expat/xmltok',
                                    'Lib/src/expat/xmlparse',
                                    ],
                      sources=['Lib/src/domlette/domlette.c',
                               'Lib/src/domlette/attr.c',
                               'Lib/src/domlette/element.c',
                               'Lib/src/domlette/processinginstruction.c',
                               'Lib/src/domlette/characterdata.c', 
                               'Lib/src/domlette/comment.c',
                               'Lib/src/domlette/text.c',
                               'Lib/src/domlette/document.c',
                               'Lib/src/domlette/domimplementation.c',
                               'Lib/src/domlette/node.c',
                               'Lib/src/domlette/util.c',
                               'Lib/src/domlette/expat2domlette.c',
                               'Lib/src/domlette/ds_tools.c',
                               'Lib/src/domlette/ds_primitives.c',
                               'Lib/src/domlette/string_pool.c',
                               # expat 1.2 sources
                               'Lib/src/expat/xmltok/xmltok.c',
                               'Lib/src/expat/xmltok/xmlrole.c',
                               'Lib/src/expat/xmlparse/xmlparse.c',
                               ],
                      )
ext_modules.append(cDomlette)

# Enable debugging for cDomlette
if int(os.environ.get('DOMLETTE_DEBUG', 0)):
    cDomlette.define_macros.append(('DEBUG', None))


############################################################
#
#  4Suite Packages and Single Python Files
#
############################################################


py_files = [('Ft.Lib', ['admin/DistExt.py', 'admin/install_data.py']),
            ]

if PYTHON_VERSION >= 2.0:
    py_files.append(('Ft.Lib', ['admin/msgfmt.py', 'admin/pygettext.py']))

    l10n = [Localization(package='Ft.Lib', domain='4Suite',
                         sources=['Lib/MessageSource.py']),
            Localization(package='Ft.Rdf', domain='4Suite',
                         sources=['Rdf/MessageSource.py']),
            Localization(package='Ft.XPointer', domain='4Suite',
                         sources=['XPointer/XPointerParserBase.py']),
            Localization(package=xml('xpath'), domain='4Suite',
                         sources=['XPath/XPathParserBase.py']),
            Localization(package=xml('xslt'), domain='4Suite',
                         sources=['Xslt/XPatternParserBase.py']),
            Localization(package='Ft.Ods.Parsers.Odl', domain='4Suite',
                         sources=['Ods/Parsers/Odl/OdlParserBase.py']),
            Localization(package='Ft.Ods.Parsers.Oql', domain='4Suite',
                         sources=['Ods/Parsers/Oql/OqlParserBase.py']),
            Localization(package='Ft.Ods.Parsers.Oif', domain='4Suite',
                         sources=['Ods/Parsers/Oif/OifParserBase.py']),
            ]
else:
    l10n = []

############################################################
#
#  4Suite Data Files
#
############################################################

data_files = [Data_Files(copy_to='.',
                         files=['docs/text/COPYRIGHT',
                                'docs/text/CREDITS',
                                'docs/text/PACKAGES',
                                'docs/text/README',
                                'docs/text/ReleaseNotes',
                                'docs/text/REBUILDING',
                                'docs/text/TODO',
                                'docs/ChangeLog',
                                'docs/README.cDomlette',
                                'docs/README.Cyclops',
                                ]),
              Data_Files(copy_to='docs',
                         files=['docs/ChangeLog',
                                ]),
              Data_Files(copy_to='docs/text',
                         files=['docs/text/COPYRIGHT',
                                'docs/text/CREDITS',
                                'docs/text/PACKAGES',
                                'docs/text/README',
                                'docs/text/ReleaseNotes',
                                'docs/text/REBUILDING',
                                'docs/text/TODO',
                                'docs/ChangeLog',
                                'docs/README.cDomlette',
                                'docs/README.Cyclops',
                                ]),
              Data_Files(copy_to='docs/text/howto',
                         files=['docs/text/howto/UNIX',
                                'docs/text/howto/cjkv',
                                'docs/text/howto/Windows',
                                ]),
              Data_Files(copy_to='docs/xml',
                         files=get_files('docs/xml/*.*')),
              Data_Files(copy_to='docs/xml/howto',
                         files=get_files('docs/xml/howto/*.*')),
              Data_Files(copy_to='docs/html',
                         files=get_files('docs/html/*.html')),
              Data_Files(copy_to='docs/html/howto',
                         files=get_files('docs/html/howto/*.html')),
              Data_Files(copy_to='docs/html/ods',
                         files=get_files('docs/html/ods/*.html')),
              Data_Files(copy_to='docs/html/howto/images',
                         files=get_files('docs/html/howto/images/*.*')),
              
              # Test suites
              Data_Files(copy_to='test_suite',
                         files=get_files('test_suite/*.*')),

              Data_Files(copy_to='test_suite/Lib',
                         files=get_files('test_suite/Lib/*.*')),

              Data_Files(copy_to='test_suite/Tools',
                         files=get_files('Tools/test_suite/*.*')),

              # 4XPath test suite
              Data_Files(copy_to='test_suite/XPath',
                         files=get_files('test_suite/XPath/*.*')),
              Data_Files(copy_to='test_suite/XPath/Core',
                         files=get_files('test_suite/XPath/Core/*.*')),
              Data_Files(copy_to='test_suite/XPath/Borrowed',
                         files=get_files('test_suite/XPath/Borrowed/*.*')),

              # 4XSLT test suite
              Data_Files(copy_to='test_suite/',
                         files=get_files('test_suite/README')),
              Data_Files(copy_to='test_suite/Xslt',
                         files=get_files('test_suite/Xslt/README')),
              Data_Files(copy_to='test_suite/Xslt',
                         files=get_files('test_suite/Xslt/*.*')),
              Data_Files(copy_to='test_suite/Xslt/Core',
                         files=get_files('test_suite/Xslt/Core/README')),
              Data_Files(copy_to='test_suite/Xslt/Core',
                         files=get_files('test_suite/Xslt/Core/*.*')),
              Data_Files(copy_to='test_suite/Xslt/Borrowed',
                         files=get_files('test_suite/Xslt/Borrowed/README')),
              Data_Files(copy_to='test_suite/Xslt/Borrowed',
                         files=get_files('test_suite/Xslt/Borrowed/*.*')),

              # 4XPointer test suite
              Data_Files(copy_to='test_suite/XPointer',
                         files=get_files('test_suite/XPointer/*.*')),

              # 4XLink test suite
              Data_Files(copy_to='test_suite/XLink',
                         files=get_files('test_suite/XLink/*.*')),

              # 4RDF test harnesses
              Data_Files(copy_to='test_suite/Rdf',
                         files=get_files('test_suite/Rdf/*.*')),
              Data_Files(copy_to='test_suite/Rdf/borrowed',
                         files=get_files('test_suite/Rdf/borrowed/*.*')),

              Data_Files(copy_to='test_suite/Rdf/use_case',
                         files=get_files('test_suite/Rdf/use_case/*.*')),
              Data_Files(copy_to='test_suite/Rdf/Drivers',
                         files=get_files('test_suite/Rdf/Drivers/*.*')),

              Data_Files(copy_to='test_suite/Rdf/Inference',
                         files=get_files('test_suite/Rdf/Inference/*.*')),


              Data_Files(copy_to='profile/Rdf',
                         files=get_files('profile/Rdf/*.*')),


              #4ODS test suite
              Data_Files(copy_to='test_suite/Ods',
                         files=get_files('test_suite/Ods/*.py')),
              Data_Files(copy_to='test_suite/Ods/Adapters',
                         files=get_files('test_suite/Ods/Adapters/*.py')),
              Data_Files(copy_to='test_suite/Ods/Collections',
                         files=get_files('test_suite/Ods/Collections/*.*')),
              Data_Files(copy_to='test_suite/Ods/System',
                         files=get_files('test_suite/Ods/System/*.*')),
              Data_Files(copy_to='test_suite/Ods/MetaData',
                         files=get_files('test_suite/Ods/MetaData/*.*')),

              Data_Files(copy_to='test_suite/Ods/Parsers',
                         files=get_files('test_suite/Ods/Parsers/*.*')),
              Data_Files(copy_to='test_suite/Ods/StorageManager',
                         files=get_files('test_suite/Ods/StorageManager/*.*')),
              Data_Files(copy_to='test_suite/Ods/borrowed',
                         files=get_files('test_suite/Ods/borrowed/*.*')),

              Data_Files(copy_to='profile/Ods',
                         files=get_files('profile/Ods/*.*')),


              # Demos
              Data_Files(copy_to='demo/4XPath',
                         files=get_files('XPath/demo/*.*')),
              Data_Files(copy_to='demo/4XSLT',
                         files=get_files('Xslt/demo/*.*')),
              Data_Files(copy_to='demo/4XSLT',
                         files=get_files('Xslt/demo/README')),

              Data_Files(copy_to='demos/4RDF',
                         files=get_files('demos/4RDF/*.*')),
              Data_Files(copy_to='demos/4RDF',
                         files=get_files('demos/4RDF/README')),

              Data_Files(copy_to='demos/4ODS/book_mark_manager',
                         files=['demos/4ODS/book_mark_manager/README']),
              Data_Files(copy_to='demos/4ODS/book_mark_manager',
                         files=get_files('demos/4ODS/book_mark_manager/*.*')),
              Data_Files(copy_to='demos/4ODS/tutorial',
                         files=get_files('demos/4ODS/tutorial/*.*')),
              ]

for df in data_files:
    df.base_dir = '$base/doc/$dist_name-$dist_version'

############################################################
#
#  The actual setup
#
############################################################

dist = setup(
    name="4Suite",
    version=str(version.StrictVersion(__version__)),
    description="4Suite Description",
    author="Fourthought, Inc.",
    author_email="support@4suite.org",
    url="http://www.4suite.org",
    long_description=longDesc,

    distclass=DistExt.Dist,

    # Command function overrides
    cmdclass=DistExt.Commands,

    package_dir={xml('xpath') : 'XPath',
                 xml('xslt') : 'Xslt',
                 'Ft' : '.',
                 'Ft.Rdf' : 'Rdf',
                 'Ft.Lib' : 'Lib',
                 'Ft.Tools' : 'Tools',
                 'Ft.Ods' : 'Ods',
                 'Ft.XPointer' : 'XPointer',
                 'Ft.XLink' : 'XLink',
                 },

    packages=['Ft',
              'Ft.Lib',
              'Ft.Lib.CommandLine',
              'Ft.Lib.TestSuite',
              'Ft.Tools',

              xml('xpath'),

              xml('xslt'),
              xml('xslt.Debugger'),

              'Ft.XPointer',

              'Ft.XLink',

              'Ft.Rdf',
              'Ft.Rdf.Drivers',
              'Ft.Rdf.Inference',
              'Ft.Rdf.Parsers',
              'Ft.Rdf.Parsers.Ril',
              'Ft.Rdf.Serializers',

              'Ft.Ods',
              'Ft.Ods.Collections',
              'Ft.Ods.MetaData',
              'Ft.Ods.Parsers',
              'Ft.Ods.Parsers.Odl',
              'Ft.Ods.Parsers.Oif',
              'Ft.Ods.Parsers.Oql',
              'Ft.Ods.StorageManager',
              'Ft.Ods.StorageManager.Adapters',
              'Ft.Ods.StorageManager.Adapters.Postgres',
              'Ft.Ods.StorageManager.Adapters.Dbm',
              'Ft.Ods.StorageManager.Adapters.SQL',
              'Ft.Ods.StorageManager.Adapters.Oracle',
              'Ft.Ods.Tools',
              ],

    # Copies single files into the package tree (added by Fourthought)
    py_files=py_files,
    l10n=l10n,

    odl_files=[],
    
    data_files=data_files,
    ext_modules=ext_modules,
    scripts=DistExt.EnsureScripts('Xslt/bin/4xslt',
                                  'exec/4rdf',
                                  'exec/4odb',
                                  'exec/4xupdate',
                                  ),

    #A non standard option
    gen_docs=[Document('docs/xml/4XPath-ExtFunctions.api',
                       ['/usr/local/lib/xslt/api.xslt'],
                       '../html/4XPath-Extensions.html'),
              Document('docs/xml/4XPath.api',
                       ['/usr/local/lib/xslt/api.xslt'],
                       '../html/4XPath-Api.html'),
              
              Document('docs/xml/4XSLT-ExtElements.api',
                       ['/usr/local/lib/xslt/api.xslt'],
                       '../html/4XSLT-Extensions.html'),
              Document('docs/xml/4XSLT.api',
                       ['/usr/local/lib/xslt/api.xslt'],
                       '../html/4XSLT-Api.html'),
              Document('docs/xml/exslt.doc',
                       ['/usr/local/lib/xslt/docbook_html1.xslt'],
                       '../html/exslt.html'),
              
              Document('docs/xml/4XPointer.api',
                       ['/usr/local/lib/xslt/api.xslt'],
                       '../html/4XPointer-Api.html'),
              
              Document('docs/xml/4XLink.api',
                       ['/usr/local/lib/xslt/api.xslt'],
                       '../html/4XLink-Api.html'),
              
              Document('docs/xml/4RDF.api',
                       ['/usr/local/lib/xslt/api.xslt'],
                       '../html/4RDF-Api.html'),
              Document('docs/xml/ril.doc',
                       ['/usr/local/lib/xslt/docbook_html1.xslt'],
                       '../html/ril.html'),
              
              Document('docs/xml/exslt.doc',
                       ['/usr/local/lib/xslt/docbook_html1.xslt'],
                       '../html/exslt.html'),
              
              Document('docs/xml/4ODS-userguide.doc',
                       ['/usr/local/lib/xslt/docbook_html1.xslt'],
                       '../html/4ODS-userguide.html'),
              
              Document('docs/xml/COPYRIGHT.doc',
                       ['/usr/local/lib/xslt/docbook_text1.xslt'],
                       '../text/COPYRIGHT'),
              Document('docs/xml/COPYRIGHT.doc',
                       ['/usr/local/lib/xslt/docbook_text1.xslt'],
                       '../../COPYRIGHT'),
              Document('docs/xml/COPYRIGHT.doc',
                       ['/usr/local/lib/xslt/docbook_html1.xslt'],
                       '../html/COPYRIGHT.html'),
              Document('docs/xml/CREDITS.doc',
                       ['/usr/local/lib/xslt/docbook_text1.xslt'],
                       '../text/CREDITS'),
              Document('docs/xml/CREDITS.doc',
                       ['/usr/local/lib/xslt/docbook_html1.xslt'],
                       '../html/CREDITS.html'),
              Document('docs/xml/PACKAGES.doc',
                       ['/usr/local/lib/xslt/4Suite-docs-text.xslt'],
                       '../text/PACKAGES'),
              Document('docs/xml/PACKAGES.doc',
                       ['/usr/local/lib/xslt/4Suite-docs-html.xslt'],
                       '../html/PACKAGES.html'),
              Document('docs/xml/README.doc',
                       ['/usr/local/lib/xslt/4Suite-docs-text.xslt'],
                       '../text/README'),
              Document('docs/xml/README.doc',
                       ['/usr/local/lib/xslt/4Suite-docs-text.xslt'],
                       '../../README'),
              Document('docs/xml/README.doc',
                       ['/usr/local/lib/xslt/4Suite-docs-html.xslt'],
                       '../html/README.html'),
              Document('docs/xml/ReleaseNotes.doc',
                       ['/usr/local/lib/xslt/4Suite-docs-text.xslt'],
                       '../text/ReleaseNotes'),
              Document('docs/xml/ReleaseNotes.doc',
                       ['/usr/local/lib/xslt/4Suite-docs-text.xslt'],
                       '../../ReleaseNotes'),
              Document('docs/xml/ReleaseNotes.doc',
                       ['/usr/local/lib/xslt/4Suite-docs-html.xslt'],
                       '../html/ReleaseNotes.html'),
              Document('docs/xml/REBUILDING.doc',
                       ['/usr/local/lib/xslt/docbook_text1.xslt'],
                       '../text/REBUILDING'),
              Document('docs/xml/REBUILDING.doc',
                       ['/usr/local/lib/xslt/docbook_html1.xslt'],
                       '../html/REBUILDING.html'),
              Document('docs/xml/TODO.doc',
                       ['/usr/local/lib/xslt/docbook_text1.xslt'],
                       '../text/TODO'),
              Document('docs/xml/TODO.doc',
                       ['/usr/local/lib/xslt/docbook_html1.xslt'],
                       '../html/TODO.html'),
              
              Document('docs/xml/index.doc',
                       ['/usr/local/lib/xslt/docbook_html1.xslt'],
                       '../html/index.html'),
              
              Document('docs/xml/howto/UNIX.doc',
                       ['/usr/local/lib/xslt/docbook_html1.xslt'],
                       '../../html/howto/UNIX.html'),
              Document('docs/xml/howto/UNIX.doc',
                       ['/usr/local/lib/xslt/docbook_text1.xslt'],
                       '../../text/howto/UNIX'),
              
              Document('docs/xml/howto/Windows.doc',
                       ['/usr/local/lib/xslt/docbook_html1.xslt'],
                       '../../html/howto/Windows.html'),
              Document('docs/xml/howto/Windows.doc',
                       ['/usr/local/lib/xslt/docbook_text1.xslt'],
                       '../../text/howto/Windows'),

              Document('docs/xml/howto/cjkv.doc',
                       ['/usr/local/lib/xslt/docbook_html1.xslt'],
                       '../../html/howto/cjkv.html'),
              ## CJKV characters break text output.
              ##Document('docs/xml/howto/cjkv.doc',
              ##         ['/usr/local/lib/xslt/docbook_text1.xslt'],
              ##         '../../text/howto/cjkv'),

              Document('demos/4ODS/tutorial/tutorial.doc',
                       ['demos/4ODS/tutorial/tutorial.xsl'],
                       'tutorial.html'),

              ],
    
    gen_cldocs=[CommandLineApp('xml.xslt._4xslt',
                               'XsltCommandLineApp',
                               'docs/html/'),
                CommandLineApp('Ft.Rdf._4rdf',
                               'RdfCommandLineApp',
                               'docs/html/'),
                CommandLineApp('Ft.Ods.Tools._4odb',
                               'OdsCommandLineApp',
                               'docs/html/ods'),
                ],


    bgen_files=['XPath/XPath.bgen',
                'Xslt/XPattern.bgen',
                'XPointer/XPointer.bgen',
                'XPointer/XPtrExpr.bgen',
                'Ods/Parsers/Odl/Odl.bgen',
                'Ods/Parsers/Odl/IfExpr.bgen',
                ],
    verbose=1,
    )
