
import os
DBNAME=os.environ.get("ODS_TEST_DB","ods:test")

from Ft.Ods import Database
from Ft.Ods.MetaData import Operation
from Ft.Ods.MetaData import Parameter
from Ft.Ods.MetaData import Interface
from Ft.Ods.MetaData import Exception
from Ft.Ods.StorageManager import Adapters
from Ft.Ods.StorageManager.Adapters import Constants
import test_metaobject
import test_metadata_util

def Test(tester):

    manager = Adapters.GetManager()
    adapter = Adapters.GetAdapter()
    if manager.exists(DBNAME):
        manager.reinitRepo(DBNAME,adapter)
    else:
        manager.new(DBNAME,adapter)
    
    db = Database.Database()
    db.open(DBNAME)
    try:
        test_metaobject.Test(tester,db,Operation.Operation)


        tester.startGroup("Operation Interface %s Driver" % tester.test_data['driver'])
        tester.startTest("Scope")
        tester.warning("No Scope Support")
        tester.testDone()

        def GetParameter(db,values):
            from Ft.Ods.MetaData import Parameter
            from Ft.Ods.MetaData import Direction
            return Parameter.Parameter(db,None,parameter_mode = Direction.mode_in)
        test_metadata_util.test_form_drop(tester,db,Operation.Operation,'signature',GetParameter,nSided=1)
        test_metadata_util.test_form_drop(tester,db,Operation.Operation,'result',Interface.Interface)
        test_metadata_util.test_form_drop(tester,db,Operation.Operation,'exceptions',Exception.Exception,nSided=1)

        tester.groupDone()
    finally:
        db.close()



