
from Ft.Lib.TestSuite import TestWalker

def PreprocessFiles(tester, dirs, files):
    """
    PreprocessFiles(tester, dirs, files) -> (dirs, files)
    
    This function is responsible for sorting and trimming the
    file and directory lists as needed for proper testing.
    """
    dirs.sort(CompareDirs)

    return (dirs, files)

g_indexes = {'Adapters':0,
             'StorageManager':1,
             'Collections':2,
             'MetaData':3,
             'Parsers':4,
             'Parsers':5,
             }

def CompareDirs(left,right):
    l = g_indexes.get(left,10)
    r = g_indexes.get(right,10)
    return cmp(l,r)




class _OdsMode(TestWalker.TestMode):

    def __init__(self):
        TestWalker.TestMode.__init__(self,self.driverName,self.default)


    def _pre(self, tester):
        from Ft.Ods.StorageManager import Adapters
        from Ft.Ods.StorageManager import GlobalCache
        from Ft.Ods.StorageManager.Adapters import ClassCache

        Adapters.g_driverName = self.driverName
        GlobalCache.GlobalCache().purgeAll()
        ClassCache.ClassCache().purgeAll()
        tester.test_data['driver'] = self.driverName
        return

    def _post(self,tester):
        tester.test_data['driver'] = None
        


class DbmMode(_OdsMode):
    driverName = 'Dbm'
    default = 1


    def _init(self,tester):
        try:
            from Ft.Ods.StorageManager.Adapters import Dbm
        except Exception, error:
            tester.warning("Unable to use mode 'Dbm': %s" % (str(error)))
            return 0
        return 1

class PostgresMode(_OdsMode):
    driverName = 'Postgres'
    default = 0

    def _init(self,tester):
        try:
            from Ft.Ods.StorageManager.Adapters import Postgres
        except Exception, error:
            tester.warning("Unable to use mode 'Postgres': %s" % (str(error)))
            return 0
        return 1

class OracleMode(_OdsMode):
    driverName = 'Oracle'
    default = 0

    def _init(self,tester):
        tester.warning("Unable to use mode 'Oracle'")
        return 0

MODES = [DbmMode(), PostgresMode(), OracleMode()]

