from Xslt import test_harness

sheet_1 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">

  <xsl:template match="customer">
    <wrapper>
    <customer id="{@id}" xmlns="http://spam.com">
      <xsl:element name="{substring-before(., ' ')}" namespace="http://eggs.com">Eggs</xsl:element>
      <name><xsl:value-of select="."/></name>
    </customer>
    </wrapper>
  </xsl:template>

</xsl:stylesheet>
"""

source_1 = """<customer id="uo">Uche Ogbuji</customer>"""

sheet_2 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:output method="html"/>

  <xsl:template match="/">
    <xsl:apply-templates/>
  </xsl:template>

</xsl:stylesheet>
"""

#source_1 = """<noescape>dummy</noescape>"""

expected_1 = """\
<?xml version='1.0' encoding='UTF-8'?>
<wrapper><customer id='uo' xmlns='http://spam.com'><Uche xmlns='http://eggs.com'>Eggs</Uche><name>Uche Ogbuji</name></customer></wrapper>"""


def Test(tester):

    tester.startGroup("Literal elements and text")

    source = test_harness.FileInfo(string=source_1)
    sty = test_harness.FileInfo(string=sheet_1)
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected_1,
                                    )

    xtest.test(tester)
    tester.groupDone()
    return
