############################################################################
#
# File Name: 		Iterator.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/Iterator.py.html
#
"""
Iterator class.
WWW: http://4suite.org/4ODS         e-mail: support@4suite.org

Copyright (c) 1999 Fourthought, Inc., USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

from Ft.Ods import Exception

class Iterator:
    NoMoreElements = Exception.NoMoreElements
    InvalidCollectionType = Exception.InvalidCollectionType
    
    def __init__(self, collection, stable=0):

        from Ft.Ods.Collections import CollectionBase
        from Ft.Ods.Collections import DictionaryBase

        if not isinstance(collection,CollectionBase.CollectionBase) and not isinstance(collection,DictionaryBase.DictionaryBase):
            raise self.InvalidCollectionType()

        if stable:
            self._collection = collection.copy(deep=1)
        else:
            self._collection = collection
        self._index = 0
        self._stable = stable

    def is_stable(self):
        return self._stable

    def at_end(self):
        return len(self._collection) == 0 or (self._collection.cardinality() -1 == self._index)

    def reset(self):
        self._index = 0

    def get_element(self):
        if self._index < self._collection.cardinality():
            return self._collection._4ods_retrieveElementByIndex(self._index)
        raise self.NoMoreElements()

    def next_position(self):
        if not self.at_end():
            self._index = self._index + 1
        else:
            raise self.NoMoreElements()

    def replace_element(self, e):
        #How does this work?
        raise FtodsUnsupportedError(feature="Iterator replace element")

