########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Server/Commands/Recompile.py,v 1.5 2004/10/21 15:06:17 uogbuji Exp $
"""
4Suite repository recompile command (4ss_manager recompile)

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__doc__ = """\
The recompile command will walk the entire repository and 
recompile all stylesheets. It is useful when changes to the underling 
code base require that stylesheets be reinited in the system."""

from Ft.Server.Server.Commands.CommandUtil import GetRepository
from Ft.Server.Common import Schema, ResourceTypes
from Ft.Lib.TestSuite import Tester


def Run(options, args):

    username, password, properties, repo = \
              GetRepository(options, '4ss_manager.start')

    tester = Tester.Tester(useColor=1)

    path = args.get('path', '/')

    commit = 0
    try:
        #Get a list of all of the stylesheets
        m = repo.getModel()
        stys = m.complete(
            None,
            Schema.TYPE,
            Schema.g_rdfResourceTypes[ResourceTypes.ResourceType.XSLT_DOCUMENT])
        stys += m.complete(
            None,
            Schema.TYPE,
            Schema.g_rdfResourceTypes[ResourceTypes.ResourceType.XSLT_DOCUMENT_DEFINITION])
        for sty in stys:
            if not sty.subject.startswith(path):
                continue
            else:
                tester.startTest("Compiling: %s" % repr(sty.subject)[1:])
                try:
                    obj = repo.fetchResource(sty.subject)
                    obj.setContent(obj.getContent())
                except KeyboardInterrupt:
                    raise
                except Exception, e:
                    tester.warning(repr(e))
                tester.testDone()
        commit = 1

    finally:
        if commit:
            repo.txCommit()
        else:
            repo.txRollback()


def Register():
    from Ft.Lib.CommandLine import Command, Options, Arguments
    options = [#Options.Option('n', 'no-daemon',
               #              'Do not detach from the terminal'),
               ]

    cmd = Command.Command(
        'recompile',
        "Recompile all stylesheets",
        '',
        __doc__,
        function=Run,
        fileName=__file__,
        options=Options.Options(options),
        arguments = [
            Arguments.OptionalArgument(
                'path',
                'The root path for the operation.  Only resources within this path will get recompiled.',
                str),
            ],
        )
    return cmd

