<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY f  "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
]>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:cext="http://xmlns.4suite.org/demos/cards"
  xmlns:exslt="http://exslt.org/common"
  xmlns:exslt-str="http://exslt.org/strings"
  xmlns:f="&f;"
  xmlns:fcore="http://xmlns.4suite.org/4ss/score"
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http"
  xmlns:fres="&fres;"
  xmlns:xupdate="http://www.xmldb.org/xupdate"
  extension-element-prefixes="cext exslt exslt-str f fcore fhttp fres"
  exclude-result-prefixes="xupdate"
>

  <!--

    4Suite repository demo application: Cribbage

    Common routines needed by various stylesheets

    Copyright 2004 Fourthought, Inc. (USA)
    http://4suite.org/

  -->

  <xsl:param name="debug"/>

  <xsl:template name='award-points'>
    <xsl:param name='player'/>
    <xsl:param name='amount'/>
    <xsl:param name='message'/>

    <AwardPoints player='{$player}' amount='{$amount}'/>

    <xsl:call-template name='log-message'>
      <xsl:with-param name='player' select='$player'/>
      <xsl:with-param name='message' select='$message'/>
    </xsl:call-template>

  </xsl:template>


  <xsl:template name='log-message'>
    <xsl:param name='player'/>
    <xsl:param name='message'/>
    <Log>
      <xsl:if test='$player'>
        <xsl:attribute name='player'>
          <xsl:value-of select='$player'/>
        </xsl:attribute>
      </xsl:if>
      <xsl:value-of select='$message'/>
    </Log>
  </xsl:template>


  <xsl:template name='play-card'>
    <xsl:param name='player'/>
    <xsl:param name='card'/>
    <xsl:param name='played'/>
    <xsl:param name='cur-count'/>

    <!-- first log it -->
    <xsl:call-template name='log-message'>
      <xsl:with-param name='player' select='$player'/>
      <xsl:with-param name='message' select='concat("plays ",$card/@formal-name)'/>
    </xsl:call-template>

    <xsl:comment>
      <xsl:value-of select='key("players",$player)/name'/><xsl:text> plays </xsl:text><xsl:value-of select='$card/@short-name'/>
    </xsl:comment>

    <!-- then move it -->
    <!-- and update the current count -->
    <!-- and change the current player -->
    <Play player='{$player}'><xsl:copy-of select='$card'/></Play>

    <ChangePlayer player='{number($player = 1) + 1}'/>

    <!--Now see if there are any score increases -->
    <xsl:variable name='count-results'>
      <xsl:call-template name='count-stack'>
        <xsl:with-param name='played' select='$played'/>
        <xsl:with-param name='next-card' select='$card'/>
        <xsl:with-param name='cur-count' select='number($cur-count)'/>
      </xsl:call-template>
    </xsl:variable>

    <xsl:if test='$debug="debug"'>

      <xsl:comment>
      Stack Count Results:
      <xsl:for-each select='exslt:node-set($count-results)/StackCountResults/@*'>
        <xsl:value-of select='local-name()'/>=<xsl:value-of select='.'/>,
      </xsl:for-each>
      Played Cards:
      <xsl:for-each select='exslt:node-set($count-results)/StackCountResults/PlayedCards/Card'>
        <xsl:value-of select='@short-name'/>,
      </xsl:for-each>
      Next Card:
      <xsl:value-of select='exslt:node-set($count-results)/StackCountResults/NextCard/Card/@short-name'/> ,
      <xsl:for-each select='exslt:node-set($count-results)/StackCountResults/*'>
        <xsl:value-of select='local-name()'/>,
      </xsl:for-each>
      </xsl:comment>
    </xsl:if>

    <xsl:apply-templates select='exslt:node-set($count-results)/StackCountResults/*' mode='award-points'>
      <xsl:with-param name='player' select='$player'/>
    </xsl:apply-templates>

  </xsl:template>


  <xsl:template name='make-go'>
    <xsl:param name='player'/>
    <xsl:call-template name='log-message'>
      <xsl:with-param name='player' select='$player'/>
      <xsl:with-param name='message' select='"GO"'/>
    </xsl:call-template>

    <xsl:if test='$debug="debug"'>
      <xsl:comment>
        <xsl:value-of select='key("players",$player)/name'/><xsl:text> has a GO!</xsl:text>
      </xsl:comment>
    </xsl:if>
    <SetGo player='{$player}'/>
    <ChangePlayer player='{number($player = 1) + 1}'/>
  </xsl:template>



</xsl:stylesheet>
