
from Ft.Server.Common import CreationParams, ValidationInfo, DocumentReference, ResourceTypes

import test_helper

from Ft.Xml.Lib import TreeCompare
from Ft import Rdf

def test_create(tester):


    tester.startTest("Create Doc Def")

    repo = test_helper.GetRepo(tester)
    maps = [("$uri",'"NAME"',"//ft:name",Rdf.OBJECT_TYPE_UNKNOWN)]
    nss = {'ft':'foo.com'}
    ddRoot = repo.fetchResource('test')

    cp = CreationParams.CreationParams()
    dd = ddRoot.createXPathDocumentDefinition('def1',nss,maps,cp)

    dMd = dd.getMetaDataResource().getContent()
    dContent = dd.getContent()

    cd,md = test_helper.TestMetaData(tester,
                                     dMd,
                                     'def1',
                                     ResourceTypes.ResourceType.XPATH_DOCUMENT_DEFINITION,
                                     [],
                                     tester.test_data['userName'],
                                     'text/xml',
                                     str(len(dContent)),
                                     [],
                                     docDef = None,
                                     )

    tester.compare(DD1,dContent, func=TreeCompare.TreeCompare)

    test_helper.TestDocumentDefinitionRdf(tester,
                                          repo,
                                          dd.getPath().absolutePath,
                                          len(dContent),
                                          tester.test_data['userName'],
                                          cd,
                                          md,
                                          cp)


    test_helper.CompareNsMap(tester,nss,dd.getNsMap())
    test_helper.CompareRdfMaps(tester,maps,dd.getRdfMaps())
    test_helper.CompareCreationParams(tester,cp,dd.getCreationParams())
    repo.txCommit()


    #Make sure it persisted
    repo = test_helper.GetRepo(tester)
    dd = repo.fetchResource('test/def1')
    test_helper.CompareNsMap(tester,nss,dd.getNsMap())
    test_helper.CompareRdfMaps(tester,maps,dd.getRdfMaps())
    test_helper.CompareCreationParams(tester,cp,dd.getCreationParams())
    repo.txRollback()
    tester.testDone()


    tester.startTest("Create Derived")
    repo = test_helper.GetRepo(tester)
    ddRoot = repo.fetchResource('test')
    maps = [("$uri",'"NAME2"',"//ft:name",Rdf.OBJECT_TYPE_UNKNOWN)]
    nss = {'ft':'foo.com'}
    cp = CreationParams.CreationParams()
    dd1 = ddRoot.fetchResource('def1')

    dd = ddRoot.createXPathDocumentDefinition('def2',nss,maps,cp)
    dd.addBaseDocumentDefinition(dd1)

    dMd = dd.getMetaDataResource().getContent()
    dContent = dd.getContent()

    cd,md = test_helper.TestMetaData(tester,
                                     dMd,
                                     'def2',
                                     ResourceTypes.ResourceType.XPATH_DOCUMENT_DEFINITION,
                                     [],
                                     tester.test_data['userName'],
                                     'text/xml',
                                     str(len(dContent)),
                                     [],
                                     docDef = None,
                                     )

    tester.compare(DD2,dContent,func=TreeCompare.TreeCompare)

    test_helper.TestDocumentDefinitionRdf(tester,
                                          repo,
                                          dd.getPath().absolutePath,
                                          len(dContent),
                                          tester.test_data['userName'],
                                          cd,
                                          md,
                                          cp,
                                          parents=[dd1.getPath().absolutePath]
                                          )

    test_helper.CompareNsMap(tester,nss,dd.getNsMap())
    test_helper.CompareRdfMaps(tester,maps,dd.getRdfMaps())
    test_helper.CompareCreationParams(tester,cp,dd.getCreationParams())
    tester.compare(1,len(dd.getBaseDefinitions()))
    tester.compare(dd1,dd.getBaseDefinitions()[0])
    tester.compare(1,len(dd1.getDerivedDefinitions()))
    tester.compare(dd,dd1.getDerivedDefinitions()[0])
    repo.txCommit()


    #Make sure it persisted
    repo = test_helper.GetRepo(tester)
    ddRoot = repo.fetchResource('test')
    dd = ddRoot.fetchResource('def2')
    dd1 = ddRoot.fetchResource('def1')
    test_helper.CompareNsMap(tester,nss,dd.getNsMap())
    test_helper.CompareRdfMaps(tester,maps,dd.getRdfMaps())
    test_helper.CompareCreationParams(tester,cp,dd.getCreationParams())
    tester.compare(1,len(dd.getBaseDefinitions()))
    tester.compare(dd1,dd.getBaseDefinitions()[0])
    tester.compare(1,len(dd1.getDerivedDefinitions()))
    tester.compare(dd,dd1.getDerivedDefinitions()[0])
    repo.txRollback()
    tester.testDone()





    for (testName,name,cp) in [("Creation Params, Full Text Index",
                                'xml1',
                                CreationParams.CreationParams(1)),
                               ("Creation Params, w/0 Full Text Index",
                                'xml2',
                                CreationParams.CreationParams(0)),
                               ("Creation Params, Enforce Schema",
                                'xml3',
                                CreationParams.CreationParams(enforceSchema = 1)),
                               ("Creation Params, w/0 Enforce Schema",
                                'xml4',
                                CreationParams.CreationParams(enforceSchema = 0)),
                               ("Creation Params, Schematron Validation, String doc ref",
                                'xml5',
                                CreationParams.CreationParams(0,ValidationInfo.SchematronValidationInfo(DocumentReference.StringDocumentReference("A String","Base URI")))),
                               ("Creation Params, Schematron Validation, Internal doc ref",
                                'xml6',
                                CreationParams.CreationParams(0,ValidationInfo.SchematronValidationInfo(DocumentReference.InternalDocumentReference("A URI")))),
                               ("Creation Params, Schematron Validation, External doc ref",
                                'xml7',
                                CreationParams.CreationParams(0,ValidationInfo.SchematronValidationInfo(DocumentReference.ExternalDocumentReference("A URI")))),
                               ("Creation Params, DTD Validation, String doc ref",
                                'xml8',
                                CreationParams.CreationParams(1,ValidationInfo.DtdValidationInfo(DocumentReference.StringDocumentReference("A String","Base URI")))),
                               ("Creation Params, Dtd Validation, Internal doc ref",
                                'xml9',
                                CreationParams.CreationParams(0,ValidationInfo.DtdValidationInfo(DocumentReference.InternalDocumentReference("A URI")))),
                               ("Creation Params, Dtd Validation, External doc ref",
                                'xml10',
                                CreationParams.CreationParams(0,ValidationInfo.DtdValidationInfo(DocumentReference.ExternalDocumentReference("A URI")))),
                               ("Creation Params, w/0 Ext Modules",
                                'xml11',
                                CreationParams.CreationParams(extModules = ['foo'])),
                               ]:

        tester.startTest(testName)
        repo = test_helper.GetRepo(tester)
        ddRoot = repo.fetchResource('test')
        dd = ddRoot.createXPathDocumentDefinition(name,{},[],cp)


        dMd = dd.getMetaDataResource().getContent()
        dContent = dd.getContent()

        cd,md = test_helper.TestMetaData(tester,
                                         dMd,
                                         name,
                                         ResourceTypes.ResourceType.XPATH_DOCUMENT_DEFINITION,
                                         [],
                                         tester.test_data['userName'],
                                         'text/xml',
                                         str(len(dContent)),
                                         [],
                                         docDef = None,
                                         )
        test_helper.TestDocumentDefinitionRdf(tester,
                                              repo,
                                              dd.getPath().absolutePath,
                                              len(dContent),
                                              tester.test_data['userName'],
                                              cd,
                                              md,
                                              cp)

        test_helper.CompareCreationParams(tester,cp,dd.getCreationParams())
        repo.txCommit()

        repo = test_helper.GetRepo(tester)
        dd = repo.fetchResource('test/'+name)
        test_helper.CompareCreationParams(tester,cp,dd.getCreationParams())
        repo.txRollback()
        tester.testDone()




def test_modify(tester):

    tester.startTest("Change Mappings")
    repo = test_helper.GetRepo(tester)
    ddRoot = repo.fetchResource('test')

    maps = [("$uri",'"NAME3"',"//ft:name",Rdf.OBJECT_TYPE_UNKNOWN),
            ("$uri",'"NAME4"',"$uri",Rdf.OBJECT_TYPE_UNKNOWN)]
    nss = {'ft':'foo2.com'}

    dr = DocumentReference.StringDocumentReference("String", "Base")
    vi = ValidationInfo.SchematronValidationInfo(dr)
    cp = CreationParams.CreationParams(0,vi)

    dd = ddRoot.fetchResource('def2')
    dd1 = ddRoot.fetchResource('def1')

    dd.setNsMap(nss)
    dd.setCreationParams(cp)
    dd.setRdfMaps(maps)


    dMd = dd.getMetaDataResource().getContent()
    dContent = dd.getContent()


    cd,md = test_helper.TestMetaData(tester,
                                     dMd,
                                     'def2',
                                     ResourceTypes.ResourceType.XPATH_DOCUMENT_DEFINITION,
                                     [],
                                     tester.test_data['userName'],
                                     'text/xml',
                                     str(len(dContent)),
                                     [],
                                     docDef = None,
                                     )


    tester.compare(DD3,dContent,func=TreeCompare.TreeCompare)

    test_helper.TestDocumentDefinitionRdf(tester,
                                          repo,
                                          dd.getPath().absolutePath,
                                          len(dContent),
                                          tester.test_data['userName'],
                                          cd,
                                          md,
                                          cp,
                                          parents=[dd1.getPath().absolutePath]
                                          )



    test_helper.CompareNsMap(tester,nss,dd.getNsMap())
    test_helper.CompareCreationParams(tester,cp,dd.getCreationParams())
    test_helper.CompareRdfMaps(tester,maps,dd.getRdfMaps())
    repo.txCommit()
    tester.testDone()

    tester.startTest("Load Changed")
    repo = test_helper.GetRepo(tester)
    ddRoot = repo.fetchResource('test')
    dd = ddRoot.fetchResource('def2')

    test_helper.CompareNsMap(tester,nss,dd.getNsMap())
    test_helper.CompareCreationParams(tester,cp,dd.getCreationParams())
    test_helper.CompareRdfMaps(tester,maps,dd.getRdfMaps())
    repo.txRollback()
    tester.testDone()



def test_delete(tester):


    tester.startTest("Delete doc def")
    repo = test_helper.GetRepo(tester)
    ddRoot = repo.fetchResource('test')

    dd = ddRoot.fetchResource('def1')
    dd.delete()
    dd2 = ddRoot.fetchResource('def2')
    tester.compare(0,repo.fetchResource('/test').hasResource('def1'))
    tester.compare(0,len(dd2.getBaseDefinitions()))
    repo.txCommit()
    tester.testDone()

def test_xml_doc_interface(tester):

    tester.startTest("Doc Def XML document interface")

    repo = test_helper.GetRepo(tester)
    ddRoot = repo.fetchResource('test')

    dd = ddRoot.fetchResource('def2')
    dd.getContent()
    dom = dd.asDom()
    tester.compare('DocDef',dom.documentElement.localName)
    repo.txCommit()

    tester.testDone()


    tester.startTest("Modify Content")
    repo = test_helper.GetRepo(tester)
    ddRoot = repo.fetchResource('test')
    dd = ddRoot.fetchResource('def2')
    dd.setContent(DD4)

    tester.compare(DD4,dd.getContent(), func=TreeCompare.TreeCompare)
    nss = {'ft3':'foo3.com'}
    maps = [("$uri",'"NAME3"',"//ft3:name",Rdf.OBJECT_TYPE_UNKNOWN),
            ]
    cp = CreationParams.CreationParams(fullTextIndex = 1,enforceSchema = 1)
    test_helper.CompareNsMap(tester,nss,dd.getNsMap())
    test_helper.CompareRdfMaps(tester,maps,dd.getRdfMaps())
    test_helper.CompareCreationParams(tester,cp,dd.getCreationParams())
    repo.txCommit()


    repo = test_helper.GetRepo(tester)
    ddRoot = repo.fetchResource('test')
    dd = ddRoot.fetchResource('def2')

    tester.compare(DD4,dd.getContent(), func=TreeCompare.TreeCompare)
    nss = {'ft3':'foo3.com'}
    maps = [("$uri",'"NAME3"',"//ft3:name",Rdf.OBJECT_TYPE_UNKNOWN),
            ]
    cp = CreationParams.CreationParams(fullTextIndex = 1,enforceSchema = 1)
    test_helper.CompareNsMap(tester,nss,dd.getNsMap())
    test_helper.CompareRdfMaps(tester,maps,dd.getRdfMaps())
    test_helper.CompareCreationParams(tester,cp,dd.getCreationParams())
    repo.txRollback()


    tester.testDone()



def test_clean(tester):
    repo = test_helper.GetRepo(tester)
    tester.startTest("Remove DTD")
    if repo.hasResource('/test'):
        t = repo.fetchResource('/test')
        t.delete()
    repo.createContainer("/test",1)
    repo.txCommit()
    tester.testDone()

def Test(tester):

    test_clean(tester)
    test_create(tester)
    test_modify(tester)
    test_delete(tester)
    test_xml_doc_interface(tester)
    test_clean(tester)



DD1="""<?xml version='1.0' encoding='UTF-8'?><ftss:DocDef xmlns:ftss='http://xmlns.4suite.org/reserved' xmlns:ft='foo.com'><ftss:BaseNames/><ftss:RdfMappings><ftss:RdfMapping><ftss:Subject>$uri</ftss:Subject><ftss:Predicate>"NAME"</ftss:Predicate><ftss:Object>//ft:name</ftss:Object></ftss:RdfMapping></ftss:RdfMappings><ftss:CreationParams FullTextIndex='0' EnforceSchema='0'><ftss:Validator type='http://schemas.4suite.org/4ss#documentdefinition.no_validation'/></ftss:CreationParams></ftss:DocDef>"""

DD2="""<?xml version='1.0' encoding='UTF-8'?><ftss:DocDef xmlns:xlink='http://www.w3.org/1999/xlink' xmlns:ft='foo.com' xmlns:ftss='http://xmlns.4suite.org/reserved'><ftss:BaseNames><ftss:Base xlink:href='/test/def1' xlink:type='simple' xlink:actuate='onLoad' xlink:show='embed'/></ftss:BaseNames><ftss:RdfMappings><ftss:RdfMapping><ftss:Subject>$uri</ftss:Subject><ftss:Predicate>"NAME2"</ftss:Predicate><ftss:Object>//ft:name</ftss:Object></ftss:RdfMapping></ftss:RdfMappings><ftss:CreationParams FullTextIndex='0' EnforceSchema='0'><ftss:Validator type='http://schemas.4suite.org/4ss#documentdefinition.no_validation'/></ftss:CreationParams></ftss:DocDef>"""

DD3="""<?xml version='1.0' encoding='UTF-8'?><ftss:DocDef xmlns:xlink='http://www.w3.org/1999/xlink' xmlns:ft='foo2.com' xmlns:ftss='http://xmlns.4suite.org/reserved'><ftss:BaseNames><ftss:Base xlink:type='simple' xlink:href='/test/def1' xlink:actuate='onLoad' xlink:show='embed'/></ftss:BaseNames><ftss:CreationParams FullTextIndex='0' EnforceSchema='0'><ftss:Validator type='http://schemas.4suite.org/4ss#documentdefinition.schematron_validation'><ftss:DocumentReference type='STRING' baseUri='Base'>String</ftss:DocumentReference></ftss:Validator></ftss:CreationParams><ftss:RdfMappings><ftss:RdfMapping><ftss:Subject>$uri</ftss:Subject><ftss:Predicate>"NAME3"</ftss:Predicate><ftss:Object>//ft:name</ftss:Object></ftss:RdfMapping><ftss:RdfMapping><ftss:Subject>$uri</ftss:Subject><ftss:Predicate>"NAME4"</ftss:Predicate><ftss:Object>$uri</ftss:Object></ftss:RdfMapping></ftss:RdfMappings></ftss:DocDef>"""


DD4="""<?xml version='1.0' encoding='UTF-8'?>
  <ftss:DocDef xmlns:ftss='http://xmlns.4suite.org/reserved' xmlns:ft3='foo3.com'>
  <ftss:BaseNames/>
  <ftss:RdfMappings>
    <ftss:RdfMapping>
      <ftss:Subject>$uri</ftss:Subject>
      <ftss:Predicate>"NAME3"</ftss:Predicate>
      <ftss:Object>//ft3:name</ftss:Object>
    </ftss:RdfMapping>
  </ftss:RdfMappings>
  <ftss:CreationParams FullTextIndex='1' EnforceSchema='1'>
    <ftss:Validator type='http://schemas.4suite.org/4ss#documentdefinition.no_validation'/>
  </ftss:CreationParams>
</ftss:DocDef>"""

