from Ft.Server.Server.Drivers.FtssDriver import DataStoreContainer
import cPickle as pickle

FTSS_CONTAIMENT_DB_NAME = 'ftss_containment.db'

class BerkeleyDBContainer(DataStoreContainer):
    """
    Implements simple containment as a 'parent' -> [child1,child2,childn] key/value Berkeley Database
    """
    def __init__(self):
        pass
    
    def initialize(self):
        pass
    
    def fetchChildren(self, parent):
        """
        Returns a list of child uris for the given parent.  Parent is a PathImp
        """
        #print self._dBs
        txn, db = self._dBs[FTSS_CONTAIMENT_DB_NAME]
        children = db.get(str(parent.absolutePath), None, txn=txn)
        children = children and pickle.loads(children) or []
        #print "children of %s: %s"%(parent.absolutePath,children)
        return children
        
    def manageChildren(self, parent, child, add=True):
        """
        Adds/remove the child specified by the given path to the parent (path - a PathImp)
        
        """
        txn, db = self._dBs[FTSS_CONTAIMENT_DB_NAME]
        parentPath = str(parent.absolutePath)
        children = db.get(parentPath, None, txn=txn)
        children = children and pickle.loads(children) or []
        if add:
            children.append(child)
        else:            
            children.remove(child)
        db.put(parentPath, pickle.dumps(children, 1), txn=txn)

    
