########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Server/Http/Soap/__init__.py,v 1.3 2005/04/06 06:19:15 mbrown Exp $
"""
SOAP module

Copyright 2005 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

import os

from Ft.Server import SCHEMA_NSS
from Ft.Server.Common import Schema
from Ft.Server.Server import FTSERVER_SERVER_NS, Module

import Handler


class SoapModule(Module):

    commands = {
        (FTSERVER_SERVER_NS, 'DocumentRoot'): 'setDocumentRoot',
        (FTSERVER_SERVER_NS, 'AuthName'): 'setAuthName',
        }

    handlers = {'basic_soap' : Handler.SoapHandler}

    def setDocumentRoot(self, parser, config, name, data, attrs):
        if not data:
            raise ValueError('%s requires path argument' % name)

        if data[0] != '/':
            raise ValueError('%s path must be absolute' % name)

        # Normalize it, borrowed mostly from posixpath.normpath()
        steps = []
        comps = data.split('/')
        for comp in comps:
            if comp in ('', '.'):
                # Either a duplicate slash ('') or a do nothing step
                continue
            if comp != '..':
                steps.append(comp)
            elif steps:
                # A dot-dot, remove previous path
                steps.pop()
        path = '/'.join(steps)
        if path:
            config.documentRoot = '/' + path
        else:
            config.documentRoot = ''
        return


    def setAuthName(self, parser, config, name, data, attrs):
        config.authName = data
        return


