#!/usr/bin/env python
import os, sys
from Ft.Server.Server import GlobalConfig, Controller

def GetConfig():
    from Ft import GetConfigVar
    if not os.environ.has_key('FTSS_ENVIRONMENT'):
        # We're running directly from the commandline
        import getpass, sha
        print '*** Running in debug mode ***'
        username = raw_input("4SS Manager Name: ")
        password = getpass.getpass("Password for %s: " % username)
        password = sha.new(password).hexdigest()
        core = os.environ.get('FTSS_CORE_ID', 'Core')
        debug = 1
    else:
        username, password, core = eval(os.environ['FTSS_ENVIRONMENT'])
        del os.environ['FTSS_ENVIRONMENT']
        debug = 0
    filename = os.environ.get('FTSERVER_CONFIG_FILE',
                              os.path.join(GetConfigVar('SYSCONFDIR'),
                                           '4ss.conf'))
    return GlobalConfig.GlobalConfig(username, password, core, filename, debug)

if __name__ == '__main__':
    config = GetConfig()
    controller = Controller.Controller(config)
    status = controller.run()
    sys.exit(status)

