<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY nbsp "&#160;">
  <!ENTITY rdf "http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <!ENTITY rdfs "http://www.w3.org/2000/01/rdf-schema#">
  <!ENTITY f "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
  <!ENTITY dc "http://purl.org/dc/elements/1.1/">
  <!ENTITY fschema "http://schemas.4suite.org/4ss#">
]>
<xsl:stylesheet 
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
  xmlns:fcore="http://xmlns.4suite.org/4ss/score" 
  xmlns:frdf="http://xmlns.4suite.org/4ss/rdf" 
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http" 
  xmlns:exslt="http://exslt.org/common" 
  xmlns:exslt-string="http://exslt.org/strings" 
  xmlns:exslt-set="http://exslt.org/sets" 
  xmlns:exslt-math="http://exslt.org/math" 
  xmlns:exslt-functions="http://exslt.org/functions" 
  xmlns:exslt-date-time="http://exslt.org/dates-and-times" 
  xmlns:str="http://exslt.org/strings"
  xmlns:date ="http://exslt.org/dates-and-times"
  xmlns:dc="&dc;"
  xmlns:fres="&fres;" 
  xmlns:rdf="&rdf;" 
  xmlns:f="&f;" 
  xmlns:fschema="&fschema;" 
  xmlns:db="http://chimezie.ogbuji.net/4ss/tools/dashboard/schema#"
  xmlns:query="http://metacognition.info/extensions/remote-query.dd#"
  extension-element-prefixes="query f frdf fhttp fcore exslt exslt-set exslt-math exslt-functions exslt-date-time">
  <xsl:output method="html" indent="yes" encoding="utf-8"/>
  <xsl:param name="fres:absolute-path"/>
  <xsl:param name="action"/>
  <xsl:param name="scope"/>
  <xsl:param name="remoteGraph"/>  
  <xsl:param name="subject"/>
  <xsl:param name="versa-query"/>
  <xsl:param name="queryType"/>
  <xsl:variable name="selected-subjects" select="fhttp:get-query-args()//*[starts-with(name(),'mark-subject')]/."/>
  <xsl:variable name="selected-objects" select="fhttp:get-query-args()//*[starts-with(name(),'mark-object')]/."/>
  <xsl:variable name="selected-predicates" select="fhttp:get-query-args()//*[starts-with(name(),'mark-predicate')]/."/>
  <xsl:variable name="selected-literals" select="fhttp:get-query-args()//*[contains(name(),'mark-literal')]/."/>
  <xsl:variable name="nsMappingDocPath" select="'/ftss/dashboard/NsMappings.xml'"/>
  <xsl:template name="create-versa-list">
    <xsl:param name="string-list"/>
    <xsl:message><xsl:value-of select="f:serialize-xml($string-list)"/></xsl:message>
    <xsl:text>list(</xsl:text>
    <xsl:for-each select="$string-list//text()">
      <xsl:variable name="currentItem" select="."/>
      <xsl:if test="not(position() = 1)">
        <xsl:text>,</xsl:text>
      </xsl:if>
      <xsl:choose>
        <xsl:when test="document($nsMappingDocPath)//fres:NsMapping[Prefix = substring-before($currentItem,':')]">
          <xsl:value-of select="."/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>'</xsl:text>
          <xsl:value-of select="."/>
          <xsl:text>'</xsl:text>          
        </xsl:otherwise>
      </xsl:choose>      
    </xsl:for-each>
    <xsl:text>)</xsl:text>
  </xsl:template>
  <xsl:template match="/">
    <xsl:choose>
      <xsl:when test="$action = 'renderNsMappings'">
        <html>
          <head>
            <title>4Suite Repository Query</title>
            <style type="text/css">
              <xsl:comment>
                * {
                margin:0;
                padding:0;
                }                
              </xsl:comment>
            </style>
          </head>
          <body bgcolor="#FFFFFF" text="#000000">
            <xsl:for-each select=".">
              
            </xsl:for-each>
          </body>
        </html>
      </xsl:when>
      <xsl:otherwise>
        <xsl:variable name="default-mappings-rtf">
          <fres:NsMapping>
            <Prefix>vcard</Prefix>
            <Uri>http://4suite.org/nexus/rdfs/vcard#</Uri>
          </fres:NsMapping>
        </xsl:variable>
        <xsl:variable name="default-mappings" select="exslt:node-set($default-mappings-rtf)"/>
        <xsl:variable name="selected-subjects-expression">
          <xsl:call-template name="create-versa-list">
            <xsl:with-param name="string-list" select="$selected-subjects"/>
          </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="selected-predicates-expression">
          <xsl:call-template name="create-versa-list">
            <xsl:with-param name="string-list" select="$selected-predicates"/>
          </xsl:call-template>
        </xsl:variable>
        
        <xsl:variable name="selected-objects-expression">
          <xsl:call-template name="create-versa-list">
            <xsl:with-param name="string-list" select="$selected-objects"/>
          </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="selected-literals-expression">
          <xsl:call-template name="create-versa-list">
            <xsl:with-param name="string-list" select="$selected-literals"/>
          </xsl:call-template>
        </xsl:variable>    
        <xsl:variable name="replacedSubjects">
          <xsl:value-of select="f:replace('$subjects',string($selected-subjects-expression),string($versa-query))"/>
        </xsl:variable>
        <xsl:variable name="replacedPredicates">
          <xsl:value-of select="f:replace('$predicates',string($selected-predicates-expression),$replacedSubjects)"/>
        </xsl:variable>
        <xsl:variable name="replacedLiterals">
          <xsl:if test="normalize-space($versa-query)">
            <xsl:value-of select="f:replace('$literals',string($selected-literals-expression),$replacedPredicates)"/>
          </xsl:if>
        </xsl:variable>    
        <xsl:variable name="replacedObjects">
          <xsl:if test="normalize-space($versa-query)">
            <xsl:value-of select="f:replace('$objects',string($selected-objects-expression),$replacedLiterals)"/>
          </xsl:if>
        </xsl:variable>
        
        <xsl:variable name="rt-format">
          <xsl:choose>
            <xsl:when test="$queryType = 'Triple'">triples</xsl:when>
            <xsl:otherwise>versa</xsl:otherwise>
          </xsl:choose>      
        </xsl:variable>
        <xsl:variable name="query-result-rtf">
          <xsl:if test="normalize-space($versa-query) and ($queryType = 'Triple' or $queryType = 'Raw')">
            <query:query remote-graph="{$remoteGraph}" query="{$replacedObjects}" scope="{$scope}" result-format="{$rt-format}">
              <xsl:copy-of select="document('/ftss/dashboard/NsMappings.xml')"/>
            </query:query>
          </xsl:if>
        </xsl:variable>
        <xsl:variable name="query-result" select="exslt:node-set($query-result-rtf)"/>
        <html>
          <head>
            <title>4Suite Repository Query</title>
            <style type="text/css">
              <xsl:comment>
                .TitleBar {  font-family: "Times New Roman", Times, serif; font-style: italic; color: #000000; font-weight: bold; background-color: #CCCCCC}
                .formHeader {text-align: right;vertical-align: top;font-style: italic;font-weight: normal}            
              </xsl:comment>
            </style>
          </head>
          <body bgcolor="#FFFFFF" text="#000000">
            <form method="post" action="/?xslt=/Triclops/Triclops.xslt">
              <table border="0" align="center" style="width: 100%;">
                <xsl:call-template name="top-query-form"/>
                <xsl:call-template name="bottom-query-form"/>
                <xsl:call-template name="search-results"/>
              </table>
            </form>
          </body>
        </html>        
      </xsl:otherwise>
    </xsl:choose>
    
  </xsl:template>
  <xsl:template name="top-query-form">
    <tr>
      <td colspan="2" class="TitleBar">
        <div align="center">4Suite Repository Triclops Query</div>
      </td>
    </tr>
    <tr>
      <th class="formHeader">Versa Query</th>
      <td>
        <div align="left">
          <textarea cols="80" rows="10" name="versa-query">
            <xsl:value-of select="$replacedObjects" disable-output-escaping="yes"/>
          </textarea>
        </div>
      </td>
    </tr>
    <tr>
      <th class="formHeader">Remote RDF Graph: </th>
      <td>
        <div align="left">
          <input name="remoteGraph" value="{$remoteGraph}" size="30"/>
        </div>
      </td>
    </tr>    
    <tr>
      <th class="formHeader"><a  href="http://uche.ogbuji.net/tech/akara/nodes/2003-01-01/scopes" target="_blank">Scope</a>: </th>
      <td>
        <div align="left">
          <input name="scope" value="{$scope}" size="30"/>
        </div>
      </td>
    </tr>
    <tr>
      <td colspan="2">
        <hr/>
      </td>
    </tr>
  </xsl:template>
  <xsl:template name="search-results">
    <tr>
      <td class="titleBar" colspan="2">
        <div align="left"> Results</div>
      </td>
    </tr>
    <xsl:choose>
      <xsl:when test="$queryType = 'SVG'">
        <!--Graph of results-->
        <tr>
          <td colspan="2">
            <xsl:call-template name="process-svg-query"/>
          </td>
        </tr>
      </xsl:when>
      <xsl:when test="$queryType = 'Graph'">
        <!--Graph of results-->
        <tr>
          <td colspan="2">
            <xsl:call-template name="process-graph-query"/>
          </td>
        </tr>
      </xsl:when>
      <xsl:when test="$queryType = 'Raw'">
        <!--Raw dump of results-->
        <tr>
          <td colspan="2">
            <xsl:call-template name="process-raw-query"/>
          </td>
        </tr>
      </xsl:when>
      <xsl:otherwise>
        <!--Triple view of results-->
        <tr>
          <td colspan="2">
            <xsl:call-template name="process-triple-query"/>
          </td>
        </tr>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="bottom-query-form">
    <tr>
      <td class="titleBar" colspan="2">
        <div align="left">
          <input type="submit" name="Submit" value="Execute Metadata Query"/>
          <input type="reset" name="Submit2" value="Reset"/>
          <select name="queryType">
            <xsl:element name="option">
              <xsl:if test="$queryType = 'Raw'">
                <xsl:attribute name="selected">on</xsl:attribute>
              </xsl:if>
              <xsl:attribute name="value">Raw</xsl:attribute>
              <xsl:text>Raw Versa Results</xsl:text>
            </xsl:element>
            <xsl:element name="option">
              <xsl:if test="$queryType = 'SVG'">
                <xsl:attribute name="selected">on</xsl:attribute>
              </xsl:if>
              <xsl:attribute name="value">SVG</xsl:attribute>
              <xsl:text>RDF Graph (SVG)</xsl:text>
            </xsl:element>
            <xsl:element name="option">
              <xsl:if test="$queryType = 'Graph'">
                <xsl:attribute name="selected">on</xsl:attribute>
              </xsl:if>
              <xsl:attribute name="value">Graph</xsl:attribute>
              <xsl:text>RDF Graph (Jpeg)</xsl:text>
            </xsl:element>
            <xsl:element name="option">
              <xsl:if test="$queryType = 'Triple'">
                <xsl:attribute name="selected">on</xsl:attribute>
              </xsl:if>
              <xsl:attribute name="value">Triple</xsl:attribute>
              <xsl:text>Results as Triples</xsl:text>
            </xsl:element>
          </select>
        </div>
      </td>
    </tr>
  </xsl:template>
  <!--Query processing templates-->
  <xsl:template match="Resource | BlankNode" mode="html-render">
    <xsl:variable name="uri" select="text()"/>
    <li>
      <span style="font-size: 0.85em">
        <xsl:choose>
          <xsl:when test="document('/ftss/dashboard/NsMappings.xml')//fres:NsMapping[Prefix = substring-before($uri,':')]">
            <xsl:value-of select="$uri"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="concat('&lt;',text(),'&gt;')"/>
          </xsl:otherwise>
        </xsl:choose>
      </span>
    </li>
  </xsl:template>  
  <xsl:template match="String" mode="html-render">    
    <li>
      <xsl:value-of select="concat('&quot;',text(),'&quot;')"/>
    </li>
  </xsl:template>  
  <xsl:template match="Number | Boolean" mode="html-render">
    <li><xsl:value-of select="."/></li>
  </xsl:template>  
  <xsl:template match="List" mode="html-render">
    <xsl:if test="ancestor::List | ancestor::Set">List:</xsl:if>
    <ol>
      <xsl:for-each select="*">
        <li><xsl:apply-templates select="." mode="html-render"/></li>
      </xsl:for-each>      
    </ol>
  </xsl:template>
  <xsl:template match="Set" mode="html-render">
    <xsl:if test="ancestor::List | ancestor::Set">Set:</xsl:if>
    <ul>
      <xsl:for-each select="*">
        <li><xsl:apply-templates select="." mode="html-render"/></li>
      </xsl:for-each>      
    </ul>
  </xsl:template>  
  <xsl:template match="Number | Boolean" mode="html-render">
    <li><xsl:value-of select="."/></li>
  </xsl:template>  
  
  
  
  <xsl:template name="process-raw-query">
    <div style="text-align: left;">
      <xsl:apply-templates mode="html-render" select="$query-result"/>
    </div>
  </xsl:template>
  <xsl:template name="process-svg-query">
    <xsl:if test="$query-result">
      <query:graph 
        query="{$replacedObjects}"
        scope="{$scope}"
        remote-graph="{$remoteGraph}"
        graph-vis="{document('/ftss/dashboard/DashboardConfig.xml')/DashboardConfig/gvisExec}" 
        output-path="/ftss/dashboard/output.svg" 
        svg="yes" 
        map-name="imageMap" 
        uri-format="/?xslt=/Triclops/Triclops.xslt&amp;versa-query=@'%s'&amp;queryType=SVG&amp;remoteGraph={$remoteGraph}&amp;scope={$scope}" 
        max-arcs="{document('/ftss/dashboard/DashboardConfig.xml')/DashboardConfig/MaxGraphArcs}" 
        namespaces="/ftss/dashboard/"/>        
    </xsl:if>
  </xsl:template>
  <xsl:template name="process-graph-query">
    <xsl:if test="$query-result">
      <img src='/ftss/dashboard/output.jpg?now={date:date-time()}"' usemap="#imageMap" border="1"/>
      <query:graph 
        query="{$replacedObjects}"
        scope="{$scope}"
        remote-graph="{$remoteGraph}"
        graph-vis="{document('/ftss/dashboard/DashboardConfig.xml')/DashboardConfig/gvisExec}" 
        output-path="/ftss/dashboard/output.jpg" 
        map-name="imageMap" 
        uri-format="/?xslt=/Triclops/Triclops.xslt&amp;versa-query=@'%s'&amp;queryType=SVG&amp;remoteGraph={$remoteGraph}&amp;scope={$scope}" 
        max-arcs="{document('/ftss/dashboard/DashboardConfig.xml')/DashboardConfig/MaxGraphArcs}" />        
    </xsl:if>
  </xsl:template>
  <xsl:template name="process-triple-query">
    <table border="1">
      <xsl:apply-templates select="$query-result" mode="triple-grid"/>
    </table>
  </xsl:template>
  <xsl:template match="Resource" mode="triple-grid">
    <xsl:variable name="subject" select="@uri"/>
    <xsl:variable name="consequent-query">
      <xsl:choose>
        <xsl:when test="document('/ftss/dashboard/NsMappings.xml')//fres:NsMapping[Prefix = substring-before($subject,':')]">
          <xsl:value-of select="$subject"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="str:encode-uri(concat('resource(&quot;',$subject,'&quot;)'),true())"/>
        </xsl:otherwise>
      </xsl:choose>      
    </xsl:variable>
    <xsl:for-each select="Predicate">
      <xsl:variable name="predicate" select="@uri"/>
      <tr>
        <th>
          <i>Statement</i>
        </th>
        <xsl:choose>
          <xsl:when test="position() = 1">
            <td>
              <input type="checkbox" name="mark-subject{position()}" value="{$subject}"/>              
              <a href='/?xslt=/Triclops/Triclops.xslt&amp;versa-query={$consequent-query}&amp;queryType=Triple&amp;remoteGraph={$remoteGraph}&amp;scope={$scope}'>
                <xsl:value-of select="$subject"/>
              </a>
            </td>
          </xsl:when>
          <xsl:otherwise><td/></xsl:otherwise>
        </xsl:choose>
        <td>
          <input type="checkbox" name="mark-predicate{position()}" value="{.}"/>
          <xsl:value-of select="$predicate"/>
        </td>
        <td>
          <input type="checkbox" name="mark-object{position()}" value="{Object}"/>
          <xsl:choose>
            <xsl:when test="string-length(./Object) > 200">
              <font size="-1">
                <xsl:value-of select="Object"/>
              </font>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="Object"/>
            </xsl:otherwise>
          </xsl:choose>
        </td>
      </tr>      
    </xsl:for-each>
  </xsl:template>
  <xsl:template match="Literal" mode="triple-grid">
    <tr>
      <th>
        <i>Literal</i>
      </th>
      <td></td>
      <td colspan="2">
        <input type="checkbox" name="mark-literal{position()}" value="{.}"/><xsl:value-of select="."/>
      </td>
    </tr>
  </xsl:template>
</xsl:stylesheet>
