# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class IotHubProperties(Model):
    """The Iot Hub properties.

    :param authorization_policies: The authorization rules.
    :type authorization_policies: list of
     :class:`SharedAccessSignatureAuthorizationRule
     <azure.mgmt.iothub.models.SharedAccessSignatureAuthorizationRule>`
    :param host_name: The name of the host.
    :type host_name: str
    :param event_hub_endpoints: The event hub endpoint properties.
    :type event_hub_endpoints: dict
    :param storage_endpoints: The list of storage end points where files can
     be uploaded. Currently only one storage account can be configured.
    :type storage_endpoints: dict
    :param messaging_endpoints: The list of messaging end points configured.
    :type messaging_endpoints: dict
    :param enable_file_upload_notifications: The flag which indicates whether
     file upload notification should be enabled. This is optional at iot hub
     level. When enabled upload notifications will be available.
    :type enable_file_upload_notifications: bool
    :param cloud_to_device:
    :type cloud_to_device: :class:`CloudToDeviceProperties
     <azure.mgmt.iothub.models.CloudToDeviceProperties>`
    :param comments: The comments.
    :type comments: str
    :param operations_monitoring_properties:
    :type operations_monitoring_properties:
     :class:`OperationsMonitoringProperties
     <azure.mgmt.iothub.models.OperationsMonitoringProperties>`
    :param features: The Capabilities/Features that need to be enabled for
     the Hub. Possible values include: 'None', 'DeviceManagement'
    :type features: str or :class:`Capabilities
     <azure.mgmt.iothub.models.Capabilities>`
    """ 

    _attribute_map = {
        'authorization_policies': {'key': 'authorizationPolicies', 'type': '[SharedAccessSignatureAuthorizationRule]'},
        'host_name': {'key': 'hostName', 'type': 'str'},
        'event_hub_endpoints': {'key': 'eventHubEndpoints', 'type': '{EventHubProperties}'},
        'storage_endpoints': {'key': 'storageEndpoints', 'type': '{StorageEndpointProperties}'},
        'messaging_endpoints': {'key': 'messagingEndpoints', 'type': '{MessagingEndpointProperties}'},
        'enable_file_upload_notifications': {'key': 'enableFileUploadNotifications', 'type': 'bool'},
        'cloud_to_device': {'key': 'cloudToDevice', 'type': 'CloudToDeviceProperties'},
        'comments': {'key': 'comments', 'type': 'str'},
        'operations_monitoring_properties': {'key': 'operationsMonitoringProperties', 'type': 'OperationsMonitoringProperties'},
        'features': {'key': 'features', 'type': 'str'},
    }

    def __init__(self, authorization_policies=None, host_name=None, event_hub_endpoints=None, storage_endpoints=None, messaging_endpoints=None, enable_file_upload_notifications=None, cloud_to_device=None, comments=None, operations_monitoring_properties=None, features=None):
        self.authorization_policies = authorization_policies
        self.host_name = host_name
        self.event_hub_endpoints = event_hub_endpoints
        self.storage_endpoints = storage_endpoints
        self.messaging_endpoints = messaging_endpoints
        self.enable_file_upload_notifications = enable_file_upload_notifications
        self.cloud_to_device = cloud_to_device
        self.comments = comments
        self.operations_monitoring_properties = operations_monitoring_properties
        self.features = features
