# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class IotHubSkuInfo(Model):
    """The Sku related information for the hub.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param name: The name of the Sku. Possible values include: 'F1', 'S1',
     'S2', 'S3'
    :type name: str or :class:`IotHubSku <azure.mgmt.iothub.models.IotHubSku>`
    :ivar tier: The tier. Possible values include: 'Free', 'Standard'
    :vartype tier: str or :class:`IotHubSkuTier
     <azure.mgmt.iothub.models.IotHubSkuTier>`
    :param capacity: The number of units being provisioned. Range of values
     [For F1: 1-1, S1: 1-200, S2: 1-200, S3: 1-10]. To go above this range,
     call support.
    :type capacity: long
    """ 

    _validation = {
        'tier': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'IotHubSkuTier'},
        'capacity': {'key': 'capacity', 'type': 'long'},
    }

    def __init__(self, name=None, capacity=None):
        self.name = name
        self.tier = None
        self.capacity = capacity
