# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class DeepCreatedOrigin(Model):
    """The main origin of CDN content which is added when creating a CDN endpoint.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Origin name
    :type name: str
    :param host_name: Required. The address of the origin. It can be a domain
     name, IPv4 address, or IPv6 address.
    :type host_name: str
    :param http_port: The value of the HTTP port. Must be between 1 and 65535
    :type http_port: int
    :param https_port: The value of the HTTPS port. Must be between 1 and
     65535
    :type https_port: int
    """

    _validation = {
        'name': {'required': True},
        'host_name': {'required': True},
        'http_port': {'maximum': 65535, 'minimum': 1},
        'https_port': {'maximum': 65535, 'minimum': 1},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'http_port': {'key': 'properties.httpPort', 'type': 'int'},
        'https_port': {'key': 'properties.httpsPort', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(DeepCreatedOrigin, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.host_name = kwargs.get('host_name', None)
        self.http_port = kwargs.get('http_port', None)
        self.https_port = kwargs.get('https_port', None)
