# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class BuildTaskUpdateParameters(Model):
    """The parameters for updating a build task.

    :param alias: The alternative updatable name for a build task.
    :type alias: str
    :param status: The current status of build task. Possible values include:
     'Disabled', 'Enabled'
    :type status: str or
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.BuildTaskStatus
    :param platform: The platform properties against which the build has to
     happen.
    :type platform:
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.PlatformProperties
    :param timeout: Build timeout in seconds.
    :type timeout: int
    :param source_repository: The properties that describes the source(code)
     for the build task.
    :type source_repository:
     ~azure.mgmt.containerregistry.v2018_02_01_preview.models.SourceRepositoryUpdateParameters
    :param tags: The ARM resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'timeout': {'maximum': 28800, 'minimum': 300},
    }

    _attribute_map = {
        'alias': {'key': 'properties.alias', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'platform': {'key': 'properties.platform', 'type': 'PlatformProperties'},
        'timeout': {'key': 'properties.timeout', 'type': 'int'},
        'source_repository': {'key': 'properties.sourceRepository', 'type': 'SourceRepositoryUpdateParameters'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(BuildTaskUpdateParameters, self).__init__(**kwargs)
        self.alias = kwargs.get('alias', None)
        self.status = kwargs.get('status', None)
        self.platform = kwargs.get('platform', None)
        self.timeout = kwargs.get('timeout', None)
        self.source_repository = kwargs.get('source_repository', None)
        self.tags = kwargs.get('tags', None)
