# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class MigrateSyncCompleteCommandInput(Model):
    """Input for command that completes sync migration for a database.

    All required parameters must be populated in order to send to Azure.

    :param database_name: Required. Name of database
    :type database_name: str
    :param commit_time_stamp: Time stamp to complete
    :type commit_time_stamp: datetime
    """

    _validation = {
        'database_name': {'required': True},
    }

    _attribute_map = {
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'commit_time_stamp': {'key': 'commitTimeStamp', 'type': 'iso-8601'},
    }

    def __init__(self, *, database_name: str, commit_time_stamp=None, **kwargs) -> None:
        super(MigrateSyncCompleteCommandInput, self).__init__(**kwargs)
        self.database_name = database_name
        self.commit_time_stamp = commit_time_stamp
