# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_resource import ProxyResource


class AssetFilter(ProxyResource):
    """An Asset Filter.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource ID for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param presentation_time_range: The presentation time range.
    :type presentation_time_range:
     ~azure.mgmt.media.models.PresentationTimeRange
    :param first_quality: The first quality.
    :type first_quality: ~azure.mgmt.media.models.FirstQuality
    :param tracks: The tracks selection conditions.
    :type tracks: list[~azure.mgmt.media.models.FilterTrackSelection]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'presentation_time_range': {'key': 'properties.presentationTimeRange', 'type': 'PresentationTimeRange'},
        'first_quality': {'key': 'properties.firstQuality', 'type': 'FirstQuality'},
        'tracks': {'key': 'properties.tracks', 'type': '[FilterTrackSelection]'},
    }

    def __init__(self, **kwargs):
        super(AssetFilter, self).__init__(**kwargs)
        self.presentation_time_range = kwargs.get('presentation_time_range', None)
        self.first_quality = kwargs.get('first_quality', None)
        self.tracks = kwargs.get('tracks', None)
