# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction(Model):
    """Configures the Explicit Analog Television Output Restriction control bits.
    For further details see the PlayReady Compliance Rules.

    All required parameters must be populated in order to send to Azure.

    :param best_effort: Required. Indicates whether this restriction is
     enforced on a Best Effort basis.
    :type best_effort: bool
    :param configuration_data: Required. Configures the restriction control
     bits. Must be between 0 and 3 inclusive.
    :type configuration_data: int
    """

    _validation = {
        'best_effort': {'required': True},
        'configuration_data': {'required': True},
    }

    _attribute_map = {
        'best_effort': {'key': 'bestEffort', 'type': 'bool'},
        'configuration_data': {'key': 'configurationData', 'type': 'int'},
    }

    def __init__(self, *, best_effort: bool, configuration_data: int, **kwargs) -> None:
        super(ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction, self).__init__(**kwargs)
        self.best_effort = best_effort
        self.configuration_data = configuration_data
