# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .backup_request import BackupRequest


class AzureWorkloadBackupRequest(BackupRequest):
    """AzureWorkload workload-specific backup request.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param backup_type: Type of backup, viz. Full, Differential, Log or
     CopyOnlyFull. Possible values include: 'Invalid', 'Full', 'Differential',
     'Log', 'CopyOnlyFull'
    :type backup_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.BackupType
    :param enable_compression: Bool for Compression setting
    :type enable_compression: bool
    :param recovery_point_expiry_time_in_utc: Backup copy will expire after
     the time specified (UTC).
    :type recovery_point_expiry_time_in_utc: datetime
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'backup_type': {'key': 'backupType', 'type': 'str'},
        'enable_compression': {'key': 'enableCompression', 'type': 'bool'},
        'recovery_point_expiry_time_in_utc': {'key': 'recoveryPointExpiryTimeInUTC', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(AzureWorkloadBackupRequest, self).__init__(**kwargs)
        self.backup_type = kwargs.get('backup_type', None)
        self.enable_compression = kwargs.get('enable_compression', None)
        self.recovery_point_expiry_time_in_utc = kwargs.get('recovery_point_expiry_time_in_utc', None)
        self.object_type = 'AzureWorkloadBackupRequest'
