# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ReservationResponse(Model):
    """ReservationResponse.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar location: The Azure Region where the reserved resource lives.
    :vartype location: str
    :param etag:
    :type etag: int
    :ivar id: Identifier of the reservation
    :vartype id: str
    :ivar name: Name of the reservation
    :vartype name: str
    :param sku:
    :type sku: ~azure.mgmt.reservations.models.SkuName
    :param properties:
    :type properties: ~azure.mgmt.reservations.models.ReservationProperties
    :ivar type: Type of resource.
     "Microsoft.Capacity/reservationOrders/reservations"
    :vartype type: str
    """

    _validation = {
        'location': {'readonly': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'int'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'SkuName'},
        'properties': {'key': 'properties', 'type': 'ReservationProperties'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ReservationResponse, self).__init__(**kwargs)
        self.location = None
        self.etag = kwargs.get('etag', None)
        self.id = None
        self.name = None
        self.sku = kwargs.get('sku', None)
        self.properties = kwargs.get('properties', None)
        self.type = None
