# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_only_resource_py3 import ProxyOnlyResource


class DetectorResponse(ProxyOnlyResource):
    """Class representing Response from Detector.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param metadata: metadata for the detector
    :type metadata: ~azure.mgmt.web.models.DetectorInfo
    :param dataset: Data Set
    :type dataset: list[~azure.mgmt.web.models.DiagnosticData]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'metadata': {'key': 'properties.metadata', 'type': 'DetectorInfo'},
        'dataset': {'key': 'properties.dataset', 'type': '[DiagnosticData]'},
    }

    def __init__(self, *, kind: str=None, metadata=None, dataset=None, **kwargs) -> None:
        super(DetectorResponse, self).__init__(kind=kind, **kwargs)
        self.metadata = metadata
        self.dataset = dataset
