# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Optional, TYPE_CHECKING

from azure.mgmt.core import AsyncARMPipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential

from ._configuration import PeeringManagementClientConfiguration
from .operations import CdnPeeringPrefixesOperations
from .operations import PeeringManagementClientOperationsMixin
from .operations import LegacyPeeringsOperations
from .operations import Operations
from .operations import PeerAsnsOperations
from .operations import PeeringLocationsOperations
from .operations import RegisteredAsnsOperations
from .operations import RegisteredPrefixesOperations
from .operations import PeeringsOperations
from .operations import ReceivedRoutesOperations
from .operations import PeeringServiceCountriesOperations
from .operations import PeeringServiceLocationsOperations
from .operations import PrefixesOperations
from .operations import PeeringServiceProvidersOperations
from .operations import PeeringServicesOperations
from .. import models


class PeeringManagementClient(PeeringManagementClientOperationsMixin):
    """Peering Client.

    :ivar cdn_peering_prefixes: CdnPeeringPrefixesOperations operations
    :vartype cdn_peering_prefixes: azure.mgmt.peering.aio.operations.CdnPeeringPrefixesOperations
    :ivar legacy_peerings: LegacyPeeringsOperations operations
    :vartype legacy_peerings: azure.mgmt.peering.aio.operations.LegacyPeeringsOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.peering.aio.operations.Operations
    :ivar peer_asns: PeerAsnsOperations operations
    :vartype peer_asns: azure.mgmt.peering.aio.operations.PeerAsnsOperations
    :ivar peering_locations: PeeringLocationsOperations operations
    :vartype peering_locations: azure.mgmt.peering.aio.operations.PeeringLocationsOperations
    :ivar registered_asns: RegisteredAsnsOperations operations
    :vartype registered_asns: azure.mgmt.peering.aio.operations.RegisteredAsnsOperations
    :ivar registered_prefixes: RegisteredPrefixesOperations operations
    :vartype registered_prefixes: azure.mgmt.peering.aio.operations.RegisteredPrefixesOperations
    :ivar peerings: PeeringsOperations operations
    :vartype peerings: azure.mgmt.peering.aio.operations.PeeringsOperations
    :ivar received_routes: ReceivedRoutesOperations operations
    :vartype received_routes: azure.mgmt.peering.aio.operations.ReceivedRoutesOperations
    :ivar peering_service_countries: PeeringServiceCountriesOperations operations
    :vartype peering_service_countries: azure.mgmt.peering.aio.operations.PeeringServiceCountriesOperations
    :ivar peering_service_locations: PeeringServiceLocationsOperations operations
    :vartype peering_service_locations: azure.mgmt.peering.aio.operations.PeeringServiceLocationsOperations
    :ivar prefixes: PrefixesOperations operations
    :vartype prefixes: azure.mgmt.peering.aio.operations.PrefixesOperations
    :ivar peering_service_providers: PeeringServiceProvidersOperations operations
    :vartype peering_service_providers: azure.mgmt.peering.aio.operations.PeeringServiceProvidersOperations
    :ivar peering_services: PeeringServicesOperations operations
    :vartype peering_services: azure.mgmt.peering.aio.operations.PeeringServicesOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: The Azure subscription ID.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        base_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        if not base_url:
            base_url = 'https://management.azure.com'
        self._config = PeeringManagementClientConfiguration(credential, subscription_id, **kwargs)
        self._client = AsyncARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._serialize.client_side_validation = False
        self._deserialize = Deserializer(client_models)

        self.cdn_peering_prefixes = CdnPeeringPrefixesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.legacy_peerings = LegacyPeeringsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.operations = Operations(
            self._client, self._config, self._serialize, self._deserialize)
        self.peer_asns = PeerAsnsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.peering_locations = PeeringLocationsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.registered_asns = RegisteredAsnsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.registered_prefixes = RegisteredPrefixesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.peerings = PeeringsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.received_routes = ReceivedRoutesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.peering_service_countries = PeeringServiceCountriesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.peering_service_locations = PeeringServiceLocationsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.prefixes = PrefixesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.peering_service_providers = PeeringServiceProvidersOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.peering_services = PeeringServicesOperations(
            self._client, self._config, self._serialize, self._deserialize)

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "PeeringManagementClient":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details) -> None:
        await self._client.__aexit__(*exc_details)
