# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import TYPE_CHECKING
import warnings

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpRequest, HttpResponse
from azure.mgmt.core.exceptions import ARMErrorFormat

from .. import models

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Callable, Dict, Generic, Iterable, Optional, TypeVar

    T = TypeVar('T')
    ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

class PolicyTrackedResourcesOperations(object):
    """PolicyTrackedResourcesOperations operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.mgmt.policyinsights.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = models

    def __init__(self, client, config, serializer, deserializer):
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    def list_query_results_for_management_group(
        self,
        management_group_name,  # type: str
        query_options=None,  # type: Optional["models.QueryOptions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["models.PolicyTrackedResourcesQueryResults"]
        """Queries policy tracked resources under the management group.

        :param management_group_name: Management group name.
        :type management_group_name: str
        :param query_options: Parameter group.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either PolicyTrackedResourcesQueryResults or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.policyinsights.models.PolicyTrackedResourcesQueryResults]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.PolicyTrackedResourcesQueryResults"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _top = None
        _filter = None
        if query_options is not None:
            _top = query_options.top
            _filter = query_options.filter
        management_groups_namespace = "Microsoft.Management"
        policy_tracked_resources_resource = "default"
        api_version = "2018-07-01-preview"
        accept = "application/json"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

            if not next_link:
                # Construct URL
                url = self.list_query_results_for_management_group.metadata['url']  # type: ignore
                path_format_arguments = {
                    'managementGroupsNamespace': self._serialize.url("management_groups_namespace", management_groups_namespace, 'str'),
                    'managementGroupName': self._serialize.url("management_group_name", management_group_name, 'str'),
                    'policyTrackedResourcesResource': self._serialize.url("policy_tracked_resources_resource", policy_tracked_resources_resource, 'str'),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                if _top is not None:
                    query_parameters['$top'] = self._serialize.query("top", _top, 'int', minimum=0)
                if _filter is not None:
                    query_parameters['$filter'] = self._serialize.query("filter", _filter, 'str')
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

                request = self._client.post(url, query_parameters, header_parameters)
            else:
                url = next_link
                query_parameters = {}  # type: Dict[str, Any]
                request = self._client.get(url, query_parameters, header_parameters)
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize('PolicyTrackedResourcesQueryResults', pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                error = self._deserialize(models.QueryFailure, response)
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(
            get_next, extract_data
        )
    list_query_results_for_management_group.metadata = {'url': '/providers/{managementGroupsNamespace}/managementGroups/{managementGroupName}/providers/Microsoft.PolicyInsights/policyTrackedResources/{policyTrackedResourcesResource}/queryResults'}  # type: ignore

    def list_query_results_for_subscription(
        self,
        query_options=None,  # type: Optional["models.QueryOptions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["models.PolicyTrackedResourcesQueryResults"]
        """Queries policy tracked resources under the subscription.

        :param query_options: Parameter group.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either PolicyTrackedResourcesQueryResults or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.policyinsights.models.PolicyTrackedResourcesQueryResults]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.PolicyTrackedResourcesQueryResults"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _top = None
        _filter = None
        if query_options is not None:
            _top = query_options.top
            _filter = query_options.filter
        policy_tracked_resources_resource = "default"
        api_version = "2018-07-01-preview"
        accept = "application/json"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

            if not next_link:
                # Construct URL
                url = self.list_query_results_for_subscription.metadata['url']  # type: ignore
                path_format_arguments = {
                    'policyTrackedResourcesResource': self._serialize.url("policy_tracked_resources_resource", policy_tracked_resources_resource, 'str'),
                    'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str'),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                if _top is not None:
                    query_parameters['$top'] = self._serialize.query("top", _top, 'int', minimum=0)
                if _filter is not None:
                    query_parameters['$filter'] = self._serialize.query("filter", _filter, 'str')
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

                request = self._client.post(url, query_parameters, header_parameters)
            else:
                url = next_link
                query_parameters = {}  # type: Dict[str, Any]
                request = self._client.get(url, query_parameters, header_parameters)
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize('PolicyTrackedResourcesQueryResults', pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                error = self._deserialize(models.QueryFailure, response)
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(
            get_next, extract_data
        )
    list_query_results_for_subscription.metadata = {'url': '/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/policyTrackedResources/{policyTrackedResourcesResource}/queryResults'}  # type: ignore

    def list_query_results_for_resource_group(
        self,
        resource_group_name,  # type: str
        query_options=None,  # type: Optional["models.QueryOptions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["models.PolicyTrackedResourcesQueryResults"]
        """Queries policy tracked resources under the resource group.

        :param resource_group_name: Resource group name.
        :type resource_group_name: str
        :param query_options: Parameter group.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either PolicyTrackedResourcesQueryResults or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.policyinsights.models.PolicyTrackedResourcesQueryResults]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.PolicyTrackedResourcesQueryResults"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _top = None
        _filter = None
        if query_options is not None:
            _top = query_options.top
            _filter = query_options.filter
        policy_tracked_resources_resource = "default"
        api_version = "2018-07-01-preview"
        accept = "application/json"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

            if not next_link:
                # Construct URL
                url = self.list_query_results_for_resource_group.metadata['url']  # type: ignore
                path_format_arguments = {
                    'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str'),
                    'policyTrackedResourcesResource': self._serialize.url("policy_tracked_resources_resource", policy_tracked_resources_resource, 'str'),
                    'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str'),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                if _top is not None:
                    query_parameters['$top'] = self._serialize.query("top", _top, 'int', minimum=0)
                if _filter is not None:
                    query_parameters['$filter'] = self._serialize.query("filter", _filter, 'str')
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

                request = self._client.post(url, query_parameters, header_parameters)
            else:
                url = next_link
                query_parameters = {}  # type: Dict[str, Any]
                request = self._client.get(url, query_parameters, header_parameters)
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize('PolicyTrackedResourcesQueryResults', pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                error = self._deserialize(models.QueryFailure, response)
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(
            get_next, extract_data
        )
    list_query_results_for_resource_group.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/policyTrackedResources/{policyTrackedResourcesResource}/queryResults'}  # type: ignore

    def list_query_results_for_resource(
        self,
        resource_id,  # type: str
        query_options=None,  # type: Optional["models.QueryOptions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["models.PolicyTrackedResourcesQueryResults"]
        """Queries policy tracked resources under the resource.

        :param resource_id: Resource ID.
        :type resource_id: str
        :param query_options: Parameter group.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either PolicyTrackedResourcesQueryResults or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.policyinsights.models.PolicyTrackedResourcesQueryResults]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.PolicyTrackedResourcesQueryResults"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _top = None
        _filter = None
        if query_options is not None:
            _top = query_options.top
            _filter = query_options.filter
        policy_tracked_resources_resource = "default"
        api_version = "2018-07-01-preview"
        accept = "application/json"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

            if not next_link:
                # Construct URL
                url = self.list_query_results_for_resource.metadata['url']  # type: ignore
                path_format_arguments = {
                    'resourceId': self._serialize.url("resource_id", resource_id, 'str', skip_quote=True),
                    'policyTrackedResourcesResource': self._serialize.url("policy_tracked_resources_resource", policy_tracked_resources_resource, 'str'),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                if _top is not None:
                    query_parameters['$top'] = self._serialize.query("top", _top, 'int', minimum=0)
                if _filter is not None:
                    query_parameters['$filter'] = self._serialize.query("filter", _filter, 'str')
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

                request = self._client.post(url, query_parameters, header_parameters)
            else:
                url = next_link
                query_parameters = {}  # type: Dict[str, Any]
                request = self._client.get(url, query_parameters, header_parameters)
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize('PolicyTrackedResourcesQueryResults', pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                error = self._deserialize(models.QueryFailure, response)
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(
            get_next, extract_data
        )
    list_query_results_for_resource.metadata = {'url': '/{resourceId}/providers/Microsoft.PolicyInsights/policyTrackedResources/{policyTrackedResourcesResource}/queryResults'}  # type: ignore
