# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, TYPE_CHECKING

from msrest import Deserializer, Serializer

from azure.core.rest import HttpRequest, HttpResponse
from azure.mgmt.core import ARMPipelineClient

from . import models
from ._configuration import ChaosManagementClientConfiguration
from .operations import CapabilitiesOperations, CapabilityTypesOperations, ExperimentsOperations, Operations, TargetTypesOperations, TargetsOperations

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials import TokenCredential

class ChaosManagementClient:
    """Chaos Management Client.

    :ivar capabilities: CapabilitiesOperations operations
    :vartype capabilities: azure.mgmt.chaos.operations.CapabilitiesOperations
    :ivar experiments: ExperimentsOperations operations
    :vartype experiments: azure.mgmt.chaos.operations.ExperimentsOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.chaos.operations.Operations
    :ivar targets: TargetsOperations operations
    :vartype targets: azure.mgmt.chaos.operations.TargetsOperations
    :ivar target_types: TargetTypesOperations operations
    :vartype target_types: azure.mgmt.chaos.operations.TargetTypesOperations
    :ivar capability_types: CapabilityTypesOperations operations
    :vartype capability_types: azure.mgmt.chaos.operations.CapabilityTypesOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: GUID that represents an Azure subscription ID.
    :type subscription_id: str
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword api_version: Api Version. Default value is "2022-07-01-preview". Note that overriding
     this default value may result in unsupported behavior.
    :paramtype api_version: str
    """

    def __init__(
        self,
        credential: "TokenCredential",
        subscription_id: str,
        base_url: str = "https://management.azure.com",
        **kwargs: Any
    ) -> None:
        self._config = ChaosManagementClientConfiguration(credential=credential, subscription_id=subscription_id, **kwargs)
        self._client = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.capabilities = CapabilitiesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.experiments = ExperimentsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.operations = Operations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.targets = TargetsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.target_types = TargetTypesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.capability_types = CapabilityTypesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )


    def _send_request(
        self,
        request: HttpRequest,
        **kwargs: Any
    ) -> HttpResponse:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client._send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/python/protocol/quickstart

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, **kwargs)

    def close(self):
        # type: () -> None
        self._client.close()

    def __enter__(self):
        # type: () -> ChaosManagementClient
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details):
        # type: (Any) -> None
        self._client.__exit__(*exc_details)
