#! /usr/bin/env python

# $Id: test_latex2e.py 6003 2009-06-27 20:44:09Z milde $
# Author: engelbert gruber <grubert@users.sourceforge.net>
# Copyright: This module has been placed in the public domain.

"""
Tests for manpage writer.
"""

from __init__ import DocutilsTestSupport

from docutils._compat import b

def suite():
    settings = {}
    s = DocutilsTestSupport.PublishTestSuite('manpage', suite_settings=settings)
    s.generateTests(totest)
    return s

indend_macros = r""".
.nr rst2man-indent-level 0
.
.de1 rstReportMargin
\\$1 \\n[an-margin]
level \\n[rst2man-indent-level]
level margin: \\n[rst2man-indent\\n[rst2man-indent-level]]
-
\\n[rst2man-indent0]
\\n[rst2man-indent1]
\\n[rst2man-indent2]
..
.de1 INDENT
.\" .rstReportMargin pre:
. RS \\$1
. nr rst2man-indent\\n[rst2man-indent-level] \\n[an-margin]
. nr rst2man-indent-level +1
.\" .rstReportMargin post:
..
.de UNINDENT
. RE
.\" indent \\n[an-margin]
.\" old: \\n[rst2man-indent\\n[rst2man-indent-level]]
.nr rst2man-indent-level -1
.\" new: \\n[rst2man-indent\\n[rst2man-indent-level]]
.in \\n[rst2man-indent\\n[rst2man-indent-level]]u
..
"""

totest = {}

totest['blank'] = [
        ["", 
        r""".TH   "" "" ""
.SH NAME
 \- 
.\" Man page generated from reStructeredText.
.
.\" Generated by docutils manpage writer.
.\" 
.
"""],
    ]

totest['simple'] = [
        ["""\
========        
 simple
========

---------------
 The way to go
---------------

:Author: someone@somewhere.net
:Date:   2009-08-05
:Copyright: public domain
:Version: 0.1
:Manual section: 1
:Manual group: text processing
:Arbitrary field: some text

SYNOPSIS
========

::

  K.I.S.S keep it simple.

DESCRIPTION
===========

General rule of life.

OPTIONS
=======

--config=<file>         Read configuration settings from <file>, if it exists.
--version, -V           Show this program's version number and exit.
--help, -h              Show this help message and exit.

OTHER SECTION
=============

With mixed case.
""", 
        r""".\" Man page generated from reStructeredText.
.
.TH SIMPLE 1 "2009-08-05" "0.1" "text processing"
.SH NAME
simple \- The way to go
"""+indend_macros+
r""".SH SYNOPSIS
.sp
.nf
.ft C
K.I.S.S keep it simple.
.ft P
.fi
.SH DESCRIPTION
.sp
General rule of life.
.SH OPTIONS
.INDENT 0.0
.TP
.BI \-\-config\fB= <file>
.
Read configuration settings from <file>, if it exists.
.TP
.B \-\-version,  \-V
.
Show this program\(aqs version number and exit.
.TP
.B \-\-help,  \-h
.
Show this help message and exit.
.UNINDENT
.SH OTHER SECTION
.sp
With mixed case.
.SH AUTHOR
someone@somewhere.net

Arbitrary field: some text
.SH COPYRIGHT
public domain
.\" Generated by docutils manpage writer.
.\" 
.
"""],
    ]

totest['table'] = [
        ["""\
        ====== =====
         head   and
        ====== =====
           1     2
          abc   so
        ====== =====
""", 
'''\
.TH   "" "" ""
.SH NAME
 \\- \n\
.\\" Man page generated from reStructeredText.
.
.INDENT 0.0
.INDENT 3.5
.TS
center;
|l|l|.
_
T{
head
T}\tT{
and
T}
_
T{
1
T}\tT{
2
T}
_
T{
abc
T}\tT{
so
T}
_
.TE
.UNINDENT
.UNINDENT
.\\" Generated by docutils manpage writer.
.\\" 
.
''']
]

if __name__ == '__main__':
    import unittest
    unittest.main(defaultTest='suite')
