
##############################################################################
#
# Copyright (c) 2003-2016 by The University of Queensland
# http://www.uq.edu.au
#
# Primary Business: Queensland, Australia
# Licensed under the Apache License, version 2.0
# http://www.apache.org/licenses/LICENSE-2.0
#
# Development until 2012 by Earth Systems Science Computational Center (ESSCC)
# Development 2012-2013 by School of Earth Sciences
# Development from 2014 by Centre for Geoscience Computing (GeoComp)
#
##############################################################################

from __future__ import print_function, division

__copyright__="""Copyright (c) 2003-2016 by The University of Queensland
http://www.uq.edu.au
Primary Business: Queensland, Australia"""
__license__="""Licensed under the Apache License, version 2.0
http://www.apache.org/licenses/LICENSE-2.0"""
__url__="https://launchpad.net/escript-finley"

"""
basic tests for functions in util.py effecting the spatial distribution 

it is assumed that the domain is the usint square/cube 

not all these test will run for all domains. check the doc string for the assumptions of a particular test

:var __author__: name of author
:var __copyright__: copyrights
:var __license__: licence agreement
:var __url__: url entry point on documentation
:var __version__: version
:var __date__: date of the version
"""
__author__="Lutz Gross, l.gross@uq.edu.au"

import esys.escriptcore.utestselect as unittest
from esys.escript import *
from numpy import array
import numpy

from test_util_spatial_functions2 import Test_Util_SpatialFunctions_noGradOnBoundary


class Test_Util_SpatialFunctions(Test_Util_SpatialFunctions_noGradOnBoundary):

   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnBoundary_fromData_ContinuousFunction_rank0(self):
      """
      tests gradient for rank 0 Data on the FunctionOnBoundary

      assumptions: ContinuousFunction(self.domain) exists
                   self.domain supports gradient on FunctionOnBoundary
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=FunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=ContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(),w)
      ref=Data(0,()+(dim,),w_ref)
      if dim==2:
        arg=(0.741017463552)*x[0]**o+(0.665549604887)*x[0]+(-0.294688627656)*x[1]**o+(-0.188608956137)*x[1]
        ref[0]=o*(0.741017463552)*x_ref[0]**(o-1)+(0.665549604887)
        ref[1]=o*(-0.294688627656)*x_ref[1]**(o-1)+(-0.188608956137)
      else:
        arg=(-0.182264095574)*x[0]**o+(0.388884343071)*x[0]+(0.0250471058578)*x[1]**o+(0.242724421847)*x[1]+(-0.863568419189)*x[2]**o+(-0.797427046061)*x[2]
        ref[0]=o*(-0.182264095574)*x_ref[0]**(o-1)+(0.388884343071)
        ref[1]=o*(0.0250471058578)*x_ref[1]**(o-1)+(0.242724421847)
        ref[2]=o*(-0.863568419189)*x_ref[2]**(o-1)+(-0.797427046061)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),()+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnBoundary_fromData_ContinuousFunction_rank1(self):
      """
      tests gradient for rank 1 Data on the FunctionOnBoundary

      assumptions: ContinuousFunction(self.domain) exists
                   self.domain supports gradient on FunctionOnBoundary
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=FunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=ContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(2,),w)
      ref=Data(0,(2,)+(dim,),w_ref)
      if dim==2:
        arg[0]=(-0.566748845779)*x[0]**o+(0.284156548246)*x[0]+(0.213805183732)*x[1]**o+(0.887833417271)*x[1]
        arg[1]=(-0.935376067943)*x[0]**o+(0.31417056704)*x[0]+(0.157729703937)*x[1]**o+(0.781264180355)*x[1]
        ref[0,0]=o*(-0.566748845779)*x_ref[0]**(o-1)+(0.284156548246)
        ref[0,1]=o*(0.213805183732)*x_ref[1]**(o-1)+(0.887833417271)
        ref[1,0]=o*(-0.935376067943)*x_ref[0]**(o-1)+(0.31417056704)
        ref[1,1]=o*(0.157729703937)*x_ref[1]**(o-1)+(0.781264180355)
      else:
        arg[0]=(0.787106597246)*x[0]**o+(0.0477259256332)*x[0]+(0.0657839729355)*x[1]**o+(-0.367242386854)*x[1]+(0.638047637996)*x[2]**o+(0.292293368262)*x[2]
        arg[1]=(0.325241621537)*x[0]**o+(-0.995465871567)*x[0]+(-0.589833259992)*x[1]**o+(0.252602994164)*x[1]+(0.271544628727)*x[2]**o+(0.401222388174)*x[2]
        ref[0,0]=o*(0.787106597246)*x_ref[0]**(o-1)+(0.0477259256332)
        ref[0,1]=o*(0.0657839729355)*x_ref[1]**(o-1)+(-0.367242386854)
        ref[0,2]=o*(0.638047637996)*x_ref[2]**(o-1)+(0.292293368262)
        ref[1,0]=o*(0.325241621537)*x_ref[0]**(o-1)+(-0.995465871567)
        ref[1,1]=o*(-0.589833259992)*x_ref[1]**(o-1)+(0.252602994164)
        ref[1,2]=o*(0.271544628727)*x_ref[2]**(o-1)+(0.401222388174)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnBoundary_fromData_ContinuousFunction_rank2(self):
      """
      tests gradient for rank 2 Data on the FunctionOnBoundary

      assumptions: ContinuousFunction(self.domain) exists
                   self.domain supports gradient on FunctionOnBoundary
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=FunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=ContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(4, 5),w)
      ref=Data(0,(4, 5)+(dim,),w_ref)
      if dim==2:
        arg[0,0]=(-0.535138548297)*x[0]**o+(0.320793182084)*x[0]+(-0.363556615611)*x[1]**o+(0.80028981928)*x[1]
        arg[0,1]=(0.50712290341)*x[0]**o+(0.0696582374725)*x[0]+(-0.565430065964)*x[1]**o+(0.840341269012)*x[1]
        arg[0,2]=(0.222608517758)*x[0]**o+(0.0741096149609)*x[0]+(-0.926916099396)*x[1]**o+(0.840471681255)*x[1]
        arg[0,3]=(-0.0729061065831)*x[0]**o+(-0.361006912293)*x[0]+(-0.796381694915)*x[1]**o+(-0.87399027927)*x[1]
        arg[0,4]=(0.946982642563)*x[0]**o+(0.776871793528)*x[0]+(0.906858449271)*x[1]**o+(0.23076439514)*x[1]
        arg[1,0]=(-0.121641842365)*x[0]**o+(0.755274749862)*x[0]+(-0.905815080361)*x[1]**o+(-0.27711865979)*x[1]
        arg[1,1]=(0.870675475328)*x[0]**o+(0.000245820302085)*x[0]+(0.990534371185)*x[1]**o+(-0.0132722523111)*x[1]
        arg[1,2]=(0.665375098591)*x[0]**o+(0.602779210152)*x[0]+(0.112732227406)*x[1]**o+(0.973600268944)*x[1]
        arg[1,3]=(-0.760686885095)*x[0]**o+(-0.993893837808)*x[0]+(-0.279242757928)*x[1]**o+(0.0970216781461)*x[1]
        arg[1,4]=(-0.326265155118)*x[0]**o+(-0.302971035826)*x[0]+(-0.991053864037)*x[1]**o+(-0.787776341406)*x[1]
        arg[2,0]=(-0.798558123695)*x[0]**o+(-0.648773673567)*x[0]+(0.911336567339)*x[1]**o+(0.525888531875)*x[1]
        arg[2,1]=(0.334481967771)*x[0]**o+(0.559633318828)*x[0]+(-0.738361234791)*x[1]**o+(0.863808627657)*x[1]
        arg[2,2]=(-0.660270802705)*x[0]**o+(-0.500800405285)*x[0]+(0.250991213972)*x[1]**o+(-0.855371865339)*x[1]
        arg[2,3]=(0.573495152924)*x[0]**o+(0.841810214664)*x[0]+(0.816402403997)*x[1]**o+(0.871435278968)*x[1]
        arg[2,4]=(0.00700234490903)*x[0]**o+(0.609696655384)*x[0]+(-0.908261420109)*x[1]**o+(-0.0469518512659)*x[1]
        arg[3,0]=(-0.78381944233)*x[0]**o+(0.547849085605)*x[0]+(-0.481333073199)*x[1]**o+(-0.100496681813)*x[1]
        arg[3,1]=(0.53995869966)*x[0]**o+(-0.503303606531)*x[0]+(0.783394329024)*x[1]**o+(0.989828473603)*x[1]
        arg[3,2]=(0.723590003109)*x[0]**o+(-0.75511396868)*x[0]+(0.249651386017)*x[1]**o+(0.545636109436)*x[1]
        arg[3,3]=(-0.126863462818)*x[0]**o+(0.553295312002)*x[0]+(-0.286155398085)*x[1]**o+(0.425889110789)*x[1]
        arg[3,4]=(-0.970069386779)*x[0]**o+(0.457400568855)*x[0]+(-0.245839304835)*x[1]**o+(-0.463000940469)*x[1]
        ref[0,0,0]=o*(-0.535138548297)*x_ref[0]**(o-1)+(0.320793182084)
        ref[0,0,1]=o*(-0.363556615611)*x_ref[1]**(o-1)+(0.80028981928)
        ref[0,1,0]=o*(0.50712290341)*x_ref[0]**(o-1)+(0.0696582374725)
        ref[0,1,1]=o*(-0.565430065964)*x_ref[1]**(o-1)+(0.840341269012)
        ref[0,2,0]=o*(0.222608517758)*x_ref[0]**(o-1)+(0.0741096149609)
        ref[0,2,1]=o*(-0.926916099396)*x_ref[1]**(o-1)+(0.840471681255)
        ref[0,3,0]=o*(-0.0729061065831)*x_ref[0]**(o-1)+(-0.361006912293)
        ref[0,3,1]=o*(-0.796381694915)*x_ref[1]**(o-1)+(-0.87399027927)
        ref[0,4,0]=o*(0.946982642563)*x_ref[0]**(o-1)+(0.776871793528)
        ref[0,4,1]=o*(0.906858449271)*x_ref[1]**(o-1)+(0.23076439514)
        ref[1,0,0]=o*(-0.121641842365)*x_ref[0]**(o-1)+(0.755274749862)
        ref[1,0,1]=o*(-0.905815080361)*x_ref[1]**(o-1)+(-0.27711865979)
        ref[1,1,0]=o*(0.870675475328)*x_ref[0]**(o-1)+(0.000245820302085)
        ref[1,1,1]=o*(0.990534371185)*x_ref[1]**(o-1)+(-0.0132722523111)
        ref[1,2,0]=o*(0.665375098591)*x_ref[0]**(o-1)+(0.602779210152)
        ref[1,2,1]=o*(0.112732227406)*x_ref[1]**(o-1)+(0.973600268944)
        ref[1,3,0]=o*(-0.760686885095)*x_ref[0]**(o-1)+(-0.993893837808)
        ref[1,3,1]=o*(-0.279242757928)*x_ref[1]**(o-1)+(0.0970216781461)
        ref[1,4,0]=o*(-0.326265155118)*x_ref[0]**(o-1)+(-0.302971035826)
        ref[1,4,1]=o*(-0.991053864037)*x_ref[1]**(o-1)+(-0.787776341406)
        ref[2,0,0]=o*(-0.798558123695)*x_ref[0]**(o-1)+(-0.648773673567)
        ref[2,0,1]=o*(0.911336567339)*x_ref[1]**(o-1)+(0.525888531875)
        ref[2,1,0]=o*(0.334481967771)*x_ref[0]**(o-1)+(0.559633318828)
        ref[2,1,1]=o*(-0.738361234791)*x_ref[1]**(o-1)+(0.863808627657)
        ref[2,2,0]=o*(-0.660270802705)*x_ref[0]**(o-1)+(-0.500800405285)
        ref[2,2,1]=o*(0.250991213972)*x_ref[1]**(o-1)+(-0.855371865339)
        ref[2,3,0]=o*(0.573495152924)*x_ref[0]**(o-1)+(0.841810214664)
        ref[2,3,1]=o*(0.816402403997)*x_ref[1]**(o-1)+(0.871435278968)
        ref[2,4,0]=o*(0.00700234490903)*x_ref[0]**(o-1)+(0.609696655384)
        ref[2,4,1]=o*(-0.908261420109)*x_ref[1]**(o-1)+(-0.0469518512659)
        ref[3,0,0]=o*(-0.78381944233)*x_ref[0]**(o-1)+(0.547849085605)
        ref[3,0,1]=o*(-0.481333073199)*x_ref[1]**(o-1)+(-0.100496681813)
        ref[3,1,0]=o*(0.53995869966)*x_ref[0]**(o-1)+(-0.503303606531)
        ref[3,1,1]=o*(0.783394329024)*x_ref[1]**(o-1)+(0.989828473603)
        ref[3,2,0]=o*(0.723590003109)*x_ref[0]**(o-1)+(-0.75511396868)
        ref[3,2,1]=o*(0.249651386017)*x_ref[1]**(o-1)+(0.545636109436)
        ref[3,3,0]=o*(-0.126863462818)*x_ref[0]**(o-1)+(0.553295312002)
        ref[3,3,1]=o*(-0.286155398085)*x_ref[1]**(o-1)+(0.425889110789)
        ref[3,4,0]=o*(-0.970069386779)*x_ref[0]**(o-1)+(0.457400568855)
        ref[3,4,1]=o*(-0.245839304835)*x_ref[1]**(o-1)+(-0.463000940469)
      else:
        arg[0,0]=(-0.0252675874258)*x[0]**o+(-0.998043629662)*x[0]+(-0.956603187221)*x[1]**o+(-0.642113208329)*x[1]+(-0.59687133215)*x[2]**o+(-0.222380006695)*x[2]
        arg[0,1]=(0.540057023826)*x[0]**o+(0.660021105706)*x[0]+(-0.0847035816563)*x[1]**o+(0.734935147879)*x[1]+(0.895080236848)*x[2]**o+(0.759076168225)*x[2]
        arg[0,2]=(0.208276460123)*x[0]**o+(-0.842726599314)*x[0]+(0.514146640689)*x[1]**o+(-0.931115443386)*x[1]+(-0.427990918054)*x[2]**o+(-0.0944702225036)*x[2]
        arg[0,3]=(-0.669873393665)*x[0]**o+(-0.164211687812)*x[0]+(0.257292402022)*x[1]**o+(0.788249196864)*x[1]+(-0.0160232742588)*x[2]**o+(0.593261720532)*x[2]
        arg[0,4]=(0.574685018662)*x[0]**o+(-0.404093341935)*x[0]+(-0.613704015926)*x[1]**o+(-0.388769512229)*x[1]+(0.65014059769)*x[2]**o+(0.796497720581)*x[2]
        arg[1,0]=(0.579425469692)*x[0]**o+(0.706786266065)*x[0]+(-0.489805412824)*x[1]**o+(0.412673120993)*x[1]+(-0.261487328773)*x[2]**o+(0.323016314178)*x[2]
        arg[1,1]=(-0.406115852457)*x[0]**o+(-0.320011474154)*x[0]+(0.83353566302)*x[1]**o+(-0.770757586792)*x[1]+(-0.497021878205)*x[2]**o+(-0.108546214912)*x[2]
        arg[1,2]=(-0.799159182698)*x[0]**o+(0.221424788319)*x[0]+(0.882092644719)*x[1]**o+(0.25804039903)*x[1]+(-0.788642442802)*x[2]**o+(-0.434293659417)*x[2]
        arg[1,3]=(-0.453596867354)*x[0]**o+(-0.855684542333)*x[0]+(0.421257402196)*x[1]**o+(0.162268279507)*x[1]+(-0.618396236314)*x[2]**o+(-0.650684413266)*x[2]
        arg[1,4]=(-0.464749011522)*x[0]**o+(-0.050661862641)*x[0]+(-0.7554290975)*x[1]**o+(-0.213826578781)*x[1]+(-0.536460109672)*x[2]**o+(-0.441490452069)*x[2]
        arg[2,0]=(0.335438338384)*x[0]**o+(-0.598515232086)*x[0]+(0.396958696838)*x[1]**o+(0.712094780848)*x[1]+(0.0112487672163)*x[2]**o+(-0.106361601342)*x[2]
        arg[2,1]=(0.157333767552)*x[0]**o+(0.763247557186)*x[0]+(0.454047596703)*x[1]**o+(0.874633696245)*x[1]+(0.80992740886)*x[2]**o+(-0.465565575276)*x[2]
        arg[2,2]=(-0.668932235683)*x[0]**o+(0.99055962791)*x[0]+(-0.473440344595)*x[1]**o+(-0.694789559356)*x[1]+(-0.337501506478)*x[2]**o+(-0.552461610916)*x[2]
        arg[2,3]=(-0.174040039098)*x[0]**o+(0.878604594327)*x[0]+(-0.488684761288)*x[1]**o+(-0.225626690649)*x[1]+(0.307550460093)*x[2]**o+(0.279172145442)*x[2]
        arg[2,4]=(0.771496476361)*x[0]**o+(-0.528231004311)*x[0]+(0.318620411204)*x[1]**o+(-0.831636376644)*x[1]+(-0.23477599759)*x[2]**o+(0.452986258707)*x[2]
        arg[3,0]=(0.689878836595)*x[0]**o+(-0.723887531161)*x[0]+(0.906077469738)*x[1]**o+(-0.729986756151)*x[1]+(0.860506345609)*x[2]**o+(-0.437203511895)*x[2]
        arg[3,1]=(0.867909616506)*x[0]**o+(-0.0480808079676)*x[0]+(-0.439925732789)*x[1]**o+(-0.753945614279)*x[1]+(-0.0015149141551)*x[2]**o+(-0.465559525628)*x[2]
        arg[3,2]=(0.915231983332)*x[0]**o+(0.77428136852)*x[0]+(0.902598621987)*x[1]**o+(-0.49204288782)*x[1]+(0.77362022057)*x[2]**o+(0.872135547313)*x[2]
        arg[3,3]=(0.274436414079)*x[0]**o+(-0.291721638943)*x[0]+(0.202501119852)*x[1]**o+(0.911330931145)*x[1]+(-0.61382801878)*x[2]**o+(0.386704897682)*x[2]
        arg[3,4]=(-0.0258695378217)*x[0]**o+(0.263046110195)*x[0]+(-0.162461126288)*x[1]**o+(-0.123570278155)*x[1]+(0.598012400912)*x[2]**o+(0.769951340801)*x[2]
        ref[0,0,0]=o*(-0.0252675874258)*x_ref[0]**(o-1)+(-0.998043629662)
        ref[0,0,1]=o*(-0.956603187221)*x_ref[1]**(o-1)+(-0.642113208329)
        ref[0,0,2]=o*(-0.59687133215)*x_ref[2]**(o-1)+(-0.222380006695)
        ref[0,1,0]=o*(0.540057023826)*x_ref[0]**(o-1)+(0.660021105706)
        ref[0,1,1]=o*(-0.0847035816563)*x_ref[1]**(o-1)+(0.734935147879)
        ref[0,1,2]=o*(0.895080236848)*x_ref[2]**(o-1)+(0.759076168225)
        ref[0,2,0]=o*(0.208276460123)*x_ref[0]**(o-1)+(-0.842726599314)
        ref[0,2,1]=o*(0.514146640689)*x_ref[1]**(o-1)+(-0.931115443386)
        ref[0,2,2]=o*(-0.427990918054)*x_ref[2]**(o-1)+(-0.0944702225036)
        ref[0,3,0]=o*(-0.669873393665)*x_ref[0]**(o-1)+(-0.164211687812)
        ref[0,3,1]=o*(0.257292402022)*x_ref[1]**(o-1)+(0.788249196864)
        ref[0,3,2]=o*(-0.0160232742588)*x_ref[2]**(o-1)+(0.593261720532)
        ref[0,4,0]=o*(0.574685018662)*x_ref[0]**(o-1)+(-0.404093341935)
        ref[0,4,1]=o*(-0.613704015926)*x_ref[1]**(o-1)+(-0.388769512229)
        ref[0,4,2]=o*(0.65014059769)*x_ref[2]**(o-1)+(0.796497720581)
        ref[1,0,0]=o*(0.579425469692)*x_ref[0]**(o-1)+(0.706786266065)
        ref[1,0,1]=o*(-0.489805412824)*x_ref[1]**(o-1)+(0.412673120993)
        ref[1,0,2]=o*(-0.261487328773)*x_ref[2]**(o-1)+(0.323016314178)
        ref[1,1,0]=o*(-0.406115852457)*x_ref[0]**(o-1)+(-0.320011474154)
        ref[1,1,1]=o*(0.83353566302)*x_ref[1]**(o-1)+(-0.770757586792)
        ref[1,1,2]=o*(-0.497021878205)*x_ref[2]**(o-1)+(-0.108546214912)
        ref[1,2,0]=o*(-0.799159182698)*x_ref[0]**(o-1)+(0.221424788319)
        ref[1,2,1]=o*(0.882092644719)*x_ref[1]**(o-1)+(0.25804039903)
        ref[1,2,2]=o*(-0.788642442802)*x_ref[2]**(o-1)+(-0.434293659417)
        ref[1,3,0]=o*(-0.453596867354)*x_ref[0]**(o-1)+(-0.855684542333)
        ref[1,3,1]=o*(0.421257402196)*x_ref[1]**(o-1)+(0.162268279507)
        ref[1,3,2]=o*(-0.618396236314)*x_ref[2]**(o-1)+(-0.650684413266)
        ref[1,4,0]=o*(-0.464749011522)*x_ref[0]**(o-1)+(-0.050661862641)
        ref[1,4,1]=o*(-0.7554290975)*x_ref[1]**(o-1)+(-0.213826578781)
        ref[1,4,2]=o*(-0.536460109672)*x_ref[2]**(o-1)+(-0.441490452069)
        ref[2,0,0]=o*(0.335438338384)*x_ref[0]**(o-1)+(-0.598515232086)
        ref[2,0,1]=o*(0.396958696838)*x_ref[1]**(o-1)+(0.712094780848)
        ref[2,0,2]=o*(0.0112487672163)*x_ref[2]**(o-1)+(-0.106361601342)
        ref[2,1,0]=o*(0.157333767552)*x_ref[0]**(o-1)+(0.763247557186)
        ref[2,1,1]=o*(0.454047596703)*x_ref[1]**(o-1)+(0.874633696245)
        ref[2,1,2]=o*(0.80992740886)*x_ref[2]**(o-1)+(-0.465565575276)
        ref[2,2,0]=o*(-0.668932235683)*x_ref[0]**(o-1)+(0.99055962791)
        ref[2,2,1]=o*(-0.473440344595)*x_ref[1]**(o-1)+(-0.694789559356)
        ref[2,2,2]=o*(-0.337501506478)*x_ref[2]**(o-1)+(-0.552461610916)
        ref[2,3,0]=o*(-0.174040039098)*x_ref[0]**(o-1)+(0.878604594327)
        ref[2,3,1]=o*(-0.488684761288)*x_ref[1]**(o-1)+(-0.225626690649)
        ref[2,3,2]=o*(0.307550460093)*x_ref[2]**(o-1)+(0.279172145442)
        ref[2,4,0]=o*(0.771496476361)*x_ref[0]**(o-1)+(-0.528231004311)
        ref[2,4,1]=o*(0.318620411204)*x_ref[1]**(o-1)+(-0.831636376644)
        ref[2,4,2]=o*(-0.23477599759)*x_ref[2]**(o-1)+(0.452986258707)
        ref[3,0,0]=o*(0.689878836595)*x_ref[0]**(o-1)+(-0.723887531161)
        ref[3,0,1]=o*(0.906077469738)*x_ref[1]**(o-1)+(-0.729986756151)
        ref[3,0,2]=o*(0.860506345609)*x_ref[2]**(o-1)+(-0.437203511895)
        ref[3,1,0]=o*(0.867909616506)*x_ref[0]**(o-1)+(-0.0480808079676)
        ref[3,1,1]=o*(-0.439925732789)*x_ref[1]**(o-1)+(-0.753945614279)
        ref[3,1,2]=o*(-0.0015149141551)*x_ref[2]**(o-1)+(-0.465559525628)
        ref[3,2,0]=o*(0.915231983332)*x_ref[0]**(o-1)+(0.77428136852)
        ref[3,2,1]=o*(0.902598621987)*x_ref[1]**(o-1)+(-0.49204288782)
        ref[3,2,2]=o*(0.77362022057)*x_ref[2]**(o-1)+(0.872135547313)
        ref[3,3,0]=o*(0.274436414079)*x_ref[0]**(o-1)+(-0.291721638943)
        ref[3,3,1]=o*(0.202501119852)*x_ref[1]**(o-1)+(0.911330931145)
        ref[3,3,2]=o*(-0.61382801878)*x_ref[2]**(o-1)+(0.386704897682)
        ref[3,4,0]=o*(-0.0258695378217)*x_ref[0]**(o-1)+(0.263046110195)
        ref[3,4,1]=o*(-0.162461126288)*x_ref[1]**(o-1)+(-0.123570278155)
        ref[3,4,2]=o*(0.598012400912)*x_ref[2]**(o-1)+(0.769951340801)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnBoundary_fromData_ContinuousFunction_rank3(self):
      """
      tests gradient for rank 3 Data on the FunctionOnBoundary

      assumptions: ContinuousFunction(self.domain) exists
                   self.domain supports gradient on FunctionOnBoundary
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=FunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=ContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(6, 2, 2),w)
      ref=Data(0,(6, 2, 2)+(dim,),w_ref)
      if dim==2:
        arg[0,0,0]=(-0.301542954432)*x[0]**o+(-0.126029003998)*x[0]+(-0.408561086014)*x[1]**o+(0.090642210886)*x[1]
        arg[0,0,1]=(0.456052591865)*x[0]**o+(0.624896766511)*x[0]+(0.87137087467)*x[1]**o+(-0.296114354421)*x[1]
        arg[0,1,0]=(0.370833001032)*x[0]**o+(-0.700862384031)*x[0]+(-0.276076372016)*x[1]**o+(-0.820884025764)*x[1]
        arg[0,1,1]=(0.550805148631)*x[0]**o+(-0.628825647329)*x[0]+(0.906362219793)*x[1]**o+(0.093148354989)*x[1]
        arg[1,0,0]=(-0.80347190678)*x[0]**o+(-0.112285193049)*x[0]+(-0.703090064994)*x[1]**o+(0.738893806856)*x[1]
        arg[1,0,1]=(0.716113817265)*x[0]**o+(-0.403563175278)*x[0]+(-0.545474326725)*x[1]**o+(-0.085377932579)*x[1]
        arg[1,1,0]=(0.0151945295253)*x[0]**o+(0.419681120006)*x[0]+(0.605889120207)*x[1]**o+(0.94921670969)*x[1]
        arg[1,1,1]=(0.330888675781)*x[0]**o+(0.536336632067)*x[0]+(0.130243661103)*x[1]**o+(0.249581698903)*x[1]
        arg[2,0,0]=(-0.94168189216)*x[0]**o+(0.42899125004)*x[0]+(0.104206704223)*x[1]**o+(0.992451993183)*x[1]
        arg[2,0,1]=(-0.557898869487)*x[0]**o+(-0.0387050073802)*x[0]+(-0.880396260326)*x[1]**o+(-0.649734782543)*x[1]
        arg[2,1,0]=(0.0362873703011)*x[0]**o+(0.641116555832)*x[0]+(-0.878565186806)*x[1]**o+(-0.305825058029)*x[1]
        arg[2,1,1]=(0.926144430868)*x[0]**o+(0.207902756992)*x[0]+(-0.823834000424)*x[1]**o+(0.541980766739)*x[1]
        arg[3,0,0]=(-0.497934527226)*x[0]**o+(0.904514339359)*x[0]+(0.0627382682436)*x[1]**o+(-0.886845257384)*x[1]
        arg[3,0,1]=(0.458163004678)*x[0]**o+(-0.890966354569)*x[0]+(0.779511556433)*x[1]**o+(0.911407858547)*x[1]
        arg[3,1,0]=(0.643197533583)*x[0]**o+(-0.445952483015)*x[0]+(-0.491648538422)*x[1]**o+(-0.339803793944)*x[1]
        arg[3,1,1]=(0.564910446806)*x[0]**o+(-0.251342703228)*x[0]+(-0.102526510378)*x[1]**o+(0.989034603428)*x[1]
        arg[4,0,0]=(0.0728812877818)*x[0]**o+(-0.160839673847)*x[0]+(0.078039622926)*x[1]**o+(-0.778740146006)*x[1]
        arg[4,0,1]=(-0.848970759855)*x[0]**o+(0.83795370612)*x[0]+(-0.652802628253)*x[1]**o+(0.570900978851)*x[1]
        arg[4,1,0]=(0.492154273484)*x[0]**o+(-0.138488354185)*x[0]+(0.269142955069)*x[1]**o+(-0.849995493706)*x[1]
        arg[4,1,1]=(0.945032529684)*x[0]**o+(0.611284327327)*x[0]+(0.549856083886)*x[1]**o+(0.347585489606)*x[1]
        arg[5,0,0]=(0.481456547858)*x[0]**o+(0.238848312219)*x[0]+(-0.5849679413)*x[1]**o+(-0.749140400072)*x[1]
        arg[5,0,1]=(0.27081490311)*x[0]**o+(-0.101642948148)*x[0]+(0.31847076679)*x[1]**o+(0.192182993758)*x[1]
        arg[5,1,0]=(-0.873348151897)*x[0]**o+(-0.613499952221)*x[0]+(0.54087826152)*x[1]**o+(-0.269096416524)*x[1]
        arg[5,1,1]=(-0.803277233859)*x[0]**o+(-0.714237882827)*x[0]+(-0.205544031812)*x[1]**o+(0.188144864673)*x[1]
        ref[0,0,0,0]=o*(-0.301542954432)*x_ref[0]**(o-1)+(-0.126029003998)
        ref[0,0,0,1]=o*(-0.408561086014)*x_ref[1]**(o-1)+(0.090642210886)
        ref[0,0,1,0]=o*(0.456052591865)*x_ref[0]**(o-1)+(0.624896766511)
        ref[0,0,1,1]=o*(0.87137087467)*x_ref[1]**(o-1)+(-0.296114354421)
        ref[0,1,0,0]=o*(0.370833001032)*x_ref[0]**(o-1)+(-0.700862384031)
        ref[0,1,0,1]=o*(-0.276076372016)*x_ref[1]**(o-1)+(-0.820884025764)
        ref[0,1,1,0]=o*(0.550805148631)*x_ref[0]**(o-1)+(-0.628825647329)
        ref[0,1,1,1]=o*(0.906362219793)*x_ref[1]**(o-1)+(0.093148354989)
        ref[1,0,0,0]=o*(-0.80347190678)*x_ref[0]**(o-1)+(-0.112285193049)
        ref[1,0,0,1]=o*(-0.703090064994)*x_ref[1]**(o-1)+(0.738893806856)
        ref[1,0,1,0]=o*(0.716113817265)*x_ref[0]**(o-1)+(-0.403563175278)
        ref[1,0,1,1]=o*(-0.545474326725)*x_ref[1]**(o-1)+(-0.085377932579)
        ref[1,1,0,0]=o*(0.0151945295253)*x_ref[0]**(o-1)+(0.419681120006)
        ref[1,1,0,1]=o*(0.605889120207)*x_ref[1]**(o-1)+(0.94921670969)
        ref[1,1,1,0]=o*(0.330888675781)*x_ref[0]**(o-1)+(0.536336632067)
        ref[1,1,1,1]=o*(0.130243661103)*x_ref[1]**(o-1)+(0.249581698903)
        ref[2,0,0,0]=o*(-0.94168189216)*x_ref[0]**(o-1)+(0.42899125004)
        ref[2,0,0,1]=o*(0.104206704223)*x_ref[1]**(o-1)+(0.992451993183)
        ref[2,0,1,0]=o*(-0.557898869487)*x_ref[0]**(o-1)+(-0.0387050073802)
        ref[2,0,1,1]=o*(-0.880396260326)*x_ref[1]**(o-1)+(-0.649734782543)
        ref[2,1,0,0]=o*(0.0362873703011)*x_ref[0]**(o-1)+(0.641116555832)
        ref[2,1,0,1]=o*(-0.878565186806)*x_ref[1]**(o-1)+(-0.305825058029)
        ref[2,1,1,0]=o*(0.926144430868)*x_ref[0]**(o-1)+(0.207902756992)
        ref[2,1,1,1]=o*(-0.823834000424)*x_ref[1]**(o-1)+(0.541980766739)
        ref[3,0,0,0]=o*(-0.497934527226)*x_ref[0]**(o-1)+(0.904514339359)
        ref[3,0,0,1]=o*(0.0627382682436)*x_ref[1]**(o-1)+(-0.886845257384)
        ref[3,0,1,0]=o*(0.458163004678)*x_ref[0]**(o-1)+(-0.890966354569)
        ref[3,0,1,1]=o*(0.779511556433)*x_ref[1]**(o-1)+(0.911407858547)
        ref[3,1,0,0]=o*(0.643197533583)*x_ref[0]**(o-1)+(-0.445952483015)
        ref[3,1,0,1]=o*(-0.491648538422)*x_ref[1]**(o-1)+(-0.339803793944)
        ref[3,1,1,0]=o*(0.564910446806)*x_ref[0]**(o-1)+(-0.251342703228)
        ref[3,1,1,1]=o*(-0.102526510378)*x_ref[1]**(o-1)+(0.989034603428)
        ref[4,0,0,0]=o*(0.0728812877818)*x_ref[0]**(o-1)+(-0.160839673847)
        ref[4,0,0,1]=o*(0.078039622926)*x_ref[1]**(o-1)+(-0.778740146006)
        ref[4,0,1,0]=o*(-0.848970759855)*x_ref[0]**(o-1)+(0.83795370612)
        ref[4,0,1,1]=o*(-0.652802628253)*x_ref[1]**(o-1)+(0.570900978851)
        ref[4,1,0,0]=o*(0.492154273484)*x_ref[0]**(o-1)+(-0.138488354185)
        ref[4,1,0,1]=o*(0.269142955069)*x_ref[1]**(o-1)+(-0.849995493706)
        ref[4,1,1,0]=o*(0.945032529684)*x_ref[0]**(o-1)+(0.611284327327)
        ref[4,1,1,1]=o*(0.549856083886)*x_ref[1]**(o-1)+(0.347585489606)
        ref[5,0,0,0]=o*(0.481456547858)*x_ref[0]**(o-1)+(0.238848312219)
        ref[5,0,0,1]=o*(-0.5849679413)*x_ref[1]**(o-1)+(-0.749140400072)
        ref[5,0,1,0]=o*(0.27081490311)*x_ref[0]**(o-1)+(-0.101642948148)
        ref[5,0,1,1]=o*(0.31847076679)*x_ref[1]**(o-1)+(0.192182993758)
        ref[5,1,0,0]=o*(-0.873348151897)*x_ref[0]**(o-1)+(-0.613499952221)
        ref[5,1,0,1]=o*(0.54087826152)*x_ref[1]**(o-1)+(-0.269096416524)
        ref[5,1,1,0]=o*(-0.803277233859)*x_ref[0]**(o-1)+(-0.714237882827)
        ref[5,1,1,1]=o*(-0.205544031812)*x_ref[1]**(o-1)+(0.188144864673)
      else:
        arg[0,0,0]=(-0.639251981322)*x[0]**o+(-0.115972267818)*x[0]+(0.491134645863)*x[1]**o+(0.345343639029)*x[1]+(-0.663597762251)*x[2]**o+(-0.328150609455)*x[2]
        arg[0,0,1]=(-0.76280151252)*x[0]**o+(0.933789965647)*x[0]+(-0.117386438957)*x[1]**o+(0.738801880577)*x[1]+(-0.823759196233)*x[2]**o+(-0.591225057134)*x[2]
        arg[0,1,0]=(-0.515479158328)*x[0]**o+(-0.498840147412)*x[0]+(-0.07870152457)*x[1]**o+(0.240823897179)*x[1]+(-0.529483054724)*x[2]**o+(0.957444878465)*x[2]
        arg[0,1,1]=(0.659163197783)*x[0]**o+(-0.987017484017)*x[0]+(0.316073196672)*x[1]**o+(-0.858184573568)*x[1]+(-0.324909144593)*x[2]**o+(-0.89624674398)*x[2]
        arg[1,0,0]=(0.582390600104)*x[0]**o+(-0.808724939916)*x[0]+(-0.204186916478)*x[1]**o+(0.63212764696)*x[1]+(-0.272947627588)*x[2]**o+(-0.133369751815)*x[2]
        arg[1,0,1]=(-0.955892141909)*x[0]**o+(0.915832405494)*x[0]+(-0.823428836636)*x[1]**o+(-0.527176552593)*x[1]+(-0.439872810771)*x[2]**o+(0.282431362763)*x[2]
        arg[1,1,0]=(0.269192050139)*x[0]**o+(0.304289733459)*x[0]+(-0.252137123064)*x[1]**o+(0.159346881758)*x[1]+(-0.875713938743)*x[2]**o+(-0.804681982204)*x[2]
        arg[1,1,1]=(0.100159906585)*x[0]**o+(0.652670710888)*x[0]+(-0.0471177296503)*x[1]**o+(0.15344212377)*x[1]+(0.162356023341)*x[2]**o+(0.242855769737)*x[2]
        arg[2,0,0]=(-0.0214334988311)*x[0]**o+(0.444654672491)*x[0]+(0.235478960156)*x[1]**o+(0.62191559883)*x[1]+(0.124531773653)*x[2]**o+(-0.603748942811)*x[2]
        arg[2,0,1]=(-0.00696114124898)*x[0]**o+(-0.350635993795)*x[0]+(0.766513244466)*x[1]**o+(-0.99996024111)*x[1]+(0.976036637033)*x[2]**o+(0.00703160282837)*x[2]
        arg[2,1,0]=(-0.210499708873)*x[0]**o+(-0.763641982769)*x[0]+(0.435435481771)*x[1]**o+(0.0886400511888)*x[1]+(0.540913993886)*x[2]**o+(-0.864904989707)*x[2]
        arg[2,1,1]=(0.609017357846)*x[0]**o+(-0.681305727596)*x[0]+(-0.291763309802)*x[1]**o+(0.12465245807)*x[1]+(-0.265362499082)*x[2]**o+(-0.978509447338)*x[2]
        arg[3,0,0]=(0.622861389608)*x[0]**o+(-0.341108338962)*x[0]+(0.908588438318)*x[1]**o+(-0.583012719535)*x[1]+(0.33513654797)*x[2]**o+(-0.835513934636)*x[2]
        arg[3,0,1]=(0.164841305439)*x[0]**o+(-0.622242302911)*x[0]+(-0.0469305037163)*x[1]**o+(-0.859517953063)*x[1]+(-0.112485630662)*x[2]**o+(0.31475831421)*x[2]
        arg[3,1,0]=(-0.177913851996)*x[0]**o+(0.74607750787)*x[0]+(-0.188838634745)*x[1]**o+(-0.803617744529)*x[1]+(0.18839438068)*x[2]**o+(-0.857696671728)*x[2]
        arg[3,1,1]=(0.485172697497)*x[0]**o+(-0.554750723313)*x[0]+(-0.59838039994)*x[1]**o+(-0.83177053032)*x[1]+(0.655490277067)*x[2]**o+(0.0645924856059)*x[2]
        arg[4,0,0]=(0.900678166492)*x[0]**o+(-0.485573346705)*x[0]+(0.0108149783491)*x[1]**o+(0.982616024342)*x[1]+(-0.374371784319)*x[2]**o+(-0.825014166204)*x[2]
        arg[4,0,1]=(0.682753472393)*x[0]**o+(0.810927347906)*x[0]+(-0.128780174224)*x[1]**o+(0.514607304836)*x[1]+(0.606285011416)*x[2]**o+(-0.691191486471)*x[2]
        arg[4,1,0]=(0.0103661338625)*x[0]**o+(0.184111752707)*x[0]+(-0.270751890504)*x[1]**o+(0.207351712222)*x[1]+(-0.366280871535)*x[2]**o+(-0.638450092731)*x[2]
        arg[4,1,1]=(-0.111302974207)*x[0]**o+(-0.520252159917)*x[0]+(-0.911197545741)*x[1]**o+(-0.779732160528)*x[1]+(-0.443379349795)*x[2]**o+(-0.783540988384)*x[2]
        arg[5,0,0]=(0.319701766792)*x[0]**o+(-0.953929305858)*x[0]+(-0.783942145061)*x[1]**o+(0.687992583635)*x[1]+(0.873868267323)*x[2]**o+(-0.204836707955)*x[2]
        arg[5,0,1]=(-0.240340717622)*x[0]**o+(-0.799598459684)*x[0]+(-0.827096078861)*x[1]**o+(0.229071234102)*x[1]+(0.309197705487)*x[2]**o+(-0.286088934882)*x[2]
        arg[5,1,0]=(-0.0926450319507)*x[0]**o+(0.638985747884)*x[0]+(0.604913216138)*x[1]**o+(-0.364251815312)*x[1]+(-0.47971664069)*x[2]**o+(-0.20655528518)*x[2]
        arg[5,1,1]=(0.418341452333)*x[0]**o+(0.430002851684)*x[0]+(0.624025385599)*x[1]**o+(0.338601201629)*x[1]+(0.0900364406242)*x[2]**o+(0.193533337073)*x[2]
        ref[0,0,0,0]=o*(-0.639251981322)*x_ref[0]**(o-1)+(-0.115972267818)
        ref[0,0,0,1]=o*(0.491134645863)*x_ref[1]**(o-1)+(0.345343639029)
        ref[0,0,0,2]=o*(-0.663597762251)*x_ref[2]**(o-1)+(-0.328150609455)
        ref[0,0,1,0]=o*(-0.76280151252)*x_ref[0]**(o-1)+(0.933789965647)
        ref[0,0,1,1]=o*(-0.117386438957)*x_ref[1]**(o-1)+(0.738801880577)
        ref[0,0,1,2]=o*(-0.823759196233)*x_ref[2]**(o-1)+(-0.591225057134)
        ref[0,1,0,0]=o*(-0.515479158328)*x_ref[0]**(o-1)+(-0.498840147412)
        ref[0,1,0,1]=o*(-0.07870152457)*x_ref[1]**(o-1)+(0.240823897179)
        ref[0,1,0,2]=o*(-0.529483054724)*x_ref[2]**(o-1)+(0.957444878465)
        ref[0,1,1,0]=o*(0.659163197783)*x_ref[0]**(o-1)+(-0.987017484017)
        ref[0,1,1,1]=o*(0.316073196672)*x_ref[1]**(o-1)+(-0.858184573568)
        ref[0,1,1,2]=o*(-0.324909144593)*x_ref[2]**(o-1)+(-0.89624674398)
        ref[1,0,0,0]=o*(0.582390600104)*x_ref[0]**(o-1)+(-0.808724939916)
        ref[1,0,0,1]=o*(-0.204186916478)*x_ref[1]**(o-1)+(0.63212764696)
        ref[1,0,0,2]=o*(-0.272947627588)*x_ref[2]**(o-1)+(-0.133369751815)
        ref[1,0,1,0]=o*(-0.955892141909)*x_ref[0]**(o-1)+(0.915832405494)
        ref[1,0,1,1]=o*(-0.823428836636)*x_ref[1]**(o-1)+(-0.527176552593)
        ref[1,0,1,2]=o*(-0.439872810771)*x_ref[2]**(o-1)+(0.282431362763)
        ref[1,1,0,0]=o*(0.269192050139)*x_ref[0]**(o-1)+(0.304289733459)
        ref[1,1,0,1]=o*(-0.252137123064)*x_ref[1]**(o-1)+(0.159346881758)
        ref[1,1,0,2]=o*(-0.875713938743)*x_ref[2]**(o-1)+(-0.804681982204)
        ref[1,1,1,0]=o*(0.100159906585)*x_ref[0]**(o-1)+(0.652670710888)
        ref[1,1,1,1]=o*(-0.0471177296503)*x_ref[1]**(o-1)+(0.15344212377)
        ref[1,1,1,2]=o*(0.162356023341)*x_ref[2]**(o-1)+(0.242855769737)
        ref[2,0,0,0]=o*(-0.0214334988311)*x_ref[0]**(o-1)+(0.444654672491)
        ref[2,0,0,1]=o*(0.235478960156)*x_ref[1]**(o-1)+(0.62191559883)
        ref[2,0,0,2]=o*(0.124531773653)*x_ref[2]**(o-1)+(-0.603748942811)
        ref[2,0,1,0]=o*(-0.00696114124898)*x_ref[0]**(o-1)+(-0.350635993795)
        ref[2,0,1,1]=o*(0.766513244466)*x_ref[1]**(o-1)+(-0.99996024111)
        ref[2,0,1,2]=o*(0.976036637033)*x_ref[2]**(o-1)+(0.00703160282837)
        ref[2,1,0,0]=o*(-0.210499708873)*x_ref[0]**(o-1)+(-0.763641982769)
        ref[2,1,0,1]=o*(0.435435481771)*x_ref[1]**(o-1)+(0.0886400511888)
        ref[2,1,0,2]=o*(0.540913993886)*x_ref[2]**(o-1)+(-0.864904989707)
        ref[2,1,1,0]=o*(0.609017357846)*x_ref[0]**(o-1)+(-0.681305727596)
        ref[2,1,1,1]=o*(-0.291763309802)*x_ref[1]**(o-1)+(0.12465245807)
        ref[2,1,1,2]=o*(-0.265362499082)*x_ref[2]**(o-1)+(-0.978509447338)
        ref[3,0,0,0]=o*(0.622861389608)*x_ref[0]**(o-1)+(-0.341108338962)
        ref[3,0,0,1]=o*(0.908588438318)*x_ref[1]**(o-1)+(-0.583012719535)
        ref[3,0,0,2]=o*(0.33513654797)*x_ref[2]**(o-1)+(-0.835513934636)
        ref[3,0,1,0]=o*(0.164841305439)*x_ref[0]**(o-1)+(-0.622242302911)
        ref[3,0,1,1]=o*(-0.0469305037163)*x_ref[1]**(o-1)+(-0.859517953063)
        ref[3,0,1,2]=o*(-0.112485630662)*x_ref[2]**(o-1)+(0.31475831421)
        ref[3,1,0,0]=o*(-0.177913851996)*x_ref[0]**(o-1)+(0.74607750787)
        ref[3,1,0,1]=o*(-0.188838634745)*x_ref[1]**(o-1)+(-0.803617744529)
        ref[3,1,0,2]=o*(0.18839438068)*x_ref[2]**(o-1)+(-0.857696671728)
        ref[3,1,1,0]=o*(0.485172697497)*x_ref[0]**(o-1)+(-0.554750723313)
        ref[3,1,1,1]=o*(-0.59838039994)*x_ref[1]**(o-1)+(-0.83177053032)
        ref[3,1,1,2]=o*(0.655490277067)*x_ref[2]**(o-1)+(0.0645924856059)
        ref[4,0,0,0]=o*(0.900678166492)*x_ref[0]**(o-1)+(-0.485573346705)
        ref[4,0,0,1]=o*(0.0108149783491)*x_ref[1]**(o-1)+(0.982616024342)
        ref[4,0,0,2]=o*(-0.374371784319)*x_ref[2]**(o-1)+(-0.825014166204)
        ref[4,0,1,0]=o*(0.682753472393)*x_ref[0]**(o-1)+(0.810927347906)
        ref[4,0,1,1]=o*(-0.128780174224)*x_ref[1]**(o-1)+(0.514607304836)
        ref[4,0,1,2]=o*(0.606285011416)*x_ref[2]**(o-1)+(-0.691191486471)
        ref[4,1,0,0]=o*(0.0103661338625)*x_ref[0]**(o-1)+(0.184111752707)
        ref[4,1,0,1]=o*(-0.270751890504)*x_ref[1]**(o-1)+(0.207351712222)
        ref[4,1,0,2]=o*(-0.366280871535)*x_ref[2]**(o-1)+(-0.638450092731)
        ref[4,1,1,0]=o*(-0.111302974207)*x_ref[0]**(o-1)+(-0.520252159917)
        ref[4,1,1,1]=o*(-0.911197545741)*x_ref[1]**(o-1)+(-0.779732160528)
        ref[4,1,1,2]=o*(-0.443379349795)*x_ref[2]**(o-1)+(-0.783540988384)
        ref[5,0,0,0]=o*(0.319701766792)*x_ref[0]**(o-1)+(-0.953929305858)
        ref[5,0,0,1]=o*(-0.783942145061)*x_ref[1]**(o-1)+(0.687992583635)
        ref[5,0,0,2]=o*(0.873868267323)*x_ref[2]**(o-1)+(-0.204836707955)
        ref[5,0,1,0]=o*(-0.240340717622)*x_ref[0]**(o-1)+(-0.799598459684)
        ref[5,0,1,1]=o*(-0.827096078861)*x_ref[1]**(o-1)+(0.229071234102)
        ref[5,0,1,2]=o*(0.309197705487)*x_ref[2]**(o-1)+(-0.286088934882)
        ref[5,1,0,0]=o*(-0.0926450319507)*x_ref[0]**(o-1)+(0.638985747884)
        ref[5,1,0,1]=o*(0.604913216138)*x_ref[1]**(o-1)+(-0.364251815312)
        ref[5,1,0,2]=o*(-0.47971664069)*x_ref[2]**(o-1)+(-0.20655528518)
        ref[5,1,1,0]=o*(0.418341452333)*x_ref[0]**(o-1)+(0.430002851684)
        ref[5,1,1,1]=o*(0.624025385599)*x_ref[1]**(o-1)+(0.338601201629)
        ref[5,1,1,2]=o*(0.0900364406242)*x_ref[2]**(o-1)+(0.193533337073)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnBoundary_fromData_Solution_rank0(self):
      """
      tests gradient for rank 0 Data on the FunctionOnBoundary

      assumptions: Solution(self.domain) exists
                   self.domain supports gradient on FunctionOnBoundary
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=FunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=Solution(self.domain)
      x=w.getX()
      arg=Data(0,(),w)
      ref=Data(0,()+(dim,),w_ref)
      if dim==2:
        arg=(0.828412007781)*x[0]**o+(0.392494008682)*x[0]+(0.424780018344)*x[1]**o+(-0.75790685259)*x[1]
        ref[0]=o*(0.828412007781)*x_ref[0]**(o-1)+(0.392494008682)
        ref[1]=o*(0.424780018344)*x_ref[1]**(o-1)+(-0.75790685259)
      else:
        arg=(0.0243949626425)*x[0]**o+(0.99040714323)*x[0]+(0.455478130443)*x[1]**o+(-0.917504050554)*x[1]+(-0.642882027126)*x[2]**o+(-0.0751962677977)*x[2]
        ref[0]=o*(0.0243949626425)*x_ref[0]**(o-1)+(0.99040714323)
        ref[1]=o*(0.455478130443)*x_ref[1]**(o-1)+(-0.917504050554)
        ref[2]=o*(-0.642882027126)*x_ref[2]**(o-1)+(-0.0751962677977)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),()+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnBoundary_fromData_Solution_rank1(self):
      """
      tests gradient for rank 1 Data on the FunctionOnBoundary

      assumptions: Solution(self.domain) exists
                   self.domain supports gradient on FunctionOnBoundary
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=FunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=Solution(self.domain)
      x=w.getX()
      arg=Data(0,(2,),w)
      ref=Data(0,(2,)+(dim,),w_ref)
      if dim==2:
        arg[0]=(-0.107613645086)*x[0]**o+(-0.942156383662)*x[0]+(0.294425370324)*x[1]**o+(-0.177019031098)*x[1]
        arg[1]=(-0.120283674295)*x[0]**o+(-0.0644985036825)*x[0]+(-0.818412208612)*x[1]**o+(-0.375335380433)*x[1]
        ref[0,0]=o*(-0.107613645086)*x_ref[0]**(o-1)+(-0.942156383662)
        ref[0,1]=o*(0.294425370324)*x_ref[1]**(o-1)+(-0.177019031098)
        ref[1,0]=o*(-0.120283674295)*x_ref[0]**(o-1)+(-0.0644985036825)
        ref[1,1]=o*(-0.818412208612)*x_ref[1]**(o-1)+(-0.375335380433)
      else:
        arg[0]=(-0.888739890088)*x[0]**o+(0.874877363684)*x[0]+(-0.104101311962)*x[1]**o+(-0.124590333446)*x[1]+(-0.311645832684)*x[2]**o+(-0.249470325769)*x[2]
        arg[1]=(0.680288601947)*x[0]**o+(0.0595361804285)*x[0]+(-0.477099840976)*x[1]**o+(-0.695340106154)*x[1]+(-0.371044873416)*x[2]**o+(-0.442877128189)*x[2]
        ref[0,0]=o*(-0.888739890088)*x_ref[0]**(o-1)+(0.874877363684)
        ref[0,1]=o*(-0.104101311962)*x_ref[1]**(o-1)+(-0.124590333446)
        ref[0,2]=o*(-0.311645832684)*x_ref[2]**(o-1)+(-0.249470325769)
        ref[1,0]=o*(0.680288601947)*x_ref[0]**(o-1)+(0.0595361804285)
        ref[1,1]=o*(-0.477099840976)*x_ref[1]**(o-1)+(-0.695340106154)
        ref[1,2]=o*(-0.371044873416)*x_ref[2]**(o-1)+(-0.442877128189)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnBoundary_fromData_Solution_rank2(self):
      """
      tests gradient for rank 2 Data on the FunctionOnBoundary

      assumptions: Solution(self.domain) exists
                   self.domain supports gradient on FunctionOnBoundary
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=FunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=Solution(self.domain)
      x=w.getX()
      arg=Data(0,(4, 5),w)
      ref=Data(0,(4, 5)+(dim,),w_ref)
      if dim==2:
        arg[0,0]=(0.0237486351119)*x[0]**o+(0.751375149587)*x[0]+(0.0776560601509)*x[1]**o+(-0.363340006998)*x[1]
        arg[0,1]=(0.129612138219)*x[0]**o+(0.377878821946)*x[0]+(0.166470268672)*x[1]**o+(-0.0442064974104)*x[1]
        arg[0,2]=(0.692350462477)*x[0]**o+(-0.439155965586)*x[0]+(0.655583353562)*x[1]**o+(0.3753639938)*x[1]
        arg[0,3]=(-0.909698820615)*x[0]**o+(0.382887632024)*x[0]+(-0.108821308794)*x[1]**o+(0.330111344773)*x[1]
        arg[0,4]=(-0.694552793316)*x[0]**o+(-0.38920298235)*x[0]+(0.174040833682)*x[1]**o+(-0.41756882346)*x[1]
        arg[1,0]=(-0.194901264915)*x[0]**o+(-0.325546767846)*x[0]+(0.507614203136)*x[1]**o+(-0.964255763976)*x[1]
        arg[1,1]=(-0.634480793567)*x[0]**o+(0.787029027123)*x[0]+(-0.067769912764)*x[1]**o+(0.439969554037)*x[1]
        arg[1,2]=(-0.59461925815)*x[0]**o+(-0.799215148911)*x[0]+(-0.286848861016)*x[1]**o+(-0.0274325066994)*x[1]
        arg[1,3]=(0.564664310607)*x[0]**o+(-0.00188717695265)*x[0]+(0.984042638249)*x[1]**o+(-0.524339915306)*x[1]
        arg[1,4]=(-0.673190201485)*x[0]**o+(0.149574403846)*x[0]+(0.667179612419)*x[1]**o+(-0.279377079395)*x[1]
        arg[2,0]=(0.270490028978)*x[0]**o+(0.498901404478)*x[0]+(0.485707956493)*x[1]**o+(-0.340861889384)*x[1]
        arg[2,1]=(-0.785952730285)*x[0]**o+(0.514446635701)*x[0]+(0.925557655147)*x[1]**o+(0.616971745561)*x[1]
        arg[2,2]=(0.788196502068)*x[0]**o+(0.651461860731)*x[0]+(0.160564742956)*x[1]**o+(-0.681831134057)*x[1]
        arg[2,3]=(0.892258488111)*x[0]**o+(0.752252063583)*x[0]+(0.853514779349)*x[1]**o+(-0.181884189513)*x[1]
        arg[2,4]=(-0.824886296933)*x[0]**o+(0.211931432354)*x[0]+(0.924362197939)*x[1]**o+(0.036482432278)*x[1]
        arg[3,0]=(-0.0616004277583)*x[0]**o+(-0.77338193907)*x[0]+(-0.966899521855)*x[1]**o+(-0.395764830291)*x[1]
        arg[3,1]=(-0.607976110595)*x[0]**o+(-0.448875768616)*x[0]+(-0.414034580078)*x[1]**o+(0.185483819416)*x[1]
        arg[3,2]=(-0.918071244524)*x[0]**o+(0.924225885038)*x[0]+(0.418000509852)*x[1]**o+(0.431330768344)*x[1]
        arg[3,3]=(0.897504318738)*x[0]**o+(0.66265738089)*x[0]+(0.720830604485)*x[1]**o+(-0.713433930025)*x[1]
        arg[3,4]=(0.526823069245)*x[0]**o+(-0.255965317744)*x[0]+(-0.326371546564)*x[1]**o+(-0.436881501009)*x[1]
        ref[0,0,0]=o*(0.0237486351119)*x_ref[0]**(o-1)+(0.751375149587)
        ref[0,0,1]=o*(0.0776560601509)*x_ref[1]**(o-1)+(-0.363340006998)
        ref[0,1,0]=o*(0.129612138219)*x_ref[0]**(o-1)+(0.377878821946)
        ref[0,1,1]=o*(0.166470268672)*x_ref[1]**(o-1)+(-0.0442064974104)
        ref[0,2,0]=o*(0.692350462477)*x_ref[0]**(o-1)+(-0.439155965586)
        ref[0,2,1]=o*(0.655583353562)*x_ref[1]**(o-1)+(0.3753639938)
        ref[0,3,0]=o*(-0.909698820615)*x_ref[0]**(o-1)+(0.382887632024)
        ref[0,3,1]=o*(-0.108821308794)*x_ref[1]**(o-1)+(0.330111344773)
        ref[0,4,0]=o*(-0.694552793316)*x_ref[0]**(o-1)+(-0.38920298235)
        ref[0,4,1]=o*(0.174040833682)*x_ref[1]**(o-1)+(-0.41756882346)
        ref[1,0,0]=o*(-0.194901264915)*x_ref[0]**(o-1)+(-0.325546767846)
        ref[1,0,1]=o*(0.507614203136)*x_ref[1]**(o-1)+(-0.964255763976)
        ref[1,1,0]=o*(-0.634480793567)*x_ref[0]**(o-1)+(0.787029027123)
        ref[1,1,1]=o*(-0.067769912764)*x_ref[1]**(o-1)+(0.439969554037)
        ref[1,2,0]=o*(-0.59461925815)*x_ref[0]**(o-1)+(-0.799215148911)
        ref[1,2,1]=o*(-0.286848861016)*x_ref[1]**(o-1)+(-0.0274325066994)
        ref[1,3,0]=o*(0.564664310607)*x_ref[0]**(o-1)+(-0.00188717695265)
        ref[1,3,1]=o*(0.984042638249)*x_ref[1]**(o-1)+(-0.524339915306)
        ref[1,4,0]=o*(-0.673190201485)*x_ref[0]**(o-1)+(0.149574403846)
        ref[1,4,1]=o*(0.667179612419)*x_ref[1]**(o-1)+(-0.279377079395)
        ref[2,0,0]=o*(0.270490028978)*x_ref[0]**(o-1)+(0.498901404478)
        ref[2,0,1]=o*(0.485707956493)*x_ref[1]**(o-1)+(-0.340861889384)
        ref[2,1,0]=o*(-0.785952730285)*x_ref[0]**(o-1)+(0.514446635701)
        ref[2,1,1]=o*(0.925557655147)*x_ref[1]**(o-1)+(0.616971745561)
        ref[2,2,0]=o*(0.788196502068)*x_ref[0]**(o-1)+(0.651461860731)
        ref[2,2,1]=o*(0.160564742956)*x_ref[1]**(o-1)+(-0.681831134057)
        ref[2,3,0]=o*(0.892258488111)*x_ref[0]**(o-1)+(0.752252063583)
        ref[2,3,1]=o*(0.853514779349)*x_ref[1]**(o-1)+(-0.181884189513)
        ref[2,4,0]=o*(-0.824886296933)*x_ref[0]**(o-1)+(0.211931432354)
        ref[2,4,1]=o*(0.924362197939)*x_ref[1]**(o-1)+(0.036482432278)
        ref[3,0,0]=o*(-0.0616004277583)*x_ref[0]**(o-1)+(-0.77338193907)
        ref[3,0,1]=o*(-0.966899521855)*x_ref[1]**(o-1)+(-0.395764830291)
        ref[3,1,0]=o*(-0.607976110595)*x_ref[0]**(o-1)+(-0.448875768616)
        ref[3,1,1]=o*(-0.414034580078)*x_ref[1]**(o-1)+(0.185483819416)
        ref[3,2,0]=o*(-0.918071244524)*x_ref[0]**(o-1)+(0.924225885038)
        ref[3,2,1]=o*(0.418000509852)*x_ref[1]**(o-1)+(0.431330768344)
        ref[3,3,0]=o*(0.897504318738)*x_ref[0]**(o-1)+(0.66265738089)
        ref[3,3,1]=o*(0.720830604485)*x_ref[1]**(o-1)+(-0.713433930025)
        ref[3,4,0]=o*(0.526823069245)*x_ref[0]**(o-1)+(-0.255965317744)
        ref[3,4,1]=o*(-0.326371546564)*x_ref[1]**(o-1)+(-0.436881501009)
      else:
        arg[0,0]=(-0.66471814098)*x[0]**o+(0.417241001417)*x[0]+(-0.228677853733)*x[1]**o+(-0.706946716128)*x[1]+(0.977168565988)*x[2]**o+(-0.0293128613918)*x[2]
        arg[0,1]=(-0.161577085067)*x[0]**o+(0.86957667281)*x[0]+(-0.246783815579)*x[1]**o+(0.495318651008)*x[1]+(-0.500962203485)*x[2]**o+(0.903521194042)*x[2]
        arg[0,2]=(0.0764824142976)*x[0]**o+(-0.0831710166954)*x[0]+(0.538063052387)*x[1]**o+(0.472451075914)*x[1]+(-0.354702552367)*x[2]**o+(-0.820126246007)*x[2]
        arg[0,3]=(-0.286219487301)*x[0]**o+(0.561959250696)*x[0]+(-0.65668352495)*x[1]**o+(-0.276560290133)*x[1]+(-0.500866980002)*x[2]**o+(0.71188245613)*x[2]
        arg[0,4]=(-0.13704169085)*x[0]**o+(0.107954139186)*x[0]+(0.498233399424)*x[1]**o+(-0.201539549426)*x[1]+(-0.889578977028)*x[2]**o+(0.33670078332)*x[2]
        arg[1,0]=(0.411075168668)*x[0]**o+(-0.982783292982)*x[0]+(0.919652087888)*x[1]**o+(0.657917523808)*x[1]+(-0.220747064163)*x[2]**o+(-0.65863499098)*x[2]
        arg[1,1]=(0.978122893048)*x[0]**o+(-0.638310308996)*x[0]+(-0.182955841813)*x[1]**o+(0.386322350256)*x[1]+(0.0238129376001)*x[2]**o+(0.415141411589)*x[2]
        arg[1,2]=(-0.410102590894)*x[0]**o+(-0.0527422034609)*x[0]+(0.218532590216)*x[1]**o+(0.338645963161)*x[1]+(-0.559262295901)*x[2]**o+(0.00154425206109)*x[2]
        arg[1,3]=(-0.509603507286)*x[0]**o+(0.220014659177)*x[0]+(-0.850244819031)*x[1]**o+(0.851103142912)*x[1]+(0.485740207202)*x[2]**o+(0.625073715619)*x[2]
        arg[1,4]=(-0.990056784415)*x[0]**o+(0.822920800823)*x[0]+(-0.310061384265)*x[1]**o+(-0.337394401914)*x[1]+(0.139776472055)*x[2]**o+(0.615477120599)*x[2]
        arg[2,0]=(0.434733128443)*x[0]**o+(-0.23992608444)*x[0]+(0.532847685888)*x[1]**o+(0.641963266518)*x[1]+(-0.421857805771)*x[2]**o+(0.385408885641)*x[2]
        arg[2,1]=(0.502146118236)*x[0]**o+(-0.476835388064)*x[0]+(-0.676891574566)*x[1]**o+(0.713401740075)*x[1]+(0.220183315534)*x[2]**o+(-0.863327755288)*x[2]
        arg[2,2]=(-0.694614904655)*x[0]**o+(-0.881664834998)*x[0]+(0.318605270866)*x[1]**o+(0.55884249433)*x[1]+(0.286031997395)*x[2]**o+(-0.947477517785)*x[2]
        arg[2,3]=(-0.046201338948)*x[0]**o+(-0.316456331808)*x[0]+(0.968975602807)*x[1]**o+(0.549024517551)*x[1]+(-0.473260734234)*x[2]**o+(0.889462696171)*x[2]
        arg[2,4]=(0.316754513953)*x[0]**o+(0.43553288512)*x[0]+(0.962932728727)*x[1]**o+(0.887900662435)*x[1]+(-0.235820939423)*x[2]**o+(0.947057541177)*x[2]
        arg[3,0]=(-0.835914763446)*x[0]**o+(-0.488811438785)*x[0]+(-0.573283060197)*x[1]**o+(0.963078263225)*x[1]+(0.601345307969)*x[2]**o+(-0.185658285596)*x[2]
        arg[3,1]=(0.597606596118)*x[0]**o+(0.0839878651552)*x[0]+(0.0836232765815)*x[1]**o+(0.594866612681)*x[1]+(-0.361174348867)*x[2]**o+(0.701364726038)*x[2]
        arg[3,2]=(-0.172328462662)*x[0]**o+(-0.856154059105)*x[0]+(0.533657669403)*x[1]**o+(-0.305657234912)*x[1]+(0.828787414246)*x[2]**o+(0.993286809537)*x[2]
        arg[3,3]=(0.181845363409)*x[0]**o+(0.184210025662)*x[0]+(-0.538269933964)*x[1]**o+(0.731384195858)*x[1]+(0.900272670238)*x[2]**o+(-0.152731605913)*x[2]
        arg[3,4]=(0.812640675362)*x[0]**o+(-0.330495179989)*x[0]+(0.455533774723)*x[1]**o+(0.32100819695)*x[1]+(-0.332730198093)*x[2]**o+(-0.692589097458)*x[2]
        ref[0,0,0]=o*(-0.66471814098)*x_ref[0]**(o-1)+(0.417241001417)
        ref[0,0,1]=o*(-0.228677853733)*x_ref[1]**(o-1)+(-0.706946716128)
        ref[0,0,2]=o*(0.977168565988)*x_ref[2]**(o-1)+(-0.0293128613918)
        ref[0,1,0]=o*(-0.161577085067)*x_ref[0]**(o-1)+(0.86957667281)
        ref[0,1,1]=o*(-0.246783815579)*x_ref[1]**(o-1)+(0.495318651008)
        ref[0,1,2]=o*(-0.500962203485)*x_ref[2]**(o-1)+(0.903521194042)
        ref[0,2,0]=o*(0.0764824142976)*x_ref[0]**(o-1)+(-0.0831710166954)
        ref[0,2,1]=o*(0.538063052387)*x_ref[1]**(o-1)+(0.472451075914)
        ref[0,2,2]=o*(-0.354702552367)*x_ref[2]**(o-1)+(-0.820126246007)
        ref[0,3,0]=o*(-0.286219487301)*x_ref[0]**(o-1)+(0.561959250696)
        ref[0,3,1]=o*(-0.65668352495)*x_ref[1]**(o-1)+(-0.276560290133)
        ref[0,3,2]=o*(-0.500866980002)*x_ref[2]**(o-1)+(0.71188245613)
        ref[0,4,0]=o*(-0.13704169085)*x_ref[0]**(o-1)+(0.107954139186)
        ref[0,4,1]=o*(0.498233399424)*x_ref[1]**(o-1)+(-0.201539549426)
        ref[0,4,2]=o*(-0.889578977028)*x_ref[2]**(o-1)+(0.33670078332)
        ref[1,0,0]=o*(0.411075168668)*x_ref[0]**(o-1)+(-0.982783292982)
        ref[1,0,1]=o*(0.919652087888)*x_ref[1]**(o-1)+(0.657917523808)
        ref[1,0,2]=o*(-0.220747064163)*x_ref[2]**(o-1)+(-0.65863499098)
        ref[1,1,0]=o*(0.978122893048)*x_ref[0]**(o-1)+(-0.638310308996)
        ref[1,1,1]=o*(-0.182955841813)*x_ref[1]**(o-1)+(0.386322350256)
        ref[1,1,2]=o*(0.0238129376001)*x_ref[2]**(o-1)+(0.415141411589)
        ref[1,2,0]=o*(-0.410102590894)*x_ref[0]**(o-1)+(-0.0527422034609)
        ref[1,2,1]=o*(0.218532590216)*x_ref[1]**(o-1)+(0.338645963161)
        ref[1,2,2]=o*(-0.559262295901)*x_ref[2]**(o-1)+(0.00154425206109)
        ref[1,3,0]=o*(-0.509603507286)*x_ref[0]**(o-1)+(0.220014659177)
        ref[1,3,1]=o*(-0.850244819031)*x_ref[1]**(o-1)+(0.851103142912)
        ref[1,3,2]=o*(0.485740207202)*x_ref[2]**(o-1)+(0.625073715619)
        ref[1,4,0]=o*(-0.990056784415)*x_ref[0]**(o-1)+(0.822920800823)
        ref[1,4,1]=o*(-0.310061384265)*x_ref[1]**(o-1)+(-0.337394401914)
        ref[1,4,2]=o*(0.139776472055)*x_ref[2]**(o-1)+(0.615477120599)
        ref[2,0,0]=o*(0.434733128443)*x_ref[0]**(o-1)+(-0.23992608444)
        ref[2,0,1]=o*(0.532847685888)*x_ref[1]**(o-1)+(0.641963266518)
        ref[2,0,2]=o*(-0.421857805771)*x_ref[2]**(o-1)+(0.385408885641)
        ref[2,1,0]=o*(0.502146118236)*x_ref[0]**(o-1)+(-0.476835388064)
        ref[2,1,1]=o*(-0.676891574566)*x_ref[1]**(o-1)+(0.713401740075)
        ref[2,1,2]=o*(0.220183315534)*x_ref[2]**(o-1)+(-0.863327755288)
        ref[2,2,0]=o*(-0.694614904655)*x_ref[0]**(o-1)+(-0.881664834998)
        ref[2,2,1]=o*(0.318605270866)*x_ref[1]**(o-1)+(0.55884249433)
        ref[2,2,2]=o*(0.286031997395)*x_ref[2]**(o-1)+(-0.947477517785)
        ref[2,3,0]=o*(-0.046201338948)*x_ref[0]**(o-1)+(-0.316456331808)
        ref[2,3,1]=o*(0.968975602807)*x_ref[1]**(o-1)+(0.549024517551)
        ref[2,3,2]=o*(-0.473260734234)*x_ref[2]**(o-1)+(0.889462696171)
        ref[2,4,0]=o*(0.316754513953)*x_ref[0]**(o-1)+(0.43553288512)
        ref[2,4,1]=o*(0.962932728727)*x_ref[1]**(o-1)+(0.887900662435)
        ref[2,4,2]=o*(-0.235820939423)*x_ref[2]**(o-1)+(0.947057541177)
        ref[3,0,0]=o*(-0.835914763446)*x_ref[0]**(o-1)+(-0.488811438785)
        ref[3,0,1]=o*(-0.573283060197)*x_ref[1]**(o-1)+(0.963078263225)
        ref[3,0,2]=o*(0.601345307969)*x_ref[2]**(o-1)+(-0.185658285596)
        ref[3,1,0]=o*(0.597606596118)*x_ref[0]**(o-1)+(0.0839878651552)
        ref[3,1,1]=o*(0.0836232765815)*x_ref[1]**(o-1)+(0.594866612681)
        ref[3,1,2]=o*(-0.361174348867)*x_ref[2]**(o-1)+(0.701364726038)
        ref[3,2,0]=o*(-0.172328462662)*x_ref[0]**(o-1)+(-0.856154059105)
        ref[3,2,1]=o*(0.533657669403)*x_ref[1]**(o-1)+(-0.305657234912)
        ref[3,2,2]=o*(0.828787414246)*x_ref[2]**(o-1)+(0.993286809537)
        ref[3,3,0]=o*(0.181845363409)*x_ref[0]**(o-1)+(0.184210025662)
        ref[3,3,1]=o*(-0.538269933964)*x_ref[1]**(o-1)+(0.731384195858)
        ref[3,3,2]=o*(0.900272670238)*x_ref[2]**(o-1)+(-0.152731605913)
        ref[3,4,0]=o*(0.812640675362)*x_ref[0]**(o-1)+(-0.330495179989)
        ref[3,4,1]=o*(0.455533774723)*x_ref[1]**(o-1)+(0.32100819695)
        ref[3,4,2]=o*(-0.332730198093)*x_ref[2]**(o-1)+(-0.692589097458)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnBoundary_fromData_Solution_rank3(self):
      """
      tests gradient for rank 3 Data on the FunctionOnBoundary

      assumptions: Solution(self.domain) exists
                   self.domain supports gradient on FunctionOnBoundary
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=FunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=Solution(self.domain)
      x=w.getX()
      arg=Data(0,(6, 2, 2),w)
      ref=Data(0,(6, 2, 2)+(dim,),w_ref)
      if dim==2:
        arg[0,0,0]=(0.253396883727)*x[0]**o+(0.491235248599)*x[0]+(-0.468734602938)*x[1]**o+(0.730479725967)*x[1]
        arg[0,0,1]=(0.344036208598)*x[0]**o+(-0.394302857752)*x[0]+(-0.608765577652)*x[1]**o+(-0.564065946953)*x[1]
        arg[0,1,0]=(-0.84520693538)*x[0]**o+(0.934285247148)*x[0]+(0.0841237910789)*x[1]**o+(0.455488803423)*x[1]
        arg[0,1,1]=(0.484027534363)*x[0]**o+(-0.374633264234)*x[0]+(-0.0665482018417)*x[1]**o+(0.528984445833)*x[1]
        arg[1,0,0]=(-0.470188044426)*x[0]**o+(-0.328178128746)*x[0]+(0.67571857307)*x[1]**o+(0.116985630247)*x[1]
        arg[1,0,1]=(0.986586449605)*x[0]**o+(-0.25691197068)*x[0]+(0.755235660838)*x[1]**o+(0.211004338524)*x[1]
        arg[1,1,0]=(-0.569322712396)*x[0]**o+(0.900009729013)*x[0]+(0.748881276361)*x[1]**o+(0.850464087662)*x[1]
        arg[1,1,1]=(0.625042758036)*x[0]**o+(-0.72757111333)*x[0]+(-0.986053078492)*x[1]**o+(-0.633517003425)*x[1]
        arg[2,0,0]=(-0.716192724085)*x[0]**o+(-0.23327162426)*x[0]+(0.206440629344)*x[1]**o+(0.816324161671)*x[1]
        arg[2,0,1]=(-0.803679553386)*x[0]**o+(0.445433027195)*x[0]+(-0.111465589792)*x[1]**o+(-0.109772986088)*x[1]
        arg[2,1,0]=(0.374386571048)*x[0]**o+(-0.317187375606)*x[0]+(0.133248401591)*x[1]**o+(-0.971347533424)*x[1]
        arg[2,1,1]=(-0.48476474399)*x[0]**o+(0.979379654323)*x[0]+(0.371437992948)*x[1]**o+(-0.110228097225)*x[1]
        arg[3,0,0]=(0.37507701433)*x[0]**o+(0.451375135714)*x[0]+(0.228204578568)*x[1]**o+(0.0935454426192)*x[1]
        arg[3,0,1]=(-0.322375030256)*x[0]**o+(-0.0412650889525)*x[0]+(0.23495348361)*x[1]**o+(-0.704960519241)*x[1]
        arg[3,1,0]=(-0.478413043796)*x[0]**o+(0.373637701709)*x[0]+(0.346845166424)*x[1]**o+(0.00492075723836)*x[1]
        arg[3,1,1]=(0.0753795682919)*x[0]**o+(0.51446748543)*x[0]+(-0.337079735899)*x[1]**o+(0.976335320865)*x[1]
        arg[4,0,0]=(0.173293972121)*x[0]**o+(0.78972296986)*x[0]+(-0.518624390388)*x[1]**o+(-0.587962330417)*x[1]
        arg[4,0,1]=(0.747393467297)*x[0]**o+(0.940132823774)*x[0]+(-0.292996377712)*x[1]**o+(0.980334604245)*x[1]
        arg[4,1,0]=(-0.836497499117)*x[0]**o+(0.625161912911)*x[0]+(0.978929091652)*x[1]**o+(-0.676430396031)*x[1]
        arg[4,1,1]=(-0.195907406253)*x[0]**o+(-0.388427741642)*x[0]+(0.233500679929)*x[1]**o+(0.535047073421)*x[1]
        arg[5,0,0]=(0.983591245443)*x[0]**o+(-0.356589240979)*x[0]+(0.328974933764)*x[1]**o+(-0.875152262477)*x[1]
        arg[5,0,1]=(0.901430256705)*x[0]**o+(0.74247442514)*x[0]+(0.189211012786)*x[1]**o+(0.930520401277)*x[1]
        arg[5,1,0]=(-0.319591878243)*x[0]**o+(0.174836571432)*x[0]+(0.953875085784)*x[1]**o+(-0.51684941838)*x[1]
        arg[5,1,1]=(-0.916869714992)*x[0]**o+(0.121572609124)*x[0]+(0.791850838139)*x[1]**o+(-0.588663035087)*x[1]
        ref[0,0,0,0]=o*(0.253396883727)*x_ref[0]**(o-1)+(0.491235248599)
        ref[0,0,0,1]=o*(-0.468734602938)*x_ref[1]**(o-1)+(0.730479725967)
        ref[0,0,1,0]=o*(0.344036208598)*x_ref[0]**(o-1)+(-0.394302857752)
        ref[0,0,1,1]=o*(-0.608765577652)*x_ref[1]**(o-1)+(-0.564065946953)
        ref[0,1,0,0]=o*(-0.84520693538)*x_ref[0]**(o-1)+(0.934285247148)
        ref[0,1,0,1]=o*(0.0841237910789)*x_ref[1]**(o-1)+(0.455488803423)
        ref[0,1,1,0]=o*(0.484027534363)*x_ref[0]**(o-1)+(-0.374633264234)
        ref[0,1,1,1]=o*(-0.0665482018417)*x_ref[1]**(o-1)+(0.528984445833)
        ref[1,0,0,0]=o*(-0.470188044426)*x_ref[0]**(o-1)+(-0.328178128746)
        ref[1,0,0,1]=o*(0.67571857307)*x_ref[1]**(o-1)+(0.116985630247)
        ref[1,0,1,0]=o*(0.986586449605)*x_ref[0]**(o-1)+(-0.25691197068)
        ref[1,0,1,1]=o*(0.755235660838)*x_ref[1]**(o-1)+(0.211004338524)
        ref[1,1,0,0]=o*(-0.569322712396)*x_ref[0]**(o-1)+(0.900009729013)
        ref[1,1,0,1]=o*(0.748881276361)*x_ref[1]**(o-1)+(0.850464087662)
        ref[1,1,1,0]=o*(0.625042758036)*x_ref[0]**(o-1)+(-0.72757111333)
        ref[1,1,1,1]=o*(-0.986053078492)*x_ref[1]**(o-1)+(-0.633517003425)
        ref[2,0,0,0]=o*(-0.716192724085)*x_ref[0]**(o-1)+(-0.23327162426)
        ref[2,0,0,1]=o*(0.206440629344)*x_ref[1]**(o-1)+(0.816324161671)
        ref[2,0,1,0]=o*(-0.803679553386)*x_ref[0]**(o-1)+(0.445433027195)
        ref[2,0,1,1]=o*(-0.111465589792)*x_ref[1]**(o-1)+(-0.109772986088)
        ref[2,1,0,0]=o*(0.374386571048)*x_ref[0]**(o-1)+(-0.317187375606)
        ref[2,1,0,1]=o*(0.133248401591)*x_ref[1]**(o-1)+(-0.971347533424)
        ref[2,1,1,0]=o*(-0.48476474399)*x_ref[0]**(o-1)+(0.979379654323)
        ref[2,1,1,1]=o*(0.371437992948)*x_ref[1]**(o-1)+(-0.110228097225)
        ref[3,0,0,0]=o*(0.37507701433)*x_ref[0]**(o-1)+(0.451375135714)
        ref[3,0,0,1]=o*(0.228204578568)*x_ref[1]**(o-1)+(0.0935454426192)
        ref[3,0,1,0]=o*(-0.322375030256)*x_ref[0]**(o-1)+(-0.0412650889525)
        ref[3,0,1,1]=o*(0.23495348361)*x_ref[1]**(o-1)+(-0.704960519241)
        ref[3,1,0,0]=o*(-0.478413043796)*x_ref[0]**(o-1)+(0.373637701709)
        ref[3,1,0,1]=o*(0.346845166424)*x_ref[1]**(o-1)+(0.00492075723836)
        ref[3,1,1,0]=o*(0.0753795682919)*x_ref[0]**(o-1)+(0.51446748543)
        ref[3,1,1,1]=o*(-0.337079735899)*x_ref[1]**(o-1)+(0.976335320865)
        ref[4,0,0,0]=o*(0.173293972121)*x_ref[0]**(o-1)+(0.78972296986)
        ref[4,0,0,1]=o*(-0.518624390388)*x_ref[1]**(o-1)+(-0.587962330417)
        ref[4,0,1,0]=o*(0.747393467297)*x_ref[0]**(o-1)+(0.940132823774)
        ref[4,0,1,1]=o*(-0.292996377712)*x_ref[1]**(o-1)+(0.980334604245)
        ref[4,1,0,0]=o*(-0.836497499117)*x_ref[0]**(o-1)+(0.625161912911)
        ref[4,1,0,1]=o*(0.978929091652)*x_ref[1]**(o-1)+(-0.676430396031)
        ref[4,1,1,0]=o*(-0.195907406253)*x_ref[0]**(o-1)+(-0.388427741642)
        ref[4,1,1,1]=o*(0.233500679929)*x_ref[1]**(o-1)+(0.535047073421)
        ref[5,0,0,0]=o*(0.983591245443)*x_ref[0]**(o-1)+(-0.356589240979)
        ref[5,0,0,1]=o*(0.328974933764)*x_ref[1]**(o-1)+(-0.875152262477)
        ref[5,0,1,0]=o*(0.901430256705)*x_ref[0]**(o-1)+(0.74247442514)
        ref[5,0,1,1]=o*(0.189211012786)*x_ref[1]**(o-1)+(0.930520401277)
        ref[5,1,0,0]=o*(-0.319591878243)*x_ref[0]**(o-1)+(0.174836571432)
        ref[5,1,0,1]=o*(0.953875085784)*x_ref[1]**(o-1)+(-0.51684941838)
        ref[5,1,1,0]=o*(-0.916869714992)*x_ref[0]**(o-1)+(0.121572609124)
        ref[5,1,1,1]=o*(0.791850838139)*x_ref[1]**(o-1)+(-0.588663035087)
      else:
        arg[0,0,0]=(-0.513971266383)*x[0]**o+(-0.117127749421)*x[0]+(-0.551292004692)*x[1]**o+(-0.268920693702)*x[1]+(0.0872538366694)*x[2]**o+(0.855491592762)*x[2]
        arg[0,0,1]=(0.156425207213)*x[0]**o+(-0.299808724719)*x[0]+(0.827383156334)*x[1]**o+(-0.594506082498)*x[1]+(-0.289589281068)*x[2]**o+(0.559159349352)*x[2]
        arg[0,1,0]=(-0.925822763448)*x[0]**o+(0.518052108584)*x[0]+(-0.774761536373)*x[1]**o+(-0.0329613155479)*x[1]+(0.957805160206)*x[2]**o+(0.0606445544683)*x[2]
        arg[0,1,1]=(-0.337663244379)*x[0]**o+(-0.634947360886)*x[0]+(0.232117517887)*x[1]**o+(-0.534317817241)*x[1]+(0.554880796818)*x[2]**o+(-0.3101266685)*x[2]
        arg[1,0,0]=(-0.888548906608)*x[0]**o+(0.517747675888)*x[0]+(-0.614381113253)*x[1]**o+(-0.757891891198)*x[1]+(0.618261909378)*x[2]**o+(-0.0853347346644)*x[2]
        arg[1,0,1]=(-0.686920109418)*x[0]**o+(0.000673193523604)*x[0]+(0.251800447271)*x[1]**o+(-0.105619412646)*x[1]+(0.00990847148242)*x[2]**o+(0.861798595402)*x[2]
        arg[1,1,0]=(0.170484209485)*x[0]**o+(-0.620257643847)*x[0]+(0.057743430303)*x[1]**o+(0.0640298192279)*x[1]+(0.0757100493935)*x[2]**o+(-0.414863410391)*x[2]
        arg[1,1,1]=(-0.714807290039)*x[0]**o+(-0.562420622765)*x[0]+(0.788769732877)*x[1]**o+(-0.472413621829)*x[1]+(-0.466159435785)*x[2]**o+(-0.476510555737)*x[2]
        arg[2,0,0]=(0.875340499144)*x[0]**o+(-0.598283854175)*x[0]+(0.206593884126)*x[1]**o+(-0.987568956833)*x[1]+(0.666527095968)*x[2]**o+(-0.352753155564)*x[2]
        arg[2,0,1]=(0.677005187408)*x[0]**o+(0.760176905882)*x[0]+(-0.0863648949101)*x[1]**o+(-0.607384058071)*x[1]+(-0.117434466077)*x[2]**o+(-0.670292588633)*x[2]
        arg[2,1,0]=(0.888629811684)*x[0]**o+(0.35826389662)*x[0]+(0.00390435387028)*x[1]**o+(-0.0937518531166)*x[1]+(-0.365569888759)*x[2]**o+(0.380035526283)*x[2]
        arg[2,1,1]=(0.138275666033)*x[0]**o+(-0.437710809963)*x[0]+(0.773451227027)*x[1]**o+(0.834016138485)*x[1]+(0.847339165612)*x[2]**o+(-0.417687340903)*x[2]
        arg[3,0,0]=(-0.298714836243)*x[0]**o+(-0.268961434956)*x[0]+(0.232096942083)*x[1]**o+(-0.455570990604)*x[1]+(-0.294542554349)*x[2]**o+(-0.37112817156)*x[2]
        arg[3,0,1]=(0.0903365333358)*x[0]**o+(0.338265717129)*x[0]+(-0.755237281599)*x[1]**o+(-0.608535543682)*x[1]+(0.812136572153)*x[2]**o+(-0.146674314466)*x[2]
        arg[3,1,0]=(0.159422014459)*x[0]**o+(0.899761817668)*x[0]+(0.467507279621)*x[1]**o+(0.47028740641)*x[1]+(-0.905453092566)*x[2]**o+(0.325443171334)*x[2]
        arg[3,1,1]=(0.706113787474)*x[0]**o+(0.411358047385)*x[0]+(0.710178001185)*x[1]**o+(-0.248170072927)*x[1]+(0.2228478152)*x[2]**o+(-0.6845238748)*x[2]
        arg[4,0,0]=(-0.810987300482)*x[0]**o+(-0.20061683347)*x[0]+(-0.362480203096)*x[1]**o+(0.23493442788)*x[1]+(-0.0262576869803)*x[2]**o+(0.40114062378)*x[2]
        arg[4,0,1]=(-0.0377982138529)*x[0]**o+(-0.844585963856)*x[0]+(-0.94360590097)*x[1]**o+(-0.775666510211)*x[1]+(-0.484314539768)*x[2]**o+(0.472661289406)*x[2]
        arg[4,1,0]=(0.579937359489)*x[0]**o+(0.384020744083)*x[0]+(-0.303096661906)*x[1]**o+(-0.0640353004314)*x[1]+(0.693425296881)*x[2]**o+(0.410980796125)*x[2]
        arg[4,1,1]=(0.152139667717)*x[0]**o+(-0.49610371397)*x[0]+(-0.884008900347)*x[1]**o+(-0.364570486388)*x[1]+(0.126918854811)*x[2]**o+(0.409453971802)*x[2]
        arg[5,0,0]=(0.409834559571)*x[0]**o+(-0.347724104753)*x[0]+(-0.263327417846)*x[1]**o+(0.18147743546)*x[1]+(-0.399848371177)*x[2]**o+(0.928317631431)*x[2]
        arg[5,0,1]=(-0.686702422025)*x[0]**o+(-0.918530462662)*x[0]+(0.478936304167)*x[1]**o+(-0.641691106861)*x[1]+(-0.582780732375)*x[2]**o+(0.30255037752)*x[2]
        arg[5,1,0]=(0.50568688101)*x[0]**o+(0.378682510558)*x[0]+(0.59801824354)*x[1]**o+(-0.316028163905)*x[1]+(-0.554966057648)*x[2]**o+(0.637313154931)*x[2]
        arg[5,1,1]=(0.300318472719)*x[0]**o+(-0.794010312167)*x[0]+(-0.314402790698)*x[1]**o+(0.991870648498)*x[1]+(0.949603731589)*x[2]**o+(-0.302054056398)*x[2]
        ref[0,0,0,0]=o*(-0.513971266383)*x_ref[0]**(o-1)+(-0.117127749421)
        ref[0,0,0,1]=o*(-0.551292004692)*x_ref[1]**(o-1)+(-0.268920693702)
        ref[0,0,0,2]=o*(0.0872538366694)*x_ref[2]**(o-1)+(0.855491592762)
        ref[0,0,1,0]=o*(0.156425207213)*x_ref[0]**(o-1)+(-0.299808724719)
        ref[0,0,1,1]=o*(0.827383156334)*x_ref[1]**(o-1)+(-0.594506082498)
        ref[0,0,1,2]=o*(-0.289589281068)*x_ref[2]**(o-1)+(0.559159349352)
        ref[0,1,0,0]=o*(-0.925822763448)*x_ref[0]**(o-1)+(0.518052108584)
        ref[0,1,0,1]=o*(-0.774761536373)*x_ref[1]**(o-1)+(-0.0329613155479)
        ref[0,1,0,2]=o*(0.957805160206)*x_ref[2]**(o-1)+(0.0606445544683)
        ref[0,1,1,0]=o*(-0.337663244379)*x_ref[0]**(o-1)+(-0.634947360886)
        ref[0,1,1,1]=o*(0.232117517887)*x_ref[1]**(o-1)+(-0.534317817241)
        ref[0,1,1,2]=o*(0.554880796818)*x_ref[2]**(o-1)+(-0.3101266685)
        ref[1,0,0,0]=o*(-0.888548906608)*x_ref[0]**(o-1)+(0.517747675888)
        ref[1,0,0,1]=o*(-0.614381113253)*x_ref[1]**(o-1)+(-0.757891891198)
        ref[1,0,0,2]=o*(0.618261909378)*x_ref[2]**(o-1)+(-0.0853347346644)
        ref[1,0,1,0]=o*(-0.686920109418)*x_ref[0]**(o-1)+(0.000673193523604)
        ref[1,0,1,1]=o*(0.251800447271)*x_ref[1]**(o-1)+(-0.105619412646)
        ref[1,0,1,2]=o*(0.00990847148242)*x_ref[2]**(o-1)+(0.861798595402)
        ref[1,1,0,0]=o*(0.170484209485)*x_ref[0]**(o-1)+(-0.620257643847)
        ref[1,1,0,1]=o*(0.057743430303)*x_ref[1]**(o-1)+(0.0640298192279)
        ref[1,1,0,2]=o*(0.0757100493935)*x_ref[2]**(o-1)+(-0.414863410391)
        ref[1,1,1,0]=o*(-0.714807290039)*x_ref[0]**(o-1)+(-0.562420622765)
        ref[1,1,1,1]=o*(0.788769732877)*x_ref[1]**(o-1)+(-0.472413621829)
        ref[1,1,1,2]=o*(-0.466159435785)*x_ref[2]**(o-1)+(-0.476510555737)
        ref[2,0,0,0]=o*(0.875340499144)*x_ref[0]**(o-1)+(-0.598283854175)
        ref[2,0,0,1]=o*(0.206593884126)*x_ref[1]**(o-1)+(-0.987568956833)
        ref[2,0,0,2]=o*(0.666527095968)*x_ref[2]**(o-1)+(-0.352753155564)
        ref[2,0,1,0]=o*(0.677005187408)*x_ref[0]**(o-1)+(0.760176905882)
        ref[2,0,1,1]=o*(-0.0863648949101)*x_ref[1]**(o-1)+(-0.607384058071)
        ref[2,0,1,2]=o*(-0.117434466077)*x_ref[2]**(o-1)+(-0.670292588633)
        ref[2,1,0,0]=o*(0.888629811684)*x_ref[0]**(o-1)+(0.35826389662)
        ref[2,1,0,1]=o*(0.00390435387028)*x_ref[1]**(o-1)+(-0.0937518531166)
        ref[2,1,0,2]=o*(-0.365569888759)*x_ref[2]**(o-1)+(0.380035526283)
        ref[2,1,1,0]=o*(0.138275666033)*x_ref[0]**(o-1)+(-0.437710809963)
        ref[2,1,1,1]=o*(0.773451227027)*x_ref[1]**(o-1)+(0.834016138485)
        ref[2,1,1,2]=o*(0.847339165612)*x_ref[2]**(o-1)+(-0.417687340903)
        ref[3,0,0,0]=o*(-0.298714836243)*x_ref[0]**(o-1)+(-0.268961434956)
        ref[3,0,0,1]=o*(0.232096942083)*x_ref[1]**(o-1)+(-0.455570990604)
        ref[3,0,0,2]=o*(-0.294542554349)*x_ref[2]**(o-1)+(-0.37112817156)
        ref[3,0,1,0]=o*(0.0903365333358)*x_ref[0]**(o-1)+(0.338265717129)
        ref[3,0,1,1]=o*(-0.755237281599)*x_ref[1]**(o-1)+(-0.608535543682)
        ref[3,0,1,2]=o*(0.812136572153)*x_ref[2]**(o-1)+(-0.146674314466)
        ref[3,1,0,0]=o*(0.159422014459)*x_ref[0]**(o-1)+(0.899761817668)
        ref[3,1,0,1]=o*(0.467507279621)*x_ref[1]**(o-1)+(0.47028740641)
        ref[3,1,0,2]=o*(-0.905453092566)*x_ref[2]**(o-1)+(0.325443171334)
        ref[3,1,1,0]=o*(0.706113787474)*x_ref[0]**(o-1)+(0.411358047385)
        ref[3,1,1,1]=o*(0.710178001185)*x_ref[1]**(o-1)+(-0.248170072927)
        ref[3,1,1,2]=o*(0.2228478152)*x_ref[2]**(o-1)+(-0.6845238748)
        ref[4,0,0,0]=o*(-0.810987300482)*x_ref[0]**(o-1)+(-0.20061683347)
        ref[4,0,0,1]=o*(-0.362480203096)*x_ref[1]**(o-1)+(0.23493442788)
        ref[4,0,0,2]=o*(-0.0262576869803)*x_ref[2]**(o-1)+(0.40114062378)
        ref[4,0,1,0]=o*(-0.0377982138529)*x_ref[0]**(o-1)+(-0.844585963856)
        ref[4,0,1,1]=o*(-0.94360590097)*x_ref[1]**(o-1)+(-0.775666510211)
        ref[4,0,1,2]=o*(-0.484314539768)*x_ref[2]**(o-1)+(0.472661289406)
        ref[4,1,0,0]=o*(0.579937359489)*x_ref[0]**(o-1)+(0.384020744083)
        ref[4,1,0,1]=o*(-0.303096661906)*x_ref[1]**(o-1)+(-0.0640353004314)
        ref[4,1,0,2]=o*(0.693425296881)*x_ref[2]**(o-1)+(0.410980796125)
        ref[4,1,1,0]=o*(0.152139667717)*x_ref[0]**(o-1)+(-0.49610371397)
        ref[4,1,1,1]=o*(-0.884008900347)*x_ref[1]**(o-1)+(-0.364570486388)
        ref[4,1,1,2]=o*(0.126918854811)*x_ref[2]**(o-1)+(0.409453971802)
        ref[5,0,0,0]=o*(0.409834559571)*x_ref[0]**(o-1)+(-0.347724104753)
        ref[5,0,0,1]=o*(-0.263327417846)*x_ref[1]**(o-1)+(0.18147743546)
        ref[5,0,0,2]=o*(-0.399848371177)*x_ref[2]**(o-1)+(0.928317631431)
        ref[5,0,1,0]=o*(-0.686702422025)*x_ref[0]**(o-1)+(-0.918530462662)
        ref[5,0,1,1]=o*(0.478936304167)*x_ref[1]**(o-1)+(-0.641691106861)
        ref[5,0,1,2]=o*(-0.582780732375)*x_ref[2]**(o-1)+(0.30255037752)
        ref[5,1,0,0]=o*(0.50568688101)*x_ref[0]**(o-1)+(0.378682510558)
        ref[5,1,0,1]=o*(0.59801824354)*x_ref[1]**(o-1)+(-0.316028163905)
        ref[5,1,0,2]=o*(-0.554966057648)*x_ref[2]**(o-1)+(0.637313154931)
        ref[5,1,1,0]=o*(0.300318472719)*x_ref[0]**(o-1)+(-0.794010312167)
        ref[5,1,1,1]=o*(-0.314402790698)*x_ref[1]**(o-1)+(0.991870648498)
        ref[5,1,1,2]=o*(0.949603731589)*x_ref[2]**(o-1)+(-0.302054056398)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnBoundary_fromData_ReducedSolution_rank0(self):
      """
      tests gradient for rank 0 Data on the FunctionOnBoundary

      assumptions: ReducedSolution(self.domain) exists
                   self.domain supports gradient on FunctionOnBoundary
      """
      o=1
      dim=self.domain.getDim()
      w_ref=FunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=ReducedSolution(self.domain)
      x=w.getX()
      arg=Data(0,(),w)
      ref=Data(0,()+(dim,),w_ref)
      if dim==2:
        arg=(0.306947418999)*x[0]+(-0.706616694784)*x[1]
        ref[0]=(0.306947418999)
        ref[1]=(-0.706616694784)
      else:
        arg=(0.490435692707)*x[0]+(0.929248719763)*x[1]+(0.269868131113)*x[2]
        ref[0]=(0.490435692707)
        ref[1]=(0.929248719763)
        ref[2]=(0.269868131113)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),()+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnBoundary_fromData_ReducedSolution_rank1(self):
      """
      tests gradient for rank 1 Data on the FunctionOnBoundary

      assumptions: ReducedSolution(self.domain) exists
                   self.domain supports gradient on FunctionOnBoundary
      """
      o=1
      dim=self.domain.getDim()
      w_ref=FunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=ReducedSolution(self.domain)
      x=w.getX()
      arg=Data(0,(2,),w)
      ref=Data(0,(2,)+(dim,),w_ref)
      if dim==2:
        arg[0]=(-0.882633673888)*x[0]+(-0.790592442848)*x[1]
        arg[1]=(1.55495669126)*x[0]+(0.496011926182)*x[1]
        ref[0,0]=(-0.882633673888)
        ref[0,1]=(-0.790592442848)
        ref[1,0]=(1.55495669126)
        ref[1,1]=(0.496011926182)
      else:
        arg[0]=(0.683098278161)*x[0]+(-0.151590511238)*x[1]+(0.54461031868)*x[2]
        arg[1]=(0.59998040214)*x[0]+(-0.995466442084)*x[1]+(-1.09468062911)*x[2]
        ref[0,0]=(0.683098278161)
        ref[0,1]=(-0.151590511238)
        ref[0,2]=(0.54461031868)
        ref[1,0]=(0.59998040214)
        ref[1,1]=(-0.995466442084)
        ref[1,2]=(-1.09468062911)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnBoundary_fromData_ReducedSolution_rank2(self):
      """
      tests gradient for rank 2 Data on the FunctionOnBoundary

      assumptions: ReducedSolution(self.domain) exists
                   self.domain supports gradient on FunctionOnBoundary
      """
      o=1
      dim=self.domain.getDim()
      w_ref=FunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=ReducedSolution(self.domain)
      x=w.getX()
      arg=Data(0,(4, 5),w)
      ref=Data(0,(4, 5)+(dim,),w_ref)
      if dim==2:
        arg[0,0]=(-0.159129528541)*x[0]+(0.107835972384)*x[1]
        arg[0,1]=(-1.52388770934)*x[0]+(0.262089610596)*x[1]
        arg[0,2]=(0.505454501555)*x[0]+(-0.247061440744)*x[1]
        arg[0,3]=(-0.556075420202)*x[0]+(0.702144110506)*x[1]
        arg[0,4]=(0.810518335626)*x[0]+(-0.76077949525)*x[1]
        arg[1,0]=(-0.491052732808)*x[0]+(-0.272913467279)*x[1]
        arg[1,1]=(0.0141908236388)*x[0]+(1.10868804645)*x[1]
        arg[1,2]=(0.719028425382)*x[0]+(-0.544780305018)*x[1]
        arg[1,3]=(-1.15474920716)*x[0]+(0.888461325396)*x[1]
        arg[1,4]=(-0.842901893766)*x[0]+(-0.465916012282)*x[1]
        arg[2,0]=(1.24606386746)*x[0]+(0.817235825831)*x[1]
        arg[2,1]=(0.400861923494)*x[0]+(1.24545704982)*x[1]
        arg[2,2]=(0.656546253691)*x[0]+(-0.0269228973404)*x[1]
        arg[2,3]=(-0.590512343874)*x[0]+(-0.0654952556025)*x[1]
        arg[2,4]=(0.806342618281)*x[0]+(-0.183166204195)*x[1]
        arg[3,0]=(0.637045776935)*x[0]+(-0.512820906995)*x[1]
        arg[3,1]=(-0.596216711833)*x[0]+(-0.221853749777)*x[1]
        arg[3,2]=(0.113235739927)*x[0]+(-0.210641618992)*x[1]
        arg[3,3]=(-1.11423980423)*x[0]+(-1.46748285012)*x[1]
        arg[3,4]=(0.573260999643)*x[0]+(0.55016627172)*x[1]
        ref[0,0,0]=(-0.159129528541)
        ref[0,0,1]=(0.107835972384)
        ref[0,1,0]=(-1.52388770934)
        ref[0,1,1]=(0.262089610596)
        ref[0,2,0]=(0.505454501555)
        ref[0,2,1]=(-0.247061440744)
        ref[0,3,0]=(-0.556075420202)
        ref[0,3,1]=(0.702144110506)
        ref[0,4,0]=(0.810518335626)
        ref[0,4,1]=(-0.76077949525)
        ref[1,0,0]=(-0.491052732808)
        ref[1,0,1]=(-0.272913467279)
        ref[1,1,0]=(0.0141908236388)
        ref[1,1,1]=(1.10868804645)
        ref[1,2,0]=(0.719028425382)
        ref[1,2,1]=(-0.544780305018)
        ref[1,3,0]=(-1.15474920716)
        ref[1,3,1]=(0.888461325396)
        ref[1,4,0]=(-0.842901893766)
        ref[1,4,1]=(-0.465916012282)
        ref[2,0,0]=(1.24606386746)
        ref[2,0,1]=(0.817235825831)
        ref[2,1,0]=(0.400861923494)
        ref[2,1,1]=(1.24545704982)
        ref[2,2,0]=(0.656546253691)
        ref[2,2,1]=(-0.0269228973404)
        ref[2,3,0]=(-0.590512343874)
        ref[2,3,1]=(-0.0654952556025)
        ref[2,4,0]=(0.806342618281)
        ref[2,4,1]=(-0.183166204195)
        ref[3,0,0]=(0.637045776935)
        ref[3,0,1]=(-0.512820906995)
        ref[3,1,0]=(-0.596216711833)
        ref[3,1,1]=(-0.221853749777)
        ref[3,2,0]=(0.113235739927)
        ref[3,2,1]=(-0.210641618992)
        ref[3,3,0]=(-1.11423980423)
        ref[3,3,1]=(-1.46748285012)
        ref[3,4,0]=(0.573260999643)
        ref[3,4,1]=(0.55016627172)
      else:
        arg[0,0]=(-0.025505130975)*x[0]+(-0.128352022583)*x[1]+(-0.0645809876948)*x[2]
        arg[0,1]=(-0.974556985555)*x[0]+(0.503751568036)*x[1]+(-0.524784840232)*x[2]
        arg[0,2]=(-1.23653778531)*x[0]+(-0.73883453445)*x[1]+(-1.59259101746)*x[2]
        arg[0,3]=(-0.543656268618)*x[0]+(0.110486603472)*x[1]+(-0.636246757745)*x[2]
        arg[0,4]=(-0.566088225133)*x[0]+(-0.272577812471)*x[1]+(-0.282075405014)*x[2]
        arg[1,0]=(-0.28252305722)*x[0]+(0.497103425073)*x[1]+(0.997942367464)*x[2]
        arg[1,1]=(-0.444059543356)*x[0]+(-0.149004039444)*x[1]+(-0.871853047384)*x[2]
        arg[1,2]=(-0.610830496789)*x[0]+(0.196494475826)*x[1]+(0.0123852343883)*x[2]
        arg[1,3]=(-0.327903465165)*x[0]+(0.523560519595)*x[1]+(-0.409961704581)*x[2]
        arg[1,4]=(0.633897214746)*x[0]+(-0.9032002551)*x[1]+(0.624042996391)*x[2]
        arg[2,0]=(0.469489049636)*x[0]+(1.46158418286)*x[1]+(-0.538453674545)*x[2]
        arg[2,1]=(0.0488906165423)*x[0]+(0.483867458959)*x[1]+(0.0419643463366)*x[2]
        arg[2,2]=(-1.89716754038)*x[0]+(-0.577554008519)*x[1]+(-0.0328835832126)*x[2]
        arg[2,3]=(0.507329501469)*x[0]+(0.354939444351)*x[1]+(0.0136766029313)*x[2]
        arg[2,4]=(-0.313182267444)*x[0]+(-1.08684309178)*x[1]+(-1.39365968958)*x[2]
        arg[3,0]=(0.272322829309)*x[0]+(-0.233645276231)*x[1]+(0.491500838791)*x[2]
        arg[3,1]=(1.27603407856)*x[0]+(-0.709429989875)*x[1]+(-0.998371438244)*x[2]
        arg[3,2]=(0.637972716248)*x[0]+(-1.37896009762)*x[1]+(0.496830616786)*x[2]
        arg[3,3]=(-1.67735443481)*x[0]+(-0.741884420811)*x[1]+(1.23125805904)*x[2]
        arg[3,4]=(-0.593290763881)*x[0]+(-0.881909104701)*x[1]+(-1.0425499934)*x[2]
        ref[0,0,0]=(-0.025505130975)
        ref[0,0,1]=(-0.128352022583)
        ref[0,0,2]=(-0.0645809876948)
        ref[0,1,0]=(-0.974556985555)
        ref[0,1,1]=(0.503751568036)
        ref[0,1,2]=(-0.524784840232)
        ref[0,2,0]=(-1.23653778531)
        ref[0,2,1]=(-0.73883453445)
        ref[0,2,2]=(-1.59259101746)
        ref[0,3,0]=(-0.543656268618)
        ref[0,3,1]=(0.110486603472)
        ref[0,3,2]=(-0.636246757745)
        ref[0,4,0]=(-0.566088225133)
        ref[0,4,1]=(-0.272577812471)
        ref[0,4,2]=(-0.282075405014)
        ref[1,0,0]=(-0.28252305722)
        ref[1,0,1]=(0.497103425073)
        ref[1,0,2]=(0.997942367464)
        ref[1,1,0]=(-0.444059543356)
        ref[1,1,1]=(-0.149004039444)
        ref[1,1,2]=(-0.871853047384)
        ref[1,2,0]=(-0.610830496789)
        ref[1,2,1]=(0.196494475826)
        ref[1,2,2]=(0.0123852343883)
        ref[1,3,0]=(-0.327903465165)
        ref[1,3,1]=(0.523560519595)
        ref[1,3,2]=(-0.409961704581)
        ref[1,4,0]=(0.633897214746)
        ref[1,4,1]=(-0.9032002551)
        ref[1,4,2]=(0.624042996391)
        ref[2,0,0]=(0.469489049636)
        ref[2,0,1]=(1.46158418286)
        ref[2,0,2]=(-0.538453674545)
        ref[2,1,0]=(0.0488906165423)
        ref[2,1,1]=(0.483867458959)
        ref[2,1,2]=(0.0419643463366)
        ref[2,2,0]=(-1.89716754038)
        ref[2,2,1]=(-0.577554008519)
        ref[2,2,2]=(-0.0328835832126)
        ref[2,3,0]=(0.507329501469)
        ref[2,3,1]=(0.354939444351)
        ref[2,3,2]=(0.0136766029313)
        ref[2,4,0]=(-0.313182267444)
        ref[2,4,1]=(-1.08684309178)
        ref[2,4,2]=(-1.39365968958)
        ref[3,0,0]=(0.272322829309)
        ref[3,0,1]=(-0.233645276231)
        ref[3,0,2]=(0.491500838791)
        ref[3,1,0]=(1.27603407856)
        ref[3,1,1]=(-0.709429989875)
        ref[3,1,2]=(-0.998371438244)
        ref[3,2,0]=(0.637972716248)
        ref[3,2,1]=(-1.37896009762)
        ref[3,2,2]=(0.496830616786)
        ref[3,3,0]=(-1.67735443481)
        ref[3,3,1]=(-0.741884420811)
        ref[3,3,2]=(1.23125805904)
        ref[3,4,0]=(-0.593290763881)
        ref[3,4,1]=(-0.881909104701)
        ref[3,4,2]=(-1.0425499934)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnBoundary_fromData_ReducedSolution_rank3(self):
      """
      tests gradient for rank 3 Data on the FunctionOnBoundary

      assumptions: ReducedSolution(self.domain) exists
                   self.domain supports gradient on FunctionOnBoundary
      """
      o=1
      dim=self.domain.getDim()
      w_ref=FunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=ReducedSolution(self.domain)
      x=w.getX()
      arg=Data(0,(6, 2, 2),w)
      ref=Data(0,(6, 2, 2)+(dim,),w_ref)
      if dim==2:
        arg[0,0,0]=(0.289868084377)*x[0]+(-1.636093365)*x[1]
        arg[0,0,1]=(0.841764493453)*x[0]+(-0.397262590373)*x[1]
        arg[0,1,0]=(0.318610649633)*x[0]+(1.59837795884)*x[1]
        arg[0,1,1]=(1.41408600658)*x[0]+(0.212012530707)*x[1]
        arg[1,0,0]=(-1.13663878903)*x[0]+(-0.535752609596)*x[1]
        arg[1,0,1]=(-0.795140440626)*x[0]+(-0.733456054749)*x[1]
        arg[1,1,0]=(-0.174874940569)*x[0]+(0.304037654801)*x[1]
        arg[1,1,1]=(0.835374268658)*x[0]+(0.645365790264)*x[1]
        arg[2,0,0]=(0.684064169293)*x[0]+(-0.580502209076)*x[1]
        arg[2,0,1]=(0.342542841673)*x[0]+(-0.620912562797)*x[1]
        arg[2,1,0]=(-0.457226288553)*x[0]+(-0.163180645461)*x[1]
        arg[2,1,1]=(-0.494067356015)*x[0]+(-0.604667785982)*x[1]
        arg[3,0,0]=(-0.224173319974)*x[0]+(-0.288566962407)*x[1]
        arg[3,0,1]=(-0.83578982053)*x[0]+(0.290663773612)*x[1]
        arg[3,1,0]=(0.700494058094)*x[0]+(0.244036699451)*x[1]
        arg[3,1,1]=(0.960756120912)*x[0]+(-0.129549309953)*x[1]
        arg[4,0,0]=(0.942292060296)*x[0]+(-0.148922577041)*x[1]
        arg[4,0,1]=(-0.363876552144)*x[0]+(0.903847614766)*x[1]
        arg[4,1,0]=(-1.91719369833)*x[0]+(0.961392595186)*x[1]
        arg[4,1,1]=(-0.141662097711)*x[0]+(-0.695061685931)*x[1]
        arg[5,0,0]=(0.416693171023)*x[0]+(1.04455773845)*x[1]
        arg[5,0,1]=(0.325327980312)*x[0]+(-1.01452792883)*x[1]
        arg[5,1,0]=(-1.43970903355)*x[0]+(-1.04382682561)*x[1]
        arg[5,1,1]=(-0.969700314248)*x[0]+(-0.286024748854)*x[1]
        ref[0,0,0,0]=(0.289868084377)
        ref[0,0,0,1]=(-1.636093365)
        ref[0,0,1,0]=(0.841764493453)
        ref[0,0,1,1]=(-0.397262590373)
        ref[0,1,0,0]=(0.318610649633)
        ref[0,1,0,1]=(1.59837795884)
        ref[0,1,1,0]=(1.41408600658)
        ref[0,1,1,1]=(0.212012530707)
        ref[1,0,0,0]=(-1.13663878903)
        ref[1,0,0,1]=(-0.535752609596)
        ref[1,0,1,0]=(-0.795140440626)
        ref[1,0,1,1]=(-0.733456054749)
        ref[1,1,0,0]=(-0.174874940569)
        ref[1,1,0,1]=(0.304037654801)
        ref[1,1,1,0]=(0.835374268658)
        ref[1,1,1,1]=(0.645365790264)
        ref[2,0,0,0]=(0.684064169293)
        ref[2,0,0,1]=(-0.580502209076)
        ref[2,0,1,0]=(0.342542841673)
        ref[2,0,1,1]=(-0.620912562797)
        ref[2,1,0,0]=(-0.457226288553)
        ref[2,1,0,1]=(-0.163180645461)
        ref[2,1,1,0]=(-0.494067356015)
        ref[2,1,1,1]=(-0.604667785982)
        ref[3,0,0,0]=(-0.224173319974)
        ref[3,0,0,1]=(-0.288566962407)
        ref[3,0,1,0]=(-0.83578982053)
        ref[3,0,1,1]=(0.290663773612)
        ref[3,1,0,0]=(0.700494058094)
        ref[3,1,0,1]=(0.244036699451)
        ref[3,1,1,0]=(0.960756120912)
        ref[3,1,1,1]=(-0.129549309953)
        ref[4,0,0,0]=(0.942292060296)
        ref[4,0,0,1]=(-0.148922577041)
        ref[4,0,1,0]=(-0.363876552144)
        ref[4,0,1,1]=(0.903847614766)
        ref[4,1,0,0]=(-1.91719369833)
        ref[4,1,0,1]=(0.961392595186)
        ref[4,1,1,0]=(-0.141662097711)
        ref[4,1,1,1]=(-0.695061685931)
        ref[5,0,0,0]=(0.416693171023)
        ref[5,0,0,1]=(1.04455773845)
        ref[5,0,1,0]=(0.325327980312)
        ref[5,0,1,1]=(-1.01452792883)
        ref[5,1,0,0]=(-1.43970903355)
        ref[5,1,0,1]=(-1.04382682561)
        ref[5,1,1,0]=(-0.969700314248)
        ref[5,1,1,1]=(-0.286024748854)
      else:
        arg[0,0,0]=(-1.52443210214)*x[0]+(-1.48020118993)*x[1]+(1.2552138343)*x[2]
        arg[0,0,1]=(-0.102900544448)*x[0]+(-1.14209442568)*x[1]+(-0.975626338621)*x[2]
        arg[0,1,0]=(0.909668629294)*x[0]+(1.29127341353)*x[1]+(-1.65221956404)*x[2]
        arg[0,1,1]=(-0.00309732749698)*x[0]+(0.0561682749786)*x[1]+(0.330039911431)*x[2]
        arg[1,0,0]=(0.966608417982)*x[0]+(-0.181702539284)*x[1]+(0.377393548129)*x[2]
        arg[1,0,1]=(0.0273333293331)*x[0]+(0.745172228806)*x[1]+(0.756302500232)*x[2]
        arg[1,1,0]=(-0.550382204645)*x[0]+(0.531191986475)*x[1]+(-1.02269665633)*x[2]
        arg[1,1,1]=(-0.928522491259)*x[0]+(-1.25241213648)*x[1]+(0.635412990933)*x[2]
        arg[2,0,0]=(-0.355234026557)*x[0]+(-1.69834232334)*x[1]+(1.17827811215)*x[2]
        arg[2,0,1]=(-0.905805855166)*x[0]+(1.4023187683)*x[1]+(-0.570168366306)*x[2]
        arg[2,1,0]=(0.550150523384)*x[0]+(-1.59933962526)*x[1]+(-0.388203251081)*x[2]
        arg[2,1,1]=(0.138470563927)*x[0]+(0.245233545344)*x[1]+(-0.293840556681)*x[2]
        arg[3,0,0]=(1.19700673733)*x[0]+(-1.04510591446)*x[1]+(1.03589008728)*x[2]
        arg[3,0,1]=(0.713948123924)*x[0]+(-1.42841558036)*x[1]+(1.07248428525)*x[2]
        arg[3,1,0]=(0.11223781122)*x[0]+(-0.00982612208261)*x[1]+(-0.263153847134)*x[2]
        arg[3,1,1]=(1.33011049869)*x[0]+(0.691016997799)*x[1]+(-0.0547947379786)*x[2]
        arg[4,0,0]=(1.0577224608)*x[0]+(-0.263034881475)*x[1]+(-0.854540775969)*x[2]
        arg[4,0,1]=(0.686363734714)*x[0]+(0.198120868875)*x[1]+(1.46326635417)*x[2]
        arg[4,1,0]=(-0.745244187008)*x[0]+(1.31766298118)*x[1]+(1.51544532829)*x[2]
        arg[4,1,1]=(0.878390723411)*x[0]+(-0.427741582253)*x[1]+(0.0324341706939)*x[2]
        arg[5,0,0]=(-0.445960121294)*x[0]+(-0.215668362178)*x[1]+(0.147632419682)*x[2]
        arg[5,0,1]=(-0.0781270285912)*x[0]+(0.782990026347)*x[1]+(-1.28046463036)*x[2]
        arg[5,1,0]=(-0.385003656622)*x[0]+(-1.02087438188)*x[1]+(-0.594357838151)*x[2]
        arg[5,1,1]=(-0.676669731714)*x[0]+(-0.28685220691)*x[1]+(0.335774697674)*x[2]
        ref[0,0,0,0]=(-1.52443210214)
        ref[0,0,0,1]=(-1.48020118993)
        ref[0,0,0,2]=(1.2552138343)
        ref[0,0,1,0]=(-0.102900544448)
        ref[0,0,1,1]=(-1.14209442568)
        ref[0,0,1,2]=(-0.975626338621)
        ref[0,1,0,0]=(0.909668629294)
        ref[0,1,0,1]=(1.29127341353)
        ref[0,1,0,2]=(-1.65221956404)
        ref[0,1,1,0]=(-0.00309732749698)
        ref[0,1,1,1]=(0.0561682749786)
        ref[0,1,1,2]=(0.330039911431)
        ref[1,0,0,0]=(0.966608417982)
        ref[1,0,0,1]=(-0.181702539284)
        ref[1,0,0,2]=(0.377393548129)
        ref[1,0,1,0]=(0.0273333293331)
        ref[1,0,1,1]=(0.745172228806)
        ref[1,0,1,2]=(0.756302500232)
        ref[1,1,0,0]=(-0.550382204645)
        ref[1,1,0,1]=(0.531191986475)
        ref[1,1,0,2]=(-1.02269665633)
        ref[1,1,1,0]=(-0.928522491259)
        ref[1,1,1,1]=(-1.25241213648)
        ref[1,1,1,2]=(0.635412990933)
        ref[2,0,0,0]=(-0.355234026557)
        ref[2,0,0,1]=(-1.69834232334)
        ref[2,0,0,2]=(1.17827811215)
        ref[2,0,1,0]=(-0.905805855166)
        ref[2,0,1,1]=(1.4023187683)
        ref[2,0,1,2]=(-0.570168366306)
        ref[2,1,0,0]=(0.550150523384)
        ref[2,1,0,1]=(-1.59933962526)
        ref[2,1,0,2]=(-0.388203251081)
        ref[2,1,1,0]=(0.138470563927)
        ref[2,1,1,1]=(0.245233545344)
        ref[2,1,1,2]=(-0.293840556681)
        ref[3,0,0,0]=(1.19700673733)
        ref[3,0,0,1]=(-1.04510591446)
        ref[3,0,0,2]=(1.03589008728)
        ref[3,0,1,0]=(0.713948123924)
        ref[3,0,1,1]=(-1.42841558036)
        ref[3,0,1,2]=(1.07248428525)
        ref[3,1,0,0]=(0.11223781122)
        ref[3,1,0,1]=(-0.00982612208261)
        ref[3,1,0,2]=(-0.263153847134)
        ref[3,1,1,0]=(1.33011049869)
        ref[3,1,1,1]=(0.691016997799)
        ref[3,1,1,2]=(-0.0547947379786)
        ref[4,0,0,0]=(1.0577224608)
        ref[4,0,0,1]=(-0.263034881475)
        ref[4,0,0,2]=(-0.854540775969)
        ref[4,0,1,0]=(0.686363734714)
        ref[4,0,1,1]=(0.198120868875)
        ref[4,0,1,2]=(1.46326635417)
        ref[4,1,0,0]=(-0.745244187008)
        ref[4,1,0,1]=(1.31766298118)
        ref[4,1,0,2]=(1.51544532829)
        ref[4,1,1,0]=(0.878390723411)
        ref[4,1,1,1]=(-0.427741582253)
        ref[4,1,1,2]=(0.0324341706939)
        ref[5,0,0,0]=(-0.445960121294)
        ref[5,0,0,1]=(-0.215668362178)
        ref[5,0,0,2]=(0.147632419682)
        ref[5,0,1,0]=(-0.0781270285912)
        ref[5,0,1,1]=(0.782990026347)
        ref[5,0,1,2]=(-1.28046463036)
        ref[5,1,0,0]=(-0.385003656622)
        ref[5,1,0,1]=(-1.02087438188)
        ref[5,1,0,2]=(-0.594357838151)
        ref[5,1,1,0]=(-0.676669731714)
        ref[5,1,1,1]=(-0.28685220691)
        ref[5,1,1,2]=(0.335774697674)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnBoundary_fromData_ReducedContinuousFunction_rank0(self):
      """
      tests gradient for rank 0 Data on the FunctionOnBoundary

      assumptions: ReducedContinuousFunction(self.domain) exists
                   self.domain supports gradient on FunctionOnBoundary
      """
      o=1
      dim=self.domain.getDim()
      w_ref=FunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=ReducedContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(),w)
      ref=Data(0,()+(dim,),w_ref)
      if dim==2:
        arg=(0.306947418999)*x[0]+(-0.706616694784)*x[1]
        ref[0]=(0.306947418999)
        ref[1]=(-0.706616694784)
      else:
        arg=(0.490435692707)*x[0]+(0.929248719763)*x[1]+(0.269868131113)*x[2]
        ref[0]=(0.490435692707)
        ref[1]=(0.929248719763)
        ref[2]=(0.269868131113)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),()+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnBoundary_fromData_ReducedContinuousFunction_rank1(self):
      """
      tests gradient for rank 1 Data on the FunctionOnBoundary

      assumptions: ReducedContinuousFunction(self.domain) exists
                   self.domain supports gradient on FunctionOnBoundary
      """
      o=1
      dim=self.domain.getDim()
      w_ref=FunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=ReducedContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(2,),w)
      ref=Data(0,(2,)+(dim,),w_ref)
      if dim==2:
        arg[0]=(-0.882633673888)*x[0]+(-0.790592442848)*x[1]
        arg[1]=(1.55495669126)*x[0]+(0.496011926182)*x[1]
        ref[0,0]=(-0.882633673888)
        ref[0,1]=(-0.790592442848)
        ref[1,0]=(1.55495669126)
        ref[1,1]=(0.496011926182)
      else:
        arg[0]=(0.683098278161)*x[0]+(-0.151590511238)*x[1]+(0.54461031868)*x[2]
        arg[1]=(0.59998040214)*x[0]+(-0.995466442084)*x[1]+(-1.09468062911)*x[2]
        ref[0,0]=(0.683098278161)
        ref[0,1]=(-0.151590511238)
        ref[0,2]=(0.54461031868)
        ref[1,0]=(0.59998040214)
        ref[1,1]=(-0.995466442084)
        ref[1,2]=(-1.09468062911)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnBoundary_fromData_ReducedContinuousFunction_rank2(self):
      """
      tests gradient for rank 2 Data on the FunctionOnBoundary

      assumptions: ReducedContinuousFunction(self.domain) exists
                   self.domain supports gradient on FunctionOnBoundary
      """
      o=1
      dim=self.domain.getDim()
      w_ref=FunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=ReducedContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(4, 5),w)
      ref=Data(0,(4, 5)+(dim,),w_ref)
      if dim==2:
        arg[0,0]=(-0.159129528541)*x[0]+(0.107835972384)*x[1]
        arg[0,1]=(-1.52388770934)*x[0]+(0.262089610596)*x[1]
        arg[0,2]=(0.505454501555)*x[0]+(-0.247061440744)*x[1]
        arg[0,3]=(-0.556075420202)*x[0]+(0.702144110506)*x[1]
        arg[0,4]=(0.810518335626)*x[0]+(-0.76077949525)*x[1]
        arg[1,0]=(-0.491052732808)*x[0]+(-0.272913467279)*x[1]
        arg[1,1]=(0.0141908236388)*x[0]+(1.10868804645)*x[1]
        arg[1,2]=(0.719028425382)*x[0]+(-0.544780305018)*x[1]
        arg[1,3]=(-1.15474920716)*x[0]+(0.888461325396)*x[1]
        arg[1,4]=(-0.842901893766)*x[0]+(-0.465916012282)*x[1]
        arg[2,0]=(1.24606386746)*x[0]+(0.817235825831)*x[1]
        arg[2,1]=(0.400861923494)*x[0]+(1.24545704982)*x[1]
        arg[2,2]=(0.656546253691)*x[0]+(-0.0269228973404)*x[1]
        arg[2,3]=(-0.590512343874)*x[0]+(-0.0654952556025)*x[1]
        arg[2,4]=(0.806342618281)*x[0]+(-0.183166204195)*x[1]
        arg[3,0]=(0.637045776935)*x[0]+(-0.512820906995)*x[1]
        arg[3,1]=(-0.596216711833)*x[0]+(-0.221853749777)*x[1]
        arg[3,2]=(0.113235739927)*x[0]+(-0.210641618992)*x[1]
        arg[3,3]=(-1.11423980423)*x[0]+(-1.46748285012)*x[1]
        arg[3,4]=(0.573260999643)*x[0]+(0.55016627172)*x[1]
        ref[0,0,0]=(-0.159129528541)
        ref[0,0,1]=(0.107835972384)
        ref[0,1,0]=(-1.52388770934)
        ref[0,1,1]=(0.262089610596)
        ref[0,2,0]=(0.505454501555)
        ref[0,2,1]=(-0.247061440744)
        ref[0,3,0]=(-0.556075420202)
        ref[0,3,1]=(0.702144110506)
        ref[0,4,0]=(0.810518335626)
        ref[0,4,1]=(-0.76077949525)
        ref[1,0,0]=(-0.491052732808)
        ref[1,0,1]=(-0.272913467279)
        ref[1,1,0]=(0.0141908236388)
        ref[1,1,1]=(1.10868804645)
        ref[1,2,0]=(0.719028425382)
        ref[1,2,1]=(-0.544780305018)
        ref[1,3,0]=(-1.15474920716)
        ref[1,3,1]=(0.888461325396)
        ref[1,4,0]=(-0.842901893766)
        ref[1,4,1]=(-0.465916012282)
        ref[2,0,0]=(1.24606386746)
        ref[2,0,1]=(0.817235825831)
        ref[2,1,0]=(0.400861923494)
        ref[2,1,1]=(1.24545704982)
        ref[2,2,0]=(0.656546253691)
        ref[2,2,1]=(-0.0269228973404)
        ref[2,3,0]=(-0.590512343874)
        ref[2,3,1]=(-0.0654952556025)
        ref[2,4,0]=(0.806342618281)
        ref[2,4,1]=(-0.183166204195)
        ref[3,0,0]=(0.637045776935)
        ref[3,0,1]=(-0.512820906995)
        ref[3,1,0]=(-0.596216711833)
        ref[3,1,1]=(-0.221853749777)
        ref[3,2,0]=(0.113235739927)
        ref[3,2,1]=(-0.210641618992)
        ref[3,3,0]=(-1.11423980423)
        ref[3,3,1]=(-1.46748285012)
        ref[3,4,0]=(0.573260999643)
        ref[3,4,1]=(0.55016627172)
      else:
        arg[0,0]=(-0.025505130975)*x[0]+(-0.128352022583)*x[1]+(-0.0645809876948)*x[2]
        arg[0,1]=(-0.974556985555)*x[0]+(0.503751568036)*x[1]+(-0.524784840232)*x[2]
        arg[0,2]=(-1.23653778531)*x[0]+(-0.73883453445)*x[1]+(-1.59259101746)*x[2]
        arg[0,3]=(-0.543656268618)*x[0]+(0.110486603472)*x[1]+(-0.636246757745)*x[2]
        arg[0,4]=(-0.566088225133)*x[0]+(-0.272577812471)*x[1]+(-0.282075405014)*x[2]
        arg[1,0]=(-0.28252305722)*x[0]+(0.497103425073)*x[1]+(0.997942367464)*x[2]
        arg[1,1]=(-0.444059543356)*x[0]+(-0.149004039444)*x[1]+(-0.871853047384)*x[2]
        arg[1,2]=(-0.610830496789)*x[0]+(0.196494475826)*x[1]+(0.0123852343883)*x[2]
        arg[1,3]=(-0.327903465165)*x[0]+(0.523560519595)*x[1]+(-0.409961704581)*x[2]
        arg[1,4]=(0.633897214746)*x[0]+(-0.9032002551)*x[1]+(0.624042996391)*x[2]
        arg[2,0]=(0.469489049636)*x[0]+(1.46158418286)*x[1]+(-0.538453674545)*x[2]
        arg[2,1]=(0.0488906165423)*x[0]+(0.483867458959)*x[1]+(0.0419643463366)*x[2]
        arg[2,2]=(-1.89716754038)*x[0]+(-0.577554008519)*x[1]+(-0.0328835832126)*x[2]
        arg[2,3]=(0.507329501469)*x[0]+(0.354939444351)*x[1]+(0.0136766029313)*x[2]
        arg[2,4]=(-0.313182267444)*x[0]+(-1.08684309178)*x[1]+(-1.39365968958)*x[2]
        arg[3,0]=(0.272322829309)*x[0]+(-0.233645276231)*x[1]+(0.491500838791)*x[2]
        arg[3,1]=(1.27603407856)*x[0]+(-0.709429989875)*x[1]+(-0.998371438244)*x[2]
        arg[3,2]=(0.637972716248)*x[0]+(-1.37896009762)*x[1]+(0.496830616786)*x[2]
        arg[3,3]=(-1.67735443481)*x[0]+(-0.741884420811)*x[1]+(1.23125805904)*x[2]
        arg[3,4]=(-0.593290763881)*x[0]+(-0.881909104701)*x[1]+(-1.0425499934)*x[2]
        ref[0,0,0]=(-0.025505130975)
        ref[0,0,1]=(-0.128352022583)
        ref[0,0,2]=(-0.0645809876948)
        ref[0,1,0]=(-0.974556985555)
        ref[0,1,1]=(0.503751568036)
        ref[0,1,2]=(-0.524784840232)
        ref[0,2,0]=(-1.23653778531)
        ref[0,2,1]=(-0.73883453445)
        ref[0,2,2]=(-1.59259101746)
        ref[0,3,0]=(-0.543656268618)
        ref[0,3,1]=(0.110486603472)
        ref[0,3,2]=(-0.636246757745)
        ref[0,4,0]=(-0.566088225133)
        ref[0,4,1]=(-0.272577812471)
        ref[0,4,2]=(-0.282075405014)
        ref[1,0,0]=(-0.28252305722)
        ref[1,0,1]=(0.497103425073)
        ref[1,0,2]=(0.997942367464)
        ref[1,1,0]=(-0.444059543356)
        ref[1,1,1]=(-0.149004039444)
        ref[1,1,2]=(-0.871853047384)
        ref[1,2,0]=(-0.610830496789)
        ref[1,2,1]=(0.196494475826)
        ref[1,2,2]=(0.0123852343883)
        ref[1,3,0]=(-0.327903465165)
        ref[1,3,1]=(0.523560519595)
        ref[1,3,2]=(-0.409961704581)
        ref[1,4,0]=(0.633897214746)
        ref[1,4,1]=(-0.9032002551)
        ref[1,4,2]=(0.624042996391)
        ref[2,0,0]=(0.469489049636)
        ref[2,0,1]=(1.46158418286)
        ref[2,0,2]=(-0.538453674545)
        ref[2,1,0]=(0.0488906165423)
        ref[2,1,1]=(0.483867458959)
        ref[2,1,2]=(0.0419643463366)
        ref[2,2,0]=(-1.89716754038)
        ref[2,2,1]=(-0.577554008519)
        ref[2,2,2]=(-0.0328835832126)
        ref[2,3,0]=(0.507329501469)
        ref[2,3,1]=(0.354939444351)
        ref[2,3,2]=(0.0136766029313)
        ref[2,4,0]=(-0.313182267444)
        ref[2,4,1]=(-1.08684309178)
        ref[2,4,2]=(-1.39365968958)
        ref[3,0,0]=(0.272322829309)
        ref[3,0,1]=(-0.233645276231)
        ref[3,0,2]=(0.491500838791)
        ref[3,1,0]=(1.27603407856)
        ref[3,1,1]=(-0.709429989875)
        ref[3,1,2]=(-0.998371438244)
        ref[3,2,0]=(0.637972716248)
        ref[3,2,1]=(-1.37896009762)
        ref[3,2,2]=(0.496830616786)
        ref[3,3,0]=(-1.67735443481)
        ref[3,3,1]=(-0.741884420811)
        ref[3,3,2]=(1.23125805904)
        ref[3,4,0]=(-0.593290763881)
        ref[3,4,1]=(-0.881909104701)
        ref[3,4,2]=(-1.0425499934)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnBoundary_fromData_ReducedContinuousFunction_rank3(self):
      """
      tests gradient for rank 3 Data on the FunctionOnBoundary

      assumptions: ReducedContinuousFunction(self.domain) exists
                   self.domain supports gradient on FunctionOnBoundary
      """
      o=1
      dim=self.domain.getDim()
      w_ref=FunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=ReducedContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(6, 2, 2),w)
      ref=Data(0,(6, 2, 2)+(dim,),w_ref)
      if dim==2:
        arg[0,0,0]=(0.289868084377)*x[0]+(-1.636093365)*x[1]
        arg[0,0,1]=(0.841764493453)*x[0]+(-0.397262590373)*x[1]
        arg[0,1,0]=(0.318610649633)*x[0]+(1.59837795884)*x[1]
        arg[0,1,1]=(1.41408600658)*x[0]+(0.212012530707)*x[1]
        arg[1,0,0]=(-1.13663878903)*x[0]+(-0.535752609596)*x[1]
        arg[1,0,1]=(-0.795140440626)*x[0]+(-0.733456054749)*x[1]
        arg[1,1,0]=(-0.174874940569)*x[0]+(0.304037654801)*x[1]
        arg[1,1,1]=(0.835374268658)*x[0]+(0.645365790264)*x[1]
        arg[2,0,0]=(0.684064169293)*x[0]+(-0.580502209076)*x[1]
        arg[2,0,1]=(0.342542841673)*x[0]+(-0.620912562797)*x[1]
        arg[2,1,0]=(-0.457226288553)*x[0]+(-0.163180645461)*x[1]
        arg[2,1,1]=(-0.494067356015)*x[0]+(-0.604667785982)*x[1]
        arg[3,0,0]=(-0.224173319974)*x[0]+(-0.288566962407)*x[1]
        arg[3,0,1]=(-0.83578982053)*x[0]+(0.290663773612)*x[1]
        arg[3,1,0]=(0.700494058094)*x[0]+(0.244036699451)*x[1]
        arg[3,1,1]=(0.960756120912)*x[0]+(-0.129549309953)*x[1]
        arg[4,0,0]=(0.942292060296)*x[0]+(-0.148922577041)*x[1]
        arg[4,0,1]=(-0.363876552144)*x[0]+(0.903847614766)*x[1]
        arg[4,1,0]=(-1.91719369833)*x[0]+(0.961392595186)*x[1]
        arg[4,1,1]=(-0.141662097711)*x[0]+(-0.695061685931)*x[1]
        arg[5,0,0]=(0.416693171023)*x[0]+(1.04455773845)*x[1]
        arg[5,0,1]=(0.325327980312)*x[0]+(-1.01452792883)*x[1]
        arg[5,1,0]=(-1.43970903355)*x[0]+(-1.04382682561)*x[1]
        arg[5,1,1]=(-0.969700314248)*x[0]+(-0.286024748854)*x[1]
        ref[0,0,0,0]=(0.289868084377)
        ref[0,0,0,1]=(-1.636093365)
        ref[0,0,1,0]=(0.841764493453)
        ref[0,0,1,1]=(-0.397262590373)
        ref[0,1,0,0]=(0.318610649633)
        ref[0,1,0,1]=(1.59837795884)
        ref[0,1,1,0]=(1.41408600658)
        ref[0,1,1,1]=(0.212012530707)
        ref[1,0,0,0]=(-1.13663878903)
        ref[1,0,0,1]=(-0.535752609596)
        ref[1,0,1,0]=(-0.795140440626)
        ref[1,0,1,1]=(-0.733456054749)
        ref[1,1,0,0]=(-0.174874940569)
        ref[1,1,0,1]=(0.304037654801)
        ref[1,1,1,0]=(0.835374268658)
        ref[1,1,1,1]=(0.645365790264)
        ref[2,0,0,0]=(0.684064169293)
        ref[2,0,0,1]=(-0.580502209076)
        ref[2,0,1,0]=(0.342542841673)
        ref[2,0,1,1]=(-0.620912562797)
        ref[2,1,0,0]=(-0.457226288553)
        ref[2,1,0,1]=(-0.163180645461)
        ref[2,1,1,0]=(-0.494067356015)
        ref[2,1,1,1]=(-0.604667785982)
        ref[3,0,0,0]=(-0.224173319974)
        ref[3,0,0,1]=(-0.288566962407)
        ref[3,0,1,0]=(-0.83578982053)
        ref[3,0,1,1]=(0.290663773612)
        ref[3,1,0,0]=(0.700494058094)
        ref[3,1,0,1]=(0.244036699451)
        ref[3,1,1,0]=(0.960756120912)
        ref[3,1,1,1]=(-0.129549309953)
        ref[4,0,0,0]=(0.942292060296)
        ref[4,0,0,1]=(-0.148922577041)
        ref[4,0,1,0]=(-0.363876552144)
        ref[4,0,1,1]=(0.903847614766)
        ref[4,1,0,0]=(-1.91719369833)
        ref[4,1,0,1]=(0.961392595186)
        ref[4,1,1,0]=(-0.141662097711)
        ref[4,1,1,1]=(-0.695061685931)
        ref[5,0,0,0]=(0.416693171023)
        ref[5,0,0,1]=(1.04455773845)
        ref[5,0,1,0]=(0.325327980312)
        ref[5,0,1,1]=(-1.01452792883)
        ref[5,1,0,0]=(-1.43970903355)
        ref[5,1,0,1]=(-1.04382682561)
        ref[5,1,1,0]=(-0.969700314248)
        ref[5,1,1,1]=(-0.286024748854)
      else:
        arg[0,0,0]=(-1.52443210214)*x[0]+(-1.48020118993)*x[1]+(1.2552138343)*x[2]
        arg[0,0,1]=(-0.102900544448)*x[0]+(-1.14209442568)*x[1]+(-0.975626338621)*x[2]
        arg[0,1,0]=(0.909668629294)*x[0]+(1.29127341353)*x[1]+(-1.65221956404)*x[2]
        arg[0,1,1]=(-0.00309732749698)*x[0]+(0.0561682749786)*x[1]+(0.330039911431)*x[2]
        arg[1,0,0]=(0.966608417982)*x[0]+(-0.181702539284)*x[1]+(0.377393548129)*x[2]
        arg[1,0,1]=(0.0273333293331)*x[0]+(0.745172228806)*x[1]+(0.756302500232)*x[2]
        arg[1,1,0]=(-0.550382204645)*x[0]+(0.531191986475)*x[1]+(-1.02269665633)*x[2]
        arg[1,1,1]=(-0.928522491259)*x[0]+(-1.25241213648)*x[1]+(0.635412990933)*x[2]
        arg[2,0,0]=(-0.355234026557)*x[0]+(-1.69834232334)*x[1]+(1.17827811215)*x[2]
        arg[2,0,1]=(-0.905805855166)*x[0]+(1.4023187683)*x[1]+(-0.570168366306)*x[2]
        arg[2,1,0]=(0.550150523384)*x[0]+(-1.59933962526)*x[1]+(-0.388203251081)*x[2]
        arg[2,1,1]=(0.138470563927)*x[0]+(0.245233545344)*x[1]+(-0.293840556681)*x[2]
        arg[3,0,0]=(1.19700673733)*x[0]+(-1.04510591446)*x[1]+(1.03589008728)*x[2]
        arg[3,0,1]=(0.713948123924)*x[0]+(-1.42841558036)*x[1]+(1.07248428525)*x[2]
        arg[3,1,0]=(0.11223781122)*x[0]+(-0.00982612208261)*x[1]+(-0.263153847134)*x[2]
        arg[3,1,1]=(1.33011049869)*x[0]+(0.691016997799)*x[1]+(-0.0547947379786)*x[2]
        arg[4,0,0]=(1.0577224608)*x[0]+(-0.263034881475)*x[1]+(-0.854540775969)*x[2]
        arg[4,0,1]=(0.686363734714)*x[0]+(0.198120868875)*x[1]+(1.46326635417)*x[2]
        arg[4,1,0]=(-0.745244187008)*x[0]+(1.31766298118)*x[1]+(1.51544532829)*x[2]
        arg[4,1,1]=(0.878390723411)*x[0]+(-0.427741582253)*x[1]+(0.0324341706939)*x[2]
        arg[5,0,0]=(-0.445960121294)*x[0]+(-0.215668362178)*x[1]+(0.147632419682)*x[2]
        arg[5,0,1]=(-0.0781270285912)*x[0]+(0.782990026347)*x[1]+(-1.28046463036)*x[2]
        arg[5,1,0]=(-0.385003656622)*x[0]+(-1.02087438188)*x[1]+(-0.594357838151)*x[2]
        arg[5,1,1]=(-0.676669731714)*x[0]+(-0.28685220691)*x[1]+(0.335774697674)*x[2]
        ref[0,0,0,0]=(-1.52443210214)
        ref[0,0,0,1]=(-1.48020118993)
        ref[0,0,0,2]=(1.2552138343)
        ref[0,0,1,0]=(-0.102900544448)
        ref[0,0,1,1]=(-1.14209442568)
        ref[0,0,1,2]=(-0.975626338621)
        ref[0,1,0,0]=(0.909668629294)
        ref[0,1,0,1]=(1.29127341353)
        ref[0,1,0,2]=(-1.65221956404)
        ref[0,1,1,0]=(-0.00309732749698)
        ref[0,1,1,1]=(0.0561682749786)
        ref[0,1,1,2]=(0.330039911431)
        ref[1,0,0,0]=(0.966608417982)
        ref[1,0,0,1]=(-0.181702539284)
        ref[1,0,0,2]=(0.377393548129)
        ref[1,0,1,0]=(0.0273333293331)
        ref[1,0,1,1]=(0.745172228806)
        ref[1,0,1,2]=(0.756302500232)
        ref[1,1,0,0]=(-0.550382204645)
        ref[1,1,0,1]=(0.531191986475)
        ref[1,1,0,2]=(-1.02269665633)
        ref[1,1,1,0]=(-0.928522491259)
        ref[1,1,1,1]=(-1.25241213648)
        ref[1,1,1,2]=(0.635412990933)
        ref[2,0,0,0]=(-0.355234026557)
        ref[2,0,0,1]=(-1.69834232334)
        ref[2,0,0,2]=(1.17827811215)
        ref[2,0,1,0]=(-0.905805855166)
        ref[2,0,1,1]=(1.4023187683)
        ref[2,0,1,2]=(-0.570168366306)
        ref[2,1,0,0]=(0.550150523384)
        ref[2,1,0,1]=(-1.59933962526)
        ref[2,1,0,2]=(-0.388203251081)
        ref[2,1,1,0]=(0.138470563927)
        ref[2,1,1,1]=(0.245233545344)
        ref[2,1,1,2]=(-0.293840556681)
        ref[3,0,0,0]=(1.19700673733)
        ref[3,0,0,1]=(-1.04510591446)
        ref[3,0,0,2]=(1.03589008728)
        ref[3,0,1,0]=(0.713948123924)
        ref[3,0,1,1]=(-1.42841558036)
        ref[3,0,1,2]=(1.07248428525)
        ref[3,1,0,0]=(0.11223781122)
        ref[3,1,0,1]=(-0.00982612208261)
        ref[3,1,0,2]=(-0.263153847134)
        ref[3,1,1,0]=(1.33011049869)
        ref[3,1,1,1]=(0.691016997799)
        ref[3,1,1,2]=(-0.0547947379786)
        ref[4,0,0,0]=(1.0577224608)
        ref[4,0,0,1]=(-0.263034881475)
        ref[4,0,0,2]=(-0.854540775969)
        ref[4,0,1,0]=(0.686363734714)
        ref[4,0,1,1]=(0.198120868875)
        ref[4,0,1,2]=(1.46326635417)
        ref[4,1,0,0]=(-0.745244187008)
        ref[4,1,0,1]=(1.31766298118)
        ref[4,1,0,2]=(1.51544532829)
        ref[4,1,1,0]=(0.878390723411)
        ref[4,1,1,1]=(-0.427741582253)
        ref[4,1,1,2]=(0.0324341706939)
        ref[5,0,0,0]=(-0.445960121294)
        ref[5,0,0,1]=(-0.215668362178)
        ref[5,0,0,2]=(0.147632419682)
        ref[5,0,1,0]=(-0.0781270285912)
        ref[5,0,1,1]=(0.782990026347)
        ref[5,0,1,2]=(-1.28046463036)
        ref[5,1,0,0]=(-0.385003656622)
        ref[5,1,0,1]=(-1.02087438188)
        ref[5,1,0,2]=(-0.594357838151)
        ref[5,1,1,0]=(-0.676669731714)
        ref[5,1,1,1]=(-0.28685220691)
        ref[5,1,1,2]=(0.335774697674)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnBoundary_fromData_ContinuousFunction_rank0(self):
      """
      tests gradient for rank 0 Data on the ReducedFunctionOnBoundary

      assumptions: ContinuousFunction(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnBoundary
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=ContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(),w)
      ref=Data(0,()+(dim,),w_ref)
      if dim==2:
        arg=(0.741017463552)*x[0]**o+(0.665549604887)*x[0]+(-0.294688627656)*x[1]**o+(-0.188608956137)*x[1]
        ref[0]=o*(0.741017463552)*x_ref[0]**(o-1)+(0.665549604887)
        ref[1]=o*(-0.294688627656)*x_ref[1]**(o-1)+(-0.188608956137)
      else:
        arg=(-0.182264095574)*x[0]**o+(0.388884343071)*x[0]+(0.0250471058578)*x[1]**o+(0.242724421847)*x[1]+(-0.863568419189)*x[2]**o+(-0.797427046061)*x[2]
        ref[0]=o*(-0.182264095574)*x_ref[0]**(o-1)+(0.388884343071)
        ref[1]=o*(0.0250471058578)*x_ref[1]**(o-1)+(0.242724421847)
        ref[2]=o*(-0.863568419189)*x_ref[2]**(o-1)+(-0.797427046061)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),()+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnBoundary_fromData_ContinuousFunction_rank1(self):
      """
      tests gradient for rank 1 Data on the ReducedFunctionOnBoundary

      assumptions: ContinuousFunction(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnBoundary
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=ContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(2,),w)
      ref=Data(0,(2,)+(dim,),w_ref)
      if dim==2:
        arg[0]=(-0.566748845779)*x[0]**o+(0.284156548246)*x[0]+(0.213805183732)*x[1]**o+(0.887833417271)*x[1]
        arg[1]=(-0.935376067943)*x[0]**o+(0.31417056704)*x[0]+(0.157729703937)*x[1]**o+(0.781264180355)*x[1]
        ref[0,0]=o*(-0.566748845779)*x_ref[0]**(o-1)+(0.284156548246)
        ref[0,1]=o*(0.213805183732)*x_ref[1]**(o-1)+(0.887833417271)
        ref[1,0]=o*(-0.935376067943)*x_ref[0]**(o-1)+(0.31417056704)
        ref[1,1]=o*(0.157729703937)*x_ref[1]**(o-1)+(0.781264180355)
      else:
        arg[0]=(0.787106597246)*x[0]**o+(0.0477259256332)*x[0]+(0.0657839729355)*x[1]**o+(-0.367242386854)*x[1]+(0.638047637996)*x[2]**o+(0.292293368262)*x[2]
        arg[1]=(0.325241621537)*x[0]**o+(-0.995465871567)*x[0]+(-0.589833259992)*x[1]**o+(0.252602994164)*x[1]+(0.271544628727)*x[2]**o+(0.401222388174)*x[2]
        ref[0,0]=o*(0.787106597246)*x_ref[0]**(o-1)+(0.0477259256332)
        ref[0,1]=o*(0.0657839729355)*x_ref[1]**(o-1)+(-0.367242386854)
        ref[0,2]=o*(0.638047637996)*x_ref[2]**(o-1)+(0.292293368262)
        ref[1,0]=o*(0.325241621537)*x_ref[0]**(o-1)+(-0.995465871567)
        ref[1,1]=o*(-0.589833259992)*x_ref[1]**(o-1)+(0.252602994164)
        ref[1,2]=o*(0.271544628727)*x_ref[2]**(o-1)+(0.401222388174)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnBoundary_fromData_ContinuousFunction_rank2(self):
      """
      tests gradient for rank 2 Data on the ReducedFunctionOnBoundary

      assumptions: ContinuousFunction(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnBoundary
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=ContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(4, 5),w)
      ref=Data(0,(4, 5)+(dim,),w_ref)
      if dim==2:
        arg[0,0]=(-0.535138548297)*x[0]**o+(0.320793182084)*x[0]+(-0.363556615611)*x[1]**o+(0.80028981928)*x[1]
        arg[0,1]=(0.50712290341)*x[0]**o+(0.0696582374725)*x[0]+(-0.565430065964)*x[1]**o+(0.840341269012)*x[1]
        arg[0,2]=(0.222608517758)*x[0]**o+(0.0741096149609)*x[0]+(-0.926916099396)*x[1]**o+(0.840471681255)*x[1]
        arg[0,3]=(-0.0729061065831)*x[0]**o+(-0.361006912293)*x[0]+(-0.796381694915)*x[1]**o+(-0.87399027927)*x[1]
        arg[0,4]=(0.946982642563)*x[0]**o+(0.776871793528)*x[0]+(0.906858449271)*x[1]**o+(0.23076439514)*x[1]
        arg[1,0]=(-0.121641842365)*x[0]**o+(0.755274749862)*x[0]+(-0.905815080361)*x[1]**o+(-0.27711865979)*x[1]
        arg[1,1]=(0.870675475328)*x[0]**o+(0.000245820302085)*x[0]+(0.990534371185)*x[1]**o+(-0.0132722523111)*x[1]
        arg[1,2]=(0.665375098591)*x[0]**o+(0.602779210152)*x[0]+(0.112732227406)*x[1]**o+(0.973600268944)*x[1]
        arg[1,3]=(-0.760686885095)*x[0]**o+(-0.993893837808)*x[0]+(-0.279242757928)*x[1]**o+(0.0970216781461)*x[1]
        arg[1,4]=(-0.326265155118)*x[0]**o+(-0.302971035826)*x[0]+(-0.991053864037)*x[1]**o+(-0.787776341406)*x[1]
        arg[2,0]=(-0.798558123695)*x[0]**o+(-0.648773673567)*x[0]+(0.911336567339)*x[1]**o+(0.525888531875)*x[1]
        arg[2,1]=(0.334481967771)*x[0]**o+(0.559633318828)*x[0]+(-0.738361234791)*x[1]**o+(0.863808627657)*x[1]
        arg[2,2]=(-0.660270802705)*x[0]**o+(-0.500800405285)*x[0]+(0.250991213972)*x[1]**o+(-0.855371865339)*x[1]
        arg[2,3]=(0.573495152924)*x[0]**o+(0.841810214664)*x[0]+(0.816402403997)*x[1]**o+(0.871435278968)*x[1]
        arg[2,4]=(0.00700234490903)*x[0]**o+(0.609696655384)*x[0]+(-0.908261420109)*x[1]**o+(-0.0469518512659)*x[1]
        arg[3,0]=(-0.78381944233)*x[0]**o+(0.547849085605)*x[0]+(-0.481333073199)*x[1]**o+(-0.100496681813)*x[1]
        arg[3,1]=(0.53995869966)*x[0]**o+(-0.503303606531)*x[0]+(0.783394329024)*x[1]**o+(0.989828473603)*x[1]
        arg[3,2]=(0.723590003109)*x[0]**o+(-0.75511396868)*x[0]+(0.249651386017)*x[1]**o+(0.545636109436)*x[1]
        arg[3,3]=(-0.126863462818)*x[0]**o+(0.553295312002)*x[0]+(-0.286155398085)*x[1]**o+(0.425889110789)*x[1]
        arg[3,4]=(-0.970069386779)*x[0]**o+(0.457400568855)*x[0]+(-0.245839304835)*x[1]**o+(-0.463000940469)*x[1]
        ref[0,0,0]=o*(-0.535138548297)*x_ref[0]**(o-1)+(0.320793182084)
        ref[0,0,1]=o*(-0.363556615611)*x_ref[1]**(o-1)+(0.80028981928)
        ref[0,1,0]=o*(0.50712290341)*x_ref[0]**(o-1)+(0.0696582374725)
        ref[0,1,1]=o*(-0.565430065964)*x_ref[1]**(o-1)+(0.840341269012)
        ref[0,2,0]=o*(0.222608517758)*x_ref[0]**(o-1)+(0.0741096149609)
        ref[0,2,1]=o*(-0.926916099396)*x_ref[1]**(o-1)+(0.840471681255)
        ref[0,3,0]=o*(-0.0729061065831)*x_ref[0]**(o-1)+(-0.361006912293)
        ref[0,3,1]=o*(-0.796381694915)*x_ref[1]**(o-1)+(-0.87399027927)
        ref[0,4,0]=o*(0.946982642563)*x_ref[0]**(o-1)+(0.776871793528)
        ref[0,4,1]=o*(0.906858449271)*x_ref[1]**(o-1)+(0.23076439514)
        ref[1,0,0]=o*(-0.121641842365)*x_ref[0]**(o-1)+(0.755274749862)
        ref[1,0,1]=o*(-0.905815080361)*x_ref[1]**(o-1)+(-0.27711865979)
        ref[1,1,0]=o*(0.870675475328)*x_ref[0]**(o-1)+(0.000245820302085)
        ref[1,1,1]=o*(0.990534371185)*x_ref[1]**(o-1)+(-0.0132722523111)
        ref[1,2,0]=o*(0.665375098591)*x_ref[0]**(o-1)+(0.602779210152)
        ref[1,2,1]=o*(0.112732227406)*x_ref[1]**(o-1)+(0.973600268944)
        ref[1,3,0]=o*(-0.760686885095)*x_ref[0]**(o-1)+(-0.993893837808)
        ref[1,3,1]=o*(-0.279242757928)*x_ref[1]**(o-1)+(0.0970216781461)
        ref[1,4,0]=o*(-0.326265155118)*x_ref[0]**(o-1)+(-0.302971035826)
        ref[1,4,1]=o*(-0.991053864037)*x_ref[1]**(o-1)+(-0.787776341406)
        ref[2,0,0]=o*(-0.798558123695)*x_ref[0]**(o-1)+(-0.648773673567)
        ref[2,0,1]=o*(0.911336567339)*x_ref[1]**(o-1)+(0.525888531875)
        ref[2,1,0]=o*(0.334481967771)*x_ref[0]**(o-1)+(0.559633318828)
        ref[2,1,1]=o*(-0.738361234791)*x_ref[1]**(o-1)+(0.863808627657)
        ref[2,2,0]=o*(-0.660270802705)*x_ref[0]**(o-1)+(-0.500800405285)
        ref[2,2,1]=o*(0.250991213972)*x_ref[1]**(o-1)+(-0.855371865339)
        ref[2,3,0]=o*(0.573495152924)*x_ref[0]**(o-1)+(0.841810214664)
        ref[2,3,1]=o*(0.816402403997)*x_ref[1]**(o-1)+(0.871435278968)
        ref[2,4,0]=o*(0.00700234490903)*x_ref[0]**(o-1)+(0.609696655384)
        ref[2,4,1]=o*(-0.908261420109)*x_ref[1]**(o-1)+(-0.0469518512659)
        ref[3,0,0]=o*(-0.78381944233)*x_ref[0]**(o-1)+(0.547849085605)
        ref[3,0,1]=o*(-0.481333073199)*x_ref[1]**(o-1)+(-0.100496681813)
        ref[3,1,0]=o*(0.53995869966)*x_ref[0]**(o-1)+(-0.503303606531)
        ref[3,1,1]=o*(0.783394329024)*x_ref[1]**(o-1)+(0.989828473603)
        ref[3,2,0]=o*(0.723590003109)*x_ref[0]**(o-1)+(-0.75511396868)
        ref[3,2,1]=o*(0.249651386017)*x_ref[1]**(o-1)+(0.545636109436)
        ref[3,3,0]=o*(-0.126863462818)*x_ref[0]**(o-1)+(0.553295312002)
        ref[3,3,1]=o*(-0.286155398085)*x_ref[1]**(o-1)+(0.425889110789)
        ref[3,4,0]=o*(-0.970069386779)*x_ref[0]**(o-1)+(0.457400568855)
        ref[3,4,1]=o*(-0.245839304835)*x_ref[1]**(o-1)+(-0.463000940469)
      else:
        arg[0,0]=(-0.0252675874258)*x[0]**o+(-0.998043629662)*x[0]+(-0.956603187221)*x[1]**o+(-0.642113208329)*x[1]+(-0.59687133215)*x[2]**o+(-0.222380006695)*x[2]
        arg[0,1]=(0.540057023826)*x[0]**o+(0.660021105706)*x[0]+(-0.0847035816563)*x[1]**o+(0.734935147879)*x[1]+(0.895080236848)*x[2]**o+(0.759076168225)*x[2]
        arg[0,2]=(0.208276460123)*x[0]**o+(-0.842726599314)*x[0]+(0.514146640689)*x[1]**o+(-0.931115443386)*x[1]+(-0.427990918054)*x[2]**o+(-0.0944702225036)*x[2]
        arg[0,3]=(-0.669873393665)*x[0]**o+(-0.164211687812)*x[0]+(0.257292402022)*x[1]**o+(0.788249196864)*x[1]+(-0.0160232742588)*x[2]**o+(0.593261720532)*x[2]
        arg[0,4]=(0.574685018662)*x[0]**o+(-0.404093341935)*x[0]+(-0.613704015926)*x[1]**o+(-0.388769512229)*x[1]+(0.65014059769)*x[2]**o+(0.796497720581)*x[2]
        arg[1,0]=(0.579425469692)*x[0]**o+(0.706786266065)*x[0]+(-0.489805412824)*x[1]**o+(0.412673120993)*x[1]+(-0.261487328773)*x[2]**o+(0.323016314178)*x[2]
        arg[1,1]=(-0.406115852457)*x[0]**o+(-0.320011474154)*x[0]+(0.83353566302)*x[1]**o+(-0.770757586792)*x[1]+(-0.497021878205)*x[2]**o+(-0.108546214912)*x[2]
        arg[1,2]=(-0.799159182698)*x[0]**o+(0.221424788319)*x[0]+(0.882092644719)*x[1]**o+(0.25804039903)*x[1]+(-0.788642442802)*x[2]**o+(-0.434293659417)*x[2]
        arg[1,3]=(-0.453596867354)*x[0]**o+(-0.855684542333)*x[0]+(0.421257402196)*x[1]**o+(0.162268279507)*x[1]+(-0.618396236314)*x[2]**o+(-0.650684413266)*x[2]
        arg[1,4]=(-0.464749011522)*x[0]**o+(-0.050661862641)*x[0]+(-0.7554290975)*x[1]**o+(-0.213826578781)*x[1]+(-0.536460109672)*x[2]**o+(-0.441490452069)*x[2]
        arg[2,0]=(0.335438338384)*x[0]**o+(-0.598515232086)*x[0]+(0.396958696838)*x[1]**o+(0.712094780848)*x[1]+(0.0112487672163)*x[2]**o+(-0.106361601342)*x[2]
        arg[2,1]=(0.157333767552)*x[0]**o+(0.763247557186)*x[0]+(0.454047596703)*x[1]**o+(0.874633696245)*x[1]+(0.80992740886)*x[2]**o+(-0.465565575276)*x[2]
        arg[2,2]=(-0.668932235683)*x[0]**o+(0.99055962791)*x[0]+(-0.473440344595)*x[1]**o+(-0.694789559356)*x[1]+(-0.337501506478)*x[2]**o+(-0.552461610916)*x[2]
        arg[2,3]=(-0.174040039098)*x[0]**o+(0.878604594327)*x[0]+(-0.488684761288)*x[1]**o+(-0.225626690649)*x[1]+(0.307550460093)*x[2]**o+(0.279172145442)*x[2]
        arg[2,4]=(0.771496476361)*x[0]**o+(-0.528231004311)*x[0]+(0.318620411204)*x[1]**o+(-0.831636376644)*x[1]+(-0.23477599759)*x[2]**o+(0.452986258707)*x[2]
        arg[3,0]=(0.689878836595)*x[0]**o+(-0.723887531161)*x[0]+(0.906077469738)*x[1]**o+(-0.729986756151)*x[1]+(0.860506345609)*x[2]**o+(-0.437203511895)*x[2]
        arg[3,1]=(0.867909616506)*x[0]**o+(-0.0480808079676)*x[0]+(-0.439925732789)*x[1]**o+(-0.753945614279)*x[1]+(-0.0015149141551)*x[2]**o+(-0.465559525628)*x[2]
        arg[3,2]=(0.915231983332)*x[0]**o+(0.77428136852)*x[0]+(0.902598621987)*x[1]**o+(-0.49204288782)*x[1]+(0.77362022057)*x[2]**o+(0.872135547313)*x[2]
        arg[3,3]=(0.274436414079)*x[0]**o+(-0.291721638943)*x[0]+(0.202501119852)*x[1]**o+(0.911330931145)*x[1]+(-0.61382801878)*x[2]**o+(0.386704897682)*x[2]
        arg[3,4]=(-0.0258695378217)*x[0]**o+(0.263046110195)*x[0]+(-0.162461126288)*x[1]**o+(-0.123570278155)*x[1]+(0.598012400912)*x[2]**o+(0.769951340801)*x[2]
        ref[0,0,0]=o*(-0.0252675874258)*x_ref[0]**(o-1)+(-0.998043629662)
        ref[0,0,1]=o*(-0.956603187221)*x_ref[1]**(o-1)+(-0.642113208329)
        ref[0,0,2]=o*(-0.59687133215)*x_ref[2]**(o-1)+(-0.222380006695)
        ref[0,1,0]=o*(0.540057023826)*x_ref[0]**(o-1)+(0.660021105706)
        ref[0,1,1]=o*(-0.0847035816563)*x_ref[1]**(o-1)+(0.734935147879)
        ref[0,1,2]=o*(0.895080236848)*x_ref[2]**(o-1)+(0.759076168225)
        ref[0,2,0]=o*(0.208276460123)*x_ref[0]**(o-1)+(-0.842726599314)
        ref[0,2,1]=o*(0.514146640689)*x_ref[1]**(o-1)+(-0.931115443386)
        ref[0,2,2]=o*(-0.427990918054)*x_ref[2]**(o-1)+(-0.0944702225036)
        ref[0,3,0]=o*(-0.669873393665)*x_ref[0]**(o-1)+(-0.164211687812)
        ref[0,3,1]=o*(0.257292402022)*x_ref[1]**(o-1)+(0.788249196864)
        ref[0,3,2]=o*(-0.0160232742588)*x_ref[2]**(o-1)+(0.593261720532)
        ref[0,4,0]=o*(0.574685018662)*x_ref[0]**(o-1)+(-0.404093341935)
        ref[0,4,1]=o*(-0.613704015926)*x_ref[1]**(o-1)+(-0.388769512229)
        ref[0,4,2]=o*(0.65014059769)*x_ref[2]**(o-1)+(0.796497720581)
        ref[1,0,0]=o*(0.579425469692)*x_ref[0]**(o-1)+(0.706786266065)
        ref[1,0,1]=o*(-0.489805412824)*x_ref[1]**(o-1)+(0.412673120993)
        ref[1,0,2]=o*(-0.261487328773)*x_ref[2]**(o-1)+(0.323016314178)
        ref[1,1,0]=o*(-0.406115852457)*x_ref[0]**(o-1)+(-0.320011474154)
        ref[1,1,1]=o*(0.83353566302)*x_ref[1]**(o-1)+(-0.770757586792)
        ref[1,1,2]=o*(-0.497021878205)*x_ref[2]**(o-1)+(-0.108546214912)
        ref[1,2,0]=o*(-0.799159182698)*x_ref[0]**(o-1)+(0.221424788319)
        ref[1,2,1]=o*(0.882092644719)*x_ref[1]**(o-1)+(0.25804039903)
        ref[1,2,2]=o*(-0.788642442802)*x_ref[2]**(o-1)+(-0.434293659417)
        ref[1,3,0]=o*(-0.453596867354)*x_ref[0]**(o-1)+(-0.855684542333)
        ref[1,3,1]=o*(0.421257402196)*x_ref[1]**(o-1)+(0.162268279507)
        ref[1,3,2]=o*(-0.618396236314)*x_ref[2]**(o-1)+(-0.650684413266)
        ref[1,4,0]=o*(-0.464749011522)*x_ref[0]**(o-1)+(-0.050661862641)
        ref[1,4,1]=o*(-0.7554290975)*x_ref[1]**(o-1)+(-0.213826578781)
        ref[1,4,2]=o*(-0.536460109672)*x_ref[2]**(o-1)+(-0.441490452069)
        ref[2,0,0]=o*(0.335438338384)*x_ref[0]**(o-1)+(-0.598515232086)
        ref[2,0,1]=o*(0.396958696838)*x_ref[1]**(o-1)+(0.712094780848)
        ref[2,0,2]=o*(0.0112487672163)*x_ref[2]**(o-1)+(-0.106361601342)
        ref[2,1,0]=o*(0.157333767552)*x_ref[0]**(o-1)+(0.763247557186)
        ref[2,1,1]=o*(0.454047596703)*x_ref[1]**(o-1)+(0.874633696245)
        ref[2,1,2]=o*(0.80992740886)*x_ref[2]**(o-1)+(-0.465565575276)
        ref[2,2,0]=o*(-0.668932235683)*x_ref[0]**(o-1)+(0.99055962791)
        ref[2,2,1]=o*(-0.473440344595)*x_ref[1]**(o-1)+(-0.694789559356)
        ref[2,2,2]=o*(-0.337501506478)*x_ref[2]**(o-1)+(-0.552461610916)
        ref[2,3,0]=o*(-0.174040039098)*x_ref[0]**(o-1)+(0.878604594327)
        ref[2,3,1]=o*(-0.488684761288)*x_ref[1]**(o-1)+(-0.225626690649)
        ref[2,3,2]=o*(0.307550460093)*x_ref[2]**(o-1)+(0.279172145442)
        ref[2,4,0]=o*(0.771496476361)*x_ref[0]**(o-1)+(-0.528231004311)
        ref[2,4,1]=o*(0.318620411204)*x_ref[1]**(o-1)+(-0.831636376644)
        ref[2,4,2]=o*(-0.23477599759)*x_ref[2]**(o-1)+(0.452986258707)
        ref[3,0,0]=o*(0.689878836595)*x_ref[0]**(o-1)+(-0.723887531161)
        ref[3,0,1]=o*(0.906077469738)*x_ref[1]**(o-1)+(-0.729986756151)
        ref[3,0,2]=o*(0.860506345609)*x_ref[2]**(o-1)+(-0.437203511895)
        ref[3,1,0]=o*(0.867909616506)*x_ref[0]**(o-1)+(-0.0480808079676)
        ref[3,1,1]=o*(-0.439925732789)*x_ref[1]**(o-1)+(-0.753945614279)
        ref[3,1,2]=o*(-0.0015149141551)*x_ref[2]**(o-1)+(-0.465559525628)
        ref[3,2,0]=o*(0.915231983332)*x_ref[0]**(o-1)+(0.77428136852)
        ref[3,2,1]=o*(0.902598621987)*x_ref[1]**(o-1)+(-0.49204288782)
        ref[3,2,2]=o*(0.77362022057)*x_ref[2]**(o-1)+(0.872135547313)
        ref[3,3,0]=o*(0.274436414079)*x_ref[0]**(o-1)+(-0.291721638943)
        ref[3,3,1]=o*(0.202501119852)*x_ref[1]**(o-1)+(0.911330931145)
        ref[3,3,2]=o*(-0.61382801878)*x_ref[2]**(o-1)+(0.386704897682)
        ref[3,4,0]=o*(-0.0258695378217)*x_ref[0]**(o-1)+(0.263046110195)
        ref[3,4,1]=o*(-0.162461126288)*x_ref[1]**(o-1)+(-0.123570278155)
        ref[3,4,2]=o*(0.598012400912)*x_ref[2]**(o-1)+(0.769951340801)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnBoundary_fromData_ContinuousFunction_rank3(self):
      """
      tests gradient for rank 3 Data on the ReducedFunctionOnBoundary

      assumptions: ContinuousFunction(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnBoundary
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=ContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(6, 2, 2),w)
      ref=Data(0,(6, 2, 2)+(dim,),w_ref)
      if dim==2:
        arg[0,0,0]=(-0.301542954432)*x[0]**o+(-0.126029003998)*x[0]+(-0.408561086014)*x[1]**o+(0.090642210886)*x[1]
        arg[0,0,1]=(0.456052591865)*x[0]**o+(0.624896766511)*x[0]+(0.87137087467)*x[1]**o+(-0.296114354421)*x[1]
        arg[0,1,0]=(0.370833001032)*x[0]**o+(-0.700862384031)*x[0]+(-0.276076372016)*x[1]**o+(-0.820884025764)*x[1]
        arg[0,1,1]=(0.550805148631)*x[0]**o+(-0.628825647329)*x[0]+(0.906362219793)*x[1]**o+(0.093148354989)*x[1]
        arg[1,0,0]=(-0.80347190678)*x[0]**o+(-0.112285193049)*x[0]+(-0.703090064994)*x[1]**o+(0.738893806856)*x[1]
        arg[1,0,1]=(0.716113817265)*x[0]**o+(-0.403563175278)*x[0]+(-0.545474326725)*x[1]**o+(-0.085377932579)*x[1]
        arg[1,1,0]=(0.0151945295253)*x[0]**o+(0.419681120006)*x[0]+(0.605889120207)*x[1]**o+(0.94921670969)*x[1]
        arg[1,1,1]=(0.330888675781)*x[0]**o+(0.536336632067)*x[0]+(0.130243661103)*x[1]**o+(0.249581698903)*x[1]
        arg[2,0,0]=(-0.94168189216)*x[0]**o+(0.42899125004)*x[0]+(0.104206704223)*x[1]**o+(0.992451993183)*x[1]
        arg[2,0,1]=(-0.557898869487)*x[0]**o+(-0.0387050073802)*x[0]+(-0.880396260326)*x[1]**o+(-0.649734782543)*x[1]
        arg[2,1,0]=(0.0362873703011)*x[0]**o+(0.641116555832)*x[0]+(-0.878565186806)*x[1]**o+(-0.305825058029)*x[1]
        arg[2,1,1]=(0.926144430868)*x[0]**o+(0.207902756992)*x[0]+(-0.823834000424)*x[1]**o+(0.541980766739)*x[1]
        arg[3,0,0]=(-0.497934527226)*x[0]**o+(0.904514339359)*x[0]+(0.0627382682436)*x[1]**o+(-0.886845257384)*x[1]
        arg[3,0,1]=(0.458163004678)*x[0]**o+(-0.890966354569)*x[0]+(0.779511556433)*x[1]**o+(0.911407858547)*x[1]
        arg[3,1,0]=(0.643197533583)*x[0]**o+(-0.445952483015)*x[0]+(-0.491648538422)*x[1]**o+(-0.339803793944)*x[1]
        arg[3,1,1]=(0.564910446806)*x[0]**o+(-0.251342703228)*x[0]+(-0.102526510378)*x[1]**o+(0.989034603428)*x[1]
        arg[4,0,0]=(0.0728812877818)*x[0]**o+(-0.160839673847)*x[0]+(0.078039622926)*x[1]**o+(-0.778740146006)*x[1]
        arg[4,0,1]=(-0.848970759855)*x[0]**o+(0.83795370612)*x[0]+(-0.652802628253)*x[1]**o+(0.570900978851)*x[1]
        arg[4,1,0]=(0.492154273484)*x[0]**o+(-0.138488354185)*x[0]+(0.269142955069)*x[1]**o+(-0.849995493706)*x[1]
        arg[4,1,1]=(0.945032529684)*x[0]**o+(0.611284327327)*x[0]+(0.549856083886)*x[1]**o+(0.347585489606)*x[1]
        arg[5,0,0]=(0.481456547858)*x[0]**o+(0.238848312219)*x[0]+(-0.5849679413)*x[1]**o+(-0.749140400072)*x[1]
        arg[5,0,1]=(0.27081490311)*x[0]**o+(-0.101642948148)*x[0]+(0.31847076679)*x[1]**o+(0.192182993758)*x[1]
        arg[5,1,0]=(-0.873348151897)*x[0]**o+(-0.613499952221)*x[0]+(0.54087826152)*x[1]**o+(-0.269096416524)*x[1]
        arg[5,1,1]=(-0.803277233859)*x[0]**o+(-0.714237882827)*x[0]+(-0.205544031812)*x[1]**o+(0.188144864673)*x[1]
        ref[0,0,0,0]=o*(-0.301542954432)*x_ref[0]**(o-1)+(-0.126029003998)
        ref[0,0,0,1]=o*(-0.408561086014)*x_ref[1]**(o-1)+(0.090642210886)
        ref[0,0,1,0]=o*(0.456052591865)*x_ref[0]**(o-1)+(0.624896766511)
        ref[0,0,1,1]=o*(0.87137087467)*x_ref[1]**(o-1)+(-0.296114354421)
        ref[0,1,0,0]=o*(0.370833001032)*x_ref[0]**(o-1)+(-0.700862384031)
        ref[0,1,0,1]=o*(-0.276076372016)*x_ref[1]**(o-1)+(-0.820884025764)
        ref[0,1,1,0]=o*(0.550805148631)*x_ref[0]**(o-1)+(-0.628825647329)
        ref[0,1,1,1]=o*(0.906362219793)*x_ref[1]**(o-1)+(0.093148354989)
        ref[1,0,0,0]=o*(-0.80347190678)*x_ref[0]**(o-1)+(-0.112285193049)
        ref[1,0,0,1]=o*(-0.703090064994)*x_ref[1]**(o-1)+(0.738893806856)
        ref[1,0,1,0]=o*(0.716113817265)*x_ref[0]**(o-1)+(-0.403563175278)
        ref[1,0,1,1]=o*(-0.545474326725)*x_ref[1]**(o-1)+(-0.085377932579)
        ref[1,1,0,0]=o*(0.0151945295253)*x_ref[0]**(o-1)+(0.419681120006)
        ref[1,1,0,1]=o*(0.605889120207)*x_ref[1]**(o-1)+(0.94921670969)
        ref[1,1,1,0]=o*(0.330888675781)*x_ref[0]**(o-1)+(0.536336632067)
        ref[1,1,1,1]=o*(0.130243661103)*x_ref[1]**(o-1)+(0.249581698903)
        ref[2,0,0,0]=o*(-0.94168189216)*x_ref[0]**(o-1)+(0.42899125004)
        ref[2,0,0,1]=o*(0.104206704223)*x_ref[1]**(o-1)+(0.992451993183)
        ref[2,0,1,0]=o*(-0.557898869487)*x_ref[0]**(o-1)+(-0.0387050073802)
        ref[2,0,1,1]=o*(-0.880396260326)*x_ref[1]**(o-1)+(-0.649734782543)
        ref[2,1,0,0]=o*(0.0362873703011)*x_ref[0]**(o-1)+(0.641116555832)
        ref[2,1,0,1]=o*(-0.878565186806)*x_ref[1]**(o-1)+(-0.305825058029)
        ref[2,1,1,0]=o*(0.926144430868)*x_ref[0]**(o-1)+(0.207902756992)
        ref[2,1,1,1]=o*(-0.823834000424)*x_ref[1]**(o-1)+(0.541980766739)
        ref[3,0,0,0]=o*(-0.497934527226)*x_ref[0]**(o-1)+(0.904514339359)
        ref[3,0,0,1]=o*(0.0627382682436)*x_ref[1]**(o-1)+(-0.886845257384)
        ref[3,0,1,0]=o*(0.458163004678)*x_ref[0]**(o-1)+(-0.890966354569)
        ref[3,0,1,1]=o*(0.779511556433)*x_ref[1]**(o-1)+(0.911407858547)
        ref[3,1,0,0]=o*(0.643197533583)*x_ref[0]**(o-1)+(-0.445952483015)
        ref[3,1,0,1]=o*(-0.491648538422)*x_ref[1]**(o-1)+(-0.339803793944)
        ref[3,1,1,0]=o*(0.564910446806)*x_ref[0]**(o-1)+(-0.251342703228)
        ref[3,1,1,1]=o*(-0.102526510378)*x_ref[1]**(o-1)+(0.989034603428)
        ref[4,0,0,0]=o*(0.0728812877818)*x_ref[0]**(o-1)+(-0.160839673847)
        ref[4,0,0,1]=o*(0.078039622926)*x_ref[1]**(o-1)+(-0.778740146006)
        ref[4,0,1,0]=o*(-0.848970759855)*x_ref[0]**(o-1)+(0.83795370612)
        ref[4,0,1,1]=o*(-0.652802628253)*x_ref[1]**(o-1)+(0.570900978851)
        ref[4,1,0,0]=o*(0.492154273484)*x_ref[0]**(o-1)+(-0.138488354185)
        ref[4,1,0,1]=o*(0.269142955069)*x_ref[1]**(o-1)+(-0.849995493706)
        ref[4,1,1,0]=o*(0.945032529684)*x_ref[0]**(o-1)+(0.611284327327)
        ref[4,1,1,1]=o*(0.549856083886)*x_ref[1]**(o-1)+(0.347585489606)
        ref[5,0,0,0]=o*(0.481456547858)*x_ref[0]**(o-1)+(0.238848312219)
        ref[5,0,0,1]=o*(-0.5849679413)*x_ref[1]**(o-1)+(-0.749140400072)
        ref[5,0,1,0]=o*(0.27081490311)*x_ref[0]**(o-1)+(-0.101642948148)
        ref[5,0,1,1]=o*(0.31847076679)*x_ref[1]**(o-1)+(0.192182993758)
        ref[5,1,0,0]=o*(-0.873348151897)*x_ref[0]**(o-1)+(-0.613499952221)
        ref[5,1,0,1]=o*(0.54087826152)*x_ref[1]**(o-1)+(-0.269096416524)
        ref[5,1,1,0]=o*(-0.803277233859)*x_ref[0]**(o-1)+(-0.714237882827)
        ref[5,1,1,1]=o*(-0.205544031812)*x_ref[1]**(o-1)+(0.188144864673)
      else:
        arg[0,0,0]=(-0.639251981322)*x[0]**o+(-0.115972267818)*x[0]+(0.491134645863)*x[1]**o+(0.345343639029)*x[1]+(-0.663597762251)*x[2]**o+(-0.328150609455)*x[2]
        arg[0,0,1]=(-0.76280151252)*x[0]**o+(0.933789965647)*x[0]+(-0.117386438957)*x[1]**o+(0.738801880577)*x[1]+(-0.823759196233)*x[2]**o+(-0.591225057134)*x[2]
        arg[0,1,0]=(-0.515479158328)*x[0]**o+(-0.498840147412)*x[0]+(-0.07870152457)*x[1]**o+(0.240823897179)*x[1]+(-0.529483054724)*x[2]**o+(0.957444878465)*x[2]
        arg[0,1,1]=(0.659163197783)*x[0]**o+(-0.987017484017)*x[0]+(0.316073196672)*x[1]**o+(-0.858184573568)*x[1]+(-0.324909144593)*x[2]**o+(-0.89624674398)*x[2]
        arg[1,0,0]=(0.582390600104)*x[0]**o+(-0.808724939916)*x[0]+(-0.204186916478)*x[1]**o+(0.63212764696)*x[1]+(-0.272947627588)*x[2]**o+(-0.133369751815)*x[2]
        arg[1,0,1]=(-0.955892141909)*x[0]**o+(0.915832405494)*x[0]+(-0.823428836636)*x[1]**o+(-0.527176552593)*x[1]+(-0.439872810771)*x[2]**o+(0.282431362763)*x[2]
        arg[1,1,0]=(0.269192050139)*x[0]**o+(0.304289733459)*x[0]+(-0.252137123064)*x[1]**o+(0.159346881758)*x[1]+(-0.875713938743)*x[2]**o+(-0.804681982204)*x[2]
        arg[1,1,1]=(0.100159906585)*x[0]**o+(0.652670710888)*x[0]+(-0.0471177296503)*x[1]**o+(0.15344212377)*x[1]+(0.162356023341)*x[2]**o+(0.242855769737)*x[2]
        arg[2,0,0]=(-0.0214334988311)*x[0]**o+(0.444654672491)*x[0]+(0.235478960156)*x[1]**o+(0.62191559883)*x[1]+(0.124531773653)*x[2]**o+(-0.603748942811)*x[2]
        arg[2,0,1]=(-0.00696114124898)*x[0]**o+(-0.350635993795)*x[0]+(0.766513244466)*x[1]**o+(-0.99996024111)*x[1]+(0.976036637033)*x[2]**o+(0.00703160282837)*x[2]
        arg[2,1,0]=(-0.210499708873)*x[0]**o+(-0.763641982769)*x[0]+(0.435435481771)*x[1]**o+(0.0886400511888)*x[1]+(0.540913993886)*x[2]**o+(-0.864904989707)*x[2]
        arg[2,1,1]=(0.609017357846)*x[0]**o+(-0.681305727596)*x[0]+(-0.291763309802)*x[1]**o+(0.12465245807)*x[1]+(-0.265362499082)*x[2]**o+(-0.978509447338)*x[2]
        arg[3,0,0]=(0.622861389608)*x[0]**o+(-0.341108338962)*x[0]+(0.908588438318)*x[1]**o+(-0.583012719535)*x[1]+(0.33513654797)*x[2]**o+(-0.835513934636)*x[2]
        arg[3,0,1]=(0.164841305439)*x[0]**o+(-0.622242302911)*x[0]+(-0.0469305037163)*x[1]**o+(-0.859517953063)*x[1]+(-0.112485630662)*x[2]**o+(0.31475831421)*x[2]
        arg[3,1,0]=(-0.177913851996)*x[0]**o+(0.74607750787)*x[0]+(-0.188838634745)*x[1]**o+(-0.803617744529)*x[1]+(0.18839438068)*x[2]**o+(-0.857696671728)*x[2]
        arg[3,1,1]=(0.485172697497)*x[0]**o+(-0.554750723313)*x[0]+(-0.59838039994)*x[1]**o+(-0.83177053032)*x[1]+(0.655490277067)*x[2]**o+(0.0645924856059)*x[2]
        arg[4,0,0]=(0.900678166492)*x[0]**o+(-0.485573346705)*x[0]+(0.0108149783491)*x[1]**o+(0.982616024342)*x[1]+(-0.374371784319)*x[2]**o+(-0.825014166204)*x[2]
        arg[4,0,1]=(0.682753472393)*x[0]**o+(0.810927347906)*x[0]+(-0.128780174224)*x[1]**o+(0.514607304836)*x[1]+(0.606285011416)*x[2]**o+(-0.691191486471)*x[2]
        arg[4,1,0]=(0.0103661338625)*x[0]**o+(0.184111752707)*x[0]+(-0.270751890504)*x[1]**o+(0.207351712222)*x[1]+(-0.366280871535)*x[2]**o+(-0.638450092731)*x[2]
        arg[4,1,1]=(-0.111302974207)*x[0]**o+(-0.520252159917)*x[0]+(-0.911197545741)*x[1]**o+(-0.779732160528)*x[1]+(-0.443379349795)*x[2]**o+(-0.783540988384)*x[2]
        arg[5,0,0]=(0.319701766792)*x[0]**o+(-0.953929305858)*x[0]+(-0.783942145061)*x[1]**o+(0.687992583635)*x[1]+(0.873868267323)*x[2]**o+(-0.204836707955)*x[2]
        arg[5,0,1]=(-0.240340717622)*x[0]**o+(-0.799598459684)*x[0]+(-0.827096078861)*x[1]**o+(0.229071234102)*x[1]+(0.309197705487)*x[2]**o+(-0.286088934882)*x[2]
        arg[5,1,0]=(-0.0926450319507)*x[0]**o+(0.638985747884)*x[0]+(0.604913216138)*x[1]**o+(-0.364251815312)*x[1]+(-0.47971664069)*x[2]**o+(-0.20655528518)*x[2]
        arg[5,1,1]=(0.418341452333)*x[0]**o+(0.430002851684)*x[0]+(0.624025385599)*x[1]**o+(0.338601201629)*x[1]+(0.0900364406242)*x[2]**o+(0.193533337073)*x[2]
        ref[0,0,0,0]=o*(-0.639251981322)*x_ref[0]**(o-1)+(-0.115972267818)
        ref[0,0,0,1]=o*(0.491134645863)*x_ref[1]**(o-1)+(0.345343639029)
        ref[0,0,0,2]=o*(-0.663597762251)*x_ref[2]**(o-1)+(-0.328150609455)
        ref[0,0,1,0]=o*(-0.76280151252)*x_ref[0]**(o-1)+(0.933789965647)
        ref[0,0,1,1]=o*(-0.117386438957)*x_ref[1]**(o-1)+(0.738801880577)
        ref[0,0,1,2]=o*(-0.823759196233)*x_ref[2]**(o-1)+(-0.591225057134)
        ref[0,1,0,0]=o*(-0.515479158328)*x_ref[0]**(o-1)+(-0.498840147412)
        ref[0,1,0,1]=o*(-0.07870152457)*x_ref[1]**(o-1)+(0.240823897179)
        ref[0,1,0,2]=o*(-0.529483054724)*x_ref[2]**(o-1)+(0.957444878465)
        ref[0,1,1,0]=o*(0.659163197783)*x_ref[0]**(o-1)+(-0.987017484017)
        ref[0,1,1,1]=o*(0.316073196672)*x_ref[1]**(o-1)+(-0.858184573568)
        ref[0,1,1,2]=o*(-0.324909144593)*x_ref[2]**(o-1)+(-0.89624674398)
        ref[1,0,0,0]=o*(0.582390600104)*x_ref[0]**(o-1)+(-0.808724939916)
        ref[1,0,0,1]=o*(-0.204186916478)*x_ref[1]**(o-1)+(0.63212764696)
        ref[1,0,0,2]=o*(-0.272947627588)*x_ref[2]**(o-1)+(-0.133369751815)
        ref[1,0,1,0]=o*(-0.955892141909)*x_ref[0]**(o-1)+(0.915832405494)
        ref[1,0,1,1]=o*(-0.823428836636)*x_ref[1]**(o-1)+(-0.527176552593)
        ref[1,0,1,2]=o*(-0.439872810771)*x_ref[2]**(o-1)+(0.282431362763)
        ref[1,1,0,0]=o*(0.269192050139)*x_ref[0]**(o-1)+(0.304289733459)
        ref[1,1,0,1]=o*(-0.252137123064)*x_ref[1]**(o-1)+(0.159346881758)
        ref[1,1,0,2]=o*(-0.875713938743)*x_ref[2]**(o-1)+(-0.804681982204)
        ref[1,1,1,0]=o*(0.100159906585)*x_ref[0]**(o-1)+(0.652670710888)
        ref[1,1,1,1]=o*(-0.0471177296503)*x_ref[1]**(o-1)+(0.15344212377)
        ref[1,1,1,2]=o*(0.162356023341)*x_ref[2]**(o-1)+(0.242855769737)
        ref[2,0,0,0]=o*(-0.0214334988311)*x_ref[0]**(o-1)+(0.444654672491)
        ref[2,0,0,1]=o*(0.235478960156)*x_ref[1]**(o-1)+(0.62191559883)
        ref[2,0,0,2]=o*(0.124531773653)*x_ref[2]**(o-1)+(-0.603748942811)
        ref[2,0,1,0]=o*(-0.00696114124898)*x_ref[0]**(o-1)+(-0.350635993795)
        ref[2,0,1,1]=o*(0.766513244466)*x_ref[1]**(o-1)+(-0.99996024111)
        ref[2,0,1,2]=o*(0.976036637033)*x_ref[2]**(o-1)+(0.00703160282837)
        ref[2,1,0,0]=o*(-0.210499708873)*x_ref[0]**(o-1)+(-0.763641982769)
        ref[2,1,0,1]=o*(0.435435481771)*x_ref[1]**(o-1)+(0.0886400511888)
        ref[2,1,0,2]=o*(0.540913993886)*x_ref[2]**(o-1)+(-0.864904989707)
        ref[2,1,1,0]=o*(0.609017357846)*x_ref[0]**(o-1)+(-0.681305727596)
        ref[2,1,1,1]=o*(-0.291763309802)*x_ref[1]**(o-1)+(0.12465245807)
        ref[2,1,1,2]=o*(-0.265362499082)*x_ref[2]**(o-1)+(-0.978509447338)
        ref[3,0,0,0]=o*(0.622861389608)*x_ref[0]**(o-1)+(-0.341108338962)
        ref[3,0,0,1]=o*(0.908588438318)*x_ref[1]**(o-1)+(-0.583012719535)
        ref[3,0,0,2]=o*(0.33513654797)*x_ref[2]**(o-1)+(-0.835513934636)
        ref[3,0,1,0]=o*(0.164841305439)*x_ref[0]**(o-1)+(-0.622242302911)
        ref[3,0,1,1]=o*(-0.0469305037163)*x_ref[1]**(o-1)+(-0.859517953063)
        ref[3,0,1,2]=o*(-0.112485630662)*x_ref[2]**(o-1)+(0.31475831421)
        ref[3,1,0,0]=o*(-0.177913851996)*x_ref[0]**(o-1)+(0.74607750787)
        ref[3,1,0,1]=o*(-0.188838634745)*x_ref[1]**(o-1)+(-0.803617744529)
        ref[3,1,0,2]=o*(0.18839438068)*x_ref[2]**(o-1)+(-0.857696671728)
        ref[3,1,1,0]=o*(0.485172697497)*x_ref[0]**(o-1)+(-0.554750723313)
        ref[3,1,1,1]=o*(-0.59838039994)*x_ref[1]**(o-1)+(-0.83177053032)
        ref[3,1,1,2]=o*(0.655490277067)*x_ref[2]**(o-1)+(0.0645924856059)
        ref[4,0,0,0]=o*(0.900678166492)*x_ref[0]**(o-1)+(-0.485573346705)
        ref[4,0,0,1]=o*(0.0108149783491)*x_ref[1]**(o-1)+(0.982616024342)
        ref[4,0,0,2]=o*(-0.374371784319)*x_ref[2]**(o-1)+(-0.825014166204)
        ref[4,0,1,0]=o*(0.682753472393)*x_ref[0]**(o-1)+(0.810927347906)
        ref[4,0,1,1]=o*(-0.128780174224)*x_ref[1]**(o-1)+(0.514607304836)
        ref[4,0,1,2]=o*(0.606285011416)*x_ref[2]**(o-1)+(-0.691191486471)
        ref[4,1,0,0]=o*(0.0103661338625)*x_ref[0]**(o-1)+(0.184111752707)
        ref[4,1,0,1]=o*(-0.270751890504)*x_ref[1]**(o-1)+(0.207351712222)
        ref[4,1,0,2]=o*(-0.366280871535)*x_ref[2]**(o-1)+(-0.638450092731)
        ref[4,1,1,0]=o*(-0.111302974207)*x_ref[0]**(o-1)+(-0.520252159917)
        ref[4,1,1,1]=o*(-0.911197545741)*x_ref[1]**(o-1)+(-0.779732160528)
        ref[4,1,1,2]=o*(-0.443379349795)*x_ref[2]**(o-1)+(-0.783540988384)
        ref[5,0,0,0]=o*(0.319701766792)*x_ref[0]**(o-1)+(-0.953929305858)
        ref[5,0,0,1]=o*(-0.783942145061)*x_ref[1]**(o-1)+(0.687992583635)
        ref[5,0,0,2]=o*(0.873868267323)*x_ref[2]**(o-1)+(-0.204836707955)
        ref[5,0,1,0]=o*(-0.240340717622)*x_ref[0]**(o-1)+(-0.799598459684)
        ref[5,0,1,1]=o*(-0.827096078861)*x_ref[1]**(o-1)+(0.229071234102)
        ref[5,0,1,2]=o*(0.309197705487)*x_ref[2]**(o-1)+(-0.286088934882)
        ref[5,1,0,0]=o*(-0.0926450319507)*x_ref[0]**(o-1)+(0.638985747884)
        ref[5,1,0,1]=o*(0.604913216138)*x_ref[1]**(o-1)+(-0.364251815312)
        ref[5,1,0,2]=o*(-0.47971664069)*x_ref[2]**(o-1)+(-0.20655528518)
        ref[5,1,1,0]=o*(0.418341452333)*x_ref[0]**(o-1)+(0.430002851684)
        ref[5,1,1,1]=o*(0.624025385599)*x_ref[1]**(o-1)+(0.338601201629)
        ref[5,1,1,2]=o*(0.0900364406242)*x_ref[2]**(o-1)+(0.193533337073)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnBoundary_fromData_Solution_rank0(self):
      """
      tests gradient for rank 0 Data on the ReducedFunctionOnBoundary

      assumptions: Solution(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnBoundary
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=Solution(self.domain)
      x=w.getX()
      arg=Data(0,(),w)
      ref=Data(0,()+(dim,),w_ref)
      if dim==2:
        arg=(0.828412007781)*x[0]**o+(0.392494008682)*x[0]+(0.424780018344)*x[1]**o+(-0.75790685259)*x[1]
        ref[0]=o*(0.828412007781)*x_ref[0]**(o-1)+(0.392494008682)
        ref[1]=o*(0.424780018344)*x_ref[1]**(o-1)+(-0.75790685259)
      else:
        arg=(0.0243949626425)*x[0]**o+(0.99040714323)*x[0]+(0.455478130443)*x[1]**o+(-0.917504050554)*x[1]+(-0.642882027126)*x[2]**o+(-0.0751962677977)*x[2]
        ref[0]=o*(0.0243949626425)*x_ref[0]**(o-1)+(0.99040714323)
        ref[1]=o*(0.455478130443)*x_ref[1]**(o-1)+(-0.917504050554)
        ref[2]=o*(-0.642882027126)*x_ref[2]**(o-1)+(-0.0751962677977)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),()+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnBoundary_fromData_Solution_rank1(self):
      """
      tests gradient for rank 1 Data on the ReducedFunctionOnBoundary

      assumptions: Solution(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnBoundary
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=Solution(self.domain)
      x=w.getX()
      arg=Data(0,(2,),w)
      ref=Data(0,(2,)+(dim,),w_ref)
      if dim==2:
        arg[0]=(-0.107613645086)*x[0]**o+(-0.942156383662)*x[0]+(0.294425370324)*x[1]**o+(-0.177019031098)*x[1]
        arg[1]=(-0.120283674295)*x[0]**o+(-0.0644985036825)*x[0]+(-0.818412208612)*x[1]**o+(-0.375335380433)*x[1]
        ref[0,0]=o*(-0.107613645086)*x_ref[0]**(o-1)+(-0.942156383662)
        ref[0,1]=o*(0.294425370324)*x_ref[1]**(o-1)+(-0.177019031098)
        ref[1,0]=o*(-0.120283674295)*x_ref[0]**(o-1)+(-0.0644985036825)
        ref[1,1]=o*(-0.818412208612)*x_ref[1]**(o-1)+(-0.375335380433)
      else:
        arg[0]=(-0.888739890088)*x[0]**o+(0.874877363684)*x[0]+(-0.104101311962)*x[1]**o+(-0.124590333446)*x[1]+(-0.311645832684)*x[2]**o+(-0.249470325769)*x[2]
        arg[1]=(0.680288601947)*x[0]**o+(0.0595361804285)*x[0]+(-0.477099840976)*x[1]**o+(-0.695340106154)*x[1]+(-0.371044873416)*x[2]**o+(-0.442877128189)*x[2]
        ref[0,0]=o*(-0.888739890088)*x_ref[0]**(o-1)+(0.874877363684)
        ref[0,1]=o*(-0.104101311962)*x_ref[1]**(o-1)+(-0.124590333446)
        ref[0,2]=o*(-0.311645832684)*x_ref[2]**(o-1)+(-0.249470325769)
        ref[1,0]=o*(0.680288601947)*x_ref[0]**(o-1)+(0.0595361804285)
        ref[1,1]=o*(-0.477099840976)*x_ref[1]**(o-1)+(-0.695340106154)
        ref[1,2]=o*(-0.371044873416)*x_ref[2]**(o-1)+(-0.442877128189)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnBoundary_fromData_Solution_rank2(self):
      """
      tests gradient for rank 2 Data on the ReducedFunctionOnBoundary

      assumptions: Solution(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnBoundary
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=Solution(self.domain)
      x=w.getX()
      arg=Data(0,(4, 5),w)
      ref=Data(0,(4, 5)+(dim,),w_ref)
      if dim==2:
        arg[0,0]=(0.0237486351119)*x[0]**o+(0.751375149587)*x[0]+(0.0776560601509)*x[1]**o+(-0.363340006998)*x[1]
        arg[0,1]=(0.129612138219)*x[0]**o+(0.377878821946)*x[0]+(0.166470268672)*x[1]**o+(-0.0442064974104)*x[1]
        arg[0,2]=(0.692350462477)*x[0]**o+(-0.439155965586)*x[0]+(0.655583353562)*x[1]**o+(0.3753639938)*x[1]
        arg[0,3]=(-0.909698820615)*x[0]**o+(0.382887632024)*x[0]+(-0.108821308794)*x[1]**o+(0.330111344773)*x[1]
        arg[0,4]=(-0.694552793316)*x[0]**o+(-0.38920298235)*x[0]+(0.174040833682)*x[1]**o+(-0.41756882346)*x[1]
        arg[1,0]=(-0.194901264915)*x[0]**o+(-0.325546767846)*x[0]+(0.507614203136)*x[1]**o+(-0.964255763976)*x[1]
        arg[1,1]=(-0.634480793567)*x[0]**o+(0.787029027123)*x[0]+(-0.067769912764)*x[1]**o+(0.439969554037)*x[1]
        arg[1,2]=(-0.59461925815)*x[0]**o+(-0.799215148911)*x[0]+(-0.286848861016)*x[1]**o+(-0.0274325066994)*x[1]
        arg[1,3]=(0.564664310607)*x[0]**o+(-0.00188717695265)*x[0]+(0.984042638249)*x[1]**o+(-0.524339915306)*x[1]
        arg[1,4]=(-0.673190201485)*x[0]**o+(0.149574403846)*x[0]+(0.667179612419)*x[1]**o+(-0.279377079395)*x[1]
        arg[2,0]=(0.270490028978)*x[0]**o+(0.498901404478)*x[0]+(0.485707956493)*x[1]**o+(-0.340861889384)*x[1]
        arg[2,1]=(-0.785952730285)*x[0]**o+(0.514446635701)*x[0]+(0.925557655147)*x[1]**o+(0.616971745561)*x[1]
        arg[2,2]=(0.788196502068)*x[0]**o+(0.651461860731)*x[0]+(0.160564742956)*x[1]**o+(-0.681831134057)*x[1]
        arg[2,3]=(0.892258488111)*x[0]**o+(0.752252063583)*x[0]+(0.853514779349)*x[1]**o+(-0.181884189513)*x[1]
        arg[2,4]=(-0.824886296933)*x[0]**o+(0.211931432354)*x[0]+(0.924362197939)*x[1]**o+(0.036482432278)*x[1]
        arg[3,0]=(-0.0616004277583)*x[0]**o+(-0.77338193907)*x[0]+(-0.966899521855)*x[1]**o+(-0.395764830291)*x[1]
        arg[3,1]=(-0.607976110595)*x[0]**o+(-0.448875768616)*x[0]+(-0.414034580078)*x[1]**o+(0.185483819416)*x[1]
        arg[3,2]=(-0.918071244524)*x[0]**o+(0.924225885038)*x[0]+(0.418000509852)*x[1]**o+(0.431330768344)*x[1]
        arg[3,3]=(0.897504318738)*x[0]**o+(0.66265738089)*x[0]+(0.720830604485)*x[1]**o+(-0.713433930025)*x[1]
        arg[3,4]=(0.526823069245)*x[0]**o+(-0.255965317744)*x[0]+(-0.326371546564)*x[1]**o+(-0.436881501009)*x[1]
        ref[0,0,0]=o*(0.0237486351119)*x_ref[0]**(o-1)+(0.751375149587)
        ref[0,0,1]=o*(0.0776560601509)*x_ref[1]**(o-1)+(-0.363340006998)
        ref[0,1,0]=o*(0.129612138219)*x_ref[0]**(o-1)+(0.377878821946)
        ref[0,1,1]=o*(0.166470268672)*x_ref[1]**(o-1)+(-0.0442064974104)
        ref[0,2,0]=o*(0.692350462477)*x_ref[0]**(o-1)+(-0.439155965586)
        ref[0,2,1]=o*(0.655583353562)*x_ref[1]**(o-1)+(0.3753639938)
        ref[0,3,0]=o*(-0.909698820615)*x_ref[0]**(o-1)+(0.382887632024)
        ref[0,3,1]=o*(-0.108821308794)*x_ref[1]**(o-1)+(0.330111344773)
        ref[0,4,0]=o*(-0.694552793316)*x_ref[0]**(o-1)+(-0.38920298235)
        ref[0,4,1]=o*(0.174040833682)*x_ref[1]**(o-1)+(-0.41756882346)
        ref[1,0,0]=o*(-0.194901264915)*x_ref[0]**(o-1)+(-0.325546767846)
        ref[1,0,1]=o*(0.507614203136)*x_ref[1]**(o-1)+(-0.964255763976)
        ref[1,1,0]=o*(-0.634480793567)*x_ref[0]**(o-1)+(0.787029027123)
        ref[1,1,1]=o*(-0.067769912764)*x_ref[1]**(o-1)+(0.439969554037)
        ref[1,2,0]=o*(-0.59461925815)*x_ref[0]**(o-1)+(-0.799215148911)
        ref[1,2,1]=o*(-0.286848861016)*x_ref[1]**(o-1)+(-0.0274325066994)
        ref[1,3,0]=o*(0.564664310607)*x_ref[0]**(o-1)+(-0.00188717695265)
        ref[1,3,1]=o*(0.984042638249)*x_ref[1]**(o-1)+(-0.524339915306)
        ref[1,4,0]=o*(-0.673190201485)*x_ref[0]**(o-1)+(0.149574403846)
        ref[1,4,1]=o*(0.667179612419)*x_ref[1]**(o-1)+(-0.279377079395)
        ref[2,0,0]=o*(0.270490028978)*x_ref[0]**(o-1)+(0.498901404478)
        ref[2,0,1]=o*(0.485707956493)*x_ref[1]**(o-1)+(-0.340861889384)
        ref[2,1,0]=o*(-0.785952730285)*x_ref[0]**(o-1)+(0.514446635701)
        ref[2,1,1]=o*(0.925557655147)*x_ref[1]**(o-1)+(0.616971745561)
        ref[2,2,0]=o*(0.788196502068)*x_ref[0]**(o-1)+(0.651461860731)
        ref[2,2,1]=o*(0.160564742956)*x_ref[1]**(o-1)+(-0.681831134057)
        ref[2,3,0]=o*(0.892258488111)*x_ref[0]**(o-1)+(0.752252063583)
        ref[2,3,1]=o*(0.853514779349)*x_ref[1]**(o-1)+(-0.181884189513)
        ref[2,4,0]=o*(-0.824886296933)*x_ref[0]**(o-1)+(0.211931432354)
        ref[2,4,1]=o*(0.924362197939)*x_ref[1]**(o-1)+(0.036482432278)
        ref[3,0,0]=o*(-0.0616004277583)*x_ref[0]**(o-1)+(-0.77338193907)
        ref[3,0,1]=o*(-0.966899521855)*x_ref[1]**(o-1)+(-0.395764830291)
        ref[3,1,0]=o*(-0.607976110595)*x_ref[0]**(o-1)+(-0.448875768616)
        ref[3,1,1]=o*(-0.414034580078)*x_ref[1]**(o-1)+(0.185483819416)
        ref[3,2,0]=o*(-0.918071244524)*x_ref[0]**(o-1)+(0.924225885038)
        ref[3,2,1]=o*(0.418000509852)*x_ref[1]**(o-1)+(0.431330768344)
        ref[3,3,0]=o*(0.897504318738)*x_ref[0]**(o-1)+(0.66265738089)
        ref[3,3,1]=o*(0.720830604485)*x_ref[1]**(o-1)+(-0.713433930025)
        ref[3,4,0]=o*(0.526823069245)*x_ref[0]**(o-1)+(-0.255965317744)
        ref[3,4,1]=o*(-0.326371546564)*x_ref[1]**(o-1)+(-0.436881501009)
      else:
        arg[0,0]=(-0.66471814098)*x[0]**o+(0.417241001417)*x[0]+(-0.228677853733)*x[1]**o+(-0.706946716128)*x[1]+(0.977168565988)*x[2]**o+(-0.0293128613918)*x[2]
        arg[0,1]=(-0.161577085067)*x[0]**o+(0.86957667281)*x[0]+(-0.246783815579)*x[1]**o+(0.495318651008)*x[1]+(-0.500962203485)*x[2]**o+(0.903521194042)*x[2]
        arg[0,2]=(0.0764824142976)*x[0]**o+(-0.0831710166954)*x[0]+(0.538063052387)*x[1]**o+(0.472451075914)*x[1]+(-0.354702552367)*x[2]**o+(-0.820126246007)*x[2]
        arg[0,3]=(-0.286219487301)*x[0]**o+(0.561959250696)*x[0]+(-0.65668352495)*x[1]**o+(-0.276560290133)*x[1]+(-0.500866980002)*x[2]**o+(0.71188245613)*x[2]
        arg[0,4]=(-0.13704169085)*x[0]**o+(0.107954139186)*x[0]+(0.498233399424)*x[1]**o+(-0.201539549426)*x[1]+(-0.889578977028)*x[2]**o+(0.33670078332)*x[2]
        arg[1,0]=(0.411075168668)*x[0]**o+(-0.982783292982)*x[0]+(0.919652087888)*x[1]**o+(0.657917523808)*x[1]+(-0.220747064163)*x[2]**o+(-0.65863499098)*x[2]
        arg[1,1]=(0.978122893048)*x[0]**o+(-0.638310308996)*x[0]+(-0.182955841813)*x[1]**o+(0.386322350256)*x[1]+(0.0238129376001)*x[2]**o+(0.415141411589)*x[2]
        arg[1,2]=(-0.410102590894)*x[0]**o+(-0.0527422034609)*x[0]+(0.218532590216)*x[1]**o+(0.338645963161)*x[1]+(-0.559262295901)*x[2]**o+(0.00154425206109)*x[2]
        arg[1,3]=(-0.509603507286)*x[0]**o+(0.220014659177)*x[0]+(-0.850244819031)*x[1]**o+(0.851103142912)*x[1]+(0.485740207202)*x[2]**o+(0.625073715619)*x[2]
        arg[1,4]=(-0.990056784415)*x[0]**o+(0.822920800823)*x[0]+(-0.310061384265)*x[1]**o+(-0.337394401914)*x[1]+(0.139776472055)*x[2]**o+(0.615477120599)*x[2]
        arg[2,0]=(0.434733128443)*x[0]**o+(-0.23992608444)*x[0]+(0.532847685888)*x[1]**o+(0.641963266518)*x[1]+(-0.421857805771)*x[2]**o+(0.385408885641)*x[2]
        arg[2,1]=(0.502146118236)*x[0]**o+(-0.476835388064)*x[0]+(-0.676891574566)*x[1]**o+(0.713401740075)*x[1]+(0.220183315534)*x[2]**o+(-0.863327755288)*x[2]
        arg[2,2]=(-0.694614904655)*x[0]**o+(-0.881664834998)*x[0]+(0.318605270866)*x[1]**o+(0.55884249433)*x[1]+(0.286031997395)*x[2]**o+(-0.947477517785)*x[2]
        arg[2,3]=(-0.046201338948)*x[0]**o+(-0.316456331808)*x[0]+(0.968975602807)*x[1]**o+(0.549024517551)*x[1]+(-0.473260734234)*x[2]**o+(0.889462696171)*x[2]
        arg[2,4]=(0.316754513953)*x[0]**o+(0.43553288512)*x[0]+(0.962932728727)*x[1]**o+(0.887900662435)*x[1]+(-0.235820939423)*x[2]**o+(0.947057541177)*x[2]
        arg[3,0]=(-0.835914763446)*x[0]**o+(-0.488811438785)*x[0]+(-0.573283060197)*x[1]**o+(0.963078263225)*x[1]+(0.601345307969)*x[2]**o+(-0.185658285596)*x[2]
        arg[3,1]=(0.597606596118)*x[0]**o+(0.0839878651552)*x[0]+(0.0836232765815)*x[1]**o+(0.594866612681)*x[1]+(-0.361174348867)*x[2]**o+(0.701364726038)*x[2]
        arg[3,2]=(-0.172328462662)*x[0]**o+(-0.856154059105)*x[0]+(0.533657669403)*x[1]**o+(-0.305657234912)*x[1]+(0.828787414246)*x[2]**o+(0.993286809537)*x[2]
        arg[3,3]=(0.181845363409)*x[0]**o+(0.184210025662)*x[0]+(-0.538269933964)*x[1]**o+(0.731384195858)*x[1]+(0.900272670238)*x[2]**o+(-0.152731605913)*x[2]
        arg[3,4]=(0.812640675362)*x[0]**o+(-0.330495179989)*x[0]+(0.455533774723)*x[1]**o+(0.32100819695)*x[1]+(-0.332730198093)*x[2]**o+(-0.692589097458)*x[2]
        ref[0,0,0]=o*(-0.66471814098)*x_ref[0]**(o-1)+(0.417241001417)
        ref[0,0,1]=o*(-0.228677853733)*x_ref[1]**(o-1)+(-0.706946716128)
        ref[0,0,2]=o*(0.977168565988)*x_ref[2]**(o-1)+(-0.0293128613918)
        ref[0,1,0]=o*(-0.161577085067)*x_ref[0]**(o-1)+(0.86957667281)
        ref[0,1,1]=o*(-0.246783815579)*x_ref[1]**(o-1)+(0.495318651008)
        ref[0,1,2]=o*(-0.500962203485)*x_ref[2]**(o-1)+(0.903521194042)
        ref[0,2,0]=o*(0.0764824142976)*x_ref[0]**(o-1)+(-0.0831710166954)
        ref[0,2,1]=o*(0.538063052387)*x_ref[1]**(o-1)+(0.472451075914)
        ref[0,2,2]=o*(-0.354702552367)*x_ref[2]**(o-1)+(-0.820126246007)
        ref[0,3,0]=o*(-0.286219487301)*x_ref[0]**(o-1)+(0.561959250696)
        ref[0,3,1]=o*(-0.65668352495)*x_ref[1]**(o-1)+(-0.276560290133)
        ref[0,3,2]=o*(-0.500866980002)*x_ref[2]**(o-1)+(0.71188245613)
        ref[0,4,0]=o*(-0.13704169085)*x_ref[0]**(o-1)+(0.107954139186)
        ref[0,4,1]=o*(0.498233399424)*x_ref[1]**(o-1)+(-0.201539549426)
        ref[0,4,2]=o*(-0.889578977028)*x_ref[2]**(o-1)+(0.33670078332)
        ref[1,0,0]=o*(0.411075168668)*x_ref[0]**(o-1)+(-0.982783292982)
        ref[1,0,1]=o*(0.919652087888)*x_ref[1]**(o-1)+(0.657917523808)
        ref[1,0,2]=o*(-0.220747064163)*x_ref[2]**(o-1)+(-0.65863499098)
        ref[1,1,0]=o*(0.978122893048)*x_ref[0]**(o-1)+(-0.638310308996)
        ref[1,1,1]=o*(-0.182955841813)*x_ref[1]**(o-1)+(0.386322350256)
        ref[1,1,2]=o*(0.0238129376001)*x_ref[2]**(o-1)+(0.415141411589)
        ref[1,2,0]=o*(-0.410102590894)*x_ref[0]**(o-1)+(-0.0527422034609)
        ref[1,2,1]=o*(0.218532590216)*x_ref[1]**(o-1)+(0.338645963161)
        ref[1,2,2]=o*(-0.559262295901)*x_ref[2]**(o-1)+(0.00154425206109)
        ref[1,3,0]=o*(-0.509603507286)*x_ref[0]**(o-1)+(0.220014659177)
        ref[1,3,1]=o*(-0.850244819031)*x_ref[1]**(o-1)+(0.851103142912)
        ref[1,3,2]=o*(0.485740207202)*x_ref[2]**(o-1)+(0.625073715619)
        ref[1,4,0]=o*(-0.990056784415)*x_ref[0]**(o-1)+(0.822920800823)
        ref[1,4,1]=o*(-0.310061384265)*x_ref[1]**(o-1)+(-0.337394401914)
        ref[1,4,2]=o*(0.139776472055)*x_ref[2]**(o-1)+(0.615477120599)
        ref[2,0,0]=o*(0.434733128443)*x_ref[0]**(o-1)+(-0.23992608444)
        ref[2,0,1]=o*(0.532847685888)*x_ref[1]**(o-1)+(0.641963266518)
        ref[2,0,2]=o*(-0.421857805771)*x_ref[2]**(o-1)+(0.385408885641)
        ref[2,1,0]=o*(0.502146118236)*x_ref[0]**(o-1)+(-0.476835388064)
        ref[2,1,1]=o*(-0.676891574566)*x_ref[1]**(o-1)+(0.713401740075)
        ref[2,1,2]=o*(0.220183315534)*x_ref[2]**(o-1)+(-0.863327755288)
        ref[2,2,0]=o*(-0.694614904655)*x_ref[0]**(o-1)+(-0.881664834998)
        ref[2,2,1]=o*(0.318605270866)*x_ref[1]**(o-1)+(0.55884249433)
        ref[2,2,2]=o*(0.286031997395)*x_ref[2]**(o-1)+(-0.947477517785)
        ref[2,3,0]=o*(-0.046201338948)*x_ref[0]**(o-1)+(-0.316456331808)
        ref[2,3,1]=o*(0.968975602807)*x_ref[1]**(o-1)+(0.549024517551)
        ref[2,3,2]=o*(-0.473260734234)*x_ref[2]**(o-1)+(0.889462696171)
        ref[2,4,0]=o*(0.316754513953)*x_ref[0]**(o-1)+(0.43553288512)
        ref[2,4,1]=o*(0.962932728727)*x_ref[1]**(o-1)+(0.887900662435)
        ref[2,4,2]=o*(-0.235820939423)*x_ref[2]**(o-1)+(0.947057541177)
        ref[3,0,0]=o*(-0.835914763446)*x_ref[0]**(o-1)+(-0.488811438785)
        ref[3,0,1]=o*(-0.573283060197)*x_ref[1]**(o-1)+(0.963078263225)
        ref[3,0,2]=o*(0.601345307969)*x_ref[2]**(o-1)+(-0.185658285596)
        ref[3,1,0]=o*(0.597606596118)*x_ref[0]**(o-1)+(0.0839878651552)
        ref[3,1,1]=o*(0.0836232765815)*x_ref[1]**(o-1)+(0.594866612681)
        ref[3,1,2]=o*(-0.361174348867)*x_ref[2]**(o-1)+(0.701364726038)
        ref[3,2,0]=o*(-0.172328462662)*x_ref[0]**(o-1)+(-0.856154059105)
        ref[3,2,1]=o*(0.533657669403)*x_ref[1]**(o-1)+(-0.305657234912)
        ref[3,2,2]=o*(0.828787414246)*x_ref[2]**(o-1)+(0.993286809537)
        ref[3,3,0]=o*(0.181845363409)*x_ref[0]**(o-1)+(0.184210025662)
        ref[3,3,1]=o*(-0.538269933964)*x_ref[1]**(o-1)+(0.731384195858)
        ref[3,3,2]=o*(0.900272670238)*x_ref[2]**(o-1)+(-0.152731605913)
        ref[3,4,0]=o*(0.812640675362)*x_ref[0]**(o-1)+(-0.330495179989)
        ref[3,4,1]=o*(0.455533774723)*x_ref[1]**(o-1)+(0.32100819695)
        ref[3,4,2]=o*(-0.332730198093)*x_ref[2]**(o-1)+(-0.692589097458)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnBoundary_fromData_Solution_rank3(self):
      """
      tests gradient for rank 3 Data on the ReducedFunctionOnBoundary

      assumptions: Solution(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnBoundary
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=Solution(self.domain)
      x=w.getX()
      arg=Data(0,(6, 2, 2),w)
      ref=Data(0,(6, 2, 2)+(dim,),w_ref)
      if dim==2:
        arg[0,0,0]=(0.253396883727)*x[0]**o+(0.491235248599)*x[0]+(-0.468734602938)*x[1]**o+(0.730479725967)*x[1]
        arg[0,0,1]=(0.344036208598)*x[0]**o+(-0.394302857752)*x[0]+(-0.608765577652)*x[1]**o+(-0.564065946953)*x[1]
        arg[0,1,0]=(-0.84520693538)*x[0]**o+(0.934285247148)*x[0]+(0.0841237910789)*x[1]**o+(0.455488803423)*x[1]
        arg[0,1,1]=(0.484027534363)*x[0]**o+(-0.374633264234)*x[0]+(-0.0665482018417)*x[1]**o+(0.528984445833)*x[1]
        arg[1,0,0]=(-0.470188044426)*x[0]**o+(-0.328178128746)*x[0]+(0.67571857307)*x[1]**o+(0.116985630247)*x[1]
        arg[1,0,1]=(0.986586449605)*x[0]**o+(-0.25691197068)*x[0]+(0.755235660838)*x[1]**o+(0.211004338524)*x[1]
        arg[1,1,0]=(-0.569322712396)*x[0]**o+(0.900009729013)*x[0]+(0.748881276361)*x[1]**o+(0.850464087662)*x[1]
        arg[1,1,1]=(0.625042758036)*x[0]**o+(-0.72757111333)*x[0]+(-0.986053078492)*x[1]**o+(-0.633517003425)*x[1]
        arg[2,0,0]=(-0.716192724085)*x[0]**o+(-0.23327162426)*x[0]+(0.206440629344)*x[1]**o+(0.816324161671)*x[1]
        arg[2,0,1]=(-0.803679553386)*x[0]**o+(0.445433027195)*x[0]+(-0.111465589792)*x[1]**o+(-0.109772986088)*x[1]
        arg[2,1,0]=(0.374386571048)*x[0]**o+(-0.317187375606)*x[0]+(0.133248401591)*x[1]**o+(-0.971347533424)*x[1]
        arg[2,1,1]=(-0.48476474399)*x[0]**o+(0.979379654323)*x[0]+(0.371437992948)*x[1]**o+(-0.110228097225)*x[1]
        arg[3,0,0]=(0.37507701433)*x[0]**o+(0.451375135714)*x[0]+(0.228204578568)*x[1]**o+(0.0935454426192)*x[1]
        arg[3,0,1]=(-0.322375030256)*x[0]**o+(-0.0412650889525)*x[0]+(0.23495348361)*x[1]**o+(-0.704960519241)*x[1]
        arg[3,1,0]=(-0.478413043796)*x[0]**o+(0.373637701709)*x[0]+(0.346845166424)*x[1]**o+(0.00492075723836)*x[1]
        arg[3,1,1]=(0.0753795682919)*x[0]**o+(0.51446748543)*x[0]+(-0.337079735899)*x[1]**o+(0.976335320865)*x[1]
        arg[4,0,0]=(0.173293972121)*x[0]**o+(0.78972296986)*x[0]+(-0.518624390388)*x[1]**o+(-0.587962330417)*x[1]
        arg[4,0,1]=(0.747393467297)*x[0]**o+(0.940132823774)*x[0]+(-0.292996377712)*x[1]**o+(0.980334604245)*x[1]
        arg[4,1,0]=(-0.836497499117)*x[0]**o+(0.625161912911)*x[0]+(0.978929091652)*x[1]**o+(-0.676430396031)*x[1]
        arg[4,1,1]=(-0.195907406253)*x[0]**o+(-0.388427741642)*x[0]+(0.233500679929)*x[1]**o+(0.535047073421)*x[1]
        arg[5,0,0]=(0.983591245443)*x[0]**o+(-0.356589240979)*x[0]+(0.328974933764)*x[1]**o+(-0.875152262477)*x[1]
        arg[5,0,1]=(0.901430256705)*x[0]**o+(0.74247442514)*x[0]+(0.189211012786)*x[1]**o+(0.930520401277)*x[1]
        arg[5,1,0]=(-0.319591878243)*x[0]**o+(0.174836571432)*x[0]+(0.953875085784)*x[1]**o+(-0.51684941838)*x[1]
        arg[5,1,1]=(-0.916869714992)*x[0]**o+(0.121572609124)*x[0]+(0.791850838139)*x[1]**o+(-0.588663035087)*x[1]
        ref[0,0,0,0]=o*(0.253396883727)*x_ref[0]**(o-1)+(0.491235248599)
        ref[0,0,0,1]=o*(-0.468734602938)*x_ref[1]**(o-1)+(0.730479725967)
        ref[0,0,1,0]=o*(0.344036208598)*x_ref[0]**(o-1)+(-0.394302857752)
        ref[0,0,1,1]=o*(-0.608765577652)*x_ref[1]**(o-1)+(-0.564065946953)
        ref[0,1,0,0]=o*(-0.84520693538)*x_ref[0]**(o-1)+(0.934285247148)
        ref[0,1,0,1]=o*(0.0841237910789)*x_ref[1]**(o-1)+(0.455488803423)
        ref[0,1,1,0]=o*(0.484027534363)*x_ref[0]**(o-1)+(-0.374633264234)
        ref[0,1,1,1]=o*(-0.0665482018417)*x_ref[1]**(o-1)+(0.528984445833)
        ref[1,0,0,0]=o*(-0.470188044426)*x_ref[0]**(o-1)+(-0.328178128746)
        ref[1,0,0,1]=o*(0.67571857307)*x_ref[1]**(o-1)+(0.116985630247)
        ref[1,0,1,0]=o*(0.986586449605)*x_ref[0]**(o-1)+(-0.25691197068)
        ref[1,0,1,1]=o*(0.755235660838)*x_ref[1]**(o-1)+(0.211004338524)
        ref[1,1,0,0]=o*(-0.569322712396)*x_ref[0]**(o-1)+(0.900009729013)
        ref[1,1,0,1]=o*(0.748881276361)*x_ref[1]**(o-1)+(0.850464087662)
        ref[1,1,1,0]=o*(0.625042758036)*x_ref[0]**(o-1)+(-0.72757111333)
        ref[1,1,1,1]=o*(-0.986053078492)*x_ref[1]**(o-1)+(-0.633517003425)
        ref[2,0,0,0]=o*(-0.716192724085)*x_ref[0]**(o-1)+(-0.23327162426)
        ref[2,0,0,1]=o*(0.206440629344)*x_ref[1]**(o-1)+(0.816324161671)
        ref[2,0,1,0]=o*(-0.803679553386)*x_ref[0]**(o-1)+(0.445433027195)
        ref[2,0,1,1]=o*(-0.111465589792)*x_ref[1]**(o-1)+(-0.109772986088)
        ref[2,1,0,0]=o*(0.374386571048)*x_ref[0]**(o-1)+(-0.317187375606)
        ref[2,1,0,1]=o*(0.133248401591)*x_ref[1]**(o-1)+(-0.971347533424)
        ref[2,1,1,0]=o*(-0.48476474399)*x_ref[0]**(o-1)+(0.979379654323)
        ref[2,1,1,1]=o*(0.371437992948)*x_ref[1]**(o-1)+(-0.110228097225)
        ref[3,0,0,0]=o*(0.37507701433)*x_ref[0]**(o-1)+(0.451375135714)
        ref[3,0,0,1]=o*(0.228204578568)*x_ref[1]**(o-1)+(0.0935454426192)
        ref[3,0,1,0]=o*(-0.322375030256)*x_ref[0]**(o-1)+(-0.0412650889525)
        ref[3,0,1,1]=o*(0.23495348361)*x_ref[1]**(o-1)+(-0.704960519241)
        ref[3,1,0,0]=o*(-0.478413043796)*x_ref[0]**(o-1)+(0.373637701709)
        ref[3,1,0,1]=o*(0.346845166424)*x_ref[1]**(o-1)+(0.00492075723836)
        ref[3,1,1,0]=o*(0.0753795682919)*x_ref[0]**(o-1)+(0.51446748543)
        ref[3,1,1,1]=o*(-0.337079735899)*x_ref[1]**(o-1)+(0.976335320865)
        ref[4,0,0,0]=o*(0.173293972121)*x_ref[0]**(o-1)+(0.78972296986)
        ref[4,0,0,1]=o*(-0.518624390388)*x_ref[1]**(o-1)+(-0.587962330417)
        ref[4,0,1,0]=o*(0.747393467297)*x_ref[0]**(o-1)+(0.940132823774)
        ref[4,0,1,1]=o*(-0.292996377712)*x_ref[1]**(o-1)+(0.980334604245)
        ref[4,1,0,0]=o*(-0.836497499117)*x_ref[0]**(o-1)+(0.625161912911)
        ref[4,1,0,1]=o*(0.978929091652)*x_ref[1]**(o-1)+(-0.676430396031)
        ref[4,1,1,0]=o*(-0.195907406253)*x_ref[0]**(o-1)+(-0.388427741642)
        ref[4,1,1,1]=o*(0.233500679929)*x_ref[1]**(o-1)+(0.535047073421)
        ref[5,0,0,0]=o*(0.983591245443)*x_ref[0]**(o-1)+(-0.356589240979)
        ref[5,0,0,1]=o*(0.328974933764)*x_ref[1]**(o-1)+(-0.875152262477)
        ref[5,0,1,0]=o*(0.901430256705)*x_ref[0]**(o-1)+(0.74247442514)
        ref[5,0,1,1]=o*(0.189211012786)*x_ref[1]**(o-1)+(0.930520401277)
        ref[5,1,0,0]=o*(-0.319591878243)*x_ref[0]**(o-1)+(0.174836571432)
        ref[5,1,0,1]=o*(0.953875085784)*x_ref[1]**(o-1)+(-0.51684941838)
        ref[5,1,1,0]=o*(-0.916869714992)*x_ref[0]**(o-1)+(0.121572609124)
        ref[5,1,1,1]=o*(0.791850838139)*x_ref[1]**(o-1)+(-0.588663035087)
      else:
        arg[0,0,0]=(-0.513971266383)*x[0]**o+(-0.117127749421)*x[0]+(-0.551292004692)*x[1]**o+(-0.268920693702)*x[1]+(0.0872538366694)*x[2]**o+(0.855491592762)*x[2]
        arg[0,0,1]=(0.156425207213)*x[0]**o+(-0.299808724719)*x[0]+(0.827383156334)*x[1]**o+(-0.594506082498)*x[1]+(-0.289589281068)*x[2]**o+(0.559159349352)*x[2]
        arg[0,1,0]=(-0.925822763448)*x[0]**o+(0.518052108584)*x[0]+(-0.774761536373)*x[1]**o+(-0.0329613155479)*x[1]+(0.957805160206)*x[2]**o+(0.0606445544683)*x[2]
        arg[0,1,1]=(-0.337663244379)*x[0]**o+(-0.634947360886)*x[0]+(0.232117517887)*x[1]**o+(-0.534317817241)*x[1]+(0.554880796818)*x[2]**o+(-0.3101266685)*x[2]
        arg[1,0,0]=(-0.888548906608)*x[0]**o+(0.517747675888)*x[0]+(-0.614381113253)*x[1]**o+(-0.757891891198)*x[1]+(0.618261909378)*x[2]**o+(-0.0853347346644)*x[2]
        arg[1,0,1]=(-0.686920109418)*x[0]**o+(0.000673193523604)*x[0]+(0.251800447271)*x[1]**o+(-0.105619412646)*x[1]+(0.00990847148242)*x[2]**o+(0.861798595402)*x[2]
        arg[1,1,0]=(0.170484209485)*x[0]**o+(-0.620257643847)*x[0]+(0.057743430303)*x[1]**o+(0.0640298192279)*x[1]+(0.0757100493935)*x[2]**o+(-0.414863410391)*x[2]
        arg[1,1,1]=(-0.714807290039)*x[0]**o+(-0.562420622765)*x[0]+(0.788769732877)*x[1]**o+(-0.472413621829)*x[1]+(-0.466159435785)*x[2]**o+(-0.476510555737)*x[2]
        arg[2,0,0]=(0.875340499144)*x[0]**o+(-0.598283854175)*x[0]+(0.206593884126)*x[1]**o+(-0.987568956833)*x[1]+(0.666527095968)*x[2]**o+(-0.352753155564)*x[2]
        arg[2,0,1]=(0.677005187408)*x[0]**o+(0.760176905882)*x[0]+(-0.0863648949101)*x[1]**o+(-0.607384058071)*x[1]+(-0.117434466077)*x[2]**o+(-0.670292588633)*x[2]
        arg[2,1,0]=(0.888629811684)*x[0]**o+(0.35826389662)*x[0]+(0.00390435387028)*x[1]**o+(-0.0937518531166)*x[1]+(-0.365569888759)*x[2]**o+(0.380035526283)*x[2]
        arg[2,1,1]=(0.138275666033)*x[0]**o+(-0.437710809963)*x[0]+(0.773451227027)*x[1]**o+(0.834016138485)*x[1]+(0.847339165612)*x[2]**o+(-0.417687340903)*x[2]
        arg[3,0,0]=(-0.298714836243)*x[0]**o+(-0.268961434956)*x[0]+(0.232096942083)*x[1]**o+(-0.455570990604)*x[1]+(-0.294542554349)*x[2]**o+(-0.37112817156)*x[2]
        arg[3,0,1]=(0.0903365333358)*x[0]**o+(0.338265717129)*x[0]+(-0.755237281599)*x[1]**o+(-0.608535543682)*x[1]+(0.812136572153)*x[2]**o+(-0.146674314466)*x[2]
        arg[3,1,0]=(0.159422014459)*x[0]**o+(0.899761817668)*x[0]+(0.467507279621)*x[1]**o+(0.47028740641)*x[1]+(-0.905453092566)*x[2]**o+(0.325443171334)*x[2]
        arg[3,1,1]=(0.706113787474)*x[0]**o+(0.411358047385)*x[0]+(0.710178001185)*x[1]**o+(-0.248170072927)*x[1]+(0.2228478152)*x[2]**o+(-0.6845238748)*x[2]
        arg[4,0,0]=(-0.810987300482)*x[0]**o+(-0.20061683347)*x[0]+(-0.362480203096)*x[1]**o+(0.23493442788)*x[1]+(-0.0262576869803)*x[2]**o+(0.40114062378)*x[2]
        arg[4,0,1]=(-0.0377982138529)*x[0]**o+(-0.844585963856)*x[0]+(-0.94360590097)*x[1]**o+(-0.775666510211)*x[1]+(-0.484314539768)*x[2]**o+(0.472661289406)*x[2]
        arg[4,1,0]=(0.579937359489)*x[0]**o+(0.384020744083)*x[0]+(-0.303096661906)*x[1]**o+(-0.0640353004314)*x[1]+(0.693425296881)*x[2]**o+(0.410980796125)*x[2]
        arg[4,1,1]=(0.152139667717)*x[0]**o+(-0.49610371397)*x[0]+(-0.884008900347)*x[1]**o+(-0.364570486388)*x[1]+(0.126918854811)*x[2]**o+(0.409453971802)*x[2]
        arg[5,0,0]=(0.409834559571)*x[0]**o+(-0.347724104753)*x[0]+(-0.263327417846)*x[1]**o+(0.18147743546)*x[1]+(-0.399848371177)*x[2]**o+(0.928317631431)*x[2]
        arg[5,0,1]=(-0.686702422025)*x[0]**o+(-0.918530462662)*x[0]+(0.478936304167)*x[1]**o+(-0.641691106861)*x[1]+(-0.582780732375)*x[2]**o+(0.30255037752)*x[2]
        arg[5,1,0]=(0.50568688101)*x[0]**o+(0.378682510558)*x[0]+(0.59801824354)*x[1]**o+(-0.316028163905)*x[1]+(-0.554966057648)*x[2]**o+(0.637313154931)*x[2]
        arg[5,1,1]=(0.300318472719)*x[0]**o+(-0.794010312167)*x[0]+(-0.314402790698)*x[1]**o+(0.991870648498)*x[1]+(0.949603731589)*x[2]**o+(-0.302054056398)*x[2]
        ref[0,0,0,0]=o*(-0.513971266383)*x_ref[0]**(o-1)+(-0.117127749421)
        ref[0,0,0,1]=o*(-0.551292004692)*x_ref[1]**(o-1)+(-0.268920693702)
        ref[0,0,0,2]=o*(0.0872538366694)*x_ref[2]**(o-1)+(0.855491592762)
        ref[0,0,1,0]=o*(0.156425207213)*x_ref[0]**(o-1)+(-0.299808724719)
        ref[0,0,1,1]=o*(0.827383156334)*x_ref[1]**(o-1)+(-0.594506082498)
        ref[0,0,1,2]=o*(-0.289589281068)*x_ref[2]**(o-1)+(0.559159349352)
        ref[0,1,0,0]=o*(-0.925822763448)*x_ref[0]**(o-1)+(0.518052108584)
        ref[0,1,0,1]=o*(-0.774761536373)*x_ref[1]**(o-1)+(-0.0329613155479)
        ref[0,1,0,2]=o*(0.957805160206)*x_ref[2]**(o-1)+(0.0606445544683)
        ref[0,1,1,0]=o*(-0.337663244379)*x_ref[0]**(o-1)+(-0.634947360886)
        ref[0,1,1,1]=o*(0.232117517887)*x_ref[1]**(o-1)+(-0.534317817241)
        ref[0,1,1,2]=o*(0.554880796818)*x_ref[2]**(o-1)+(-0.3101266685)
        ref[1,0,0,0]=o*(-0.888548906608)*x_ref[0]**(o-1)+(0.517747675888)
        ref[1,0,0,1]=o*(-0.614381113253)*x_ref[1]**(o-1)+(-0.757891891198)
        ref[1,0,0,2]=o*(0.618261909378)*x_ref[2]**(o-1)+(-0.0853347346644)
        ref[1,0,1,0]=o*(-0.686920109418)*x_ref[0]**(o-1)+(0.000673193523604)
        ref[1,0,1,1]=o*(0.251800447271)*x_ref[1]**(o-1)+(-0.105619412646)
        ref[1,0,1,2]=o*(0.00990847148242)*x_ref[2]**(o-1)+(0.861798595402)
        ref[1,1,0,0]=o*(0.170484209485)*x_ref[0]**(o-1)+(-0.620257643847)
        ref[1,1,0,1]=o*(0.057743430303)*x_ref[1]**(o-1)+(0.0640298192279)
        ref[1,1,0,2]=o*(0.0757100493935)*x_ref[2]**(o-1)+(-0.414863410391)
        ref[1,1,1,0]=o*(-0.714807290039)*x_ref[0]**(o-1)+(-0.562420622765)
        ref[1,1,1,1]=o*(0.788769732877)*x_ref[1]**(o-1)+(-0.472413621829)
        ref[1,1,1,2]=o*(-0.466159435785)*x_ref[2]**(o-1)+(-0.476510555737)
        ref[2,0,0,0]=o*(0.875340499144)*x_ref[0]**(o-1)+(-0.598283854175)
        ref[2,0,0,1]=o*(0.206593884126)*x_ref[1]**(o-1)+(-0.987568956833)
        ref[2,0,0,2]=o*(0.666527095968)*x_ref[2]**(o-1)+(-0.352753155564)
        ref[2,0,1,0]=o*(0.677005187408)*x_ref[0]**(o-1)+(0.760176905882)
        ref[2,0,1,1]=o*(-0.0863648949101)*x_ref[1]**(o-1)+(-0.607384058071)
        ref[2,0,1,2]=o*(-0.117434466077)*x_ref[2]**(o-1)+(-0.670292588633)
        ref[2,1,0,0]=o*(0.888629811684)*x_ref[0]**(o-1)+(0.35826389662)
        ref[2,1,0,1]=o*(0.00390435387028)*x_ref[1]**(o-1)+(-0.0937518531166)
        ref[2,1,0,2]=o*(-0.365569888759)*x_ref[2]**(o-1)+(0.380035526283)
        ref[2,1,1,0]=o*(0.138275666033)*x_ref[0]**(o-1)+(-0.437710809963)
        ref[2,1,1,1]=o*(0.773451227027)*x_ref[1]**(o-1)+(0.834016138485)
        ref[2,1,1,2]=o*(0.847339165612)*x_ref[2]**(o-1)+(-0.417687340903)
        ref[3,0,0,0]=o*(-0.298714836243)*x_ref[0]**(o-1)+(-0.268961434956)
        ref[3,0,0,1]=o*(0.232096942083)*x_ref[1]**(o-1)+(-0.455570990604)
        ref[3,0,0,2]=o*(-0.294542554349)*x_ref[2]**(o-1)+(-0.37112817156)
        ref[3,0,1,0]=o*(0.0903365333358)*x_ref[0]**(o-1)+(0.338265717129)
        ref[3,0,1,1]=o*(-0.755237281599)*x_ref[1]**(o-1)+(-0.608535543682)
        ref[3,0,1,2]=o*(0.812136572153)*x_ref[2]**(o-1)+(-0.146674314466)
        ref[3,1,0,0]=o*(0.159422014459)*x_ref[0]**(o-1)+(0.899761817668)
        ref[3,1,0,1]=o*(0.467507279621)*x_ref[1]**(o-1)+(0.47028740641)
        ref[3,1,0,2]=o*(-0.905453092566)*x_ref[2]**(o-1)+(0.325443171334)
        ref[3,1,1,0]=o*(0.706113787474)*x_ref[0]**(o-1)+(0.411358047385)
        ref[3,1,1,1]=o*(0.710178001185)*x_ref[1]**(o-1)+(-0.248170072927)
        ref[3,1,1,2]=o*(0.2228478152)*x_ref[2]**(o-1)+(-0.6845238748)
        ref[4,0,0,0]=o*(-0.810987300482)*x_ref[0]**(o-1)+(-0.20061683347)
        ref[4,0,0,1]=o*(-0.362480203096)*x_ref[1]**(o-1)+(0.23493442788)
        ref[4,0,0,2]=o*(-0.0262576869803)*x_ref[2]**(o-1)+(0.40114062378)
        ref[4,0,1,0]=o*(-0.0377982138529)*x_ref[0]**(o-1)+(-0.844585963856)
        ref[4,0,1,1]=o*(-0.94360590097)*x_ref[1]**(o-1)+(-0.775666510211)
        ref[4,0,1,2]=o*(-0.484314539768)*x_ref[2]**(o-1)+(0.472661289406)
        ref[4,1,0,0]=o*(0.579937359489)*x_ref[0]**(o-1)+(0.384020744083)
        ref[4,1,0,1]=o*(-0.303096661906)*x_ref[1]**(o-1)+(-0.0640353004314)
        ref[4,1,0,2]=o*(0.693425296881)*x_ref[2]**(o-1)+(0.410980796125)
        ref[4,1,1,0]=o*(0.152139667717)*x_ref[0]**(o-1)+(-0.49610371397)
        ref[4,1,1,1]=o*(-0.884008900347)*x_ref[1]**(o-1)+(-0.364570486388)
        ref[4,1,1,2]=o*(0.126918854811)*x_ref[2]**(o-1)+(0.409453971802)
        ref[5,0,0,0]=o*(0.409834559571)*x_ref[0]**(o-1)+(-0.347724104753)
        ref[5,0,0,1]=o*(-0.263327417846)*x_ref[1]**(o-1)+(0.18147743546)
        ref[5,0,0,2]=o*(-0.399848371177)*x_ref[2]**(o-1)+(0.928317631431)
        ref[5,0,1,0]=o*(-0.686702422025)*x_ref[0]**(o-1)+(-0.918530462662)
        ref[5,0,1,1]=o*(0.478936304167)*x_ref[1]**(o-1)+(-0.641691106861)
        ref[5,0,1,2]=o*(-0.582780732375)*x_ref[2]**(o-1)+(0.30255037752)
        ref[5,1,0,0]=o*(0.50568688101)*x_ref[0]**(o-1)+(0.378682510558)
        ref[5,1,0,1]=o*(0.59801824354)*x_ref[1]**(o-1)+(-0.316028163905)
        ref[5,1,0,2]=o*(-0.554966057648)*x_ref[2]**(o-1)+(0.637313154931)
        ref[5,1,1,0]=o*(0.300318472719)*x_ref[0]**(o-1)+(-0.794010312167)
        ref[5,1,1,1]=o*(-0.314402790698)*x_ref[1]**(o-1)+(0.991870648498)
        ref[5,1,1,2]=o*(0.949603731589)*x_ref[2]**(o-1)+(-0.302054056398)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnBoundary_fromData_ReducedSolution_rank0(self):
      """
      tests gradient for rank 0 Data on the ReducedFunctionOnBoundary

      assumptions: ReducedSolution(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnBoundary
      """
      o=1
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=ReducedSolution(self.domain)
      x=w.getX()
      arg=Data(0,(),w)
      ref=Data(0,()+(dim,),w_ref)
      if dim==2:
        arg=(0.306947418999)*x[0]+(-0.706616694784)*x[1]
        ref[0]=(0.306947418999)
        ref[1]=(-0.706616694784)
      else:
        arg=(0.490435692707)*x[0]+(0.929248719763)*x[1]+(0.269868131113)*x[2]
        ref[0]=(0.490435692707)
        ref[1]=(0.929248719763)
        ref[2]=(0.269868131113)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),()+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnBoundary_fromData_ReducedSolution_rank1(self):
      """
      tests gradient for rank 1 Data on the ReducedFunctionOnBoundary

      assumptions: ReducedSolution(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnBoundary
      """
      o=1
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=ReducedSolution(self.domain)
      x=w.getX()
      arg=Data(0,(2,),w)
      ref=Data(0,(2,)+(dim,),w_ref)
      if dim==2:
        arg[0]=(-0.882633673888)*x[0]+(-0.790592442848)*x[1]
        arg[1]=(1.55495669126)*x[0]+(0.496011926182)*x[1]
        ref[0,0]=(-0.882633673888)
        ref[0,1]=(-0.790592442848)
        ref[1,0]=(1.55495669126)
        ref[1,1]=(0.496011926182)
      else:
        arg[0]=(0.683098278161)*x[0]+(-0.151590511238)*x[1]+(0.54461031868)*x[2]
        arg[1]=(0.59998040214)*x[0]+(-0.995466442084)*x[1]+(-1.09468062911)*x[2]
        ref[0,0]=(0.683098278161)
        ref[0,1]=(-0.151590511238)
        ref[0,2]=(0.54461031868)
        ref[1,0]=(0.59998040214)
        ref[1,1]=(-0.995466442084)
        ref[1,2]=(-1.09468062911)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnBoundary_fromData_ReducedSolution_rank2(self):
      """
      tests gradient for rank 2 Data on the ReducedFunctionOnBoundary

      assumptions: ReducedSolution(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnBoundary
      """
      o=1
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=ReducedSolution(self.domain)
      x=w.getX()
      arg=Data(0,(4, 5),w)
      ref=Data(0,(4, 5)+(dim,),w_ref)
      if dim==2:
        arg[0,0]=(-0.159129528541)*x[0]+(0.107835972384)*x[1]
        arg[0,1]=(-1.52388770934)*x[0]+(0.262089610596)*x[1]
        arg[0,2]=(0.505454501555)*x[0]+(-0.247061440744)*x[1]
        arg[0,3]=(-0.556075420202)*x[0]+(0.702144110506)*x[1]
        arg[0,4]=(0.810518335626)*x[0]+(-0.76077949525)*x[1]
        arg[1,0]=(-0.491052732808)*x[0]+(-0.272913467279)*x[1]
        arg[1,1]=(0.0141908236388)*x[0]+(1.10868804645)*x[1]
        arg[1,2]=(0.719028425382)*x[0]+(-0.544780305018)*x[1]
        arg[1,3]=(-1.15474920716)*x[0]+(0.888461325396)*x[1]
        arg[1,4]=(-0.842901893766)*x[0]+(-0.465916012282)*x[1]
        arg[2,0]=(1.24606386746)*x[0]+(0.817235825831)*x[1]
        arg[2,1]=(0.400861923494)*x[0]+(1.24545704982)*x[1]
        arg[2,2]=(0.656546253691)*x[0]+(-0.0269228973404)*x[1]
        arg[2,3]=(-0.590512343874)*x[0]+(-0.0654952556025)*x[1]
        arg[2,4]=(0.806342618281)*x[0]+(-0.183166204195)*x[1]
        arg[3,0]=(0.637045776935)*x[0]+(-0.512820906995)*x[1]
        arg[3,1]=(-0.596216711833)*x[0]+(-0.221853749777)*x[1]
        arg[3,2]=(0.113235739927)*x[0]+(-0.210641618992)*x[1]
        arg[3,3]=(-1.11423980423)*x[0]+(-1.46748285012)*x[1]
        arg[3,4]=(0.573260999643)*x[0]+(0.55016627172)*x[1]
        ref[0,0,0]=(-0.159129528541)
        ref[0,0,1]=(0.107835972384)
        ref[0,1,0]=(-1.52388770934)
        ref[0,1,1]=(0.262089610596)
        ref[0,2,0]=(0.505454501555)
        ref[0,2,1]=(-0.247061440744)
        ref[0,3,0]=(-0.556075420202)
        ref[0,3,1]=(0.702144110506)
        ref[0,4,0]=(0.810518335626)
        ref[0,4,1]=(-0.76077949525)
        ref[1,0,0]=(-0.491052732808)
        ref[1,0,1]=(-0.272913467279)
        ref[1,1,0]=(0.0141908236388)
        ref[1,1,1]=(1.10868804645)
        ref[1,2,0]=(0.719028425382)
        ref[1,2,1]=(-0.544780305018)
        ref[1,3,0]=(-1.15474920716)
        ref[1,3,1]=(0.888461325396)
        ref[1,4,0]=(-0.842901893766)
        ref[1,4,1]=(-0.465916012282)
        ref[2,0,0]=(1.24606386746)
        ref[2,0,1]=(0.817235825831)
        ref[2,1,0]=(0.400861923494)
        ref[2,1,1]=(1.24545704982)
        ref[2,2,0]=(0.656546253691)
        ref[2,2,1]=(-0.0269228973404)
        ref[2,3,0]=(-0.590512343874)
        ref[2,3,1]=(-0.0654952556025)
        ref[2,4,0]=(0.806342618281)
        ref[2,4,1]=(-0.183166204195)
        ref[3,0,0]=(0.637045776935)
        ref[3,0,1]=(-0.512820906995)
        ref[3,1,0]=(-0.596216711833)
        ref[3,1,1]=(-0.221853749777)
        ref[3,2,0]=(0.113235739927)
        ref[3,2,1]=(-0.210641618992)
        ref[3,3,0]=(-1.11423980423)
        ref[3,3,1]=(-1.46748285012)
        ref[3,4,0]=(0.573260999643)
        ref[3,4,1]=(0.55016627172)
      else:
        arg[0,0]=(-0.025505130975)*x[0]+(-0.128352022583)*x[1]+(-0.0645809876948)*x[2]
        arg[0,1]=(-0.974556985555)*x[0]+(0.503751568036)*x[1]+(-0.524784840232)*x[2]
        arg[0,2]=(-1.23653778531)*x[0]+(-0.73883453445)*x[1]+(-1.59259101746)*x[2]
        arg[0,3]=(-0.543656268618)*x[0]+(0.110486603472)*x[1]+(-0.636246757745)*x[2]
        arg[0,4]=(-0.566088225133)*x[0]+(-0.272577812471)*x[1]+(-0.282075405014)*x[2]
        arg[1,0]=(-0.28252305722)*x[0]+(0.497103425073)*x[1]+(0.997942367464)*x[2]
        arg[1,1]=(-0.444059543356)*x[0]+(-0.149004039444)*x[1]+(-0.871853047384)*x[2]
        arg[1,2]=(-0.610830496789)*x[0]+(0.196494475826)*x[1]+(0.0123852343883)*x[2]
        arg[1,3]=(-0.327903465165)*x[0]+(0.523560519595)*x[1]+(-0.409961704581)*x[2]
        arg[1,4]=(0.633897214746)*x[0]+(-0.9032002551)*x[1]+(0.624042996391)*x[2]
        arg[2,0]=(0.469489049636)*x[0]+(1.46158418286)*x[1]+(-0.538453674545)*x[2]
        arg[2,1]=(0.0488906165423)*x[0]+(0.483867458959)*x[1]+(0.0419643463366)*x[2]
        arg[2,2]=(-1.89716754038)*x[0]+(-0.577554008519)*x[1]+(-0.0328835832126)*x[2]
        arg[2,3]=(0.507329501469)*x[0]+(0.354939444351)*x[1]+(0.0136766029313)*x[2]
        arg[2,4]=(-0.313182267444)*x[0]+(-1.08684309178)*x[1]+(-1.39365968958)*x[2]
        arg[3,0]=(0.272322829309)*x[0]+(-0.233645276231)*x[1]+(0.491500838791)*x[2]
        arg[3,1]=(1.27603407856)*x[0]+(-0.709429989875)*x[1]+(-0.998371438244)*x[2]
        arg[3,2]=(0.637972716248)*x[0]+(-1.37896009762)*x[1]+(0.496830616786)*x[2]
        arg[3,3]=(-1.67735443481)*x[0]+(-0.741884420811)*x[1]+(1.23125805904)*x[2]
        arg[3,4]=(-0.593290763881)*x[0]+(-0.881909104701)*x[1]+(-1.0425499934)*x[2]
        ref[0,0,0]=(-0.025505130975)
        ref[0,0,1]=(-0.128352022583)
        ref[0,0,2]=(-0.0645809876948)
        ref[0,1,0]=(-0.974556985555)
        ref[0,1,1]=(0.503751568036)
        ref[0,1,2]=(-0.524784840232)
        ref[0,2,0]=(-1.23653778531)
        ref[0,2,1]=(-0.73883453445)
        ref[0,2,2]=(-1.59259101746)
        ref[0,3,0]=(-0.543656268618)
        ref[0,3,1]=(0.110486603472)
        ref[0,3,2]=(-0.636246757745)
        ref[0,4,0]=(-0.566088225133)
        ref[0,4,1]=(-0.272577812471)
        ref[0,4,2]=(-0.282075405014)
        ref[1,0,0]=(-0.28252305722)
        ref[1,0,1]=(0.497103425073)
        ref[1,0,2]=(0.997942367464)
        ref[1,1,0]=(-0.444059543356)
        ref[1,1,1]=(-0.149004039444)
        ref[1,1,2]=(-0.871853047384)
        ref[1,2,0]=(-0.610830496789)
        ref[1,2,1]=(0.196494475826)
        ref[1,2,2]=(0.0123852343883)
        ref[1,3,0]=(-0.327903465165)
        ref[1,3,1]=(0.523560519595)
        ref[1,3,2]=(-0.409961704581)
        ref[1,4,0]=(0.633897214746)
        ref[1,4,1]=(-0.9032002551)
        ref[1,4,2]=(0.624042996391)
        ref[2,0,0]=(0.469489049636)
        ref[2,0,1]=(1.46158418286)
        ref[2,0,2]=(-0.538453674545)
        ref[2,1,0]=(0.0488906165423)
        ref[2,1,1]=(0.483867458959)
        ref[2,1,2]=(0.0419643463366)
        ref[2,2,0]=(-1.89716754038)
        ref[2,2,1]=(-0.577554008519)
        ref[2,2,2]=(-0.0328835832126)
        ref[2,3,0]=(0.507329501469)
        ref[2,3,1]=(0.354939444351)
        ref[2,3,2]=(0.0136766029313)
        ref[2,4,0]=(-0.313182267444)
        ref[2,4,1]=(-1.08684309178)
        ref[2,4,2]=(-1.39365968958)
        ref[3,0,0]=(0.272322829309)
        ref[3,0,1]=(-0.233645276231)
        ref[3,0,2]=(0.491500838791)
        ref[3,1,0]=(1.27603407856)
        ref[3,1,1]=(-0.709429989875)
        ref[3,1,2]=(-0.998371438244)
        ref[3,2,0]=(0.637972716248)
        ref[3,2,1]=(-1.37896009762)
        ref[3,2,2]=(0.496830616786)
        ref[3,3,0]=(-1.67735443481)
        ref[3,3,1]=(-0.741884420811)
        ref[3,3,2]=(1.23125805904)
        ref[3,4,0]=(-0.593290763881)
        ref[3,4,1]=(-0.881909104701)
        ref[3,4,2]=(-1.0425499934)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnBoundary_fromData_ReducedSolution_rank3(self):
      """
      tests gradient for rank 3 Data on the ReducedFunctionOnBoundary

      assumptions: ReducedSolution(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnBoundary
      """
      o=1
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=ReducedSolution(self.domain)
      x=w.getX()
      arg=Data(0,(6, 2, 2),w)
      ref=Data(0,(6, 2, 2)+(dim,),w_ref)
      if dim==2:
        arg[0,0,0]=(0.289868084377)*x[0]+(-1.636093365)*x[1]
        arg[0,0,1]=(0.841764493453)*x[0]+(-0.397262590373)*x[1]
        arg[0,1,0]=(0.318610649633)*x[0]+(1.59837795884)*x[1]
        arg[0,1,1]=(1.41408600658)*x[0]+(0.212012530707)*x[1]
        arg[1,0,0]=(-1.13663878903)*x[0]+(-0.535752609596)*x[1]
        arg[1,0,1]=(-0.795140440626)*x[0]+(-0.733456054749)*x[1]
        arg[1,1,0]=(-0.174874940569)*x[0]+(0.304037654801)*x[1]
        arg[1,1,1]=(0.835374268658)*x[0]+(0.645365790264)*x[1]
        arg[2,0,0]=(0.684064169293)*x[0]+(-0.580502209076)*x[1]
        arg[2,0,1]=(0.342542841673)*x[0]+(-0.620912562797)*x[1]
        arg[2,1,0]=(-0.457226288553)*x[0]+(-0.163180645461)*x[1]
        arg[2,1,1]=(-0.494067356015)*x[0]+(-0.604667785982)*x[1]
        arg[3,0,0]=(-0.224173319974)*x[0]+(-0.288566962407)*x[1]
        arg[3,0,1]=(-0.83578982053)*x[0]+(0.290663773612)*x[1]
        arg[3,1,0]=(0.700494058094)*x[0]+(0.244036699451)*x[1]
        arg[3,1,1]=(0.960756120912)*x[0]+(-0.129549309953)*x[1]
        arg[4,0,0]=(0.942292060296)*x[0]+(-0.148922577041)*x[1]
        arg[4,0,1]=(-0.363876552144)*x[0]+(0.903847614766)*x[1]
        arg[4,1,0]=(-1.91719369833)*x[0]+(0.961392595186)*x[1]
        arg[4,1,1]=(-0.141662097711)*x[0]+(-0.695061685931)*x[1]
        arg[5,0,0]=(0.416693171023)*x[0]+(1.04455773845)*x[1]
        arg[5,0,1]=(0.325327980312)*x[0]+(-1.01452792883)*x[1]
        arg[5,1,0]=(-1.43970903355)*x[0]+(-1.04382682561)*x[1]
        arg[5,1,1]=(-0.969700314248)*x[0]+(-0.286024748854)*x[1]
        ref[0,0,0,0]=(0.289868084377)
        ref[0,0,0,1]=(-1.636093365)
        ref[0,0,1,0]=(0.841764493453)
        ref[0,0,1,1]=(-0.397262590373)
        ref[0,1,0,0]=(0.318610649633)
        ref[0,1,0,1]=(1.59837795884)
        ref[0,1,1,0]=(1.41408600658)
        ref[0,1,1,1]=(0.212012530707)
        ref[1,0,0,0]=(-1.13663878903)
        ref[1,0,0,1]=(-0.535752609596)
        ref[1,0,1,0]=(-0.795140440626)
        ref[1,0,1,1]=(-0.733456054749)
        ref[1,1,0,0]=(-0.174874940569)
        ref[1,1,0,1]=(0.304037654801)
        ref[1,1,1,0]=(0.835374268658)
        ref[1,1,1,1]=(0.645365790264)
        ref[2,0,0,0]=(0.684064169293)
        ref[2,0,0,1]=(-0.580502209076)
        ref[2,0,1,0]=(0.342542841673)
        ref[2,0,1,1]=(-0.620912562797)
        ref[2,1,0,0]=(-0.457226288553)
        ref[2,1,0,1]=(-0.163180645461)
        ref[2,1,1,0]=(-0.494067356015)
        ref[2,1,1,1]=(-0.604667785982)
        ref[3,0,0,0]=(-0.224173319974)
        ref[3,0,0,1]=(-0.288566962407)
        ref[3,0,1,0]=(-0.83578982053)
        ref[3,0,1,1]=(0.290663773612)
        ref[3,1,0,0]=(0.700494058094)
        ref[3,1,0,1]=(0.244036699451)
        ref[3,1,1,0]=(0.960756120912)
        ref[3,1,1,1]=(-0.129549309953)
        ref[4,0,0,0]=(0.942292060296)
        ref[4,0,0,1]=(-0.148922577041)
        ref[4,0,1,0]=(-0.363876552144)
        ref[4,0,1,1]=(0.903847614766)
        ref[4,1,0,0]=(-1.91719369833)
        ref[4,1,0,1]=(0.961392595186)
        ref[4,1,1,0]=(-0.141662097711)
        ref[4,1,1,1]=(-0.695061685931)
        ref[5,0,0,0]=(0.416693171023)
        ref[5,0,0,1]=(1.04455773845)
        ref[5,0,1,0]=(0.325327980312)
        ref[5,0,1,1]=(-1.01452792883)
        ref[5,1,0,0]=(-1.43970903355)
        ref[5,1,0,1]=(-1.04382682561)
        ref[5,1,1,0]=(-0.969700314248)
        ref[5,1,1,1]=(-0.286024748854)
      else:
        arg[0,0,0]=(-1.52443210214)*x[0]+(-1.48020118993)*x[1]+(1.2552138343)*x[2]
        arg[0,0,1]=(-0.102900544448)*x[0]+(-1.14209442568)*x[1]+(-0.975626338621)*x[2]
        arg[0,1,0]=(0.909668629294)*x[0]+(1.29127341353)*x[1]+(-1.65221956404)*x[2]
        arg[0,1,1]=(-0.00309732749698)*x[0]+(0.0561682749786)*x[1]+(0.330039911431)*x[2]
        arg[1,0,0]=(0.966608417982)*x[0]+(-0.181702539284)*x[1]+(0.377393548129)*x[2]
        arg[1,0,1]=(0.0273333293331)*x[0]+(0.745172228806)*x[1]+(0.756302500232)*x[2]
        arg[1,1,0]=(-0.550382204645)*x[0]+(0.531191986475)*x[1]+(-1.02269665633)*x[2]
        arg[1,1,1]=(-0.928522491259)*x[0]+(-1.25241213648)*x[1]+(0.635412990933)*x[2]
        arg[2,0,0]=(-0.355234026557)*x[0]+(-1.69834232334)*x[1]+(1.17827811215)*x[2]
        arg[2,0,1]=(-0.905805855166)*x[0]+(1.4023187683)*x[1]+(-0.570168366306)*x[2]
        arg[2,1,0]=(0.550150523384)*x[0]+(-1.59933962526)*x[1]+(-0.388203251081)*x[2]
        arg[2,1,1]=(0.138470563927)*x[0]+(0.245233545344)*x[1]+(-0.293840556681)*x[2]
        arg[3,0,0]=(1.19700673733)*x[0]+(-1.04510591446)*x[1]+(1.03589008728)*x[2]
        arg[3,0,1]=(0.713948123924)*x[0]+(-1.42841558036)*x[1]+(1.07248428525)*x[2]
        arg[3,1,0]=(0.11223781122)*x[0]+(-0.00982612208261)*x[1]+(-0.263153847134)*x[2]
        arg[3,1,1]=(1.33011049869)*x[0]+(0.691016997799)*x[1]+(-0.0547947379786)*x[2]
        arg[4,0,0]=(1.0577224608)*x[0]+(-0.263034881475)*x[1]+(-0.854540775969)*x[2]
        arg[4,0,1]=(0.686363734714)*x[0]+(0.198120868875)*x[1]+(1.46326635417)*x[2]
        arg[4,1,0]=(-0.745244187008)*x[0]+(1.31766298118)*x[1]+(1.51544532829)*x[2]
        arg[4,1,1]=(0.878390723411)*x[0]+(-0.427741582253)*x[1]+(0.0324341706939)*x[2]
        arg[5,0,0]=(-0.445960121294)*x[0]+(-0.215668362178)*x[1]+(0.147632419682)*x[2]
        arg[5,0,1]=(-0.0781270285912)*x[0]+(0.782990026347)*x[1]+(-1.28046463036)*x[2]
        arg[5,1,0]=(-0.385003656622)*x[0]+(-1.02087438188)*x[1]+(-0.594357838151)*x[2]
        arg[5,1,1]=(-0.676669731714)*x[0]+(-0.28685220691)*x[1]+(0.335774697674)*x[2]
        ref[0,0,0,0]=(-1.52443210214)
        ref[0,0,0,1]=(-1.48020118993)
        ref[0,0,0,2]=(1.2552138343)
        ref[0,0,1,0]=(-0.102900544448)
        ref[0,0,1,1]=(-1.14209442568)
        ref[0,0,1,2]=(-0.975626338621)
        ref[0,1,0,0]=(0.909668629294)
        ref[0,1,0,1]=(1.29127341353)
        ref[0,1,0,2]=(-1.65221956404)
        ref[0,1,1,0]=(-0.00309732749698)
        ref[0,1,1,1]=(0.0561682749786)
        ref[0,1,1,2]=(0.330039911431)
        ref[1,0,0,0]=(0.966608417982)
        ref[1,0,0,1]=(-0.181702539284)
        ref[1,0,0,2]=(0.377393548129)
        ref[1,0,1,0]=(0.0273333293331)
        ref[1,0,1,1]=(0.745172228806)
        ref[1,0,1,2]=(0.756302500232)
        ref[1,1,0,0]=(-0.550382204645)
        ref[1,1,0,1]=(0.531191986475)
        ref[1,1,0,2]=(-1.02269665633)
        ref[1,1,1,0]=(-0.928522491259)
        ref[1,1,1,1]=(-1.25241213648)
        ref[1,1,1,2]=(0.635412990933)
        ref[2,0,0,0]=(-0.355234026557)
        ref[2,0,0,1]=(-1.69834232334)
        ref[2,0,0,2]=(1.17827811215)
        ref[2,0,1,0]=(-0.905805855166)
        ref[2,0,1,1]=(1.4023187683)
        ref[2,0,1,2]=(-0.570168366306)
        ref[2,1,0,0]=(0.550150523384)
        ref[2,1,0,1]=(-1.59933962526)
        ref[2,1,0,2]=(-0.388203251081)
        ref[2,1,1,0]=(0.138470563927)
        ref[2,1,1,1]=(0.245233545344)
        ref[2,1,1,2]=(-0.293840556681)
        ref[3,0,0,0]=(1.19700673733)
        ref[3,0,0,1]=(-1.04510591446)
        ref[3,0,0,2]=(1.03589008728)
        ref[3,0,1,0]=(0.713948123924)
        ref[3,0,1,1]=(-1.42841558036)
        ref[3,0,1,2]=(1.07248428525)
        ref[3,1,0,0]=(0.11223781122)
        ref[3,1,0,1]=(-0.00982612208261)
        ref[3,1,0,2]=(-0.263153847134)
        ref[3,1,1,0]=(1.33011049869)
        ref[3,1,1,1]=(0.691016997799)
        ref[3,1,1,2]=(-0.0547947379786)
        ref[4,0,0,0]=(1.0577224608)
        ref[4,0,0,1]=(-0.263034881475)
        ref[4,0,0,2]=(-0.854540775969)
        ref[4,0,1,0]=(0.686363734714)
        ref[4,0,1,1]=(0.198120868875)
        ref[4,0,1,2]=(1.46326635417)
        ref[4,1,0,0]=(-0.745244187008)
        ref[4,1,0,1]=(1.31766298118)
        ref[4,1,0,2]=(1.51544532829)
        ref[4,1,1,0]=(0.878390723411)
        ref[4,1,1,1]=(-0.427741582253)
        ref[4,1,1,2]=(0.0324341706939)
        ref[5,0,0,0]=(-0.445960121294)
        ref[5,0,0,1]=(-0.215668362178)
        ref[5,0,0,2]=(0.147632419682)
        ref[5,0,1,0]=(-0.0781270285912)
        ref[5,0,1,1]=(0.782990026347)
        ref[5,0,1,2]=(-1.28046463036)
        ref[5,1,0,0]=(-0.385003656622)
        ref[5,1,0,1]=(-1.02087438188)
        ref[5,1,0,2]=(-0.594357838151)
        ref[5,1,1,0]=(-0.676669731714)
        ref[5,1,1,1]=(-0.28685220691)
        ref[5,1,1,2]=(0.335774697674)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnBoundary_fromData_ReducedContinuousFunction_rank0(self):
      """
      tests gradient for rank 0 Data on the ReducedFunctionOnBoundary

      assumptions: ReducedContinuousFunction(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnBoundary
      """
      o=1
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=ReducedContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(),w)
      ref=Data(0,()+(dim,),w_ref)
      if dim==2:
        arg=(0.306947418999)*x[0]+(-0.706616694784)*x[1]
        ref[0]=(0.306947418999)
        ref[1]=(-0.706616694784)
      else:
        arg=(0.490435692707)*x[0]+(0.929248719763)*x[1]+(0.269868131113)*x[2]
        ref[0]=(0.490435692707)
        ref[1]=(0.929248719763)
        ref[2]=(0.269868131113)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),()+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnBoundary_fromData_ReducedContinuousFunction_rank1(self):
      """
      tests gradient for rank 1 Data on the ReducedFunctionOnBoundary

      assumptions: ReducedContinuousFunction(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnBoundary
      """
      o=1
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=ReducedContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(2,),w)
      ref=Data(0,(2,)+(dim,),w_ref)
      if dim==2:
        arg[0]=(-0.882633673888)*x[0]+(-0.790592442848)*x[1]
        arg[1]=(1.55495669126)*x[0]+(0.496011926182)*x[1]
        ref[0,0]=(-0.882633673888)
        ref[0,1]=(-0.790592442848)
        ref[1,0]=(1.55495669126)
        ref[1,1]=(0.496011926182)
      else:
        arg[0]=(0.683098278161)*x[0]+(-0.151590511238)*x[1]+(0.54461031868)*x[2]
        arg[1]=(0.59998040214)*x[0]+(-0.995466442084)*x[1]+(-1.09468062911)*x[2]
        ref[0,0]=(0.683098278161)
        ref[0,1]=(-0.151590511238)
        ref[0,2]=(0.54461031868)
        ref[1,0]=(0.59998040214)
        ref[1,1]=(-0.995466442084)
        ref[1,2]=(-1.09468062911)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnBoundary_fromData_ReducedContinuousFunction_rank2(self):
      """
      tests gradient for rank 2 Data on the ReducedFunctionOnBoundary

      assumptions: ReducedContinuousFunction(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnBoundary
      """
      o=1
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=ReducedContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(4, 5),w)
      ref=Data(0,(4, 5)+(dim,),w_ref)
      if dim==2:
        arg[0,0]=(-0.159129528541)*x[0]+(0.107835972384)*x[1]
        arg[0,1]=(-1.52388770934)*x[0]+(0.262089610596)*x[1]
        arg[0,2]=(0.505454501555)*x[0]+(-0.247061440744)*x[1]
        arg[0,3]=(-0.556075420202)*x[0]+(0.702144110506)*x[1]
        arg[0,4]=(0.810518335626)*x[0]+(-0.76077949525)*x[1]
        arg[1,0]=(-0.491052732808)*x[0]+(-0.272913467279)*x[1]
        arg[1,1]=(0.0141908236388)*x[0]+(1.10868804645)*x[1]
        arg[1,2]=(0.719028425382)*x[0]+(-0.544780305018)*x[1]
        arg[1,3]=(-1.15474920716)*x[0]+(0.888461325396)*x[1]
        arg[1,4]=(-0.842901893766)*x[0]+(-0.465916012282)*x[1]
        arg[2,0]=(1.24606386746)*x[0]+(0.817235825831)*x[1]
        arg[2,1]=(0.400861923494)*x[0]+(1.24545704982)*x[1]
        arg[2,2]=(0.656546253691)*x[0]+(-0.0269228973404)*x[1]
        arg[2,3]=(-0.590512343874)*x[0]+(-0.0654952556025)*x[1]
        arg[2,4]=(0.806342618281)*x[0]+(-0.183166204195)*x[1]
        arg[3,0]=(0.637045776935)*x[0]+(-0.512820906995)*x[1]
        arg[3,1]=(-0.596216711833)*x[0]+(-0.221853749777)*x[1]
        arg[3,2]=(0.113235739927)*x[0]+(-0.210641618992)*x[1]
        arg[3,3]=(-1.11423980423)*x[0]+(-1.46748285012)*x[1]
        arg[3,4]=(0.573260999643)*x[0]+(0.55016627172)*x[1]
        ref[0,0,0]=(-0.159129528541)
        ref[0,0,1]=(0.107835972384)
        ref[0,1,0]=(-1.52388770934)
        ref[0,1,1]=(0.262089610596)
        ref[0,2,0]=(0.505454501555)
        ref[0,2,1]=(-0.247061440744)
        ref[0,3,0]=(-0.556075420202)
        ref[0,3,1]=(0.702144110506)
        ref[0,4,0]=(0.810518335626)
        ref[0,4,1]=(-0.76077949525)
        ref[1,0,0]=(-0.491052732808)
        ref[1,0,1]=(-0.272913467279)
        ref[1,1,0]=(0.0141908236388)
        ref[1,1,1]=(1.10868804645)
        ref[1,2,0]=(0.719028425382)
        ref[1,2,1]=(-0.544780305018)
        ref[1,3,0]=(-1.15474920716)
        ref[1,3,1]=(0.888461325396)
        ref[1,4,0]=(-0.842901893766)
        ref[1,4,1]=(-0.465916012282)
        ref[2,0,0]=(1.24606386746)
        ref[2,0,1]=(0.817235825831)
        ref[2,1,0]=(0.400861923494)
        ref[2,1,1]=(1.24545704982)
        ref[2,2,0]=(0.656546253691)
        ref[2,2,1]=(-0.0269228973404)
        ref[2,3,0]=(-0.590512343874)
        ref[2,3,1]=(-0.0654952556025)
        ref[2,4,0]=(0.806342618281)
        ref[2,4,1]=(-0.183166204195)
        ref[3,0,0]=(0.637045776935)
        ref[3,0,1]=(-0.512820906995)
        ref[3,1,0]=(-0.596216711833)
        ref[3,1,1]=(-0.221853749777)
        ref[3,2,0]=(0.113235739927)
        ref[3,2,1]=(-0.210641618992)
        ref[3,3,0]=(-1.11423980423)
        ref[3,3,1]=(-1.46748285012)
        ref[3,4,0]=(0.573260999643)
        ref[3,4,1]=(0.55016627172)
      else:
        arg[0,0]=(-0.025505130975)*x[0]+(-0.128352022583)*x[1]+(-0.0645809876948)*x[2]
        arg[0,1]=(-0.974556985555)*x[0]+(0.503751568036)*x[1]+(-0.524784840232)*x[2]
        arg[0,2]=(-1.23653778531)*x[0]+(-0.73883453445)*x[1]+(-1.59259101746)*x[2]
        arg[0,3]=(-0.543656268618)*x[0]+(0.110486603472)*x[1]+(-0.636246757745)*x[2]
        arg[0,4]=(-0.566088225133)*x[0]+(-0.272577812471)*x[1]+(-0.282075405014)*x[2]
        arg[1,0]=(-0.28252305722)*x[0]+(0.497103425073)*x[1]+(0.997942367464)*x[2]
        arg[1,1]=(-0.444059543356)*x[0]+(-0.149004039444)*x[1]+(-0.871853047384)*x[2]
        arg[1,2]=(-0.610830496789)*x[0]+(0.196494475826)*x[1]+(0.0123852343883)*x[2]
        arg[1,3]=(-0.327903465165)*x[0]+(0.523560519595)*x[1]+(-0.409961704581)*x[2]
        arg[1,4]=(0.633897214746)*x[0]+(-0.9032002551)*x[1]+(0.624042996391)*x[2]
        arg[2,0]=(0.469489049636)*x[0]+(1.46158418286)*x[1]+(-0.538453674545)*x[2]
        arg[2,1]=(0.0488906165423)*x[0]+(0.483867458959)*x[1]+(0.0419643463366)*x[2]
        arg[2,2]=(-1.89716754038)*x[0]+(-0.577554008519)*x[1]+(-0.0328835832126)*x[2]
        arg[2,3]=(0.507329501469)*x[0]+(0.354939444351)*x[1]+(0.0136766029313)*x[2]
        arg[2,4]=(-0.313182267444)*x[0]+(-1.08684309178)*x[1]+(-1.39365968958)*x[2]
        arg[3,0]=(0.272322829309)*x[0]+(-0.233645276231)*x[1]+(0.491500838791)*x[2]
        arg[3,1]=(1.27603407856)*x[0]+(-0.709429989875)*x[1]+(-0.998371438244)*x[2]
        arg[3,2]=(0.637972716248)*x[0]+(-1.37896009762)*x[1]+(0.496830616786)*x[2]
        arg[3,3]=(-1.67735443481)*x[0]+(-0.741884420811)*x[1]+(1.23125805904)*x[2]
        arg[3,4]=(-0.593290763881)*x[0]+(-0.881909104701)*x[1]+(-1.0425499934)*x[2]
        ref[0,0,0]=(-0.025505130975)
        ref[0,0,1]=(-0.128352022583)
        ref[0,0,2]=(-0.0645809876948)
        ref[0,1,0]=(-0.974556985555)
        ref[0,1,1]=(0.503751568036)
        ref[0,1,2]=(-0.524784840232)
        ref[0,2,0]=(-1.23653778531)
        ref[0,2,1]=(-0.73883453445)
        ref[0,2,2]=(-1.59259101746)
        ref[0,3,0]=(-0.543656268618)
        ref[0,3,1]=(0.110486603472)
        ref[0,3,2]=(-0.636246757745)
        ref[0,4,0]=(-0.566088225133)
        ref[0,4,1]=(-0.272577812471)
        ref[0,4,2]=(-0.282075405014)
        ref[1,0,0]=(-0.28252305722)
        ref[1,0,1]=(0.497103425073)
        ref[1,0,2]=(0.997942367464)
        ref[1,1,0]=(-0.444059543356)
        ref[1,1,1]=(-0.149004039444)
        ref[1,1,2]=(-0.871853047384)
        ref[1,2,0]=(-0.610830496789)
        ref[1,2,1]=(0.196494475826)
        ref[1,2,2]=(0.0123852343883)
        ref[1,3,0]=(-0.327903465165)
        ref[1,3,1]=(0.523560519595)
        ref[1,3,2]=(-0.409961704581)
        ref[1,4,0]=(0.633897214746)
        ref[1,4,1]=(-0.9032002551)
        ref[1,4,2]=(0.624042996391)
        ref[2,0,0]=(0.469489049636)
        ref[2,0,1]=(1.46158418286)
        ref[2,0,2]=(-0.538453674545)
        ref[2,1,0]=(0.0488906165423)
        ref[2,1,1]=(0.483867458959)
        ref[2,1,2]=(0.0419643463366)
        ref[2,2,0]=(-1.89716754038)
        ref[2,2,1]=(-0.577554008519)
        ref[2,2,2]=(-0.0328835832126)
        ref[2,3,0]=(0.507329501469)
        ref[2,3,1]=(0.354939444351)
        ref[2,3,2]=(0.0136766029313)
        ref[2,4,0]=(-0.313182267444)
        ref[2,4,1]=(-1.08684309178)
        ref[2,4,2]=(-1.39365968958)
        ref[3,0,0]=(0.272322829309)
        ref[3,0,1]=(-0.233645276231)
        ref[3,0,2]=(0.491500838791)
        ref[3,1,0]=(1.27603407856)
        ref[3,1,1]=(-0.709429989875)
        ref[3,1,2]=(-0.998371438244)
        ref[3,2,0]=(0.637972716248)
        ref[3,2,1]=(-1.37896009762)
        ref[3,2,2]=(0.496830616786)
        ref[3,3,0]=(-1.67735443481)
        ref[3,3,1]=(-0.741884420811)
        ref[3,3,2]=(1.23125805904)
        ref[3,4,0]=(-0.593290763881)
        ref[3,4,1]=(-0.881909104701)
        ref[3,4,2]=(-1.0425499934)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnBoundary_fromData_ReducedContinuousFunction_rank3(self):
      """
      tests gradient for rank 3 Data on the ReducedFunctionOnBoundary

      assumptions: ReducedContinuousFunction(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnBoundary
      """
      o=1
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=ReducedContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(6, 2, 2),w)
      ref=Data(0,(6, 2, 2)+(dim,),w_ref)
      if dim==2:
        arg[0,0,0]=(0.289868084377)*x[0]+(-1.636093365)*x[1]
        arg[0,0,1]=(0.841764493453)*x[0]+(-0.397262590373)*x[1]
        arg[0,1,0]=(0.318610649633)*x[0]+(1.59837795884)*x[1]
        arg[0,1,1]=(1.41408600658)*x[0]+(0.212012530707)*x[1]
        arg[1,0,0]=(-1.13663878903)*x[0]+(-0.535752609596)*x[1]
        arg[1,0,1]=(-0.795140440626)*x[0]+(-0.733456054749)*x[1]
        arg[1,1,0]=(-0.174874940569)*x[0]+(0.304037654801)*x[1]
        arg[1,1,1]=(0.835374268658)*x[0]+(0.645365790264)*x[1]
        arg[2,0,0]=(0.684064169293)*x[0]+(-0.580502209076)*x[1]
        arg[2,0,1]=(0.342542841673)*x[0]+(-0.620912562797)*x[1]
        arg[2,1,0]=(-0.457226288553)*x[0]+(-0.163180645461)*x[1]
        arg[2,1,1]=(-0.494067356015)*x[0]+(-0.604667785982)*x[1]
        arg[3,0,0]=(-0.224173319974)*x[0]+(-0.288566962407)*x[1]
        arg[3,0,1]=(-0.83578982053)*x[0]+(0.290663773612)*x[1]
        arg[3,1,0]=(0.700494058094)*x[0]+(0.244036699451)*x[1]
        arg[3,1,1]=(0.960756120912)*x[0]+(-0.129549309953)*x[1]
        arg[4,0,0]=(0.942292060296)*x[0]+(-0.148922577041)*x[1]
        arg[4,0,1]=(-0.363876552144)*x[0]+(0.903847614766)*x[1]
        arg[4,1,0]=(-1.91719369833)*x[0]+(0.961392595186)*x[1]
        arg[4,1,1]=(-0.141662097711)*x[0]+(-0.695061685931)*x[1]
        arg[5,0,0]=(0.416693171023)*x[0]+(1.04455773845)*x[1]
        arg[5,0,1]=(0.325327980312)*x[0]+(-1.01452792883)*x[1]
        arg[5,1,0]=(-1.43970903355)*x[0]+(-1.04382682561)*x[1]
        arg[5,1,1]=(-0.969700314248)*x[0]+(-0.286024748854)*x[1]
        ref[0,0,0,0]=(0.289868084377)
        ref[0,0,0,1]=(-1.636093365)
        ref[0,0,1,0]=(0.841764493453)
        ref[0,0,1,1]=(-0.397262590373)
        ref[0,1,0,0]=(0.318610649633)
        ref[0,1,0,1]=(1.59837795884)
        ref[0,1,1,0]=(1.41408600658)
        ref[0,1,1,1]=(0.212012530707)
        ref[1,0,0,0]=(-1.13663878903)
        ref[1,0,0,1]=(-0.535752609596)
        ref[1,0,1,0]=(-0.795140440626)
        ref[1,0,1,1]=(-0.733456054749)
        ref[1,1,0,0]=(-0.174874940569)
        ref[1,1,0,1]=(0.304037654801)
        ref[1,1,1,0]=(0.835374268658)
        ref[1,1,1,1]=(0.645365790264)
        ref[2,0,0,0]=(0.684064169293)
        ref[2,0,0,1]=(-0.580502209076)
        ref[2,0,1,0]=(0.342542841673)
        ref[2,0,1,1]=(-0.620912562797)
        ref[2,1,0,0]=(-0.457226288553)
        ref[2,1,0,1]=(-0.163180645461)
        ref[2,1,1,0]=(-0.494067356015)
        ref[2,1,1,1]=(-0.604667785982)
        ref[3,0,0,0]=(-0.224173319974)
        ref[3,0,0,1]=(-0.288566962407)
        ref[3,0,1,0]=(-0.83578982053)
        ref[3,0,1,1]=(0.290663773612)
        ref[3,1,0,0]=(0.700494058094)
        ref[3,1,0,1]=(0.244036699451)
        ref[3,1,1,0]=(0.960756120912)
        ref[3,1,1,1]=(-0.129549309953)
        ref[4,0,0,0]=(0.942292060296)
        ref[4,0,0,1]=(-0.148922577041)
        ref[4,0,1,0]=(-0.363876552144)
        ref[4,0,1,1]=(0.903847614766)
        ref[4,1,0,0]=(-1.91719369833)
        ref[4,1,0,1]=(0.961392595186)
        ref[4,1,1,0]=(-0.141662097711)
        ref[4,1,1,1]=(-0.695061685931)
        ref[5,0,0,0]=(0.416693171023)
        ref[5,0,0,1]=(1.04455773845)
        ref[5,0,1,0]=(0.325327980312)
        ref[5,0,1,1]=(-1.01452792883)
        ref[5,1,0,0]=(-1.43970903355)
        ref[5,1,0,1]=(-1.04382682561)
        ref[5,1,1,0]=(-0.969700314248)
        ref[5,1,1,1]=(-0.286024748854)
      else:
        arg[0,0,0]=(-1.52443210214)*x[0]+(-1.48020118993)*x[1]+(1.2552138343)*x[2]
        arg[0,0,1]=(-0.102900544448)*x[0]+(-1.14209442568)*x[1]+(-0.975626338621)*x[2]
        arg[0,1,0]=(0.909668629294)*x[0]+(1.29127341353)*x[1]+(-1.65221956404)*x[2]
        arg[0,1,1]=(-0.00309732749698)*x[0]+(0.0561682749786)*x[1]+(0.330039911431)*x[2]
        arg[1,0,0]=(0.966608417982)*x[0]+(-0.181702539284)*x[1]+(0.377393548129)*x[2]
        arg[1,0,1]=(0.0273333293331)*x[0]+(0.745172228806)*x[1]+(0.756302500232)*x[2]
        arg[1,1,0]=(-0.550382204645)*x[0]+(0.531191986475)*x[1]+(-1.02269665633)*x[2]
        arg[1,1,1]=(-0.928522491259)*x[0]+(-1.25241213648)*x[1]+(0.635412990933)*x[2]
        arg[2,0,0]=(-0.355234026557)*x[0]+(-1.69834232334)*x[1]+(1.17827811215)*x[2]
        arg[2,0,1]=(-0.905805855166)*x[0]+(1.4023187683)*x[1]+(-0.570168366306)*x[2]
        arg[2,1,0]=(0.550150523384)*x[0]+(-1.59933962526)*x[1]+(-0.388203251081)*x[2]
        arg[2,1,1]=(0.138470563927)*x[0]+(0.245233545344)*x[1]+(-0.293840556681)*x[2]
        arg[3,0,0]=(1.19700673733)*x[0]+(-1.04510591446)*x[1]+(1.03589008728)*x[2]
        arg[3,0,1]=(0.713948123924)*x[0]+(-1.42841558036)*x[1]+(1.07248428525)*x[2]
        arg[3,1,0]=(0.11223781122)*x[0]+(-0.00982612208261)*x[1]+(-0.263153847134)*x[2]
        arg[3,1,1]=(1.33011049869)*x[0]+(0.691016997799)*x[1]+(-0.0547947379786)*x[2]
        arg[4,0,0]=(1.0577224608)*x[0]+(-0.263034881475)*x[1]+(-0.854540775969)*x[2]
        arg[4,0,1]=(0.686363734714)*x[0]+(0.198120868875)*x[1]+(1.46326635417)*x[2]
        arg[4,1,0]=(-0.745244187008)*x[0]+(1.31766298118)*x[1]+(1.51544532829)*x[2]
        arg[4,1,1]=(0.878390723411)*x[0]+(-0.427741582253)*x[1]+(0.0324341706939)*x[2]
        arg[5,0,0]=(-0.445960121294)*x[0]+(-0.215668362178)*x[1]+(0.147632419682)*x[2]
        arg[5,0,1]=(-0.0781270285912)*x[0]+(0.782990026347)*x[1]+(-1.28046463036)*x[2]
        arg[5,1,0]=(-0.385003656622)*x[0]+(-1.02087438188)*x[1]+(-0.594357838151)*x[2]
        arg[5,1,1]=(-0.676669731714)*x[0]+(-0.28685220691)*x[1]+(0.335774697674)*x[2]
        ref[0,0,0,0]=(-1.52443210214)
        ref[0,0,0,1]=(-1.48020118993)
        ref[0,0,0,2]=(1.2552138343)
        ref[0,0,1,0]=(-0.102900544448)
        ref[0,0,1,1]=(-1.14209442568)
        ref[0,0,1,2]=(-0.975626338621)
        ref[0,1,0,0]=(0.909668629294)
        ref[0,1,0,1]=(1.29127341353)
        ref[0,1,0,2]=(-1.65221956404)
        ref[0,1,1,0]=(-0.00309732749698)
        ref[0,1,1,1]=(0.0561682749786)
        ref[0,1,1,2]=(0.330039911431)
        ref[1,0,0,0]=(0.966608417982)
        ref[1,0,0,1]=(-0.181702539284)
        ref[1,0,0,2]=(0.377393548129)
        ref[1,0,1,0]=(0.0273333293331)
        ref[1,0,1,1]=(0.745172228806)
        ref[1,0,1,2]=(0.756302500232)
        ref[1,1,0,0]=(-0.550382204645)
        ref[1,1,0,1]=(0.531191986475)
        ref[1,1,0,2]=(-1.02269665633)
        ref[1,1,1,0]=(-0.928522491259)
        ref[1,1,1,1]=(-1.25241213648)
        ref[1,1,1,2]=(0.635412990933)
        ref[2,0,0,0]=(-0.355234026557)
        ref[2,0,0,1]=(-1.69834232334)
        ref[2,0,0,2]=(1.17827811215)
        ref[2,0,1,0]=(-0.905805855166)
        ref[2,0,1,1]=(1.4023187683)
        ref[2,0,1,2]=(-0.570168366306)
        ref[2,1,0,0]=(0.550150523384)
        ref[2,1,0,1]=(-1.59933962526)
        ref[2,1,0,2]=(-0.388203251081)
        ref[2,1,1,0]=(0.138470563927)
        ref[2,1,1,1]=(0.245233545344)
        ref[2,1,1,2]=(-0.293840556681)
        ref[3,0,0,0]=(1.19700673733)
        ref[3,0,0,1]=(-1.04510591446)
        ref[3,0,0,2]=(1.03589008728)
        ref[3,0,1,0]=(0.713948123924)
        ref[3,0,1,1]=(-1.42841558036)
        ref[3,0,1,2]=(1.07248428525)
        ref[3,1,0,0]=(0.11223781122)
        ref[3,1,0,1]=(-0.00982612208261)
        ref[3,1,0,2]=(-0.263153847134)
        ref[3,1,1,0]=(1.33011049869)
        ref[3,1,1,1]=(0.691016997799)
        ref[3,1,1,2]=(-0.0547947379786)
        ref[4,0,0,0]=(1.0577224608)
        ref[4,0,0,1]=(-0.263034881475)
        ref[4,0,0,2]=(-0.854540775969)
        ref[4,0,1,0]=(0.686363734714)
        ref[4,0,1,1]=(0.198120868875)
        ref[4,0,1,2]=(1.46326635417)
        ref[4,1,0,0]=(-0.745244187008)
        ref[4,1,0,1]=(1.31766298118)
        ref[4,1,0,2]=(1.51544532829)
        ref[4,1,1,0]=(0.878390723411)
        ref[4,1,1,1]=(-0.427741582253)
        ref[4,1,1,2]=(0.0324341706939)
        ref[5,0,0,0]=(-0.445960121294)
        ref[5,0,0,1]=(-0.215668362178)
        ref[5,0,0,2]=(0.147632419682)
        ref[5,0,1,0]=(-0.0781270285912)
        ref[5,0,1,1]=(0.782990026347)
        ref[5,0,1,2]=(-1.28046463036)
        ref[5,1,0,0]=(-0.385003656622)
        ref[5,1,0,1]=(-1.02087438188)
        ref[5,1,0,2]=(-0.594357838151)
        ref[5,1,1,0]=(-0.676669731714)
        ref[5,1,1,1]=(-0.28685220691)
        ref[5,1,1,2]=(0.335774697674)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnContactZero_fromData_ContinuousFunction_rank0(self):
      """
      tests gradient for rank 0 Data on the FunctionOnContactZero

      assumptions: ContinuousFunction(self.domain) exists
                   self.domain supports gradient on FunctionOnContactZero
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=FunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=ContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(),w)
      ref=Data(0,()+(dim,),w_ref)
      if dim==2:
        arg=(-0.447987377779)*x[0]**o+(-0.3185298109)*x[0]+(0.748689324197)*x[1]**o+(-0.979369398128)*x[1]
        ref[0]=o*(-0.447987377779)*x_ref[0]**(o-1)+(-0.3185298109)
        ref[1]=o*(0.748689324197)*x_ref[1]**(o-1)+(-0.979369398128)
      else:
        arg=(-0.991175677257)*x[0]**o+(0.486310659385)*x[0]+(0.366862476014)*x[1]**o+(0.718311286349)*x[1]+(-0.593137377946)*x[2]**o+(-0.98259729892)*x[2]
        ref[0]=o*(-0.991175677257)*x_ref[0]**(o-1)+(0.486310659385)
        ref[1]=o*(0.366862476014)*x_ref[1]**(o-1)+(0.718311286349)
        ref[2]=o*(-0.593137377946)*x_ref[2]**(o-1)+(-0.98259729892)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),()+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnContactZero_fromData_ContinuousFunction_rank1(self):
      """
      tests gradient for rank 1 Data on the FunctionOnContactZero

      assumptions: ContinuousFunction(self.domain) exists
                   self.domain supports gradient on FunctionOnContactZero
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=FunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=ContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(2,),w)
      ref=Data(0,(2,)+(dim,),w_ref)
      if dim==2:
        arg[0]=(0.532427358862)*x[0]**o+(-0.699829406888)*x[0]+(-0.378181075858)*x[1]**o+(-0.163897932934)*x[1]
        arg[1]=(0.76393225396)*x[0]**o+(0.87331212216)*x[0]+(0.0261520274749)*x[1]**o+(-0.475078274702)*x[1]
        ref[0,0]=o*(0.532427358862)*x_ref[0]**(o-1)+(-0.699829406888)
        ref[0,1]=o*(-0.378181075858)*x_ref[1]**(o-1)+(-0.163897932934)
        ref[1,0]=o*(0.76393225396)*x_ref[0]**(o-1)+(0.87331212216)
        ref[1,1]=o*(0.0261520274749)*x_ref[1]**(o-1)+(-0.475078274702)
      else:
        arg[0]=(-0.559640148983)*x[0]**o+(0.868360358061)*x[0]+(0.148807680806)*x[1]**o+(-0.488426629736)*x[1]+(0.99381766343)*x[2]**o+(-0.0241703848022)*x[2]
        arg[1]=(-0.00270447073555)*x[0]**o+(0.599732416474)*x[0]+(-0.455449579349)*x[1]**o+(-0.791088816655)*x[1]+(0.850362671968)*x[2]**o+(-0.180726138889)*x[2]
        ref[0,0]=o*(-0.559640148983)*x_ref[0]**(o-1)+(0.868360358061)
        ref[0,1]=o*(0.148807680806)*x_ref[1]**(o-1)+(-0.488426629736)
        ref[0,2]=o*(0.99381766343)*x_ref[2]**(o-1)+(-0.0241703848022)
        ref[1,0]=o*(-0.00270447073555)*x_ref[0]**(o-1)+(0.599732416474)
        ref[1,1]=o*(-0.455449579349)*x_ref[1]**(o-1)+(-0.791088816655)
        ref[1,2]=o*(0.850362671968)*x_ref[2]**(o-1)+(-0.180726138889)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnContactZero_fromData_ContinuousFunction_rank2(self):
      """
      tests gradient for rank 2 Data on the FunctionOnContactZero

      assumptions: ContinuousFunction(self.domain) exists
                   self.domain supports gradient on FunctionOnContactZero
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=FunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=ContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(4, 5),w)
      ref=Data(0,(4, 5)+(dim,),w_ref)
      if dim==2:
        arg[0,0]=(0.157399152858)*x[0]**o+(0.00598352783814)*x[0]+(-0.904853822462)*x[1]**o+(0.767645769461)*x[1]
        arg[0,1]=(0.764556091331)*x[0]**o+(-0.167733604181)*x[0]+(0.723254547109)*x[1]**o+(-0.863633737324)*x[1]
        arg[0,2]=(0.480913138549)*x[0]**o+(0.505712705322)*x[0]+(-0.295398027463)*x[1]**o+(-0.0497846093953)*x[1]
        arg[0,3]=(-0.957208239652)*x[0]**o+(0.608346818502)*x[0]+(-0.194623401251)*x[1]**o+(0.670671588806)*x[1]
        arg[0,4]=(-0.179165159786)*x[0]**o+(-0.146090255471)*x[0]+(-0.413009197676)*x[1]**o+(-0.168508218849)*x[1]
        arg[1,0]=(0.659914628278)*x[0]**o+(0.123177996909)*x[0]+(0.713971230628)*x[1]**o+(-0.687569461154)*x[1]
        arg[1,1]=(0.857554477911)*x[0]**o+(0.119604916634)*x[0]+(-0.123185856515)*x[1]**o+(0.968800869965)*x[1]
        arg[1,2]=(0.566596883167)*x[0]**o+(-0.667227639224)*x[0]+(0.29838343622)*x[1]**o+(0.0172896834006)*x[1]
        arg[1,3]=(0.340418732306)*x[0]**o+(-0.115031635126)*x[0]+(0.212495048781)*x[1]**o+(-0.690939141829)*x[1]
        arg[1,4]=(-0.513225187356)*x[0]**o+(0.975159534619)*x[0]+(0.159694719764)*x[1]**o+(-0.441973185517)*x[1]
        arg[2,0]=(0.00598247134499)*x[0]**o+(-0.680866157243)*x[0]+(0.198740044836)*x[1]**o+(-0.776778848701)*x[1]
        arg[2,1]=(0.385572341196)*x[0]**o+(-0.911229388405)*x[0]+(-0.869563350649)*x[1]**o+(-0.453073292811)*x[1]
        arg[2,2]=(-0.678405510051)*x[0]**o+(0.570159849365)*x[0]+(-0.998909274112)*x[1]**o+(-0.56867397999)*x[1]
        arg[2,3]=(0.592650344218)*x[0]**o+(-0.990760992864)*x[0]+(0.54832364584)*x[1]**o+(-0.62848423403)*x[1]
        arg[2,4]=(-0.267222595774)*x[0]**o+(-0.398631721649)*x[0]+(-0.139351142788)*x[1]**o+(-0.973211734322)*x[1]
        arg[3,0]=(-0.748270220449)*x[0]**o+(-0.432648285296)*x[0]+(-0.572322019432)*x[1]**o+(-0.361258377472)*x[1]
        arg[3,1]=(-0.872970937458)*x[0]**o+(-0.412714429527)*x[0]+(0.28965384698)*x[1]**o+(0.0899128505144)*x[1]
        arg[3,2]=(-0.448552675711)*x[0]**o+(-0.0531593149976)*x[0]+(-0.445359129375)*x[1]**o+(-0.357551800127)*x[1]
        arg[3,3]=(-0.120676057603)*x[0]**o+(-0.736959379114)*x[0]+(-0.437089829553)*x[1]**o+(-0.272117257464)*x[1]
        arg[3,4]=(0.342279309395)*x[0]**o+(0.182206506048)*x[0]+(0.843948330758)*x[1]**o+(0.165354303251)*x[1]
        ref[0,0,0]=o*(0.157399152858)*x_ref[0]**(o-1)+(0.00598352783814)
        ref[0,0,1]=o*(-0.904853822462)*x_ref[1]**(o-1)+(0.767645769461)
        ref[0,1,0]=o*(0.764556091331)*x_ref[0]**(o-1)+(-0.167733604181)
        ref[0,1,1]=o*(0.723254547109)*x_ref[1]**(o-1)+(-0.863633737324)
        ref[0,2,0]=o*(0.480913138549)*x_ref[0]**(o-1)+(0.505712705322)
        ref[0,2,1]=o*(-0.295398027463)*x_ref[1]**(o-1)+(-0.0497846093953)
        ref[0,3,0]=o*(-0.957208239652)*x_ref[0]**(o-1)+(0.608346818502)
        ref[0,3,1]=o*(-0.194623401251)*x_ref[1]**(o-1)+(0.670671588806)
        ref[0,4,0]=o*(-0.179165159786)*x_ref[0]**(o-1)+(-0.146090255471)
        ref[0,4,1]=o*(-0.413009197676)*x_ref[1]**(o-1)+(-0.168508218849)
        ref[1,0,0]=o*(0.659914628278)*x_ref[0]**(o-1)+(0.123177996909)
        ref[1,0,1]=o*(0.713971230628)*x_ref[1]**(o-1)+(-0.687569461154)
        ref[1,1,0]=o*(0.857554477911)*x_ref[0]**(o-1)+(0.119604916634)
        ref[1,1,1]=o*(-0.123185856515)*x_ref[1]**(o-1)+(0.968800869965)
        ref[1,2,0]=o*(0.566596883167)*x_ref[0]**(o-1)+(-0.667227639224)
        ref[1,2,1]=o*(0.29838343622)*x_ref[1]**(o-1)+(0.0172896834006)
        ref[1,3,0]=o*(0.340418732306)*x_ref[0]**(o-1)+(-0.115031635126)
        ref[1,3,1]=o*(0.212495048781)*x_ref[1]**(o-1)+(-0.690939141829)
        ref[1,4,0]=o*(-0.513225187356)*x_ref[0]**(o-1)+(0.975159534619)
        ref[1,4,1]=o*(0.159694719764)*x_ref[1]**(o-1)+(-0.441973185517)
        ref[2,0,0]=o*(0.00598247134499)*x_ref[0]**(o-1)+(-0.680866157243)
        ref[2,0,1]=o*(0.198740044836)*x_ref[1]**(o-1)+(-0.776778848701)
        ref[2,1,0]=o*(0.385572341196)*x_ref[0]**(o-1)+(-0.911229388405)
        ref[2,1,1]=o*(-0.869563350649)*x_ref[1]**(o-1)+(-0.453073292811)
        ref[2,2,0]=o*(-0.678405510051)*x_ref[0]**(o-1)+(0.570159849365)
        ref[2,2,1]=o*(-0.998909274112)*x_ref[1]**(o-1)+(-0.56867397999)
        ref[2,3,0]=o*(0.592650344218)*x_ref[0]**(o-1)+(-0.990760992864)
        ref[2,3,1]=o*(0.54832364584)*x_ref[1]**(o-1)+(-0.62848423403)
        ref[2,4,0]=o*(-0.267222595774)*x_ref[0]**(o-1)+(-0.398631721649)
        ref[2,4,1]=o*(-0.139351142788)*x_ref[1]**(o-1)+(-0.973211734322)
        ref[3,0,0]=o*(-0.748270220449)*x_ref[0]**(o-1)+(-0.432648285296)
        ref[3,0,1]=o*(-0.572322019432)*x_ref[1]**(o-1)+(-0.361258377472)
        ref[3,1,0]=o*(-0.872970937458)*x_ref[0]**(o-1)+(-0.412714429527)
        ref[3,1,1]=o*(0.28965384698)*x_ref[1]**(o-1)+(0.0899128505144)
        ref[3,2,0]=o*(-0.448552675711)*x_ref[0]**(o-1)+(-0.0531593149976)
        ref[3,2,1]=o*(-0.445359129375)*x_ref[1]**(o-1)+(-0.357551800127)
        ref[3,3,0]=o*(-0.120676057603)*x_ref[0]**(o-1)+(-0.736959379114)
        ref[3,3,1]=o*(-0.437089829553)*x_ref[1]**(o-1)+(-0.272117257464)
        ref[3,4,0]=o*(0.342279309395)*x_ref[0]**(o-1)+(0.182206506048)
        ref[3,4,1]=o*(0.843948330758)*x_ref[1]**(o-1)+(0.165354303251)
      else:
        arg[0,0]=(-0.912611504385)*x[0]**o+(0.730660242466)*x[0]+(-0.807306513948)*x[1]**o+(-0.611619910819)*x[1]+(-0.567616988907)*x[2]**o+(0.554411283236)*x[2]
        arg[0,1]=(-0.900956431107)*x[0]**o+(-0.731441474835)*x[0]+(0.366905510731)*x[1]**o+(0.444763254457)*x[1]+(0.223337203463)*x[2]**o+(0.0823258304577)*x[2]
        arg[0,2]=(-0.300262400629)*x[0]**o+(0.781835992318)*x[0]+(-0.961025746467)*x[1]**o+(-0.0255420888548)*x[1]+(-0.195336914392)*x[2]**o+(0.631006440014)*x[2]
        arg[0,3]=(-0.0362225627667)*x[0]**o+(-0.258309391935)*x[0]+(0.915114590957)*x[1]**o+(-0.0261151730116)*x[1]+(-0.0359136191693)*x[2]**o+(0.34837541797)*x[2]
        arg[0,4]=(0.718483283111)*x[0]**o+(-0.981945434022)*x[0]+(0.715616160215)*x[1]**o+(-0.213673997408)*x[1]+(0.703864386687)*x[2]**o+(-0.258970624794)*x[2]
        arg[1,0]=(0.562339421788)*x[0]**o+(-0.469800316995)*x[0]+(-0.58860202695)*x[1]**o+(0.592493291759)*x[1]+(-0.0747446509827)*x[2]**o+(0.459846703357)*x[2]
        arg[1,1]=(-0.739792007188)*x[0]**o+(0.69804646711)*x[0]+(0.685574577582)*x[1]**o+(0.34906822136)*x[1]+(-0.346626103556)*x[2]**o+(-0.186290616908)*x[2]
        arg[1,2]=(0.605479936712)*x[0]**o+(0.23811484281)*x[0]+(-0.18270059933)*x[1]**o+(-0.883573478283)*x[1]+(0.558417469124)*x[2]**o+(0.0921284647122)*x[2]
        arg[1,3]=(0.829453952054)*x[0]**o+(0.0943225421949)*x[0]+(-0.377472410614)*x[1]**o+(0.422596289908)*x[1]+(0.992700203574)*x[2]**o+(0.954704595957)*x[2]
        arg[1,4]=(0.713437745608)*x[0]**o+(-0.90755469394)*x[0]+(-0.116969245983)*x[1]**o+(-0.615609779318)*x[1]+(-0.631014272933)*x[2]**o+(0.196556707186)*x[2]
        arg[2,0]=(-0.643142569205)*x[0]**o+(-0.522571508238)*x[0]+(-0.221094875426)*x[1]**o+(0.00263621704394)*x[1]+(-0.346088170378)*x[2]**o+(-0.323346603492)*x[2]
        arg[2,1]=(0.121192120404)*x[0]**o+(-0.910581465748)*x[0]+(0.661403514322)*x[1]**o+(0.314356472557)*x[1]+(0.740349932503)*x[2]**o+(0.397923840477)*x[2]
        arg[2,2]=(0.712887835251)*x[0]**o+(0.802827824977)*x[0]+(0.225275507294)*x[1]**o+(0.00655056099106)*x[1]+(-0.0211189465513)*x[2]**o+(-0.672450969446)*x[2]
        arg[2,3]=(0.220976204507)*x[0]**o+(0.384529933174)*x[0]+(-0.824967564367)*x[1]**o+(0.382079183434)*x[1]+(0.975192346085)*x[2]**o+(-0.845325222223)*x[2]
        arg[2,4]=(-0.316551069119)*x[0]**o+(0.194934627874)*x[0]+(0.192096230967)*x[1]**o+(-0.423775967466)*x[1]+(-0.669140845203)*x[2]**o+(0.367813824992)*x[2]
        arg[3,0]=(-0.361410077778)*x[0]**o+(0.377521588398)*x[0]+(-0.795093364568)*x[1]**o+(0.475257686757)*x[1]+(-0.996619080341)*x[2]**o+(-0.909105543506)*x[2]
        arg[3,1]=(-0.324100979259)*x[0]**o+(-0.950807456193)*x[0]+(-0.141687301441)*x[1]**o+(0.153568029515)*x[1]+(-0.698514966417)*x[2]**o+(0.312395968777)*x[2]
        arg[3,2]=(-0.997783460035)*x[0]**o+(0.328724967881)*x[0]+(-0.561572087716)*x[1]**o+(-0.0148890799876)*x[1]+(0.236142454998)*x[2]**o+(-0.36513107554)*x[2]
        arg[3,3]=(0.750818510719)*x[0]**o+(-0.484598204959)*x[0]+(-0.599436804638)*x[1]**o+(-0.236232976078)*x[1]+(-0.0789148183785)*x[2]**o+(-0.74437164566)*x[2]
        arg[3,4]=(-0.730664688591)*x[0]**o+(-0.94753100979)*x[0]+(-0.671463334034)*x[1]**o+(-0.139992464354)*x[1]+(0.286757519111)*x[2]**o+(0.512453551537)*x[2]
        ref[0,0,0]=o*(-0.912611504385)*x_ref[0]**(o-1)+(0.730660242466)
        ref[0,0,1]=o*(-0.807306513948)*x_ref[1]**(o-1)+(-0.611619910819)
        ref[0,0,2]=o*(-0.567616988907)*x_ref[2]**(o-1)+(0.554411283236)
        ref[0,1,0]=o*(-0.900956431107)*x_ref[0]**(o-1)+(-0.731441474835)
        ref[0,1,1]=o*(0.366905510731)*x_ref[1]**(o-1)+(0.444763254457)
        ref[0,1,2]=o*(0.223337203463)*x_ref[2]**(o-1)+(0.0823258304577)
        ref[0,2,0]=o*(-0.300262400629)*x_ref[0]**(o-1)+(0.781835992318)
        ref[0,2,1]=o*(-0.961025746467)*x_ref[1]**(o-1)+(-0.0255420888548)
        ref[0,2,2]=o*(-0.195336914392)*x_ref[2]**(o-1)+(0.631006440014)
        ref[0,3,0]=o*(-0.0362225627667)*x_ref[0]**(o-1)+(-0.258309391935)
        ref[0,3,1]=o*(0.915114590957)*x_ref[1]**(o-1)+(-0.0261151730116)
        ref[0,3,2]=o*(-0.0359136191693)*x_ref[2]**(o-1)+(0.34837541797)
        ref[0,4,0]=o*(0.718483283111)*x_ref[0]**(o-1)+(-0.981945434022)
        ref[0,4,1]=o*(0.715616160215)*x_ref[1]**(o-1)+(-0.213673997408)
        ref[0,4,2]=o*(0.703864386687)*x_ref[2]**(o-1)+(-0.258970624794)
        ref[1,0,0]=o*(0.562339421788)*x_ref[0]**(o-1)+(-0.469800316995)
        ref[1,0,1]=o*(-0.58860202695)*x_ref[1]**(o-1)+(0.592493291759)
        ref[1,0,2]=o*(-0.0747446509827)*x_ref[2]**(o-1)+(0.459846703357)
        ref[1,1,0]=o*(-0.739792007188)*x_ref[0]**(o-1)+(0.69804646711)
        ref[1,1,1]=o*(0.685574577582)*x_ref[1]**(o-1)+(0.34906822136)
        ref[1,1,2]=o*(-0.346626103556)*x_ref[2]**(o-1)+(-0.186290616908)
        ref[1,2,0]=o*(0.605479936712)*x_ref[0]**(o-1)+(0.23811484281)
        ref[1,2,1]=o*(-0.18270059933)*x_ref[1]**(o-1)+(-0.883573478283)
        ref[1,2,2]=o*(0.558417469124)*x_ref[2]**(o-1)+(0.0921284647122)
        ref[1,3,0]=o*(0.829453952054)*x_ref[0]**(o-1)+(0.0943225421949)
        ref[1,3,1]=o*(-0.377472410614)*x_ref[1]**(o-1)+(0.422596289908)
        ref[1,3,2]=o*(0.992700203574)*x_ref[2]**(o-1)+(0.954704595957)
        ref[1,4,0]=o*(0.713437745608)*x_ref[0]**(o-1)+(-0.90755469394)
        ref[1,4,1]=o*(-0.116969245983)*x_ref[1]**(o-1)+(-0.615609779318)
        ref[1,4,2]=o*(-0.631014272933)*x_ref[2]**(o-1)+(0.196556707186)
        ref[2,0,0]=o*(-0.643142569205)*x_ref[0]**(o-1)+(-0.522571508238)
        ref[2,0,1]=o*(-0.221094875426)*x_ref[1]**(o-1)+(0.00263621704394)
        ref[2,0,2]=o*(-0.346088170378)*x_ref[2]**(o-1)+(-0.323346603492)
        ref[2,1,0]=o*(0.121192120404)*x_ref[0]**(o-1)+(-0.910581465748)
        ref[2,1,1]=o*(0.661403514322)*x_ref[1]**(o-1)+(0.314356472557)
        ref[2,1,2]=o*(0.740349932503)*x_ref[2]**(o-1)+(0.397923840477)
        ref[2,2,0]=o*(0.712887835251)*x_ref[0]**(o-1)+(0.802827824977)
        ref[2,2,1]=o*(0.225275507294)*x_ref[1]**(o-1)+(0.00655056099106)
        ref[2,2,2]=o*(-0.0211189465513)*x_ref[2]**(o-1)+(-0.672450969446)
        ref[2,3,0]=o*(0.220976204507)*x_ref[0]**(o-1)+(0.384529933174)
        ref[2,3,1]=o*(-0.824967564367)*x_ref[1]**(o-1)+(0.382079183434)
        ref[2,3,2]=o*(0.975192346085)*x_ref[2]**(o-1)+(-0.845325222223)
        ref[2,4,0]=o*(-0.316551069119)*x_ref[0]**(o-1)+(0.194934627874)
        ref[2,4,1]=o*(0.192096230967)*x_ref[1]**(o-1)+(-0.423775967466)
        ref[2,4,2]=o*(-0.669140845203)*x_ref[2]**(o-1)+(0.367813824992)
        ref[3,0,0]=o*(-0.361410077778)*x_ref[0]**(o-1)+(0.377521588398)
        ref[3,0,1]=o*(-0.795093364568)*x_ref[1]**(o-1)+(0.475257686757)
        ref[3,0,2]=o*(-0.996619080341)*x_ref[2]**(o-1)+(-0.909105543506)
        ref[3,1,0]=o*(-0.324100979259)*x_ref[0]**(o-1)+(-0.950807456193)
        ref[3,1,1]=o*(-0.141687301441)*x_ref[1]**(o-1)+(0.153568029515)
        ref[3,1,2]=o*(-0.698514966417)*x_ref[2]**(o-1)+(0.312395968777)
        ref[3,2,0]=o*(-0.997783460035)*x_ref[0]**(o-1)+(0.328724967881)
        ref[3,2,1]=o*(-0.561572087716)*x_ref[1]**(o-1)+(-0.0148890799876)
        ref[3,2,2]=o*(0.236142454998)*x_ref[2]**(o-1)+(-0.36513107554)
        ref[3,3,0]=o*(0.750818510719)*x_ref[0]**(o-1)+(-0.484598204959)
        ref[3,3,1]=o*(-0.599436804638)*x_ref[1]**(o-1)+(-0.236232976078)
        ref[3,3,2]=o*(-0.0789148183785)*x_ref[2]**(o-1)+(-0.74437164566)
        ref[3,4,0]=o*(-0.730664688591)*x_ref[0]**(o-1)+(-0.94753100979)
        ref[3,4,1]=o*(-0.671463334034)*x_ref[1]**(o-1)+(-0.139992464354)
        ref[3,4,2]=o*(0.286757519111)*x_ref[2]**(o-1)+(0.512453551537)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnContactZero_fromData_ContinuousFunction_rank3(self):
      """
      tests gradient for rank 3 Data on the FunctionOnContactZero

      assumptions: ContinuousFunction(self.domain) exists
                   self.domain supports gradient on FunctionOnContactZero
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=FunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=ContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(6, 2, 2),w)
      ref=Data(0,(6, 2, 2)+(dim,),w_ref)
      if dim==2:
        arg[0,0,0]=(0.467597203998)*x[0]**o+(-0.878331243959)*x[0]+(-0.971530784104)*x[1]**o+(0.685854853102)*x[1]
        arg[0,0,1]=(0.291345615954)*x[0]**o+(-0.745469654319)*x[0]+(0.976621664002)*x[1]**o+(-0.881452217847)*x[1]
        arg[0,1,0]=(0.537843295475)*x[0]**o+(0.489619951145)*x[0]+(0.77330251637)*x[1]**o+(0.998031266089)*x[1]
        arg[0,1,1]=(0.355984068681)*x[0]**o+(-0.814720548776)*x[0]+(0.495564264626)*x[1]**o+(0.525926194911)*x[1]
        arg[1,0,0]=(0.0459062782507)*x[0]**o+(0.745363380399)*x[0]+(0.254962338793)*x[1]**o+(-0.818268107226)*x[1]
        arg[1,0,1]=(0.806972777032)*x[0]**o+(0.65759411882)*x[0]+(-0.714015350868)*x[1]**o+(0.785611067194)*x[1]
        arg[1,1,0]=(0.576206375389)*x[0]**o+(-0.502513595266)*x[0]+(0.258287392463)*x[1]**o+(0.0897418205816)*x[1]
        arg[1,1,1]=(-0.854645709831)*x[0]**o+(0.48910569315)*x[0]+(0.684503579045)*x[1]**o+(0.156890859871)*x[1]
        arg[2,0,0]=(-0.535650648427)*x[0]**o+(-0.189186476574)*x[0]+(-0.62891575537)*x[1]**o+(-0.37603690255)*x[1]
        arg[2,0,1]=(-0.153001902814)*x[0]**o+(0.028214773063)*x[0]+(-0.605102549169)*x[1]**o+(-0.566991398262)*x[1]
        arg[2,1,0]=(0.607976055886)*x[0]**o+(-0.247395663109)*x[0]+(0.424340230656)*x[1]**o+(0.210489427749)*x[1]
        arg[2,1,1]=(-0.513543937157)*x[0]**o+(0.345931529219)*x[0]+(0.893744279358)*x[1]**o+(-0.519602594857)*x[1]
        arg[3,0,0]=(-0.618812192169)*x[0]**o+(-0.897898654184)*x[0]+(-0.717700928924)*x[1]**o+(-0.21348885325)*x[1]
        arg[3,0,1]=(-0.582829504396)*x[0]**o+(-0.0726162868757)*x[0]+(0.366457797377)*x[1]**o+(0.479006714526)*x[1]
        arg[3,1,0]=(0.929143108169)*x[0]**o+(-0.302254589362)*x[0]+(-0.518817476772)*x[1]**o+(0.854860903894)*x[1]
        arg[3,1,1]=(-0.815422381361)*x[0]**o+(-0.183407261786)*x[0]+(0.841334455272)*x[1]**o+(-0.560841747647)*x[1]
        arg[4,0,0]=(0.746229089137)*x[0]**o+(-0.00173525360161)*x[0]+(0.729473923491)*x[1]**o+(-0.0152936558265)*x[1]
        arg[4,0,1]=(-0.0474071267025)*x[0]**o+(-0.380505263812)*x[0]+(0.166181839511)*x[1]**o+(-0.421069915995)*x[1]
        arg[4,1,0]=(-0.826801927705)*x[0]**o+(0.704799677183)*x[0]+(-0.0346961982898)*x[1]**o+(-0.401235214163)*x[1]
        arg[4,1,1]=(-0.973646144788)*x[0]**o+(0.469976655077)*x[0]+(-0.458846284633)*x[1]**o+(0.818397008807)*x[1]
        arg[5,0,0]=(0.155460716472)*x[0]**o+(-0.509095443426)*x[0]+(-0.0942934981524)*x[1]**o+(0.754087972651)*x[1]
        arg[5,0,1]=(-0.584172835053)*x[0]**o+(-0.904579020559)*x[0]+(0.156301832106)*x[1]**o+(0.169995805721)*x[1]
        arg[5,1,0]=(-0.424977437614)*x[0]**o+(0.244566550647)*x[0]+(-0.474400097866)*x[1]**o+(-0.315912223349)*x[1]
        arg[5,1,1]=(0.764961378837)*x[0]**o+(-0.83633430067)*x[0]+(-0.446378328981)*x[1]**o+(-0.278460992776)*x[1]
        ref[0,0,0,0]=o*(0.467597203998)*x_ref[0]**(o-1)+(-0.878331243959)
        ref[0,0,0,1]=o*(-0.971530784104)*x_ref[1]**(o-1)+(0.685854853102)
        ref[0,0,1,0]=o*(0.291345615954)*x_ref[0]**(o-1)+(-0.745469654319)
        ref[0,0,1,1]=o*(0.976621664002)*x_ref[1]**(o-1)+(-0.881452217847)
        ref[0,1,0,0]=o*(0.537843295475)*x_ref[0]**(o-1)+(0.489619951145)
        ref[0,1,0,1]=o*(0.77330251637)*x_ref[1]**(o-1)+(0.998031266089)
        ref[0,1,1,0]=o*(0.355984068681)*x_ref[0]**(o-1)+(-0.814720548776)
        ref[0,1,1,1]=o*(0.495564264626)*x_ref[1]**(o-1)+(0.525926194911)
        ref[1,0,0,0]=o*(0.0459062782507)*x_ref[0]**(o-1)+(0.745363380399)
        ref[1,0,0,1]=o*(0.254962338793)*x_ref[1]**(o-1)+(-0.818268107226)
        ref[1,0,1,0]=o*(0.806972777032)*x_ref[0]**(o-1)+(0.65759411882)
        ref[1,0,1,1]=o*(-0.714015350868)*x_ref[1]**(o-1)+(0.785611067194)
        ref[1,1,0,0]=o*(0.576206375389)*x_ref[0]**(o-1)+(-0.502513595266)
        ref[1,1,0,1]=o*(0.258287392463)*x_ref[1]**(o-1)+(0.0897418205816)
        ref[1,1,1,0]=o*(-0.854645709831)*x_ref[0]**(o-1)+(0.48910569315)
        ref[1,1,1,1]=o*(0.684503579045)*x_ref[1]**(o-1)+(0.156890859871)
        ref[2,0,0,0]=o*(-0.535650648427)*x_ref[0]**(o-1)+(-0.189186476574)
        ref[2,0,0,1]=o*(-0.62891575537)*x_ref[1]**(o-1)+(-0.37603690255)
        ref[2,0,1,0]=o*(-0.153001902814)*x_ref[0]**(o-1)+(0.028214773063)
        ref[2,0,1,1]=o*(-0.605102549169)*x_ref[1]**(o-1)+(-0.566991398262)
        ref[2,1,0,0]=o*(0.607976055886)*x_ref[0]**(o-1)+(-0.247395663109)
        ref[2,1,0,1]=o*(0.424340230656)*x_ref[1]**(o-1)+(0.210489427749)
        ref[2,1,1,0]=o*(-0.513543937157)*x_ref[0]**(o-1)+(0.345931529219)
        ref[2,1,1,1]=o*(0.893744279358)*x_ref[1]**(o-1)+(-0.519602594857)
        ref[3,0,0,0]=o*(-0.618812192169)*x_ref[0]**(o-1)+(-0.897898654184)
        ref[3,0,0,1]=o*(-0.717700928924)*x_ref[1]**(o-1)+(-0.21348885325)
        ref[3,0,1,0]=o*(-0.582829504396)*x_ref[0]**(o-1)+(-0.0726162868757)
        ref[3,0,1,1]=o*(0.366457797377)*x_ref[1]**(o-1)+(0.479006714526)
        ref[3,1,0,0]=o*(0.929143108169)*x_ref[0]**(o-1)+(-0.302254589362)
        ref[3,1,0,1]=o*(-0.518817476772)*x_ref[1]**(o-1)+(0.854860903894)
        ref[3,1,1,0]=o*(-0.815422381361)*x_ref[0]**(o-1)+(-0.183407261786)
        ref[3,1,1,1]=o*(0.841334455272)*x_ref[1]**(o-1)+(-0.560841747647)
        ref[4,0,0,0]=o*(0.746229089137)*x_ref[0]**(o-1)+(-0.00173525360161)
        ref[4,0,0,1]=o*(0.729473923491)*x_ref[1]**(o-1)+(-0.0152936558265)
        ref[4,0,1,0]=o*(-0.0474071267025)*x_ref[0]**(o-1)+(-0.380505263812)
        ref[4,0,1,1]=o*(0.166181839511)*x_ref[1]**(o-1)+(-0.421069915995)
        ref[4,1,0,0]=o*(-0.826801927705)*x_ref[0]**(o-1)+(0.704799677183)
        ref[4,1,0,1]=o*(-0.0346961982898)*x_ref[1]**(o-1)+(-0.401235214163)
        ref[4,1,1,0]=o*(-0.973646144788)*x_ref[0]**(o-1)+(0.469976655077)
        ref[4,1,1,1]=o*(-0.458846284633)*x_ref[1]**(o-1)+(0.818397008807)
        ref[5,0,0,0]=o*(0.155460716472)*x_ref[0]**(o-1)+(-0.509095443426)
        ref[5,0,0,1]=o*(-0.0942934981524)*x_ref[1]**(o-1)+(0.754087972651)
        ref[5,0,1,0]=o*(-0.584172835053)*x_ref[0]**(o-1)+(-0.904579020559)
        ref[5,0,1,1]=o*(0.156301832106)*x_ref[1]**(o-1)+(0.169995805721)
        ref[5,1,0,0]=o*(-0.424977437614)*x_ref[0]**(o-1)+(0.244566550647)
        ref[5,1,0,1]=o*(-0.474400097866)*x_ref[1]**(o-1)+(-0.315912223349)
        ref[5,1,1,0]=o*(0.764961378837)*x_ref[0]**(o-1)+(-0.83633430067)
        ref[5,1,1,1]=o*(-0.446378328981)*x_ref[1]**(o-1)+(-0.278460992776)
      else:
        arg[0,0,0]=(0.723756735151)*x[0]**o+(0.738121670547)*x[0]+(0.384835073242)*x[1]**o+(-0.997944909714)*x[1]+(0.271533052097)*x[2]**o+(-0.667680363953)*x[2]
        arg[0,0,1]=(-0.279804914835)*x[0]**o+(0.789671404386)*x[0]+(-0.823187173328)*x[1]**o+(-0.0126377581755)*x[1]+(-0.942836469998)*x[2]**o+(0.416417451133)*x[2]
        arg[0,1,0]=(-0.69035514237)*x[0]**o+(0.388349204037)*x[0]+(0.807201832597)*x[1]**o+(-0.969007115064)*x[1]+(0.280506744137)*x[2]**o+(0.228554540968)*x[2]
        arg[0,1,1]=(0.893542584763)*x[0]**o+(-0.755974692532)*x[0]+(0.675321004205)*x[1]**o+(0.670278291297)*x[1]+(0.92092687885)*x[2]**o+(-0.516288388724)*x[2]
        arg[1,0,0]=(0.503764409596)*x[0]**o+(-0.39410032918)*x[0]+(0.532408717712)*x[1]**o+(0.0658355614843)*x[1]+(-0.533534889451)*x[2]**o+(0.846333211477)*x[2]
        arg[1,0,1]=(0.520531780859)*x[0]**o+(0.869039672332)*x[0]+(-0.706342144586)*x[1]**o+(0.0665768341658)*x[1]+(-0.909079295867)*x[2]**o+(-0.34153327843)*x[2]
        arg[1,1,0]=(-0.873546169914)*x[0]**o+(-0.554907283387)*x[0]+(-0.0560665557101)*x[1]**o+(0.436703623389)*x[1]+(0.730437022736)*x[2]**o+(0.100904171105)*x[2]
        arg[1,1,1]=(0.845958886681)*x[0]**o+(0.376444128389)*x[0]+(-0.393744308499)*x[1]**o+(-0.0940537397734)*x[1]+(0.178796464778)*x[2]**o+(-0.584448595407)*x[2]
        arg[2,0,0]=(0.000704382305339)*x[0]**o+(-0.836800712787)*x[0]+(0.671931504433)*x[1]**o+(0.263280364406)*x[1]+(-0.746980015754)*x[2]**o+(-0.985058787575)*x[2]
        arg[2,0,1]=(-0.540690929008)*x[0]**o+(0.656899216804)*x[0]+(-0.608036845804)*x[1]**o+(0.224943400248)*x[1]+(-0.312449005326)*x[2]**o+(-0.621458231634)*x[2]
        arg[2,1,0]=(0.440432866893)*x[0]**o+(0.972046189647)*x[0]+(0.060785199375)*x[1]**o+(0.304756432986)*x[1]+(-0.473510049103)*x[2]**o+(0.3707166351)*x[2]
        arg[2,1,1]=(0.96344472567)*x[0]**o+(-0.153932665404)*x[0]+(-0.43646142206)*x[1]**o+(0.4838463484)*x[1]+(0.613286612579)*x[2]**o+(0.84521461472)*x[2]
        arg[3,0,0]=(0.65147393118)*x[0]**o+(-0.886665762467)*x[0]+(-0.266000665973)*x[1]**o+(0.897979405808)*x[1]+(0.699333158084)*x[2]**o+(-0.460865970247)*x[2]
        arg[3,0,1]=(0.870253308112)*x[0]**o+(-0.248736315721)*x[0]+(-0.816719773596)*x[1]**o+(-0.89378202899)*x[1]+(0.524350309915)*x[2]**o+(0.107325872954)*x[2]
        arg[3,1,0]=(-0.152250686624)*x[0]**o+(-0.89784066484)*x[0]+(-0.327207891694)*x[1]**o+(0.346548492907)*x[1]+(0.409288642845)*x[2]**o+(-0.627349664194)*x[2]
        arg[3,1,1]=(0.398337202036)*x[0]**o+(0.307156588584)*x[0]+(0.0567088869624)*x[1]**o+(-0.132313990308)*x[1]+(-0.361821356587)*x[2]**o+(0.913518325149)*x[2]
        arg[4,0,0]=(0.184289428296)*x[0]**o+(0.138095407277)*x[0]+(0.514405012603)*x[1]**o+(0.590757249119)*x[1]+(-0.984116206238)*x[2]**o+(-0.176561783123)*x[2]
        arg[4,0,1]=(-0.804189448075)*x[0]**o+(0.662750787102)*x[0]+(0.361634380444)*x[1]**o+(-0.682665313256)*x[1]+(-0.0738989964344)*x[2]**o+(0.8870747144)*x[2]
        arg[4,1,0]=(-0.28290153618)*x[0]**o+(-0.942107675992)*x[0]+(0.308140792703)*x[1]**o+(0.686659531002)*x[1]+(0.789553636322)*x[2]**o+(0.587377542884)*x[2]
        arg[4,1,1]=(0.6137979501)*x[0]**o+(-0.564031937362)*x[0]+(-0.116407590432)*x[1]**o+(-0.119100735459)*x[1]+(0.673631378916)*x[2]**o+(0.766413057635)*x[2]
        arg[5,0,0]=(-0.871242033478)*x[0]**o+(0.823859447959)*x[0]+(-0.0506075089356)*x[1]**o+(-0.901254358367)*x[1]+(0.936710991394)*x[2]**o+(0.328438496312)*x[2]
        arg[5,0,1]=(-0.768255700059)*x[0]**o+(0.199623934067)*x[0]+(-0.0715921959057)*x[1]**o+(-0.542435290562)*x[1]+(-0.278962068381)*x[2]**o+(0.784363143932)*x[2]
        arg[5,1,0]=(0.897130313615)*x[0]**o+(-0.519033315355)*x[0]+(0.223176381444)*x[1]**o+(0.495645921147)*x[1]+(-0.0957696173909)*x[2]**o+(-0.768307051074)*x[2]
        arg[5,1,1]=(-0.944161779454)*x[0]**o+(0.430097328631)*x[0]+(0.86626977715)*x[1]**o+(-0.675612908116)*x[1]+(0.506821683353)*x[2]**o+(0.386559021354)*x[2]
        ref[0,0,0,0]=o*(0.723756735151)*x_ref[0]**(o-1)+(0.738121670547)
        ref[0,0,0,1]=o*(0.384835073242)*x_ref[1]**(o-1)+(-0.997944909714)
        ref[0,0,0,2]=o*(0.271533052097)*x_ref[2]**(o-1)+(-0.667680363953)
        ref[0,0,1,0]=o*(-0.279804914835)*x_ref[0]**(o-1)+(0.789671404386)
        ref[0,0,1,1]=o*(-0.823187173328)*x_ref[1]**(o-1)+(-0.0126377581755)
        ref[0,0,1,2]=o*(-0.942836469998)*x_ref[2]**(o-1)+(0.416417451133)
        ref[0,1,0,0]=o*(-0.69035514237)*x_ref[0]**(o-1)+(0.388349204037)
        ref[0,1,0,1]=o*(0.807201832597)*x_ref[1]**(o-1)+(-0.969007115064)
        ref[0,1,0,2]=o*(0.280506744137)*x_ref[2]**(o-1)+(0.228554540968)
        ref[0,1,1,0]=o*(0.893542584763)*x_ref[0]**(o-1)+(-0.755974692532)
        ref[0,1,1,1]=o*(0.675321004205)*x_ref[1]**(o-1)+(0.670278291297)
        ref[0,1,1,2]=o*(0.92092687885)*x_ref[2]**(o-1)+(-0.516288388724)
        ref[1,0,0,0]=o*(0.503764409596)*x_ref[0]**(o-1)+(-0.39410032918)
        ref[1,0,0,1]=o*(0.532408717712)*x_ref[1]**(o-1)+(0.0658355614843)
        ref[1,0,0,2]=o*(-0.533534889451)*x_ref[2]**(o-1)+(0.846333211477)
        ref[1,0,1,0]=o*(0.520531780859)*x_ref[0]**(o-1)+(0.869039672332)
        ref[1,0,1,1]=o*(-0.706342144586)*x_ref[1]**(o-1)+(0.0665768341658)
        ref[1,0,1,2]=o*(-0.909079295867)*x_ref[2]**(o-1)+(-0.34153327843)
        ref[1,1,0,0]=o*(-0.873546169914)*x_ref[0]**(o-1)+(-0.554907283387)
        ref[1,1,0,1]=o*(-0.0560665557101)*x_ref[1]**(o-1)+(0.436703623389)
        ref[1,1,0,2]=o*(0.730437022736)*x_ref[2]**(o-1)+(0.100904171105)
        ref[1,1,1,0]=o*(0.845958886681)*x_ref[0]**(o-1)+(0.376444128389)
        ref[1,1,1,1]=o*(-0.393744308499)*x_ref[1]**(o-1)+(-0.0940537397734)
        ref[1,1,1,2]=o*(0.178796464778)*x_ref[2]**(o-1)+(-0.584448595407)
        ref[2,0,0,0]=o*(0.000704382305339)*x_ref[0]**(o-1)+(-0.836800712787)
        ref[2,0,0,1]=o*(0.671931504433)*x_ref[1]**(o-1)+(0.263280364406)
        ref[2,0,0,2]=o*(-0.746980015754)*x_ref[2]**(o-1)+(-0.985058787575)
        ref[2,0,1,0]=o*(-0.540690929008)*x_ref[0]**(o-1)+(0.656899216804)
        ref[2,0,1,1]=o*(-0.608036845804)*x_ref[1]**(o-1)+(0.224943400248)
        ref[2,0,1,2]=o*(-0.312449005326)*x_ref[2]**(o-1)+(-0.621458231634)
        ref[2,1,0,0]=o*(0.440432866893)*x_ref[0]**(o-1)+(0.972046189647)
        ref[2,1,0,1]=o*(0.060785199375)*x_ref[1]**(o-1)+(0.304756432986)
        ref[2,1,0,2]=o*(-0.473510049103)*x_ref[2]**(o-1)+(0.3707166351)
        ref[2,1,1,0]=o*(0.96344472567)*x_ref[0]**(o-1)+(-0.153932665404)
        ref[2,1,1,1]=o*(-0.43646142206)*x_ref[1]**(o-1)+(0.4838463484)
        ref[2,1,1,2]=o*(0.613286612579)*x_ref[2]**(o-1)+(0.84521461472)
        ref[3,0,0,0]=o*(0.65147393118)*x_ref[0]**(o-1)+(-0.886665762467)
        ref[3,0,0,1]=o*(-0.266000665973)*x_ref[1]**(o-1)+(0.897979405808)
        ref[3,0,0,2]=o*(0.699333158084)*x_ref[2]**(o-1)+(-0.460865970247)
        ref[3,0,1,0]=o*(0.870253308112)*x_ref[0]**(o-1)+(-0.248736315721)
        ref[3,0,1,1]=o*(-0.816719773596)*x_ref[1]**(o-1)+(-0.89378202899)
        ref[3,0,1,2]=o*(0.524350309915)*x_ref[2]**(o-1)+(0.107325872954)
        ref[3,1,0,0]=o*(-0.152250686624)*x_ref[0]**(o-1)+(-0.89784066484)
        ref[3,1,0,1]=o*(-0.327207891694)*x_ref[1]**(o-1)+(0.346548492907)
        ref[3,1,0,2]=o*(0.409288642845)*x_ref[2]**(o-1)+(-0.627349664194)
        ref[3,1,1,0]=o*(0.398337202036)*x_ref[0]**(o-1)+(0.307156588584)
        ref[3,1,1,1]=o*(0.0567088869624)*x_ref[1]**(o-1)+(-0.132313990308)
        ref[3,1,1,2]=o*(-0.361821356587)*x_ref[2]**(o-1)+(0.913518325149)
        ref[4,0,0,0]=o*(0.184289428296)*x_ref[0]**(o-1)+(0.138095407277)
        ref[4,0,0,1]=o*(0.514405012603)*x_ref[1]**(o-1)+(0.590757249119)
        ref[4,0,0,2]=o*(-0.984116206238)*x_ref[2]**(o-1)+(-0.176561783123)
        ref[4,0,1,0]=o*(-0.804189448075)*x_ref[0]**(o-1)+(0.662750787102)
        ref[4,0,1,1]=o*(0.361634380444)*x_ref[1]**(o-1)+(-0.682665313256)
        ref[4,0,1,2]=o*(-0.0738989964344)*x_ref[2]**(o-1)+(0.8870747144)
        ref[4,1,0,0]=o*(-0.28290153618)*x_ref[0]**(o-1)+(-0.942107675992)
        ref[4,1,0,1]=o*(0.308140792703)*x_ref[1]**(o-1)+(0.686659531002)
        ref[4,1,0,2]=o*(0.789553636322)*x_ref[2]**(o-1)+(0.587377542884)
        ref[4,1,1,0]=o*(0.6137979501)*x_ref[0]**(o-1)+(-0.564031937362)
        ref[4,1,1,1]=o*(-0.116407590432)*x_ref[1]**(o-1)+(-0.119100735459)
        ref[4,1,1,2]=o*(0.673631378916)*x_ref[2]**(o-1)+(0.766413057635)
        ref[5,0,0,0]=o*(-0.871242033478)*x_ref[0]**(o-1)+(0.823859447959)
        ref[5,0,0,1]=o*(-0.0506075089356)*x_ref[1]**(o-1)+(-0.901254358367)
        ref[5,0,0,2]=o*(0.936710991394)*x_ref[2]**(o-1)+(0.328438496312)
        ref[5,0,1,0]=o*(-0.768255700059)*x_ref[0]**(o-1)+(0.199623934067)
        ref[5,0,1,1]=o*(-0.0715921959057)*x_ref[1]**(o-1)+(-0.542435290562)
        ref[5,0,1,2]=o*(-0.278962068381)*x_ref[2]**(o-1)+(0.784363143932)
        ref[5,1,0,0]=o*(0.897130313615)*x_ref[0]**(o-1)+(-0.519033315355)
        ref[5,1,0,1]=o*(0.223176381444)*x_ref[1]**(o-1)+(0.495645921147)
        ref[5,1,0,2]=o*(-0.0957696173909)*x_ref[2]**(o-1)+(-0.768307051074)
        ref[5,1,1,0]=o*(-0.944161779454)*x_ref[0]**(o-1)+(0.430097328631)
        ref[5,1,1,1]=o*(0.86626977715)*x_ref[1]**(o-1)+(-0.675612908116)
        ref[5,1,1,2]=o*(0.506821683353)*x_ref[2]**(o-1)+(0.386559021354)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnContactZero_fromData_Solution_rank0(self):
      """
      tests gradient for rank 0 Data on the FunctionOnContactZero

      assumptions: Solution(self.domain) exists
                   self.domain supports gradient on FunctionOnContactZero
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=FunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=Solution(self.domain)
      x=w.getX()
      arg=Data(0,(),w)
      ref=Data(0,()+(dim,),w_ref)
      if dim==2:
        arg=(0.54415545025)*x[0]**o+(0.979947366774)*x[0]+(-0.405934730304)*x[1]**o+(0.424994268397)*x[1]
        ref[0]=o*(0.54415545025)*x_ref[0]**(o-1)+(0.979947366774)
        ref[1]=o*(-0.405934730304)*x_ref[1]**(o-1)+(0.424994268397)
      else:
        arg=(-0.0240792232301)*x[0]**o+(0.33156704088)*x[0]+(-0.051539264252)*x[1]**o+(-0.886370693155)*x[1]+(-0.954475798211)*x[2]**o+(0.238073928589)*x[2]
        ref[0]=o*(-0.0240792232301)*x_ref[0]**(o-1)+(0.33156704088)
        ref[1]=o*(-0.051539264252)*x_ref[1]**(o-1)+(-0.886370693155)
        ref[2]=o*(-0.954475798211)*x_ref[2]**(o-1)+(0.238073928589)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),()+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnContactZero_fromData_Solution_rank1(self):
      """
      tests gradient for rank 1 Data on the FunctionOnContactZero

      assumptions: Solution(self.domain) exists
                   self.domain supports gradient on FunctionOnContactZero
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=FunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=Solution(self.domain)
      x=w.getX()
      arg=Data(0,(2,),w)
      ref=Data(0,(2,)+(dim,),w_ref)
      if dim==2:
        arg[0]=(-0.526471606132)*x[0]**o+(-0.355534153967)*x[0]+(-0.792258102571)*x[1]**o+(0.386283553167)*x[1]
        arg[1]=(-0.892924864905)*x[0]**o+(0.19218757952)*x[0]+(0.00248964495987)*x[1]**o+(-0.687070938997)*x[1]
        ref[0,0]=o*(-0.526471606132)*x_ref[0]**(o-1)+(-0.355534153967)
        ref[0,1]=o*(-0.792258102571)*x_ref[1]**(o-1)+(0.386283553167)
        ref[1,0]=o*(-0.892924864905)*x_ref[0]**(o-1)+(0.19218757952)
        ref[1,1]=o*(0.00248964495987)*x_ref[1]**(o-1)+(-0.687070938997)
      else:
        arg[0]=(-0.254013984725)*x[0]**o+(0.126174108068)*x[0]+(-0.967653739084)*x[1]**o+(-0.524294999327)*x[1]+(0.374454913375)*x[2]**o+(0.783768839592)*x[2]
        arg[1]=(0.862328996944)*x[0]**o+(-0.0100272707295)*x[0]+(0.163524617753)*x[1]**o+(-0.19251370258)*x[1]+(0.889557068195)*x[2]**o+(0.573248942406)*x[2]
        ref[0,0]=o*(-0.254013984725)*x_ref[0]**(o-1)+(0.126174108068)
        ref[0,1]=o*(-0.967653739084)*x_ref[1]**(o-1)+(-0.524294999327)
        ref[0,2]=o*(0.374454913375)*x_ref[2]**(o-1)+(0.783768839592)
        ref[1,0]=o*(0.862328996944)*x_ref[0]**(o-1)+(-0.0100272707295)
        ref[1,1]=o*(0.163524617753)*x_ref[1]**(o-1)+(-0.19251370258)
        ref[1,2]=o*(0.889557068195)*x_ref[2]**(o-1)+(0.573248942406)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnContactZero_fromData_Solution_rank2(self):
      """
      tests gradient for rank 2 Data on the FunctionOnContactZero

      assumptions: Solution(self.domain) exists
                   self.domain supports gradient on FunctionOnContactZero
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=FunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=Solution(self.domain)
      x=w.getX()
      arg=Data(0,(4, 5),w)
      ref=Data(0,(4, 5)+(dim,),w_ref)
      if dim==2:
        arg[0,0]=(0.712410724071)*x[0]**o+(0.642832165006)*x[0]+(0.409613677638)*x[1]**o+(-0.940707375829)*x[1]
        arg[0,1]=(-0.192677448978)*x[0]**o+(0.928105399392)*x[0]+(-0.0976390111113)*x[1]**o+(0.152541825282)*x[1]
        arg[0,2]=(-0.555865920622)*x[0]**o+(0.187618737934)*x[0]+(-0.400398722616)*x[1]**o+(0.132335647294)*x[1]
        arg[0,3]=(-0.0984345355899)*x[0]**o+(-0.136251593387)*x[0]+(0.820900167194)*x[1]**o+(-0.54323976155)*x[1]
        arg[0,4]=(-0.718763327727)*x[0]**o+(-0.993678837401)*x[0]+(0.0282625285716)*x[1]**o+(0.480464124636)*x[1]
        arg[1,0]=(-0.1635372419)*x[0]**o+(0.97173720053)*x[0]+(0.0423190406144)*x[1]**o+(-0.607779321237)*x[1]
        arg[1,1]=(-0.59220466746)*x[0]**o+(-0.329625880847)*x[0]+(0.176412343254)*x[1]**o+(0.955769019385)*x[1]
        arg[1,2]=(-0.516421195901)*x[0]**o+(0.147037193899)*x[0]+(0.247835053631)*x[1]**o+(-0.877986653535)*x[1]
        arg[1,3]=(-0.317266388999)*x[0]**o+(0.864393749347)*x[0]+(-0.957863705756)*x[1]**o+(-0.884975429798)*x[1]
        arg[1,4]=(0.540121554391)*x[0]**o+(0.808050078272)*x[0]+(0.703557587067)*x[1]**o+(-0.0976121077766)*x[1]
        arg[2,0]=(0.23658022222)*x[0]**o+(0.122038637852)*x[0]+(0.411570045798)*x[1]**o+(-0.434531687414)*x[1]
        arg[2,1]=(-0.378365306249)*x[0]**o+(0.511747532394)*x[0]+(0.586326813286)*x[1]**o+(0.699918966936)*x[1]
        arg[2,2]=(0.445092669694)*x[0]**o+(0.637517787944)*x[0]+(-0.668779388847)*x[1]**o+(0.487635262236)*x[1]
        arg[2,3]=(-0.232265851556)*x[0]**o+(0.391449220433)*x[0]+(0.647177607766)*x[1]**o+(0.207062996634)*x[1]
        arg[2,4]=(0.338412227828)*x[0]**o+(0.0205801366652)*x[0]+(-0.492628796478)*x[1]**o+(-0.683459852092)*x[1]
        arg[3,0]=(0.584296838468)*x[0]**o+(-0.598793253755)*x[0]+(0.707319426212)*x[1]**o+(0.678834769735)*x[1]
        arg[3,1]=(0.801295300134)*x[0]**o+(0.0494871119593)*x[0]+(0.378929822492)*x[1]**o+(-0.536309789421)*x[1]
        arg[3,2]=(-0.761535984131)*x[0]**o+(0.121584094596)*x[0]+(-0.00655849155175)*x[1]**o+(0.321872124523)*x[1]
        arg[3,3]=(0.384633290815)*x[0]**o+(-0.710356674518)*x[0]+(0.962059942069)*x[1]**o+(-0.593059919585)*x[1]
        arg[3,4]=(-0.608988807286)*x[0]**o+(-0.0776468065145)*x[0]+(-0.701400144867)*x[1]**o+(0.643928611178)*x[1]
        ref[0,0,0]=o*(0.712410724071)*x_ref[0]**(o-1)+(0.642832165006)
        ref[0,0,1]=o*(0.409613677638)*x_ref[1]**(o-1)+(-0.940707375829)
        ref[0,1,0]=o*(-0.192677448978)*x_ref[0]**(o-1)+(0.928105399392)
        ref[0,1,1]=o*(-0.0976390111113)*x_ref[1]**(o-1)+(0.152541825282)
        ref[0,2,0]=o*(-0.555865920622)*x_ref[0]**(o-1)+(0.187618737934)
        ref[0,2,1]=o*(-0.400398722616)*x_ref[1]**(o-1)+(0.132335647294)
        ref[0,3,0]=o*(-0.0984345355899)*x_ref[0]**(o-1)+(-0.136251593387)
        ref[0,3,1]=o*(0.820900167194)*x_ref[1]**(o-1)+(-0.54323976155)
        ref[0,4,0]=o*(-0.718763327727)*x_ref[0]**(o-1)+(-0.993678837401)
        ref[0,4,1]=o*(0.0282625285716)*x_ref[1]**(o-1)+(0.480464124636)
        ref[1,0,0]=o*(-0.1635372419)*x_ref[0]**(o-1)+(0.97173720053)
        ref[1,0,1]=o*(0.0423190406144)*x_ref[1]**(o-1)+(-0.607779321237)
        ref[1,1,0]=o*(-0.59220466746)*x_ref[0]**(o-1)+(-0.329625880847)
        ref[1,1,1]=o*(0.176412343254)*x_ref[1]**(o-1)+(0.955769019385)
        ref[1,2,0]=o*(-0.516421195901)*x_ref[0]**(o-1)+(0.147037193899)
        ref[1,2,1]=o*(0.247835053631)*x_ref[1]**(o-1)+(-0.877986653535)
        ref[1,3,0]=o*(-0.317266388999)*x_ref[0]**(o-1)+(0.864393749347)
        ref[1,3,1]=o*(-0.957863705756)*x_ref[1]**(o-1)+(-0.884975429798)
        ref[1,4,0]=o*(0.540121554391)*x_ref[0]**(o-1)+(0.808050078272)
        ref[1,4,1]=o*(0.703557587067)*x_ref[1]**(o-1)+(-0.0976121077766)
        ref[2,0,0]=o*(0.23658022222)*x_ref[0]**(o-1)+(0.122038637852)
        ref[2,0,1]=o*(0.411570045798)*x_ref[1]**(o-1)+(-0.434531687414)
        ref[2,1,0]=o*(-0.378365306249)*x_ref[0]**(o-1)+(0.511747532394)
        ref[2,1,1]=o*(0.586326813286)*x_ref[1]**(o-1)+(0.699918966936)
        ref[2,2,0]=o*(0.445092669694)*x_ref[0]**(o-1)+(0.637517787944)
        ref[2,2,1]=o*(-0.668779388847)*x_ref[1]**(o-1)+(0.487635262236)
        ref[2,3,0]=o*(-0.232265851556)*x_ref[0]**(o-1)+(0.391449220433)
        ref[2,3,1]=o*(0.647177607766)*x_ref[1]**(o-1)+(0.207062996634)
        ref[2,4,0]=o*(0.338412227828)*x_ref[0]**(o-1)+(0.0205801366652)
        ref[2,4,1]=o*(-0.492628796478)*x_ref[1]**(o-1)+(-0.683459852092)
        ref[3,0,0]=o*(0.584296838468)*x_ref[0]**(o-1)+(-0.598793253755)
        ref[3,0,1]=o*(0.707319426212)*x_ref[1]**(o-1)+(0.678834769735)
        ref[3,1,0]=o*(0.801295300134)*x_ref[0]**(o-1)+(0.0494871119593)
        ref[3,1,1]=o*(0.378929822492)*x_ref[1]**(o-1)+(-0.536309789421)
        ref[3,2,0]=o*(-0.761535984131)*x_ref[0]**(o-1)+(0.121584094596)
        ref[3,2,1]=o*(-0.00655849155175)*x_ref[1]**(o-1)+(0.321872124523)
        ref[3,3,0]=o*(0.384633290815)*x_ref[0]**(o-1)+(-0.710356674518)
        ref[3,3,1]=o*(0.962059942069)*x_ref[1]**(o-1)+(-0.593059919585)
        ref[3,4,0]=o*(-0.608988807286)*x_ref[0]**(o-1)+(-0.0776468065145)
        ref[3,4,1]=o*(-0.701400144867)*x_ref[1]**(o-1)+(0.643928611178)
      else:
        arg[0,0]=(-0.514546772198)*x[0]**o+(0.679859064768)*x[0]+(-0.494037106077)*x[1]**o+(-0.0598645161488)*x[1]+(-0.543474311879)*x[2]**o+(0.597237276677)*x[2]
        arg[0,1]=(0.0826513727579)*x[0]**o+(0.870535937411)*x[0]+(-0.194047768119)*x[1]**o+(-0.111616761775)*x[1]+(0.697073558803)*x[2]**o+(-0.170433075843)*x[2]
        arg[0,2]=(0.608560200938)*x[0]**o+(-0.28991661304)*x[0]+(0.929121366615)*x[1]**o+(0.445280468492)*x[1]+(-0.0671026162019)*x[2]**o+(-0.835086989851)*x[2]
        arg[0,3]=(-0.256476478337)*x[0]**o+(-0.857686365148)*x[0]+(-0.309306419219)*x[1]**o+(0.750579112592)*x[1]+(0.758254577714)*x[2]**o+(0.108972886739)*x[2]
        arg[0,4]=(0.189540467853)*x[0]**o+(-0.639906129587)*x[0]+(0.1086564431)*x[1]**o+(-0.254754163159)*x[1]+(-0.595415956315)*x[2]**o+(0.416643698623)*x[2]
        arg[1,0]=(0.649640741159)*x[0]**o+(-0.715604744977)*x[0]+(0.144698127223)*x[1]**o+(0.84058008507)*x[1]+(0.00226738664623)*x[2]**o+(0.143092105366)*x[2]
        arg[1,1]=(0.30428097785)*x[0]**o+(0.172630542192)*x[0]+(0.645118113075)*x[1]**o+(-0.394468022223)*x[1]+(0.731670923192)*x[2]**o+(-0.676021495379)*x[2]
        arg[1,2]=(0.56459927889)*x[0]**o+(-0.624980053566)*x[0]+(-0.524836958708)*x[1]**o+(0.282862320474)*x[1]+(0.99070455422)*x[2]**o+(0.000265746399286)*x[2]
        arg[1,3]=(-0.251929813217)*x[0]**o+(0.00685246758491)*x[0]+(-0.252595929082)*x[1]**o+(-0.997558334417)*x[1]+(-0.431329146194)*x[2]**o+(0.0685298495116)*x[2]
        arg[1,4]=(-0.850398225165)*x[0]**o+(-0.752363025861)*x[0]+(-0.669448553729)*x[1]**o+(0.809247179374)*x[1]+(-0.927467807251)*x[2]**o+(-0.498094160268)*x[2]
        arg[2,0]=(0.541736859663)*x[0]**o+(-0.651273876855)*x[0]+(-0.679670779769)*x[1]**o+(0.669564679419)*x[1]+(-0.825048237017)*x[2]**o+(-0.247744537755)*x[2]
        arg[2,1]=(0.909016713138)*x[0]**o+(-0.794124179572)*x[0]+(0.887294650854)*x[1]**o+(-0.198933351435)*x[1]+(-0.819671062456)*x[2]**o+(0.287455634612)*x[2]
        arg[2,2]=(-0.469337238665)*x[0]**o+(0.787828984218)*x[0]+(0.916042829702)*x[1]**o+(-0.475983675757)*x[1]+(-0.350660319046)*x[2]**o+(0.944222119413)*x[2]
        arg[2,3]=(-0.194629035155)*x[0]**o+(0.452058614199)*x[0]+(-0.565150768916)*x[1]**o+(-0.967642852138)*x[1]+(-0.345332973443)*x[2]**o+(-0.238359110833)*x[2]
        arg[2,4]=(-0.744197369952)*x[0]**o+(-0.0161450929106)*x[0]+(0.946555120156)*x[1]**o+(-0.336314723492)*x[1]+(0.212936909808)*x[2]**o+(-0.900582293569)*x[2]
        arg[3,0]=(0.90736518985)*x[0]**o+(-0.866096443075)*x[0]+(0.440227521532)*x[1]**o+(-0.545983384676)*x[1]+(0.433167375756)*x[2]**o+(-0.913060961228)*x[2]
        arg[3,1]=(0.33547032327)*x[0]**o+(0.766388218896)*x[0]+(-0.386141806114)*x[1]**o+(0.28471049668)*x[1]+(0.389347155974)*x[2]**o+(0.211663215285)*x[2]
        arg[3,2]=(0.193757801099)*x[0]**o+(0.0145439587225)*x[0]+(0.575506295918)*x[1]**o+(-0.678317336021)*x[1]+(0.64603157052)*x[2]**o+(-0.876667949279)*x[2]
        arg[3,3]=(-0.0518002857411)*x[0]**o+(-0.540021971724)*x[0]+(-0.490275636747)*x[1]**o+(-0.849147647677)*x[1]+(-0.0132783508877)*x[2]**o+(0.0859860768541)*x[2]
        arg[3,4]=(-0.332675003425)*x[0]**o+(-0.757986125506)*x[0]+(-0.487001539705)*x[1]**o+(0.898881577697)*x[1]+(0.56557767007)*x[2]**o+(0.181594113977)*x[2]
        ref[0,0,0]=o*(-0.514546772198)*x_ref[0]**(o-1)+(0.679859064768)
        ref[0,0,1]=o*(-0.494037106077)*x_ref[1]**(o-1)+(-0.0598645161488)
        ref[0,0,2]=o*(-0.543474311879)*x_ref[2]**(o-1)+(0.597237276677)
        ref[0,1,0]=o*(0.0826513727579)*x_ref[0]**(o-1)+(0.870535937411)
        ref[0,1,1]=o*(-0.194047768119)*x_ref[1]**(o-1)+(-0.111616761775)
        ref[0,1,2]=o*(0.697073558803)*x_ref[2]**(o-1)+(-0.170433075843)
        ref[0,2,0]=o*(0.608560200938)*x_ref[0]**(o-1)+(-0.28991661304)
        ref[0,2,1]=o*(0.929121366615)*x_ref[1]**(o-1)+(0.445280468492)
        ref[0,2,2]=o*(-0.0671026162019)*x_ref[2]**(o-1)+(-0.835086989851)
        ref[0,3,0]=o*(-0.256476478337)*x_ref[0]**(o-1)+(-0.857686365148)
        ref[0,3,1]=o*(-0.309306419219)*x_ref[1]**(o-1)+(0.750579112592)
        ref[0,3,2]=o*(0.758254577714)*x_ref[2]**(o-1)+(0.108972886739)
        ref[0,4,0]=o*(0.189540467853)*x_ref[0]**(o-1)+(-0.639906129587)
        ref[0,4,1]=o*(0.1086564431)*x_ref[1]**(o-1)+(-0.254754163159)
        ref[0,4,2]=o*(-0.595415956315)*x_ref[2]**(o-1)+(0.416643698623)
        ref[1,0,0]=o*(0.649640741159)*x_ref[0]**(o-1)+(-0.715604744977)
        ref[1,0,1]=o*(0.144698127223)*x_ref[1]**(o-1)+(0.84058008507)
        ref[1,0,2]=o*(0.00226738664623)*x_ref[2]**(o-1)+(0.143092105366)
        ref[1,1,0]=o*(0.30428097785)*x_ref[0]**(o-1)+(0.172630542192)
        ref[1,1,1]=o*(0.645118113075)*x_ref[1]**(o-1)+(-0.394468022223)
        ref[1,1,2]=o*(0.731670923192)*x_ref[2]**(o-1)+(-0.676021495379)
        ref[1,2,0]=o*(0.56459927889)*x_ref[0]**(o-1)+(-0.624980053566)
        ref[1,2,1]=o*(-0.524836958708)*x_ref[1]**(o-1)+(0.282862320474)
        ref[1,2,2]=o*(0.99070455422)*x_ref[2]**(o-1)+(0.000265746399286)
        ref[1,3,0]=o*(-0.251929813217)*x_ref[0]**(o-1)+(0.00685246758491)
        ref[1,3,1]=o*(-0.252595929082)*x_ref[1]**(o-1)+(-0.997558334417)
        ref[1,3,2]=o*(-0.431329146194)*x_ref[2]**(o-1)+(0.0685298495116)
        ref[1,4,0]=o*(-0.850398225165)*x_ref[0]**(o-1)+(-0.752363025861)
        ref[1,4,1]=o*(-0.669448553729)*x_ref[1]**(o-1)+(0.809247179374)
        ref[1,4,2]=o*(-0.927467807251)*x_ref[2]**(o-1)+(-0.498094160268)
        ref[2,0,0]=o*(0.541736859663)*x_ref[0]**(o-1)+(-0.651273876855)
        ref[2,0,1]=o*(-0.679670779769)*x_ref[1]**(o-1)+(0.669564679419)
        ref[2,0,2]=o*(-0.825048237017)*x_ref[2]**(o-1)+(-0.247744537755)
        ref[2,1,0]=o*(0.909016713138)*x_ref[0]**(o-1)+(-0.794124179572)
        ref[2,1,1]=o*(0.887294650854)*x_ref[1]**(o-1)+(-0.198933351435)
        ref[2,1,2]=o*(-0.819671062456)*x_ref[2]**(o-1)+(0.287455634612)
        ref[2,2,0]=o*(-0.469337238665)*x_ref[0]**(o-1)+(0.787828984218)
        ref[2,2,1]=o*(0.916042829702)*x_ref[1]**(o-1)+(-0.475983675757)
        ref[2,2,2]=o*(-0.350660319046)*x_ref[2]**(o-1)+(0.944222119413)
        ref[2,3,0]=o*(-0.194629035155)*x_ref[0]**(o-1)+(0.452058614199)
        ref[2,3,1]=o*(-0.565150768916)*x_ref[1]**(o-1)+(-0.967642852138)
        ref[2,3,2]=o*(-0.345332973443)*x_ref[2]**(o-1)+(-0.238359110833)
        ref[2,4,0]=o*(-0.744197369952)*x_ref[0]**(o-1)+(-0.0161450929106)
        ref[2,4,1]=o*(0.946555120156)*x_ref[1]**(o-1)+(-0.336314723492)
        ref[2,4,2]=o*(0.212936909808)*x_ref[2]**(o-1)+(-0.900582293569)
        ref[3,0,0]=o*(0.90736518985)*x_ref[0]**(o-1)+(-0.866096443075)
        ref[3,0,1]=o*(0.440227521532)*x_ref[1]**(o-1)+(-0.545983384676)
        ref[3,0,2]=o*(0.433167375756)*x_ref[2]**(o-1)+(-0.913060961228)
        ref[3,1,0]=o*(0.33547032327)*x_ref[0]**(o-1)+(0.766388218896)
        ref[3,1,1]=o*(-0.386141806114)*x_ref[1]**(o-1)+(0.28471049668)
        ref[3,1,2]=o*(0.389347155974)*x_ref[2]**(o-1)+(0.211663215285)
        ref[3,2,0]=o*(0.193757801099)*x_ref[0]**(o-1)+(0.0145439587225)
        ref[3,2,1]=o*(0.575506295918)*x_ref[1]**(o-1)+(-0.678317336021)
        ref[3,2,2]=o*(0.64603157052)*x_ref[2]**(o-1)+(-0.876667949279)
        ref[3,3,0]=o*(-0.0518002857411)*x_ref[0]**(o-1)+(-0.540021971724)
        ref[3,3,1]=o*(-0.490275636747)*x_ref[1]**(o-1)+(-0.849147647677)
        ref[3,3,2]=o*(-0.0132783508877)*x_ref[2]**(o-1)+(0.0859860768541)
        ref[3,4,0]=o*(-0.332675003425)*x_ref[0]**(o-1)+(-0.757986125506)
        ref[3,4,1]=o*(-0.487001539705)*x_ref[1]**(o-1)+(0.898881577697)
        ref[3,4,2]=o*(0.56557767007)*x_ref[2]**(o-1)+(0.181594113977)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnContactZero_fromData_Solution_rank3(self):
      """
      tests gradient for rank 3 Data on the FunctionOnContactZero

      assumptions: Solution(self.domain) exists
                   self.domain supports gradient on FunctionOnContactZero
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=FunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=Solution(self.domain)
      x=w.getX()
      arg=Data(0,(6, 2, 2),w)
      ref=Data(0,(6, 2, 2)+(dim,),w_ref)
      if dim==2:
        arg[0,0,0]=(0.568278554396)*x[0]**o+(0.714635312506)*x[0]+(-0.121000061881)*x[1]**o+(0.650923087629)*x[1]
        arg[0,0,1]=(0.610070747198)*x[0]**o+(-0.17228586298)*x[0]+(-0.763207252556)*x[1]**o+(-0.417620736844)*x[1]
        arg[0,1,0]=(0.953437717333)*x[0]**o+(-0.877858891638)*x[0]+(-0.629855255168)*x[1]**o+(0.138168708132)*x[1]
        arg[0,1,1]=(-0.676346259275)*x[0]**o+(0.810400719592)*x[0]+(0.252517037374)*x[1]**o+(-0.0253025825974)*x[1]
        arg[1,0,0]=(0.0354009852553)*x[0]**o+(-0.930486981217)*x[0]+(0.515533244848)*x[1]**o+(0.39357313927)*x[1]
        arg[1,0,1]=(4.954730054e-05)*x[0]**o+(0.902841279458)*x[0]+(0.0974175050415)*x[1]**o+(-0.283224733511)*x[1]
        arg[1,1,0]=(-0.3695113121)*x[0]**o+(-0.425976895152)*x[0]+(-0.752863101988)*x[1]**o+(-0.135026977845)*x[1]
        arg[1,1,1]=(-0.627750038208)*x[0]**o+(-0.682825202306)*x[0]+(0.598327522753)*x[1]**o+(0.0402698525348)*x[1]
        arg[2,0,0]=(0.95982907811)*x[0]**o+(-0.786158711751)*x[0]+(0.6974717418)*x[1]**o+(-0.548248895713)*x[1]
        arg[2,0,1]=(-0.21063630362)*x[0]**o+(-0.979628903483)*x[0]+(0.514851452559)*x[1]**o+(-0.294218784425)*x[1]
        arg[2,1,0]=(-0.446140926476)*x[0]**o+(0.658918134389)*x[0]+(-0.166087456007)*x[1]**o+(0.328044805625)*x[1]
        arg[2,1,1]=(0.937161634589)*x[0]**o+(0.594322457074)*x[0]+(0.992336676032)*x[1]**o+(-0.499637100315)*x[1]
        arg[3,0,0]=(0.767677974163)*x[0]**o+(-0.820615663298)*x[0]+(0.558185245925)*x[1]**o+(-0.763525476816)*x[1]
        arg[3,0,1]=(-0.866581629552)*x[0]**o+(0.589993777037)*x[0]+(-0.0704817160146)*x[1]**o+(-0.897469280048)*x[1]
        arg[3,1,0]=(-0.290118027748)*x[0]**o+(0.211790364383)*x[0]+(-0.0688758465892)*x[1]**o+(0.777490292219)*x[1]
        arg[3,1,1]=(-0.969418722549)*x[0]**o+(-0.46884683812)*x[0]+(0.826696594862)*x[1]**o+(-0.926802811507)*x[1]
        arg[4,0,0]=(-0.230285931083)*x[0]**o+(0.905695021426)*x[0]+(-0.581906633624)*x[1]**o+(-0.69277147014)*x[1]
        arg[4,0,1]=(-0.251350536276)*x[0]**o+(0.352877501605)*x[0]+(0.290432460788)*x[1]**o+(0.614218150117)*x[1]
        arg[4,1,0]=(-0.475014635407)*x[0]**o+(0.86786497963)*x[0]+(-0.763349511499)*x[1]**o+(0.817847286727)*x[1]
        arg[4,1,1]=(0.0079711463132)*x[0]**o+(-0.20685339926)*x[0]+(0.377467915936)*x[1]**o+(-0.209268733968)*x[1]
        arg[5,0,0]=(0.795790630791)*x[0]**o+(0.0661201279192)*x[0]+(0.932665258262)*x[1]**o+(-0.4785884914)*x[1]
        arg[5,0,1]=(0.929422646068)*x[0]**o+(0.775378282324)*x[0]+(0.297482039582)*x[1]**o+(-0.700872789842)*x[1]
        arg[5,1,0]=(0.678688297204)*x[0]**o+(0.365975847321)*x[0]+(-0.565261107289)*x[1]**o+(0.0317556604619)*x[1]
        arg[5,1,1]=(-0.0231297032408)*x[0]**o+(-0.985865541949)*x[0]+(0.733821736669)*x[1]**o+(0.603255951212)*x[1]
        ref[0,0,0,0]=o*(0.568278554396)*x_ref[0]**(o-1)+(0.714635312506)
        ref[0,0,0,1]=o*(-0.121000061881)*x_ref[1]**(o-1)+(0.650923087629)
        ref[0,0,1,0]=o*(0.610070747198)*x_ref[0]**(o-1)+(-0.17228586298)
        ref[0,0,1,1]=o*(-0.763207252556)*x_ref[1]**(o-1)+(-0.417620736844)
        ref[0,1,0,0]=o*(0.953437717333)*x_ref[0]**(o-1)+(-0.877858891638)
        ref[0,1,0,1]=o*(-0.629855255168)*x_ref[1]**(o-1)+(0.138168708132)
        ref[0,1,1,0]=o*(-0.676346259275)*x_ref[0]**(o-1)+(0.810400719592)
        ref[0,1,1,1]=o*(0.252517037374)*x_ref[1]**(o-1)+(-0.0253025825974)
        ref[1,0,0,0]=o*(0.0354009852553)*x_ref[0]**(o-1)+(-0.930486981217)
        ref[1,0,0,1]=o*(0.515533244848)*x_ref[1]**(o-1)+(0.39357313927)
        ref[1,0,1,0]=o*(4.954730054e-05)*x_ref[0]**(o-1)+(0.902841279458)
        ref[1,0,1,1]=o*(0.0974175050415)*x_ref[1]**(o-1)+(-0.283224733511)
        ref[1,1,0,0]=o*(-0.3695113121)*x_ref[0]**(o-1)+(-0.425976895152)
        ref[1,1,0,1]=o*(-0.752863101988)*x_ref[1]**(o-1)+(-0.135026977845)
        ref[1,1,1,0]=o*(-0.627750038208)*x_ref[0]**(o-1)+(-0.682825202306)
        ref[1,1,1,1]=o*(0.598327522753)*x_ref[1]**(o-1)+(0.0402698525348)
        ref[2,0,0,0]=o*(0.95982907811)*x_ref[0]**(o-1)+(-0.786158711751)
        ref[2,0,0,1]=o*(0.6974717418)*x_ref[1]**(o-1)+(-0.548248895713)
        ref[2,0,1,0]=o*(-0.21063630362)*x_ref[0]**(o-1)+(-0.979628903483)
        ref[2,0,1,1]=o*(0.514851452559)*x_ref[1]**(o-1)+(-0.294218784425)
        ref[2,1,0,0]=o*(-0.446140926476)*x_ref[0]**(o-1)+(0.658918134389)
        ref[2,1,0,1]=o*(-0.166087456007)*x_ref[1]**(o-1)+(0.328044805625)
        ref[2,1,1,0]=o*(0.937161634589)*x_ref[0]**(o-1)+(0.594322457074)
        ref[2,1,1,1]=o*(0.992336676032)*x_ref[1]**(o-1)+(-0.499637100315)
        ref[3,0,0,0]=o*(0.767677974163)*x_ref[0]**(o-1)+(-0.820615663298)
        ref[3,0,0,1]=o*(0.558185245925)*x_ref[1]**(o-1)+(-0.763525476816)
        ref[3,0,1,0]=o*(-0.866581629552)*x_ref[0]**(o-1)+(0.589993777037)
        ref[3,0,1,1]=o*(-0.0704817160146)*x_ref[1]**(o-1)+(-0.897469280048)
        ref[3,1,0,0]=o*(-0.290118027748)*x_ref[0]**(o-1)+(0.211790364383)
        ref[3,1,0,1]=o*(-0.0688758465892)*x_ref[1]**(o-1)+(0.777490292219)
        ref[3,1,1,0]=o*(-0.969418722549)*x_ref[0]**(o-1)+(-0.46884683812)
        ref[3,1,1,1]=o*(0.826696594862)*x_ref[1]**(o-1)+(-0.926802811507)
        ref[4,0,0,0]=o*(-0.230285931083)*x_ref[0]**(o-1)+(0.905695021426)
        ref[4,0,0,1]=o*(-0.581906633624)*x_ref[1]**(o-1)+(-0.69277147014)
        ref[4,0,1,0]=o*(-0.251350536276)*x_ref[0]**(o-1)+(0.352877501605)
        ref[4,0,1,1]=o*(0.290432460788)*x_ref[1]**(o-1)+(0.614218150117)
        ref[4,1,0,0]=o*(-0.475014635407)*x_ref[0]**(o-1)+(0.86786497963)
        ref[4,1,0,1]=o*(-0.763349511499)*x_ref[1]**(o-1)+(0.817847286727)
        ref[4,1,1,0]=o*(0.0079711463132)*x_ref[0]**(o-1)+(-0.20685339926)
        ref[4,1,1,1]=o*(0.377467915936)*x_ref[1]**(o-1)+(-0.209268733968)
        ref[5,0,0,0]=o*(0.795790630791)*x_ref[0]**(o-1)+(0.0661201279192)
        ref[5,0,0,1]=o*(0.932665258262)*x_ref[1]**(o-1)+(-0.4785884914)
        ref[5,0,1,0]=o*(0.929422646068)*x_ref[0]**(o-1)+(0.775378282324)
        ref[5,0,1,1]=o*(0.297482039582)*x_ref[1]**(o-1)+(-0.700872789842)
        ref[5,1,0,0]=o*(0.678688297204)*x_ref[0]**(o-1)+(0.365975847321)
        ref[5,1,0,1]=o*(-0.565261107289)*x_ref[1]**(o-1)+(0.0317556604619)
        ref[5,1,1,0]=o*(-0.0231297032408)*x_ref[0]**(o-1)+(-0.985865541949)
        ref[5,1,1,1]=o*(0.733821736669)*x_ref[1]**(o-1)+(0.603255951212)
      else:
        arg[0,0,0]=(-0.211459759219)*x[0]**o+(-0.577684864446)*x[0]+(-0.391603126843)*x[1]**o+(0.260321825768)*x[1]+(-0.314038207978)*x[2]**o+(-0.981440041663)*x[2]
        arg[0,0,1]=(-0.876053365684)*x[0]**o+(-0.194899445893)*x[0]+(0.346950377505)*x[1]**o+(0.571865696578)*x[1]+(0.632901527485)*x[2]**o+(0.832258490904)*x[2]
        arg[0,1,0]=(-0.0779003885155)*x[0]**o+(0.583384314998)*x[0]+(-0.257262737021)*x[1]**o+(0.456730130081)*x[1]+(0.262812418811)*x[2]**o+(0.0815640391979)*x[2]
        arg[0,1,1]=(0.087484387098)*x[0]**o+(-0.415375968565)*x[0]+(0.31138114792)*x[1]**o+(0.832138685168)*x[1]+(0.552625436456)*x[2]**o+(-0.0969172211154)*x[2]
        arg[1,0,0]=(0.721326796741)*x[0]**o+(-0.556644260079)*x[0]+(0.14718294664)*x[1]**o+(0.688425309252)*x[1]+(-0.16480505764)*x[2]**o+(-0.914914176523)*x[2]
        arg[1,0,1]=(0.0932763269908)*x[0]**o+(0.359036469617)*x[0]+(0.568509073358)*x[1]**o+(-0.42133310351)*x[1]+(0.576833556667)*x[2]**o+(0.44466763296)*x[2]
        arg[1,1,0]=(0.564028751408)*x[0]**o+(-0.314840429631)*x[0]+(-0.910523044917)*x[1]**o+(-0.0377714078758)*x[1]+(0.0125836031881)*x[2]**o+(0.602273699833)*x[2]
        arg[1,1,1]=(0.135282471986)*x[0]**o+(0.163613895979)*x[0]+(0.115685034139)*x[1]**o+(-0.687078382924)*x[1]+(0.406385459521)*x[2]**o+(-0.401846794432)*x[2]
        arg[2,0,0]=(0.815695969791)*x[0]**o+(0.312205723135)*x[0]+(0.993404535838)*x[1]**o+(0.101946422158)*x[1]+(-0.331818829998)*x[2]**o+(-0.0034480605816)*x[2]
        arg[2,0,1]=(0.638646208966)*x[0]**o+(0.265838992948)*x[0]+(0.156594972273)*x[1]**o+(0.935292984535)*x[1]+(-0.930522319399)*x[2]**o+(0.540679813135)*x[2]
        arg[2,1,0]=(-0.778823826824)*x[0]**o+(0.435399707656)*x[0]+(0.123031900278)*x[1]**o+(-0.132556439303)*x[1]+(-0.29114590778)*x[2]**o+(-0.277636472779)*x[2]
        arg[2,1,1]=(-0.200541347963)*x[0]**o+(-0.526841282198)*x[0]+(0.670718267305)*x[1]**o+(0.0777161510281)*x[1]+(0.847335718393)*x[2]**o+(0.167185849891)*x[2]
        arg[3,0,0]=(0.481112023661)*x[0]**o+(-0.703558873662)*x[0]+(0.0661746324247)*x[1]**o+(0.0628113595423)*x[1]+(0.804110728888)*x[2]**o+(0.517297444342)*x[2]
        arg[3,0,1]=(-0.44648091284)*x[0]**o+(-0.976332452987)*x[0]+(-0.886297355627)*x[1]**o+(-0.910033293533)*x[1]+(0.946007442337)*x[2]**o+(-0.586006699603)*x[2]
        arg[3,1,0]=(0.686532047098)*x[0]**o+(0.647146535444)*x[0]+(-0.424413819624)*x[1]**o+(-0.266078497115)*x[1]+(-0.656118336723)*x[2]**o+(0.902145487914)*x[2]
        arg[3,1,1]=(-0.0562438759603)*x[0]**o+(0.600872472135)*x[0]+(-0.162016187788)*x[1]**o+(-0.685387926)*x[1]+(-0.899318041513)*x[2]**o+(0.459743174318)*x[2]
        arg[4,0,0]=(-0.923373905806)*x[0]**o+(-0.0340303642214)*x[0]+(-0.798971449517)*x[1]**o+(-0.45521271974)*x[1]+(-0.354501811953)*x[2]**o+(0.0668579007274)*x[2]
        arg[4,0,1]=(0.411397784181)*x[0]**o+(0.112609440102)*x[0]+(0.352899973694)*x[1]**o+(-0.0728024007714)*x[1]+(0.50804391825)*x[2]**o+(0.748548958571)*x[2]
        arg[4,1,0]=(0.875890044031)*x[0]**o+(0.674204747948)*x[0]+(-0.879286517401)*x[1]**o+(-0.00338161978492)*x[1]+(-0.372790489717)*x[2]**o+(0.480822881409)*x[2]
        arg[4,1,1]=(-0.224827091498)*x[0]**o+(0.854170572245)*x[0]+(-0.670467931784)*x[1]**o+(0.85225464592)*x[1]+(0.41885719338)*x[2]**o+(-0.623296073831)*x[2]
        arg[5,0,0]=(-0.662704253172)*x[0]**o+(0.690656552406)*x[0]+(-0.812436958497)*x[1]**o+(0.928013493065)*x[1]+(0.763792541097)*x[2]**o+(-0.430084528987)*x[2]
        arg[5,0,1]=(0.451167682598)*x[0]**o+(0.373015986015)*x[0]+(0.73334610852)*x[1]**o+(0.44892130407)*x[1]+(0.820233215547)*x[2]**o+(0.863864357936)*x[2]
        arg[5,1,0]=(-0.700840074185)*x[0]**o+(-0.637964737375)*x[0]+(0.0532062256138)*x[1]**o+(-0.902662868597)*x[1]+(-0.91668008633)*x[2]**o+(0.00253116545509)*x[2]
        arg[5,1,1]=(0.0461834200484)*x[0]**o+(0.102406795193)*x[0]+(0.599142154957)*x[1]**o+(0.374585801545)*x[1]+(-0.444968156109)*x[2]**o+(-0.932860816729)*x[2]
        ref[0,0,0,0]=o*(-0.211459759219)*x_ref[0]**(o-1)+(-0.577684864446)
        ref[0,0,0,1]=o*(-0.391603126843)*x_ref[1]**(o-1)+(0.260321825768)
        ref[0,0,0,2]=o*(-0.314038207978)*x_ref[2]**(o-1)+(-0.981440041663)
        ref[0,0,1,0]=o*(-0.876053365684)*x_ref[0]**(o-1)+(-0.194899445893)
        ref[0,0,1,1]=o*(0.346950377505)*x_ref[1]**(o-1)+(0.571865696578)
        ref[0,0,1,2]=o*(0.632901527485)*x_ref[2]**(o-1)+(0.832258490904)
        ref[0,1,0,0]=o*(-0.0779003885155)*x_ref[0]**(o-1)+(0.583384314998)
        ref[0,1,0,1]=o*(-0.257262737021)*x_ref[1]**(o-1)+(0.456730130081)
        ref[0,1,0,2]=o*(0.262812418811)*x_ref[2]**(o-1)+(0.0815640391979)
        ref[0,1,1,0]=o*(0.087484387098)*x_ref[0]**(o-1)+(-0.415375968565)
        ref[0,1,1,1]=o*(0.31138114792)*x_ref[1]**(o-1)+(0.832138685168)
        ref[0,1,1,2]=o*(0.552625436456)*x_ref[2]**(o-1)+(-0.0969172211154)
        ref[1,0,0,0]=o*(0.721326796741)*x_ref[0]**(o-1)+(-0.556644260079)
        ref[1,0,0,1]=o*(0.14718294664)*x_ref[1]**(o-1)+(0.688425309252)
        ref[1,0,0,2]=o*(-0.16480505764)*x_ref[2]**(o-1)+(-0.914914176523)
        ref[1,0,1,0]=o*(0.0932763269908)*x_ref[0]**(o-1)+(0.359036469617)
        ref[1,0,1,1]=o*(0.568509073358)*x_ref[1]**(o-1)+(-0.42133310351)
        ref[1,0,1,2]=o*(0.576833556667)*x_ref[2]**(o-1)+(0.44466763296)
        ref[1,1,0,0]=o*(0.564028751408)*x_ref[0]**(o-1)+(-0.314840429631)
        ref[1,1,0,1]=o*(-0.910523044917)*x_ref[1]**(o-1)+(-0.0377714078758)
        ref[1,1,0,2]=o*(0.0125836031881)*x_ref[2]**(o-1)+(0.602273699833)
        ref[1,1,1,0]=o*(0.135282471986)*x_ref[0]**(o-1)+(0.163613895979)
        ref[1,1,1,1]=o*(0.115685034139)*x_ref[1]**(o-1)+(-0.687078382924)
        ref[1,1,1,2]=o*(0.406385459521)*x_ref[2]**(o-1)+(-0.401846794432)
        ref[2,0,0,0]=o*(0.815695969791)*x_ref[0]**(o-1)+(0.312205723135)
        ref[2,0,0,1]=o*(0.993404535838)*x_ref[1]**(o-1)+(0.101946422158)
        ref[2,0,0,2]=o*(-0.331818829998)*x_ref[2]**(o-1)+(-0.0034480605816)
        ref[2,0,1,0]=o*(0.638646208966)*x_ref[0]**(o-1)+(0.265838992948)
        ref[2,0,1,1]=o*(0.156594972273)*x_ref[1]**(o-1)+(0.935292984535)
        ref[2,0,1,2]=o*(-0.930522319399)*x_ref[2]**(o-1)+(0.540679813135)
        ref[2,1,0,0]=o*(-0.778823826824)*x_ref[0]**(o-1)+(0.435399707656)
        ref[2,1,0,1]=o*(0.123031900278)*x_ref[1]**(o-1)+(-0.132556439303)
        ref[2,1,0,2]=o*(-0.29114590778)*x_ref[2]**(o-1)+(-0.277636472779)
        ref[2,1,1,0]=o*(-0.200541347963)*x_ref[0]**(o-1)+(-0.526841282198)
        ref[2,1,1,1]=o*(0.670718267305)*x_ref[1]**(o-1)+(0.0777161510281)
        ref[2,1,1,2]=o*(0.847335718393)*x_ref[2]**(o-1)+(0.167185849891)
        ref[3,0,0,0]=o*(0.481112023661)*x_ref[0]**(o-1)+(-0.703558873662)
        ref[3,0,0,1]=o*(0.0661746324247)*x_ref[1]**(o-1)+(0.0628113595423)
        ref[3,0,0,2]=o*(0.804110728888)*x_ref[2]**(o-1)+(0.517297444342)
        ref[3,0,1,0]=o*(-0.44648091284)*x_ref[0]**(o-1)+(-0.976332452987)
        ref[3,0,1,1]=o*(-0.886297355627)*x_ref[1]**(o-1)+(-0.910033293533)
        ref[3,0,1,2]=o*(0.946007442337)*x_ref[2]**(o-1)+(-0.586006699603)
        ref[3,1,0,0]=o*(0.686532047098)*x_ref[0]**(o-1)+(0.647146535444)
        ref[3,1,0,1]=o*(-0.424413819624)*x_ref[1]**(o-1)+(-0.266078497115)
        ref[3,1,0,2]=o*(-0.656118336723)*x_ref[2]**(o-1)+(0.902145487914)
        ref[3,1,1,0]=o*(-0.0562438759603)*x_ref[0]**(o-1)+(0.600872472135)
        ref[3,1,1,1]=o*(-0.162016187788)*x_ref[1]**(o-1)+(-0.685387926)
        ref[3,1,1,2]=o*(-0.899318041513)*x_ref[2]**(o-1)+(0.459743174318)
        ref[4,0,0,0]=o*(-0.923373905806)*x_ref[0]**(o-1)+(-0.0340303642214)
        ref[4,0,0,1]=o*(-0.798971449517)*x_ref[1]**(o-1)+(-0.45521271974)
        ref[4,0,0,2]=o*(-0.354501811953)*x_ref[2]**(o-1)+(0.0668579007274)
        ref[4,0,1,0]=o*(0.411397784181)*x_ref[0]**(o-1)+(0.112609440102)
        ref[4,0,1,1]=o*(0.352899973694)*x_ref[1]**(o-1)+(-0.0728024007714)
        ref[4,0,1,2]=o*(0.50804391825)*x_ref[2]**(o-1)+(0.748548958571)
        ref[4,1,0,0]=o*(0.875890044031)*x_ref[0]**(o-1)+(0.674204747948)
        ref[4,1,0,1]=o*(-0.879286517401)*x_ref[1]**(o-1)+(-0.00338161978492)
        ref[4,1,0,2]=o*(-0.372790489717)*x_ref[2]**(o-1)+(0.480822881409)
        ref[4,1,1,0]=o*(-0.224827091498)*x_ref[0]**(o-1)+(0.854170572245)
        ref[4,1,1,1]=o*(-0.670467931784)*x_ref[1]**(o-1)+(0.85225464592)
        ref[4,1,1,2]=o*(0.41885719338)*x_ref[2]**(o-1)+(-0.623296073831)
        ref[5,0,0,0]=o*(-0.662704253172)*x_ref[0]**(o-1)+(0.690656552406)
        ref[5,0,0,1]=o*(-0.812436958497)*x_ref[1]**(o-1)+(0.928013493065)
        ref[5,0,0,2]=o*(0.763792541097)*x_ref[2]**(o-1)+(-0.430084528987)
        ref[5,0,1,0]=o*(0.451167682598)*x_ref[0]**(o-1)+(0.373015986015)
        ref[5,0,1,1]=o*(0.73334610852)*x_ref[1]**(o-1)+(0.44892130407)
        ref[5,0,1,2]=o*(0.820233215547)*x_ref[2]**(o-1)+(0.863864357936)
        ref[5,1,0,0]=o*(-0.700840074185)*x_ref[0]**(o-1)+(-0.637964737375)
        ref[5,1,0,1]=o*(0.0532062256138)*x_ref[1]**(o-1)+(-0.902662868597)
        ref[5,1,0,2]=o*(-0.91668008633)*x_ref[2]**(o-1)+(0.00253116545509)
        ref[5,1,1,0]=o*(0.0461834200484)*x_ref[0]**(o-1)+(0.102406795193)
        ref[5,1,1,1]=o*(0.599142154957)*x_ref[1]**(o-1)+(0.374585801545)
        ref[5,1,1,2]=o*(-0.444968156109)*x_ref[2]**(o-1)+(-0.932860816729)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnContactZero_fromData_ReducedSolution_rank0(self):
      """
      tests gradient for rank 0 Data on the FunctionOnContactZero

      assumptions: ReducedSolution(self.domain) exists
                   self.domain supports gradient on FunctionOnContactZero
      """
      o=1
      dim=self.domain.getDim()
      w_ref=FunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=ReducedSolution(self.domain)
      x=w.getX()
      arg=Data(0,(),w)
      ref=Data(0,()+(dim,),w_ref)
      if dim==2:
        arg=(1.37238770251)*x[0]+(-1.43917937019)*x[1]
        ref[0]=(1.37238770251)
        ref[1]=(-1.43917937019)
      else:
        arg=(0.951563810847)*x[0]+(-1.91408943437)*x[1]+(0.233861671105)*x[2]
        ref[0]=(0.951563810847)
        ref[1]=(-1.91408943437)
        ref[2]=(0.233861671105)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),()+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnContactZero_fromData_ReducedSolution_rank1(self):
      """
      tests gradient for rank 1 Data on the FunctionOnContactZero

      assumptions: ReducedSolution(self.domain) exists
                   self.domain supports gradient on FunctionOnContactZero
      """
      o=1
      dim=self.domain.getDim()
      w_ref=FunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=ReducedSolution(self.domain)
      x=w.getX()
      arg=Data(0,(2,),w)
      ref=Data(0,(2,)+(dim,),w_ref)
      if dim==2:
        arg[0]=(1.42921344972)*x[0]+(-0.911436505176)*x[1]
        arg[1]=(1.25688300316)*x[0]+(0.0536640238292)*x[1]
        ref[0,0]=(1.42921344972)
        ref[0,1]=(-0.911436505176)
        ref[1,0]=(1.25688300316)
        ref[1,1]=(0.0536640238292)
      else:
        arg[0]=(-1.57773112011)*x[0]+(-0.697311790617)*x[1]+(-0.480770363787)*x[2]
        arg[1]=(-0.136063655594)*x[0]+(0.882253548646)*x[1]+(1.35773570995)*x[2]
        ref[0,0]=(-1.57773112011)
        ref[0,1]=(-0.697311790617)
        ref[0,2]=(-0.480770363787)
        ref[1,0]=(-0.136063655594)
        ref[1,1]=(0.882253548646)
        ref[1,2]=(1.35773570995)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnContactZero_fromData_ReducedSolution_rank2(self):
      """
      tests gradient for rank 2 Data on the FunctionOnContactZero

      assumptions: ReducedSolution(self.domain) exists
                   self.domain supports gradient on FunctionOnContactZero
      """
      o=1
      dim=self.domain.getDim()
      w_ref=FunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=ReducedSolution(self.domain)
      x=w.getX()
      arg=Data(0,(4, 5),w)
      ref=Data(0,(4, 5)+(dim,),w_ref)
      if dim==2:
        arg[0,0]=(0.448247291087)*x[0]+(-0.00880442943882)*x[1]
        arg[0,1]=(-0.59784234455)*x[0]+(-0.94951606979)*x[1]
        arg[0,2]=(1.38316656933)*x[0]+(-0.124817047005)*x[1]
        arg[0,3]=(-0.0748469893414)*x[0]+(1.44145142047)*x[1]
        arg[0,4]=(1.81133385456)*x[0]+(-0.518406894403)*x[1]
        arg[1,0]=(-0.65460152624)*x[0]+(-0.350858526434)*x[1]
        arg[1,1]=(0.924058009558)*x[0]+(-0.40973995895)*x[1]
        arg[1,2]=(-0.299794705178)*x[0]+(-0.924557696915)*x[1]
        arg[1,3]=(-0.608513627169)*x[0]+(-0.141936714389)*x[1]
        arg[1,4]=(0.469099778997)*x[0]+(0.754132353456)*x[1]
        arg[2,0]=(-0.627098551951)*x[0]+(0.476865448119)*x[1]
        arg[2,1]=(-1.03564375134)*x[0]+(-0.280009187543)*x[1]
        arg[2,2]=(0.475083576156)*x[0]+(0.220248066616)*x[1]
        arg[2,3]=(0.0420499398173)*x[0]+(0.0808105284548)*x[1]
        arg[2,4]=(0.368173655662)*x[0]+(-0.58266909961)*x[1]
        arg[3,0]=(0.450851110298)*x[0]+(0.0844590226087)*x[1]
        arg[3,1]=(0.508010554654)*x[0]+(0.797109833792)*x[1]
        arg[3,2]=(0.711479388001)*x[0]+(1.12829906729)*x[1]
        arg[3,3]=(0.0588799697153)*x[0]+(-0.991874826409)*x[1]
        arg[3,4]=(0.743446045536)*x[0]+(0.65754450588)*x[1]
        ref[0,0,0]=(0.448247291087)
        ref[0,0,1]=(-0.00880442943882)
        ref[0,1,0]=(-0.59784234455)
        ref[0,1,1]=(-0.94951606979)
        ref[0,2,0]=(1.38316656933)
        ref[0,2,1]=(-0.124817047005)
        ref[0,3,0]=(-0.0748469893414)
        ref[0,3,1]=(1.44145142047)
        ref[0,4,0]=(1.81133385456)
        ref[0,4,1]=(-0.518406894403)
        ref[1,0,0]=(-0.65460152624)
        ref[1,0,1]=(-0.350858526434)
        ref[1,1,0]=(0.924058009558)
        ref[1,1,1]=(-0.40973995895)
        ref[1,2,0]=(-0.299794705178)
        ref[1,2,1]=(-0.924557696915)
        ref[1,3,0]=(-0.608513627169)
        ref[1,3,1]=(-0.141936714389)
        ref[1,4,0]=(0.469099778997)
        ref[1,4,1]=(0.754132353456)
        ref[2,0,0]=(-0.627098551951)
        ref[2,0,1]=(0.476865448119)
        ref[2,1,0]=(-1.03564375134)
        ref[2,1,1]=(-0.280009187543)
        ref[2,2,0]=(0.475083576156)
        ref[2,2,1]=(0.220248066616)
        ref[2,3,0]=(0.0420499398173)
        ref[2,3,1]=(0.0808105284548)
        ref[2,4,0]=(0.368173655662)
        ref[2,4,1]=(-0.58266909961)
        ref[3,0,0]=(0.450851110298)
        ref[3,0,1]=(0.0844590226087)
        ref[3,1,0]=(0.508010554654)
        ref[3,1,1]=(0.797109833792)
        ref[3,2,0]=(0.711479388001)
        ref[3,2,1]=(1.12829906729)
        ref[3,3,0]=(0.0588799697153)
        ref[3,3,1]=(-0.991874826409)
        ref[3,4,0]=(0.743446045536)
        ref[3,4,1]=(0.65754450588)
      else:
        arg[0,0]=(-0.43386387868)*x[0]+(0.321105491776)*x[1]+(0.384206679414)*x[2]
        arg[0,1]=(0.604698878149)*x[0]+(0.594375439325)*x[1]+(0.162832272176)*x[2]
        arg[0,2]=(-0.332194829416)*x[0]+(0.600821281937)*x[1]+(0.493622302813)*x[2]
        arg[0,3]=(0.846367268698)*x[0]+(-1.32744832381)*x[1]+(0.00466654421944)*x[2]
        arg[0,4]=(0.385111950936)*x[0]+(-0.176705693397)*x[1]+(0.461732370075)*x[2]
        arg[1,0]=(-0.14529643778)*x[0]+(1.15329219838)*x[1]+(0.157842247326)*x[2]
        arg[1,1]=(0.00817149012591)*x[0]+(-0.703898404732)*x[1]+(-1.14419500663)*x[2]
        arg[1,2]=(-0.124155034423)*x[0]+(0.906000496919)*x[1]+(-0.466071596735)*x[2]
        arg[1,3]=(0.413190740147)*x[0]+(0.968639404637)*x[1]+(-1.25413312698)*x[2]
        arg[1,4]=(0.521974966379)*x[0]+(0.936384991187)*x[1]+(-0.0630547476157)*x[2]
        arg[2,0]=(-0.334976510608)*x[0]+(-0.268364721371)*x[1]+(0.806974769679)*x[2]
        arg[2,1]=(-0.0672705162033)*x[0]+(0.459808873839)*x[1]+(0.0725634327358)*x[2]
        arg[2,2]=(0.142418012401)*x[0]+(-0.400301432498)*x[1]+(-1.37021128371)*x[2]
        arg[2,3]=(-1.60617980561)*x[0]+(0.0686943218654)*x[1]+(0.647509287658)*x[2]
        arg[2,4]=(0.0102366197695)*x[0]+(-1.24104511219)*x[1]+(-0.739463479584)*x[2]
        arg[3,0]=(-0.425526939568)*x[0]+(-0.946421307227)*x[1]+(0.133101457377)*x[2]
        arg[3,1]=(1.07183638389)*x[0]+(-1.21405997903)*x[1]+(-0.962984008606)*x[2]
        arg[3,2]=(-0.913456686897)*x[0]+(0.907233128077)*x[1]+(0.581609247137)*x[2]
        arg[3,3]=(-0.729544885457)*x[0]+(-0.433435638004)*x[1]+(0.357011166494)*x[2]
        arg[3,4]=(1.21906931308)*x[0]+(0.322487716786)*x[1]+(1.05602783674)*x[2]
        ref[0,0,0]=(-0.43386387868)
        ref[0,0,1]=(0.321105491776)
        ref[0,0,2]=(0.384206679414)
        ref[0,1,0]=(0.604698878149)
        ref[0,1,1]=(0.594375439325)
        ref[0,1,2]=(0.162832272176)
        ref[0,2,0]=(-0.332194829416)
        ref[0,2,1]=(0.600821281937)
        ref[0,2,2]=(0.493622302813)
        ref[0,3,0]=(0.846367268698)
        ref[0,3,1]=(-1.32744832381)
        ref[0,3,2]=(0.00466654421944)
        ref[0,4,0]=(0.385111950936)
        ref[0,4,1]=(-0.176705693397)
        ref[0,4,2]=(0.461732370075)
        ref[1,0,0]=(-0.14529643778)
        ref[1,0,1]=(1.15329219838)
        ref[1,0,2]=(0.157842247326)
        ref[1,1,0]=(0.00817149012591)
        ref[1,1,1]=(-0.703898404732)
        ref[1,1,2]=(-1.14419500663)
        ref[1,2,0]=(-0.124155034423)
        ref[1,2,1]=(0.906000496919)
        ref[1,2,2]=(-0.466071596735)
        ref[1,3,0]=(0.413190740147)
        ref[1,3,1]=(0.968639404637)
        ref[1,3,2]=(-1.25413312698)
        ref[1,4,0]=(0.521974966379)
        ref[1,4,1]=(0.936384991187)
        ref[1,4,2]=(-0.0630547476157)
        ref[2,0,0]=(-0.334976510608)
        ref[2,0,1]=(-0.268364721371)
        ref[2,0,2]=(0.806974769679)
        ref[2,1,0]=(-0.0672705162033)
        ref[2,1,1]=(0.459808873839)
        ref[2,1,2]=(0.0725634327358)
        ref[2,2,0]=(0.142418012401)
        ref[2,2,1]=(-0.400301432498)
        ref[2,2,2]=(-1.37021128371)
        ref[2,3,0]=(-1.60617980561)
        ref[2,3,1]=(0.0686943218654)
        ref[2,3,2]=(0.647509287658)
        ref[2,4,0]=(0.0102366197695)
        ref[2,4,1]=(-1.24104511219)
        ref[2,4,2]=(-0.739463479584)
        ref[3,0,0]=(-0.425526939568)
        ref[3,0,1]=(-0.946421307227)
        ref[3,0,2]=(0.133101457377)
        ref[3,1,0]=(1.07183638389)
        ref[3,1,1]=(-1.21405997903)
        ref[3,1,2]=(-0.962984008606)
        ref[3,2,0]=(-0.913456686897)
        ref[3,2,1]=(0.907233128077)
        ref[3,2,2]=(0.581609247137)
        ref[3,3,0]=(-0.729544885457)
        ref[3,3,1]=(-0.433435638004)
        ref[3,3,2]=(0.357011166494)
        ref[3,4,0]=(1.21906931308)
        ref[3,4,1]=(0.322487716786)
        ref[3,4,2]=(1.05602783674)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnContactZero_fromData_ReducedSolution_rank3(self):
      """
      tests gradient for rank 3 Data on the FunctionOnContactZero

      assumptions: ReducedSolution(self.domain) exists
                   self.domain supports gradient on FunctionOnContactZero
      """
      o=1
      dim=self.domain.getDim()
      w_ref=FunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=ReducedSolution(self.domain)
      x=w.getX()
      arg=Data(0,(6, 2, 2),w)
      ref=Data(0,(6, 2, 2)+(dim,),w_ref)
      if dim==2:
        arg[0,0,0]=(-0.287546203823)*x[0]+(0.390321729967)*x[1]
        arg[0,0,1]=(-0.112653571553)*x[0]+(-0.359753186922)*x[1]
        arg[0,1,0]=(0.00656985674969)*x[0]+(-0.397210304393)*x[1]
        arg[0,1,1]=(-0.825698431533)*x[0]+(-1.20994477496)*x[1]
        arg[1,0,0]=(0.0456789352898)*x[0]+(0.201178709355)*x[1]
        arg[1,0,1]=(0.216619650199)*x[0]+(-0.684237394127)*x[1]
        arg[1,1,0]=(-0.452605086273)*x[0]+(0.383220784575)*x[1]
        arg[1,1,1]=(-0.385315869703)*x[0]+(-1.25937320051)*x[1]
        arg[2,0,0]=(-0.546290546777)*x[0]+(0.0659124729108)*x[1]
        arg[2,0,1]=(0.23413834434)*x[0]+(0.241510050424)*x[1]
        arg[2,1,0]=(-0.541097368124)*x[0]+(0.458682016611)*x[1]
        arg[2,1,1]=(0.314030173817)*x[0]+(0.083613884286)*x[1]
        arg[3,0,0]=(0.862005271666)*x[0]+(0.858693755091)*x[1]
        arg[3,0,1]=(-1.14220805291)*x[0]+(0.609875693913)*x[1]
        arg[3,1,0]=(-0.847069360014)*x[0]+(0.240069314456)*x[1]
        arg[3,1,1]=(0.480596211718)*x[0]+(-1.40901297384)*x[1]
        arg[4,0,0]=(-1.38036653523)*x[0]+(-0.0732955000278)*x[1]
        arg[4,0,1]=(0.0716061704803)*x[0]+(0.180127379412)*x[1]
        arg[4,1,0]=(1.26959959862)*x[0]+(-1.38131896436)*x[1]
        arg[4,1,1]=(0.204280361123)*x[0]+(0.532611514369)*x[1]
        arg[5,0,0]=(0.209536293545)*x[0]+(-0.303994906788)*x[1]
        arg[5,0,1]=(1.41150162289)*x[0]+(1.32515735407)*x[1]
        arg[5,1,0]=(1.59736027384)*x[0]+(-0.711055564868)*x[1]
        arg[5,1,1]=(-1.31799658024)*x[0]+(0.829209493108)*x[1]
        ref[0,0,0,0]=(-0.287546203823)
        ref[0,0,0,1]=(0.390321729967)
        ref[0,0,1,0]=(-0.112653571553)
        ref[0,0,1,1]=(-0.359753186922)
        ref[0,1,0,0]=(0.00656985674969)
        ref[0,1,0,1]=(-0.397210304393)
        ref[0,1,1,0]=(-0.825698431533)
        ref[0,1,1,1]=(-1.20994477496)
        ref[1,0,0,0]=(0.0456789352898)
        ref[1,0,0,1]=(0.201178709355)
        ref[1,0,1,0]=(0.216619650199)
        ref[1,0,1,1]=(-0.684237394127)
        ref[1,1,0,0]=(-0.452605086273)
        ref[1,1,0,1]=(0.383220784575)
        ref[1,1,1,0]=(-0.385315869703)
        ref[1,1,1,1]=(-1.25937320051)
        ref[2,0,0,0]=(-0.546290546777)
        ref[2,0,0,1]=(0.0659124729108)
        ref[2,0,1,0]=(0.23413834434)
        ref[2,0,1,1]=(0.241510050424)
        ref[2,1,0,0]=(-0.541097368124)
        ref[2,1,0,1]=(0.458682016611)
        ref[2,1,1,0]=(0.314030173817)
        ref[2,1,1,1]=(0.083613884286)
        ref[3,0,0,0]=(0.862005271666)
        ref[3,0,0,1]=(0.858693755091)
        ref[3,0,1,0]=(-1.14220805291)
        ref[3,0,1,1]=(0.609875693913)
        ref[3,1,0,0]=(-0.847069360014)
        ref[3,1,0,1]=(0.240069314456)
        ref[3,1,1,0]=(0.480596211718)
        ref[3,1,1,1]=(-1.40901297384)
        ref[4,0,0,0]=(-1.38036653523)
        ref[4,0,0,1]=(-0.0732955000278)
        ref[4,0,1,0]=(0.0716061704803)
        ref[4,0,1,1]=(0.180127379412)
        ref[4,1,0,0]=(1.26959959862)
        ref[4,1,0,1]=(-1.38131896436)
        ref[4,1,1,0]=(0.204280361123)
        ref[4,1,1,1]=(0.532611514369)
        ref[5,0,0,0]=(0.209536293545)
        ref[5,0,0,1]=(-0.303994906788)
        ref[5,0,1,0]=(1.41150162289)
        ref[5,0,1,1]=(1.32515735407)
        ref[5,1,0,0]=(1.59736027384)
        ref[5,1,0,1]=(-0.711055564868)
        ref[5,1,1,0]=(-1.31799658024)
        ref[5,1,1,1]=(0.829209493108)
      else:
        arg[0,0,0]=(0.832267408258)*x[0]+(-1.1995239623)*x[1]+(-1.81276973398)*x[2]
        arg[0,0,1]=(-0.0125232856194)*x[0]+(0.122543918666)*x[1]+(-1.12411286836)*x[2]
        arg[0,1,0]=(0.985611388383)*x[0]+(-1.17217207383)*x[1]+(-0.231241872108)*x[2]
        arg[0,1,1]=(0.625494139449)*x[0]+(0.784802683192)*x[1]+(0.612764525973)*x[2]
        arg[1,0,0]=(0.327644975022)*x[0]+(0.0552951801276)*x[1]+(-0.806887445103)*x[2]
        arg[1,0,1]=(0.194338798022)*x[0]+(0.799902026341)*x[1]+(1.70164249741)*x[2]
        arg[1,1,0]=(0.890832636865)*x[0]+(0.223899365292)*x[1]+(-0.283094526824)*x[2]
        arg[1,1,1]=(-0.122108330088)*x[0]+(-0.293413695547)*x[1]+(-0.371581852879)*x[2]
        arg[2,0,0]=(-0.469341678297)*x[0]+(0.152856292978)*x[1]+(0.765861314481)*x[2]
        arg[2,0,1]=(0.249219162734)*x[0]+(0.319622173697)*x[1]+(-0.182998471546)*x[2]
        arg[2,1,0]=(0.39687496584)*x[0]+(0.137084411978)*x[1]+(-0.34707250854)*x[2]
        arg[2,1,1]=(-0.382391798519)*x[0]+(0.755317411547)*x[1]+(0.424204162929)*x[2]
        arg[3,0,0]=(1.12637976255)*x[0]+(0.11632178776)*x[1]+(-0.615547388072)*x[2]
        arg[3,0,1]=(-0.819303259446)*x[0]+(0.916951216368)*x[1]+(-0.572792050441)*x[2]
        arg[3,1,0]=(0.194642055711)*x[0]+(0.949663114037)*x[1]+(-0.403001914682)*x[2]
        arg[3,1,1]=(0.902547242635)*x[0]+(-1.04027936291)*x[1]+(-1.78463515221)*x[2]
        arg[4,0,0]=(0.59060036737)*x[0]+(-0.580905638676)*x[1]+(-0.486098556884)*x[2]
        arg[4,0,1]=(-0.330634605524)*x[0]+(-0.758140973629)*x[1]+(-0.192282397672)*x[2]
        arg[4,1,0]=(1.40502801336)*x[0]+(0.199036161455)*x[1]+(-0.558660947885)*x[2]
        arg[4,1,1]=(-0.155588274273)*x[0]+(-0.57050736529)*x[1]+(1.1998664442)*x[2]
        arg[5,0,0]=(-0.754680865929)*x[0]+(1.29040984028)*x[1]+(-1.83778974463)*x[2]
        arg[5,0,1]=(0.274692501647)*x[0]+(0.368546080921)*x[1]+(-0.446376269232)*x[2]
        arg[5,1,0]=(-0.758704372861)*x[0]+(1.75555227426)*x[1]+(-0.13664688871)*x[2]
        arg[5,1,1]=(-0.568468068187)*x[0]+(-0.320218561544)*x[1]+(-0.827795466031)*x[2]
        ref[0,0,0,0]=(0.832267408258)
        ref[0,0,0,1]=(-1.1995239623)
        ref[0,0,0,2]=(-1.81276973398)
        ref[0,0,1,0]=(-0.0125232856194)
        ref[0,0,1,1]=(0.122543918666)
        ref[0,0,1,2]=(-1.12411286836)
        ref[0,1,0,0]=(0.985611388383)
        ref[0,1,0,1]=(-1.17217207383)
        ref[0,1,0,2]=(-0.231241872108)
        ref[0,1,1,0]=(0.625494139449)
        ref[0,1,1,1]=(0.784802683192)
        ref[0,1,1,2]=(0.612764525973)
        ref[1,0,0,0]=(0.327644975022)
        ref[1,0,0,1]=(0.0552951801276)
        ref[1,0,0,2]=(-0.806887445103)
        ref[1,0,1,0]=(0.194338798022)
        ref[1,0,1,1]=(0.799902026341)
        ref[1,0,1,2]=(1.70164249741)
        ref[1,1,0,0]=(0.890832636865)
        ref[1,1,0,1]=(0.223899365292)
        ref[1,1,0,2]=(-0.283094526824)
        ref[1,1,1,0]=(-0.122108330088)
        ref[1,1,1,1]=(-0.293413695547)
        ref[1,1,1,2]=(-0.371581852879)
        ref[2,0,0,0]=(-0.469341678297)
        ref[2,0,0,1]=(0.152856292978)
        ref[2,0,0,2]=(0.765861314481)
        ref[2,0,1,0]=(0.249219162734)
        ref[2,0,1,1]=(0.319622173697)
        ref[2,0,1,2]=(-0.182998471546)
        ref[2,1,0,0]=(0.39687496584)
        ref[2,1,0,1]=(0.137084411978)
        ref[2,1,0,2]=(-0.34707250854)
        ref[2,1,1,0]=(-0.382391798519)
        ref[2,1,1,1]=(0.755317411547)
        ref[2,1,1,2]=(0.424204162929)
        ref[3,0,0,0]=(1.12637976255)
        ref[3,0,0,1]=(0.11632178776)
        ref[3,0,0,2]=(-0.615547388072)
        ref[3,0,1,0]=(-0.819303259446)
        ref[3,0,1,1]=(0.916951216368)
        ref[3,0,1,2]=(-0.572792050441)
        ref[3,1,0,0]=(0.194642055711)
        ref[3,1,0,1]=(0.949663114037)
        ref[3,1,0,2]=(-0.403001914682)
        ref[3,1,1,0]=(0.902547242635)
        ref[3,1,1,1]=(-1.04027936291)
        ref[3,1,1,2]=(-1.78463515221)
        ref[4,0,0,0]=(0.59060036737)
        ref[4,0,0,1]=(-0.580905638676)
        ref[4,0,0,2]=(-0.486098556884)
        ref[4,0,1,0]=(-0.330634605524)
        ref[4,0,1,1]=(-0.758140973629)
        ref[4,0,1,2]=(-0.192282397672)
        ref[4,1,0,0]=(1.40502801336)
        ref[4,1,0,1]=(0.199036161455)
        ref[4,1,0,2]=(-0.558660947885)
        ref[4,1,1,0]=(-0.155588274273)
        ref[4,1,1,1]=(-0.57050736529)
        ref[4,1,1,2]=(1.1998664442)
        ref[5,0,0,0]=(-0.754680865929)
        ref[5,0,0,1]=(1.29040984028)
        ref[5,0,0,2]=(-1.83778974463)
        ref[5,0,1,0]=(0.274692501647)
        ref[5,0,1,1]=(0.368546080921)
        ref[5,0,1,2]=(-0.446376269232)
        ref[5,1,0,0]=(-0.758704372861)
        ref[5,1,0,1]=(1.75555227426)
        ref[5,1,0,2]=(-0.13664688871)
        ref[5,1,1,0]=(-0.568468068187)
        ref[5,1,1,1]=(-0.320218561544)
        ref[5,1,1,2]=(-0.827795466031)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnContactZero_fromData_ReducedContinuousFunction_rank0(self):
      """
      tests gradient for rank 0 Data on the FunctionOnContactZero

      assumptions: ReducedContinuousFunction(self.domain) exists
                   self.domain supports gradient on FunctionOnContactZero
      """
      o=1
      dim=self.domain.getDim()
      w_ref=FunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=ReducedContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(),w)
      ref=Data(0,()+(dim,),w_ref)
      if dim==2:
        arg=(1.37238770251)*x[0]+(-1.43917937019)*x[1]
        ref[0]=(1.37238770251)
        ref[1]=(-1.43917937019)
      else:
        arg=(0.951563810847)*x[0]+(-1.91408943437)*x[1]+(0.233861671105)*x[2]
        ref[0]=(0.951563810847)
        ref[1]=(-1.91408943437)
        ref[2]=(0.233861671105)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),()+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnContactZero_fromData_ReducedContinuousFunction_rank1(self):
      """
      tests gradient for rank 1 Data on the FunctionOnContactZero

      assumptions: ReducedContinuousFunction(self.domain) exists
                   self.domain supports gradient on FunctionOnContactZero
      """
      o=1
      dim=self.domain.getDim()
      w_ref=FunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=ReducedContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(2,),w)
      ref=Data(0,(2,)+(dim,),w_ref)
      if dim==2:
        arg[0]=(1.42921344972)*x[0]+(-0.911436505176)*x[1]
        arg[1]=(1.25688300316)*x[0]+(0.0536640238292)*x[1]
        ref[0,0]=(1.42921344972)
        ref[0,1]=(-0.911436505176)
        ref[1,0]=(1.25688300316)
        ref[1,1]=(0.0536640238292)
      else:
        arg[0]=(-1.57773112011)*x[0]+(-0.697311790617)*x[1]+(-0.480770363787)*x[2]
        arg[1]=(-0.136063655594)*x[0]+(0.882253548646)*x[1]+(1.35773570995)*x[2]
        ref[0,0]=(-1.57773112011)
        ref[0,1]=(-0.697311790617)
        ref[0,2]=(-0.480770363787)
        ref[1,0]=(-0.136063655594)
        ref[1,1]=(0.882253548646)
        ref[1,2]=(1.35773570995)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnContactZero_fromData_ReducedContinuousFunction_rank2(self):
      """
      tests gradient for rank 2 Data on the FunctionOnContactZero

      assumptions: ReducedContinuousFunction(self.domain) exists
                   self.domain supports gradient on FunctionOnContactZero
      """
      o=1
      dim=self.domain.getDim()
      w_ref=FunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=ReducedContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(4, 5),w)
      ref=Data(0,(4, 5)+(dim,),w_ref)
      if dim==2:
        arg[0,0]=(0.448247291087)*x[0]+(-0.00880442943882)*x[1]
        arg[0,1]=(-0.59784234455)*x[0]+(-0.94951606979)*x[1]
        arg[0,2]=(1.38316656933)*x[0]+(-0.124817047005)*x[1]
        arg[0,3]=(-0.0748469893414)*x[0]+(1.44145142047)*x[1]
        arg[0,4]=(1.81133385456)*x[0]+(-0.518406894403)*x[1]
        arg[1,0]=(-0.65460152624)*x[0]+(-0.350858526434)*x[1]
        arg[1,1]=(0.924058009558)*x[0]+(-0.40973995895)*x[1]
        arg[1,2]=(-0.299794705178)*x[0]+(-0.924557696915)*x[1]
        arg[1,3]=(-0.608513627169)*x[0]+(-0.141936714389)*x[1]
        arg[1,4]=(0.469099778997)*x[0]+(0.754132353456)*x[1]
        arg[2,0]=(-0.627098551951)*x[0]+(0.476865448119)*x[1]
        arg[2,1]=(-1.03564375134)*x[0]+(-0.280009187543)*x[1]
        arg[2,2]=(0.475083576156)*x[0]+(0.220248066616)*x[1]
        arg[2,3]=(0.0420499398173)*x[0]+(0.0808105284548)*x[1]
        arg[2,4]=(0.368173655662)*x[0]+(-0.58266909961)*x[1]
        arg[3,0]=(0.450851110298)*x[0]+(0.0844590226087)*x[1]
        arg[3,1]=(0.508010554654)*x[0]+(0.797109833792)*x[1]
        arg[3,2]=(0.711479388001)*x[0]+(1.12829906729)*x[1]
        arg[3,3]=(0.0588799697153)*x[0]+(-0.991874826409)*x[1]
        arg[3,4]=(0.743446045536)*x[0]+(0.65754450588)*x[1]
        ref[0,0,0]=(0.448247291087)
        ref[0,0,1]=(-0.00880442943882)
        ref[0,1,0]=(-0.59784234455)
        ref[0,1,1]=(-0.94951606979)
        ref[0,2,0]=(1.38316656933)
        ref[0,2,1]=(-0.124817047005)
        ref[0,3,0]=(-0.0748469893414)
        ref[0,3,1]=(1.44145142047)
        ref[0,4,0]=(1.81133385456)
        ref[0,4,1]=(-0.518406894403)
        ref[1,0,0]=(-0.65460152624)
        ref[1,0,1]=(-0.350858526434)
        ref[1,1,0]=(0.924058009558)
        ref[1,1,1]=(-0.40973995895)
        ref[1,2,0]=(-0.299794705178)
        ref[1,2,1]=(-0.924557696915)
        ref[1,3,0]=(-0.608513627169)
        ref[1,3,1]=(-0.141936714389)
        ref[1,4,0]=(0.469099778997)
        ref[1,4,1]=(0.754132353456)
        ref[2,0,0]=(-0.627098551951)
        ref[2,0,1]=(0.476865448119)
        ref[2,1,0]=(-1.03564375134)
        ref[2,1,1]=(-0.280009187543)
        ref[2,2,0]=(0.475083576156)
        ref[2,2,1]=(0.220248066616)
        ref[2,3,0]=(0.0420499398173)
        ref[2,3,1]=(0.0808105284548)
        ref[2,4,0]=(0.368173655662)
        ref[2,4,1]=(-0.58266909961)
        ref[3,0,0]=(0.450851110298)
        ref[3,0,1]=(0.0844590226087)
        ref[3,1,0]=(0.508010554654)
        ref[3,1,1]=(0.797109833792)
        ref[3,2,0]=(0.711479388001)
        ref[3,2,1]=(1.12829906729)
        ref[3,3,0]=(0.0588799697153)
        ref[3,3,1]=(-0.991874826409)
        ref[3,4,0]=(0.743446045536)
        ref[3,4,1]=(0.65754450588)
      else:
        arg[0,0]=(-0.43386387868)*x[0]+(0.321105491776)*x[1]+(0.384206679414)*x[2]
        arg[0,1]=(0.604698878149)*x[0]+(0.594375439325)*x[1]+(0.162832272176)*x[2]
        arg[0,2]=(-0.332194829416)*x[0]+(0.600821281937)*x[1]+(0.493622302813)*x[2]
        arg[0,3]=(0.846367268698)*x[0]+(-1.32744832381)*x[1]+(0.00466654421944)*x[2]
        arg[0,4]=(0.385111950936)*x[0]+(-0.176705693397)*x[1]+(0.461732370075)*x[2]
        arg[1,0]=(-0.14529643778)*x[0]+(1.15329219838)*x[1]+(0.157842247326)*x[2]
        arg[1,1]=(0.00817149012591)*x[0]+(-0.703898404732)*x[1]+(-1.14419500663)*x[2]
        arg[1,2]=(-0.124155034423)*x[0]+(0.906000496919)*x[1]+(-0.466071596735)*x[2]
        arg[1,3]=(0.413190740147)*x[0]+(0.968639404637)*x[1]+(-1.25413312698)*x[2]
        arg[1,4]=(0.521974966379)*x[0]+(0.936384991187)*x[1]+(-0.0630547476157)*x[2]
        arg[2,0]=(-0.334976510608)*x[0]+(-0.268364721371)*x[1]+(0.806974769679)*x[2]
        arg[2,1]=(-0.0672705162033)*x[0]+(0.459808873839)*x[1]+(0.0725634327358)*x[2]
        arg[2,2]=(0.142418012401)*x[0]+(-0.400301432498)*x[1]+(-1.37021128371)*x[2]
        arg[2,3]=(-1.60617980561)*x[0]+(0.0686943218654)*x[1]+(0.647509287658)*x[2]
        arg[2,4]=(0.0102366197695)*x[0]+(-1.24104511219)*x[1]+(-0.739463479584)*x[2]
        arg[3,0]=(-0.425526939568)*x[0]+(-0.946421307227)*x[1]+(0.133101457377)*x[2]
        arg[3,1]=(1.07183638389)*x[0]+(-1.21405997903)*x[1]+(-0.962984008606)*x[2]
        arg[3,2]=(-0.913456686897)*x[0]+(0.907233128077)*x[1]+(0.581609247137)*x[2]
        arg[3,3]=(-0.729544885457)*x[0]+(-0.433435638004)*x[1]+(0.357011166494)*x[2]
        arg[3,4]=(1.21906931308)*x[0]+(0.322487716786)*x[1]+(1.05602783674)*x[2]
        ref[0,0,0]=(-0.43386387868)
        ref[0,0,1]=(0.321105491776)
        ref[0,0,2]=(0.384206679414)
        ref[0,1,0]=(0.604698878149)
        ref[0,1,1]=(0.594375439325)
        ref[0,1,2]=(0.162832272176)
        ref[0,2,0]=(-0.332194829416)
        ref[0,2,1]=(0.600821281937)
        ref[0,2,2]=(0.493622302813)
        ref[0,3,0]=(0.846367268698)
        ref[0,3,1]=(-1.32744832381)
        ref[0,3,2]=(0.00466654421944)
        ref[0,4,0]=(0.385111950936)
        ref[0,4,1]=(-0.176705693397)
        ref[0,4,2]=(0.461732370075)
        ref[1,0,0]=(-0.14529643778)
        ref[1,0,1]=(1.15329219838)
        ref[1,0,2]=(0.157842247326)
        ref[1,1,0]=(0.00817149012591)
        ref[1,1,1]=(-0.703898404732)
        ref[1,1,2]=(-1.14419500663)
        ref[1,2,0]=(-0.124155034423)
        ref[1,2,1]=(0.906000496919)
        ref[1,2,2]=(-0.466071596735)
        ref[1,3,0]=(0.413190740147)
        ref[1,3,1]=(0.968639404637)
        ref[1,3,2]=(-1.25413312698)
        ref[1,4,0]=(0.521974966379)
        ref[1,4,1]=(0.936384991187)
        ref[1,4,2]=(-0.0630547476157)
        ref[2,0,0]=(-0.334976510608)
        ref[2,0,1]=(-0.268364721371)
        ref[2,0,2]=(0.806974769679)
        ref[2,1,0]=(-0.0672705162033)
        ref[2,1,1]=(0.459808873839)
        ref[2,1,2]=(0.0725634327358)
        ref[2,2,0]=(0.142418012401)
        ref[2,2,1]=(-0.400301432498)
        ref[2,2,2]=(-1.37021128371)
        ref[2,3,0]=(-1.60617980561)
        ref[2,3,1]=(0.0686943218654)
        ref[2,3,2]=(0.647509287658)
        ref[2,4,0]=(0.0102366197695)
        ref[2,4,1]=(-1.24104511219)
        ref[2,4,2]=(-0.739463479584)
        ref[3,0,0]=(-0.425526939568)
        ref[3,0,1]=(-0.946421307227)
        ref[3,0,2]=(0.133101457377)
        ref[3,1,0]=(1.07183638389)
        ref[3,1,1]=(-1.21405997903)
        ref[3,1,2]=(-0.962984008606)
        ref[3,2,0]=(-0.913456686897)
        ref[3,2,1]=(0.907233128077)
        ref[3,2,2]=(0.581609247137)
        ref[3,3,0]=(-0.729544885457)
        ref[3,3,1]=(-0.433435638004)
        ref[3,3,2]=(0.357011166494)
        ref[3,4,0]=(1.21906931308)
        ref[3,4,1]=(0.322487716786)
        ref[3,4,2]=(1.05602783674)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnContactZero_fromData_ReducedContinuousFunction_rank3(self):
      """
      tests gradient for rank 3 Data on the FunctionOnContactZero

      assumptions: ReducedContinuousFunction(self.domain) exists
                   self.domain supports gradient on FunctionOnContactZero
      """
      o=1
      dim=self.domain.getDim()
      w_ref=FunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=ReducedContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(6, 2, 2),w)
      ref=Data(0,(6, 2, 2)+(dim,),w_ref)
      if dim==2:
        arg[0,0,0]=(-0.287546203823)*x[0]+(0.390321729967)*x[1]
        arg[0,0,1]=(-0.112653571553)*x[0]+(-0.359753186922)*x[1]
        arg[0,1,0]=(0.00656985674969)*x[0]+(-0.397210304393)*x[1]
        arg[0,1,1]=(-0.825698431533)*x[0]+(-1.20994477496)*x[1]
        arg[1,0,0]=(0.0456789352898)*x[0]+(0.201178709355)*x[1]
        arg[1,0,1]=(0.216619650199)*x[0]+(-0.684237394127)*x[1]
        arg[1,1,0]=(-0.452605086273)*x[0]+(0.383220784575)*x[1]
        arg[1,1,1]=(-0.385315869703)*x[0]+(-1.25937320051)*x[1]
        arg[2,0,0]=(-0.546290546777)*x[0]+(0.0659124729108)*x[1]
        arg[2,0,1]=(0.23413834434)*x[0]+(0.241510050424)*x[1]
        arg[2,1,0]=(-0.541097368124)*x[0]+(0.458682016611)*x[1]
        arg[2,1,1]=(0.314030173817)*x[0]+(0.083613884286)*x[1]
        arg[3,0,0]=(0.862005271666)*x[0]+(0.858693755091)*x[1]
        arg[3,0,1]=(-1.14220805291)*x[0]+(0.609875693913)*x[1]
        arg[3,1,0]=(-0.847069360014)*x[0]+(0.240069314456)*x[1]
        arg[3,1,1]=(0.480596211718)*x[0]+(-1.40901297384)*x[1]
        arg[4,0,0]=(-1.38036653523)*x[0]+(-0.0732955000278)*x[1]
        arg[4,0,1]=(0.0716061704803)*x[0]+(0.180127379412)*x[1]
        arg[4,1,0]=(1.26959959862)*x[0]+(-1.38131896436)*x[1]
        arg[4,1,1]=(0.204280361123)*x[0]+(0.532611514369)*x[1]
        arg[5,0,0]=(0.209536293545)*x[0]+(-0.303994906788)*x[1]
        arg[5,0,1]=(1.41150162289)*x[0]+(1.32515735407)*x[1]
        arg[5,1,0]=(1.59736027384)*x[0]+(-0.711055564868)*x[1]
        arg[5,1,1]=(-1.31799658024)*x[0]+(0.829209493108)*x[1]
        ref[0,0,0,0]=(-0.287546203823)
        ref[0,0,0,1]=(0.390321729967)
        ref[0,0,1,0]=(-0.112653571553)
        ref[0,0,1,1]=(-0.359753186922)
        ref[0,1,0,0]=(0.00656985674969)
        ref[0,1,0,1]=(-0.397210304393)
        ref[0,1,1,0]=(-0.825698431533)
        ref[0,1,1,1]=(-1.20994477496)
        ref[1,0,0,0]=(0.0456789352898)
        ref[1,0,0,1]=(0.201178709355)
        ref[1,0,1,0]=(0.216619650199)
        ref[1,0,1,1]=(-0.684237394127)
        ref[1,1,0,0]=(-0.452605086273)
        ref[1,1,0,1]=(0.383220784575)
        ref[1,1,1,0]=(-0.385315869703)
        ref[1,1,1,1]=(-1.25937320051)
        ref[2,0,0,0]=(-0.546290546777)
        ref[2,0,0,1]=(0.0659124729108)
        ref[2,0,1,0]=(0.23413834434)
        ref[2,0,1,1]=(0.241510050424)
        ref[2,1,0,0]=(-0.541097368124)
        ref[2,1,0,1]=(0.458682016611)
        ref[2,1,1,0]=(0.314030173817)
        ref[2,1,1,1]=(0.083613884286)
        ref[3,0,0,0]=(0.862005271666)
        ref[3,0,0,1]=(0.858693755091)
        ref[3,0,1,0]=(-1.14220805291)
        ref[3,0,1,1]=(0.609875693913)
        ref[3,1,0,0]=(-0.847069360014)
        ref[3,1,0,1]=(0.240069314456)
        ref[3,1,1,0]=(0.480596211718)
        ref[3,1,1,1]=(-1.40901297384)
        ref[4,0,0,0]=(-1.38036653523)
        ref[4,0,0,1]=(-0.0732955000278)
        ref[4,0,1,0]=(0.0716061704803)
        ref[4,0,1,1]=(0.180127379412)
        ref[4,1,0,0]=(1.26959959862)
        ref[4,1,0,1]=(-1.38131896436)
        ref[4,1,1,0]=(0.204280361123)
        ref[4,1,1,1]=(0.532611514369)
        ref[5,0,0,0]=(0.209536293545)
        ref[5,0,0,1]=(-0.303994906788)
        ref[5,0,1,0]=(1.41150162289)
        ref[5,0,1,1]=(1.32515735407)
        ref[5,1,0,0]=(1.59736027384)
        ref[5,1,0,1]=(-0.711055564868)
        ref[5,1,1,0]=(-1.31799658024)
        ref[5,1,1,1]=(0.829209493108)
      else:
        arg[0,0,0]=(0.832267408258)*x[0]+(-1.1995239623)*x[1]+(-1.81276973398)*x[2]
        arg[0,0,1]=(-0.0125232856194)*x[0]+(0.122543918666)*x[1]+(-1.12411286836)*x[2]
        arg[0,1,0]=(0.985611388383)*x[0]+(-1.17217207383)*x[1]+(-0.231241872108)*x[2]
        arg[0,1,1]=(0.625494139449)*x[0]+(0.784802683192)*x[1]+(0.612764525973)*x[2]
        arg[1,0,0]=(0.327644975022)*x[0]+(0.0552951801276)*x[1]+(-0.806887445103)*x[2]
        arg[1,0,1]=(0.194338798022)*x[0]+(0.799902026341)*x[1]+(1.70164249741)*x[2]
        arg[1,1,0]=(0.890832636865)*x[0]+(0.223899365292)*x[1]+(-0.283094526824)*x[2]
        arg[1,1,1]=(-0.122108330088)*x[0]+(-0.293413695547)*x[1]+(-0.371581852879)*x[2]
        arg[2,0,0]=(-0.469341678297)*x[0]+(0.152856292978)*x[1]+(0.765861314481)*x[2]
        arg[2,0,1]=(0.249219162734)*x[0]+(0.319622173697)*x[1]+(-0.182998471546)*x[2]
        arg[2,1,0]=(0.39687496584)*x[0]+(0.137084411978)*x[1]+(-0.34707250854)*x[2]
        arg[2,1,1]=(-0.382391798519)*x[0]+(0.755317411547)*x[1]+(0.424204162929)*x[2]
        arg[3,0,0]=(1.12637976255)*x[0]+(0.11632178776)*x[1]+(-0.615547388072)*x[2]
        arg[3,0,1]=(-0.819303259446)*x[0]+(0.916951216368)*x[1]+(-0.572792050441)*x[2]
        arg[3,1,0]=(0.194642055711)*x[0]+(0.949663114037)*x[1]+(-0.403001914682)*x[2]
        arg[3,1,1]=(0.902547242635)*x[0]+(-1.04027936291)*x[1]+(-1.78463515221)*x[2]
        arg[4,0,0]=(0.59060036737)*x[0]+(-0.580905638676)*x[1]+(-0.486098556884)*x[2]
        arg[4,0,1]=(-0.330634605524)*x[0]+(-0.758140973629)*x[1]+(-0.192282397672)*x[2]
        arg[4,1,0]=(1.40502801336)*x[0]+(0.199036161455)*x[1]+(-0.558660947885)*x[2]
        arg[4,1,1]=(-0.155588274273)*x[0]+(-0.57050736529)*x[1]+(1.1998664442)*x[2]
        arg[5,0,0]=(-0.754680865929)*x[0]+(1.29040984028)*x[1]+(-1.83778974463)*x[2]
        arg[5,0,1]=(0.274692501647)*x[0]+(0.368546080921)*x[1]+(-0.446376269232)*x[2]
        arg[5,1,0]=(-0.758704372861)*x[0]+(1.75555227426)*x[1]+(-0.13664688871)*x[2]
        arg[5,1,1]=(-0.568468068187)*x[0]+(-0.320218561544)*x[1]+(-0.827795466031)*x[2]
        ref[0,0,0,0]=(0.832267408258)
        ref[0,0,0,1]=(-1.1995239623)
        ref[0,0,0,2]=(-1.81276973398)
        ref[0,0,1,0]=(-0.0125232856194)
        ref[0,0,1,1]=(0.122543918666)
        ref[0,0,1,2]=(-1.12411286836)
        ref[0,1,0,0]=(0.985611388383)
        ref[0,1,0,1]=(-1.17217207383)
        ref[0,1,0,2]=(-0.231241872108)
        ref[0,1,1,0]=(0.625494139449)
        ref[0,1,1,1]=(0.784802683192)
        ref[0,1,1,2]=(0.612764525973)
        ref[1,0,0,0]=(0.327644975022)
        ref[1,0,0,1]=(0.0552951801276)
        ref[1,0,0,2]=(-0.806887445103)
        ref[1,0,1,0]=(0.194338798022)
        ref[1,0,1,1]=(0.799902026341)
        ref[1,0,1,2]=(1.70164249741)
        ref[1,1,0,0]=(0.890832636865)
        ref[1,1,0,1]=(0.223899365292)
        ref[1,1,0,2]=(-0.283094526824)
        ref[1,1,1,0]=(-0.122108330088)
        ref[1,1,1,1]=(-0.293413695547)
        ref[1,1,1,2]=(-0.371581852879)
        ref[2,0,0,0]=(-0.469341678297)
        ref[2,0,0,1]=(0.152856292978)
        ref[2,0,0,2]=(0.765861314481)
        ref[2,0,1,0]=(0.249219162734)
        ref[2,0,1,1]=(0.319622173697)
        ref[2,0,1,2]=(-0.182998471546)
        ref[2,1,0,0]=(0.39687496584)
        ref[2,1,0,1]=(0.137084411978)
        ref[2,1,0,2]=(-0.34707250854)
        ref[2,1,1,0]=(-0.382391798519)
        ref[2,1,1,1]=(0.755317411547)
        ref[2,1,1,2]=(0.424204162929)
        ref[3,0,0,0]=(1.12637976255)
        ref[3,0,0,1]=(0.11632178776)
        ref[3,0,0,2]=(-0.615547388072)
        ref[3,0,1,0]=(-0.819303259446)
        ref[3,0,1,1]=(0.916951216368)
        ref[3,0,1,2]=(-0.572792050441)
        ref[3,1,0,0]=(0.194642055711)
        ref[3,1,0,1]=(0.949663114037)
        ref[3,1,0,2]=(-0.403001914682)
        ref[3,1,1,0]=(0.902547242635)
        ref[3,1,1,1]=(-1.04027936291)
        ref[3,1,1,2]=(-1.78463515221)
        ref[4,0,0,0]=(0.59060036737)
        ref[4,0,0,1]=(-0.580905638676)
        ref[4,0,0,2]=(-0.486098556884)
        ref[4,0,1,0]=(-0.330634605524)
        ref[4,0,1,1]=(-0.758140973629)
        ref[4,0,1,2]=(-0.192282397672)
        ref[4,1,0,0]=(1.40502801336)
        ref[4,1,0,1]=(0.199036161455)
        ref[4,1,0,2]=(-0.558660947885)
        ref[4,1,1,0]=(-0.155588274273)
        ref[4,1,1,1]=(-0.57050736529)
        ref[4,1,1,2]=(1.1998664442)
        ref[5,0,0,0]=(-0.754680865929)
        ref[5,0,0,1]=(1.29040984028)
        ref[5,0,0,2]=(-1.83778974463)
        ref[5,0,1,0]=(0.274692501647)
        ref[5,0,1,1]=(0.368546080921)
        ref[5,0,1,2]=(-0.446376269232)
        ref[5,1,0,0]=(-0.758704372861)
        ref[5,1,0,1]=(1.75555227426)
        ref[5,1,0,2]=(-0.13664688871)
        ref[5,1,1,0]=(-0.568468068187)
        ref[5,1,1,1]=(-0.320218561544)
        ref[5,1,1,2]=(-0.827795466031)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnContactZero_fromData_ContinuousFunction_rank0(self):
      """
      tests gradient for rank 0 Data on the ReducedFunctionOnContactZero

      assumptions: ContinuousFunction(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnContactZero
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=ContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(),w)
      ref=Data(0,()+(dim,),w_ref)
      if dim==2:
        arg=(-0.447987377779)*x[0]**o+(-0.3185298109)*x[0]+(0.748689324197)*x[1]**o+(-0.979369398128)*x[1]
        ref[0]=o*(-0.447987377779)*x_ref[0]**(o-1)+(-0.3185298109)
        ref[1]=o*(0.748689324197)*x_ref[1]**(o-1)+(-0.979369398128)
      else:
        arg=(-0.991175677257)*x[0]**o+(0.486310659385)*x[0]+(0.366862476014)*x[1]**o+(0.718311286349)*x[1]+(-0.593137377946)*x[2]**o+(-0.98259729892)*x[2]
        ref[0]=o*(-0.991175677257)*x_ref[0]**(o-1)+(0.486310659385)
        ref[1]=o*(0.366862476014)*x_ref[1]**(o-1)+(0.718311286349)
        ref[2]=o*(-0.593137377946)*x_ref[2]**(o-1)+(-0.98259729892)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),()+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnContactZero_fromData_ContinuousFunction_rank1(self):
      """
      tests gradient for rank 1 Data on the ReducedFunctionOnContactZero

      assumptions: ContinuousFunction(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnContactZero
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=ContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(2,),w)
      ref=Data(0,(2,)+(dim,),w_ref)
      if dim==2:
        arg[0]=(0.532427358862)*x[0]**o+(-0.699829406888)*x[0]+(-0.378181075858)*x[1]**o+(-0.163897932934)*x[1]
        arg[1]=(0.76393225396)*x[0]**o+(0.87331212216)*x[0]+(0.0261520274749)*x[1]**o+(-0.475078274702)*x[1]
        ref[0,0]=o*(0.532427358862)*x_ref[0]**(o-1)+(-0.699829406888)
        ref[0,1]=o*(-0.378181075858)*x_ref[1]**(o-1)+(-0.163897932934)
        ref[1,0]=o*(0.76393225396)*x_ref[0]**(o-1)+(0.87331212216)
        ref[1,1]=o*(0.0261520274749)*x_ref[1]**(o-1)+(-0.475078274702)
      else:
        arg[0]=(-0.559640148983)*x[0]**o+(0.868360358061)*x[0]+(0.148807680806)*x[1]**o+(-0.488426629736)*x[1]+(0.99381766343)*x[2]**o+(-0.0241703848022)*x[2]
        arg[1]=(-0.00270447073555)*x[0]**o+(0.599732416474)*x[0]+(-0.455449579349)*x[1]**o+(-0.791088816655)*x[1]+(0.850362671968)*x[2]**o+(-0.180726138889)*x[2]
        ref[0,0]=o*(-0.559640148983)*x_ref[0]**(o-1)+(0.868360358061)
        ref[0,1]=o*(0.148807680806)*x_ref[1]**(o-1)+(-0.488426629736)
        ref[0,2]=o*(0.99381766343)*x_ref[2]**(o-1)+(-0.0241703848022)
        ref[1,0]=o*(-0.00270447073555)*x_ref[0]**(o-1)+(0.599732416474)
        ref[1,1]=o*(-0.455449579349)*x_ref[1]**(o-1)+(-0.791088816655)
        ref[1,2]=o*(0.850362671968)*x_ref[2]**(o-1)+(-0.180726138889)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnContactZero_fromData_ContinuousFunction_rank2(self):
      """
      tests gradient for rank 2 Data on the ReducedFunctionOnContactZero

      assumptions: ContinuousFunction(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnContactZero
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=ContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(4, 5),w)
      ref=Data(0,(4, 5)+(dim,),w_ref)
      if dim==2:
        arg[0,0]=(0.157399152858)*x[0]**o+(0.00598352783814)*x[0]+(-0.904853822462)*x[1]**o+(0.767645769461)*x[1]
        arg[0,1]=(0.764556091331)*x[0]**o+(-0.167733604181)*x[0]+(0.723254547109)*x[1]**o+(-0.863633737324)*x[1]
        arg[0,2]=(0.480913138549)*x[0]**o+(0.505712705322)*x[0]+(-0.295398027463)*x[1]**o+(-0.0497846093953)*x[1]
        arg[0,3]=(-0.957208239652)*x[0]**o+(0.608346818502)*x[0]+(-0.194623401251)*x[1]**o+(0.670671588806)*x[1]
        arg[0,4]=(-0.179165159786)*x[0]**o+(-0.146090255471)*x[0]+(-0.413009197676)*x[1]**o+(-0.168508218849)*x[1]
        arg[1,0]=(0.659914628278)*x[0]**o+(0.123177996909)*x[0]+(0.713971230628)*x[1]**o+(-0.687569461154)*x[1]
        arg[1,1]=(0.857554477911)*x[0]**o+(0.119604916634)*x[0]+(-0.123185856515)*x[1]**o+(0.968800869965)*x[1]
        arg[1,2]=(0.566596883167)*x[0]**o+(-0.667227639224)*x[0]+(0.29838343622)*x[1]**o+(0.0172896834006)*x[1]
        arg[1,3]=(0.340418732306)*x[0]**o+(-0.115031635126)*x[0]+(0.212495048781)*x[1]**o+(-0.690939141829)*x[1]
        arg[1,4]=(-0.513225187356)*x[0]**o+(0.975159534619)*x[0]+(0.159694719764)*x[1]**o+(-0.441973185517)*x[1]
        arg[2,0]=(0.00598247134499)*x[0]**o+(-0.680866157243)*x[0]+(0.198740044836)*x[1]**o+(-0.776778848701)*x[1]
        arg[2,1]=(0.385572341196)*x[0]**o+(-0.911229388405)*x[0]+(-0.869563350649)*x[1]**o+(-0.453073292811)*x[1]
        arg[2,2]=(-0.678405510051)*x[0]**o+(0.570159849365)*x[0]+(-0.998909274112)*x[1]**o+(-0.56867397999)*x[1]
        arg[2,3]=(0.592650344218)*x[0]**o+(-0.990760992864)*x[0]+(0.54832364584)*x[1]**o+(-0.62848423403)*x[1]
        arg[2,4]=(-0.267222595774)*x[0]**o+(-0.398631721649)*x[0]+(-0.139351142788)*x[1]**o+(-0.973211734322)*x[1]
        arg[3,0]=(-0.748270220449)*x[0]**o+(-0.432648285296)*x[0]+(-0.572322019432)*x[1]**o+(-0.361258377472)*x[1]
        arg[3,1]=(-0.872970937458)*x[0]**o+(-0.412714429527)*x[0]+(0.28965384698)*x[1]**o+(0.0899128505144)*x[1]
        arg[3,2]=(-0.448552675711)*x[0]**o+(-0.0531593149976)*x[0]+(-0.445359129375)*x[1]**o+(-0.357551800127)*x[1]
        arg[3,3]=(-0.120676057603)*x[0]**o+(-0.736959379114)*x[0]+(-0.437089829553)*x[1]**o+(-0.272117257464)*x[1]
        arg[3,4]=(0.342279309395)*x[0]**o+(0.182206506048)*x[0]+(0.843948330758)*x[1]**o+(0.165354303251)*x[1]
        ref[0,0,0]=o*(0.157399152858)*x_ref[0]**(o-1)+(0.00598352783814)
        ref[0,0,1]=o*(-0.904853822462)*x_ref[1]**(o-1)+(0.767645769461)
        ref[0,1,0]=o*(0.764556091331)*x_ref[0]**(o-1)+(-0.167733604181)
        ref[0,1,1]=o*(0.723254547109)*x_ref[1]**(o-1)+(-0.863633737324)
        ref[0,2,0]=o*(0.480913138549)*x_ref[0]**(o-1)+(0.505712705322)
        ref[0,2,1]=o*(-0.295398027463)*x_ref[1]**(o-1)+(-0.0497846093953)
        ref[0,3,0]=o*(-0.957208239652)*x_ref[0]**(o-1)+(0.608346818502)
        ref[0,3,1]=o*(-0.194623401251)*x_ref[1]**(o-1)+(0.670671588806)
        ref[0,4,0]=o*(-0.179165159786)*x_ref[0]**(o-1)+(-0.146090255471)
        ref[0,4,1]=o*(-0.413009197676)*x_ref[1]**(o-1)+(-0.168508218849)
        ref[1,0,0]=o*(0.659914628278)*x_ref[0]**(o-1)+(0.123177996909)
        ref[1,0,1]=o*(0.713971230628)*x_ref[1]**(o-1)+(-0.687569461154)
        ref[1,1,0]=o*(0.857554477911)*x_ref[0]**(o-1)+(0.119604916634)
        ref[1,1,1]=o*(-0.123185856515)*x_ref[1]**(o-1)+(0.968800869965)
        ref[1,2,0]=o*(0.566596883167)*x_ref[0]**(o-1)+(-0.667227639224)
        ref[1,2,1]=o*(0.29838343622)*x_ref[1]**(o-1)+(0.0172896834006)
        ref[1,3,0]=o*(0.340418732306)*x_ref[0]**(o-1)+(-0.115031635126)
        ref[1,3,1]=o*(0.212495048781)*x_ref[1]**(o-1)+(-0.690939141829)
        ref[1,4,0]=o*(-0.513225187356)*x_ref[0]**(o-1)+(0.975159534619)
        ref[1,4,1]=o*(0.159694719764)*x_ref[1]**(o-1)+(-0.441973185517)
        ref[2,0,0]=o*(0.00598247134499)*x_ref[0]**(o-1)+(-0.680866157243)
        ref[2,0,1]=o*(0.198740044836)*x_ref[1]**(o-1)+(-0.776778848701)
        ref[2,1,0]=o*(0.385572341196)*x_ref[0]**(o-1)+(-0.911229388405)
        ref[2,1,1]=o*(-0.869563350649)*x_ref[1]**(o-1)+(-0.453073292811)
        ref[2,2,0]=o*(-0.678405510051)*x_ref[0]**(o-1)+(0.570159849365)
        ref[2,2,1]=o*(-0.998909274112)*x_ref[1]**(o-1)+(-0.56867397999)
        ref[2,3,0]=o*(0.592650344218)*x_ref[0]**(o-1)+(-0.990760992864)
        ref[2,3,1]=o*(0.54832364584)*x_ref[1]**(o-1)+(-0.62848423403)
        ref[2,4,0]=o*(-0.267222595774)*x_ref[0]**(o-1)+(-0.398631721649)
        ref[2,4,1]=o*(-0.139351142788)*x_ref[1]**(o-1)+(-0.973211734322)
        ref[3,0,0]=o*(-0.748270220449)*x_ref[0]**(o-1)+(-0.432648285296)
        ref[3,0,1]=o*(-0.572322019432)*x_ref[1]**(o-1)+(-0.361258377472)
        ref[3,1,0]=o*(-0.872970937458)*x_ref[0]**(o-1)+(-0.412714429527)
        ref[3,1,1]=o*(0.28965384698)*x_ref[1]**(o-1)+(0.0899128505144)
        ref[3,2,0]=o*(-0.448552675711)*x_ref[0]**(o-1)+(-0.0531593149976)
        ref[3,2,1]=o*(-0.445359129375)*x_ref[1]**(o-1)+(-0.357551800127)
        ref[3,3,0]=o*(-0.120676057603)*x_ref[0]**(o-1)+(-0.736959379114)
        ref[3,3,1]=o*(-0.437089829553)*x_ref[1]**(o-1)+(-0.272117257464)
        ref[3,4,0]=o*(0.342279309395)*x_ref[0]**(o-1)+(0.182206506048)
        ref[3,4,1]=o*(0.843948330758)*x_ref[1]**(o-1)+(0.165354303251)
      else:
        arg[0,0]=(-0.912611504385)*x[0]**o+(0.730660242466)*x[0]+(-0.807306513948)*x[1]**o+(-0.611619910819)*x[1]+(-0.567616988907)*x[2]**o+(0.554411283236)*x[2]
        arg[0,1]=(-0.900956431107)*x[0]**o+(-0.731441474835)*x[0]+(0.366905510731)*x[1]**o+(0.444763254457)*x[1]+(0.223337203463)*x[2]**o+(0.0823258304577)*x[2]
        arg[0,2]=(-0.300262400629)*x[0]**o+(0.781835992318)*x[0]+(-0.961025746467)*x[1]**o+(-0.0255420888548)*x[1]+(-0.195336914392)*x[2]**o+(0.631006440014)*x[2]
        arg[0,3]=(-0.0362225627667)*x[0]**o+(-0.258309391935)*x[0]+(0.915114590957)*x[1]**o+(-0.0261151730116)*x[1]+(-0.0359136191693)*x[2]**o+(0.34837541797)*x[2]
        arg[0,4]=(0.718483283111)*x[0]**o+(-0.981945434022)*x[0]+(0.715616160215)*x[1]**o+(-0.213673997408)*x[1]+(0.703864386687)*x[2]**o+(-0.258970624794)*x[2]
        arg[1,0]=(0.562339421788)*x[0]**o+(-0.469800316995)*x[0]+(-0.58860202695)*x[1]**o+(0.592493291759)*x[1]+(-0.0747446509827)*x[2]**o+(0.459846703357)*x[2]
        arg[1,1]=(-0.739792007188)*x[0]**o+(0.69804646711)*x[0]+(0.685574577582)*x[1]**o+(0.34906822136)*x[1]+(-0.346626103556)*x[2]**o+(-0.186290616908)*x[2]
        arg[1,2]=(0.605479936712)*x[0]**o+(0.23811484281)*x[0]+(-0.18270059933)*x[1]**o+(-0.883573478283)*x[1]+(0.558417469124)*x[2]**o+(0.0921284647122)*x[2]
        arg[1,3]=(0.829453952054)*x[0]**o+(0.0943225421949)*x[0]+(-0.377472410614)*x[1]**o+(0.422596289908)*x[1]+(0.992700203574)*x[2]**o+(0.954704595957)*x[2]
        arg[1,4]=(0.713437745608)*x[0]**o+(-0.90755469394)*x[0]+(-0.116969245983)*x[1]**o+(-0.615609779318)*x[1]+(-0.631014272933)*x[2]**o+(0.196556707186)*x[2]
        arg[2,0]=(-0.643142569205)*x[0]**o+(-0.522571508238)*x[0]+(-0.221094875426)*x[1]**o+(0.00263621704394)*x[1]+(-0.346088170378)*x[2]**o+(-0.323346603492)*x[2]
        arg[2,1]=(0.121192120404)*x[0]**o+(-0.910581465748)*x[0]+(0.661403514322)*x[1]**o+(0.314356472557)*x[1]+(0.740349932503)*x[2]**o+(0.397923840477)*x[2]
        arg[2,2]=(0.712887835251)*x[0]**o+(0.802827824977)*x[0]+(0.225275507294)*x[1]**o+(0.00655056099106)*x[1]+(-0.0211189465513)*x[2]**o+(-0.672450969446)*x[2]
        arg[2,3]=(0.220976204507)*x[0]**o+(0.384529933174)*x[0]+(-0.824967564367)*x[1]**o+(0.382079183434)*x[1]+(0.975192346085)*x[2]**o+(-0.845325222223)*x[2]
        arg[2,4]=(-0.316551069119)*x[0]**o+(0.194934627874)*x[0]+(0.192096230967)*x[1]**o+(-0.423775967466)*x[1]+(-0.669140845203)*x[2]**o+(0.367813824992)*x[2]
        arg[3,0]=(-0.361410077778)*x[0]**o+(0.377521588398)*x[0]+(-0.795093364568)*x[1]**o+(0.475257686757)*x[1]+(-0.996619080341)*x[2]**o+(-0.909105543506)*x[2]
        arg[3,1]=(-0.324100979259)*x[0]**o+(-0.950807456193)*x[0]+(-0.141687301441)*x[1]**o+(0.153568029515)*x[1]+(-0.698514966417)*x[2]**o+(0.312395968777)*x[2]
        arg[3,2]=(-0.997783460035)*x[0]**o+(0.328724967881)*x[0]+(-0.561572087716)*x[1]**o+(-0.0148890799876)*x[1]+(0.236142454998)*x[2]**o+(-0.36513107554)*x[2]
        arg[3,3]=(0.750818510719)*x[0]**o+(-0.484598204959)*x[0]+(-0.599436804638)*x[1]**o+(-0.236232976078)*x[1]+(-0.0789148183785)*x[2]**o+(-0.74437164566)*x[2]
        arg[3,4]=(-0.730664688591)*x[0]**o+(-0.94753100979)*x[0]+(-0.671463334034)*x[1]**o+(-0.139992464354)*x[1]+(0.286757519111)*x[2]**o+(0.512453551537)*x[2]
        ref[0,0,0]=o*(-0.912611504385)*x_ref[0]**(o-1)+(0.730660242466)
        ref[0,0,1]=o*(-0.807306513948)*x_ref[1]**(o-1)+(-0.611619910819)
        ref[0,0,2]=o*(-0.567616988907)*x_ref[2]**(o-1)+(0.554411283236)
        ref[0,1,0]=o*(-0.900956431107)*x_ref[0]**(o-1)+(-0.731441474835)
        ref[0,1,1]=o*(0.366905510731)*x_ref[1]**(o-1)+(0.444763254457)
        ref[0,1,2]=o*(0.223337203463)*x_ref[2]**(o-1)+(0.0823258304577)
        ref[0,2,0]=o*(-0.300262400629)*x_ref[0]**(o-1)+(0.781835992318)
        ref[0,2,1]=o*(-0.961025746467)*x_ref[1]**(o-1)+(-0.0255420888548)
        ref[0,2,2]=o*(-0.195336914392)*x_ref[2]**(o-1)+(0.631006440014)
        ref[0,3,0]=o*(-0.0362225627667)*x_ref[0]**(o-1)+(-0.258309391935)
        ref[0,3,1]=o*(0.915114590957)*x_ref[1]**(o-1)+(-0.0261151730116)
        ref[0,3,2]=o*(-0.0359136191693)*x_ref[2]**(o-1)+(0.34837541797)
        ref[0,4,0]=o*(0.718483283111)*x_ref[0]**(o-1)+(-0.981945434022)
        ref[0,4,1]=o*(0.715616160215)*x_ref[1]**(o-1)+(-0.213673997408)
        ref[0,4,2]=o*(0.703864386687)*x_ref[2]**(o-1)+(-0.258970624794)
        ref[1,0,0]=o*(0.562339421788)*x_ref[0]**(o-1)+(-0.469800316995)
        ref[1,0,1]=o*(-0.58860202695)*x_ref[1]**(o-1)+(0.592493291759)
        ref[1,0,2]=o*(-0.0747446509827)*x_ref[2]**(o-1)+(0.459846703357)
        ref[1,1,0]=o*(-0.739792007188)*x_ref[0]**(o-1)+(0.69804646711)
        ref[1,1,1]=o*(0.685574577582)*x_ref[1]**(o-1)+(0.34906822136)
        ref[1,1,2]=o*(-0.346626103556)*x_ref[2]**(o-1)+(-0.186290616908)
        ref[1,2,0]=o*(0.605479936712)*x_ref[0]**(o-1)+(0.23811484281)
        ref[1,2,1]=o*(-0.18270059933)*x_ref[1]**(o-1)+(-0.883573478283)
        ref[1,2,2]=o*(0.558417469124)*x_ref[2]**(o-1)+(0.0921284647122)
        ref[1,3,0]=o*(0.829453952054)*x_ref[0]**(o-1)+(0.0943225421949)
        ref[1,3,1]=o*(-0.377472410614)*x_ref[1]**(o-1)+(0.422596289908)
        ref[1,3,2]=o*(0.992700203574)*x_ref[2]**(o-1)+(0.954704595957)
        ref[1,4,0]=o*(0.713437745608)*x_ref[0]**(o-1)+(-0.90755469394)
        ref[1,4,1]=o*(-0.116969245983)*x_ref[1]**(o-1)+(-0.615609779318)
        ref[1,4,2]=o*(-0.631014272933)*x_ref[2]**(o-1)+(0.196556707186)
        ref[2,0,0]=o*(-0.643142569205)*x_ref[0]**(o-1)+(-0.522571508238)
        ref[2,0,1]=o*(-0.221094875426)*x_ref[1]**(o-1)+(0.00263621704394)
        ref[2,0,2]=o*(-0.346088170378)*x_ref[2]**(o-1)+(-0.323346603492)
        ref[2,1,0]=o*(0.121192120404)*x_ref[0]**(o-1)+(-0.910581465748)
        ref[2,1,1]=o*(0.661403514322)*x_ref[1]**(o-1)+(0.314356472557)
        ref[2,1,2]=o*(0.740349932503)*x_ref[2]**(o-1)+(0.397923840477)
        ref[2,2,0]=o*(0.712887835251)*x_ref[0]**(o-1)+(0.802827824977)
        ref[2,2,1]=o*(0.225275507294)*x_ref[1]**(o-1)+(0.00655056099106)
        ref[2,2,2]=o*(-0.0211189465513)*x_ref[2]**(o-1)+(-0.672450969446)
        ref[2,3,0]=o*(0.220976204507)*x_ref[0]**(o-1)+(0.384529933174)
        ref[2,3,1]=o*(-0.824967564367)*x_ref[1]**(o-1)+(0.382079183434)
        ref[2,3,2]=o*(0.975192346085)*x_ref[2]**(o-1)+(-0.845325222223)
        ref[2,4,0]=o*(-0.316551069119)*x_ref[0]**(o-1)+(0.194934627874)
        ref[2,4,1]=o*(0.192096230967)*x_ref[1]**(o-1)+(-0.423775967466)
        ref[2,4,2]=o*(-0.669140845203)*x_ref[2]**(o-1)+(0.367813824992)
        ref[3,0,0]=o*(-0.361410077778)*x_ref[0]**(o-1)+(0.377521588398)
        ref[3,0,1]=o*(-0.795093364568)*x_ref[1]**(o-1)+(0.475257686757)
        ref[3,0,2]=o*(-0.996619080341)*x_ref[2]**(o-1)+(-0.909105543506)
        ref[3,1,0]=o*(-0.324100979259)*x_ref[0]**(o-1)+(-0.950807456193)
        ref[3,1,1]=o*(-0.141687301441)*x_ref[1]**(o-1)+(0.153568029515)
        ref[3,1,2]=o*(-0.698514966417)*x_ref[2]**(o-1)+(0.312395968777)
        ref[3,2,0]=o*(-0.997783460035)*x_ref[0]**(o-1)+(0.328724967881)
        ref[3,2,1]=o*(-0.561572087716)*x_ref[1]**(o-1)+(-0.0148890799876)
        ref[3,2,2]=o*(0.236142454998)*x_ref[2]**(o-1)+(-0.36513107554)
        ref[3,3,0]=o*(0.750818510719)*x_ref[0]**(o-1)+(-0.484598204959)
        ref[3,3,1]=o*(-0.599436804638)*x_ref[1]**(o-1)+(-0.236232976078)
        ref[3,3,2]=o*(-0.0789148183785)*x_ref[2]**(o-1)+(-0.74437164566)
        ref[3,4,0]=o*(-0.730664688591)*x_ref[0]**(o-1)+(-0.94753100979)
        ref[3,4,1]=o*(-0.671463334034)*x_ref[1]**(o-1)+(-0.139992464354)
        ref[3,4,2]=o*(0.286757519111)*x_ref[2]**(o-1)+(0.512453551537)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnContactZero_fromData_ContinuousFunction_rank3(self):
      """
      tests gradient for rank 3 Data on the ReducedFunctionOnContactZero

      assumptions: ContinuousFunction(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnContactZero
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=ContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(6, 2, 2),w)
      ref=Data(0,(6, 2, 2)+(dim,),w_ref)
      if dim==2:
        arg[0,0,0]=(0.467597203998)*x[0]**o+(-0.878331243959)*x[0]+(-0.971530784104)*x[1]**o+(0.685854853102)*x[1]
        arg[0,0,1]=(0.291345615954)*x[0]**o+(-0.745469654319)*x[0]+(0.976621664002)*x[1]**o+(-0.881452217847)*x[1]
        arg[0,1,0]=(0.537843295475)*x[0]**o+(0.489619951145)*x[0]+(0.77330251637)*x[1]**o+(0.998031266089)*x[1]
        arg[0,1,1]=(0.355984068681)*x[0]**o+(-0.814720548776)*x[0]+(0.495564264626)*x[1]**o+(0.525926194911)*x[1]
        arg[1,0,0]=(0.0459062782507)*x[0]**o+(0.745363380399)*x[0]+(0.254962338793)*x[1]**o+(-0.818268107226)*x[1]
        arg[1,0,1]=(0.806972777032)*x[0]**o+(0.65759411882)*x[0]+(-0.714015350868)*x[1]**o+(0.785611067194)*x[1]
        arg[1,1,0]=(0.576206375389)*x[0]**o+(-0.502513595266)*x[0]+(0.258287392463)*x[1]**o+(0.0897418205816)*x[1]
        arg[1,1,1]=(-0.854645709831)*x[0]**o+(0.48910569315)*x[0]+(0.684503579045)*x[1]**o+(0.156890859871)*x[1]
        arg[2,0,0]=(-0.535650648427)*x[0]**o+(-0.189186476574)*x[0]+(-0.62891575537)*x[1]**o+(-0.37603690255)*x[1]
        arg[2,0,1]=(-0.153001902814)*x[0]**o+(0.028214773063)*x[0]+(-0.605102549169)*x[1]**o+(-0.566991398262)*x[1]
        arg[2,1,0]=(0.607976055886)*x[0]**o+(-0.247395663109)*x[0]+(0.424340230656)*x[1]**o+(0.210489427749)*x[1]
        arg[2,1,1]=(-0.513543937157)*x[0]**o+(0.345931529219)*x[0]+(0.893744279358)*x[1]**o+(-0.519602594857)*x[1]
        arg[3,0,0]=(-0.618812192169)*x[0]**o+(-0.897898654184)*x[0]+(-0.717700928924)*x[1]**o+(-0.21348885325)*x[1]
        arg[3,0,1]=(-0.582829504396)*x[0]**o+(-0.0726162868757)*x[0]+(0.366457797377)*x[1]**o+(0.479006714526)*x[1]
        arg[3,1,0]=(0.929143108169)*x[0]**o+(-0.302254589362)*x[0]+(-0.518817476772)*x[1]**o+(0.854860903894)*x[1]
        arg[3,1,1]=(-0.815422381361)*x[0]**o+(-0.183407261786)*x[0]+(0.841334455272)*x[1]**o+(-0.560841747647)*x[1]
        arg[4,0,0]=(0.746229089137)*x[0]**o+(-0.00173525360161)*x[0]+(0.729473923491)*x[1]**o+(-0.0152936558265)*x[1]
        arg[4,0,1]=(-0.0474071267025)*x[0]**o+(-0.380505263812)*x[0]+(0.166181839511)*x[1]**o+(-0.421069915995)*x[1]
        arg[4,1,0]=(-0.826801927705)*x[0]**o+(0.704799677183)*x[0]+(-0.0346961982898)*x[1]**o+(-0.401235214163)*x[1]
        arg[4,1,1]=(-0.973646144788)*x[0]**o+(0.469976655077)*x[0]+(-0.458846284633)*x[1]**o+(0.818397008807)*x[1]
        arg[5,0,0]=(0.155460716472)*x[0]**o+(-0.509095443426)*x[0]+(-0.0942934981524)*x[1]**o+(0.754087972651)*x[1]
        arg[5,0,1]=(-0.584172835053)*x[0]**o+(-0.904579020559)*x[0]+(0.156301832106)*x[1]**o+(0.169995805721)*x[1]
        arg[5,1,0]=(-0.424977437614)*x[0]**o+(0.244566550647)*x[0]+(-0.474400097866)*x[1]**o+(-0.315912223349)*x[1]
        arg[5,1,1]=(0.764961378837)*x[0]**o+(-0.83633430067)*x[0]+(-0.446378328981)*x[1]**o+(-0.278460992776)*x[1]
        ref[0,0,0,0]=o*(0.467597203998)*x_ref[0]**(o-1)+(-0.878331243959)
        ref[0,0,0,1]=o*(-0.971530784104)*x_ref[1]**(o-1)+(0.685854853102)
        ref[0,0,1,0]=o*(0.291345615954)*x_ref[0]**(o-1)+(-0.745469654319)
        ref[0,0,1,1]=o*(0.976621664002)*x_ref[1]**(o-1)+(-0.881452217847)
        ref[0,1,0,0]=o*(0.537843295475)*x_ref[0]**(o-1)+(0.489619951145)
        ref[0,1,0,1]=o*(0.77330251637)*x_ref[1]**(o-1)+(0.998031266089)
        ref[0,1,1,0]=o*(0.355984068681)*x_ref[0]**(o-1)+(-0.814720548776)
        ref[0,1,1,1]=o*(0.495564264626)*x_ref[1]**(o-1)+(0.525926194911)
        ref[1,0,0,0]=o*(0.0459062782507)*x_ref[0]**(o-1)+(0.745363380399)
        ref[1,0,0,1]=o*(0.254962338793)*x_ref[1]**(o-1)+(-0.818268107226)
        ref[1,0,1,0]=o*(0.806972777032)*x_ref[0]**(o-1)+(0.65759411882)
        ref[1,0,1,1]=o*(-0.714015350868)*x_ref[1]**(o-1)+(0.785611067194)
        ref[1,1,0,0]=o*(0.576206375389)*x_ref[0]**(o-1)+(-0.502513595266)
        ref[1,1,0,1]=o*(0.258287392463)*x_ref[1]**(o-1)+(0.0897418205816)
        ref[1,1,1,0]=o*(-0.854645709831)*x_ref[0]**(o-1)+(0.48910569315)
        ref[1,1,1,1]=o*(0.684503579045)*x_ref[1]**(o-1)+(0.156890859871)
        ref[2,0,0,0]=o*(-0.535650648427)*x_ref[0]**(o-1)+(-0.189186476574)
        ref[2,0,0,1]=o*(-0.62891575537)*x_ref[1]**(o-1)+(-0.37603690255)
        ref[2,0,1,0]=o*(-0.153001902814)*x_ref[0]**(o-1)+(0.028214773063)
        ref[2,0,1,1]=o*(-0.605102549169)*x_ref[1]**(o-1)+(-0.566991398262)
        ref[2,1,0,0]=o*(0.607976055886)*x_ref[0]**(o-1)+(-0.247395663109)
        ref[2,1,0,1]=o*(0.424340230656)*x_ref[1]**(o-1)+(0.210489427749)
        ref[2,1,1,0]=o*(-0.513543937157)*x_ref[0]**(o-1)+(0.345931529219)
        ref[2,1,1,1]=o*(0.893744279358)*x_ref[1]**(o-1)+(-0.519602594857)
        ref[3,0,0,0]=o*(-0.618812192169)*x_ref[0]**(o-1)+(-0.897898654184)
        ref[3,0,0,1]=o*(-0.717700928924)*x_ref[1]**(o-1)+(-0.21348885325)
        ref[3,0,1,0]=o*(-0.582829504396)*x_ref[0]**(o-1)+(-0.0726162868757)
        ref[3,0,1,1]=o*(0.366457797377)*x_ref[1]**(o-1)+(0.479006714526)
        ref[3,1,0,0]=o*(0.929143108169)*x_ref[0]**(o-1)+(-0.302254589362)
        ref[3,1,0,1]=o*(-0.518817476772)*x_ref[1]**(o-1)+(0.854860903894)
        ref[3,1,1,0]=o*(-0.815422381361)*x_ref[0]**(o-1)+(-0.183407261786)
        ref[3,1,1,1]=o*(0.841334455272)*x_ref[1]**(o-1)+(-0.560841747647)
        ref[4,0,0,0]=o*(0.746229089137)*x_ref[0]**(o-1)+(-0.00173525360161)
        ref[4,0,0,1]=o*(0.729473923491)*x_ref[1]**(o-1)+(-0.0152936558265)
        ref[4,0,1,0]=o*(-0.0474071267025)*x_ref[0]**(o-1)+(-0.380505263812)
        ref[4,0,1,1]=o*(0.166181839511)*x_ref[1]**(o-1)+(-0.421069915995)
        ref[4,1,0,0]=o*(-0.826801927705)*x_ref[0]**(o-1)+(0.704799677183)
        ref[4,1,0,1]=o*(-0.0346961982898)*x_ref[1]**(o-1)+(-0.401235214163)
        ref[4,1,1,0]=o*(-0.973646144788)*x_ref[0]**(o-1)+(0.469976655077)
        ref[4,1,1,1]=o*(-0.458846284633)*x_ref[1]**(o-1)+(0.818397008807)
        ref[5,0,0,0]=o*(0.155460716472)*x_ref[0]**(o-1)+(-0.509095443426)
        ref[5,0,0,1]=o*(-0.0942934981524)*x_ref[1]**(o-1)+(0.754087972651)
        ref[5,0,1,0]=o*(-0.584172835053)*x_ref[0]**(o-1)+(-0.904579020559)
        ref[5,0,1,1]=o*(0.156301832106)*x_ref[1]**(o-1)+(0.169995805721)
        ref[5,1,0,0]=o*(-0.424977437614)*x_ref[0]**(o-1)+(0.244566550647)
        ref[5,1,0,1]=o*(-0.474400097866)*x_ref[1]**(o-1)+(-0.315912223349)
        ref[5,1,1,0]=o*(0.764961378837)*x_ref[0]**(o-1)+(-0.83633430067)
        ref[5,1,1,1]=o*(-0.446378328981)*x_ref[1]**(o-1)+(-0.278460992776)
      else:
        arg[0,0,0]=(0.723756735151)*x[0]**o+(0.738121670547)*x[0]+(0.384835073242)*x[1]**o+(-0.997944909714)*x[1]+(0.271533052097)*x[2]**o+(-0.667680363953)*x[2]
        arg[0,0,1]=(-0.279804914835)*x[0]**o+(0.789671404386)*x[0]+(-0.823187173328)*x[1]**o+(-0.0126377581755)*x[1]+(-0.942836469998)*x[2]**o+(0.416417451133)*x[2]
        arg[0,1,0]=(-0.69035514237)*x[0]**o+(0.388349204037)*x[0]+(0.807201832597)*x[1]**o+(-0.969007115064)*x[1]+(0.280506744137)*x[2]**o+(0.228554540968)*x[2]
        arg[0,1,1]=(0.893542584763)*x[0]**o+(-0.755974692532)*x[0]+(0.675321004205)*x[1]**o+(0.670278291297)*x[1]+(0.92092687885)*x[2]**o+(-0.516288388724)*x[2]
        arg[1,0,0]=(0.503764409596)*x[0]**o+(-0.39410032918)*x[0]+(0.532408717712)*x[1]**o+(0.0658355614843)*x[1]+(-0.533534889451)*x[2]**o+(0.846333211477)*x[2]
        arg[1,0,1]=(0.520531780859)*x[0]**o+(0.869039672332)*x[0]+(-0.706342144586)*x[1]**o+(0.0665768341658)*x[1]+(-0.909079295867)*x[2]**o+(-0.34153327843)*x[2]
        arg[1,1,0]=(-0.873546169914)*x[0]**o+(-0.554907283387)*x[0]+(-0.0560665557101)*x[1]**o+(0.436703623389)*x[1]+(0.730437022736)*x[2]**o+(0.100904171105)*x[2]
        arg[1,1,1]=(0.845958886681)*x[0]**o+(0.376444128389)*x[0]+(-0.393744308499)*x[1]**o+(-0.0940537397734)*x[1]+(0.178796464778)*x[2]**o+(-0.584448595407)*x[2]
        arg[2,0,0]=(0.000704382305339)*x[0]**o+(-0.836800712787)*x[0]+(0.671931504433)*x[1]**o+(0.263280364406)*x[1]+(-0.746980015754)*x[2]**o+(-0.985058787575)*x[2]
        arg[2,0,1]=(-0.540690929008)*x[0]**o+(0.656899216804)*x[0]+(-0.608036845804)*x[1]**o+(0.224943400248)*x[1]+(-0.312449005326)*x[2]**o+(-0.621458231634)*x[2]
        arg[2,1,0]=(0.440432866893)*x[0]**o+(0.972046189647)*x[0]+(0.060785199375)*x[1]**o+(0.304756432986)*x[1]+(-0.473510049103)*x[2]**o+(0.3707166351)*x[2]
        arg[2,1,1]=(0.96344472567)*x[0]**o+(-0.153932665404)*x[0]+(-0.43646142206)*x[1]**o+(0.4838463484)*x[1]+(0.613286612579)*x[2]**o+(0.84521461472)*x[2]
        arg[3,0,0]=(0.65147393118)*x[0]**o+(-0.886665762467)*x[0]+(-0.266000665973)*x[1]**o+(0.897979405808)*x[1]+(0.699333158084)*x[2]**o+(-0.460865970247)*x[2]
        arg[3,0,1]=(0.870253308112)*x[0]**o+(-0.248736315721)*x[0]+(-0.816719773596)*x[1]**o+(-0.89378202899)*x[1]+(0.524350309915)*x[2]**o+(0.107325872954)*x[2]
        arg[3,1,0]=(-0.152250686624)*x[0]**o+(-0.89784066484)*x[0]+(-0.327207891694)*x[1]**o+(0.346548492907)*x[1]+(0.409288642845)*x[2]**o+(-0.627349664194)*x[2]
        arg[3,1,1]=(0.398337202036)*x[0]**o+(0.307156588584)*x[0]+(0.0567088869624)*x[1]**o+(-0.132313990308)*x[1]+(-0.361821356587)*x[2]**o+(0.913518325149)*x[2]
        arg[4,0,0]=(0.184289428296)*x[0]**o+(0.138095407277)*x[0]+(0.514405012603)*x[1]**o+(0.590757249119)*x[1]+(-0.984116206238)*x[2]**o+(-0.176561783123)*x[2]
        arg[4,0,1]=(-0.804189448075)*x[0]**o+(0.662750787102)*x[0]+(0.361634380444)*x[1]**o+(-0.682665313256)*x[1]+(-0.0738989964344)*x[2]**o+(0.8870747144)*x[2]
        arg[4,1,0]=(-0.28290153618)*x[0]**o+(-0.942107675992)*x[0]+(0.308140792703)*x[1]**o+(0.686659531002)*x[1]+(0.789553636322)*x[2]**o+(0.587377542884)*x[2]
        arg[4,1,1]=(0.6137979501)*x[0]**o+(-0.564031937362)*x[0]+(-0.116407590432)*x[1]**o+(-0.119100735459)*x[1]+(0.673631378916)*x[2]**o+(0.766413057635)*x[2]
        arg[5,0,0]=(-0.871242033478)*x[0]**o+(0.823859447959)*x[0]+(-0.0506075089356)*x[1]**o+(-0.901254358367)*x[1]+(0.936710991394)*x[2]**o+(0.328438496312)*x[2]
        arg[5,0,1]=(-0.768255700059)*x[0]**o+(0.199623934067)*x[0]+(-0.0715921959057)*x[1]**o+(-0.542435290562)*x[1]+(-0.278962068381)*x[2]**o+(0.784363143932)*x[2]
        arg[5,1,0]=(0.897130313615)*x[0]**o+(-0.519033315355)*x[0]+(0.223176381444)*x[1]**o+(0.495645921147)*x[1]+(-0.0957696173909)*x[2]**o+(-0.768307051074)*x[2]
        arg[5,1,1]=(-0.944161779454)*x[0]**o+(0.430097328631)*x[0]+(0.86626977715)*x[1]**o+(-0.675612908116)*x[1]+(0.506821683353)*x[2]**o+(0.386559021354)*x[2]
        ref[0,0,0,0]=o*(0.723756735151)*x_ref[0]**(o-1)+(0.738121670547)
        ref[0,0,0,1]=o*(0.384835073242)*x_ref[1]**(o-1)+(-0.997944909714)
        ref[0,0,0,2]=o*(0.271533052097)*x_ref[2]**(o-1)+(-0.667680363953)
        ref[0,0,1,0]=o*(-0.279804914835)*x_ref[0]**(o-1)+(0.789671404386)
        ref[0,0,1,1]=o*(-0.823187173328)*x_ref[1]**(o-1)+(-0.0126377581755)
        ref[0,0,1,2]=o*(-0.942836469998)*x_ref[2]**(o-1)+(0.416417451133)
        ref[0,1,0,0]=o*(-0.69035514237)*x_ref[0]**(o-1)+(0.388349204037)
        ref[0,1,0,1]=o*(0.807201832597)*x_ref[1]**(o-1)+(-0.969007115064)
        ref[0,1,0,2]=o*(0.280506744137)*x_ref[2]**(o-1)+(0.228554540968)
        ref[0,1,1,0]=o*(0.893542584763)*x_ref[0]**(o-1)+(-0.755974692532)
        ref[0,1,1,1]=o*(0.675321004205)*x_ref[1]**(o-1)+(0.670278291297)
        ref[0,1,1,2]=o*(0.92092687885)*x_ref[2]**(o-1)+(-0.516288388724)
        ref[1,0,0,0]=o*(0.503764409596)*x_ref[0]**(o-1)+(-0.39410032918)
        ref[1,0,0,1]=o*(0.532408717712)*x_ref[1]**(o-1)+(0.0658355614843)
        ref[1,0,0,2]=o*(-0.533534889451)*x_ref[2]**(o-1)+(0.846333211477)
        ref[1,0,1,0]=o*(0.520531780859)*x_ref[0]**(o-1)+(0.869039672332)
        ref[1,0,1,1]=o*(-0.706342144586)*x_ref[1]**(o-1)+(0.0665768341658)
        ref[1,0,1,2]=o*(-0.909079295867)*x_ref[2]**(o-1)+(-0.34153327843)
        ref[1,1,0,0]=o*(-0.873546169914)*x_ref[0]**(o-1)+(-0.554907283387)
        ref[1,1,0,1]=o*(-0.0560665557101)*x_ref[1]**(o-1)+(0.436703623389)
        ref[1,1,0,2]=o*(0.730437022736)*x_ref[2]**(o-1)+(0.100904171105)
        ref[1,1,1,0]=o*(0.845958886681)*x_ref[0]**(o-1)+(0.376444128389)
        ref[1,1,1,1]=o*(-0.393744308499)*x_ref[1]**(o-1)+(-0.0940537397734)
        ref[1,1,1,2]=o*(0.178796464778)*x_ref[2]**(o-1)+(-0.584448595407)
        ref[2,0,0,0]=o*(0.000704382305339)*x_ref[0]**(o-1)+(-0.836800712787)
        ref[2,0,0,1]=o*(0.671931504433)*x_ref[1]**(o-1)+(0.263280364406)
        ref[2,0,0,2]=o*(-0.746980015754)*x_ref[2]**(o-1)+(-0.985058787575)
        ref[2,0,1,0]=o*(-0.540690929008)*x_ref[0]**(o-1)+(0.656899216804)
        ref[2,0,1,1]=o*(-0.608036845804)*x_ref[1]**(o-1)+(0.224943400248)
        ref[2,0,1,2]=o*(-0.312449005326)*x_ref[2]**(o-1)+(-0.621458231634)
        ref[2,1,0,0]=o*(0.440432866893)*x_ref[0]**(o-1)+(0.972046189647)
        ref[2,1,0,1]=o*(0.060785199375)*x_ref[1]**(o-1)+(0.304756432986)
        ref[2,1,0,2]=o*(-0.473510049103)*x_ref[2]**(o-1)+(0.3707166351)
        ref[2,1,1,0]=o*(0.96344472567)*x_ref[0]**(o-1)+(-0.153932665404)
        ref[2,1,1,1]=o*(-0.43646142206)*x_ref[1]**(o-1)+(0.4838463484)
        ref[2,1,1,2]=o*(0.613286612579)*x_ref[2]**(o-1)+(0.84521461472)
        ref[3,0,0,0]=o*(0.65147393118)*x_ref[0]**(o-1)+(-0.886665762467)
        ref[3,0,0,1]=o*(-0.266000665973)*x_ref[1]**(o-1)+(0.897979405808)
        ref[3,0,0,2]=o*(0.699333158084)*x_ref[2]**(o-1)+(-0.460865970247)
        ref[3,0,1,0]=o*(0.870253308112)*x_ref[0]**(o-1)+(-0.248736315721)
        ref[3,0,1,1]=o*(-0.816719773596)*x_ref[1]**(o-1)+(-0.89378202899)
        ref[3,0,1,2]=o*(0.524350309915)*x_ref[2]**(o-1)+(0.107325872954)
        ref[3,1,0,0]=o*(-0.152250686624)*x_ref[0]**(o-1)+(-0.89784066484)
        ref[3,1,0,1]=o*(-0.327207891694)*x_ref[1]**(o-1)+(0.346548492907)
        ref[3,1,0,2]=o*(0.409288642845)*x_ref[2]**(o-1)+(-0.627349664194)
        ref[3,1,1,0]=o*(0.398337202036)*x_ref[0]**(o-1)+(0.307156588584)
        ref[3,1,1,1]=o*(0.0567088869624)*x_ref[1]**(o-1)+(-0.132313990308)
        ref[3,1,1,2]=o*(-0.361821356587)*x_ref[2]**(o-1)+(0.913518325149)
        ref[4,0,0,0]=o*(0.184289428296)*x_ref[0]**(o-1)+(0.138095407277)
        ref[4,0,0,1]=o*(0.514405012603)*x_ref[1]**(o-1)+(0.590757249119)
        ref[4,0,0,2]=o*(-0.984116206238)*x_ref[2]**(o-1)+(-0.176561783123)
        ref[4,0,1,0]=o*(-0.804189448075)*x_ref[0]**(o-1)+(0.662750787102)
        ref[4,0,1,1]=o*(0.361634380444)*x_ref[1]**(o-1)+(-0.682665313256)
        ref[4,0,1,2]=o*(-0.0738989964344)*x_ref[2]**(o-1)+(0.8870747144)
        ref[4,1,0,0]=o*(-0.28290153618)*x_ref[0]**(o-1)+(-0.942107675992)
        ref[4,1,0,1]=o*(0.308140792703)*x_ref[1]**(o-1)+(0.686659531002)
        ref[4,1,0,2]=o*(0.789553636322)*x_ref[2]**(o-1)+(0.587377542884)
        ref[4,1,1,0]=o*(0.6137979501)*x_ref[0]**(o-1)+(-0.564031937362)
        ref[4,1,1,1]=o*(-0.116407590432)*x_ref[1]**(o-1)+(-0.119100735459)
        ref[4,1,1,2]=o*(0.673631378916)*x_ref[2]**(o-1)+(0.766413057635)
        ref[5,0,0,0]=o*(-0.871242033478)*x_ref[0]**(o-1)+(0.823859447959)
        ref[5,0,0,1]=o*(-0.0506075089356)*x_ref[1]**(o-1)+(-0.901254358367)
        ref[5,0,0,2]=o*(0.936710991394)*x_ref[2]**(o-1)+(0.328438496312)
        ref[5,0,1,0]=o*(-0.768255700059)*x_ref[0]**(o-1)+(0.199623934067)
        ref[5,0,1,1]=o*(-0.0715921959057)*x_ref[1]**(o-1)+(-0.542435290562)
        ref[5,0,1,2]=o*(-0.278962068381)*x_ref[2]**(o-1)+(0.784363143932)
        ref[5,1,0,0]=o*(0.897130313615)*x_ref[0]**(o-1)+(-0.519033315355)
        ref[5,1,0,1]=o*(0.223176381444)*x_ref[1]**(o-1)+(0.495645921147)
        ref[5,1,0,2]=o*(-0.0957696173909)*x_ref[2]**(o-1)+(-0.768307051074)
        ref[5,1,1,0]=o*(-0.944161779454)*x_ref[0]**(o-1)+(0.430097328631)
        ref[5,1,1,1]=o*(0.86626977715)*x_ref[1]**(o-1)+(-0.675612908116)
        ref[5,1,1,2]=o*(0.506821683353)*x_ref[2]**(o-1)+(0.386559021354)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnContactZero_fromData_Solution_rank0(self):
      """
      tests gradient for rank 0 Data on the ReducedFunctionOnContactZero

      assumptions: Solution(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnContactZero
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=Solution(self.domain)
      x=w.getX()
      arg=Data(0,(),w)
      ref=Data(0,()+(dim,),w_ref)
      if dim==2:
        arg=(0.54415545025)*x[0]**o+(0.979947366774)*x[0]+(-0.405934730304)*x[1]**o+(0.424994268397)*x[1]
        ref[0]=o*(0.54415545025)*x_ref[0]**(o-1)+(0.979947366774)
        ref[1]=o*(-0.405934730304)*x_ref[1]**(o-1)+(0.424994268397)
      else:
        arg=(-0.0240792232301)*x[0]**o+(0.33156704088)*x[0]+(-0.051539264252)*x[1]**o+(-0.886370693155)*x[1]+(-0.954475798211)*x[2]**o+(0.238073928589)*x[2]
        ref[0]=o*(-0.0240792232301)*x_ref[0]**(o-1)+(0.33156704088)
        ref[1]=o*(-0.051539264252)*x_ref[1]**(o-1)+(-0.886370693155)
        ref[2]=o*(-0.954475798211)*x_ref[2]**(o-1)+(0.238073928589)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),()+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnContactZero_fromData_Solution_rank1(self):
      """
      tests gradient for rank 1 Data on the ReducedFunctionOnContactZero

      assumptions: Solution(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnContactZero
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=Solution(self.domain)
      x=w.getX()
      arg=Data(0,(2,),w)
      ref=Data(0,(2,)+(dim,),w_ref)
      if dim==2:
        arg[0]=(-0.526471606132)*x[0]**o+(-0.355534153967)*x[0]+(-0.792258102571)*x[1]**o+(0.386283553167)*x[1]
        arg[1]=(-0.892924864905)*x[0]**o+(0.19218757952)*x[0]+(0.00248964495987)*x[1]**o+(-0.687070938997)*x[1]
        ref[0,0]=o*(-0.526471606132)*x_ref[0]**(o-1)+(-0.355534153967)
        ref[0,1]=o*(-0.792258102571)*x_ref[1]**(o-1)+(0.386283553167)
        ref[1,0]=o*(-0.892924864905)*x_ref[0]**(o-1)+(0.19218757952)
        ref[1,1]=o*(0.00248964495987)*x_ref[1]**(o-1)+(-0.687070938997)
      else:
        arg[0]=(-0.254013984725)*x[0]**o+(0.126174108068)*x[0]+(-0.967653739084)*x[1]**o+(-0.524294999327)*x[1]+(0.374454913375)*x[2]**o+(0.783768839592)*x[2]
        arg[1]=(0.862328996944)*x[0]**o+(-0.0100272707295)*x[0]+(0.163524617753)*x[1]**o+(-0.19251370258)*x[1]+(0.889557068195)*x[2]**o+(0.573248942406)*x[2]
        ref[0,0]=o*(-0.254013984725)*x_ref[0]**(o-1)+(0.126174108068)
        ref[0,1]=o*(-0.967653739084)*x_ref[1]**(o-1)+(-0.524294999327)
        ref[0,2]=o*(0.374454913375)*x_ref[2]**(o-1)+(0.783768839592)
        ref[1,0]=o*(0.862328996944)*x_ref[0]**(o-1)+(-0.0100272707295)
        ref[1,1]=o*(0.163524617753)*x_ref[1]**(o-1)+(-0.19251370258)
        ref[1,2]=o*(0.889557068195)*x_ref[2]**(o-1)+(0.573248942406)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnContactZero_fromData_Solution_rank2(self):
      """
      tests gradient for rank 2 Data on the ReducedFunctionOnContactZero

      assumptions: Solution(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnContactZero
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=Solution(self.domain)
      x=w.getX()
      arg=Data(0,(4, 5),w)
      ref=Data(0,(4, 5)+(dim,),w_ref)
      if dim==2:
        arg[0,0]=(0.712410724071)*x[0]**o+(0.642832165006)*x[0]+(0.409613677638)*x[1]**o+(-0.940707375829)*x[1]
        arg[0,1]=(-0.192677448978)*x[0]**o+(0.928105399392)*x[0]+(-0.0976390111113)*x[1]**o+(0.152541825282)*x[1]
        arg[0,2]=(-0.555865920622)*x[0]**o+(0.187618737934)*x[0]+(-0.400398722616)*x[1]**o+(0.132335647294)*x[1]
        arg[0,3]=(-0.0984345355899)*x[0]**o+(-0.136251593387)*x[0]+(0.820900167194)*x[1]**o+(-0.54323976155)*x[1]
        arg[0,4]=(-0.718763327727)*x[0]**o+(-0.993678837401)*x[0]+(0.0282625285716)*x[1]**o+(0.480464124636)*x[1]
        arg[1,0]=(-0.1635372419)*x[0]**o+(0.97173720053)*x[0]+(0.0423190406144)*x[1]**o+(-0.607779321237)*x[1]
        arg[1,1]=(-0.59220466746)*x[0]**o+(-0.329625880847)*x[0]+(0.176412343254)*x[1]**o+(0.955769019385)*x[1]
        arg[1,2]=(-0.516421195901)*x[0]**o+(0.147037193899)*x[0]+(0.247835053631)*x[1]**o+(-0.877986653535)*x[1]
        arg[1,3]=(-0.317266388999)*x[0]**o+(0.864393749347)*x[0]+(-0.957863705756)*x[1]**o+(-0.884975429798)*x[1]
        arg[1,4]=(0.540121554391)*x[0]**o+(0.808050078272)*x[0]+(0.703557587067)*x[1]**o+(-0.0976121077766)*x[1]
        arg[2,0]=(0.23658022222)*x[0]**o+(0.122038637852)*x[0]+(0.411570045798)*x[1]**o+(-0.434531687414)*x[1]
        arg[2,1]=(-0.378365306249)*x[0]**o+(0.511747532394)*x[0]+(0.586326813286)*x[1]**o+(0.699918966936)*x[1]
        arg[2,2]=(0.445092669694)*x[0]**o+(0.637517787944)*x[0]+(-0.668779388847)*x[1]**o+(0.487635262236)*x[1]
        arg[2,3]=(-0.232265851556)*x[0]**o+(0.391449220433)*x[0]+(0.647177607766)*x[1]**o+(0.207062996634)*x[1]
        arg[2,4]=(0.338412227828)*x[0]**o+(0.0205801366652)*x[0]+(-0.492628796478)*x[1]**o+(-0.683459852092)*x[1]
        arg[3,0]=(0.584296838468)*x[0]**o+(-0.598793253755)*x[0]+(0.707319426212)*x[1]**o+(0.678834769735)*x[1]
        arg[3,1]=(0.801295300134)*x[0]**o+(0.0494871119593)*x[0]+(0.378929822492)*x[1]**o+(-0.536309789421)*x[1]
        arg[3,2]=(-0.761535984131)*x[0]**o+(0.121584094596)*x[0]+(-0.00655849155175)*x[1]**o+(0.321872124523)*x[1]
        arg[3,3]=(0.384633290815)*x[0]**o+(-0.710356674518)*x[0]+(0.962059942069)*x[1]**o+(-0.593059919585)*x[1]
        arg[3,4]=(-0.608988807286)*x[0]**o+(-0.0776468065145)*x[0]+(-0.701400144867)*x[1]**o+(0.643928611178)*x[1]
        ref[0,0,0]=o*(0.712410724071)*x_ref[0]**(o-1)+(0.642832165006)
        ref[0,0,1]=o*(0.409613677638)*x_ref[1]**(o-1)+(-0.940707375829)
        ref[0,1,0]=o*(-0.192677448978)*x_ref[0]**(o-1)+(0.928105399392)
        ref[0,1,1]=o*(-0.0976390111113)*x_ref[1]**(o-1)+(0.152541825282)
        ref[0,2,0]=o*(-0.555865920622)*x_ref[0]**(o-1)+(0.187618737934)
        ref[0,2,1]=o*(-0.400398722616)*x_ref[1]**(o-1)+(0.132335647294)
        ref[0,3,0]=o*(-0.0984345355899)*x_ref[0]**(o-1)+(-0.136251593387)
        ref[0,3,1]=o*(0.820900167194)*x_ref[1]**(o-1)+(-0.54323976155)
        ref[0,4,0]=o*(-0.718763327727)*x_ref[0]**(o-1)+(-0.993678837401)
        ref[0,4,1]=o*(0.0282625285716)*x_ref[1]**(o-1)+(0.480464124636)
        ref[1,0,0]=o*(-0.1635372419)*x_ref[0]**(o-1)+(0.97173720053)
        ref[1,0,1]=o*(0.0423190406144)*x_ref[1]**(o-1)+(-0.607779321237)
        ref[1,1,0]=o*(-0.59220466746)*x_ref[0]**(o-1)+(-0.329625880847)
        ref[1,1,1]=o*(0.176412343254)*x_ref[1]**(o-1)+(0.955769019385)
        ref[1,2,0]=o*(-0.516421195901)*x_ref[0]**(o-1)+(0.147037193899)
        ref[1,2,1]=o*(0.247835053631)*x_ref[1]**(o-1)+(-0.877986653535)
        ref[1,3,0]=o*(-0.317266388999)*x_ref[0]**(o-1)+(0.864393749347)
        ref[1,3,1]=o*(-0.957863705756)*x_ref[1]**(o-1)+(-0.884975429798)
        ref[1,4,0]=o*(0.540121554391)*x_ref[0]**(o-1)+(0.808050078272)
        ref[1,4,1]=o*(0.703557587067)*x_ref[1]**(o-1)+(-0.0976121077766)
        ref[2,0,0]=o*(0.23658022222)*x_ref[0]**(o-1)+(0.122038637852)
        ref[2,0,1]=o*(0.411570045798)*x_ref[1]**(o-1)+(-0.434531687414)
        ref[2,1,0]=o*(-0.378365306249)*x_ref[0]**(o-1)+(0.511747532394)
        ref[2,1,1]=o*(0.586326813286)*x_ref[1]**(o-1)+(0.699918966936)
        ref[2,2,0]=o*(0.445092669694)*x_ref[0]**(o-1)+(0.637517787944)
        ref[2,2,1]=o*(-0.668779388847)*x_ref[1]**(o-1)+(0.487635262236)
        ref[2,3,0]=o*(-0.232265851556)*x_ref[0]**(o-1)+(0.391449220433)
        ref[2,3,1]=o*(0.647177607766)*x_ref[1]**(o-1)+(0.207062996634)
        ref[2,4,0]=o*(0.338412227828)*x_ref[0]**(o-1)+(0.0205801366652)
        ref[2,4,1]=o*(-0.492628796478)*x_ref[1]**(o-1)+(-0.683459852092)
        ref[3,0,0]=o*(0.584296838468)*x_ref[0]**(o-1)+(-0.598793253755)
        ref[3,0,1]=o*(0.707319426212)*x_ref[1]**(o-1)+(0.678834769735)
        ref[3,1,0]=o*(0.801295300134)*x_ref[0]**(o-1)+(0.0494871119593)
        ref[3,1,1]=o*(0.378929822492)*x_ref[1]**(o-1)+(-0.536309789421)
        ref[3,2,0]=o*(-0.761535984131)*x_ref[0]**(o-1)+(0.121584094596)
        ref[3,2,1]=o*(-0.00655849155175)*x_ref[1]**(o-1)+(0.321872124523)
        ref[3,3,0]=o*(0.384633290815)*x_ref[0]**(o-1)+(-0.710356674518)
        ref[3,3,1]=o*(0.962059942069)*x_ref[1]**(o-1)+(-0.593059919585)
        ref[3,4,0]=o*(-0.608988807286)*x_ref[0]**(o-1)+(-0.0776468065145)
        ref[3,4,1]=o*(-0.701400144867)*x_ref[1]**(o-1)+(0.643928611178)
      else:
        arg[0,0]=(-0.514546772198)*x[0]**o+(0.679859064768)*x[0]+(-0.494037106077)*x[1]**o+(-0.0598645161488)*x[1]+(-0.543474311879)*x[2]**o+(0.597237276677)*x[2]
        arg[0,1]=(0.0826513727579)*x[0]**o+(0.870535937411)*x[0]+(-0.194047768119)*x[1]**o+(-0.111616761775)*x[1]+(0.697073558803)*x[2]**o+(-0.170433075843)*x[2]
        arg[0,2]=(0.608560200938)*x[0]**o+(-0.28991661304)*x[0]+(0.929121366615)*x[1]**o+(0.445280468492)*x[1]+(-0.0671026162019)*x[2]**o+(-0.835086989851)*x[2]
        arg[0,3]=(-0.256476478337)*x[0]**o+(-0.857686365148)*x[0]+(-0.309306419219)*x[1]**o+(0.750579112592)*x[1]+(0.758254577714)*x[2]**o+(0.108972886739)*x[2]
        arg[0,4]=(0.189540467853)*x[0]**o+(-0.639906129587)*x[0]+(0.1086564431)*x[1]**o+(-0.254754163159)*x[1]+(-0.595415956315)*x[2]**o+(0.416643698623)*x[2]
        arg[1,0]=(0.649640741159)*x[0]**o+(-0.715604744977)*x[0]+(0.144698127223)*x[1]**o+(0.84058008507)*x[1]+(0.00226738664623)*x[2]**o+(0.143092105366)*x[2]
        arg[1,1]=(0.30428097785)*x[0]**o+(0.172630542192)*x[0]+(0.645118113075)*x[1]**o+(-0.394468022223)*x[1]+(0.731670923192)*x[2]**o+(-0.676021495379)*x[2]
        arg[1,2]=(0.56459927889)*x[0]**o+(-0.624980053566)*x[0]+(-0.524836958708)*x[1]**o+(0.282862320474)*x[1]+(0.99070455422)*x[2]**o+(0.000265746399286)*x[2]
        arg[1,3]=(-0.251929813217)*x[0]**o+(0.00685246758491)*x[0]+(-0.252595929082)*x[1]**o+(-0.997558334417)*x[1]+(-0.431329146194)*x[2]**o+(0.0685298495116)*x[2]
        arg[1,4]=(-0.850398225165)*x[0]**o+(-0.752363025861)*x[0]+(-0.669448553729)*x[1]**o+(0.809247179374)*x[1]+(-0.927467807251)*x[2]**o+(-0.498094160268)*x[2]
        arg[2,0]=(0.541736859663)*x[0]**o+(-0.651273876855)*x[0]+(-0.679670779769)*x[1]**o+(0.669564679419)*x[1]+(-0.825048237017)*x[2]**o+(-0.247744537755)*x[2]
        arg[2,1]=(0.909016713138)*x[0]**o+(-0.794124179572)*x[0]+(0.887294650854)*x[1]**o+(-0.198933351435)*x[1]+(-0.819671062456)*x[2]**o+(0.287455634612)*x[2]
        arg[2,2]=(-0.469337238665)*x[0]**o+(0.787828984218)*x[0]+(0.916042829702)*x[1]**o+(-0.475983675757)*x[1]+(-0.350660319046)*x[2]**o+(0.944222119413)*x[2]
        arg[2,3]=(-0.194629035155)*x[0]**o+(0.452058614199)*x[0]+(-0.565150768916)*x[1]**o+(-0.967642852138)*x[1]+(-0.345332973443)*x[2]**o+(-0.238359110833)*x[2]
        arg[2,4]=(-0.744197369952)*x[0]**o+(-0.0161450929106)*x[0]+(0.946555120156)*x[1]**o+(-0.336314723492)*x[1]+(0.212936909808)*x[2]**o+(-0.900582293569)*x[2]
        arg[3,0]=(0.90736518985)*x[0]**o+(-0.866096443075)*x[0]+(0.440227521532)*x[1]**o+(-0.545983384676)*x[1]+(0.433167375756)*x[2]**o+(-0.913060961228)*x[2]
        arg[3,1]=(0.33547032327)*x[0]**o+(0.766388218896)*x[0]+(-0.386141806114)*x[1]**o+(0.28471049668)*x[1]+(0.389347155974)*x[2]**o+(0.211663215285)*x[2]
        arg[3,2]=(0.193757801099)*x[0]**o+(0.0145439587225)*x[0]+(0.575506295918)*x[1]**o+(-0.678317336021)*x[1]+(0.64603157052)*x[2]**o+(-0.876667949279)*x[2]
        arg[3,3]=(-0.0518002857411)*x[0]**o+(-0.540021971724)*x[0]+(-0.490275636747)*x[1]**o+(-0.849147647677)*x[1]+(-0.0132783508877)*x[2]**o+(0.0859860768541)*x[2]
        arg[3,4]=(-0.332675003425)*x[0]**o+(-0.757986125506)*x[0]+(-0.487001539705)*x[1]**o+(0.898881577697)*x[1]+(0.56557767007)*x[2]**o+(0.181594113977)*x[2]
        ref[0,0,0]=o*(-0.514546772198)*x_ref[0]**(o-1)+(0.679859064768)
        ref[0,0,1]=o*(-0.494037106077)*x_ref[1]**(o-1)+(-0.0598645161488)
        ref[0,0,2]=o*(-0.543474311879)*x_ref[2]**(o-1)+(0.597237276677)
        ref[0,1,0]=o*(0.0826513727579)*x_ref[0]**(o-1)+(0.870535937411)
        ref[0,1,1]=o*(-0.194047768119)*x_ref[1]**(o-1)+(-0.111616761775)
        ref[0,1,2]=o*(0.697073558803)*x_ref[2]**(o-1)+(-0.170433075843)
        ref[0,2,0]=o*(0.608560200938)*x_ref[0]**(o-1)+(-0.28991661304)
        ref[0,2,1]=o*(0.929121366615)*x_ref[1]**(o-1)+(0.445280468492)
        ref[0,2,2]=o*(-0.0671026162019)*x_ref[2]**(o-1)+(-0.835086989851)
        ref[0,3,0]=o*(-0.256476478337)*x_ref[0]**(o-1)+(-0.857686365148)
        ref[0,3,1]=o*(-0.309306419219)*x_ref[1]**(o-1)+(0.750579112592)
        ref[0,3,2]=o*(0.758254577714)*x_ref[2]**(o-1)+(0.108972886739)
        ref[0,4,0]=o*(0.189540467853)*x_ref[0]**(o-1)+(-0.639906129587)
        ref[0,4,1]=o*(0.1086564431)*x_ref[1]**(o-1)+(-0.254754163159)
        ref[0,4,2]=o*(-0.595415956315)*x_ref[2]**(o-1)+(0.416643698623)
        ref[1,0,0]=o*(0.649640741159)*x_ref[0]**(o-1)+(-0.715604744977)
        ref[1,0,1]=o*(0.144698127223)*x_ref[1]**(o-1)+(0.84058008507)
        ref[1,0,2]=o*(0.00226738664623)*x_ref[2]**(o-1)+(0.143092105366)
        ref[1,1,0]=o*(0.30428097785)*x_ref[0]**(o-1)+(0.172630542192)
        ref[1,1,1]=o*(0.645118113075)*x_ref[1]**(o-1)+(-0.394468022223)
        ref[1,1,2]=o*(0.731670923192)*x_ref[2]**(o-1)+(-0.676021495379)
        ref[1,2,0]=o*(0.56459927889)*x_ref[0]**(o-1)+(-0.624980053566)
        ref[1,2,1]=o*(-0.524836958708)*x_ref[1]**(o-1)+(0.282862320474)
        ref[1,2,2]=o*(0.99070455422)*x_ref[2]**(o-1)+(0.000265746399286)
        ref[1,3,0]=o*(-0.251929813217)*x_ref[0]**(o-1)+(0.00685246758491)
        ref[1,3,1]=o*(-0.252595929082)*x_ref[1]**(o-1)+(-0.997558334417)
        ref[1,3,2]=o*(-0.431329146194)*x_ref[2]**(o-1)+(0.0685298495116)
        ref[1,4,0]=o*(-0.850398225165)*x_ref[0]**(o-1)+(-0.752363025861)
        ref[1,4,1]=o*(-0.669448553729)*x_ref[1]**(o-1)+(0.809247179374)
        ref[1,4,2]=o*(-0.927467807251)*x_ref[2]**(o-1)+(-0.498094160268)
        ref[2,0,0]=o*(0.541736859663)*x_ref[0]**(o-1)+(-0.651273876855)
        ref[2,0,1]=o*(-0.679670779769)*x_ref[1]**(o-1)+(0.669564679419)
        ref[2,0,2]=o*(-0.825048237017)*x_ref[2]**(o-1)+(-0.247744537755)
        ref[2,1,0]=o*(0.909016713138)*x_ref[0]**(o-1)+(-0.794124179572)
        ref[2,1,1]=o*(0.887294650854)*x_ref[1]**(o-1)+(-0.198933351435)
        ref[2,1,2]=o*(-0.819671062456)*x_ref[2]**(o-1)+(0.287455634612)
        ref[2,2,0]=o*(-0.469337238665)*x_ref[0]**(o-1)+(0.787828984218)
        ref[2,2,1]=o*(0.916042829702)*x_ref[1]**(o-1)+(-0.475983675757)
        ref[2,2,2]=o*(-0.350660319046)*x_ref[2]**(o-1)+(0.944222119413)
        ref[2,3,0]=o*(-0.194629035155)*x_ref[0]**(o-1)+(0.452058614199)
        ref[2,3,1]=o*(-0.565150768916)*x_ref[1]**(o-1)+(-0.967642852138)
        ref[2,3,2]=o*(-0.345332973443)*x_ref[2]**(o-1)+(-0.238359110833)
        ref[2,4,0]=o*(-0.744197369952)*x_ref[0]**(o-1)+(-0.0161450929106)
        ref[2,4,1]=o*(0.946555120156)*x_ref[1]**(o-1)+(-0.336314723492)
        ref[2,4,2]=o*(0.212936909808)*x_ref[2]**(o-1)+(-0.900582293569)
        ref[3,0,0]=o*(0.90736518985)*x_ref[0]**(o-1)+(-0.866096443075)
        ref[3,0,1]=o*(0.440227521532)*x_ref[1]**(o-1)+(-0.545983384676)
        ref[3,0,2]=o*(0.433167375756)*x_ref[2]**(o-1)+(-0.913060961228)
        ref[3,1,0]=o*(0.33547032327)*x_ref[0]**(o-1)+(0.766388218896)
        ref[3,1,1]=o*(-0.386141806114)*x_ref[1]**(o-1)+(0.28471049668)
        ref[3,1,2]=o*(0.389347155974)*x_ref[2]**(o-1)+(0.211663215285)
        ref[3,2,0]=o*(0.193757801099)*x_ref[0]**(o-1)+(0.0145439587225)
        ref[3,2,1]=o*(0.575506295918)*x_ref[1]**(o-1)+(-0.678317336021)
        ref[3,2,2]=o*(0.64603157052)*x_ref[2]**(o-1)+(-0.876667949279)
        ref[3,3,0]=o*(-0.0518002857411)*x_ref[0]**(o-1)+(-0.540021971724)
        ref[3,3,1]=o*(-0.490275636747)*x_ref[1]**(o-1)+(-0.849147647677)
        ref[3,3,2]=o*(-0.0132783508877)*x_ref[2]**(o-1)+(0.0859860768541)
        ref[3,4,0]=o*(-0.332675003425)*x_ref[0]**(o-1)+(-0.757986125506)
        ref[3,4,1]=o*(-0.487001539705)*x_ref[1]**(o-1)+(0.898881577697)
        ref[3,4,2]=o*(0.56557767007)*x_ref[2]**(o-1)+(0.181594113977)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnContactZero_fromData_Solution_rank3(self):
      """
      tests gradient for rank 3 Data on the ReducedFunctionOnContactZero

      assumptions: Solution(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnContactZero
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=Solution(self.domain)
      x=w.getX()
      arg=Data(0,(6, 2, 2),w)
      ref=Data(0,(6, 2, 2)+(dim,),w_ref)
      if dim==2:
        arg[0,0,0]=(0.568278554396)*x[0]**o+(0.714635312506)*x[0]+(-0.121000061881)*x[1]**o+(0.650923087629)*x[1]
        arg[0,0,1]=(0.610070747198)*x[0]**o+(-0.17228586298)*x[0]+(-0.763207252556)*x[1]**o+(-0.417620736844)*x[1]
        arg[0,1,0]=(0.953437717333)*x[0]**o+(-0.877858891638)*x[0]+(-0.629855255168)*x[1]**o+(0.138168708132)*x[1]
        arg[0,1,1]=(-0.676346259275)*x[0]**o+(0.810400719592)*x[0]+(0.252517037374)*x[1]**o+(-0.0253025825974)*x[1]
        arg[1,0,0]=(0.0354009852553)*x[0]**o+(-0.930486981217)*x[0]+(0.515533244848)*x[1]**o+(0.39357313927)*x[1]
        arg[1,0,1]=(4.954730054e-05)*x[0]**o+(0.902841279458)*x[0]+(0.0974175050415)*x[1]**o+(-0.283224733511)*x[1]
        arg[1,1,0]=(-0.3695113121)*x[0]**o+(-0.425976895152)*x[0]+(-0.752863101988)*x[1]**o+(-0.135026977845)*x[1]
        arg[1,1,1]=(-0.627750038208)*x[0]**o+(-0.682825202306)*x[0]+(0.598327522753)*x[1]**o+(0.0402698525348)*x[1]
        arg[2,0,0]=(0.95982907811)*x[0]**o+(-0.786158711751)*x[0]+(0.6974717418)*x[1]**o+(-0.548248895713)*x[1]
        arg[2,0,1]=(-0.21063630362)*x[0]**o+(-0.979628903483)*x[0]+(0.514851452559)*x[1]**o+(-0.294218784425)*x[1]
        arg[2,1,0]=(-0.446140926476)*x[0]**o+(0.658918134389)*x[0]+(-0.166087456007)*x[1]**o+(0.328044805625)*x[1]
        arg[2,1,1]=(0.937161634589)*x[0]**o+(0.594322457074)*x[0]+(0.992336676032)*x[1]**o+(-0.499637100315)*x[1]
        arg[3,0,0]=(0.767677974163)*x[0]**o+(-0.820615663298)*x[0]+(0.558185245925)*x[1]**o+(-0.763525476816)*x[1]
        arg[3,0,1]=(-0.866581629552)*x[0]**o+(0.589993777037)*x[0]+(-0.0704817160146)*x[1]**o+(-0.897469280048)*x[1]
        arg[3,1,0]=(-0.290118027748)*x[0]**o+(0.211790364383)*x[0]+(-0.0688758465892)*x[1]**o+(0.777490292219)*x[1]
        arg[3,1,1]=(-0.969418722549)*x[0]**o+(-0.46884683812)*x[0]+(0.826696594862)*x[1]**o+(-0.926802811507)*x[1]
        arg[4,0,0]=(-0.230285931083)*x[0]**o+(0.905695021426)*x[0]+(-0.581906633624)*x[1]**o+(-0.69277147014)*x[1]
        arg[4,0,1]=(-0.251350536276)*x[0]**o+(0.352877501605)*x[0]+(0.290432460788)*x[1]**o+(0.614218150117)*x[1]
        arg[4,1,0]=(-0.475014635407)*x[0]**o+(0.86786497963)*x[0]+(-0.763349511499)*x[1]**o+(0.817847286727)*x[1]
        arg[4,1,1]=(0.0079711463132)*x[0]**o+(-0.20685339926)*x[0]+(0.377467915936)*x[1]**o+(-0.209268733968)*x[1]
        arg[5,0,0]=(0.795790630791)*x[0]**o+(0.0661201279192)*x[0]+(0.932665258262)*x[1]**o+(-0.4785884914)*x[1]
        arg[5,0,1]=(0.929422646068)*x[0]**o+(0.775378282324)*x[0]+(0.297482039582)*x[1]**o+(-0.700872789842)*x[1]
        arg[5,1,0]=(0.678688297204)*x[0]**o+(0.365975847321)*x[0]+(-0.565261107289)*x[1]**o+(0.0317556604619)*x[1]
        arg[5,1,1]=(-0.0231297032408)*x[0]**o+(-0.985865541949)*x[0]+(0.733821736669)*x[1]**o+(0.603255951212)*x[1]
        ref[0,0,0,0]=o*(0.568278554396)*x_ref[0]**(o-1)+(0.714635312506)
        ref[0,0,0,1]=o*(-0.121000061881)*x_ref[1]**(o-1)+(0.650923087629)
        ref[0,0,1,0]=o*(0.610070747198)*x_ref[0]**(o-1)+(-0.17228586298)
        ref[0,0,1,1]=o*(-0.763207252556)*x_ref[1]**(o-1)+(-0.417620736844)
        ref[0,1,0,0]=o*(0.953437717333)*x_ref[0]**(o-1)+(-0.877858891638)
        ref[0,1,0,1]=o*(-0.629855255168)*x_ref[1]**(o-1)+(0.138168708132)
        ref[0,1,1,0]=o*(-0.676346259275)*x_ref[0]**(o-1)+(0.810400719592)
        ref[0,1,1,1]=o*(0.252517037374)*x_ref[1]**(o-1)+(-0.0253025825974)
        ref[1,0,0,0]=o*(0.0354009852553)*x_ref[0]**(o-1)+(-0.930486981217)
        ref[1,0,0,1]=o*(0.515533244848)*x_ref[1]**(o-1)+(0.39357313927)
        ref[1,0,1,0]=o*(4.954730054e-05)*x_ref[0]**(o-1)+(0.902841279458)
        ref[1,0,1,1]=o*(0.0974175050415)*x_ref[1]**(o-1)+(-0.283224733511)
        ref[1,1,0,0]=o*(-0.3695113121)*x_ref[0]**(o-1)+(-0.425976895152)
        ref[1,1,0,1]=o*(-0.752863101988)*x_ref[1]**(o-1)+(-0.135026977845)
        ref[1,1,1,0]=o*(-0.627750038208)*x_ref[0]**(o-1)+(-0.682825202306)
        ref[1,1,1,1]=o*(0.598327522753)*x_ref[1]**(o-1)+(0.0402698525348)
        ref[2,0,0,0]=o*(0.95982907811)*x_ref[0]**(o-1)+(-0.786158711751)
        ref[2,0,0,1]=o*(0.6974717418)*x_ref[1]**(o-1)+(-0.548248895713)
        ref[2,0,1,0]=o*(-0.21063630362)*x_ref[0]**(o-1)+(-0.979628903483)
        ref[2,0,1,1]=o*(0.514851452559)*x_ref[1]**(o-1)+(-0.294218784425)
        ref[2,1,0,0]=o*(-0.446140926476)*x_ref[0]**(o-1)+(0.658918134389)
        ref[2,1,0,1]=o*(-0.166087456007)*x_ref[1]**(o-1)+(0.328044805625)
        ref[2,1,1,0]=o*(0.937161634589)*x_ref[0]**(o-1)+(0.594322457074)
        ref[2,1,1,1]=o*(0.992336676032)*x_ref[1]**(o-1)+(-0.499637100315)
        ref[3,0,0,0]=o*(0.767677974163)*x_ref[0]**(o-1)+(-0.820615663298)
        ref[3,0,0,1]=o*(0.558185245925)*x_ref[1]**(o-1)+(-0.763525476816)
        ref[3,0,1,0]=o*(-0.866581629552)*x_ref[0]**(o-1)+(0.589993777037)
        ref[3,0,1,1]=o*(-0.0704817160146)*x_ref[1]**(o-1)+(-0.897469280048)
        ref[3,1,0,0]=o*(-0.290118027748)*x_ref[0]**(o-1)+(0.211790364383)
        ref[3,1,0,1]=o*(-0.0688758465892)*x_ref[1]**(o-1)+(0.777490292219)
        ref[3,1,1,0]=o*(-0.969418722549)*x_ref[0]**(o-1)+(-0.46884683812)
        ref[3,1,1,1]=o*(0.826696594862)*x_ref[1]**(o-1)+(-0.926802811507)
        ref[4,0,0,0]=o*(-0.230285931083)*x_ref[0]**(o-1)+(0.905695021426)
        ref[4,0,0,1]=o*(-0.581906633624)*x_ref[1]**(o-1)+(-0.69277147014)
        ref[4,0,1,0]=o*(-0.251350536276)*x_ref[0]**(o-1)+(0.352877501605)
        ref[4,0,1,1]=o*(0.290432460788)*x_ref[1]**(o-1)+(0.614218150117)
        ref[4,1,0,0]=o*(-0.475014635407)*x_ref[0]**(o-1)+(0.86786497963)
        ref[4,1,0,1]=o*(-0.763349511499)*x_ref[1]**(o-1)+(0.817847286727)
        ref[4,1,1,0]=o*(0.0079711463132)*x_ref[0]**(o-1)+(-0.20685339926)
        ref[4,1,1,1]=o*(0.377467915936)*x_ref[1]**(o-1)+(-0.209268733968)
        ref[5,0,0,0]=o*(0.795790630791)*x_ref[0]**(o-1)+(0.0661201279192)
        ref[5,0,0,1]=o*(0.932665258262)*x_ref[1]**(o-1)+(-0.4785884914)
        ref[5,0,1,0]=o*(0.929422646068)*x_ref[0]**(o-1)+(0.775378282324)
        ref[5,0,1,1]=o*(0.297482039582)*x_ref[1]**(o-1)+(-0.700872789842)
        ref[5,1,0,0]=o*(0.678688297204)*x_ref[0]**(o-1)+(0.365975847321)
        ref[5,1,0,1]=o*(-0.565261107289)*x_ref[1]**(o-1)+(0.0317556604619)
        ref[5,1,1,0]=o*(-0.0231297032408)*x_ref[0]**(o-1)+(-0.985865541949)
        ref[5,1,1,1]=o*(0.733821736669)*x_ref[1]**(o-1)+(0.603255951212)
      else:
        arg[0,0,0]=(-0.211459759219)*x[0]**o+(-0.577684864446)*x[0]+(-0.391603126843)*x[1]**o+(0.260321825768)*x[1]+(-0.314038207978)*x[2]**o+(-0.981440041663)*x[2]
        arg[0,0,1]=(-0.876053365684)*x[0]**o+(-0.194899445893)*x[0]+(0.346950377505)*x[1]**o+(0.571865696578)*x[1]+(0.632901527485)*x[2]**o+(0.832258490904)*x[2]
        arg[0,1,0]=(-0.0779003885155)*x[0]**o+(0.583384314998)*x[0]+(-0.257262737021)*x[1]**o+(0.456730130081)*x[1]+(0.262812418811)*x[2]**o+(0.0815640391979)*x[2]
        arg[0,1,1]=(0.087484387098)*x[0]**o+(-0.415375968565)*x[0]+(0.31138114792)*x[1]**o+(0.832138685168)*x[1]+(0.552625436456)*x[2]**o+(-0.0969172211154)*x[2]
        arg[1,0,0]=(0.721326796741)*x[0]**o+(-0.556644260079)*x[0]+(0.14718294664)*x[1]**o+(0.688425309252)*x[1]+(-0.16480505764)*x[2]**o+(-0.914914176523)*x[2]
        arg[1,0,1]=(0.0932763269908)*x[0]**o+(0.359036469617)*x[0]+(0.568509073358)*x[1]**o+(-0.42133310351)*x[1]+(0.576833556667)*x[2]**o+(0.44466763296)*x[2]
        arg[1,1,0]=(0.564028751408)*x[0]**o+(-0.314840429631)*x[0]+(-0.910523044917)*x[1]**o+(-0.0377714078758)*x[1]+(0.0125836031881)*x[2]**o+(0.602273699833)*x[2]
        arg[1,1,1]=(0.135282471986)*x[0]**o+(0.163613895979)*x[0]+(0.115685034139)*x[1]**o+(-0.687078382924)*x[1]+(0.406385459521)*x[2]**o+(-0.401846794432)*x[2]
        arg[2,0,0]=(0.815695969791)*x[0]**o+(0.312205723135)*x[0]+(0.993404535838)*x[1]**o+(0.101946422158)*x[1]+(-0.331818829998)*x[2]**o+(-0.0034480605816)*x[2]
        arg[2,0,1]=(0.638646208966)*x[0]**o+(0.265838992948)*x[0]+(0.156594972273)*x[1]**o+(0.935292984535)*x[1]+(-0.930522319399)*x[2]**o+(0.540679813135)*x[2]
        arg[2,1,0]=(-0.778823826824)*x[0]**o+(0.435399707656)*x[0]+(0.123031900278)*x[1]**o+(-0.132556439303)*x[1]+(-0.29114590778)*x[2]**o+(-0.277636472779)*x[2]
        arg[2,1,1]=(-0.200541347963)*x[0]**o+(-0.526841282198)*x[0]+(0.670718267305)*x[1]**o+(0.0777161510281)*x[1]+(0.847335718393)*x[2]**o+(0.167185849891)*x[2]
        arg[3,0,0]=(0.481112023661)*x[0]**o+(-0.703558873662)*x[0]+(0.0661746324247)*x[1]**o+(0.0628113595423)*x[1]+(0.804110728888)*x[2]**o+(0.517297444342)*x[2]
        arg[3,0,1]=(-0.44648091284)*x[0]**o+(-0.976332452987)*x[0]+(-0.886297355627)*x[1]**o+(-0.910033293533)*x[1]+(0.946007442337)*x[2]**o+(-0.586006699603)*x[2]
        arg[3,1,0]=(0.686532047098)*x[0]**o+(0.647146535444)*x[0]+(-0.424413819624)*x[1]**o+(-0.266078497115)*x[1]+(-0.656118336723)*x[2]**o+(0.902145487914)*x[2]
        arg[3,1,1]=(-0.0562438759603)*x[0]**o+(0.600872472135)*x[0]+(-0.162016187788)*x[1]**o+(-0.685387926)*x[1]+(-0.899318041513)*x[2]**o+(0.459743174318)*x[2]
        arg[4,0,0]=(-0.923373905806)*x[0]**o+(-0.0340303642214)*x[0]+(-0.798971449517)*x[1]**o+(-0.45521271974)*x[1]+(-0.354501811953)*x[2]**o+(0.0668579007274)*x[2]
        arg[4,0,1]=(0.411397784181)*x[0]**o+(0.112609440102)*x[0]+(0.352899973694)*x[1]**o+(-0.0728024007714)*x[1]+(0.50804391825)*x[2]**o+(0.748548958571)*x[2]
        arg[4,1,0]=(0.875890044031)*x[0]**o+(0.674204747948)*x[0]+(-0.879286517401)*x[1]**o+(-0.00338161978492)*x[1]+(-0.372790489717)*x[2]**o+(0.480822881409)*x[2]
        arg[4,1,1]=(-0.224827091498)*x[0]**o+(0.854170572245)*x[0]+(-0.670467931784)*x[1]**o+(0.85225464592)*x[1]+(0.41885719338)*x[2]**o+(-0.623296073831)*x[2]
        arg[5,0,0]=(-0.662704253172)*x[0]**o+(0.690656552406)*x[0]+(-0.812436958497)*x[1]**o+(0.928013493065)*x[1]+(0.763792541097)*x[2]**o+(-0.430084528987)*x[2]
        arg[5,0,1]=(0.451167682598)*x[0]**o+(0.373015986015)*x[0]+(0.73334610852)*x[1]**o+(0.44892130407)*x[1]+(0.820233215547)*x[2]**o+(0.863864357936)*x[2]
        arg[5,1,0]=(-0.700840074185)*x[0]**o+(-0.637964737375)*x[0]+(0.0532062256138)*x[1]**o+(-0.902662868597)*x[1]+(-0.91668008633)*x[2]**o+(0.00253116545509)*x[2]
        arg[5,1,1]=(0.0461834200484)*x[0]**o+(0.102406795193)*x[0]+(0.599142154957)*x[1]**o+(0.374585801545)*x[1]+(-0.444968156109)*x[2]**o+(-0.932860816729)*x[2]
        ref[0,0,0,0]=o*(-0.211459759219)*x_ref[0]**(o-1)+(-0.577684864446)
        ref[0,0,0,1]=o*(-0.391603126843)*x_ref[1]**(o-1)+(0.260321825768)
        ref[0,0,0,2]=o*(-0.314038207978)*x_ref[2]**(o-1)+(-0.981440041663)
        ref[0,0,1,0]=o*(-0.876053365684)*x_ref[0]**(o-1)+(-0.194899445893)
        ref[0,0,1,1]=o*(0.346950377505)*x_ref[1]**(o-1)+(0.571865696578)
        ref[0,0,1,2]=o*(0.632901527485)*x_ref[2]**(o-1)+(0.832258490904)
        ref[0,1,0,0]=o*(-0.0779003885155)*x_ref[0]**(o-1)+(0.583384314998)
        ref[0,1,0,1]=o*(-0.257262737021)*x_ref[1]**(o-1)+(0.456730130081)
        ref[0,1,0,2]=o*(0.262812418811)*x_ref[2]**(o-1)+(0.0815640391979)
        ref[0,1,1,0]=o*(0.087484387098)*x_ref[0]**(o-1)+(-0.415375968565)
        ref[0,1,1,1]=o*(0.31138114792)*x_ref[1]**(o-1)+(0.832138685168)
        ref[0,1,1,2]=o*(0.552625436456)*x_ref[2]**(o-1)+(-0.0969172211154)
        ref[1,0,0,0]=o*(0.721326796741)*x_ref[0]**(o-1)+(-0.556644260079)
        ref[1,0,0,1]=o*(0.14718294664)*x_ref[1]**(o-1)+(0.688425309252)
        ref[1,0,0,2]=o*(-0.16480505764)*x_ref[2]**(o-1)+(-0.914914176523)
        ref[1,0,1,0]=o*(0.0932763269908)*x_ref[0]**(o-1)+(0.359036469617)
        ref[1,0,1,1]=o*(0.568509073358)*x_ref[1]**(o-1)+(-0.42133310351)
        ref[1,0,1,2]=o*(0.576833556667)*x_ref[2]**(o-1)+(0.44466763296)
        ref[1,1,0,0]=o*(0.564028751408)*x_ref[0]**(o-1)+(-0.314840429631)
        ref[1,1,0,1]=o*(-0.910523044917)*x_ref[1]**(o-1)+(-0.0377714078758)
        ref[1,1,0,2]=o*(0.0125836031881)*x_ref[2]**(o-1)+(0.602273699833)
        ref[1,1,1,0]=o*(0.135282471986)*x_ref[0]**(o-1)+(0.163613895979)
        ref[1,1,1,1]=o*(0.115685034139)*x_ref[1]**(o-1)+(-0.687078382924)
        ref[1,1,1,2]=o*(0.406385459521)*x_ref[2]**(o-1)+(-0.401846794432)
        ref[2,0,0,0]=o*(0.815695969791)*x_ref[0]**(o-1)+(0.312205723135)
        ref[2,0,0,1]=o*(0.993404535838)*x_ref[1]**(o-1)+(0.101946422158)
        ref[2,0,0,2]=o*(-0.331818829998)*x_ref[2]**(o-1)+(-0.0034480605816)
        ref[2,0,1,0]=o*(0.638646208966)*x_ref[0]**(o-1)+(0.265838992948)
        ref[2,0,1,1]=o*(0.156594972273)*x_ref[1]**(o-1)+(0.935292984535)
        ref[2,0,1,2]=o*(-0.930522319399)*x_ref[2]**(o-1)+(0.540679813135)
        ref[2,1,0,0]=o*(-0.778823826824)*x_ref[0]**(o-1)+(0.435399707656)
        ref[2,1,0,1]=o*(0.123031900278)*x_ref[1]**(o-1)+(-0.132556439303)
        ref[2,1,0,2]=o*(-0.29114590778)*x_ref[2]**(o-1)+(-0.277636472779)
        ref[2,1,1,0]=o*(-0.200541347963)*x_ref[0]**(o-1)+(-0.526841282198)
        ref[2,1,1,1]=o*(0.670718267305)*x_ref[1]**(o-1)+(0.0777161510281)
        ref[2,1,1,2]=o*(0.847335718393)*x_ref[2]**(o-1)+(0.167185849891)
        ref[3,0,0,0]=o*(0.481112023661)*x_ref[0]**(o-1)+(-0.703558873662)
        ref[3,0,0,1]=o*(0.0661746324247)*x_ref[1]**(o-1)+(0.0628113595423)
        ref[3,0,0,2]=o*(0.804110728888)*x_ref[2]**(o-1)+(0.517297444342)
        ref[3,0,1,0]=o*(-0.44648091284)*x_ref[0]**(o-1)+(-0.976332452987)
        ref[3,0,1,1]=o*(-0.886297355627)*x_ref[1]**(o-1)+(-0.910033293533)
        ref[3,0,1,2]=o*(0.946007442337)*x_ref[2]**(o-1)+(-0.586006699603)
        ref[3,1,0,0]=o*(0.686532047098)*x_ref[0]**(o-1)+(0.647146535444)
        ref[3,1,0,1]=o*(-0.424413819624)*x_ref[1]**(o-1)+(-0.266078497115)
        ref[3,1,0,2]=o*(-0.656118336723)*x_ref[2]**(o-1)+(0.902145487914)
        ref[3,1,1,0]=o*(-0.0562438759603)*x_ref[0]**(o-1)+(0.600872472135)
        ref[3,1,1,1]=o*(-0.162016187788)*x_ref[1]**(o-1)+(-0.685387926)
        ref[3,1,1,2]=o*(-0.899318041513)*x_ref[2]**(o-1)+(0.459743174318)
        ref[4,0,0,0]=o*(-0.923373905806)*x_ref[0]**(o-1)+(-0.0340303642214)
        ref[4,0,0,1]=o*(-0.798971449517)*x_ref[1]**(o-1)+(-0.45521271974)
        ref[4,0,0,2]=o*(-0.354501811953)*x_ref[2]**(o-1)+(0.0668579007274)
        ref[4,0,1,0]=o*(0.411397784181)*x_ref[0]**(o-1)+(0.112609440102)
        ref[4,0,1,1]=o*(0.352899973694)*x_ref[1]**(o-1)+(-0.0728024007714)
        ref[4,0,1,2]=o*(0.50804391825)*x_ref[2]**(o-1)+(0.748548958571)
        ref[4,1,0,0]=o*(0.875890044031)*x_ref[0]**(o-1)+(0.674204747948)
        ref[4,1,0,1]=o*(-0.879286517401)*x_ref[1]**(o-1)+(-0.00338161978492)
        ref[4,1,0,2]=o*(-0.372790489717)*x_ref[2]**(o-1)+(0.480822881409)
        ref[4,1,1,0]=o*(-0.224827091498)*x_ref[0]**(o-1)+(0.854170572245)
        ref[4,1,1,1]=o*(-0.670467931784)*x_ref[1]**(o-1)+(0.85225464592)
        ref[4,1,1,2]=o*(0.41885719338)*x_ref[2]**(o-1)+(-0.623296073831)
        ref[5,0,0,0]=o*(-0.662704253172)*x_ref[0]**(o-1)+(0.690656552406)
        ref[5,0,0,1]=o*(-0.812436958497)*x_ref[1]**(o-1)+(0.928013493065)
        ref[5,0,0,2]=o*(0.763792541097)*x_ref[2]**(o-1)+(-0.430084528987)
        ref[5,0,1,0]=o*(0.451167682598)*x_ref[0]**(o-1)+(0.373015986015)
        ref[5,0,1,1]=o*(0.73334610852)*x_ref[1]**(o-1)+(0.44892130407)
        ref[5,0,1,2]=o*(0.820233215547)*x_ref[2]**(o-1)+(0.863864357936)
        ref[5,1,0,0]=o*(-0.700840074185)*x_ref[0]**(o-1)+(-0.637964737375)
        ref[5,1,0,1]=o*(0.0532062256138)*x_ref[1]**(o-1)+(-0.902662868597)
        ref[5,1,0,2]=o*(-0.91668008633)*x_ref[2]**(o-1)+(0.00253116545509)
        ref[5,1,1,0]=o*(0.0461834200484)*x_ref[0]**(o-1)+(0.102406795193)
        ref[5,1,1,1]=o*(0.599142154957)*x_ref[1]**(o-1)+(0.374585801545)
        ref[5,1,1,2]=o*(-0.444968156109)*x_ref[2]**(o-1)+(-0.932860816729)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnContactZero_fromData_ReducedSolution_rank0(self):
      """
      tests gradient for rank 0 Data on the ReducedFunctionOnContactZero

      assumptions: ReducedSolution(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnContactZero
      """
      o=1
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=ReducedSolution(self.domain)
      x=w.getX()
      arg=Data(0,(),w)
      ref=Data(0,()+(dim,),w_ref)
      if dim==2:
        arg=(1.37238770251)*x[0]+(-1.43917937019)*x[1]
        ref[0]=(1.37238770251)
        ref[1]=(-1.43917937019)
      else:
        arg=(0.951563810847)*x[0]+(-1.91408943437)*x[1]+(0.233861671105)*x[2]
        ref[0]=(0.951563810847)
        ref[1]=(-1.91408943437)
        ref[2]=(0.233861671105)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),()+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnContactZero_fromData_ReducedSolution_rank1(self):
      """
      tests gradient for rank 1 Data on the ReducedFunctionOnContactZero

      assumptions: ReducedSolution(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnContactZero
      """
      o=1
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=ReducedSolution(self.domain)
      x=w.getX()
      arg=Data(0,(2,),w)
      ref=Data(0,(2,)+(dim,),w_ref)
      if dim==2:
        arg[0]=(1.42921344972)*x[0]+(-0.911436505176)*x[1]
        arg[1]=(1.25688300316)*x[0]+(0.0536640238292)*x[1]
        ref[0,0]=(1.42921344972)
        ref[0,1]=(-0.911436505176)
        ref[1,0]=(1.25688300316)
        ref[1,1]=(0.0536640238292)
      else:
        arg[0]=(-1.57773112011)*x[0]+(-0.697311790617)*x[1]+(-0.480770363787)*x[2]
        arg[1]=(-0.136063655594)*x[0]+(0.882253548646)*x[1]+(1.35773570995)*x[2]
        ref[0,0]=(-1.57773112011)
        ref[0,1]=(-0.697311790617)
        ref[0,2]=(-0.480770363787)
        ref[1,0]=(-0.136063655594)
        ref[1,1]=(0.882253548646)
        ref[1,2]=(1.35773570995)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnContactZero_fromData_ReducedSolution_rank2(self):
      """
      tests gradient for rank 2 Data on the ReducedFunctionOnContactZero

      assumptions: ReducedSolution(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnContactZero
      """
      o=1
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=ReducedSolution(self.domain)
      x=w.getX()
      arg=Data(0,(4, 5),w)
      ref=Data(0,(4, 5)+(dim,),w_ref)
      if dim==2:
        arg[0,0]=(0.448247291087)*x[0]+(-0.00880442943882)*x[1]
        arg[0,1]=(-0.59784234455)*x[0]+(-0.94951606979)*x[1]
        arg[0,2]=(1.38316656933)*x[0]+(-0.124817047005)*x[1]
        arg[0,3]=(-0.0748469893414)*x[0]+(1.44145142047)*x[1]
        arg[0,4]=(1.81133385456)*x[0]+(-0.518406894403)*x[1]
        arg[1,0]=(-0.65460152624)*x[0]+(-0.350858526434)*x[1]
        arg[1,1]=(0.924058009558)*x[0]+(-0.40973995895)*x[1]
        arg[1,2]=(-0.299794705178)*x[0]+(-0.924557696915)*x[1]
        arg[1,3]=(-0.608513627169)*x[0]+(-0.141936714389)*x[1]
        arg[1,4]=(0.469099778997)*x[0]+(0.754132353456)*x[1]
        arg[2,0]=(-0.627098551951)*x[0]+(0.476865448119)*x[1]
        arg[2,1]=(-1.03564375134)*x[0]+(-0.280009187543)*x[1]
        arg[2,2]=(0.475083576156)*x[0]+(0.220248066616)*x[1]
        arg[2,3]=(0.0420499398173)*x[0]+(0.0808105284548)*x[1]
        arg[2,4]=(0.368173655662)*x[0]+(-0.58266909961)*x[1]
        arg[3,0]=(0.450851110298)*x[0]+(0.0844590226087)*x[1]
        arg[3,1]=(0.508010554654)*x[0]+(0.797109833792)*x[1]
        arg[3,2]=(0.711479388001)*x[0]+(1.12829906729)*x[1]
        arg[3,3]=(0.0588799697153)*x[0]+(-0.991874826409)*x[1]
        arg[3,4]=(0.743446045536)*x[0]+(0.65754450588)*x[1]
        ref[0,0,0]=(0.448247291087)
        ref[0,0,1]=(-0.00880442943882)
        ref[0,1,0]=(-0.59784234455)
        ref[0,1,1]=(-0.94951606979)
        ref[0,2,0]=(1.38316656933)
        ref[0,2,1]=(-0.124817047005)
        ref[0,3,0]=(-0.0748469893414)
        ref[0,3,1]=(1.44145142047)
        ref[0,4,0]=(1.81133385456)
        ref[0,4,1]=(-0.518406894403)
        ref[1,0,0]=(-0.65460152624)
        ref[1,0,1]=(-0.350858526434)
        ref[1,1,0]=(0.924058009558)
        ref[1,1,1]=(-0.40973995895)
        ref[1,2,0]=(-0.299794705178)
        ref[1,2,1]=(-0.924557696915)
        ref[1,3,0]=(-0.608513627169)
        ref[1,3,1]=(-0.141936714389)
        ref[1,4,0]=(0.469099778997)
        ref[1,4,1]=(0.754132353456)
        ref[2,0,0]=(-0.627098551951)
        ref[2,0,1]=(0.476865448119)
        ref[2,1,0]=(-1.03564375134)
        ref[2,1,1]=(-0.280009187543)
        ref[2,2,0]=(0.475083576156)
        ref[2,2,1]=(0.220248066616)
        ref[2,3,0]=(0.0420499398173)
        ref[2,3,1]=(0.0808105284548)
        ref[2,4,0]=(0.368173655662)
        ref[2,4,1]=(-0.58266909961)
        ref[3,0,0]=(0.450851110298)
        ref[3,0,1]=(0.0844590226087)
        ref[3,1,0]=(0.508010554654)
        ref[3,1,1]=(0.797109833792)
        ref[3,2,0]=(0.711479388001)
        ref[3,2,1]=(1.12829906729)
        ref[3,3,0]=(0.0588799697153)
        ref[3,3,1]=(-0.991874826409)
        ref[3,4,0]=(0.743446045536)
        ref[3,4,1]=(0.65754450588)
      else:
        arg[0,0]=(-0.43386387868)*x[0]+(0.321105491776)*x[1]+(0.384206679414)*x[2]
        arg[0,1]=(0.604698878149)*x[0]+(0.594375439325)*x[1]+(0.162832272176)*x[2]
        arg[0,2]=(-0.332194829416)*x[0]+(0.600821281937)*x[1]+(0.493622302813)*x[2]
        arg[0,3]=(0.846367268698)*x[0]+(-1.32744832381)*x[1]+(0.00466654421944)*x[2]
        arg[0,4]=(0.385111950936)*x[0]+(-0.176705693397)*x[1]+(0.461732370075)*x[2]
        arg[1,0]=(-0.14529643778)*x[0]+(1.15329219838)*x[1]+(0.157842247326)*x[2]
        arg[1,1]=(0.00817149012591)*x[0]+(-0.703898404732)*x[1]+(-1.14419500663)*x[2]
        arg[1,2]=(-0.124155034423)*x[0]+(0.906000496919)*x[1]+(-0.466071596735)*x[2]
        arg[1,3]=(0.413190740147)*x[0]+(0.968639404637)*x[1]+(-1.25413312698)*x[2]
        arg[1,4]=(0.521974966379)*x[0]+(0.936384991187)*x[1]+(-0.0630547476157)*x[2]
        arg[2,0]=(-0.334976510608)*x[0]+(-0.268364721371)*x[1]+(0.806974769679)*x[2]
        arg[2,1]=(-0.0672705162033)*x[0]+(0.459808873839)*x[1]+(0.0725634327358)*x[2]
        arg[2,2]=(0.142418012401)*x[0]+(-0.400301432498)*x[1]+(-1.37021128371)*x[2]
        arg[2,3]=(-1.60617980561)*x[0]+(0.0686943218654)*x[1]+(0.647509287658)*x[2]
        arg[2,4]=(0.0102366197695)*x[0]+(-1.24104511219)*x[1]+(-0.739463479584)*x[2]
        arg[3,0]=(-0.425526939568)*x[0]+(-0.946421307227)*x[1]+(0.133101457377)*x[2]
        arg[3,1]=(1.07183638389)*x[0]+(-1.21405997903)*x[1]+(-0.962984008606)*x[2]
        arg[3,2]=(-0.913456686897)*x[0]+(0.907233128077)*x[1]+(0.581609247137)*x[2]
        arg[3,3]=(-0.729544885457)*x[0]+(-0.433435638004)*x[1]+(0.357011166494)*x[2]
        arg[3,4]=(1.21906931308)*x[0]+(0.322487716786)*x[1]+(1.05602783674)*x[2]
        ref[0,0,0]=(-0.43386387868)
        ref[0,0,1]=(0.321105491776)
        ref[0,0,2]=(0.384206679414)
        ref[0,1,0]=(0.604698878149)
        ref[0,1,1]=(0.594375439325)
        ref[0,1,2]=(0.162832272176)
        ref[0,2,0]=(-0.332194829416)
        ref[0,2,1]=(0.600821281937)
        ref[0,2,2]=(0.493622302813)
        ref[0,3,0]=(0.846367268698)
        ref[0,3,1]=(-1.32744832381)
        ref[0,3,2]=(0.00466654421944)
        ref[0,4,0]=(0.385111950936)
        ref[0,4,1]=(-0.176705693397)
        ref[0,4,2]=(0.461732370075)
        ref[1,0,0]=(-0.14529643778)
        ref[1,0,1]=(1.15329219838)
        ref[1,0,2]=(0.157842247326)
        ref[1,1,0]=(0.00817149012591)
        ref[1,1,1]=(-0.703898404732)
        ref[1,1,2]=(-1.14419500663)
        ref[1,2,0]=(-0.124155034423)
        ref[1,2,1]=(0.906000496919)
        ref[1,2,2]=(-0.466071596735)
        ref[1,3,0]=(0.413190740147)
        ref[1,3,1]=(0.968639404637)
        ref[1,3,2]=(-1.25413312698)
        ref[1,4,0]=(0.521974966379)
        ref[1,4,1]=(0.936384991187)
        ref[1,4,2]=(-0.0630547476157)
        ref[2,0,0]=(-0.334976510608)
        ref[2,0,1]=(-0.268364721371)
        ref[2,0,2]=(0.806974769679)
        ref[2,1,0]=(-0.0672705162033)
        ref[2,1,1]=(0.459808873839)
        ref[2,1,2]=(0.0725634327358)
        ref[2,2,0]=(0.142418012401)
        ref[2,2,1]=(-0.400301432498)
        ref[2,2,2]=(-1.37021128371)
        ref[2,3,0]=(-1.60617980561)
        ref[2,3,1]=(0.0686943218654)
        ref[2,3,2]=(0.647509287658)
        ref[2,4,0]=(0.0102366197695)
        ref[2,4,1]=(-1.24104511219)
        ref[2,4,2]=(-0.739463479584)
        ref[3,0,0]=(-0.425526939568)
        ref[3,0,1]=(-0.946421307227)
        ref[3,0,2]=(0.133101457377)
        ref[3,1,0]=(1.07183638389)
        ref[3,1,1]=(-1.21405997903)
        ref[3,1,2]=(-0.962984008606)
        ref[3,2,0]=(-0.913456686897)
        ref[3,2,1]=(0.907233128077)
        ref[3,2,2]=(0.581609247137)
        ref[3,3,0]=(-0.729544885457)
        ref[3,3,1]=(-0.433435638004)
        ref[3,3,2]=(0.357011166494)
        ref[3,4,0]=(1.21906931308)
        ref[3,4,1]=(0.322487716786)
        ref[3,4,2]=(1.05602783674)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnContactZero_fromData_ReducedSolution_rank3(self):
      """
      tests gradient for rank 3 Data on the ReducedFunctionOnContactZero

      assumptions: ReducedSolution(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnContactZero
      """
      o=1
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=ReducedSolution(self.domain)
      x=w.getX()
      arg=Data(0,(6, 2, 2),w)
      ref=Data(0,(6, 2, 2)+(dim,),w_ref)
      if dim==2:
        arg[0,0,0]=(-0.287546203823)*x[0]+(0.390321729967)*x[1]
        arg[0,0,1]=(-0.112653571553)*x[0]+(-0.359753186922)*x[1]
        arg[0,1,0]=(0.00656985674969)*x[0]+(-0.397210304393)*x[1]
        arg[0,1,1]=(-0.825698431533)*x[0]+(-1.20994477496)*x[1]
        arg[1,0,0]=(0.0456789352898)*x[0]+(0.201178709355)*x[1]
        arg[1,0,1]=(0.216619650199)*x[0]+(-0.684237394127)*x[1]
        arg[1,1,0]=(-0.452605086273)*x[0]+(0.383220784575)*x[1]
        arg[1,1,1]=(-0.385315869703)*x[0]+(-1.25937320051)*x[1]
        arg[2,0,0]=(-0.546290546777)*x[0]+(0.0659124729108)*x[1]
        arg[2,0,1]=(0.23413834434)*x[0]+(0.241510050424)*x[1]
        arg[2,1,0]=(-0.541097368124)*x[0]+(0.458682016611)*x[1]
        arg[2,1,1]=(0.314030173817)*x[0]+(0.083613884286)*x[1]
        arg[3,0,0]=(0.862005271666)*x[0]+(0.858693755091)*x[1]
        arg[3,0,1]=(-1.14220805291)*x[0]+(0.609875693913)*x[1]
        arg[3,1,0]=(-0.847069360014)*x[0]+(0.240069314456)*x[1]
        arg[3,1,1]=(0.480596211718)*x[0]+(-1.40901297384)*x[1]
        arg[4,0,0]=(-1.38036653523)*x[0]+(-0.0732955000278)*x[1]
        arg[4,0,1]=(0.0716061704803)*x[0]+(0.180127379412)*x[1]
        arg[4,1,0]=(1.26959959862)*x[0]+(-1.38131896436)*x[1]
        arg[4,1,1]=(0.204280361123)*x[0]+(0.532611514369)*x[1]
        arg[5,0,0]=(0.209536293545)*x[0]+(-0.303994906788)*x[1]
        arg[5,0,1]=(1.41150162289)*x[0]+(1.32515735407)*x[1]
        arg[5,1,0]=(1.59736027384)*x[0]+(-0.711055564868)*x[1]
        arg[5,1,1]=(-1.31799658024)*x[0]+(0.829209493108)*x[1]
        ref[0,0,0,0]=(-0.287546203823)
        ref[0,0,0,1]=(0.390321729967)
        ref[0,0,1,0]=(-0.112653571553)
        ref[0,0,1,1]=(-0.359753186922)
        ref[0,1,0,0]=(0.00656985674969)
        ref[0,1,0,1]=(-0.397210304393)
        ref[0,1,1,0]=(-0.825698431533)
        ref[0,1,1,1]=(-1.20994477496)
        ref[1,0,0,0]=(0.0456789352898)
        ref[1,0,0,1]=(0.201178709355)
        ref[1,0,1,0]=(0.216619650199)
        ref[1,0,1,1]=(-0.684237394127)
        ref[1,1,0,0]=(-0.452605086273)
        ref[1,1,0,1]=(0.383220784575)
        ref[1,1,1,0]=(-0.385315869703)
        ref[1,1,1,1]=(-1.25937320051)
        ref[2,0,0,0]=(-0.546290546777)
        ref[2,0,0,1]=(0.0659124729108)
        ref[2,0,1,0]=(0.23413834434)
        ref[2,0,1,1]=(0.241510050424)
        ref[2,1,0,0]=(-0.541097368124)
        ref[2,1,0,1]=(0.458682016611)
        ref[2,1,1,0]=(0.314030173817)
        ref[2,1,1,1]=(0.083613884286)
        ref[3,0,0,0]=(0.862005271666)
        ref[3,0,0,1]=(0.858693755091)
        ref[3,0,1,0]=(-1.14220805291)
        ref[3,0,1,1]=(0.609875693913)
        ref[3,1,0,0]=(-0.847069360014)
        ref[3,1,0,1]=(0.240069314456)
        ref[3,1,1,0]=(0.480596211718)
        ref[3,1,1,1]=(-1.40901297384)
        ref[4,0,0,0]=(-1.38036653523)
        ref[4,0,0,1]=(-0.0732955000278)
        ref[4,0,1,0]=(0.0716061704803)
        ref[4,0,1,1]=(0.180127379412)
        ref[4,1,0,0]=(1.26959959862)
        ref[4,1,0,1]=(-1.38131896436)
        ref[4,1,1,0]=(0.204280361123)
        ref[4,1,1,1]=(0.532611514369)
        ref[5,0,0,0]=(0.209536293545)
        ref[5,0,0,1]=(-0.303994906788)
        ref[5,0,1,0]=(1.41150162289)
        ref[5,0,1,1]=(1.32515735407)
        ref[5,1,0,0]=(1.59736027384)
        ref[5,1,0,1]=(-0.711055564868)
        ref[5,1,1,0]=(-1.31799658024)
        ref[5,1,1,1]=(0.829209493108)
      else:
        arg[0,0,0]=(0.832267408258)*x[0]+(-1.1995239623)*x[1]+(-1.81276973398)*x[2]
        arg[0,0,1]=(-0.0125232856194)*x[0]+(0.122543918666)*x[1]+(-1.12411286836)*x[2]
        arg[0,1,0]=(0.985611388383)*x[0]+(-1.17217207383)*x[1]+(-0.231241872108)*x[2]
        arg[0,1,1]=(0.625494139449)*x[0]+(0.784802683192)*x[1]+(0.612764525973)*x[2]
        arg[1,0,0]=(0.327644975022)*x[0]+(0.0552951801276)*x[1]+(-0.806887445103)*x[2]
        arg[1,0,1]=(0.194338798022)*x[0]+(0.799902026341)*x[1]+(1.70164249741)*x[2]
        arg[1,1,0]=(0.890832636865)*x[0]+(0.223899365292)*x[1]+(-0.283094526824)*x[2]
        arg[1,1,1]=(-0.122108330088)*x[0]+(-0.293413695547)*x[1]+(-0.371581852879)*x[2]
        arg[2,0,0]=(-0.469341678297)*x[0]+(0.152856292978)*x[1]+(0.765861314481)*x[2]
        arg[2,0,1]=(0.249219162734)*x[0]+(0.319622173697)*x[1]+(-0.182998471546)*x[2]
        arg[2,1,0]=(0.39687496584)*x[0]+(0.137084411978)*x[1]+(-0.34707250854)*x[2]
        arg[2,1,1]=(-0.382391798519)*x[0]+(0.755317411547)*x[1]+(0.424204162929)*x[2]
        arg[3,0,0]=(1.12637976255)*x[0]+(0.11632178776)*x[1]+(-0.615547388072)*x[2]
        arg[3,0,1]=(-0.819303259446)*x[0]+(0.916951216368)*x[1]+(-0.572792050441)*x[2]
        arg[3,1,0]=(0.194642055711)*x[0]+(0.949663114037)*x[1]+(-0.403001914682)*x[2]
        arg[3,1,1]=(0.902547242635)*x[0]+(-1.04027936291)*x[1]+(-1.78463515221)*x[2]
        arg[4,0,0]=(0.59060036737)*x[0]+(-0.580905638676)*x[1]+(-0.486098556884)*x[2]
        arg[4,0,1]=(-0.330634605524)*x[0]+(-0.758140973629)*x[1]+(-0.192282397672)*x[2]
        arg[4,1,0]=(1.40502801336)*x[0]+(0.199036161455)*x[1]+(-0.558660947885)*x[2]
        arg[4,1,1]=(-0.155588274273)*x[0]+(-0.57050736529)*x[1]+(1.1998664442)*x[2]
        arg[5,0,0]=(-0.754680865929)*x[0]+(1.29040984028)*x[1]+(-1.83778974463)*x[2]
        arg[5,0,1]=(0.274692501647)*x[0]+(0.368546080921)*x[1]+(-0.446376269232)*x[2]
        arg[5,1,0]=(-0.758704372861)*x[0]+(1.75555227426)*x[1]+(-0.13664688871)*x[2]
        arg[5,1,1]=(-0.568468068187)*x[0]+(-0.320218561544)*x[1]+(-0.827795466031)*x[2]
        ref[0,0,0,0]=(0.832267408258)
        ref[0,0,0,1]=(-1.1995239623)
        ref[0,0,0,2]=(-1.81276973398)
        ref[0,0,1,0]=(-0.0125232856194)
        ref[0,0,1,1]=(0.122543918666)
        ref[0,0,1,2]=(-1.12411286836)
        ref[0,1,0,0]=(0.985611388383)
        ref[0,1,0,1]=(-1.17217207383)
        ref[0,1,0,2]=(-0.231241872108)
        ref[0,1,1,0]=(0.625494139449)
        ref[0,1,1,1]=(0.784802683192)
        ref[0,1,1,2]=(0.612764525973)
        ref[1,0,0,0]=(0.327644975022)
        ref[1,0,0,1]=(0.0552951801276)
        ref[1,0,0,2]=(-0.806887445103)
        ref[1,0,1,0]=(0.194338798022)
        ref[1,0,1,1]=(0.799902026341)
        ref[1,0,1,2]=(1.70164249741)
        ref[1,1,0,0]=(0.890832636865)
        ref[1,1,0,1]=(0.223899365292)
        ref[1,1,0,2]=(-0.283094526824)
        ref[1,1,1,0]=(-0.122108330088)
        ref[1,1,1,1]=(-0.293413695547)
        ref[1,1,1,2]=(-0.371581852879)
        ref[2,0,0,0]=(-0.469341678297)
        ref[2,0,0,1]=(0.152856292978)
        ref[2,0,0,2]=(0.765861314481)
        ref[2,0,1,0]=(0.249219162734)
        ref[2,0,1,1]=(0.319622173697)
        ref[2,0,1,2]=(-0.182998471546)
        ref[2,1,0,0]=(0.39687496584)
        ref[2,1,0,1]=(0.137084411978)
        ref[2,1,0,2]=(-0.34707250854)
        ref[2,1,1,0]=(-0.382391798519)
        ref[2,1,1,1]=(0.755317411547)
        ref[2,1,1,2]=(0.424204162929)
        ref[3,0,0,0]=(1.12637976255)
        ref[3,0,0,1]=(0.11632178776)
        ref[3,0,0,2]=(-0.615547388072)
        ref[3,0,1,0]=(-0.819303259446)
        ref[3,0,1,1]=(0.916951216368)
        ref[3,0,1,2]=(-0.572792050441)
        ref[3,1,0,0]=(0.194642055711)
        ref[3,1,0,1]=(0.949663114037)
        ref[3,1,0,2]=(-0.403001914682)
        ref[3,1,1,0]=(0.902547242635)
        ref[3,1,1,1]=(-1.04027936291)
        ref[3,1,1,2]=(-1.78463515221)
        ref[4,0,0,0]=(0.59060036737)
        ref[4,0,0,1]=(-0.580905638676)
        ref[4,0,0,2]=(-0.486098556884)
        ref[4,0,1,0]=(-0.330634605524)
        ref[4,0,1,1]=(-0.758140973629)
        ref[4,0,1,2]=(-0.192282397672)
        ref[4,1,0,0]=(1.40502801336)
        ref[4,1,0,1]=(0.199036161455)
        ref[4,1,0,2]=(-0.558660947885)
        ref[4,1,1,0]=(-0.155588274273)
        ref[4,1,1,1]=(-0.57050736529)
        ref[4,1,1,2]=(1.1998664442)
        ref[5,0,0,0]=(-0.754680865929)
        ref[5,0,0,1]=(1.29040984028)
        ref[5,0,0,2]=(-1.83778974463)
        ref[5,0,1,0]=(0.274692501647)
        ref[5,0,1,1]=(0.368546080921)
        ref[5,0,1,2]=(-0.446376269232)
        ref[5,1,0,0]=(-0.758704372861)
        ref[5,1,0,1]=(1.75555227426)
        ref[5,1,0,2]=(-0.13664688871)
        ref[5,1,1,0]=(-0.568468068187)
        ref[5,1,1,1]=(-0.320218561544)
        ref[5,1,1,2]=(-0.827795466031)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnContactZero_fromData_ReducedContinuousFunction_rank0(self):
      """
      tests gradient for rank 0 Data on the ReducedFunctionOnContactZero

      assumptions: ReducedContinuousFunction(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnContactZero
      """
      o=1
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=ReducedContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(),w)
      ref=Data(0,()+(dim,),w_ref)
      if dim==2:
        arg=(1.37238770251)*x[0]+(-1.43917937019)*x[1]
        ref[0]=(1.37238770251)
        ref[1]=(-1.43917937019)
      else:
        arg=(0.951563810847)*x[0]+(-1.91408943437)*x[1]+(0.233861671105)*x[2]
        ref[0]=(0.951563810847)
        ref[1]=(-1.91408943437)
        ref[2]=(0.233861671105)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),()+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnContactZero_fromData_ReducedContinuousFunction_rank1(self):
      """
      tests gradient for rank 1 Data on the ReducedFunctionOnContactZero

      assumptions: ReducedContinuousFunction(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnContactZero
      """
      o=1
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=ReducedContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(2,),w)
      ref=Data(0,(2,)+(dim,),w_ref)
      if dim==2:
        arg[0]=(1.42921344972)*x[0]+(-0.911436505176)*x[1]
        arg[1]=(1.25688300316)*x[0]+(0.0536640238292)*x[1]
        ref[0,0]=(1.42921344972)
        ref[0,1]=(-0.911436505176)
        ref[1,0]=(1.25688300316)
        ref[1,1]=(0.0536640238292)
      else:
        arg[0]=(-1.57773112011)*x[0]+(-0.697311790617)*x[1]+(-0.480770363787)*x[2]
        arg[1]=(-0.136063655594)*x[0]+(0.882253548646)*x[1]+(1.35773570995)*x[2]
        ref[0,0]=(-1.57773112011)
        ref[0,1]=(-0.697311790617)
        ref[0,2]=(-0.480770363787)
        ref[1,0]=(-0.136063655594)
        ref[1,1]=(0.882253548646)
        ref[1,2]=(1.35773570995)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnContactZero_fromData_ReducedContinuousFunction_rank2(self):
      """
      tests gradient for rank 2 Data on the ReducedFunctionOnContactZero

      assumptions: ReducedContinuousFunction(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnContactZero
      """
      o=1
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=ReducedContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(4, 5),w)
      ref=Data(0,(4, 5)+(dim,),w_ref)
      if dim==2:
        arg[0,0]=(0.448247291087)*x[0]+(-0.00880442943882)*x[1]
        arg[0,1]=(-0.59784234455)*x[0]+(-0.94951606979)*x[1]
        arg[0,2]=(1.38316656933)*x[0]+(-0.124817047005)*x[1]
        arg[0,3]=(-0.0748469893414)*x[0]+(1.44145142047)*x[1]
        arg[0,4]=(1.81133385456)*x[0]+(-0.518406894403)*x[1]
        arg[1,0]=(-0.65460152624)*x[0]+(-0.350858526434)*x[1]
        arg[1,1]=(0.924058009558)*x[0]+(-0.40973995895)*x[1]
        arg[1,2]=(-0.299794705178)*x[0]+(-0.924557696915)*x[1]
        arg[1,3]=(-0.608513627169)*x[0]+(-0.141936714389)*x[1]
        arg[1,4]=(0.469099778997)*x[0]+(0.754132353456)*x[1]
        arg[2,0]=(-0.627098551951)*x[0]+(0.476865448119)*x[1]
        arg[2,1]=(-1.03564375134)*x[0]+(-0.280009187543)*x[1]
        arg[2,2]=(0.475083576156)*x[0]+(0.220248066616)*x[1]
        arg[2,3]=(0.0420499398173)*x[0]+(0.0808105284548)*x[1]
        arg[2,4]=(0.368173655662)*x[0]+(-0.58266909961)*x[1]
        arg[3,0]=(0.450851110298)*x[0]+(0.0844590226087)*x[1]
        arg[3,1]=(0.508010554654)*x[0]+(0.797109833792)*x[1]
        arg[3,2]=(0.711479388001)*x[0]+(1.12829906729)*x[1]
        arg[3,3]=(0.0588799697153)*x[0]+(-0.991874826409)*x[1]
        arg[3,4]=(0.743446045536)*x[0]+(0.65754450588)*x[1]
        ref[0,0,0]=(0.448247291087)
        ref[0,0,1]=(-0.00880442943882)
        ref[0,1,0]=(-0.59784234455)
        ref[0,1,1]=(-0.94951606979)
        ref[0,2,0]=(1.38316656933)
        ref[0,2,1]=(-0.124817047005)
        ref[0,3,0]=(-0.0748469893414)
        ref[0,3,1]=(1.44145142047)
        ref[0,4,0]=(1.81133385456)
        ref[0,4,1]=(-0.518406894403)
        ref[1,0,0]=(-0.65460152624)
        ref[1,0,1]=(-0.350858526434)
        ref[1,1,0]=(0.924058009558)
        ref[1,1,1]=(-0.40973995895)
        ref[1,2,0]=(-0.299794705178)
        ref[1,2,1]=(-0.924557696915)
        ref[1,3,0]=(-0.608513627169)
        ref[1,3,1]=(-0.141936714389)
        ref[1,4,0]=(0.469099778997)
        ref[1,4,1]=(0.754132353456)
        ref[2,0,0]=(-0.627098551951)
        ref[2,0,1]=(0.476865448119)
        ref[2,1,0]=(-1.03564375134)
        ref[2,1,1]=(-0.280009187543)
        ref[2,2,0]=(0.475083576156)
        ref[2,2,1]=(0.220248066616)
        ref[2,3,0]=(0.0420499398173)
        ref[2,3,1]=(0.0808105284548)
        ref[2,4,0]=(0.368173655662)
        ref[2,4,1]=(-0.58266909961)
        ref[3,0,0]=(0.450851110298)
        ref[3,0,1]=(0.0844590226087)
        ref[3,1,0]=(0.508010554654)
        ref[3,1,1]=(0.797109833792)
        ref[3,2,0]=(0.711479388001)
        ref[3,2,1]=(1.12829906729)
        ref[3,3,0]=(0.0588799697153)
        ref[3,3,1]=(-0.991874826409)
        ref[3,4,0]=(0.743446045536)
        ref[3,4,1]=(0.65754450588)
      else:
        arg[0,0]=(-0.43386387868)*x[0]+(0.321105491776)*x[1]+(0.384206679414)*x[2]
        arg[0,1]=(0.604698878149)*x[0]+(0.594375439325)*x[1]+(0.162832272176)*x[2]
        arg[0,2]=(-0.332194829416)*x[0]+(0.600821281937)*x[1]+(0.493622302813)*x[2]
        arg[0,3]=(0.846367268698)*x[0]+(-1.32744832381)*x[1]+(0.00466654421944)*x[2]
        arg[0,4]=(0.385111950936)*x[0]+(-0.176705693397)*x[1]+(0.461732370075)*x[2]
        arg[1,0]=(-0.14529643778)*x[0]+(1.15329219838)*x[1]+(0.157842247326)*x[2]
        arg[1,1]=(0.00817149012591)*x[0]+(-0.703898404732)*x[1]+(-1.14419500663)*x[2]
        arg[1,2]=(-0.124155034423)*x[0]+(0.906000496919)*x[1]+(-0.466071596735)*x[2]
        arg[1,3]=(0.413190740147)*x[0]+(0.968639404637)*x[1]+(-1.25413312698)*x[2]
        arg[1,4]=(0.521974966379)*x[0]+(0.936384991187)*x[1]+(-0.0630547476157)*x[2]
        arg[2,0]=(-0.334976510608)*x[0]+(-0.268364721371)*x[1]+(0.806974769679)*x[2]
        arg[2,1]=(-0.0672705162033)*x[0]+(0.459808873839)*x[1]+(0.0725634327358)*x[2]
        arg[2,2]=(0.142418012401)*x[0]+(-0.400301432498)*x[1]+(-1.37021128371)*x[2]
        arg[2,3]=(-1.60617980561)*x[0]+(0.0686943218654)*x[1]+(0.647509287658)*x[2]
        arg[2,4]=(0.0102366197695)*x[0]+(-1.24104511219)*x[1]+(-0.739463479584)*x[2]
        arg[3,0]=(-0.425526939568)*x[0]+(-0.946421307227)*x[1]+(0.133101457377)*x[2]
        arg[3,1]=(1.07183638389)*x[0]+(-1.21405997903)*x[1]+(-0.962984008606)*x[2]
        arg[3,2]=(-0.913456686897)*x[0]+(0.907233128077)*x[1]+(0.581609247137)*x[2]
        arg[3,3]=(-0.729544885457)*x[0]+(-0.433435638004)*x[1]+(0.357011166494)*x[2]
        arg[3,4]=(1.21906931308)*x[0]+(0.322487716786)*x[1]+(1.05602783674)*x[2]
        ref[0,0,0]=(-0.43386387868)
        ref[0,0,1]=(0.321105491776)
        ref[0,0,2]=(0.384206679414)
        ref[0,1,0]=(0.604698878149)
        ref[0,1,1]=(0.594375439325)
        ref[0,1,2]=(0.162832272176)
        ref[0,2,0]=(-0.332194829416)
        ref[0,2,1]=(0.600821281937)
        ref[0,2,2]=(0.493622302813)
        ref[0,3,0]=(0.846367268698)
        ref[0,3,1]=(-1.32744832381)
        ref[0,3,2]=(0.00466654421944)
        ref[0,4,0]=(0.385111950936)
        ref[0,4,1]=(-0.176705693397)
        ref[0,4,2]=(0.461732370075)
        ref[1,0,0]=(-0.14529643778)
        ref[1,0,1]=(1.15329219838)
        ref[1,0,2]=(0.157842247326)
        ref[1,1,0]=(0.00817149012591)
        ref[1,1,1]=(-0.703898404732)
        ref[1,1,2]=(-1.14419500663)
        ref[1,2,0]=(-0.124155034423)
        ref[1,2,1]=(0.906000496919)
        ref[1,2,2]=(-0.466071596735)
        ref[1,3,0]=(0.413190740147)
        ref[1,3,1]=(0.968639404637)
        ref[1,3,2]=(-1.25413312698)
        ref[1,4,0]=(0.521974966379)
        ref[1,4,1]=(0.936384991187)
        ref[1,4,2]=(-0.0630547476157)
        ref[2,0,0]=(-0.334976510608)
        ref[2,0,1]=(-0.268364721371)
        ref[2,0,2]=(0.806974769679)
        ref[2,1,0]=(-0.0672705162033)
        ref[2,1,1]=(0.459808873839)
        ref[2,1,2]=(0.0725634327358)
        ref[2,2,0]=(0.142418012401)
        ref[2,2,1]=(-0.400301432498)
        ref[2,2,2]=(-1.37021128371)
        ref[2,3,0]=(-1.60617980561)
        ref[2,3,1]=(0.0686943218654)
        ref[2,3,2]=(0.647509287658)
        ref[2,4,0]=(0.0102366197695)
        ref[2,4,1]=(-1.24104511219)
        ref[2,4,2]=(-0.739463479584)
        ref[3,0,0]=(-0.425526939568)
        ref[3,0,1]=(-0.946421307227)
        ref[3,0,2]=(0.133101457377)
        ref[3,1,0]=(1.07183638389)
        ref[3,1,1]=(-1.21405997903)
        ref[3,1,2]=(-0.962984008606)
        ref[3,2,0]=(-0.913456686897)
        ref[3,2,1]=(0.907233128077)
        ref[3,2,2]=(0.581609247137)
        ref[3,3,0]=(-0.729544885457)
        ref[3,3,1]=(-0.433435638004)
        ref[3,3,2]=(0.357011166494)
        ref[3,4,0]=(1.21906931308)
        ref[3,4,1]=(0.322487716786)
        ref[3,4,2]=(1.05602783674)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnContactZero_fromData_ReducedContinuousFunction_rank3(self):
      """
      tests gradient for rank 3 Data on the ReducedFunctionOnContactZero

      assumptions: ReducedContinuousFunction(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnContactZero
      """
      o=1
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=ReducedContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(6, 2, 2),w)
      ref=Data(0,(6, 2, 2)+(dim,),w_ref)
      if dim==2:
        arg[0,0,0]=(-0.287546203823)*x[0]+(0.390321729967)*x[1]
        arg[0,0,1]=(-0.112653571553)*x[0]+(-0.359753186922)*x[1]
        arg[0,1,0]=(0.00656985674969)*x[0]+(-0.397210304393)*x[1]
        arg[0,1,1]=(-0.825698431533)*x[0]+(-1.20994477496)*x[1]
        arg[1,0,0]=(0.0456789352898)*x[0]+(0.201178709355)*x[1]
        arg[1,0,1]=(0.216619650199)*x[0]+(-0.684237394127)*x[1]
        arg[1,1,0]=(-0.452605086273)*x[0]+(0.383220784575)*x[1]
        arg[1,1,1]=(-0.385315869703)*x[0]+(-1.25937320051)*x[1]
        arg[2,0,0]=(-0.546290546777)*x[0]+(0.0659124729108)*x[1]
        arg[2,0,1]=(0.23413834434)*x[0]+(0.241510050424)*x[1]
        arg[2,1,0]=(-0.541097368124)*x[0]+(0.458682016611)*x[1]
        arg[2,1,1]=(0.314030173817)*x[0]+(0.083613884286)*x[1]
        arg[3,0,0]=(0.862005271666)*x[0]+(0.858693755091)*x[1]
        arg[3,0,1]=(-1.14220805291)*x[0]+(0.609875693913)*x[1]
        arg[3,1,0]=(-0.847069360014)*x[0]+(0.240069314456)*x[1]
        arg[3,1,1]=(0.480596211718)*x[0]+(-1.40901297384)*x[1]
        arg[4,0,0]=(-1.38036653523)*x[0]+(-0.0732955000278)*x[1]
        arg[4,0,1]=(0.0716061704803)*x[0]+(0.180127379412)*x[1]
        arg[4,1,0]=(1.26959959862)*x[0]+(-1.38131896436)*x[1]
        arg[4,1,1]=(0.204280361123)*x[0]+(0.532611514369)*x[1]
        arg[5,0,0]=(0.209536293545)*x[0]+(-0.303994906788)*x[1]
        arg[5,0,1]=(1.41150162289)*x[0]+(1.32515735407)*x[1]
        arg[5,1,0]=(1.59736027384)*x[0]+(-0.711055564868)*x[1]
        arg[5,1,1]=(-1.31799658024)*x[0]+(0.829209493108)*x[1]
        ref[0,0,0,0]=(-0.287546203823)
        ref[0,0,0,1]=(0.390321729967)
        ref[0,0,1,0]=(-0.112653571553)
        ref[0,0,1,1]=(-0.359753186922)
        ref[0,1,0,0]=(0.00656985674969)
        ref[0,1,0,1]=(-0.397210304393)
        ref[0,1,1,0]=(-0.825698431533)
        ref[0,1,1,1]=(-1.20994477496)
        ref[1,0,0,0]=(0.0456789352898)
        ref[1,0,0,1]=(0.201178709355)
        ref[1,0,1,0]=(0.216619650199)
        ref[1,0,1,1]=(-0.684237394127)
        ref[1,1,0,0]=(-0.452605086273)
        ref[1,1,0,1]=(0.383220784575)
        ref[1,1,1,0]=(-0.385315869703)
        ref[1,1,1,1]=(-1.25937320051)
        ref[2,0,0,0]=(-0.546290546777)
        ref[2,0,0,1]=(0.0659124729108)
        ref[2,0,1,0]=(0.23413834434)
        ref[2,0,1,1]=(0.241510050424)
        ref[2,1,0,0]=(-0.541097368124)
        ref[2,1,0,1]=(0.458682016611)
        ref[2,1,1,0]=(0.314030173817)
        ref[2,1,1,1]=(0.083613884286)
        ref[3,0,0,0]=(0.862005271666)
        ref[3,0,0,1]=(0.858693755091)
        ref[3,0,1,0]=(-1.14220805291)
        ref[3,0,1,1]=(0.609875693913)
        ref[3,1,0,0]=(-0.847069360014)
        ref[3,1,0,1]=(0.240069314456)
        ref[3,1,1,0]=(0.480596211718)
        ref[3,1,1,1]=(-1.40901297384)
        ref[4,0,0,0]=(-1.38036653523)
        ref[4,0,0,1]=(-0.0732955000278)
        ref[4,0,1,0]=(0.0716061704803)
        ref[4,0,1,1]=(0.180127379412)
        ref[4,1,0,0]=(1.26959959862)
        ref[4,1,0,1]=(-1.38131896436)
        ref[4,1,1,0]=(0.204280361123)
        ref[4,1,1,1]=(0.532611514369)
        ref[5,0,0,0]=(0.209536293545)
        ref[5,0,0,1]=(-0.303994906788)
        ref[5,0,1,0]=(1.41150162289)
        ref[5,0,1,1]=(1.32515735407)
        ref[5,1,0,0]=(1.59736027384)
        ref[5,1,0,1]=(-0.711055564868)
        ref[5,1,1,0]=(-1.31799658024)
        ref[5,1,1,1]=(0.829209493108)
      else:
        arg[0,0,0]=(0.832267408258)*x[0]+(-1.1995239623)*x[1]+(-1.81276973398)*x[2]
        arg[0,0,1]=(-0.0125232856194)*x[0]+(0.122543918666)*x[1]+(-1.12411286836)*x[2]
        arg[0,1,0]=(0.985611388383)*x[0]+(-1.17217207383)*x[1]+(-0.231241872108)*x[2]
        arg[0,1,1]=(0.625494139449)*x[0]+(0.784802683192)*x[1]+(0.612764525973)*x[2]
        arg[1,0,0]=(0.327644975022)*x[0]+(0.0552951801276)*x[1]+(-0.806887445103)*x[2]
        arg[1,0,1]=(0.194338798022)*x[0]+(0.799902026341)*x[1]+(1.70164249741)*x[2]
        arg[1,1,0]=(0.890832636865)*x[0]+(0.223899365292)*x[1]+(-0.283094526824)*x[2]
        arg[1,1,1]=(-0.122108330088)*x[0]+(-0.293413695547)*x[1]+(-0.371581852879)*x[2]
        arg[2,0,0]=(-0.469341678297)*x[0]+(0.152856292978)*x[1]+(0.765861314481)*x[2]
        arg[2,0,1]=(0.249219162734)*x[0]+(0.319622173697)*x[1]+(-0.182998471546)*x[2]
        arg[2,1,0]=(0.39687496584)*x[0]+(0.137084411978)*x[1]+(-0.34707250854)*x[2]
        arg[2,1,1]=(-0.382391798519)*x[0]+(0.755317411547)*x[1]+(0.424204162929)*x[2]
        arg[3,0,0]=(1.12637976255)*x[0]+(0.11632178776)*x[1]+(-0.615547388072)*x[2]
        arg[3,0,1]=(-0.819303259446)*x[0]+(0.916951216368)*x[1]+(-0.572792050441)*x[2]
        arg[3,1,0]=(0.194642055711)*x[0]+(0.949663114037)*x[1]+(-0.403001914682)*x[2]
        arg[3,1,1]=(0.902547242635)*x[0]+(-1.04027936291)*x[1]+(-1.78463515221)*x[2]
        arg[4,0,0]=(0.59060036737)*x[0]+(-0.580905638676)*x[1]+(-0.486098556884)*x[2]
        arg[4,0,1]=(-0.330634605524)*x[0]+(-0.758140973629)*x[1]+(-0.192282397672)*x[2]
        arg[4,1,0]=(1.40502801336)*x[0]+(0.199036161455)*x[1]+(-0.558660947885)*x[2]
        arg[4,1,1]=(-0.155588274273)*x[0]+(-0.57050736529)*x[1]+(1.1998664442)*x[2]
        arg[5,0,0]=(-0.754680865929)*x[0]+(1.29040984028)*x[1]+(-1.83778974463)*x[2]
        arg[5,0,1]=(0.274692501647)*x[0]+(0.368546080921)*x[1]+(-0.446376269232)*x[2]
        arg[5,1,0]=(-0.758704372861)*x[0]+(1.75555227426)*x[1]+(-0.13664688871)*x[2]
        arg[5,1,1]=(-0.568468068187)*x[0]+(-0.320218561544)*x[1]+(-0.827795466031)*x[2]
        ref[0,0,0,0]=(0.832267408258)
        ref[0,0,0,1]=(-1.1995239623)
        ref[0,0,0,2]=(-1.81276973398)
        ref[0,0,1,0]=(-0.0125232856194)
        ref[0,0,1,1]=(0.122543918666)
        ref[0,0,1,2]=(-1.12411286836)
        ref[0,1,0,0]=(0.985611388383)
        ref[0,1,0,1]=(-1.17217207383)
        ref[0,1,0,2]=(-0.231241872108)
        ref[0,1,1,0]=(0.625494139449)
        ref[0,1,1,1]=(0.784802683192)
        ref[0,1,1,2]=(0.612764525973)
        ref[1,0,0,0]=(0.327644975022)
        ref[1,0,0,1]=(0.0552951801276)
        ref[1,0,0,2]=(-0.806887445103)
        ref[1,0,1,0]=(0.194338798022)
        ref[1,0,1,1]=(0.799902026341)
        ref[1,0,1,2]=(1.70164249741)
        ref[1,1,0,0]=(0.890832636865)
        ref[1,1,0,1]=(0.223899365292)
        ref[1,1,0,2]=(-0.283094526824)
        ref[1,1,1,0]=(-0.122108330088)
        ref[1,1,1,1]=(-0.293413695547)
        ref[1,1,1,2]=(-0.371581852879)
        ref[2,0,0,0]=(-0.469341678297)
        ref[2,0,0,1]=(0.152856292978)
        ref[2,0,0,2]=(0.765861314481)
        ref[2,0,1,0]=(0.249219162734)
        ref[2,0,1,1]=(0.319622173697)
        ref[2,0,1,2]=(-0.182998471546)
        ref[2,1,0,0]=(0.39687496584)
        ref[2,1,0,1]=(0.137084411978)
        ref[2,1,0,2]=(-0.34707250854)
        ref[2,1,1,0]=(-0.382391798519)
        ref[2,1,1,1]=(0.755317411547)
        ref[2,1,1,2]=(0.424204162929)
        ref[3,0,0,0]=(1.12637976255)
        ref[3,0,0,1]=(0.11632178776)
        ref[3,0,0,2]=(-0.615547388072)
        ref[3,0,1,0]=(-0.819303259446)
        ref[3,0,1,1]=(0.916951216368)
        ref[3,0,1,2]=(-0.572792050441)
        ref[3,1,0,0]=(0.194642055711)
        ref[3,1,0,1]=(0.949663114037)
        ref[3,1,0,2]=(-0.403001914682)
        ref[3,1,1,0]=(0.902547242635)
        ref[3,1,1,1]=(-1.04027936291)
        ref[3,1,1,2]=(-1.78463515221)
        ref[4,0,0,0]=(0.59060036737)
        ref[4,0,0,1]=(-0.580905638676)
        ref[4,0,0,2]=(-0.486098556884)
        ref[4,0,1,0]=(-0.330634605524)
        ref[4,0,1,1]=(-0.758140973629)
        ref[4,0,1,2]=(-0.192282397672)
        ref[4,1,0,0]=(1.40502801336)
        ref[4,1,0,1]=(0.199036161455)
        ref[4,1,0,2]=(-0.558660947885)
        ref[4,1,1,0]=(-0.155588274273)
        ref[4,1,1,1]=(-0.57050736529)
        ref[4,1,1,2]=(1.1998664442)
        ref[5,0,0,0]=(-0.754680865929)
        ref[5,0,0,1]=(1.29040984028)
        ref[5,0,0,2]=(-1.83778974463)
        ref[5,0,1,0]=(0.274692501647)
        ref[5,0,1,1]=(0.368546080921)
        ref[5,0,1,2]=(-0.446376269232)
        ref[5,1,0,0]=(-0.758704372861)
        ref[5,1,0,1]=(1.75555227426)
        ref[5,1,0,2]=(-0.13664688871)
        ref[5,1,1,0]=(-0.568468068187)
        ref[5,1,1,1]=(-0.320218561544)
        ref[5,1,1,2]=(-0.827795466031)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnContactOne_fromData_ContinuousFunction_rank0(self):
      """
      tests gradient for rank 0 Data on the FunctionOnContactOne

      assumptions: ContinuousFunction(self.domain) exists
                   self.domain supports gradient on FunctionOnContactOne
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=FunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=ContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(),w)
      ref=Data(0,()+(dim,),w_ref)
      if dim==2:
        arg=(-0.169375355906)*x[0]**o+(0.270029734958)*x[0]+(-0.19196016538)*x[1]**o+(0.426264369437)*x[1]
        ref[0]=o*(-0.169375355906)*x_ref[0]**(o-1)+(0.270029734958)
        ref[1]=o*(-0.19196016538)*x_ref[1]**(o-1)+(0.426264369437)
      else:
        arg=(0.00913595455019)*x[0]**o+(-0.561918629059)*x[0]+(0.0164102679759)*x[1]**o+(0.20749162111)*x[1]+(0.588703418401)*x[2]**o+(0.841289333498)*x[2]
        ref[0]=o*(0.00913595455019)*x_ref[0]**(o-1)+(-0.561918629059)
        ref[1]=o*(0.0164102679759)*x_ref[1]**(o-1)+(0.20749162111)
        ref[2]=o*(0.588703418401)*x_ref[2]**(o-1)+(0.841289333498)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),()+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnContactOne_fromData_ContinuousFunction_rank1(self):
      """
      tests gradient for rank 1 Data on the FunctionOnContactOne

      assumptions: ContinuousFunction(self.domain) exists
                   self.domain supports gradient on FunctionOnContactOne
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=FunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=ContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(2,),w)
      ref=Data(0,(2,)+(dim,),w_ref)
      if dim==2:
        arg[0]=(-0.290031175706)*x[0]**o+(0.690121137589)*x[0]+(0.916232953272)*x[1]**o+(0.427227803135)*x[1]
        arg[1]=(0.0325792679154)*x[0]**o+(0.773157737135)*x[0]+(-0.0443953478357)*x[1]**o+(0.772028975294)*x[1]
        ref[0,0]=o*(-0.290031175706)*x_ref[0]**(o-1)+(0.690121137589)
        ref[0,1]=o*(0.916232953272)*x_ref[1]**(o-1)+(0.427227803135)
        ref[1,0]=o*(0.0325792679154)*x_ref[0]**(o-1)+(0.773157737135)
        ref[1,1]=o*(-0.0443953478357)*x_ref[1]**(o-1)+(0.772028975294)
      else:
        arg[0]=(-0.119338345858)*x[0]**o+(-0.866134437839)*x[0]+(-0.727685742079)*x[1]**o+(0.465666609669)*x[1]+(-0.351266733199)*x[2]**o+(-0.960631632698)*x[2]
        arg[1]=(-0.731037524737)*x[0]**o+(0.415975622707)*x[0]+(-0.86639696362)*x[1]**o+(0.914277406921)*x[1]+(0.627502485514)*x[2]**o+(-0.855013681276)*x[2]
        ref[0,0]=o*(-0.119338345858)*x_ref[0]**(o-1)+(-0.866134437839)
        ref[0,1]=o*(-0.727685742079)*x_ref[1]**(o-1)+(0.465666609669)
        ref[0,2]=o*(-0.351266733199)*x_ref[2]**(o-1)+(-0.960631632698)
        ref[1,0]=o*(-0.731037524737)*x_ref[0]**(o-1)+(0.415975622707)
        ref[1,1]=o*(-0.86639696362)*x_ref[1]**(o-1)+(0.914277406921)
        ref[1,2]=o*(0.627502485514)*x_ref[2]**(o-1)+(-0.855013681276)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnContactOne_fromData_ContinuousFunction_rank2(self):
      """
      tests gradient for rank 2 Data on the FunctionOnContactOne

      assumptions: ContinuousFunction(self.domain) exists
                   self.domain supports gradient on FunctionOnContactOne
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=FunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=ContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(4, 5),w)
      ref=Data(0,(4, 5)+(dim,),w_ref)
      if dim==2:
        arg[0,0]=(0.148320408183)*x[0]**o+(-0.340902870434)*x[0]+(-0.0856445410272)*x[1]**o+(0.220499304831)*x[1]
        arg[0,1]=(0.915892845602)*x[0]**o+(-0.04770770327)*x[0]+(0.482403170451)*x[1]**o+(-0.639478756575)*x[1]
        arg[0,2]=(-0.109204159071)*x[0]**o+(0.641607024805)*x[0]+(-0.409310547283)*x[1]**o+(0.202984386731)*x[1]
        arg[0,3]=(0.436833770493)*x[0]**o+(-0.200611791892)*x[0]+(-0.74814554517)*x[1]**o+(0.571881526754)*x[1]
        arg[0,4]=(0.704812299415)*x[0]**o+(0.688151134045)*x[0]+(0.486135712907)*x[1]**o+(0.955314240096)*x[1]
        arg[1,0]=(-0.731790373321)*x[0]**o+(-0.711258122556)*x[0]+(-0.961514666684)*x[1]**o+(0.726573978492)*x[1]
        arg[1,1]=(0.975372389889)*x[0]**o+(0.5026238435)*x[0]+(0.948955767945)*x[1]**o+(-0.780842035663)*x[1]
        arg[1,2]=(0.742383399984)*x[0]**o+(-0.729678661652)*x[0]+(-0.815499612514)*x[1]**o+(-0.12280674993)*x[1]
        arg[1,3]=(0.323809901662)*x[0]**o+(-0.441906205977)*x[0]+(-0.308989501913)*x[1]**o+(-0.549353671447)*x[1]
        arg[1,4]=(0.711285710752)*x[0]**o+(0.297823778866)*x[0]+(0.645185023747)*x[1]**o+(0.825620074525)*x[1]
        arg[2,0]=(-0.373175217644)*x[0]**o+(-0.25651286112)*x[0]+(-0.46193047583)*x[1]**o+(-0.359820938943)*x[1]
        arg[2,1]=(-0.406101756283)*x[0]**o+(-0.38896428223)*x[0]+(-0.993257693721)*x[1]**o+(-0.910326366305)*x[1]
        arg[2,2]=(0.517566718504)*x[0]**o+(-0.582940900248)*x[0]+(-0.381600156082)*x[1]**o+(0.466575604699)*x[1]
        arg[2,3]=(0.323944380062)*x[0]**o+(-0.99359065412)*x[0]+(0.069389014076)*x[1]**o+(0.960192708612)*x[1]
        arg[2,4]=(-0.741362989132)*x[0]**o+(0.978137520347)*x[0]+(-0.398259900603)*x[1]**o+(-0.224949732925)*x[1]
        arg[3,0]=(-0.540235240193)*x[0]**o+(0.761488584116)*x[0]+(-0.100229643779)*x[1]**o+(-0.168724555964)*x[1]
        arg[3,1]=(0.565068220879)*x[0]**o+(-0.778936552173)*x[0]+(-0.933478028833)*x[1]**o+(-0.274446893155)*x[1]
        arg[3,2]=(-0.198878845493)*x[0]**o+(0.97185846381)*x[0]+(0.0345948289236)*x[1]**o+(0.359375885935)*x[1]
        arg[3,3]=(-0.815426880937)*x[0]**o+(-0.0734806259357)*x[0]+(-0.0452925239934)*x[1]**o+(0.976167480949)*x[1]
        arg[3,4]=(0.374670688698)*x[0]**o+(-0.427666745858)*x[0]+(-0.631640994091)*x[1]**o+(-0.312455066404)*x[1]
        ref[0,0,0]=o*(0.148320408183)*x_ref[0]**(o-1)+(-0.340902870434)
        ref[0,0,1]=o*(-0.0856445410272)*x_ref[1]**(o-1)+(0.220499304831)
        ref[0,1,0]=o*(0.915892845602)*x_ref[0]**(o-1)+(-0.04770770327)
        ref[0,1,1]=o*(0.482403170451)*x_ref[1]**(o-1)+(-0.639478756575)
        ref[0,2,0]=o*(-0.109204159071)*x_ref[0]**(o-1)+(0.641607024805)
        ref[0,2,1]=o*(-0.409310547283)*x_ref[1]**(o-1)+(0.202984386731)
        ref[0,3,0]=o*(0.436833770493)*x_ref[0]**(o-1)+(-0.200611791892)
        ref[0,3,1]=o*(-0.74814554517)*x_ref[1]**(o-1)+(0.571881526754)
        ref[0,4,0]=o*(0.704812299415)*x_ref[0]**(o-1)+(0.688151134045)
        ref[0,4,1]=o*(0.486135712907)*x_ref[1]**(o-1)+(0.955314240096)
        ref[1,0,0]=o*(-0.731790373321)*x_ref[0]**(o-1)+(-0.711258122556)
        ref[1,0,1]=o*(-0.961514666684)*x_ref[1]**(o-1)+(0.726573978492)
        ref[1,1,0]=o*(0.975372389889)*x_ref[0]**(o-1)+(0.5026238435)
        ref[1,1,1]=o*(0.948955767945)*x_ref[1]**(o-1)+(-0.780842035663)
        ref[1,2,0]=o*(0.742383399984)*x_ref[0]**(o-1)+(-0.729678661652)
        ref[1,2,1]=o*(-0.815499612514)*x_ref[1]**(o-1)+(-0.12280674993)
        ref[1,3,0]=o*(0.323809901662)*x_ref[0]**(o-1)+(-0.441906205977)
        ref[1,3,1]=o*(-0.308989501913)*x_ref[1]**(o-1)+(-0.549353671447)
        ref[1,4,0]=o*(0.711285710752)*x_ref[0]**(o-1)+(0.297823778866)
        ref[1,4,1]=o*(0.645185023747)*x_ref[1]**(o-1)+(0.825620074525)
        ref[2,0,0]=o*(-0.373175217644)*x_ref[0]**(o-1)+(-0.25651286112)
        ref[2,0,1]=o*(-0.46193047583)*x_ref[1]**(o-1)+(-0.359820938943)
        ref[2,1,0]=o*(-0.406101756283)*x_ref[0]**(o-1)+(-0.38896428223)
        ref[2,1,1]=o*(-0.993257693721)*x_ref[1]**(o-1)+(-0.910326366305)
        ref[2,2,0]=o*(0.517566718504)*x_ref[0]**(o-1)+(-0.582940900248)
        ref[2,2,1]=o*(-0.381600156082)*x_ref[1]**(o-1)+(0.466575604699)
        ref[2,3,0]=o*(0.323944380062)*x_ref[0]**(o-1)+(-0.99359065412)
        ref[2,3,1]=o*(0.069389014076)*x_ref[1]**(o-1)+(0.960192708612)
        ref[2,4,0]=o*(-0.741362989132)*x_ref[0]**(o-1)+(0.978137520347)
        ref[2,4,1]=o*(-0.398259900603)*x_ref[1]**(o-1)+(-0.224949732925)
        ref[3,0,0]=o*(-0.540235240193)*x_ref[0]**(o-1)+(0.761488584116)
        ref[3,0,1]=o*(-0.100229643779)*x_ref[1]**(o-1)+(-0.168724555964)
        ref[3,1,0]=o*(0.565068220879)*x_ref[0]**(o-1)+(-0.778936552173)
        ref[3,1,1]=o*(-0.933478028833)*x_ref[1]**(o-1)+(-0.274446893155)
        ref[3,2,0]=o*(-0.198878845493)*x_ref[0]**(o-1)+(0.97185846381)
        ref[3,2,1]=o*(0.0345948289236)*x_ref[1]**(o-1)+(0.359375885935)
        ref[3,3,0]=o*(-0.815426880937)*x_ref[0]**(o-1)+(-0.0734806259357)
        ref[3,3,1]=o*(-0.0452925239934)*x_ref[1]**(o-1)+(0.976167480949)
        ref[3,4,0]=o*(0.374670688698)*x_ref[0]**(o-1)+(-0.427666745858)
        ref[3,4,1]=o*(-0.631640994091)*x_ref[1]**(o-1)+(-0.312455066404)
      else:
        arg[0,0]=(0.284398400678)*x[0]**o+(0.219396164435)*x[0]+(0.220563761332)*x[1]**o+(0.167554964517)*x[1]+(0.234139558431)*x[2]**o+(-0.462262273341)*x[2]
        arg[0,1]=(0.161107248226)*x[0]**o+(0.23981806792)*x[0]+(-0.365265066245)*x[1]**o+(0.280522162689)*x[1]+(0.0813974911438)*x[2]**o+(-0.43305486384)*x[2]
        arg[0,2]=(0.813480874845)*x[0]**o+(0.600760069636)*x[0]+(-0.133815038485)*x[1]**o+(-0.954192097752)*x[1]+(-0.60756978514)*x[2]**o+(0.669710363926)*x[2]
        arg[0,3]=(-0.760542897936)*x[0]**o+(0.869702837484)*x[0]+(0.568626088907)*x[1]**o+(0.272054244422)*x[1]+(-0.0415999983147)*x[2]**o+(0.446199878551)*x[2]
        arg[0,4]=(0.0453200557409)*x[0]**o+(0.990444244175)*x[0]+(0.134265180195)*x[1]**o+(0.156166931353)*x[1]+(-0.787964274948)*x[2]**o+(0.0116920503615)*x[2]
        arg[1,0]=(-0.826245054647)*x[0]**o+(0.203727421041)*x[0]+(0.435254937068)*x[1]**o+(-0.271957510058)*x[1]+(0.24056400787)*x[2]**o+(-0.270322614397)*x[2]
        arg[1,1]=(-0.423339337474)*x[0]**o+(0.272439137387)*x[0]+(-0.0736213619539)*x[1]**o+(-0.776123259153)*x[1]+(-0.751736227059)*x[2]**o+(0.944253810697)*x[2]
        arg[1,2]=(0.189348519506)*x[0]**o+(-0.599085006375)*x[0]+(0.511802349511)*x[1]**o+(-0.309756999526)*x[1]+(-0.753093308971)*x[2]**o+(-0.109878524762)*x[2]
        arg[1,3]=(0.273889782311)*x[0]**o+(0.284416273071)*x[0]+(-0.793016836976)*x[1]**o+(0.584657111427)*x[1]+(0.202246448215)*x[2]**o+(0.669336280646)*x[2]
        arg[1,4]=(-0.310062687494)*x[0]**o+(-0.0558492819571)*x[0]+(0.661043054703)*x[1]**o+(0.708531199864)*x[1]+(0.0490202348501)*x[2]**o+(0.732983691308)*x[2]
        arg[2,0]=(0.967228638923)*x[0]**o+(-0.816725187456)*x[0]+(0.836005904943)*x[1]**o+(-0.618363868727)*x[1]+(-0.977101150283)*x[2]**o+(-0.960030792428)*x[2]
        arg[2,1]=(0.536503091036)*x[0]**o+(-0.786194077149)*x[0]+(-0.337609174718)*x[1]**o+(0.787326702105)*x[1]+(0.989900210061)*x[2]**o+(0.67077581859)*x[2]
        arg[2,2]=(-0.732242113661)*x[0]**o+(-0.565641876648)*x[0]+(0.175986347852)*x[1]**o+(0.862449074966)*x[1]+(0.0257656069443)*x[2]**o+(0.824927753427)*x[2]
        arg[2,3]=(-0.863272499797)*x[0]**o+(-0.817781186551)*x[0]+(0.168931269996)*x[1]**o+(-0.530060186715)*x[1]+(-0.516801368376)*x[2]**o+(-0.570137941882)*x[2]
        arg[2,4]=(-0.675287850319)*x[0]**o+(-0.672701614891)*x[0]+(-0.19851266374)*x[1]**o+(-0.0494587000627)*x[1]+(0.518006592112)*x[2]**o+(0.0337938303974)*x[2]
        arg[3,0]=(-0.175683006965)*x[0]**o+(-0.843980579113)*x[0]+(0.903358518604)*x[1]**o+(0.962156465407)*x[1]+(-0.0887392353523)*x[2]**o+(0.524587238729)*x[2]
        arg[3,1]=(0.0622433182846)*x[0]**o+(-0.756701969275)*x[0]+(0.721836266349)*x[1]**o+(0.457673032865)*x[1]+(0.704951904865)*x[2]**o+(0.781015828813)*x[2]
        arg[3,2]=(-0.457057269128)*x[0]**o+(-0.880403805028)*x[0]+(0.103553852578)*x[1]**o+(-0.807061998574)*x[1]+(-0.0352722677587)*x[2]**o+(0.0527948564177)*x[2]
        arg[3,3]=(0.161459807817)*x[0]**o+(0.698509459014)*x[0]+(-0.596487730094)*x[1]**o+(-0.906646770174)*x[1]+(0.567036380682)*x[2]**o+(0.490123167386)*x[2]
        arg[3,4]=(-0.668686195082)*x[0]**o+(0.911485638627)*x[0]+(-0.856948411336)*x[1]**o+(0.0348927535379)*x[1]+(0.17649505057)*x[2]**o+(-0.778920185271)*x[2]
        ref[0,0,0]=o*(0.284398400678)*x_ref[0]**(o-1)+(0.219396164435)
        ref[0,0,1]=o*(0.220563761332)*x_ref[1]**(o-1)+(0.167554964517)
        ref[0,0,2]=o*(0.234139558431)*x_ref[2]**(o-1)+(-0.462262273341)
        ref[0,1,0]=o*(0.161107248226)*x_ref[0]**(o-1)+(0.23981806792)
        ref[0,1,1]=o*(-0.365265066245)*x_ref[1]**(o-1)+(0.280522162689)
        ref[0,1,2]=o*(0.0813974911438)*x_ref[2]**(o-1)+(-0.43305486384)
        ref[0,2,0]=o*(0.813480874845)*x_ref[0]**(o-1)+(0.600760069636)
        ref[0,2,1]=o*(-0.133815038485)*x_ref[1]**(o-1)+(-0.954192097752)
        ref[0,2,2]=o*(-0.60756978514)*x_ref[2]**(o-1)+(0.669710363926)
        ref[0,3,0]=o*(-0.760542897936)*x_ref[0]**(o-1)+(0.869702837484)
        ref[0,3,1]=o*(0.568626088907)*x_ref[1]**(o-1)+(0.272054244422)
        ref[0,3,2]=o*(-0.0415999983147)*x_ref[2]**(o-1)+(0.446199878551)
        ref[0,4,0]=o*(0.0453200557409)*x_ref[0]**(o-1)+(0.990444244175)
        ref[0,4,1]=o*(0.134265180195)*x_ref[1]**(o-1)+(0.156166931353)
        ref[0,4,2]=o*(-0.787964274948)*x_ref[2]**(o-1)+(0.0116920503615)
        ref[1,0,0]=o*(-0.826245054647)*x_ref[0]**(o-1)+(0.203727421041)
        ref[1,0,1]=o*(0.435254937068)*x_ref[1]**(o-1)+(-0.271957510058)
        ref[1,0,2]=o*(0.24056400787)*x_ref[2]**(o-1)+(-0.270322614397)
        ref[1,1,0]=o*(-0.423339337474)*x_ref[0]**(o-1)+(0.272439137387)
        ref[1,1,1]=o*(-0.0736213619539)*x_ref[1]**(o-1)+(-0.776123259153)
        ref[1,1,2]=o*(-0.751736227059)*x_ref[2]**(o-1)+(0.944253810697)
        ref[1,2,0]=o*(0.189348519506)*x_ref[0]**(o-1)+(-0.599085006375)
        ref[1,2,1]=o*(0.511802349511)*x_ref[1]**(o-1)+(-0.309756999526)
        ref[1,2,2]=o*(-0.753093308971)*x_ref[2]**(o-1)+(-0.109878524762)
        ref[1,3,0]=o*(0.273889782311)*x_ref[0]**(o-1)+(0.284416273071)
        ref[1,3,1]=o*(-0.793016836976)*x_ref[1]**(o-1)+(0.584657111427)
        ref[1,3,2]=o*(0.202246448215)*x_ref[2]**(o-1)+(0.669336280646)
        ref[1,4,0]=o*(-0.310062687494)*x_ref[0]**(o-1)+(-0.0558492819571)
        ref[1,4,1]=o*(0.661043054703)*x_ref[1]**(o-1)+(0.708531199864)
        ref[1,4,2]=o*(0.0490202348501)*x_ref[2]**(o-1)+(0.732983691308)
        ref[2,0,0]=o*(0.967228638923)*x_ref[0]**(o-1)+(-0.816725187456)
        ref[2,0,1]=o*(0.836005904943)*x_ref[1]**(o-1)+(-0.618363868727)
        ref[2,0,2]=o*(-0.977101150283)*x_ref[2]**(o-1)+(-0.960030792428)
        ref[2,1,0]=o*(0.536503091036)*x_ref[0]**(o-1)+(-0.786194077149)
        ref[2,1,1]=o*(-0.337609174718)*x_ref[1]**(o-1)+(0.787326702105)
        ref[2,1,2]=o*(0.989900210061)*x_ref[2]**(o-1)+(0.67077581859)
        ref[2,2,0]=o*(-0.732242113661)*x_ref[0]**(o-1)+(-0.565641876648)
        ref[2,2,1]=o*(0.175986347852)*x_ref[1]**(o-1)+(0.862449074966)
        ref[2,2,2]=o*(0.0257656069443)*x_ref[2]**(o-1)+(0.824927753427)
        ref[2,3,0]=o*(-0.863272499797)*x_ref[0]**(o-1)+(-0.817781186551)
        ref[2,3,1]=o*(0.168931269996)*x_ref[1]**(o-1)+(-0.530060186715)
        ref[2,3,2]=o*(-0.516801368376)*x_ref[2]**(o-1)+(-0.570137941882)
        ref[2,4,0]=o*(-0.675287850319)*x_ref[0]**(o-1)+(-0.672701614891)
        ref[2,4,1]=o*(-0.19851266374)*x_ref[1]**(o-1)+(-0.0494587000627)
        ref[2,4,2]=o*(0.518006592112)*x_ref[2]**(o-1)+(0.0337938303974)
        ref[3,0,0]=o*(-0.175683006965)*x_ref[0]**(o-1)+(-0.843980579113)
        ref[3,0,1]=o*(0.903358518604)*x_ref[1]**(o-1)+(0.962156465407)
        ref[3,0,2]=o*(-0.0887392353523)*x_ref[2]**(o-1)+(0.524587238729)
        ref[3,1,0]=o*(0.0622433182846)*x_ref[0]**(o-1)+(-0.756701969275)
        ref[3,1,1]=o*(0.721836266349)*x_ref[1]**(o-1)+(0.457673032865)
        ref[3,1,2]=o*(0.704951904865)*x_ref[2]**(o-1)+(0.781015828813)
        ref[3,2,0]=o*(-0.457057269128)*x_ref[0]**(o-1)+(-0.880403805028)
        ref[3,2,1]=o*(0.103553852578)*x_ref[1]**(o-1)+(-0.807061998574)
        ref[3,2,2]=o*(-0.0352722677587)*x_ref[2]**(o-1)+(0.0527948564177)
        ref[3,3,0]=o*(0.161459807817)*x_ref[0]**(o-1)+(0.698509459014)
        ref[3,3,1]=o*(-0.596487730094)*x_ref[1]**(o-1)+(-0.906646770174)
        ref[3,3,2]=o*(0.567036380682)*x_ref[2]**(o-1)+(0.490123167386)
        ref[3,4,0]=o*(-0.668686195082)*x_ref[0]**(o-1)+(0.911485638627)
        ref[3,4,1]=o*(-0.856948411336)*x_ref[1]**(o-1)+(0.0348927535379)
        ref[3,4,2]=o*(0.17649505057)*x_ref[2]**(o-1)+(-0.778920185271)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnContactOne_fromData_ContinuousFunction_rank3(self):
      """
      tests gradient for rank 3 Data on the FunctionOnContactOne

      assumptions: ContinuousFunction(self.domain) exists
                   self.domain supports gradient on FunctionOnContactOne
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=FunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=ContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(6, 2, 2),w)
      ref=Data(0,(6, 2, 2)+(dim,),w_ref)
      if dim==2:
        arg[0,0,0]=(0.366719126165)*x[0]**o+(0.273305723392)*x[0]+(0.508134048679)*x[1]**o+(-0.0895788966541)*x[1]
        arg[0,0,1]=(-0.911986850385)*x[0]**o+(-0.98503317507)*x[0]+(-0.310897248279)*x[1]**o+(0.015206007134)*x[1]
        arg[0,1,0]=(-0.0827324676842)*x[0]**o+(0.566620026269)*x[0]+(-0.0581063189367)*x[1]**o+(0.379530936223)*x[1]
        arg[0,1,1]=(0.223247684076)*x[0]**o+(0.511247996036)*x[0]+(-0.904638808138)*x[1]**o+(-0.253982863496)*x[1]
        arg[1,0,0]=(-0.117040630362)*x[0]**o+(0.720200175398)*x[0]+(0.316014562047)*x[1]**o+(-0.88437304478)*x[1]
        arg[1,0,1]=(0.521261471788)*x[0]**o+(0.866618380963)*x[0]+(0.376866254345)*x[1]**o+(0.0905522236713)*x[1]
        arg[1,1,0]=(-0.0907011175214)*x[0]**o+(0.925809501719)*x[0]+(0.29066676347)*x[1]**o+(-0.77392365917)*x[1]
        arg[1,1,1]=(0.410922874646)*x[0]**o+(-0.801953959211)*x[0]+(-0.911104174539)*x[1]**o+(-0.640661859542)*x[1]
        arg[2,0,0]=(-0.449471274267)*x[0]**o+(0.8111872512)*x[0]+(0.0498814189394)*x[1]**o+(0.683703882124)*x[1]
        arg[2,0,1]=(-0.192396495147)*x[0]**o+(0.893457442524)*x[0]+(-0.946936565887)*x[1]**o+(-0.0290255758634)*x[1]
        arg[2,1,0]=(0.90847535637)*x[0]**o+(-0.517929281823)*x[0]+(0.389994692606)*x[1]**o+(-0.601708219886)*x[1]
        arg[2,1,1]=(0.401910281699)*x[0]**o+(0.485033224067)*x[0]+(-0.362139392478)*x[1]**o+(-0.740542640224)*x[1]
        arg[3,0,0]=(0.195815356554)*x[0]**o+(-0.584270182199)*x[0]+(-0.773247762709)*x[1]**o+(0.974109226972)*x[1]
        arg[3,0,1]=(0.516821334505)*x[0]**o+(-0.667535261235)*x[0]+(-0.687554420634)*x[1]**o+(-0.826211449593)*x[1]
        arg[3,1,0]=(-0.886684033283)*x[0]**o+(0.833394822235)*x[0]+(-0.509561014765)*x[1]**o+(-0.934990250803)*x[1]
        arg[3,1,1]=(-0.279505984235)*x[0]**o+(0.629210321924)*x[0]+(-0.245033518843)*x[1]**o+(0.148437993524)*x[1]
        arg[4,0,0]=(-0.120914130766)*x[0]**o+(-0.70386339291)*x[0]+(-0.37739143589)*x[1]**o+(-0.604979315802)*x[1]
        arg[4,0,1]=(-0.259492475213)*x[0]**o+(0.628922768093)*x[0]+(-0.973387886178)*x[1]**o+(0.285217747252)*x[1]
        arg[4,1,0]=(-0.986163107858)*x[0]**o+(-0.85082996164)*x[0]+(-0.560402256475)*x[1]**o+(-0.468278543242)*x[1]
        arg[4,1,1]=(0.370258762453)*x[0]**o+(0.870396552858)*x[0]+(0.57205142923)*x[1]**o+(0.332787259857)*x[1]
        arg[5,0,0]=(-0.570453853889)*x[0]**o+(0.253977538115)*x[0]+(0.628545140288)*x[1]**o+(-0.766550576107)*x[1]
        arg[5,0,1]=(-0.626776709555)*x[0]**o+(0.593526092433)*x[0]+(0.824052315861)*x[1]**o+(-0.409883522469)*x[1]
        arg[5,1,0]=(0.285256467088)*x[0]**o+(-0.808675657802)*x[0]+(-0.818251043807)*x[1]**o+(0.378756627769)*x[1]
        arg[5,1,1]=(-0.810805592247)*x[0]**o+(-0.879886206051)*x[0]+(0.378171206533)*x[1]**o+(0.478469089448)*x[1]
        ref[0,0,0,0]=o*(0.366719126165)*x_ref[0]**(o-1)+(0.273305723392)
        ref[0,0,0,1]=o*(0.508134048679)*x_ref[1]**(o-1)+(-0.0895788966541)
        ref[0,0,1,0]=o*(-0.911986850385)*x_ref[0]**(o-1)+(-0.98503317507)
        ref[0,0,1,1]=o*(-0.310897248279)*x_ref[1]**(o-1)+(0.015206007134)
        ref[0,1,0,0]=o*(-0.0827324676842)*x_ref[0]**(o-1)+(0.566620026269)
        ref[0,1,0,1]=o*(-0.0581063189367)*x_ref[1]**(o-1)+(0.379530936223)
        ref[0,1,1,0]=o*(0.223247684076)*x_ref[0]**(o-1)+(0.511247996036)
        ref[0,1,1,1]=o*(-0.904638808138)*x_ref[1]**(o-1)+(-0.253982863496)
        ref[1,0,0,0]=o*(-0.117040630362)*x_ref[0]**(o-1)+(0.720200175398)
        ref[1,0,0,1]=o*(0.316014562047)*x_ref[1]**(o-1)+(-0.88437304478)
        ref[1,0,1,0]=o*(0.521261471788)*x_ref[0]**(o-1)+(0.866618380963)
        ref[1,0,1,1]=o*(0.376866254345)*x_ref[1]**(o-1)+(0.0905522236713)
        ref[1,1,0,0]=o*(-0.0907011175214)*x_ref[0]**(o-1)+(0.925809501719)
        ref[1,1,0,1]=o*(0.29066676347)*x_ref[1]**(o-1)+(-0.77392365917)
        ref[1,1,1,0]=o*(0.410922874646)*x_ref[0]**(o-1)+(-0.801953959211)
        ref[1,1,1,1]=o*(-0.911104174539)*x_ref[1]**(o-1)+(-0.640661859542)
        ref[2,0,0,0]=o*(-0.449471274267)*x_ref[0]**(o-1)+(0.8111872512)
        ref[2,0,0,1]=o*(0.0498814189394)*x_ref[1]**(o-1)+(0.683703882124)
        ref[2,0,1,0]=o*(-0.192396495147)*x_ref[0]**(o-1)+(0.893457442524)
        ref[2,0,1,1]=o*(-0.946936565887)*x_ref[1]**(o-1)+(-0.0290255758634)
        ref[2,1,0,0]=o*(0.90847535637)*x_ref[0]**(o-1)+(-0.517929281823)
        ref[2,1,0,1]=o*(0.389994692606)*x_ref[1]**(o-1)+(-0.601708219886)
        ref[2,1,1,0]=o*(0.401910281699)*x_ref[0]**(o-1)+(0.485033224067)
        ref[2,1,1,1]=o*(-0.362139392478)*x_ref[1]**(o-1)+(-0.740542640224)
        ref[3,0,0,0]=o*(0.195815356554)*x_ref[0]**(o-1)+(-0.584270182199)
        ref[3,0,0,1]=o*(-0.773247762709)*x_ref[1]**(o-1)+(0.974109226972)
        ref[3,0,1,0]=o*(0.516821334505)*x_ref[0]**(o-1)+(-0.667535261235)
        ref[3,0,1,1]=o*(-0.687554420634)*x_ref[1]**(o-1)+(-0.826211449593)
        ref[3,1,0,0]=o*(-0.886684033283)*x_ref[0]**(o-1)+(0.833394822235)
        ref[3,1,0,1]=o*(-0.509561014765)*x_ref[1]**(o-1)+(-0.934990250803)
        ref[3,1,1,0]=o*(-0.279505984235)*x_ref[0]**(o-1)+(0.629210321924)
        ref[3,1,1,1]=o*(-0.245033518843)*x_ref[1]**(o-1)+(0.148437993524)
        ref[4,0,0,0]=o*(-0.120914130766)*x_ref[0]**(o-1)+(-0.70386339291)
        ref[4,0,0,1]=o*(-0.37739143589)*x_ref[1]**(o-1)+(-0.604979315802)
        ref[4,0,1,0]=o*(-0.259492475213)*x_ref[0]**(o-1)+(0.628922768093)
        ref[4,0,1,1]=o*(-0.973387886178)*x_ref[1]**(o-1)+(0.285217747252)
        ref[4,1,0,0]=o*(-0.986163107858)*x_ref[0]**(o-1)+(-0.85082996164)
        ref[4,1,0,1]=o*(-0.560402256475)*x_ref[1]**(o-1)+(-0.468278543242)
        ref[4,1,1,0]=o*(0.370258762453)*x_ref[0]**(o-1)+(0.870396552858)
        ref[4,1,1,1]=o*(0.57205142923)*x_ref[1]**(o-1)+(0.332787259857)
        ref[5,0,0,0]=o*(-0.570453853889)*x_ref[0]**(o-1)+(0.253977538115)
        ref[5,0,0,1]=o*(0.628545140288)*x_ref[1]**(o-1)+(-0.766550576107)
        ref[5,0,1,0]=o*(-0.626776709555)*x_ref[0]**(o-1)+(0.593526092433)
        ref[5,0,1,1]=o*(0.824052315861)*x_ref[1]**(o-1)+(-0.409883522469)
        ref[5,1,0,0]=o*(0.285256467088)*x_ref[0]**(o-1)+(-0.808675657802)
        ref[5,1,0,1]=o*(-0.818251043807)*x_ref[1]**(o-1)+(0.378756627769)
        ref[5,1,1,0]=o*(-0.810805592247)*x_ref[0]**(o-1)+(-0.879886206051)
        ref[5,1,1,1]=o*(0.378171206533)*x_ref[1]**(o-1)+(0.478469089448)
      else:
        arg[0,0,0]=(0.99032561737)*x[0]**o+(0.0664709329455)*x[0]+(0.118470702946)*x[1]**o+(0.339805181064)*x[1]+(-0.288819936068)*x[2]**o+(0.500626113335)*x[2]
        arg[0,0,1]=(-0.736833023385)*x[0]**o+(-0.160433791202)*x[0]+(-0.159295012314)*x[1]**o+(-0.0515197665154)*x[1]+(-0.199553046759)*x[2]**o+(0.912767397035)*x[2]
        arg[0,1,0]=(0.263643352646)*x[0]**o+(-0.408521561602)*x[0]+(-0.690441644678)*x[1]**o+(0.514925086967)*x[1]+(-0.321785011214)*x[2]**o+(-0.192767636106)*x[2]
        arg[0,1,1]=(-0.00679573309711)*x[0]**o+(-0.0919830030966)*x[0]+(0.0194635540782)*x[1]**o+(0.0364274479874)*x[1]+(0.324767149157)*x[2]**o+(-0.930770951272)*x[2]
        arg[1,0,0]=(0.129524159454)*x[0]**o+(-0.747948168258)*x[0]+(0.748091879992)*x[1]**o+(0.0701365933978)*x[1]+(-0.227595193537)*x[2]**o+(-0.515988222581)*x[2]
        arg[1,0,1]=(-0.369843455974)*x[0]**o+(0.902965907161)*x[0]+(0.841050267135)*x[1]**o+(0.985297243316)*x[1]+(-0.96057678523)*x[2]**o+(0.149329555515)*x[2]
        arg[1,1,0]=(-0.530918169849)*x[0]**o+(0.574734874263)*x[0]+(-0.56424658789)*x[1]**o+(-0.756154171146)*x[1]+(-0.181750429769)*x[2]**o+(-0.270972276027)*x[2]
        arg[1,1,1]=(0.18184543511)*x[0]**o+(0.810253164883)*x[0]+(-0.0289547932926)*x[1]**o+(0.690366471619)*x[1]+(0.862616271239)*x[2]**o+(0.157705360996)*x[2]
        arg[2,0,0]=(-0.732811475459)*x[0]**o+(-0.720788617286)*x[0]+(-0.72285785154)*x[1]**o+(-0.764360626538)*x[1]+(0.979115834974)*x[2]**o+(0.430570190112)*x[2]
        arg[2,0,1]=(-0.602364948602)*x[0]**o+(-0.313871272033)*x[0]+(0.931476652796)*x[1]**o+(-0.553237167378)*x[1]+(0.273773142735)*x[2]**o+(0.732796238419)*x[2]
        arg[2,1,0]=(0.723724167325)*x[0]**o+(-0.411330362765)*x[0]+(0.415411259564)*x[1]**o+(0.596006586583)*x[1]+(0.588177039382)*x[2]**o+(-0.365406082278)*x[2]
        arg[2,1,1]=(0.0622006916856)*x[0]**o+(0.583807018004)*x[0]+(0.292401319183)*x[1]**o+(-0.202393075873)*x[1]+(-0.544886623341)*x[2]**o+(-0.269087712755)*x[2]
        arg[3,0,0]=(-0.543339583883)*x[0]**o+(-0.594218090249)*x[0]+(0.463226896714)*x[1]**o+(0.613466907584)*x[1]+(0.147935164587)*x[2]**o+(0.696530808607)*x[2]
        arg[3,0,1]=(0.338109512519)*x[0]**o+(0.281428380284)*x[0]+(0.0445095482602)*x[1]**o+(0.898143737155)*x[1]+(0.0465131079784)*x[2]**o+(-0.311801195497)*x[2]
        arg[3,1,0]=(0.489699597199)*x[0]**o+(0.198461296558)*x[0]+(0.87785894323)*x[1]**o+(0.916226820395)*x[1]+(-0.473685913201)*x[2]**o+(-0.496145627682)*x[2]
        arg[3,1,1]=(0.249814020596)*x[0]**o+(-0.894315482252)*x[0]+(-0.778776373134)*x[1]**o+(0.760727700644)*x[1]+(0.743775735588)*x[2]**o+(-0.689040985439)*x[2]
        arg[4,0,0]=(-0.825052728563)*x[0]**o+(0.522046869865)*x[0]+(0.333964173928)*x[1]**o+(-0.76926539114)*x[1]+(0.412352181661)*x[2]**o+(-0.0067772174596)*x[2]
        arg[4,0,1]=(-0.478610156432)*x[0]**o+(0.750576911314)*x[0]+(-0.531813749953)*x[1]**o+(0.355951176778)*x[1]+(-0.852853671607)*x[2]**o+(0.980221079923)*x[2]
        arg[4,1,0]=(-0.641389506244)*x[0]**o+(0.881787042426)*x[0]+(-0.304080099649)*x[1]**o+(0.38448900132)*x[1]+(-0.047930997317)*x[2]**o+(-0.276038511441)*x[2]
        arg[4,1,1]=(0.606877338216)*x[0]**o+(0.693205674961)*x[0]+(-0.731785947563)*x[1]**o+(0.980888111857)*x[1]+(0.355758103413)*x[2]**o+(-0.493780352941)*x[2]
        arg[5,0,0]=(-0.542680086594)*x[0]**o+(-0.335712421489)*x[0]+(0.196257902892)*x[1]**o+(-0.923381865562)*x[1]+(0.396049043788)*x[2]**o+(0.231195219983)*x[2]
        arg[5,0,1]=(0.224328300764)*x[0]**o+(0.306254705923)*x[0]+(-0.298262471524)*x[1]**o+(0.318537412793)*x[1]+(-0.0971742408716)*x[2]**o+(-0.374440507273)*x[2]
        arg[5,1,0]=(-0.408985188836)*x[0]**o+(-0.932478279672)*x[0]+(0.700313488604)*x[1]**o+(0.259720889362)*x[1]+(0.862207003532)*x[2]**o+(0.646109275237)*x[2]
        arg[5,1,1]=(-0.0341740340851)*x[0]**o+(0.742119475866)*x[0]+(0.310640405448)*x[1]**o+(-0.295841203899)*x[1]+(-0.778064951853)*x[2]**o+(-0.847637829972)*x[2]
        ref[0,0,0,0]=o*(0.99032561737)*x_ref[0]**(o-1)+(0.0664709329455)
        ref[0,0,0,1]=o*(0.118470702946)*x_ref[1]**(o-1)+(0.339805181064)
        ref[0,0,0,2]=o*(-0.288819936068)*x_ref[2]**(o-1)+(0.500626113335)
        ref[0,0,1,0]=o*(-0.736833023385)*x_ref[0]**(o-1)+(-0.160433791202)
        ref[0,0,1,1]=o*(-0.159295012314)*x_ref[1]**(o-1)+(-0.0515197665154)
        ref[0,0,1,2]=o*(-0.199553046759)*x_ref[2]**(o-1)+(0.912767397035)
        ref[0,1,0,0]=o*(0.263643352646)*x_ref[0]**(o-1)+(-0.408521561602)
        ref[0,1,0,1]=o*(-0.690441644678)*x_ref[1]**(o-1)+(0.514925086967)
        ref[0,1,0,2]=o*(-0.321785011214)*x_ref[2]**(o-1)+(-0.192767636106)
        ref[0,1,1,0]=o*(-0.00679573309711)*x_ref[0]**(o-1)+(-0.0919830030966)
        ref[0,1,1,1]=o*(0.0194635540782)*x_ref[1]**(o-1)+(0.0364274479874)
        ref[0,1,1,2]=o*(0.324767149157)*x_ref[2]**(o-1)+(-0.930770951272)
        ref[1,0,0,0]=o*(0.129524159454)*x_ref[0]**(o-1)+(-0.747948168258)
        ref[1,0,0,1]=o*(0.748091879992)*x_ref[1]**(o-1)+(0.0701365933978)
        ref[1,0,0,2]=o*(-0.227595193537)*x_ref[2]**(o-1)+(-0.515988222581)
        ref[1,0,1,0]=o*(-0.369843455974)*x_ref[0]**(o-1)+(0.902965907161)
        ref[1,0,1,1]=o*(0.841050267135)*x_ref[1]**(o-1)+(0.985297243316)
        ref[1,0,1,2]=o*(-0.96057678523)*x_ref[2]**(o-1)+(0.149329555515)
        ref[1,1,0,0]=o*(-0.530918169849)*x_ref[0]**(o-1)+(0.574734874263)
        ref[1,1,0,1]=o*(-0.56424658789)*x_ref[1]**(o-1)+(-0.756154171146)
        ref[1,1,0,2]=o*(-0.181750429769)*x_ref[2]**(o-1)+(-0.270972276027)
        ref[1,1,1,0]=o*(0.18184543511)*x_ref[0]**(o-1)+(0.810253164883)
        ref[1,1,1,1]=o*(-0.0289547932926)*x_ref[1]**(o-1)+(0.690366471619)
        ref[1,1,1,2]=o*(0.862616271239)*x_ref[2]**(o-1)+(0.157705360996)
        ref[2,0,0,0]=o*(-0.732811475459)*x_ref[0]**(o-1)+(-0.720788617286)
        ref[2,0,0,1]=o*(-0.72285785154)*x_ref[1]**(o-1)+(-0.764360626538)
        ref[2,0,0,2]=o*(0.979115834974)*x_ref[2]**(o-1)+(0.430570190112)
        ref[2,0,1,0]=o*(-0.602364948602)*x_ref[0]**(o-1)+(-0.313871272033)
        ref[2,0,1,1]=o*(0.931476652796)*x_ref[1]**(o-1)+(-0.553237167378)
        ref[2,0,1,2]=o*(0.273773142735)*x_ref[2]**(o-1)+(0.732796238419)
        ref[2,1,0,0]=o*(0.723724167325)*x_ref[0]**(o-1)+(-0.411330362765)
        ref[2,1,0,1]=o*(0.415411259564)*x_ref[1]**(o-1)+(0.596006586583)
        ref[2,1,0,2]=o*(0.588177039382)*x_ref[2]**(o-1)+(-0.365406082278)
        ref[2,1,1,0]=o*(0.0622006916856)*x_ref[0]**(o-1)+(0.583807018004)
        ref[2,1,1,1]=o*(0.292401319183)*x_ref[1]**(o-1)+(-0.202393075873)
        ref[2,1,1,2]=o*(-0.544886623341)*x_ref[2]**(o-1)+(-0.269087712755)
        ref[3,0,0,0]=o*(-0.543339583883)*x_ref[0]**(o-1)+(-0.594218090249)
        ref[3,0,0,1]=o*(0.463226896714)*x_ref[1]**(o-1)+(0.613466907584)
        ref[3,0,0,2]=o*(0.147935164587)*x_ref[2]**(o-1)+(0.696530808607)
        ref[3,0,1,0]=o*(0.338109512519)*x_ref[0]**(o-1)+(0.281428380284)
        ref[3,0,1,1]=o*(0.0445095482602)*x_ref[1]**(o-1)+(0.898143737155)
        ref[3,0,1,2]=o*(0.0465131079784)*x_ref[2]**(o-1)+(-0.311801195497)
        ref[3,1,0,0]=o*(0.489699597199)*x_ref[0]**(o-1)+(0.198461296558)
        ref[3,1,0,1]=o*(0.87785894323)*x_ref[1]**(o-1)+(0.916226820395)
        ref[3,1,0,2]=o*(-0.473685913201)*x_ref[2]**(o-1)+(-0.496145627682)
        ref[3,1,1,0]=o*(0.249814020596)*x_ref[0]**(o-1)+(-0.894315482252)
        ref[3,1,1,1]=o*(-0.778776373134)*x_ref[1]**(o-1)+(0.760727700644)
        ref[3,1,1,2]=o*(0.743775735588)*x_ref[2]**(o-1)+(-0.689040985439)
        ref[4,0,0,0]=o*(-0.825052728563)*x_ref[0]**(o-1)+(0.522046869865)
        ref[4,0,0,1]=o*(0.333964173928)*x_ref[1]**(o-1)+(-0.76926539114)
        ref[4,0,0,2]=o*(0.412352181661)*x_ref[2]**(o-1)+(-0.0067772174596)
        ref[4,0,1,0]=o*(-0.478610156432)*x_ref[0]**(o-1)+(0.750576911314)
        ref[4,0,1,1]=o*(-0.531813749953)*x_ref[1]**(o-1)+(0.355951176778)
        ref[4,0,1,2]=o*(-0.852853671607)*x_ref[2]**(o-1)+(0.980221079923)
        ref[4,1,0,0]=o*(-0.641389506244)*x_ref[0]**(o-1)+(0.881787042426)
        ref[4,1,0,1]=o*(-0.304080099649)*x_ref[1]**(o-1)+(0.38448900132)
        ref[4,1,0,2]=o*(-0.047930997317)*x_ref[2]**(o-1)+(-0.276038511441)
        ref[4,1,1,0]=o*(0.606877338216)*x_ref[0]**(o-1)+(0.693205674961)
        ref[4,1,1,1]=o*(-0.731785947563)*x_ref[1]**(o-1)+(0.980888111857)
        ref[4,1,1,2]=o*(0.355758103413)*x_ref[2]**(o-1)+(-0.493780352941)
        ref[5,0,0,0]=o*(-0.542680086594)*x_ref[0]**(o-1)+(-0.335712421489)
        ref[5,0,0,1]=o*(0.196257902892)*x_ref[1]**(o-1)+(-0.923381865562)
        ref[5,0,0,2]=o*(0.396049043788)*x_ref[2]**(o-1)+(0.231195219983)
        ref[5,0,1,0]=o*(0.224328300764)*x_ref[0]**(o-1)+(0.306254705923)
        ref[5,0,1,1]=o*(-0.298262471524)*x_ref[1]**(o-1)+(0.318537412793)
        ref[5,0,1,2]=o*(-0.0971742408716)*x_ref[2]**(o-1)+(-0.374440507273)
        ref[5,1,0,0]=o*(-0.408985188836)*x_ref[0]**(o-1)+(-0.932478279672)
        ref[5,1,0,1]=o*(0.700313488604)*x_ref[1]**(o-1)+(0.259720889362)
        ref[5,1,0,2]=o*(0.862207003532)*x_ref[2]**(o-1)+(0.646109275237)
        ref[5,1,1,0]=o*(-0.0341740340851)*x_ref[0]**(o-1)+(0.742119475866)
        ref[5,1,1,1]=o*(0.310640405448)*x_ref[1]**(o-1)+(-0.295841203899)
        ref[5,1,1,2]=o*(-0.778064951853)*x_ref[2]**(o-1)+(-0.847637829972)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnContactOne_fromData_Solution_rank0(self):
      """
      tests gradient for rank 0 Data on the FunctionOnContactOne

      assumptions: Solution(self.domain) exists
                   self.domain supports gradient on FunctionOnContactOne
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=FunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=Solution(self.domain)
      x=w.getX()
      arg=Data(0,(),w)
      ref=Data(0,()+(dim,),w_ref)
      if dim==2:
        arg=(-0.188926722839)*x[0]**o+(0.0528015322778)*x[0]+(0.394368405707)*x[1]**o+(0.573648619197)*x[1]
        ref[0]=o*(-0.188926722839)*x_ref[0]**(o-1)+(0.0528015322778)
        ref[1]=o*(0.394368405707)*x_ref[1]**(o-1)+(0.573648619197)
      else:
        arg=(0.208843709667)*x[0]**o+(-0.461780133723)*x[0]+(0.15028897973)*x[1]**o+(-0.594920423887)*x[1]+(0.517629763426)*x[2]**o+(0.403396285863)*x[2]
        ref[0]=o*(0.208843709667)*x_ref[0]**(o-1)+(-0.461780133723)
        ref[1]=o*(0.15028897973)*x_ref[1]**(o-1)+(-0.594920423887)
        ref[2]=o*(0.517629763426)*x_ref[2]**(o-1)+(0.403396285863)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),()+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnContactOne_fromData_Solution_rank1(self):
      """
      tests gradient for rank 1 Data on the FunctionOnContactOne

      assumptions: Solution(self.domain) exists
                   self.domain supports gradient on FunctionOnContactOne
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=FunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=Solution(self.domain)
      x=w.getX()
      arg=Data(0,(2,),w)
      ref=Data(0,(2,)+(dim,),w_ref)
      if dim==2:
        arg[0]=(0.321445299816)*x[0]**o+(-0.133016832047)*x[0]+(0.663051729844)*x[1]**o+(-0.688058231943)*x[1]
        arg[1]=(-0.0269450330081)*x[0]**o+(0.0944332164606)*x[0]+(-0.285657276114)*x[1]**o+(-0.00151309619508)*x[1]
        ref[0,0]=o*(0.321445299816)*x_ref[0]**(o-1)+(-0.133016832047)
        ref[0,1]=o*(0.663051729844)*x_ref[1]**(o-1)+(-0.688058231943)
        ref[1,0]=o*(-0.0269450330081)*x_ref[0]**(o-1)+(0.0944332164606)
        ref[1,1]=o*(-0.285657276114)*x_ref[1]**(o-1)+(-0.00151309619508)
      else:
        arg[0]=(-0.779418963504)*x[0]**o+(-0.66017852882)*x[0]+(0.0796746454991)*x[1]**o+(-0.559782816375)*x[1]+(0.903645344893)*x[2]**o+(0.752370056114)*x[2]
        arg[1]=(-0.789198080015)*x[0]**o+(-0.61428352272)*x[0]+(-0.0678314090236)*x[1]**o+(-0.592189717525)*x[1]+(0.289759368386)*x[2]**o+(-0.612628874512)*x[2]
        ref[0,0]=o*(-0.779418963504)*x_ref[0]**(o-1)+(-0.66017852882)
        ref[0,1]=o*(0.0796746454991)*x_ref[1]**(o-1)+(-0.559782816375)
        ref[0,2]=o*(0.903645344893)*x_ref[2]**(o-1)+(0.752370056114)
        ref[1,0]=o*(-0.789198080015)*x_ref[0]**(o-1)+(-0.61428352272)
        ref[1,1]=o*(-0.0678314090236)*x_ref[1]**(o-1)+(-0.592189717525)
        ref[1,2]=o*(0.289759368386)*x_ref[2]**(o-1)+(-0.612628874512)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnContactOne_fromData_Solution_rank2(self):
      """
      tests gradient for rank 2 Data on the FunctionOnContactOne

      assumptions: Solution(self.domain) exists
                   self.domain supports gradient on FunctionOnContactOne
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=FunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=Solution(self.domain)
      x=w.getX()
      arg=Data(0,(4, 5),w)
      ref=Data(0,(4, 5)+(dim,),w_ref)
      if dim==2:
        arg[0,0]=(-0.23566716053)*x[0]**o+(-0.72341376636)*x[0]+(0.972511874619)*x[1]**o+(-0.915617397257)*x[1]
        arg[0,1]=(-0.767927641628)*x[0]**o+(0.381522882363)*x[0]+(0.147312331507)*x[1]**o+(0.593669546711)*x[1]
        arg[0,2]=(0.735354496752)*x[0]**o+(0.0328129903288)*x[0]+(-0.113236521952)*x[1]**o+(0.486761746739)*x[1]
        arg[0,3]=(-0.324209941994)*x[0]**o+(-0.235510827792)*x[0]+(0.167116943517)*x[1]**o+(0.0751459244008)*x[1]
        arg[0,4]=(-0.880038149806)*x[0]**o+(0.250698509807)*x[0]+(-0.249975000596)*x[1]**o+(-0.597287763096)*x[1]
        arg[1,0]=(0.0776176376816)*x[0]**o+(0.719231364575)*x[0]+(-0.573766708326)*x[1]**o+(-0.0657431038913)*x[1]
        arg[1,1]=(0.214586176047)*x[0]**o+(-0.542584637828)*x[0]+(-0.649916769602)*x[1]**o+(0.360674473897)*x[1]
        arg[1,2]=(-0.131191309002)*x[0]**o+(0.00956079049513)*x[0]+(-0.0399067337815)*x[1]**o+(-0.870803424616)*x[1]
        arg[1,3]=(-0.604243786872)*x[0]**o+(0.439677657963)*x[0]+(0.749342339715)*x[1]**o+(0.772192804507)*x[1]
        arg[1,4]=(0.461907488239)*x[0]**o+(-0.957858912937)*x[0]+(0.915893716197)*x[1]**o+(-0.858798101783)*x[1]
        arg[2,0]=(0.922598387398)*x[0]**o+(-0.194676923002)*x[0]+(-0.724972013231)*x[1]**o+(-0.83198174562)*x[1]
        arg[2,1]=(0.62648959348)*x[0]**o+(-0.968390708088)*x[0]+(0.955519507666)*x[1]**o+(0.0140489471727)*x[1]
        arg[2,2]=(-0.488249561275)*x[0]**o+(-0.354607683897)*x[0]+(-0.781278758499)*x[1]**o+(-0.206598205965)*x[1]
        arg[2,3]=(-0.503987693598)*x[0]**o+(0.581909066959)*x[0]+(0.133400791996)*x[1]**o+(-0.234595457546)*x[1]
        arg[2,4]=(-0.768789727431)*x[0]**o+(0.669013649323)*x[0]+(-0.618484878747)*x[1]**o+(-0.287461699457)*x[1]
        arg[3,0]=(0.125603852132)*x[0]**o+(0.83276119445)*x[0]+(-0.643188775199)*x[1]**o+(0.228300434999)*x[1]
        arg[3,1]=(0.645892506866)*x[0]**o+(0.701922167913)*x[0]+(-0.283958147744)*x[1]**o+(-0.781197564279)*x[1]
        arg[3,2]=(-0.0995754594857)*x[0]**o+(-0.106281614694)*x[0]+(0.00912723779796)*x[1]**o+(0.841448365384)*x[1]
        arg[3,3]=(-0.664740577186)*x[0]**o+(0.100401840489)*x[0]+(0.334300978415)*x[1]**o+(-0.383639183037)*x[1]
        arg[3,4]=(0.949394733501)*x[0]**o+(-0.0768203586407)*x[0]+(0.715238033192)*x[1]**o+(-0.175178433047)*x[1]
        ref[0,0,0]=o*(-0.23566716053)*x_ref[0]**(o-1)+(-0.72341376636)
        ref[0,0,1]=o*(0.972511874619)*x_ref[1]**(o-1)+(-0.915617397257)
        ref[0,1,0]=o*(-0.767927641628)*x_ref[0]**(o-1)+(0.381522882363)
        ref[0,1,1]=o*(0.147312331507)*x_ref[1]**(o-1)+(0.593669546711)
        ref[0,2,0]=o*(0.735354496752)*x_ref[0]**(o-1)+(0.0328129903288)
        ref[0,2,1]=o*(-0.113236521952)*x_ref[1]**(o-1)+(0.486761746739)
        ref[0,3,0]=o*(-0.324209941994)*x_ref[0]**(o-1)+(-0.235510827792)
        ref[0,3,1]=o*(0.167116943517)*x_ref[1]**(o-1)+(0.0751459244008)
        ref[0,4,0]=o*(-0.880038149806)*x_ref[0]**(o-1)+(0.250698509807)
        ref[0,4,1]=o*(-0.249975000596)*x_ref[1]**(o-1)+(-0.597287763096)
        ref[1,0,0]=o*(0.0776176376816)*x_ref[0]**(o-1)+(0.719231364575)
        ref[1,0,1]=o*(-0.573766708326)*x_ref[1]**(o-1)+(-0.0657431038913)
        ref[1,1,0]=o*(0.214586176047)*x_ref[0]**(o-1)+(-0.542584637828)
        ref[1,1,1]=o*(-0.649916769602)*x_ref[1]**(o-1)+(0.360674473897)
        ref[1,2,0]=o*(-0.131191309002)*x_ref[0]**(o-1)+(0.00956079049513)
        ref[1,2,1]=o*(-0.0399067337815)*x_ref[1]**(o-1)+(-0.870803424616)
        ref[1,3,0]=o*(-0.604243786872)*x_ref[0]**(o-1)+(0.439677657963)
        ref[1,3,1]=o*(0.749342339715)*x_ref[1]**(o-1)+(0.772192804507)
        ref[1,4,0]=o*(0.461907488239)*x_ref[0]**(o-1)+(-0.957858912937)
        ref[1,4,1]=o*(0.915893716197)*x_ref[1]**(o-1)+(-0.858798101783)
        ref[2,0,0]=o*(0.922598387398)*x_ref[0]**(o-1)+(-0.194676923002)
        ref[2,0,1]=o*(-0.724972013231)*x_ref[1]**(o-1)+(-0.83198174562)
        ref[2,1,0]=o*(0.62648959348)*x_ref[0]**(o-1)+(-0.968390708088)
        ref[2,1,1]=o*(0.955519507666)*x_ref[1]**(o-1)+(0.0140489471727)
        ref[2,2,0]=o*(-0.488249561275)*x_ref[0]**(o-1)+(-0.354607683897)
        ref[2,2,1]=o*(-0.781278758499)*x_ref[1]**(o-1)+(-0.206598205965)
        ref[2,3,0]=o*(-0.503987693598)*x_ref[0]**(o-1)+(0.581909066959)
        ref[2,3,1]=o*(0.133400791996)*x_ref[1]**(o-1)+(-0.234595457546)
        ref[2,4,0]=o*(-0.768789727431)*x_ref[0]**(o-1)+(0.669013649323)
        ref[2,4,1]=o*(-0.618484878747)*x_ref[1]**(o-1)+(-0.287461699457)
        ref[3,0,0]=o*(0.125603852132)*x_ref[0]**(o-1)+(0.83276119445)
        ref[3,0,1]=o*(-0.643188775199)*x_ref[1]**(o-1)+(0.228300434999)
        ref[3,1,0]=o*(0.645892506866)*x_ref[0]**(o-1)+(0.701922167913)
        ref[3,1,1]=o*(-0.283958147744)*x_ref[1]**(o-1)+(-0.781197564279)
        ref[3,2,0]=o*(-0.0995754594857)*x_ref[0]**(o-1)+(-0.106281614694)
        ref[3,2,1]=o*(0.00912723779796)*x_ref[1]**(o-1)+(0.841448365384)
        ref[3,3,0]=o*(-0.664740577186)*x_ref[0]**(o-1)+(0.100401840489)
        ref[3,3,1]=o*(0.334300978415)*x_ref[1]**(o-1)+(-0.383639183037)
        ref[3,4,0]=o*(0.949394733501)*x_ref[0]**(o-1)+(-0.0768203586407)
        ref[3,4,1]=o*(0.715238033192)*x_ref[1]**(o-1)+(-0.175178433047)
      else:
        arg[0,0]=(0.697509098917)*x[0]**o+(-0.571983680004)*x[0]+(0.456254556306)*x[1]**o+(0.407076527516)*x[1]+(-0.379511349609)*x[2]**o+(0.37799055755)*x[2]
        arg[0,1]=(-0.543310012054)*x[0]**o+(0.622613643381)*x[0]+(0.899028609397)*x[1]**o+(0.0358870746022)*x[1]+(0.923875380698)*x[2]**o+(-0.79605331054)*x[2]
        arg[0,2]=(0.613316685189)*x[0]**o+(0.308568047177)*x[0]+(0.0817110033202)*x[1]**o+(0.631167179752)*x[1]+(0.527259723046)*x[2]**o+(-0.44240882282)*x[2]
        arg[0,3]=(0.831261835833)*x[0]**o+(-0.0869775296331)*x[0]+(0.30622781536)*x[1]**o+(0.633056041347)*x[1]+(0.631243241273)*x[2]**o+(0.100112313541)*x[2]
        arg[0,4]=(-0.997030704248)*x[0]**o+(-0.374466395678)*x[0]+(0.0194535973217)*x[1]**o+(0.816505299829)*x[1]+(-0.412869831136)*x[2]**o+(-0.943976805293)*x[2]
        arg[1,0]=(0.555404162574)*x[0]**o+(-0.335389786458)*x[0]+(0.644585507787)*x[1]**o+(0.917280812233)*x[1]+(0.417410132456)*x[2]**o+(-0.26505427144)*x[2]
        arg[1,1]=(0.781185373116)*x[0]**o+(-0.852319927495)*x[0]+(-0.442528270016)*x[1]**o+(-0.538132919634)*x[1]+(-0.604047417588)*x[2]**o+(0.727395882535)*x[2]
        arg[1,2]=(-0.272462727471)*x[0]**o+(-0.834077558378)*x[0]+(0.763269297137)*x[1]**o+(-0.823180222291)*x[1]+(-0.162146758865)*x[2]**o+(0.595529366226)*x[2]
        arg[1,3]=(-0.0468429326976)*x[0]**o+(-0.179116342871)*x[0]+(-0.640563576973)*x[1]**o+(0.914070705704)*x[1]+(0.725297040984)*x[2]**o+(0.870302256055)*x[2]
        arg[1,4]=(-0.0632444730547)*x[0]**o+(-0.266315658984)*x[0]+(0.533681589116)*x[1]**o+(0.709939511175)*x[1]+(-0.60554532679)*x[2]**o+(0.915224044125)*x[2]
        arg[2,0]=(0.23330035938)*x[0]**o+(-0.385419740264)*x[0]+(0.120424890588)*x[1]**o+(0.591983224766)*x[1]+(0.925564960339)*x[2]**o+(-0.602528014193)*x[2]
        arg[2,1]=(0.786024569139)*x[0]**o+(0.619287163829)*x[0]+(-0.722187904611)*x[1]**o+(0.275352886478)*x[1]+(0.723591624164)*x[2]**o+(0.0909486746072)*x[2]
        arg[2,2]=(0.766293557291)*x[0]**o+(0.0610694643295)*x[0]+(0.375714644104)*x[1]**o+(-0.772092520637)*x[1]+(0.775058332825)*x[2]**o+(0.533525926942)*x[2]
        arg[2,3]=(-0.67254491898)*x[0]**o+(-0.0926113197516)*x[0]+(-0.615891770107)*x[1]**o+(-0.616600504392)*x[1]+(-0.808251600122)*x[2]**o+(-0.602309670223)*x[2]
        arg[2,4]=(0.80242562495)*x[0]**o+(0.359171734464)*x[0]+(-0.560256436586)*x[1]**o+(-0.420334736194)*x[1]+(0.871043977034)*x[2]**o+(0.156212055829)*x[2]
        arg[3,0]=(-0.0569856826934)*x[0]**o+(-0.381868544897)*x[0]+(-0.396013644801)*x[1]**o+(0.695329212849)*x[1]+(0.201188831017)*x[2]**o+(0.471078018432)*x[2]
        arg[3,1]=(0.28457474179)*x[0]**o+(-0.623305572154)*x[0]+(-0.442659858168)*x[1]**o+(0.725900635371)*x[1]+(-0.908206119008)*x[2]**o+(-0.190223696293)*x[2]
        arg[3,2]=(0.568043480074)*x[0]**o+(0.942235524274)*x[0]+(-0.720727900911)*x[1]**o+(0.771808109591)*x[1]+(-0.538996050264)*x[2]**o+(-0.641448383256)*x[2]
        arg[3,3]=(0.00707362989382)*x[0]**o+(0.139812417833)*x[0]+(-0.179986304531)*x[1]**o+(-0.546332565953)*x[1]+(-0.687783685855)*x[2]**o+(0.292513389166)*x[2]
        arg[3,4]=(0.657315930332)*x[0]**o+(0.0252304793386)*x[0]+(0.540737656651)*x[1]**o+(0.832327802479)*x[1]+(-0.822641904799)*x[2]**o+(-0.599972412377)*x[2]
        ref[0,0,0]=o*(0.697509098917)*x_ref[0]**(o-1)+(-0.571983680004)
        ref[0,0,1]=o*(0.456254556306)*x_ref[1]**(o-1)+(0.407076527516)
        ref[0,0,2]=o*(-0.379511349609)*x_ref[2]**(o-1)+(0.37799055755)
        ref[0,1,0]=o*(-0.543310012054)*x_ref[0]**(o-1)+(0.622613643381)
        ref[0,1,1]=o*(0.899028609397)*x_ref[1]**(o-1)+(0.0358870746022)
        ref[0,1,2]=o*(0.923875380698)*x_ref[2]**(o-1)+(-0.79605331054)
        ref[0,2,0]=o*(0.613316685189)*x_ref[0]**(o-1)+(0.308568047177)
        ref[0,2,1]=o*(0.0817110033202)*x_ref[1]**(o-1)+(0.631167179752)
        ref[0,2,2]=o*(0.527259723046)*x_ref[2]**(o-1)+(-0.44240882282)
        ref[0,3,0]=o*(0.831261835833)*x_ref[0]**(o-1)+(-0.0869775296331)
        ref[0,3,1]=o*(0.30622781536)*x_ref[1]**(o-1)+(0.633056041347)
        ref[0,3,2]=o*(0.631243241273)*x_ref[2]**(o-1)+(0.100112313541)
        ref[0,4,0]=o*(-0.997030704248)*x_ref[0]**(o-1)+(-0.374466395678)
        ref[0,4,1]=o*(0.0194535973217)*x_ref[1]**(o-1)+(0.816505299829)
        ref[0,4,2]=o*(-0.412869831136)*x_ref[2]**(o-1)+(-0.943976805293)
        ref[1,0,0]=o*(0.555404162574)*x_ref[0]**(o-1)+(-0.335389786458)
        ref[1,0,1]=o*(0.644585507787)*x_ref[1]**(o-1)+(0.917280812233)
        ref[1,0,2]=o*(0.417410132456)*x_ref[2]**(o-1)+(-0.26505427144)
        ref[1,1,0]=o*(0.781185373116)*x_ref[0]**(o-1)+(-0.852319927495)
        ref[1,1,1]=o*(-0.442528270016)*x_ref[1]**(o-1)+(-0.538132919634)
        ref[1,1,2]=o*(-0.604047417588)*x_ref[2]**(o-1)+(0.727395882535)
        ref[1,2,0]=o*(-0.272462727471)*x_ref[0]**(o-1)+(-0.834077558378)
        ref[1,2,1]=o*(0.763269297137)*x_ref[1]**(o-1)+(-0.823180222291)
        ref[1,2,2]=o*(-0.162146758865)*x_ref[2]**(o-1)+(0.595529366226)
        ref[1,3,0]=o*(-0.0468429326976)*x_ref[0]**(o-1)+(-0.179116342871)
        ref[1,3,1]=o*(-0.640563576973)*x_ref[1]**(o-1)+(0.914070705704)
        ref[1,3,2]=o*(0.725297040984)*x_ref[2]**(o-1)+(0.870302256055)
        ref[1,4,0]=o*(-0.0632444730547)*x_ref[0]**(o-1)+(-0.266315658984)
        ref[1,4,1]=o*(0.533681589116)*x_ref[1]**(o-1)+(0.709939511175)
        ref[1,4,2]=o*(-0.60554532679)*x_ref[2]**(o-1)+(0.915224044125)
        ref[2,0,0]=o*(0.23330035938)*x_ref[0]**(o-1)+(-0.385419740264)
        ref[2,0,1]=o*(0.120424890588)*x_ref[1]**(o-1)+(0.591983224766)
        ref[2,0,2]=o*(0.925564960339)*x_ref[2]**(o-1)+(-0.602528014193)
        ref[2,1,0]=o*(0.786024569139)*x_ref[0]**(o-1)+(0.619287163829)
        ref[2,1,1]=o*(-0.722187904611)*x_ref[1]**(o-1)+(0.275352886478)
        ref[2,1,2]=o*(0.723591624164)*x_ref[2]**(o-1)+(0.0909486746072)
        ref[2,2,0]=o*(0.766293557291)*x_ref[0]**(o-1)+(0.0610694643295)
        ref[2,2,1]=o*(0.375714644104)*x_ref[1]**(o-1)+(-0.772092520637)
        ref[2,2,2]=o*(0.775058332825)*x_ref[2]**(o-1)+(0.533525926942)
        ref[2,3,0]=o*(-0.67254491898)*x_ref[0]**(o-1)+(-0.0926113197516)
        ref[2,3,1]=o*(-0.615891770107)*x_ref[1]**(o-1)+(-0.616600504392)
        ref[2,3,2]=o*(-0.808251600122)*x_ref[2]**(o-1)+(-0.602309670223)
        ref[2,4,0]=o*(0.80242562495)*x_ref[0]**(o-1)+(0.359171734464)
        ref[2,4,1]=o*(-0.560256436586)*x_ref[1]**(o-1)+(-0.420334736194)
        ref[2,4,2]=o*(0.871043977034)*x_ref[2]**(o-1)+(0.156212055829)
        ref[3,0,0]=o*(-0.0569856826934)*x_ref[0]**(o-1)+(-0.381868544897)
        ref[3,0,1]=o*(-0.396013644801)*x_ref[1]**(o-1)+(0.695329212849)
        ref[3,0,2]=o*(0.201188831017)*x_ref[2]**(o-1)+(0.471078018432)
        ref[3,1,0]=o*(0.28457474179)*x_ref[0]**(o-1)+(-0.623305572154)
        ref[3,1,1]=o*(-0.442659858168)*x_ref[1]**(o-1)+(0.725900635371)
        ref[3,1,2]=o*(-0.908206119008)*x_ref[2]**(o-1)+(-0.190223696293)
        ref[3,2,0]=o*(0.568043480074)*x_ref[0]**(o-1)+(0.942235524274)
        ref[3,2,1]=o*(-0.720727900911)*x_ref[1]**(o-1)+(0.771808109591)
        ref[3,2,2]=o*(-0.538996050264)*x_ref[2]**(o-1)+(-0.641448383256)
        ref[3,3,0]=o*(0.00707362989382)*x_ref[0]**(o-1)+(0.139812417833)
        ref[3,3,1]=o*(-0.179986304531)*x_ref[1]**(o-1)+(-0.546332565953)
        ref[3,3,2]=o*(-0.687783685855)*x_ref[2]**(o-1)+(0.292513389166)
        ref[3,4,0]=o*(0.657315930332)*x_ref[0]**(o-1)+(0.0252304793386)
        ref[3,4,1]=o*(0.540737656651)*x_ref[1]**(o-1)+(0.832327802479)
        ref[3,4,2]=o*(-0.822641904799)*x_ref[2]**(o-1)+(-0.599972412377)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnContactOne_fromData_Solution_rank3(self):
      """
      tests gradient for rank 3 Data on the FunctionOnContactOne

      assumptions: Solution(self.domain) exists
                   self.domain supports gradient on FunctionOnContactOne
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=FunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=Solution(self.domain)
      x=w.getX()
      arg=Data(0,(6, 2, 2),w)
      ref=Data(0,(6, 2, 2)+(dim,),w_ref)
      if dim==2:
        arg[0,0,0]=(0.711259674136)*x[0]**o+(0.597099394118)*x[0]+(0.656676641605)*x[1]**o+(0.800065074626)*x[1]
        arg[0,0,1]=(0.410575880869)*x[0]**o+(0.0290305819624)*x[0]+(-0.746442034948)*x[1]**o+(0.074826200729)*x[1]
        arg[0,1,0]=(0.478073638149)*x[0]**o+(0.856920711223)*x[0]+(0.517173340088)*x[1]**o+(-0.677846282063)*x[1]
        arg[0,1,1]=(0.285231489647)*x[0]**o+(0.0756593965609)*x[0]+(-0.355221676478)*x[1]**o+(-0.520564308221)*x[1]
        arg[1,0,0]=(-0.368777104698)*x[0]**o+(0.474996103371)*x[0]+(0.675654207136)*x[1]**o+(-0.0324979517659)*x[1]
        arg[1,0,1]=(0.498857835281)*x[0]**o+(-0.73836840989)*x[0]+(0.362789682422)*x[1]**o+(0.315425076703)*x[1]
        arg[1,1,0]=(-0.325384820094)*x[0]**o+(-0.895297521761)*x[0]+(0.563090918504)*x[1]**o+(0.589834648825)*x[1]
        arg[1,1,1]=(0.0378060061714)*x[0]**o+(-0.429064920806)*x[0]+(-0.467324629077)*x[1]**o+(0.938161415082)*x[1]
        arg[2,0,0]=(-0.527827738902)*x[0]**o+(-0.534425169092)*x[0]+(-0.185111533531)*x[1]**o+(-0.810076656622)*x[1]
        arg[2,0,1]=(-0.221712302033)*x[0]**o+(0.883619587624)*x[0]+(-0.972912188123)*x[1]**o+(0.0780565750992)*x[1]
        arg[2,1,0]=(-0.752942706408)*x[0]**o+(-0.153790659605)*x[0]+(-0.398384592556)*x[1]**o+(0.657319049074)*x[1]
        arg[2,1,1]=(0.428492876383)*x[0]**o+(0.427090189076)*x[0]+(-0.017400284896)*x[1]**o+(-0.730635641841)*x[1]
        arg[3,0,0]=(-0.644602330168)*x[0]**o+(0.706532342264)*x[0]+(-0.64532460698)*x[1]**o+(0.850059843173)*x[1]
        arg[3,0,1]=(-0.63066688687)*x[0]**o+(0.578132047851)*x[0]+(0.413335880906)*x[1]**o+(0.611233278281)*x[1]
        arg[3,1,0]=(-0.247378556309)*x[0]**o+(-0.631688468936)*x[0]+(-0.898130068425)*x[1]**o+(0.147210661251)*x[1]
        arg[3,1,1]=(0.979026126394)*x[0]**o+(-0.231003559285)*x[0]+(-0.884530953901)*x[1]**o+(-0.453907922804)*x[1]
        arg[4,0,0]=(-0.584910281652)*x[0]**o+(-0.808929690751)*x[0]+(0.661854511996)*x[1]**o+(0.262336033771)*x[1]
        arg[4,0,1]=(0.32006961919)*x[0]**o+(0.407637671852)*x[0]+(-0.36617527544)*x[1]**o+(-0.28786191714)*x[1]
        arg[4,1,0]=(0.718670448416)*x[0]**o+(-0.836956284868)*x[0]+(0.694744974874)*x[1]**o+(-0.176920245996)*x[1]
        arg[4,1,1]=(-0.892867770142)*x[0]**o+(-0.439240069099)*x[0]+(0.960956271989)*x[1]**o+(-0.559541152716)*x[1]
        arg[5,0,0]=(-0.159459484106)*x[0]**o+(0.497366075466)*x[0]+(0.776343693655)*x[1]**o+(0.326882397775)*x[1]
        arg[5,0,1]=(-0.769197598992)*x[0]**o+(-0.155931232816)*x[0]+(0.306889959757)*x[1]**o+(0.283798117232)*x[1]
        arg[5,1,0]=(0.329987736778)*x[0]**o+(-0.181917315586)*x[0]+(0.896508353752)*x[1]**o+(0.505276687831)*x[1]
        arg[5,1,1]=(-0.805264678584)*x[0]**o+(0.1541429191)*x[0]+(0.759370357364)*x[1]**o+(-0.858941373648)*x[1]
        ref[0,0,0,0]=o*(0.711259674136)*x_ref[0]**(o-1)+(0.597099394118)
        ref[0,0,0,1]=o*(0.656676641605)*x_ref[1]**(o-1)+(0.800065074626)
        ref[0,0,1,0]=o*(0.410575880869)*x_ref[0]**(o-1)+(0.0290305819624)
        ref[0,0,1,1]=o*(-0.746442034948)*x_ref[1]**(o-1)+(0.074826200729)
        ref[0,1,0,0]=o*(0.478073638149)*x_ref[0]**(o-1)+(0.856920711223)
        ref[0,1,0,1]=o*(0.517173340088)*x_ref[1]**(o-1)+(-0.677846282063)
        ref[0,1,1,0]=o*(0.285231489647)*x_ref[0]**(o-1)+(0.0756593965609)
        ref[0,1,1,1]=o*(-0.355221676478)*x_ref[1]**(o-1)+(-0.520564308221)
        ref[1,0,0,0]=o*(-0.368777104698)*x_ref[0]**(o-1)+(0.474996103371)
        ref[1,0,0,1]=o*(0.675654207136)*x_ref[1]**(o-1)+(-0.0324979517659)
        ref[1,0,1,0]=o*(0.498857835281)*x_ref[0]**(o-1)+(-0.73836840989)
        ref[1,0,1,1]=o*(0.362789682422)*x_ref[1]**(o-1)+(0.315425076703)
        ref[1,1,0,0]=o*(-0.325384820094)*x_ref[0]**(o-1)+(-0.895297521761)
        ref[1,1,0,1]=o*(0.563090918504)*x_ref[1]**(o-1)+(0.589834648825)
        ref[1,1,1,0]=o*(0.0378060061714)*x_ref[0]**(o-1)+(-0.429064920806)
        ref[1,1,1,1]=o*(-0.467324629077)*x_ref[1]**(o-1)+(0.938161415082)
        ref[2,0,0,0]=o*(-0.527827738902)*x_ref[0]**(o-1)+(-0.534425169092)
        ref[2,0,0,1]=o*(-0.185111533531)*x_ref[1]**(o-1)+(-0.810076656622)
        ref[2,0,1,0]=o*(-0.221712302033)*x_ref[0]**(o-1)+(0.883619587624)
        ref[2,0,1,1]=o*(-0.972912188123)*x_ref[1]**(o-1)+(0.0780565750992)
        ref[2,1,0,0]=o*(-0.752942706408)*x_ref[0]**(o-1)+(-0.153790659605)
        ref[2,1,0,1]=o*(-0.398384592556)*x_ref[1]**(o-1)+(0.657319049074)
        ref[2,1,1,0]=o*(0.428492876383)*x_ref[0]**(o-1)+(0.427090189076)
        ref[2,1,1,1]=o*(-0.017400284896)*x_ref[1]**(o-1)+(-0.730635641841)
        ref[3,0,0,0]=o*(-0.644602330168)*x_ref[0]**(o-1)+(0.706532342264)
        ref[3,0,0,1]=o*(-0.64532460698)*x_ref[1]**(o-1)+(0.850059843173)
        ref[3,0,1,0]=o*(-0.63066688687)*x_ref[0]**(o-1)+(0.578132047851)
        ref[3,0,1,1]=o*(0.413335880906)*x_ref[1]**(o-1)+(0.611233278281)
        ref[3,1,0,0]=o*(-0.247378556309)*x_ref[0]**(o-1)+(-0.631688468936)
        ref[3,1,0,1]=o*(-0.898130068425)*x_ref[1]**(o-1)+(0.147210661251)
        ref[3,1,1,0]=o*(0.979026126394)*x_ref[0]**(o-1)+(-0.231003559285)
        ref[3,1,1,1]=o*(-0.884530953901)*x_ref[1]**(o-1)+(-0.453907922804)
        ref[4,0,0,0]=o*(-0.584910281652)*x_ref[0]**(o-1)+(-0.808929690751)
        ref[4,0,0,1]=o*(0.661854511996)*x_ref[1]**(o-1)+(0.262336033771)
        ref[4,0,1,0]=o*(0.32006961919)*x_ref[0]**(o-1)+(0.407637671852)
        ref[4,0,1,1]=o*(-0.36617527544)*x_ref[1]**(o-1)+(-0.28786191714)
        ref[4,1,0,0]=o*(0.718670448416)*x_ref[0]**(o-1)+(-0.836956284868)
        ref[4,1,0,1]=o*(0.694744974874)*x_ref[1]**(o-1)+(-0.176920245996)
        ref[4,1,1,0]=o*(-0.892867770142)*x_ref[0]**(o-1)+(-0.439240069099)
        ref[4,1,1,1]=o*(0.960956271989)*x_ref[1]**(o-1)+(-0.559541152716)
        ref[5,0,0,0]=o*(-0.159459484106)*x_ref[0]**(o-1)+(0.497366075466)
        ref[5,0,0,1]=o*(0.776343693655)*x_ref[1]**(o-1)+(0.326882397775)
        ref[5,0,1,0]=o*(-0.769197598992)*x_ref[0]**(o-1)+(-0.155931232816)
        ref[5,0,1,1]=o*(0.306889959757)*x_ref[1]**(o-1)+(0.283798117232)
        ref[5,1,0,0]=o*(0.329987736778)*x_ref[0]**(o-1)+(-0.181917315586)
        ref[5,1,0,1]=o*(0.896508353752)*x_ref[1]**(o-1)+(0.505276687831)
        ref[5,1,1,0]=o*(-0.805264678584)*x_ref[0]**(o-1)+(0.1541429191)
        ref[5,1,1,1]=o*(0.759370357364)*x_ref[1]**(o-1)+(-0.858941373648)
      else:
        arg[0,0,0]=(0.168268053227)*x[0]**o+(-0.693455720059)*x[0]+(-0.929660815724)*x[1]**o+(0.986095168154)*x[1]+(0.736239785757)*x[2]**o+(-0.852231596742)*x[2]
        arg[0,0,1]=(-0.246755690586)*x[0]**o+(0.374568513964)*x[0]+(-0.964930789849)*x[1]**o+(0.911595670675)*x[1]+(-0.450825843592)*x[2]**o+(0.109918389584)*x[2]
        arg[0,1,0]=(-0.733872890764)*x[0]**o+(-0.673737586895)*x[0]+(0.948528017502)*x[1]**o+(0.00135698010622)*x[1]+(0.960702320728)*x[2]**o+(-0.0223793346126)*x[2]
        arg[0,1,1]=(0.117470384547)*x[0]**o+(0.390065805504)*x[0]+(0.116939897886)*x[1]**o+(0.201756470627)*x[1]+(0.649311190776)*x[2]**o+(-0.388330674246)*x[2]
        arg[1,0,0]=(0.848074231014)*x[0]**o+(-0.431699971504)*x[0]+(0.956477578677)*x[1]**o+(0.522633753414)*x[1]+(0.147733403055)*x[2]**o+(0.136817362225)*x[2]
        arg[1,0,1]=(0.482934543775)*x[0]**o+(-0.358181242578)*x[0]+(-0.013088278343)*x[1]**o+(0.002654195003)*x[1]+(0.960898421715)*x[2]**o+(0.23166323571)*x[2]
        arg[1,1,0]=(-0.60469206115)*x[0]**o+(-0.449073005118)*x[0]+(-0.0774626329204)*x[1]**o+(-0.135772353437)*x[1]+(-0.796309060217)*x[2]**o+(-0.0601212417342)*x[2]
        arg[1,1,1]=(0.41742915222)*x[0]**o+(-0.907531578792)*x[0]+(-0.998018453394)*x[1]**o+(0.38863222527)*x[1]+(-0.941909949653)*x[2]**o+(-0.962025400733)*x[2]
        arg[2,0,0]=(0.677803680186)*x[0]**o+(0.493757303449)*x[0]+(-0.700353467324)*x[1]**o+(0.713489396377)*x[1]+(-0.147276750564)*x[2]**o+(-0.666815984705)*x[2]
        arg[2,0,1]=(-0.196166170445)*x[0]**o+(-0.776357160477)*x[0]+(0.531757851468)*x[1]**o+(-0.0951663105473)*x[1]+(0.296695659682)*x[2]**o+(0.132047740242)*x[2]
        arg[2,1,0]=(0.89703218788)*x[0]**o+(0.446461958293)*x[0]+(0.849781349832)*x[1]**o+(0.495003438762)*x[1]+(0.200866318394)*x[2]**o+(-0.239158244355)*x[2]
        arg[2,1,1]=(0.699816693)*x[0]**o+(-0.498016262468)*x[0]+(0.467212425781)*x[1]**o+(0.507210685133)*x[1]+(0.872000089805)*x[2]**o+(-0.608415132584)*x[2]
        arg[3,0,0]=(-0.858779999521)*x[0]**o+(-0.934307938564)*x[0]+(0.998531969194)*x[1]**o+(-0.10694369616)*x[1]+(0.565515051636)*x[2]**o+(-0.340328286843)*x[2]
        arg[3,0,1]=(-0.734447160975)*x[0]**o+(0.592969337009)*x[0]+(0.769648460523)*x[1]**o+(0.939994123398)*x[1]+(-0.14168879251)*x[2]**o+(-0.151602759825)*x[2]
        arg[3,1,0]=(-0.204447368694)*x[0]**o+(-0.149512701586)*x[0]+(0.496643987821)*x[1]**o+(0.137154021271)*x[1]+(-0.207451973465)*x[2]**o+(0.976289933313)*x[2]
        arg[3,1,1]=(-0.498939396392)*x[0]**o+(-0.388761371521)*x[0]+(0.918876234523)*x[1]**o+(0.326334103437)*x[1]+(0.135801853065)*x[2]**o+(-0.513268577694)*x[2]
        arg[4,0,0]=(0.383369953978)*x[0]**o+(0.262190952188)*x[0]+(0.226913840907)*x[1]**o+(0.625767074123)*x[1]+(0.0736409418752)*x[2]**o+(-0.681643359069)*x[2]
        arg[4,0,1]=(-0.00395633017219)*x[0]**o+(0.103598757494)*x[0]+(0.245388867438)*x[1]**o+(0.0199139065324)*x[1]+(-0.85935209669)*x[2]**o+(0.780770429677)*x[2]
        arg[4,1,0]=(0.93284113054)*x[0]**o+(0.192867707515)*x[0]+(0.354258046046)*x[1]**o+(0.0244899514488)*x[1]+(-0.00723308587137)*x[2]**o+(0.724287748378)*x[2]
        arg[4,1,1]=(-0.701870704251)*x[0]**o+(0.29146856048)*x[0]+(-0.677358067691)*x[1]**o+(-0.055827889309)*x[1]+(0.96248585097)*x[2]**o+(0.100526700803)*x[2]
        arg[5,0,0]=(-0.582058132348)*x[0]**o+(0.5354038569)*x[0]+(-0.608415656952)*x[1]**o+(0.700352801694)*x[1]+(-0.705438310252)*x[2]**o+(0.969824711925)*x[2]
        arg[5,0,1]=(-0.573326444971)*x[0]**o+(0.00490482707944)*x[0]+(0.300312254171)*x[1]**o+(-0.620154697788)*x[1]+(-0.0703788860867)*x[2]**o+(-0.608567609941)*x[2]
        arg[5,1,0]=(0.346782282755)*x[0]**o+(-0.022146949553)*x[0]+(0.548359292626)*x[1]**o+(0.314315074761)*x[1]+(0.164808336191)*x[2]**o+(-0.983018613943)*x[2]
        arg[5,1,1]=(-0.357126808896)*x[0]**o+(0.547191129837)*x[0]+(-0.0128153418859)*x[1]**o+(-0.199507147279)*x[1]+(-0.637546467191)*x[2]**o+(0.65056997574)*x[2]
        ref[0,0,0,0]=o*(0.168268053227)*x_ref[0]**(o-1)+(-0.693455720059)
        ref[0,0,0,1]=o*(-0.929660815724)*x_ref[1]**(o-1)+(0.986095168154)
        ref[0,0,0,2]=o*(0.736239785757)*x_ref[2]**(o-1)+(-0.852231596742)
        ref[0,0,1,0]=o*(-0.246755690586)*x_ref[0]**(o-1)+(0.374568513964)
        ref[0,0,1,1]=o*(-0.964930789849)*x_ref[1]**(o-1)+(0.911595670675)
        ref[0,0,1,2]=o*(-0.450825843592)*x_ref[2]**(o-1)+(0.109918389584)
        ref[0,1,0,0]=o*(-0.733872890764)*x_ref[0]**(o-1)+(-0.673737586895)
        ref[0,1,0,1]=o*(0.948528017502)*x_ref[1]**(o-1)+(0.00135698010622)
        ref[0,1,0,2]=o*(0.960702320728)*x_ref[2]**(o-1)+(-0.0223793346126)
        ref[0,1,1,0]=o*(0.117470384547)*x_ref[0]**(o-1)+(0.390065805504)
        ref[0,1,1,1]=o*(0.116939897886)*x_ref[1]**(o-1)+(0.201756470627)
        ref[0,1,1,2]=o*(0.649311190776)*x_ref[2]**(o-1)+(-0.388330674246)
        ref[1,0,0,0]=o*(0.848074231014)*x_ref[0]**(o-1)+(-0.431699971504)
        ref[1,0,0,1]=o*(0.956477578677)*x_ref[1]**(o-1)+(0.522633753414)
        ref[1,0,0,2]=o*(0.147733403055)*x_ref[2]**(o-1)+(0.136817362225)
        ref[1,0,1,0]=o*(0.482934543775)*x_ref[0]**(o-1)+(-0.358181242578)
        ref[1,0,1,1]=o*(-0.013088278343)*x_ref[1]**(o-1)+(0.002654195003)
        ref[1,0,1,2]=o*(0.960898421715)*x_ref[2]**(o-1)+(0.23166323571)
        ref[1,1,0,0]=o*(-0.60469206115)*x_ref[0]**(o-1)+(-0.449073005118)
        ref[1,1,0,1]=o*(-0.0774626329204)*x_ref[1]**(o-1)+(-0.135772353437)
        ref[1,1,0,2]=o*(-0.796309060217)*x_ref[2]**(o-1)+(-0.0601212417342)
        ref[1,1,1,0]=o*(0.41742915222)*x_ref[0]**(o-1)+(-0.907531578792)
        ref[1,1,1,1]=o*(-0.998018453394)*x_ref[1]**(o-1)+(0.38863222527)
        ref[1,1,1,2]=o*(-0.941909949653)*x_ref[2]**(o-1)+(-0.962025400733)
        ref[2,0,0,0]=o*(0.677803680186)*x_ref[0]**(o-1)+(0.493757303449)
        ref[2,0,0,1]=o*(-0.700353467324)*x_ref[1]**(o-1)+(0.713489396377)
        ref[2,0,0,2]=o*(-0.147276750564)*x_ref[2]**(o-1)+(-0.666815984705)
        ref[2,0,1,0]=o*(-0.196166170445)*x_ref[0]**(o-1)+(-0.776357160477)
        ref[2,0,1,1]=o*(0.531757851468)*x_ref[1]**(o-1)+(-0.0951663105473)
        ref[2,0,1,2]=o*(0.296695659682)*x_ref[2]**(o-1)+(0.132047740242)
        ref[2,1,0,0]=o*(0.89703218788)*x_ref[0]**(o-1)+(0.446461958293)
        ref[2,1,0,1]=o*(0.849781349832)*x_ref[1]**(o-1)+(0.495003438762)
        ref[2,1,0,2]=o*(0.200866318394)*x_ref[2]**(o-1)+(-0.239158244355)
        ref[2,1,1,0]=o*(0.699816693)*x_ref[0]**(o-1)+(-0.498016262468)
        ref[2,1,1,1]=o*(0.467212425781)*x_ref[1]**(o-1)+(0.507210685133)
        ref[2,1,1,2]=o*(0.872000089805)*x_ref[2]**(o-1)+(-0.608415132584)
        ref[3,0,0,0]=o*(-0.858779999521)*x_ref[0]**(o-1)+(-0.934307938564)
        ref[3,0,0,1]=o*(0.998531969194)*x_ref[1]**(o-1)+(-0.10694369616)
        ref[3,0,0,2]=o*(0.565515051636)*x_ref[2]**(o-1)+(-0.340328286843)
        ref[3,0,1,0]=o*(-0.734447160975)*x_ref[0]**(o-1)+(0.592969337009)
        ref[3,0,1,1]=o*(0.769648460523)*x_ref[1]**(o-1)+(0.939994123398)
        ref[3,0,1,2]=o*(-0.14168879251)*x_ref[2]**(o-1)+(-0.151602759825)
        ref[3,1,0,0]=o*(-0.204447368694)*x_ref[0]**(o-1)+(-0.149512701586)
        ref[3,1,0,1]=o*(0.496643987821)*x_ref[1]**(o-1)+(0.137154021271)
        ref[3,1,0,2]=o*(-0.207451973465)*x_ref[2]**(o-1)+(0.976289933313)
        ref[3,1,1,0]=o*(-0.498939396392)*x_ref[0]**(o-1)+(-0.388761371521)
        ref[3,1,1,1]=o*(0.918876234523)*x_ref[1]**(o-1)+(0.326334103437)
        ref[3,1,1,2]=o*(0.135801853065)*x_ref[2]**(o-1)+(-0.513268577694)
        ref[4,0,0,0]=o*(0.383369953978)*x_ref[0]**(o-1)+(0.262190952188)
        ref[4,0,0,1]=o*(0.226913840907)*x_ref[1]**(o-1)+(0.625767074123)
        ref[4,0,0,2]=o*(0.0736409418752)*x_ref[2]**(o-1)+(-0.681643359069)
        ref[4,0,1,0]=o*(-0.00395633017219)*x_ref[0]**(o-1)+(0.103598757494)
        ref[4,0,1,1]=o*(0.245388867438)*x_ref[1]**(o-1)+(0.0199139065324)
        ref[4,0,1,2]=o*(-0.85935209669)*x_ref[2]**(o-1)+(0.780770429677)
        ref[4,1,0,0]=o*(0.93284113054)*x_ref[0]**(o-1)+(0.192867707515)
        ref[4,1,0,1]=o*(0.354258046046)*x_ref[1]**(o-1)+(0.0244899514488)
        ref[4,1,0,2]=o*(-0.00723308587137)*x_ref[2]**(o-1)+(0.724287748378)
        ref[4,1,1,0]=o*(-0.701870704251)*x_ref[0]**(o-1)+(0.29146856048)
        ref[4,1,1,1]=o*(-0.677358067691)*x_ref[1]**(o-1)+(-0.055827889309)
        ref[4,1,1,2]=o*(0.96248585097)*x_ref[2]**(o-1)+(0.100526700803)
        ref[5,0,0,0]=o*(-0.582058132348)*x_ref[0]**(o-1)+(0.5354038569)
        ref[5,0,0,1]=o*(-0.608415656952)*x_ref[1]**(o-1)+(0.700352801694)
        ref[5,0,0,2]=o*(-0.705438310252)*x_ref[2]**(o-1)+(0.969824711925)
        ref[5,0,1,0]=o*(-0.573326444971)*x_ref[0]**(o-1)+(0.00490482707944)
        ref[5,0,1,1]=o*(0.300312254171)*x_ref[1]**(o-1)+(-0.620154697788)
        ref[5,0,1,2]=o*(-0.0703788860867)*x_ref[2]**(o-1)+(-0.608567609941)
        ref[5,1,0,0]=o*(0.346782282755)*x_ref[0]**(o-1)+(-0.022146949553)
        ref[5,1,0,1]=o*(0.548359292626)*x_ref[1]**(o-1)+(0.314315074761)
        ref[5,1,0,2]=o*(0.164808336191)*x_ref[2]**(o-1)+(-0.983018613943)
        ref[5,1,1,0]=o*(-0.357126808896)*x_ref[0]**(o-1)+(0.547191129837)
        ref[5,1,1,1]=o*(-0.0128153418859)*x_ref[1]**(o-1)+(-0.199507147279)
        ref[5,1,1,2]=o*(-0.637546467191)*x_ref[2]**(o-1)+(0.65056997574)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnContactOne_fromData_ReducedSolution_rank0(self):
      """
      tests gradient for rank 0 Data on the FunctionOnContactOne

      assumptions: ReducedSolution(self.domain) exists
                   self.domain supports gradient on FunctionOnContactOne
      """
      o=1
      dim=self.domain.getDim()
      w_ref=FunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=ReducedSolution(self.domain)
      x=w.getX()
      arg=Data(0,(),w)
      ref=Data(0,()+(dim,),w_ref)
      if dim==2:
        arg=(0.694260485776)*x[0]+(1.46246375886)*x[1]
        ref[0]=(0.694260485776)
        ref[1]=(1.46246375886)
      else:
        arg=(-1.10912081576)*x[0]+(1.19790363484)*x[1]+(0.555862453192)*x[2]
        ref[0]=(-1.10912081576)
        ref[1]=(1.19790363484)
        ref[2]=(0.555862453192)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),()+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnContactOne_fromData_ReducedSolution_rank1(self):
      """
      tests gradient for rank 1 Data on the FunctionOnContactOne

      assumptions: ReducedSolution(self.domain) exists
                   self.domain supports gradient on FunctionOnContactOne
      """
      o=1
      dim=self.domain.getDim()
      w_ref=FunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=ReducedSolution(self.domain)
      x=w.getX()
      arg=Data(0,(2,),w)
      ref=Data(0,(2,)+(dim,),w_ref)
      if dim==2:
        arg[0]=(-0.0963683715208)*x[0]+(-0.985421300426)*x[1]
        arg[1]=(0.50107481561)*x[0]+(0.296191075154)*x[1]
        ref[0,0]=(-0.0963683715208)
        ref[0,1]=(-0.985421300426)
        ref[1,0]=(0.50107481561)
        ref[1,1]=(0.296191075154)
      else:
        arg[0]=(0.790729361248)*x[0]+(0.3673431791)*x[1]+(0.031915702612)*x[2]
        arg[1]=(-0.218629391175)*x[0]+(-0.0619831001578)*x[1]+(-1.46460054046)*x[2]
        ref[0,0]=(0.790729361248)
        ref[0,1]=(0.3673431791)
        ref[0,2]=(0.031915702612)
        ref[1,0]=(-0.218629391175)
        ref[1,1]=(-0.0619831001578)
        ref[1,2]=(-1.46460054046)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnContactOne_fromData_ReducedSolution_rank2(self):
      """
      tests gradient for rank 2 Data on the FunctionOnContactOne

      assumptions: ReducedSolution(self.domain) exists
                   self.domain supports gradient on FunctionOnContactOne
      """
      o=1
      dim=self.domain.getDim()
      w_ref=FunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=ReducedSolution(self.domain)
      x=w.getX()
      arg=Data(0,(4, 5),w)
      ref=Data(0,(4, 5)+(dim,),w_ref)
      if dim==2:
        arg[0,0]=(0.102266041928)*x[0]+(0.962985129019)*x[1]
        arg[0,1]=(1.22474578409)*x[0]+(-0.211640772922)*x[1]
        arg[0,2]=(-0.51306749275)*x[0]+(0.652502950912)*x[1]
        arg[0,3]=(1.89516926008)*x[0]+(0.317996805009)*x[1]
        arg[0,4]=(0.562531430083)*x[0]+(-0.194650166716)*x[1]
        arg[1,0]=(0.344353002434)*x[0]+(-0.830671914713)*x[1]
        arg[1,1]=(0.984363231775)*x[0]+(-0.0773767796506)*x[1]
        arg[1,2]=(-0.893978692143)*x[0]+(1.43362006873)*x[1]
        arg[1,3]=(0.603459290036)*x[0]+(-0.527471281229)*x[1]
        arg[1,4]=(-0.768879816113)*x[0]+(0.670739267079)*x[1]
        arg[2,0]=(0.466692398942)*x[0]+(-0.315362658981)*x[1]
        arg[2,1]=(1.30065290708)*x[0]+(-0.202369755569)*x[1]
        arg[2,2]=(-0.114571246331)*x[0]+(1.30250121342)*x[1]
        arg[2,3]=(-0.243608494456)*x[0]+(-0.103398411275)*x[1]
        arg[2,4]=(-0.262568543724)*x[0]+(-0.23979204654)*x[1]
        arg[3,0]=(0.0334727960327)*x[0]+(-0.24547366383)*x[1]
        arg[3,1]=(0.829837477348)*x[0]+(-0.416646135702)*x[1]
        arg[3,2]=(1.43081322579)*x[0]+(0.574724874607)*x[1]
        arg[3,3]=(1.16303985686)*x[0]+(-0.915348714324)*x[1]
        arg[3,4]=(0.773764690591)*x[0]+(0.28049189996)*x[1]
        ref[0,0,0]=(0.102266041928)
        ref[0,0,1]=(0.962985129019)
        ref[0,1,0]=(1.22474578409)
        ref[0,1,1]=(-0.211640772922)
        ref[0,2,0]=(-0.51306749275)
        ref[0,2,1]=(0.652502950912)
        ref[0,3,0]=(1.89516926008)
        ref[0,3,1]=(0.317996805009)
        ref[0,4,0]=(0.562531430083)
        ref[0,4,1]=(-0.194650166716)
        ref[1,0,0]=(0.344353002434)
        ref[1,0,1]=(-0.830671914713)
        ref[1,1,0]=(0.984363231775)
        ref[1,1,1]=(-0.0773767796506)
        ref[1,2,0]=(-0.893978692143)
        ref[1,2,1]=(1.43362006873)
        ref[1,3,0]=(0.603459290036)
        ref[1,3,1]=(-0.527471281229)
        ref[1,4,0]=(-0.768879816113)
        ref[1,4,1]=(0.670739267079)
        ref[2,0,0]=(0.466692398942)
        ref[2,0,1]=(-0.315362658981)
        ref[2,1,0]=(1.30065290708)
        ref[2,1,1]=(-0.202369755569)
        ref[2,2,0]=(-0.114571246331)
        ref[2,2,1]=(1.30250121342)
        ref[2,3,0]=(-0.243608494456)
        ref[2,3,1]=(-0.103398411275)
        ref[2,4,0]=(-0.262568543724)
        ref[2,4,1]=(-0.23979204654)
        ref[3,0,0]=(0.0334727960327)
        ref[3,0,1]=(-0.24547366383)
        ref[3,1,0]=(0.829837477348)
        ref[3,1,1]=(-0.416646135702)
        ref[3,2,0]=(1.43081322579)
        ref[3,2,1]=(0.574724874607)
        ref[3,3,0]=(1.16303985686)
        ref[3,3,1]=(-0.915348714324)
        ref[3,4,0]=(0.773764690591)
        ref[3,4,1]=(0.28049189996)
      else:
        arg[0,0]=(-0.998409457516)*x[0]+(0.374200474533)*x[1]+(-0.397603453862)*x[2]
        arg[0,1]=(-1.48600938216)*x[0]+(1.46358462866)*x[1]+(-0.393381462291)*x[2]
        arg[0,2]=(1.08201727329)*x[0]+(0.065185376372)*x[1]+(-1.32483264357)*x[2]
        arg[0,3]=(-0.518441162)*x[0]+(0.364373161676)*x[1]+(-1.25875574919)*x[2]
        arg[0,4]=(-0.836980279478)*x[0]+(1.21655914685)*x[1]+(0.1586084291)*x[2]
        arg[1,0]=(0.760774732939)*x[0]+(0.515414129191)*x[1]+(-1.50192024303)*x[2]
        arg[1,1]=(-0.653360330499)*x[0]+(1.71417096347)*x[1]+(-0.169129173291)*x[2]
        arg[1,2]=(1.07221333767)*x[0]+(-1.07638348405)*x[1]+(1.13393461135)*x[2]
        arg[1,3]=(0.847567825055)*x[0]+(-0.0298335468796)*x[1]+(0.45122717832)*x[2]
        arg[1,4]=(-0.108027217492)*x[0]+(-1.12654142913)*x[1]+(-0.781718943065)*x[2]
        arg[2,0]=(0.408863322164)*x[0]+(0.100914804776)*x[1]+(-0.471567638444)*x[2]
        arg[2,1]=(-1.42194256762)*x[0]+(-0.348217894465)*x[1]+(-0.830561377367)*x[2]
        arg[2,2]=(1.36876795155)*x[0]+(0.125252389466)*x[1]+(0.00641454191902)*x[2]
        arg[2,3]=(0.135243193372)*x[0]+(-1.04394510102)*x[1]+(0.0223029076973)*x[2]
        arg[2,4]=(-0.969785158394)*x[0]+(-0.48178611106)*x[1]+(-0.0556576599006)*x[2]
        arg[3,0]=(1.39484073703)*x[0]+(-1.0132109886)*x[1]+(0.0205156989927)*x[2]
        arg[3,1]=(-0.92783313898)*x[0]+(-1.27904129731)*x[1]+(-0.817768402689)*x[2]
        arg[3,2]=(1.21718392423)*x[0]+(-0.984091647405)*x[1]+(0.458009888947)*x[2]
        arg[3,3]=(-0.812990754761)*x[0]+(-0.104941245044)*x[1]+(-0.996531826869)*x[2]
        arg[3,4]=(-0.28581988131)*x[0]+(-1.24321114539)*x[1]+(0.408464222517)*x[2]
        ref[0,0,0]=(-0.998409457516)
        ref[0,0,1]=(0.374200474533)
        ref[0,0,2]=(-0.397603453862)
        ref[0,1,0]=(-1.48600938216)
        ref[0,1,1]=(1.46358462866)
        ref[0,1,2]=(-0.393381462291)
        ref[0,2,0]=(1.08201727329)
        ref[0,2,1]=(0.065185376372)
        ref[0,2,2]=(-1.32483264357)
        ref[0,3,0]=(-0.518441162)
        ref[0,3,1]=(0.364373161676)
        ref[0,3,2]=(-1.25875574919)
        ref[0,4,0]=(-0.836980279478)
        ref[0,4,1]=(1.21655914685)
        ref[0,4,2]=(0.1586084291)
        ref[1,0,0]=(0.760774732939)
        ref[1,0,1]=(0.515414129191)
        ref[1,0,2]=(-1.50192024303)
        ref[1,1,0]=(-0.653360330499)
        ref[1,1,1]=(1.71417096347)
        ref[1,1,2]=(-0.169129173291)
        ref[1,2,0]=(1.07221333767)
        ref[1,2,1]=(-1.07638348405)
        ref[1,2,2]=(1.13393461135)
        ref[1,3,0]=(0.847567825055)
        ref[1,3,1]=(-0.0298335468796)
        ref[1,3,2]=(0.45122717832)
        ref[1,4,0]=(-0.108027217492)
        ref[1,4,1]=(-1.12654142913)
        ref[1,4,2]=(-0.781718943065)
        ref[2,0,0]=(0.408863322164)
        ref[2,0,1]=(0.100914804776)
        ref[2,0,2]=(-0.471567638444)
        ref[2,1,0]=(-1.42194256762)
        ref[2,1,1]=(-0.348217894465)
        ref[2,1,2]=(-0.830561377367)
        ref[2,2,0]=(1.36876795155)
        ref[2,2,1]=(0.125252389466)
        ref[2,2,2]=(0.00641454191902)
        ref[2,3,0]=(0.135243193372)
        ref[2,3,1]=(-1.04394510102)
        ref[2,3,2]=(0.0223029076973)
        ref[2,4,0]=(-0.969785158394)
        ref[2,4,1]=(-0.48178611106)
        ref[2,4,2]=(-0.0556576599006)
        ref[3,0,0]=(1.39484073703)
        ref[3,0,1]=(-1.0132109886)
        ref[3,0,2]=(0.0205156989927)
        ref[3,1,0]=(-0.92783313898)
        ref[3,1,1]=(-1.27904129731)
        ref[3,1,2]=(-0.817768402689)
        ref[3,2,0]=(1.21718392423)
        ref[3,2,1]=(-0.984091647405)
        ref[3,2,2]=(0.458009888947)
        ref[3,3,0]=(-0.812990754761)
        ref[3,3,1]=(-0.104941245044)
        ref[3,3,2]=(-0.996531826869)
        ref[3,4,0]=(-0.28581988131)
        ref[3,4,1]=(-1.24321114539)
        ref[3,4,2]=(0.408464222517)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnContactOne_fromData_ReducedSolution_rank3(self):
      """
      tests gradient for rank 3 Data on the FunctionOnContactOne

      assumptions: ReducedSolution(self.domain) exists
                   self.domain supports gradient on FunctionOnContactOne
      """
      o=1
      dim=self.domain.getDim()
      w_ref=FunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=ReducedSolution(self.domain)
      x=w.getX()
      arg=Data(0,(6, 2, 2),w)
      ref=Data(0,(6, 2, 2)+(dim,),w_ref)
      if dim==2:
        arg[0,0,0]=(0.39712204981)*x[0]+(-1.36315938849)*x[1]
        arg[0,0,1]=(0.654450268666)*x[0]+(-0.198258834351)*x[1]
        arg[0,1,0]=(0.21357757124)*x[0]+(0.193878132191)*x[1]
        arg[0,1,1]=(0.0762258436603)*x[0]+(-0.33284111684)*x[1]
        arg[1,0,0]=(-0.264232939297)*x[0]+(-0.726336076701)*x[1]
        arg[1,0,1]=(-0.179928817534)*x[0]+(-0.723247805844)*x[1]
        arg[1,1,0]=(0.923289681593)*x[0]+(0.986763135255)*x[1]
        arg[1,1,1]=(0.065387254507)*x[0]+(-0.710965008545)*x[1]
        arg[2,0,0]=(0.759853961917)*x[0]+(0.24486573839)*x[1]
        arg[2,0,1]=(-0.318336679378)*x[0]+(0.39328274922)*x[1]
        arg[2,1,0]=(-1.562818948)*x[0]+(-0.891340974738)*x[1]
        arg[2,1,1]=(0.0508006116584)*x[0]+(1.17654134987)*x[1]
        arg[3,0,0]=(-0.155883472458)*x[0]+(0.248809866836)*x[1]
        arg[3,0,1]=(0.287794710222)*x[0]+(-1.72525392296)*x[1]
        arg[3,1,0]=(0.00665202042795)*x[0]+(-0.0996395796968)*x[1]
        arg[3,1,1]=(-0.19809021298)*x[0]+(0.487549616652)*x[1]
        arg[4,0,0]=(0.764163773078)*x[0]+(-0.898694486894)*x[1]
        arg[4,0,1]=(-0.213042355119)*x[0]+(0.708925705544)*x[1]
        arg[4,1,0]=(1.55505564031)*x[0]+(-0.545746649289)*x[1]
        arg[4,1,1]=(-1.31623592165)*x[0]+(0.948772953354)*x[1]
        arg[5,0,0]=(0.221103671977)*x[0]+(0.866067107464)*x[1]
        arg[5,0,1]=(-0.0979530612779)*x[0]+(-0.371623102578)*x[1]
        arg[5,1,0]=(-0.348963169972)*x[0]+(-0.692055450872)*x[1]
        arg[5,1,1]=(-0.584053243695)*x[0]+(-0.487768032842)*x[1]
        ref[0,0,0,0]=(0.39712204981)
        ref[0,0,0,1]=(-1.36315938849)
        ref[0,0,1,0]=(0.654450268666)
        ref[0,0,1,1]=(-0.198258834351)
        ref[0,1,0,0]=(0.21357757124)
        ref[0,1,0,1]=(0.193878132191)
        ref[0,1,1,0]=(0.0762258436603)
        ref[0,1,1,1]=(-0.33284111684)
        ref[1,0,0,0]=(-0.264232939297)
        ref[1,0,0,1]=(-0.726336076701)
        ref[1,0,1,0]=(-0.179928817534)
        ref[1,0,1,1]=(-0.723247805844)
        ref[1,1,0,0]=(0.923289681593)
        ref[1,1,0,1]=(0.986763135255)
        ref[1,1,1,0]=(0.065387254507)
        ref[1,1,1,1]=(-0.710965008545)
        ref[2,0,0,0]=(0.759853961917)
        ref[2,0,0,1]=(0.24486573839)
        ref[2,0,1,0]=(-0.318336679378)
        ref[2,0,1,1]=(0.39328274922)
        ref[2,1,0,0]=(-1.562818948)
        ref[2,1,0,1]=(-0.891340974738)
        ref[2,1,1,0]=(0.0508006116584)
        ref[2,1,1,1]=(1.17654134987)
        ref[3,0,0,0]=(-0.155883472458)
        ref[3,0,0,1]=(0.248809866836)
        ref[3,0,1,0]=(0.287794710222)
        ref[3,0,1,1]=(-1.72525392296)
        ref[3,1,0,0]=(0.00665202042795)
        ref[3,1,0,1]=(-0.0996395796968)
        ref[3,1,1,0]=(-0.19809021298)
        ref[3,1,1,1]=(0.487549616652)
        ref[4,0,0,0]=(0.764163773078)
        ref[4,0,0,1]=(-0.898694486894)
        ref[4,0,1,0]=(-0.213042355119)
        ref[4,0,1,1]=(0.708925705544)
        ref[4,1,0,0]=(1.55505564031)
        ref[4,1,0,1]=(-0.545746649289)
        ref[4,1,1,0]=(-1.31623592165)
        ref[4,1,1,1]=(0.948772953354)
        ref[5,0,0,0]=(0.221103671977)
        ref[5,0,0,1]=(0.866067107464)
        ref[5,0,1,0]=(-0.0979530612779)
        ref[5,0,1,1]=(-0.371623102578)
        ref[5,1,0,0]=(-0.348963169972)
        ref[5,1,0,1]=(-0.692055450872)
        ref[5,1,1,0]=(-0.584053243695)
        ref[5,1,1,1]=(-0.487768032842)
      else:
        arg[0,0,0]=(-1.45023987007)*x[0]+(0.138479134523)*x[1]+(1.46404607112)*x[2]
        arg[0,0,1]=(-0.647908832568)*x[0]+(-0.503758830859)*x[1]+(1.23196203665)*x[2]
        arg[0,1,0]=(-0.0108286161243)*x[0]+(0.565615928686)*x[1]+(-0.357789821636)*x[2]
        arg[0,1,1]=(0.648224572901)*x[0]+(0.775857442933)*x[1]+(0.960991462312)*x[2]
        arg[1,0,0]=(0.340590670624)*x[0]+(0.0357759349963)*x[1]+(0.358139256621)*x[2]
        arg[1,0,1]=(0.569789735109)*x[0]+(1.40678949618)*x[1]+(-0.965577726422)*x[2]
        arg[1,1,0]=(-0.758717082212)*x[0]+(0.612968081377)*x[1]+(-0.417988159948)*x[2]
        arg[1,1,1]=(0.969867032567)*x[0]+(-0.0700234825891)*x[1]+(1.53879850558)*x[2]
        arg[2,0,0]=(-1.02952648125)*x[0]+(0.108642437375)*x[1]+(0.251073184196)*x[2]
        arg[2,0,1]=(0.794766888909)*x[0]+(1.50591346365)*x[1]+(-0.36870578891)*x[2]
        arg[2,1,0]=(-0.534487055503)*x[0]+(-1.09061679233)*x[1]+(0.799342633685)*x[2]
        arg[2,1,1]=(0.0435889213805)*x[0]+(-0.209888628166)*x[1]+(1.34633215915)*x[2]
        arg[3,0,0]=(-0.0344682106376)*x[0]+(-0.92386569455)*x[1]+(-0.551250384619)*x[2]
        arg[3,0,1]=(-0.168599962689)*x[0]+(0.204634495314)*x[1]+(-0.65426520271)*x[2]
        arg[3,1,0]=(-1.61759210628)*x[0]+(-0.5922211067)*x[1]+(-0.139092780207)*x[2]
        arg[3,1,1]=(-0.13862300062)*x[0]+(-1.45951050222)*x[1]+(0.300904423579)*x[2]
        arg[4,0,0]=(0.629590770742)*x[0]+(-0.217150209985)*x[1]+(-0.140384227583)*x[2]
        arg[4,0,1]=(-0.0461635416119)*x[0]+(0.525692990183)*x[1]+(-1.89728167146)*x[2]
        arg[4,1,0]=(-0.130297059668)*x[0]+(-0.138816250007)*x[1]+(1.26805054232)*x[2]
        arg[4,1,1]=(0.742488751566)*x[0]+(0.659272799907)*x[1]+(-0.370877917078)*x[2]
        arg[5,0,0]=(-0.521350561164)*x[0]+(-0.213669151076)*x[1]+(0.00949381597317)*x[2]
        arg[5,0,1]=(-0.951547526648)*x[0]+(-0.388340895795)*x[1]+(0.741997603334)*x[2]
        arg[5,1,0]=(-0.332922940005)*x[0]+(1.74852940259)*x[1]+(-0.484189519128)*x[2]
        arg[5,1,1]=(0.418660109098)*x[0]+(-0.690728767024)*x[1]+(-0.675947375912)*x[2]
        ref[0,0,0,0]=(-1.45023987007)
        ref[0,0,0,1]=(0.138479134523)
        ref[0,0,0,2]=(1.46404607112)
        ref[0,0,1,0]=(-0.647908832568)
        ref[0,0,1,1]=(-0.503758830859)
        ref[0,0,1,2]=(1.23196203665)
        ref[0,1,0,0]=(-0.0108286161243)
        ref[0,1,0,1]=(0.565615928686)
        ref[0,1,0,2]=(-0.357789821636)
        ref[0,1,1,0]=(0.648224572901)
        ref[0,1,1,1]=(0.775857442933)
        ref[0,1,1,2]=(0.960991462312)
        ref[1,0,0,0]=(0.340590670624)
        ref[1,0,0,1]=(0.0357759349963)
        ref[1,0,0,2]=(0.358139256621)
        ref[1,0,1,0]=(0.569789735109)
        ref[1,0,1,1]=(1.40678949618)
        ref[1,0,1,2]=(-0.965577726422)
        ref[1,1,0,0]=(-0.758717082212)
        ref[1,1,0,1]=(0.612968081377)
        ref[1,1,0,2]=(-0.417988159948)
        ref[1,1,1,0]=(0.969867032567)
        ref[1,1,1,1]=(-0.0700234825891)
        ref[1,1,1,2]=(1.53879850558)
        ref[2,0,0,0]=(-1.02952648125)
        ref[2,0,0,1]=(0.108642437375)
        ref[2,0,0,2]=(0.251073184196)
        ref[2,0,1,0]=(0.794766888909)
        ref[2,0,1,1]=(1.50591346365)
        ref[2,0,1,2]=(-0.36870578891)
        ref[2,1,0,0]=(-0.534487055503)
        ref[2,1,0,1]=(-1.09061679233)
        ref[2,1,0,2]=(0.799342633685)
        ref[2,1,1,0]=(0.0435889213805)
        ref[2,1,1,1]=(-0.209888628166)
        ref[2,1,1,2]=(1.34633215915)
        ref[3,0,0,0]=(-0.0344682106376)
        ref[3,0,0,1]=(-0.92386569455)
        ref[3,0,0,2]=(-0.551250384619)
        ref[3,0,1,0]=(-0.168599962689)
        ref[3,0,1,1]=(0.204634495314)
        ref[3,0,1,2]=(-0.65426520271)
        ref[3,1,0,0]=(-1.61759210628)
        ref[3,1,0,1]=(-0.5922211067)
        ref[3,1,0,2]=(-0.139092780207)
        ref[3,1,1,0]=(-0.13862300062)
        ref[3,1,1,1]=(-1.45951050222)
        ref[3,1,1,2]=(0.300904423579)
        ref[4,0,0,0]=(0.629590770742)
        ref[4,0,0,1]=(-0.217150209985)
        ref[4,0,0,2]=(-0.140384227583)
        ref[4,0,1,0]=(-0.0461635416119)
        ref[4,0,1,1]=(0.525692990183)
        ref[4,0,1,2]=(-1.89728167146)
        ref[4,1,0,0]=(-0.130297059668)
        ref[4,1,0,1]=(-0.138816250007)
        ref[4,1,0,2]=(1.26805054232)
        ref[4,1,1,0]=(0.742488751566)
        ref[4,1,1,1]=(0.659272799907)
        ref[4,1,1,2]=(-0.370877917078)
        ref[5,0,0,0]=(-0.521350561164)
        ref[5,0,0,1]=(-0.213669151076)
        ref[5,0,0,2]=(0.00949381597317)
        ref[5,0,1,0]=(-0.951547526648)
        ref[5,0,1,1]=(-0.388340895795)
        ref[5,0,1,2]=(0.741997603334)
        ref[5,1,0,0]=(-0.332922940005)
        ref[5,1,0,1]=(1.74852940259)
        ref[5,1,0,2]=(-0.484189519128)
        ref[5,1,1,0]=(0.418660109098)
        ref[5,1,1,1]=(-0.690728767024)
        ref[5,1,1,2]=(-0.675947375912)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnContactOne_fromData_ReducedContinuousFunction_rank0(self):
      """
      tests gradient for rank 0 Data on the FunctionOnContactOne

      assumptions: ReducedContinuousFunction(self.domain) exists
                   self.domain supports gradient on FunctionOnContactOne
      """
      o=1
      dim=self.domain.getDim()
      w_ref=FunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=ReducedContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(),w)
      ref=Data(0,()+(dim,),w_ref)
      if dim==2:
        arg=(0.694260485776)*x[0]+(1.46246375886)*x[1]
        ref[0]=(0.694260485776)
        ref[1]=(1.46246375886)
      else:
        arg=(-1.10912081576)*x[0]+(1.19790363484)*x[1]+(0.555862453192)*x[2]
        ref[0]=(-1.10912081576)
        ref[1]=(1.19790363484)
        ref[2]=(0.555862453192)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),()+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnContactOne_fromData_ReducedContinuousFunction_rank1(self):
      """
      tests gradient for rank 1 Data on the FunctionOnContactOne

      assumptions: ReducedContinuousFunction(self.domain) exists
                   self.domain supports gradient on FunctionOnContactOne
      """
      o=1
      dim=self.domain.getDim()
      w_ref=FunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=ReducedContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(2,),w)
      ref=Data(0,(2,)+(dim,),w_ref)
      if dim==2:
        arg[0]=(-0.0963683715208)*x[0]+(-0.985421300426)*x[1]
        arg[1]=(0.50107481561)*x[0]+(0.296191075154)*x[1]
        ref[0,0]=(-0.0963683715208)
        ref[0,1]=(-0.985421300426)
        ref[1,0]=(0.50107481561)
        ref[1,1]=(0.296191075154)
      else:
        arg[0]=(0.790729361248)*x[0]+(0.3673431791)*x[1]+(0.031915702612)*x[2]
        arg[1]=(-0.218629391175)*x[0]+(-0.0619831001578)*x[1]+(-1.46460054046)*x[2]
        ref[0,0]=(0.790729361248)
        ref[0,1]=(0.3673431791)
        ref[0,2]=(0.031915702612)
        ref[1,0]=(-0.218629391175)
        ref[1,1]=(-0.0619831001578)
        ref[1,2]=(-1.46460054046)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnContactOne_fromData_ReducedContinuousFunction_rank2(self):
      """
      tests gradient for rank 2 Data on the FunctionOnContactOne

      assumptions: ReducedContinuousFunction(self.domain) exists
                   self.domain supports gradient on FunctionOnContactOne
      """
      o=1
      dim=self.domain.getDim()
      w_ref=FunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=ReducedContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(4, 5),w)
      ref=Data(0,(4, 5)+(dim,),w_ref)
      if dim==2:
        arg[0,0]=(0.102266041928)*x[0]+(0.962985129019)*x[1]
        arg[0,1]=(1.22474578409)*x[0]+(-0.211640772922)*x[1]
        arg[0,2]=(-0.51306749275)*x[0]+(0.652502950912)*x[1]
        arg[0,3]=(1.89516926008)*x[0]+(0.317996805009)*x[1]
        arg[0,4]=(0.562531430083)*x[0]+(-0.194650166716)*x[1]
        arg[1,0]=(0.344353002434)*x[0]+(-0.830671914713)*x[1]
        arg[1,1]=(0.984363231775)*x[0]+(-0.0773767796506)*x[1]
        arg[1,2]=(-0.893978692143)*x[0]+(1.43362006873)*x[1]
        arg[1,3]=(0.603459290036)*x[0]+(-0.527471281229)*x[1]
        arg[1,4]=(-0.768879816113)*x[0]+(0.670739267079)*x[1]
        arg[2,0]=(0.466692398942)*x[0]+(-0.315362658981)*x[1]
        arg[2,1]=(1.30065290708)*x[0]+(-0.202369755569)*x[1]
        arg[2,2]=(-0.114571246331)*x[0]+(1.30250121342)*x[1]
        arg[2,3]=(-0.243608494456)*x[0]+(-0.103398411275)*x[1]
        arg[2,4]=(-0.262568543724)*x[0]+(-0.23979204654)*x[1]
        arg[3,0]=(0.0334727960327)*x[0]+(-0.24547366383)*x[1]
        arg[3,1]=(0.829837477348)*x[0]+(-0.416646135702)*x[1]
        arg[3,2]=(1.43081322579)*x[0]+(0.574724874607)*x[1]
        arg[3,3]=(1.16303985686)*x[0]+(-0.915348714324)*x[1]
        arg[3,4]=(0.773764690591)*x[0]+(0.28049189996)*x[1]
        ref[0,0,0]=(0.102266041928)
        ref[0,0,1]=(0.962985129019)
        ref[0,1,0]=(1.22474578409)
        ref[0,1,1]=(-0.211640772922)
        ref[0,2,0]=(-0.51306749275)
        ref[0,2,1]=(0.652502950912)
        ref[0,3,0]=(1.89516926008)
        ref[0,3,1]=(0.317996805009)
        ref[0,4,0]=(0.562531430083)
        ref[0,4,1]=(-0.194650166716)
        ref[1,0,0]=(0.344353002434)
        ref[1,0,1]=(-0.830671914713)
        ref[1,1,0]=(0.984363231775)
        ref[1,1,1]=(-0.0773767796506)
        ref[1,2,0]=(-0.893978692143)
        ref[1,2,1]=(1.43362006873)
        ref[1,3,0]=(0.603459290036)
        ref[1,3,1]=(-0.527471281229)
        ref[1,4,0]=(-0.768879816113)
        ref[1,4,1]=(0.670739267079)
        ref[2,0,0]=(0.466692398942)
        ref[2,0,1]=(-0.315362658981)
        ref[2,1,0]=(1.30065290708)
        ref[2,1,1]=(-0.202369755569)
        ref[2,2,0]=(-0.114571246331)
        ref[2,2,1]=(1.30250121342)
        ref[2,3,0]=(-0.243608494456)
        ref[2,3,1]=(-0.103398411275)
        ref[2,4,0]=(-0.262568543724)
        ref[2,4,1]=(-0.23979204654)
        ref[3,0,0]=(0.0334727960327)
        ref[3,0,1]=(-0.24547366383)
        ref[3,1,0]=(0.829837477348)
        ref[3,1,1]=(-0.416646135702)
        ref[3,2,0]=(1.43081322579)
        ref[3,2,1]=(0.574724874607)
        ref[3,3,0]=(1.16303985686)
        ref[3,3,1]=(-0.915348714324)
        ref[3,4,0]=(0.773764690591)
        ref[3,4,1]=(0.28049189996)
      else:
        arg[0,0]=(-0.998409457516)*x[0]+(0.374200474533)*x[1]+(-0.397603453862)*x[2]
        arg[0,1]=(-1.48600938216)*x[0]+(1.46358462866)*x[1]+(-0.393381462291)*x[2]
        arg[0,2]=(1.08201727329)*x[0]+(0.065185376372)*x[1]+(-1.32483264357)*x[2]
        arg[0,3]=(-0.518441162)*x[0]+(0.364373161676)*x[1]+(-1.25875574919)*x[2]
        arg[0,4]=(-0.836980279478)*x[0]+(1.21655914685)*x[1]+(0.1586084291)*x[2]
        arg[1,0]=(0.760774732939)*x[0]+(0.515414129191)*x[1]+(-1.50192024303)*x[2]
        arg[1,1]=(-0.653360330499)*x[0]+(1.71417096347)*x[1]+(-0.169129173291)*x[2]
        arg[1,2]=(1.07221333767)*x[0]+(-1.07638348405)*x[1]+(1.13393461135)*x[2]
        arg[1,3]=(0.847567825055)*x[0]+(-0.0298335468796)*x[1]+(0.45122717832)*x[2]
        arg[1,4]=(-0.108027217492)*x[0]+(-1.12654142913)*x[1]+(-0.781718943065)*x[2]
        arg[2,0]=(0.408863322164)*x[0]+(0.100914804776)*x[1]+(-0.471567638444)*x[2]
        arg[2,1]=(-1.42194256762)*x[0]+(-0.348217894465)*x[1]+(-0.830561377367)*x[2]
        arg[2,2]=(1.36876795155)*x[0]+(0.125252389466)*x[1]+(0.00641454191902)*x[2]
        arg[2,3]=(0.135243193372)*x[0]+(-1.04394510102)*x[1]+(0.0223029076973)*x[2]
        arg[2,4]=(-0.969785158394)*x[0]+(-0.48178611106)*x[1]+(-0.0556576599006)*x[2]
        arg[3,0]=(1.39484073703)*x[0]+(-1.0132109886)*x[1]+(0.0205156989927)*x[2]
        arg[3,1]=(-0.92783313898)*x[0]+(-1.27904129731)*x[1]+(-0.817768402689)*x[2]
        arg[3,2]=(1.21718392423)*x[0]+(-0.984091647405)*x[1]+(0.458009888947)*x[2]
        arg[3,3]=(-0.812990754761)*x[0]+(-0.104941245044)*x[1]+(-0.996531826869)*x[2]
        arg[3,4]=(-0.28581988131)*x[0]+(-1.24321114539)*x[1]+(0.408464222517)*x[2]
        ref[0,0,0]=(-0.998409457516)
        ref[0,0,1]=(0.374200474533)
        ref[0,0,2]=(-0.397603453862)
        ref[0,1,0]=(-1.48600938216)
        ref[0,1,1]=(1.46358462866)
        ref[0,1,2]=(-0.393381462291)
        ref[0,2,0]=(1.08201727329)
        ref[0,2,1]=(0.065185376372)
        ref[0,2,2]=(-1.32483264357)
        ref[0,3,0]=(-0.518441162)
        ref[0,3,1]=(0.364373161676)
        ref[0,3,2]=(-1.25875574919)
        ref[0,4,0]=(-0.836980279478)
        ref[0,4,1]=(1.21655914685)
        ref[0,4,2]=(0.1586084291)
        ref[1,0,0]=(0.760774732939)
        ref[1,0,1]=(0.515414129191)
        ref[1,0,2]=(-1.50192024303)
        ref[1,1,0]=(-0.653360330499)
        ref[1,1,1]=(1.71417096347)
        ref[1,1,2]=(-0.169129173291)
        ref[1,2,0]=(1.07221333767)
        ref[1,2,1]=(-1.07638348405)
        ref[1,2,2]=(1.13393461135)
        ref[1,3,0]=(0.847567825055)
        ref[1,3,1]=(-0.0298335468796)
        ref[1,3,2]=(0.45122717832)
        ref[1,4,0]=(-0.108027217492)
        ref[1,4,1]=(-1.12654142913)
        ref[1,4,2]=(-0.781718943065)
        ref[2,0,0]=(0.408863322164)
        ref[2,0,1]=(0.100914804776)
        ref[2,0,2]=(-0.471567638444)
        ref[2,1,0]=(-1.42194256762)
        ref[2,1,1]=(-0.348217894465)
        ref[2,1,2]=(-0.830561377367)
        ref[2,2,0]=(1.36876795155)
        ref[2,2,1]=(0.125252389466)
        ref[2,2,2]=(0.00641454191902)
        ref[2,3,0]=(0.135243193372)
        ref[2,3,1]=(-1.04394510102)
        ref[2,3,2]=(0.0223029076973)
        ref[2,4,0]=(-0.969785158394)
        ref[2,4,1]=(-0.48178611106)
        ref[2,4,2]=(-0.0556576599006)
        ref[3,0,0]=(1.39484073703)
        ref[3,0,1]=(-1.0132109886)
        ref[3,0,2]=(0.0205156989927)
        ref[3,1,0]=(-0.92783313898)
        ref[3,1,1]=(-1.27904129731)
        ref[3,1,2]=(-0.817768402689)
        ref[3,2,0]=(1.21718392423)
        ref[3,2,1]=(-0.984091647405)
        ref[3,2,2]=(0.458009888947)
        ref[3,3,0]=(-0.812990754761)
        ref[3,3,1]=(-0.104941245044)
        ref[3,3,2]=(-0.996531826869)
        ref[3,4,0]=(-0.28581988131)
        ref[3,4,1]=(-1.24321114539)
        ref[3,4,2]=(0.408464222517)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onFunctionOnContactOne_fromData_ReducedContinuousFunction_rank3(self):
      """
      tests gradient for rank 3 Data on the FunctionOnContactOne

      assumptions: ReducedContinuousFunction(self.domain) exists
                   self.domain supports gradient on FunctionOnContactOne
      """
      o=1
      dim=self.domain.getDim()
      w_ref=FunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=ReducedContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(6, 2, 2),w)
      ref=Data(0,(6, 2, 2)+(dim,),w_ref)
      if dim==2:
        arg[0,0,0]=(0.39712204981)*x[0]+(-1.36315938849)*x[1]
        arg[0,0,1]=(0.654450268666)*x[0]+(-0.198258834351)*x[1]
        arg[0,1,0]=(0.21357757124)*x[0]+(0.193878132191)*x[1]
        arg[0,1,1]=(0.0762258436603)*x[0]+(-0.33284111684)*x[1]
        arg[1,0,0]=(-0.264232939297)*x[0]+(-0.726336076701)*x[1]
        arg[1,0,1]=(-0.179928817534)*x[0]+(-0.723247805844)*x[1]
        arg[1,1,0]=(0.923289681593)*x[0]+(0.986763135255)*x[1]
        arg[1,1,1]=(0.065387254507)*x[0]+(-0.710965008545)*x[1]
        arg[2,0,0]=(0.759853961917)*x[0]+(0.24486573839)*x[1]
        arg[2,0,1]=(-0.318336679378)*x[0]+(0.39328274922)*x[1]
        arg[2,1,0]=(-1.562818948)*x[0]+(-0.891340974738)*x[1]
        arg[2,1,1]=(0.0508006116584)*x[0]+(1.17654134987)*x[1]
        arg[3,0,0]=(-0.155883472458)*x[0]+(0.248809866836)*x[1]
        arg[3,0,1]=(0.287794710222)*x[0]+(-1.72525392296)*x[1]
        arg[3,1,0]=(0.00665202042795)*x[0]+(-0.0996395796968)*x[1]
        arg[3,1,1]=(-0.19809021298)*x[0]+(0.487549616652)*x[1]
        arg[4,0,0]=(0.764163773078)*x[0]+(-0.898694486894)*x[1]
        arg[4,0,1]=(-0.213042355119)*x[0]+(0.708925705544)*x[1]
        arg[4,1,0]=(1.55505564031)*x[0]+(-0.545746649289)*x[1]
        arg[4,1,1]=(-1.31623592165)*x[0]+(0.948772953354)*x[1]
        arg[5,0,0]=(0.221103671977)*x[0]+(0.866067107464)*x[1]
        arg[5,0,1]=(-0.0979530612779)*x[0]+(-0.371623102578)*x[1]
        arg[5,1,0]=(-0.348963169972)*x[0]+(-0.692055450872)*x[1]
        arg[5,1,1]=(-0.584053243695)*x[0]+(-0.487768032842)*x[1]
        ref[0,0,0,0]=(0.39712204981)
        ref[0,0,0,1]=(-1.36315938849)
        ref[0,0,1,0]=(0.654450268666)
        ref[0,0,1,1]=(-0.198258834351)
        ref[0,1,0,0]=(0.21357757124)
        ref[0,1,0,1]=(0.193878132191)
        ref[0,1,1,0]=(0.0762258436603)
        ref[0,1,1,1]=(-0.33284111684)
        ref[1,0,0,0]=(-0.264232939297)
        ref[1,0,0,1]=(-0.726336076701)
        ref[1,0,1,0]=(-0.179928817534)
        ref[1,0,1,1]=(-0.723247805844)
        ref[1,1,0,0]=(0.923289681593)
        ref[1,1,0,1]=(0.986763135255)
        ref[1,1,1,0]=(0.065387254507)
        ref[1,1,1,1]=(-0.710965008545)
        ref[2,0,0,0]=(0.759853961917)
        ref[2,0,0,1]=(0.24486573839)
        ref[2,0,1,0]=(-0.318336679378)
        ref[2,0,1,1]=(0.39328274922)
        ref[2,1,0,0]=(-1.562818948)
        ref[2,1,0,1]=(-0.891340974738)
        ref[2,1,1,0]=(0.0508006116584)
        ref[2,1,1,1]=(1.17654134987)
        ref[3,0,0,0]=(-0.155883472458)
        ref[3,0,0,1]=(0.248809866836)
        ref[3,0,1,0]=(0.287794710222)
        ref[3,0,1,1]=(-1.72525392296)
        ref[3,1,0,0]=(0.00665202042795)
        ref[3,1,0,1]=(-0.0996395796968)
        ref[3,1,1,0]=(-0.19809021298)
        ref[3,1,1,1]=(0.487549616652)
        ref[4,0,0,0]=(0.764163773078)
        ref[4,0,0,1]=(-0.898694486894)
        ref[4,0,1,0]=(-0.213042355119)
        ref[4,0,1,1]=(0.708925705544)
        ref[4,1,0,0]=(1.55505564031)
        ref[4,1,0,1]=(-0.545746649289)
        ref[4,1,1,0]=(-1.31623592165)
        ref[4,1,1,1]=(0.948772953354)
        ref[5,0,0,0]=(0.221103671977)
        ref[5,0,0,1]=(0.866067107464)
        ref[5,0,1,0]=(-0.0979530612779)
        ref[5,0,1,1]=(-0.371623102578)
        ref[5,1,0,0]=(-0.348963169972)
        ref[5,1,0,1]=(-0.692055450872)
        ref[5,1,1,0]=(-0.584053243695)
        ref[5,1,1,1]=(-0.487768032842)
      else:
        arg[0,0,0]=(-1.45023987007)*x[0]+(0.138479134523)*x[1]+(1.46404607112)*x[2]
        arg[0,0,1]=(-0.647908832568)*x[0]+(-0.503758830859)*x[1]+(1.23196203665)*x[2]
        arg[0,1,0]=(-0.0108286161243)*x[0]+(0.565615928686)*x[1]+(-0.357789821636)*x[2]
        arg[0,1,1]=(0.648224572901)*x[0]+(0.775857442933)*x[1]+(0.960991462312)*x[2]
        arg[1,0,0]=(0.340590670624)*x[0]+(0.0357759349963)*x[1]+(0.358139256621)*x[2]
        arg[1,0,1]=(0.569789735109)*x[0]+(1.40678949618)*x[1]+(-0.965577726422)*x[2]
        arg[1,1,0]=(-0.758717082212)*x[0]+(0.612968081377)*x[1]+(-0.417988159948)*x[2]
        arg[1,1,1]=(0.969867032567)*x[0]+(-0.0700234825891)*x[1]+(1.53879850558)*x[2]
        arg[2,0,0]=(-1.02952648125)*x[0]+(0.108642437375)*x[1]+(0.251073184196)*x[2]
        arg[2,0,1]=(0.794766888909)*x[0]+(1.50591346365)*x[1]+(-0.36870578891)*x[2]
        arg[2,1,0]=(-0.534487055503)*x[0]+(-1.09061679233)*x[1]+(0.799342633685)*x[2]
        arg[2,1,1]=(0.0435889213805)*x[0]+(-0.209888628166)*x[1]+(1.34633215915)*x[2]
        arg[3,0,0]=(-0.0344682106376)*x[0]+(-0.92386569455)*x[1]+(-0.551250384619)*x[2]
        arg[3,0,1]=(-0.168599962689)*x[0]+(0.204634495314)*x[1]+(-0.65426520271)*x[2]
        arg[3,1,0]=(-1.61759210628)*x[0]+(-0.5922211067)*x[1]+(-0.139092780207)*x[2]
        arg[3,1,1]=(-0.13862300062)*x[0]+(-1.45951050222)*x[1]+(0.300904423579)*x[2]
        arg[4,0,0]=(0.629590770742)*x[0]+(-0.217150209985)*x[1]+(-0.140384227583)*x[2]
        arg[4,0,1]=(-0.0461635416119)*x[0]+(0.525692990183)*x[1]+(-1.89728167146)*x[2]
        arg[4,1,0]=(-0.130297059668)*x[0]+(-0.138816250007)*x[1]+(1.26805054232)*x[2]
        arg[4,1,1]=(0.742488751566)*x[0]+(0.659272799907)*x[1]+(-0.370877917078)*x[2]
        arg[5,0,0]=(-0.521350561164)*x[0]+(-0.213669151076)*x[1]+(0.00949381597317)*x[2]
        arg[5,0,1]=(-0.951547526648)*x[0]+(-0.388340895795)*x[1]+(0.741997603334)*x[2]
        arg[5,1,0]=(-0.332922940005)*x[0]+(1.74852940259)*x[1]+(-0.484189519128)*x[2]
        arg[5,1,1]=(0.418660109098)*x[0]+(-0.690728767024)*x[1]+(-0.675947375912)*x[2]
        ref[0,0,0,0]=(-1.45023987007)
        ref[0,0,0,1]=(0.138479134523)
        ref[0,0,0,2]=(1.46404607112)
        ref[0,0,1,0]=(-0.647908832568)
        ref[0,0,1,1]=(-0.503758830859)
        ref[0,0,1,2]=(1.23196203665)
        ref[0,1,0,0]=(-0.0108286161243)
        ref[0,1,0,1]=(0.565615928686)
        ref[0,1,0,2]=(-0.357789821636)
        ref[0,1,1,0]=(0.648224572901)
        ref[0,1,1,1]=(0.775857442933)
        ref[0,1,1,2]=(0.960991462312)
        ref[1,0,0,0]=(0.340590670624)
        ref[1,0,0,1]=(0.0357759349963)
        ref[1,0,0,2]=(0.358139256621)
        ref[1,0,1,0]=(0.569789735109)
        ref[1,0,1,1]=(1.40678949618)
        ref[1,0,1,2]=(-0.965577726422)
        ref[1,1,0,0]=(-0.758717082212)
        ref[1,1,0,1]=(0.612968081377)
        ref[1,1,0,2]=(-0.417988159948)
        ref[1,1,1,0]=(0.969867032567)
        ref[1,1,1,1]=(-0.0700234825891)
        ref[1,1,1,2]=(1.53879850558)
        ref[2,0,0,0]=(-1.02952648125)
        ref[2,0,0,1]=(0.108642437375)
        ref[2,0,0,2]=(0.251073184196)
        ref[2,0,1,0]=(0.794766888909)
        ref[2,0,1,1]=(1.50591346365)
        ref[2,0,1,2]=(-0.36870578891)
        ref[2,1,0,0]=(-0.534487055503)
        ref[2,1,0,1]=(-1.09061679233)
        ref[2,1,0,2]=(0.799342633685)
        ref[2,1,1,0]=(0.0435889213805)
        ref[2,1,1,1]=(-0.209888628166)
        ref[2,1,1,2]=(1.34633215915)
        ref[3,0,0,0]=(-0.0344682106376)
        ref[3,0,0,1]=(-0.92386569455)
        ref[3,0,0,2]=(-0.551250384619)
        ref[3,0,1,0]=(-0.168599962689)
        ref[3,0,1,1]=(0.204634495314)
        ref[3,0,1,2]=(-0.65426520271)
        ref[3,1,0,0]=(-1.61759210628)
        ref[3,1,0,1]=(-0.5922211067)
        ref[3,1,0,2]=(-0.139092780207)
        ref[3,1,1,0]=(-0.13862300062)
        ref[3,1,1,1]=(-1.45951050222)
        ref[3,1,1,2]=(0.300904423579)
        ref[4,0,0,0]=(0.629590770742)
        ref[4,0,0,1]=(-0.217150209985)
        ref[4,0,0,2]=(-0.140384227583)
        ref[4,0,1,0]=(-0.0461635416119)
        ref[4,0,1,1]=(0.525692990183)
        ref[4,0,1,2]=(-1.89728167146)
        ref[4,1,0,0]=(-0.130297059668)
        ref[4,1,0,1]=(-0.138816250007)
        ref[4,1,0,2]=(1.26805054232)
        ref[4,1,1,0]=(0.742488751566)
        ref[4,1,1,1]=(0.659272799907)
        ref[4,1,1,2]=(-0.370877917078)
        ref[5,0,0,0]=(-0.521350561164)
        ref[5,0,0,1]=(-0.213669151076)
        ref[5,0,0,2]=(0.00949381597317)
        ref[5,0,1,0]=(-0.951547526648)
        ref[5,0,1,1]=(-0.388340895795)
        ref[5,0,1,2]=(0.741997603334)
        ref[5,1,0,0]=(-0.332922940005)
        ref[5,1,0,1]=(1.74852940259)
        ref[5,1,0,2]=(-0.484189519128)
        ref[5,1,1,0]=(0.418660109098)
        ref[5,1,1,1]=(-0.690728767024)
        ref[5,1,1,2]=(-0.675947375912)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnContactOne_fromData_ContinuousFunction_rank0(self):
      """
      tests gradient for rank 0 Data on the ReducedFunctionOnContactOne

      assumptions: ContinuousFunction(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnContactOne
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=ContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(),w)
      ref=Data(0,()+(dim,),w_ref)
      if dim==2:
        arg=(-0.169375355906)*x[0]**o+(0.270029734958)*x[0]+(-0.19196016538)*x[1]**o+(0.426264369437)*x[1]
        ref[0]=o*(-0.169375355906)*x_ref[0]**(o-1)+(0.270029734958)
        ref[1]=o*(-0.19196016538)*x_ref[1]**(o-1)+(0.426264369437)
      else:
        arg=(0.00913595455019)*x[0]**o+(-0.561918629059)*x[0]+(0.0164102679759)*x[1]**o+(0.20749162111)*x[1]+(0.588703418401)*x[2]**o+(0.841289333498)*x[2]
        ref[0]=o*(0.00913595455019)*x_ref[0]**(o-1)+(-0.561918629059)
        ref[1]=o*(0.0164102679759)*x_ref[1]**(o-1)+(0.20749162111)
        ref[2]=o*(0.588703418401)*x_ref[2]**(o-1)+(0.841289333498)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),()+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnContactOne_fromData_ContinuousFunction_rank1(self):
      """
      tests gradient for rank 1 Data on the ReducedFunctionOnContactOne

      assumptions: ContinuousFunction(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnContactOne
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=ContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(2,),w)
      ref=Data(0,(2,)+(dim,),w_ref)
      if dim==2:
        arg[0]=(-0.290031175706)*x[0]**o+(0.690121137589)*x[0]+(0.916232953272)*x[1]**o+(0.427227803135)*x[1]
        arg[1]=(0.0325792679154)*x[0]**o+(0.773157737135)*x[0]+(-0.0443953478357)*x[1]**o+(0.772028975294)*x[1]
        ref[0,0]=o*(-0.290031175706)*x_ref[0]**(o-1)+(0.690121137589)
        ref[0,1]=o*(0.916232953272)*x_ref[1]**(o-1)+(0.427227803135)
        ref[1,0]=o*(0.0325792679154)*x_ref[0]**(o-1)+(0.773157737135)
        ref[1,1]=o*(-0.0443953478357)*x_ref[1]**(o-1)+(0.772028975294)
      else:
        arg[0]=(-0.119338345858)*x[0]**o+(-0.866134437839)*x[0]+(-0.727685742079)*x[1]**o+(0.465666609669)*x[1]+(-0.351266733199)*x[2]**o+(-0.960631632698)*x[2]
        arg[1]=(-0.731037524737)*x[0]**o+(0.415975622707)*x[0]+(-0.86639696362)*x[1]**o+(0.914277406921)*x[1]+(0.627502485514)*x[2]**o+(-0.855013681276)*x[2]
        ref[0,0]=o*(-0.119338345858)*x_ref[0]**(o-1)+(-0.866134437839)
        ref[0,1]=o*(-0.727685742079)*x_ref[1]**(o-1)+(0.465666609669)
        ref[0,2]=o*(-0.351266733199)*x_ref[2]**(o-1)+(-0.960631632698)
        ref[1,0]=o*(-0.731037524737)*x_ref[0]**(o-1)+(0.415975622707)
        ref[1,1]=o*(-0.86639696362)*x_ref[1]**(o-1)+(0.914277406921)
        ref[1,2]=o*(0.627502485514)*x_ref[2]**(o-1)+(-0.855013681276)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnContactOne_fromData_ContinuousFunction_rank2(self):
      """
      tests gradient for rank 2 Data on the ReducedFunctionOnContactOne

      assumptions: ContinuousFunction(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnContactOne
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=ContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(4, 5),w)
      ref=Data(0,(4, 5)+(dim,),w_ref)
      if dim==2:
        arg[0,0]=(0.148320408183)*x[0]**o+(-0.340902870434)*x[0]+(-0.0856445410272)*x[1]**o+(0.220499304831)*x[1]
        arg[0,1]=(0.915892845602)*x[0]**o+(-0.04770770327)*x[0]+(0.482403170451)*x[1]**o+(-0.639478756575)*x[1]
        arg[0,2]=(-0.109204159071)*x[0]**o+(0.641607024805)*x[0]+(-0.409310547283)*x[1]**o+(0.202984386731)*x[1]
        arg[0,3]=(0.436833770493)*x[0]**o+(-0.200611791892)*x[0]+(-0.74814554517)*x[1]**o+(0.571881526754)*x[1]
        arg[0,4]=(0.704812299415)*x[0]**o+(0.688151134045)*x[0]+(0.486135712907)*x[1]**o+(0.955314240096)*x[1]
        arg[1,0]=(-0.731790373321)*x[0]**o+(-0.711258122556)*x[0]+(-0.961514666684)*x[1]**o+(0.726573978492)*x[1]
        arg[1,1]=(0.975372389889)*x[0]**o+(0.5026238435)*x[0]+(0.948955767945)*x[1]**o+(-0.780842035663)*x[1]
        arg[1,2]=(0.742383399984)*x[0]**o+(-0.729678661652)*x[0]+(-0.815499612514)*x[1]**o+(-0.12280674993)*x[1]
        arg[1,3]=(0.323809901662)*x[0]**o+(-0.441906205977)*x[0]+(-0.308989501913)*x[1]**o+(-0.549353671447)*x[1]
        arg[1,4]=(0.711285710752)*x[0]**o+(0.297823778866)*x[0]+(0.645185023747)*x[1]**o+(0.825620074525)*x[1]
        arg[2,0]=(-0.373175217644)*x[0]**o+(-0.25651286112)*x[0]+(-0.46193047583)*x[1]**o+(-0.359820938943)*x[1]
        arg[2,1]=(-0.406101756283)*x[0]**o+(-0.38896428223)*x[0]+(-0.993257693721)*x[1]**o+(-0.910326366305)*x[1]
        arg[2,2]=(0.517566718504)*x[0]**o+(-0.582940900248)*x[0]+(-0.381600156082)*x[1]**o+(0.466575604699)*x[1]
        arg[2,3]=(0.323944380062)*x[0]**o+(-0.99359065412)*x[0]+(0.069389014076)*x[1]**o+(0.960192708612)*x[1]
        arg[2,4]=(-0.741362989132)*x[0]**o+(0.978137520347)*x[0]+(-0.398259900603)*x[1]**o+(-0.224949732925)*x[1]
        arg[3,0]=(-0.540235240193)*x[0]**o+(0.761488584116)*x[0]+(-0.100229643779)*x[1]**o+(-0.168724555964)*x[1]
        arg[3,1]=(0.565068220879)*x[0]**o+(-0.778936552173)*x[0]+(-0.933478028833)*x[1]**o+(-0.274446893155)*x[1]
        arg[3,2]=(-0.198878845493)*x[0]**o+(0.97185846381)*x[0]+(0.0345948289236)*x[1]**o+(0.359375885935)*x[1]
        arg[3,3]=(-0.815426880937)*x[0]**o+(-0.0734806259357)*x[0]+(-0.0452925239934)*x[1]**o+(0.976167480949)*x[1]
        arg[3,4]=(0.374670688698)*x[0]**o+(-0.427666745858)*x[0]+(-0.631640994091)*x[1]**o+(-0.312455066404)*x[1]
        ref[0,0,0]=o*(0.148320408183)*x_ref[0]**(o-1)+(-0.340902870434)
        ref[0,0,1]=o*(-0.0856445410272)*x_ref[1]**(o-1)+(0.220499304831)
        ref[0,1,0]=o*(0.915892845602)*x_ref[0]**(o-1)+(-0.04770770327)
        ref[0,1,1]=o*(0.482403170451)*x_ref[1]**(o-1)+(-0.639478756575)
        ref[0,2,0]=o*(-0.109204159071)*x_ref[0]**(o-1)+(0.641607024805)
        ref[0,2,1]=o*(-0.409310547283)*x_ref[1]**(o-1)+(0.202984386731)
        ref[0,3,0]=o*(0.436833770493)*x_ref[0]**(o-1)+(-0.200611791892)
        ref[0,3,1]=o*(-0.74814554517)*x_ref[1]**(o-1)+(0.571881526754)
        ref[0,4,0]=o*(0.704812299415)*x_ref[0]**(o-1)+(0.688151134045)
        ref[0,4,1]=o*(0.486135712907)*x_ref[1]**(o-1)+(0.955314240096)
        ref[1,0,0]=o*(-0.731790373321)*x_ref[0]**(o-1)+(-0.711258122556)
        ref[1,0,1]=o*(-0.961514666684)*x_ref[1]**(o-1)+(0.726573978492)
        ref[1,1,0]=o*(0.975372389889)*x_ref[0]**(o-1)+(0.5026238435)
        ref[1,1,1]=o*(0.948955767945)*x_ref[1]**(o-1)+(-0.780842035663)
        ref[1,2,0]=o*(0.742383399984)*x_ref[0]**(o-1)+(-0.729678661652)
        ref[1,2,1]=o*(-0.815499612514)*x_ref[1]**(o-1)+(-0.12280674993)
        ref[1,3,0]=o*(0.323809901662)*x_ref[0]**(o-1)+(-0.441906205977)
        ref[1,3,1]=o*(-0.308989501913)*x_ref[1]**(o-1)+(-0.549353671447)
        ref[1,4,0]=o*(0.711285710752)*x_ref[0]**(o-1)+(0.297823778866)
        ref[1,4,1]=o*(0.645185023747)*x_ref[1]**(o-1)+(0.825620074525)
        ref[2,0,0]=o*(-0.373175217644)*x_ref[0]**(o-1)+(-0.25651286112)
        ref[2,0,1]=o*(-0.46193047583)*x_ref[1]**(o-1)+(-0.359820938943)
        ref[2,1,0]=o*(-0.406101756283)*x_ref[0]**(o-1)+(-0.38896428223)
        ref[2,1,1]=o*(-0.993257693721)*x_ref[1]**(o-1)+(-0.910326366305)
        ref[2,2,0]=o*(0.517566718504)*x_ref[0]**(o-1)+(-0.582940900248)
        ref[2,2,1]=o*(-0.381600156082)*x_ref[1]**(o-1)+(0.466575604699)
        ref[2,3,0]=o*(0.323944380062)*x_ref[0]**(o-1)+(-0.99359065412)
        ref[2,3,1]=o*(0.069389014076)*x_ref[1]**(o-1)+(0.960192708612)
        ref[2,4,0]=o*(-0.741362989132)*x_ref[0]**(o-1)+(0.978137520347)
        ref[2,4,1]=o*(-0.398259900603)*x_ref[1]**(o-1)+(-0.224949732925)
        ref[3,0,0]=o*(-0.540235240193)*x_ref[0]**(o-1)+(0.761488584116)
        ref[3,0,1]=o*(-0.100229643779)*x_ref[1]**(o-1)+(-0.168724555964)
        ref[3,1,0]=o*(0.565068220879)*x_ref[0]**(o-1)+(-0.778936552173)
        ref[3,1,1]=o*(-0.933478028833)*x_ref[1]**(o-1)+(-0.274446893155)
        ref[3,2,0]=o*(-0.198878845493)*x_ref[0]**(o-1)+(0.97185846381)
        ref[3,2,1]=o*(0.0345948289236)*x_ref[1]**(o-1)+(0.359375885935)
        ref[3,3,0]=o*(-0.815426880937)*x_ref[0]**(o-1)+(-0.0734806259357)
        ref[3,3,1]=o*(-0.0452925239934)*x_ref[1]**(o-1)+(0.976167480949)
        ref[3,4,0]=o*(0.374670688698)*x_ref[0]**(o-1)+(-0.427666745858)
        ref[3,4,1]=o*(-0.631640994091)*x_ref[1]**(o-1)+(-0.312455066404)
      else:
        arg[0,0]=(0.284398400678)*x[0]**o+(0.219396164435)*x[0]+(0.220563761332)*x[1]**o+(0.167554964517)*x[1]+(0.234139558431)*x[2]**o+(-0.462262273341)*x[2]
        arg[0,1]=(0.161107248226)*x[0]**o+(0.23981806792)*x[0]+(-0.365265066245)*x[1]**o+(0.280522162689)*x[1]+(0.0813974911438)*x[2]**o+(-0.43305486384)*x[2]
        arg[0,2]=(0.813480874845)*x[0]**o+(0.600760069636)*x[0]+(-0.133815038485)*x[1]**o+(-0.954192097752)*x[1]+(-0.60756978514)*x[2]**o+(0.669710363926)*x[2]
        arg[0,3]=(-0.760542897936)*x[0]**o+(0.869702837484)*x[0]+(0.568626088907)*x[1]**o+(0.272054244422)*x[1]+(-0.0415999983147)*x[2]**o+(0.446199878551)*x[2]
        arg[0,4]=(0.0453200557409)*x[0]**o+(0.990444244175)*x[0]+(0.134265180195)*x[1]**o+(0.156166931353)*x[1]+(-0.787964274948)*x[2]**o+(0.0116920503615)*x[2]
        arg[1,0]=(-0.826245054647)*x[0]**o+(0.203727421041)*x[0]+(0.435254937068)*x[1]**o+(-0.271957510058)*x[1]+(0.24056400787)*x[2]**o+(-0.270322614397)*x[2]
        arg[1,1]=(-0.423339337474)*x[0]**o+(0.272439137387)*x[0]+(-0.0736213619539)*x[1]**o+(-0.776123259153)*x[1]+(-0.751736227059)*x[2]**o+(0.944253810697)*x[2]
        arg[1,2]=(0.189348519506)*x[0]**o+(-0.599085006375)*x[0]+(0.511802349511)*x[1]**o+(-0.309756999526)*x[1]+(-0.753093308971)*x[2]**o+(-0.109878524762)*x[2]
        arg[1,3]=(0.273889782311)*x[0]**o+(0.284416273071)*x[0]+(-0.793016836976)*x[1]**o+(0.584657111427)*x[1]+(0.202246448215)*x[2]**o+(0.669336280646)*x[2]
        arg[1,4]=(-0.310062687494)*x[0]**o+(-0.0558492819571)*x[0]+(0.661043054703)*x[1]**o+(0.708531199864)*x[1]+(0.0490202348501)*x[2]**o+(0.732983691308)*x[2]
        arg[2,0]=(0.967228638923)*x[0]**o+(-0.816725187456)*x[0]+(0.836005904943)*x[1]**o+(-0.618363868727)*x[1]+(-0.977101150283)*x[2]**o+(-0.960030792428)*x[2]
        arg[2,1]=(0.536503091036)*x[0]**o+(-0.786194077149)*x[0]+(-0.337609174718)*x[1]**o+(0.787326702105)*x[1]+(0.989900210061)*x[2]**o+(0.67077581859)*x[2]
        arg[2,2]=(-0.732242113661)*x[0]**o+(-0.565641876648)*x[0]+(0.175986347852)*x[1]**o+(0.862449074966)*x[1]+(0.0257656069443)*x[2]**o+(0.824927753427)*x[2]
        arg[2,3]=(-0.863272499797)*x[0]**o+(-0.817781186551)*x[0]+(0.168931269996)*x[1]**o+(-0.530060186715)*x[1]+(-0.516801368376)*x[2]**o+(-0.570137941882)*x[2]
        arg[2,4]=(-0.675287850319)*x[0]**o+(-0.672701614891)*x[0]+(-0.19851266374)*x[1]**o+(-0.0494587000627)*x[1]+(0.518006592112)*x[2]**o+(0.0337938303974)*x[2]
        arg[3,0]=(-0.175683006965)*x[0]**o+(-0.843980579113)*x[0]+(0.903358518604)*x[1]**o+(0.962156465407)*x[1]+(-0.0887392353523)*x[2]**o+(0.524587238729)*x[2]
        arg[3,1]=(0.0622433182846)*x[0]**o+(-0.756701969275)*x[0]+(0.721836266349)*x[1]**o+(0.457673032865)*x[1]+(0.704951904865)*x[2]**o+(0.781015828813)*x[2]
        arg[3,2]=(-0.457057269128)*x[0]**o+(-0.880403805028)*x[0]+(0.103553852578)*x[1]**o+(-0.807061998574)*x[1]+(-0.0352722677587)*x[2]**o+(0.0527948564177)*x[2]
        arg[3,3]=(0.161459807817)*x[0]**o+(0.698509459014)*x[0]+(-0.596487730094)*x[1]**o+(-0.906646770174)*x[1]+(0.567036380682)*x[2]**o+(0.490123167386)*x[2]
        arg[3,4]=(-0.668686195082)*x[0]**o+(0.911485638627)*x[0]+(-0.856948411336)*x[1]**o+(0.0348927535379)*x[1]+(0.17649505057)*x[2]**o+(-0.778920185271)*x[2]
        ref[0,0,0]=o*(0.284398400678)*x_ref[0]**(o-1)+(0.219396164435)
        ref[0,0,1]=o*(0.220563761332)*x_ref[1]**(o-1)+(0.167554964517)
        ref[0,0,2]=o*(0.234139558431)*x_ref[2]**(o-1)+(-0.462262273341)
        ref[0,1,0]=o*(0.161107248226)*x_ref[0]**(o-1)+(0.23981806792)
        ref[0,1,1]=o*(-0.365265066245)*x_ref[1]**(o-1)+(0.280522162689)
        ref[0,1,2]=o*(0.0813974911438)*x_ref[2]**(o-1)+(-0.43305486384)
        ref[0,2,0]=o*(0.813480874845)*x_ref[0]**(o-1)+(0.600760069636)
        ref[0,2,1]=o*(-0.133815038485)*x_ref[1]**(o-1)+(-0.954192097752)
        ref[0,2,2]=o*(-0.60756978514)*x_ref[2]**(o-1)+(0.669710363926)
        ref[0,3,0]=o*(-0.760542897936)*x_ref[0]**(o-1)+(0.869702837484)
        ref[0,3,1]=o*(0.568626088907)*x_ref[1]**(o-1)+(0.272054244422)
        ref[0,3,2]=o*(-0.0415999983147)*x_ref[2]**(o-1)+(0.446199878551)
        ref[0,4,0]=o*(0.0453200557409)*x_ref[0]**(o-1)+(0.990444244175)
        ref[0,4,1]=o*(0.134265180195)*x_ref[1]**(o-1)+(0.156166931353)
        ref[0,4,2]=o*(-0.787964274948)*x_ref[2]**(o-1)+(0.0116920503615)
        ref[1,0,0]=o*(-0.826245054647)*x_ref[0]**(o-1)+(0.203727421041)
        ref[1,0,1]=o*(0.435254937068)*x_ref[1]**(o-1)+(-0.271957510058)
        ref[1,0,2]=o*(0.24056400787)*x_ref[2]**(o-1)+(-0.270322614397)
        ref[1,1,0]=o*(-0.423339337474)*x_ref[0]**(o-1)+(0.272439137387)
        ref[1,1,1]=o*(-0.0736213619539)*x_ref[1]**(o-1)+(-0.776123259153)
        ref[1,1,2]=o*(-0.751736227059)*x_ref[2]**(o-1)+(0.944253810697)
        ref[1,2,0]=o*(0.189348519506)*x_ref[0]**(o-1)+(-0.599085006375)
        ref[1,2,1]=o*(0.511802349511)*x_ref[1]**(o-1)+(-0.309756999526)
        ref[1,2,2]=o*(-0.753093308971)*x_ref[2]**(o-1)+(-0.109878524762)
        ref[1,3,0]=o*(0.273889782311)*x_ref[0]**(o-1)+(0.284416273071)
        ref[1,3,1]=o*(-0.793016836976)*x_ref[1]**(o-1)+(0.584657111427)
        ref[1,3,2]=o*(0.202246448215)*x_ref[2]**(o-1)+(0.669336280646)
        ref[1,4,0]=o*(-0.310062687494)*x_ref[0]**(o-1)+(-0.0558492819571)
        ref[1,4,1]=o*(0.661043054703)*x_ref[1]**(o-1)+(0.708531199864)
        ref[1,4,2]=o*(0.0490202348501)*x_ref[2]**(o-1)+(0.732983691308)
        ref[2,0,0]=o*(0.967228638923)*x_ref[0]**(o-1)+(-0.816725187456)
        ref[2,0,1]=o*(0.836005904943)*x_ref[1]**(o-1)+(-0.618363868727)
        ref[2,0,2]=o*(-0.977101150283)*x_ref[2]**(o-1)+(-0.960030792428)
        ref[2,1,0]=o*(0.536503091036)*x_ref[0]**(o-1)+(-0.786194077149)
        ref[2,1,1]=o*(-0.337609174718)*x_ref[1]**(o-1)+(0.787326702105)
        ref[2,1,2]=o*(0.989900210061)*x_ref[2]**(o-1)+(0.67077581859)
        ref[2,2,0]=o*(-0.732242113661)*x_ref[0]**(o-1)+(-0.565641876648)
        ref[2,2,1]=o*(0.175986347852)*x_ref[1]**(o-1)+(0.862449074966)
        ref[2,2,2]=o*(0.0257656069443)*x_ref[2]**(o-1)+(0.824927753427)
        ref[2,3,0]=o*(-0.863272499797)*x_ref[0]**(o-1)+(-0.817781186551)
        ref[2,3,1]=o*(0.168931269996)*x_ref[1]**(o-1)+(-0.530060186715)
        ref[2,3,2]=o*(-0.516801368376)*x_ref[2]**(o-1)+(-0.570137941882)
        ref[2,4,0]=o*(-0.675287850319)*x_ref[0]**(o-1)+(-0.672701614891)
        ref[2,4,1]=o*(-0.19851266374)*x_ref[1]**(o-1)+(-0.0494587000627)
        ref[2,4,2]=o*(0.518006592112)*x_ref[2]**(o-1)+(0.0337938303974)
        ref[3,0,0]=o*(-0.175683006965)*x_ref[0]**(o-1)+(-0.843980579113)
        ref[3,0,1]=o*(0.903358518604)*x_ref[1]**(o-1)+(0.962156465407)
        ref[3,0,2]=o*(-0.0887392353523)*x_ref[2]**(o-1)+(0.524587238729)
        ref[3,1,0]=o*(0.0622433182846)*x_ref[0]**(o-1)+(-0.756701969275)
        ref[3,1,1]=o*(0.721836266349)*x_ref[1]**(o-1)+(0.457673032865)
        ref[3,1,2]=o*(0.704951904865)*x_ref[2]**(o-1)+(0.781015828813)
        ref[3,2,0]=o*(-0.457057269128)*x_ref[0]**(o-1)+(-0.880403805028)
        ref[3,2,1]=o*(0.103553852578)*x_ref[1]**(o-1)+(-0.807061998574)
        ref[3,2,2]=o*(-0.0352722677587)*x_ref[2]**(o-1)+(0.0527948564177)
        ref[3,3,0]=o*(0.161459807817)*x_ref[0]**(o-1)+(0.698509459014)
        ref[3,3,1]=o*(-0.596487730094)*x_ref[1]**(o-1)+(-0.906646770174)
        ref[3,3,2]=o*(0.567036380682)*x_ref[2]**(o-1)+(0.490123167386)
        ref[3,4,0]=o*(-0.668686195082)*x_ref[0]**(o-1)+(0.911485638627)
        ref[3,4,1]=o*(-0.856948411336)*x_ref[1]**(o-1)+(0.0348927535379)
        ref[3,4,2]=o*(0.17649505057)*x_ref[2]**(o-1)+(-0.778920185271)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnContactOne_fromData_ContinuousFunction_rank3(self):
      """
      tests gradient for rank 3 Data on the ReducedFunctionOnContactOne

      assumptions: ContinuousFunction(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnContactOne
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=ContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(6, 2, 2),w)
      ref=Data(0,(6, 2, 2)+(dim,),w_ref)
      if dim==2:
        arg[0,0,0]=(0.366719126165)*x[0]**o+(0.273305723392)*x[0]+(0.508134048679)*x[1]**o+(-0.0895788966541)*x[1]
        arg[0,0,1]=(-0.911986850385)*x[0]**o+(-0.98503317507)*x[0]+(-0.310897248279)*x[1]**o+(0.015206007134)*x[1]
        arg[0,1,0]=(-0.0827324676842)*x[0]**o+(0.566620026269)*x[0]+(-0.0581063189367)*x[1]**o+(0.379530936223)*x[1]
        arg[0,1,1]=(0.223247684076)*x[0]**o+(0.511247996036)*x[0]+(-0.904638808138)*x[1]**o+(-0.253982863496)*x[1]
        arg[1,0,0]=(-0.117040630362)*x[0]**o+(0.720200175398)*x[0]+(0.316014562047)*x[1]**o+(-0.88437304478)*x[1]
        arg[1,0,1]=(0.521261471788)*x[0]**o+(0.866618380963)*x[0]+(0.376866254345)*x[1]**o+(0.0905522236713)*x[1]
        arg[1,1,0]=(-0.0907011175214)*x[0]**o+(0.925809501719)*x[0]+(0.29066676347)*x[1]**o+(-0.77392365917)*x[1]
        arg[1,1,1]=(0.410922874646)*x[0]**o+(-0.801953959211)*x[0]+(-0.911104174539)*x[1]**o+(-0.640661859542)*x[1]
        arg[2,0,0]=(-0.449471274267)*x[0]**o+(0.8111872512)*x[0]+(0.0498814189394)*x[1]**o+(0.683703882124)*x[1]
        arg[2,0,1]=(-0.192396495147)*x[0]**o+(0.893457442524)*x[0]+(-0.946936565887)*x[1]**o+(-0.0290255758634)*x[1]
        arg[2,1,0]=(0.90847535637)*x[0]**o+(-0.517929281823)*x[0]+(0.389994692606)*x[1]**o+(-0.601708219886)*x[1]
        arg[2,1,1]=(0.401910281699)*x[0]**o+(0.485033224067)*x[0]+(-0.362139392478)*x[1]**o+(-0.740542640224)*x[1]
        arg[3,0,0]=(0.195815356554)*x[0]**o+(-0.584270182199)*x[0]+(-0.773247762709)*x[1]**o+(0.974109226972)*x[1]
        arg[3,0,1]=(0.516821334505)*x[0]**o+(-0.667535261235)*x[0]+(-0.687554420634)*x[1]**o+(-0.826211449593)*x[1]
        arg[3,1,0]=(-0.886684033283)*x[0]**o+(0.833394822235)*x[0]+(-0.509561014765)*x[1]**o+(-0.934990250803)*x[1]
        arg[3,1,1]=(-0.279505984235)*x[0]**o+(0.629210321924)*x[0]+(-0.245033518843)*x[1]**o+(0.148437993524)*x[1]
        arg[4,0,0]=(-0.120914130766)*x[0]**o+(-0.70386339291)*x[0]+(-0.37739143589)*x[1]**o+(-0.604979315802)*x[1]
        arg[4,0,1]=(-0.259492475213)*x[0]**o+(0.628922768093)*x[0]+(-0.973387886178)*x[1]**o+(0.285217747252)*x[1]
        arg[4,1,0]=(-0.986163107858)*x[0]**o+(-0.85082996164)*x[0]+(-0.560402256475)*x[1]**o+(-0.468278543242)*x[1]
        arg[4,1,1]=(0.370258762453)*x[0]**o+(0.870396552858)*x[0]+(0.57205142923)*x[1]**o+(0.332787259857)*x[1]
        arg[5,0,0]=(-0.570453853889)*x[0]**o+(0.253977538115)*x[0]+(0.628545140288)*x[1]**o+(-0.766550576107)*x[1]
        arg[5,0,1]=(-0.626776709555)*x[0]**o+(0.593526092433)*x[0]+(0.824052315861)*x[1]**o+(-0.409883522469)*x[1]
        arg[5,1,0]=(0.285256467088)*x[0]**o+(-0.808675657802)*x[0]+(-0.818251043807)*x[1]**o+(0.378756627769)*x[1]
        arg[5,1,1]=(-0.810805592247)*x[0]**o+(-0.879886206051)*x[0]+(0.378171206533)*x[1]**o+(0.478469089448)*x[1]
        ref[0,0,0,0]=o*(0.366719126165)*x_ref[0]**(o-1)+(0.273305723392)
        ref[0,0,0,1]=o*(0.508134048679)*x_ref[1]**(o-1)+(-0.0895788966541)
        ref[0,0,1,0]=o*(-0.911986850385)*x_ref[0]**(o-1)+(-0.98503317507)
        ref[0,0,1,1]=o*(-0.310897248279)*x_ref[1]**(o-1)+(0.015206007134)
        ref[0,1,0,0]=o*(-0.0827324676842)*x_ref[0]**(o-1)+(0.566620026269)
        ref[0,1,0,1]=o*(-0.0581063189367)*x_ref[1]**(o-1)+(0.379530936223)
        ref[0,1,1,0]=o*(0.223247684076)*x_ref[0]**(o-1)+(0.511247996036)
        ref[0,1,1,1]=o*(-0.904638808138)*x_ref[1]**(o-1)+(-0.253982863496)
        ref[1,0,0,0]=o*(-0.117040630362)*x_ref[0]**(o-1)+(0.720200175398)
        ref[1,0,0,1]=o*(0.316014562047)*x_ref[1]**(o-1)+(-0.88437304478)
        ref[1,0,1,0]=o*(0.521261471788)*x_ref[0]**(o-1)+(0.866618380963)
        ref[1,0,1,1]=o*(0.376866254345)*x_ref[1]**(o-1)+(0.0905522236713)
        ref[1,1,0,0]=o*(-0.0907011175214)*x_ref[0]**(o-1)+(0.925809501719)
        ref[1,1,0,1]=o*(0.29066676347)*x_ref[1]**(o-1)+(-0.77392365917)
        ref[1,1,1,0]=o*(0.410922874646)*x_ref[0]**(o-1)+(-0.801953959211)
        ref[1,1,1,1]=o*(-0.911104174539)*x_ref[1]**(o-1)+(-0.640661859542)
        ref[2,0,0,0]=o*(-0.449471274267)*x_ref[0]**(o-1)+(0.8111872512)
        ref[2,0,0,1]=o*(0.0498814189394)*x_ref[1]**(o-1)+(0.683703882124)
        ref[2,0,1,0]=o*(-0.192396495147)*x_ref[0]**(o-1)+(0.893457442524)
        ref[2,0,1,1]=o*(-0.946936565887)*x_ref[1]**(o-1)+(-0.0290255758634)
        ref[2,1,0,0]=o*(0.90847535637)*x_ref[0]**(o-1)+(-0.517929281823)
        ref[2,1,0,1]=o*(0.389994692606)*x_ref[1]**(o-1)+(-0.601708219886)
        ref[2,1,1,0]=o*(0.401910281699)*x_ref[0]**(o-1)+(0.485033224067)
        ref[2,1,1,1]=o*(-0.362139392478)*x_ref[1]**(o-1)+(-0.740542640224)
        ref[3,0,0,0]=o*(0.195815356554)*x_ref[0]**(o-1)+(-0.584270182199)
        ref[3,0,0,1]=o*(-0.773247762709)*x_ref[1]**(o-1)+(0.974109226972)
        ref[3,0,1,0]=o*(0.516821334505)*x_ref[0]**(o-1)+(-0.667535261235)
        ref[3,0,1,1]=o*(-0.687554420634)*x_ref[1]**(o-1)+(-0.826211449593)
        ref[3,1,0,0]=o*(-0.886684033283)*x_ref[0]**(o-1)+(0.833394822235)
        ref[3,1,0,1]=o*(-0.509561014765)*x_ref[1]**(o-1)+(-0.934990250803)
        ref[3,1,1,0]=o*(-0.279505984235)*x_ref[0]**(o-1)+(0.629210321924)
        ref[3,1,1,1]=o*(-0.245033518843)*x_ref[1]**(o-1)+(0.148437993524)
        ref[4,0,0,0]=o*(-0.120914130766)*x_ref[0]**(o-1)+(-0.70386339291)
        ref[4,0,0,1]=o*(-0.37739143589)*x_ref[1]**(o-1)+(-0.604979315802)
        ref[4,0,1,0]=o*(-0.259492475213)*x_ref[0]**(o-1)+(0.628922768093)
        ref[4,0,1,1]=o*(-0.973387886178)*x_ref[1]**(o-1)+(0.285217747252)
        ref[4,1,0,0]=o*(-0.986163107858)*x_ref[0]**(o-1)+(-0.85082996164)
        ref[4,1,0,1]=o*(-0.560402256475)*x_ref[1]**(o-1)+(-0.468278543242)
        ref[4,1,1,0]=o*(0.370258762453)*x_ref[0]**(o-1)+(0.870396552858)
        ref[4,1,1,1]=o*(0.57205142923)*x_ref[1]**(o-1)+(0.332787259857)
        ref[5,0,0,0]=o*(-0.570453853889)*x_ref[0]**(o-1)+(0.253977538115)
        ref[5,0,0,1]=o*(0.628545140288)*x_ref[1]**(o-1)+(-0.766550576107)
        ref[5,0,1,0]=o*(-0.626776709555)*x_ref[0]**(o-1)+(0.593526092433)
        ref[5,0,1,1]=o*(0.824052315861)*x_ref[1]**(o-1)+(-0.409883522469)
        ref[5,1,0,0]=o*(0.285256467088)*x_ref[0]**(o-1)+(-0.808675657802)
        ref[5,1,0,1]=o*(-0.818251043807)*x_ref[1]**(o-1)+(0.378756627769)
        ref[5,1,1,0]=o*(-0.810805592247)*x_ref[0]**(o-1)+(-0.879886206051)
        ref[5,1,1,1]=o*(0.378171206533)*x_ref[1]**(o-1)+(0.478469089448)
      else:
        arg[0,0,0]=(0.99032561737)*x[0]**o+(0.0664709329455)*x[0]+(0.118470702946)*x[1]**o+(0.339805181064)*x[1]+(-0.288819936068)*x[2]**o+(0.500626113335)*x[2]
        arg[0,0,1]=(-0.736833023385)*x[0]**o+(-0.160433791202)*x[0]+(-0.159295012314)*x[1]**o+(-0.0515197665154)*x[1]+(-0.199553046759)*x[2]**o+(0.912767397035)*x[2]
        arg[0,1,0]=(0.263643352646)*x[0]**o+(-0.408521561602)*x[0]+(-0.690441644678)*x[1]**o+(0.514925086967)*x[1]+(-0.321785011214)*x[2]**o+(-0.192767636106)*x[2]
        arg[0,1,1]=(-0.00679573309711)*x[0]**o+(-0.0919830030966)*x[0]+(0.0194635540782)*x[1]**o+(0.0364274479874)*x[1]+(0.324767149157)*x[2]**o+(-0.930770951272)*x[2]
        arg[1,0,0]=(0.129524159454)*x[0]**o+(-0.747948168258)*x[0]+(0.748091879992)*x[1]**o+(0.0701365933978)*x[1]+(-0.227595193537)*x[2]**o+(-0.515988222581)*x[2]
        arg[1,0,1]=(-0.369843455974)*x[0]**o+(0.902965907161)*x[0]+(0.841050267135)*x[1]**o+(0.985297243316)*x[1]+(-0.96057678523)*x[2]**o+(0.149329555515)*x[2]
        arg[1,1,0]=(-0.530918169849)*x[0]**o+(0.574734874263)*x[0]+(-0.56424658789)*x[1]**o+(-0.756154171146)*x[1]+(-0.181750429769)*x[2]**o+(-0.270972276027)*x[2]
        arg[1,1,1]=(0.18184543511)*x[0]**o+(0.810253164883)*x[0]+(-0.0289547932926)*x[1]**o+(0.690366471619)*x[1]+(0.862616271239)*x[2]**o+(0.157705360996)*x[2]
        arg[2,0,0]=(-0.732811475459)*x[0]**o+(-0.720788617286)*x[0]+(-0.72285785154)*x[1]**o+(-0.764360626538)*x[1]+(0.979115834974)*x[2]**o+(0.430570190112)*x[2]
        arg[2,0,1]=(-0.602364948602)*x[0]**o+(-0.313871272033)*x[0]+(0.931476652796)*x[1]**o+(-0.553237167378)*x[1]+(0.273773142735)*x[2]**o+(0.732796238419)*x[2]
        arg[2,1,0]=(0.723724167325)*x[0]**o+(-0.411330362765)*x[0]+(0.415411259564)*x[1]**o+(0.596006586583)*x[1]+(0.588177039382)*x[2]**o+(-0.365406082278)*x[2]
        arg[2,1,1]=(0.0622006916856)*x[0]**o+(0.583807018004)*x[0]+(0.292401319183)*x[1]**o+(-0.202393075873)*x[1]+(-0.544886623341)*x[2]**o+(-0.269087712755)*x[2]
        arg[3,0,0]=(-0.543339583883)*x[0]**o+(-0.594218090249)*x[0]+(0.463226896714)*x[1]**o+(0.613466907584)*x[1]+(0.147935164587)*x[2]**o+(0.696530808607)*x[2]
        arg[3,0,1]=(0.338109512519)*x[0]**o+(0.281428380284)*x[0]+(0.0445095482602)*x[1]**o+(0.898143737155)*x[1]+(0.0465131079784)*x[2]**o+(-0.311801195497)*x[2]
        arg[3,1,0]=(0.489699597199)*x[0]**o+(0.198461296558)*x[0]+(0.87785894323)*x[1]**o+(0.916226820395)*x[1]+(-0.473685913201)*x[2]**o+(-0.496145627682)*x[2]
        arg[3,1,1]=(0.249814020596)*x[0]**o+(-0.894315482252)*x[0]+(-0.778776373134)*x[1]**o+(0.760727700644)*x[1]+(0.743775735588)*x[2]**o+(-0.689040985439)*x[2]
        arg[4,0,0]=(-0.825052728563)*x[0]**o+(0.522046869865)*x[0]+(0.333964173928)*x[1]**o+(-0.76926539114)*x[1]+(0.412352181661)*x[2]**o+(-0.0067772174596)*x[2]
        arg[4,0,1]=(-0.478610156432)*x[0]**o+(0.750576911314)*x[0]+(-0.531813749953)*x[1]**o+(0.355951176778)*x[1]+(-0.852853671607)*x[2]**o+(0.980221079923)*x[2]
        arg[4,1,0]=(-0.641389506244)*x[0]**o+(0.881787042426)*x[0]+(-0.304080099649)*x[1]**o+(0.38448900132)*x[1]+(-0.047930997317)*x[2]**o+(-0.276038511441)*x[2]
        arg[4,1,1]=(0.606877338216)*x[0]**o+(0.693205674961)*x[0]+(-0.731785947563)*x[1]**o+(0.980888111857)*x[1]+(0.355758103413)*x[2]**o+(-0.493780352941)*x[2]
        arg[5,0,0]=(-0.542680086594)*x[0]**o+(-0.335712421489)*x[0]+(0.196257902892)*x[1]**o+(-0.923381865562)*x[1]+(0.396049043788)*x[2]**o+(0.231195219983)*x[2]
        arg[5,0,1]=(0.224328300764)*x[0]**o+(0.306254705923)*x[0]+(-0.298262471524)*x[1]**o+(0.318537412793)*x[1]+(-0.0971742408716)*x[2]**o+(-0.374440507273)*x[2]
        arg[5,1,0]=(-0.408985188836)*x[0]**o+(-0.932478279672)*x[0]+(0.700313488604)*x[1]**o+(0.259720889362)*x[1]+(0.862207003532)*x[2]**o+(0.646109275237)*x[2]
        arg[5,1,1]=(-0.0341740340851)*x[0]**o+(0.742119475866)*x[0]+(0.310640405448)*x[1]**o+(-0.295841203899)*x[1]+(-0.778064951853)*x[2]**o+(-0.847637829972)*x[2]
        ref[0,0,0,0]=o*(0.99032561737)*x_ref[0]**(o-1)+(0.0664709329455)
        ref[0,0,0,1]=o*(0.118470702946)*x_ref[1]**(o-1)+(0.339805181064)
        ref[0,0,0,2]=o*(-0.288819936068)*x_ref[2]**(o-1)+(0.500626113335)
        ref[0,0,1,0]=o*(-0.736833023385)*x_ref[0]**(o-1)+(-0.160433791202)
        ref[0,0,1,1]=o*(-0.159295012314)*x_ref[1]**(o-1)+(-0.0515197665154)
        ref[0,0,1,2]=o*(-0.199553046759)*x_ref[2]**(o-1)+(0.912767397035)
        ref[0,1,0,0]=o*(0.263643352646)*x_ref[0]**(o-1)+(-0.408521561602)
        ref[0,1,0,1]=o*(-0.690441644678)*x_ref[1]**(o-1)+(0.514925086967)
        ref[0,1,0,2]=o*(-0.321785011214)*x_ref[2]**(o-1)+(-0.192767636106)
        ref[0,1,1,0]=o*(-0.00679573309711)*x_ref[0]**(o-1)+(-0.0919830030966)
        ref[0,1,1,1]=o*(0.0194635540782)*x_ref[1]**(o-1)+(0.0364274479874)
        ref[0,1,1,2]=o*(0.324767149157)*x_ref[2]**(o-1)+(-0.930770951272)
        ref[1,0,0,0]=o*(0.129524159454)*x_ref[0]**(o-1)+(-0.747948168258)
        ref[1,0,0,1]=o*(0.748091879992)*x_ref[1]**(o-1)+(0.0701365933978)
        ref[1,0,0,2]=o*(-0.227595193537)*x_ref[2]**(o-1)+(-0.515988222581)
        ref[1,0,1,0]=o*(-0.369843455974)*x_ref[0]**(o-1)+(0.902965907161)
        ref[1,0,1,1]=o*(0.841050267135)*x_ref[1]**(o-1)+(0.985297243316)
        ref[1,0,1,2]=o*(-0.96057678523)*x_ref[2]**(o-1)+(0.149329555515)
        ref[1,1,0,0]=o*(-0.530918169849)*x_ref[0]**(o-1)+(0.574734874263)
        ref[1,1,0,1]=o*(-0.56424658789)*x_ref[1]**(o-1)+(-0.756154171146)
        ref[1,1,0,2]=o*(-0.181750429769)*x_ref[2]**(o-1)+(-0.270972276027)
        ref[1,1,1,0]=o*(0.18184543511)*x_ref[0]**(o-1)+(0.810253164883)
        ref[1,1,1,1]=o*(-0.0289547932926)*x_ref[1]**(o-1)+(0.690366471619)
        ref[1,1,1,2]=o*(0.862616271239)*x_ref[2]**(o-1)+(0.157705360996)
        ref[2,0,0,0]=o*(-0.732811475459)*x_ref[0]**(o-1)+(-0.720788617286)
        ref[2,0,0,1]=o*(-0.72285785154)*x_ref[1]**(o-1)+(-0.764360626538)
        ref[2,0,0,2]=o*(0.979115834974)*x_ref[2]**(o-1)+(0.430570190112)
        ref[2,0,1,0]=o*(-0.602364948602)*x_ref[0]**(o-1)+(-0.313871272033)
        ref[2,0,1,1]=o*(0.931476652796)*x_ref[1]**(o-1)+(-0.553237167378)
        ref[2,0,1,2]=o*(0.273773142735)*x_ref[2]**(o-1)+(0.732796238419)
        ref[2,1,0,0]=o*(0.723724167325)*x_ref[0]**(o-1)+(-0.411330362765)
        ref[2,1,0,1]=o*(0.415411259564)*x_ref[1]**(o-1)+(0.596006586583)
        ref[2,1,0,2]=o*(0.588177039382)*x_ref[2]**(o-1)+(-0.365406082278)
        ref[2,1,1,0]=o*(0.0622006916856)*x_ref[0]**(o-1)+(0.583807018004)
        ref[2,1,1,1]=o*(0.292401319183)*x_ref[1]**(o-1)+(-0.202393075873)
        ref[2,1,1,2]=o*(-0.544886623341)*x_ref[2]**(o-1)+(-0.269087712755)
        ref[3,0,0,0]=o*(-0.543339583883)*x_ref[0]**(o-1)+(-0.594218090249)
        ref[3,0,0,1]=o*(0.463226896714)*x_ref[1]**(o-1)+(0.613466907584)
        ref[3,0,0,2]=o*(0.147935164587)*x_ref[2]**(o-1)+(0.696530808607)
        ref[3,0,1,0]=o*(0.338109512519)*x_ref[0]**(o-1)+(0.281428380284)
        ref[3,0,1,1]=o*(0.0445095482602)*x_ref[1]**(o-1)+(0.898143737155)
        ref[3,0,1,2]=o*(0.0465131079784)*x_ref[2]**(o-1)+(-0.311801195497)
        ref[3,1,0,0]=o*(0.489699597199)*x_ref[0]**(o-1)+(0.198461296558)
        ref[3,1,0,1]=o*(0.87785894323)*x_ref[1]**(o-1)+(0.916226820395)
        ref[3,1,0,2]=o*(-0.473685913201)*x_ref[2]**(o-1)+(-0.496145627682)
        ref[3,1,1,0]=o*(0.249814020596)*x_ref[0]**(o-1)+(-0.894315482252)
        ref[3,1,1,1]=o*(-0.778776373134)*x_ref[1]**(o-1)+(0.760727700644)
        ref[3,1,1,2]=o*(0.743775735588)*x_ref[2]**(o-1)+(-0.689040985439)
        ref[4,0,0,0]=o*(-0.825052728563)*x_ref[0]**(o-1)+(0.522046869865)
        ref[4,0,0,1]=o*(0.333964173928)*x_ref[1]**(o-1)+(-0.76926539114)
        ref[4,0,0,2]=o*(0.412352181661)*x_ref[2]**(o-1)+(-0.0067772174596)
        ref[4,0,1,0]=o*(-0.478610156432)*x_ref[0]**(o-1)+(0.750576911314)
        ref[4,0,1,1]=o*(-0.531813749953)*x_ref[1]**(o-1)+(0.355951176778)
        ref[4,0,1,2]=o*(-0.852853671607)*x_ref[2]**(o-1)+(0.980221079923)
        ref[4,1,0,0]=o*(-0.641389506244)*x_ref[0]**(o-1)+(0.881787042426)
        ref[4,1,0,1]=o*(-0.304080099649)*x_ref[1]**(o-1)+(0.38448900132)
        ref[4,1,0,2]=o*(-0.047930997317)*x_ref[2]**(o-1)+(-0.276038511441)
        ref[4,1,1,0]=o*(0.606877338216)*x_ref[0]**(o-1)+(0.693205674961)
        ref[4,1,1,1]=o*(-0.731785947563)*x_ref[1]**(o-1)+(0.980888111857)
        ref[4,1,1,2]=o*(0.355758103413)*x_ref[2]**(o-1)+(-0.493780352941)
        ref[5,0,0,0]=o*(-0.542680086594)*x_ref[0]**(o-1)+(-0.335712421489)
        ref[5,0,0,1]=o*(0.196257902892)*x_ref[1]**(o-1)+(-0.923381865562)
        ref[5,0,0,2]=o*(0.396049043788)*x_ref[2]**(o-1)+(0.231195219983)
        ref[5,0,1,0]=o*(0.224328300764)*x_ref[0]**(o-1)+(0.306254705923)
        ref[5,0,1,1]=o*(-0.298262471524)*x_ref[1]**(o-1)+(0.318537412793)
        ref[5,0,1,2]=o*(-0.0971742408716)*x_ref[2]**(o-1)+(-0.374440507273)
        ref[5,1,0,0]=o*(-0.408985188836)*x_ref[0]**(o-1)+(-0.932478279672)
        ref[5,1,0,1]=o*(0.700313488604)*x_ref[1]**(o-1)+(0.259720889362)
        ref[5,1,0,2]=o*(0.862207003532)*x_ref[2]**(o-1)+(0.646109275237)
        ref[5,1,1,0]=o*(-0.0341740340851)*x_ref[0]**(o-1)+(0.742119475866)
        ref[5,1,1,1]=o*(0.310640405448)*x_ref[1]**(o-1)+(-0.295841203899)
        ref[5,1,1,2]=o*(-0.778064951853)*x_ref[2]**(o-1)+(-0.847637829972)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnContactOne_fromData_Solution_rank0(self):
      """
      tests gradient for rank 0 Data on the ReducedFunctionOnContactOne

      assumptions: Solution(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnContactOne
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=Solution(self.domain)
      x=w.getX()
      arg=Data(0,(),w)
      ref=Data(0,()+(dim,),w_ref)
      if dim==2:
        arg=(-0.188926722839)*x[0]**o+(0.0528015322778)*x[0]+(0.394368405707)*x[1]**o+(0.573648619197)*x[1]
        ref[0]=o*(-0.188926722839)*x_ref[0]**(o-1)+(0.0528015322778)
        ref[1]=o*(0.394368405707)*x_ref[1]**(o-1)+(0.573648619197)
      else:
        arg=(0.208843709667)*x[0]**o+(-0.461780133723)*x[0]+(0.15028897973)*x[1]**o+(-0.594920423887)*x[1]+(0.517629763426)*x[2]**o+(0.403396285863)*x[2]
        ref[0]=o*(0.208843709667)*x_ref[0]**(o-1)+(-0.461780133723)
        ref[1]=o*(0.15028897973)*x_ref[1]**(o-1)+(-0.594920423887)
        ref[2]=o*(0.517629763426)*x_ref[2]**(o-1)+(0.403396285863)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),()+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnContactOne_fromData_Solution_rank1(self):
      """
      tests gradient for rank 1 Data on the ReducedFunctionOnContactOne

      assumptions: Solution(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnContactOne
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=Solution(self.domain)
      x=w.getX()
      arg=Data(0,(2,),w)
      ref=Data(0,(2,)+(dim,),w_ref)
      if dim==2:
        arg[0]=(0.321445299816)*x[0]**o+(-0.133016832047)*x[0]+(0.663051729844)*x[1]**o+(-0.688058231943)*x[1]
        arg[1]=(-0.0269450330081)*x[0]**o+(0.0944332164606)*x[0]+(-0.285657276114)*x[1]**o+(-0.00151309619508)*x[1]
        ref[0,0]=o*(0.321445299816)*x_ref[0]**(o-1)+(-0.133016832047)
        ref[0,1]=o*(0.663051729844)*x_ref[1]**(o-1)+(-0.688058231943)
        ref[1,0]=o*(-0.0269450330081)*x_ref[0]**(o-1)+(0.0944332164606)
        ref[1,1]=o*(-0.285657276114)*x_ref[1]**(o-1)+(-0.00151309619508)
      else:
        arg[0]=(-0.779418963504)*x[0]**o+(-0.66017852882)*x[0]+(0.0796746454991)*x[1]**o+(-0.559782816375)*x[1]+(0.903645344893)*x[2]**o+(0.752370056114)*x[2]
        arg[1]=(-0.789198080015)*x[0]**o+(-0.61428352272)*x[0]+(-0.0678314090236)*x[1]**o+(-0.592189717525)*x[1]+(0.289759368386)*x[2]**o+(-0.612628874512)*x[2]
        ref[0,0]=o*(-0.779418963504)*x_ref[0]**(o-1)+(-0.66017852882)
        ref[0,1]=o*(0.0796746454991)*x_ref[1]**(o-1)+(-0.559782816375)
        ref[0,2]=o*(0.903645344893)*x_ref[2]**(o-1)+(0.752370056114)
        ref[1,0]=o*(-0.789198080015)*x_ref[0]**(o-1)+(-0.61428352272)
        ref[1,1]=o*(-0.0678314090236)*x_ref[1]**(o-1)+(-0.592189717525)
        ref[1,2]=o*(0.289759368386)*x_ref[2]**(o-1)+(-0.612628874512)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnContactOne_fromData_Solution_rank2(self):
      """
      tests gradient for rank 2 Data on the ReducedFunctionOnContactOne

      assumptions: Solution(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnContactOne
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=Solution(self.domain)
      x=w.getX()
      arg=Data(0,(4, 5),w)
      ref=Data(0,(4, 5)+(dim,),w_ref)
      if dim==2:
        arg[0,0]=(-0.23566716053)*x[0]**o+(-0.72341376636)*x[0]+(0.972511874619)*x[1]**o+(-0.915617397257)*x[1]
        arg[0,1]=(-0.767927641628)*x[0]**o+(0.381522882363)*x[0]+(0.147312331507)*x[1]**o+(0.593669546711)*x[1]
        arg[0,2]=(0.735354496752)*x[0]**o+(0.0328129903288)*x[0]+(-0.113236521952)*x[1]**o+(0.486761746739)*x[1]
        arg[0,3]=(-0.324209941994)*x[0]**o+(-0.235510827792)*x[0]+(0.167116943517)*x[1]**o+(0.0751459244008)*x[1]
        arg[0,4]=(-0.880038149806)*x[0]**o+(0.250698509807)*x[0]+(-0.249975000596)*x[1]**o+(-0.597287763096)*x[1]
        arg[1,0]=(0.0776176376816)*x[0]**o+(0.719231364575)*x[0]+(-0.573766708326)*x[1]**o+(-0.0657431038913)*x[1]
        arg[1,1]=(0.214586176047)*x[0]**o+(-0.542584637828)*x[0]+(-0.649916769602)*x[1]**o+(0.360674473897)*x[1]
        arg[1,2]=(-0.131191309002)*x[0]**o+(0.00956079049513)*x[0]+(-0.0399067337815)*x[1]**o+(-0.870803424616)*x[1]
        arg[1,3]=(-0.604243786872)*x[0]**o+(0.439677657963)*x[0]+(0.749342339715)*x[1]**o+(0.772192804507)*x[1]
        arg[1,4]=(0.461907488239)*x[0]**o+(-0.957858912937)*x[0]+(0.915893716197)*x[1]**o+(-0.858798101783)*x[1]
        arg[2,0]=(0.922598387398)*x[0]**o+(-0.194676923002)*x[0]+(-0.724972013231)*x[1]**o+(-0.83198174562)*x[1]
        arg[2,1]=(0.62648959348)*x[0]**o+(-0.968390708088)*x[0]+(0.955519507666)*x[1]**o+(0.0140489471727)*x[1]
        arg[2,2]=(-0.488249561275)*x[0]**o+(-0.354607683897)*x[0]+(-0.781278758499)*x[1]**o+(-0.206598205965)*x[1]
        arg[2,3]=(-0.503987693598)*x[0]**o+(0.581909066959)*x[0]+(0.133400791996)*x[1]**o+(-0.234595457546)*x[1]
        arg[2,4]=(-0.768789727431)*x[0]**o+(0.669013649323)*x[0]+(-0.618484878747)*x[1]**o+(-0.287461699457)*x[1]
        arg[3,0]=(0.125603852132)*x[0]**o+(0.83276119445)*x[0]+(-0.643188775199)*x[1]**o+(0.228300434999)*x[1]
        arg[3,1]=(0.645892506866)*x[0]**o+(0.701922167913)*x[0]+(-0.283958147744)*x[1]**o+(-0.781197564279)*x[1]
        arg[3,2]=(-0.0995754594857)*x[0]**o+(-0.106281614694)*x[0]+(0.00912723779796)*x[1]**o+(0.841448365384)*x[1]
        arg[3,3]=(-0.664740577186)*x[0]**o+(0.100401840489)*x[0]+(0.334300978415)*x[1]**o+(-0.383639183037)*x[1]
        arg[3,4]=(0.949394733501)*x[0]**o+(-0.0768203586407)*x[0]+(0.715238033192)*x[1]**o+(-0.175178433047)*x[1]
        ref[0,0,0]=o*(-0.23566716053)*x_ref[0]**(o-1)+(-0.72341376636)
        ref[0,0,1]=o*(0.972511874619)*x_ref[1]**(o-1)+(-0.915617397257)
        ref[0,1,0]=o*(-0.767927641628)*x_ref[0]**(o-1)+(0.381522882363)
        ref[0,1,1]=o*(0.147312331507)*x_ref[1]**(o-1)+(0.593669546711)
        ref[0,2,0]=o*(0.735354496752)*x_ref[0]**(o-1)+(0.0328129903288)
        ref[0,2,1]=o*(-0.113236521952)*x_ref[1]**(o-1)+(0.486761746739)
        ref[0,3,0]=o*(-0.324209941994)*x_ref[0]**(o-1)+(-0.235510827792)
        ref[0,3,1]=o*(0.167116943517)*x_ref[1]**(o-1)+(0.0751459244008)
        ref[0,4,0]=o*(-0.880038149806)*x_ref[0]**(o-1)+(0.250698509807)
        ref[0,4,1]=o*(-0.249975000596)*x_ref[1]**(o-1)+(-0.597287763096)
        ref[1,0,0]=o*(0.0776176376816)*x_ref[0]**(o-1)+(0.719231364575)
        ref[1,0,1]=o*(-0.573766708326)*x_ref[1]**(o-1)+(-0.0657431038913)
        ref[1,1,0]=o*(0.214586176047)*x_ref[0]**(o-1)+(-0.542584637828)
        ref[1,1,1]=o*(-0.649916769602)*x_ref[1]**(o-1)+(0.360674473897)
        ref[1,2,0]=o*(-0.131191309002)*x_ref[0]**(o-1)+(0.00956079049513)
        ref[1,2,1]=o*(-0.0399067337815)*x_ref[1]**(o-1)+(-0.870803424616)
        ref[1,3,0]=o*(-0.604243786872)*x_ref[0]**(o-1)+(0.439677657963)
        ref[1,3,1]=o*(0.749342339715)*x_ref[1]**(o-1)+(0.772192804507)
        ref[1,4,0]=o*(0.461907488239)*x_ref[0]**(o-1)+(-0.957858912937)
        ref[1,4,1]=o*(0.915893716197)*x_ref[1]**(o-1)+(-0.858798101783)
        ref[2,0,0]=o*(0.922598387398)*x_ref[0]**(o-1)+(-0.194676923002)
        ref[2,0,1]=o*(-0.724972013231)*x_ref[1]**(o-1)+(-0.83198174562)
        ref[2,1,0]=o*(0.62648959348)*x_ref[0]**(o-1)+(-0.968390708088)
        ref[2,1,1]=o*(0.955519507666)*x_ref[1]**(o-1)+(0.0140489471727)
        ref[2,2,0]=o*(-0.488249561275)*x_ref[0]**(o-1)+(-0.354607683897)
        ref[2,2,1]=o*(-0.781278758499)*x_ref[1]**(o-1)+(-0.206598205965)
        ref[2,3,0]=o*(-0.503987693598)*x_ref[0]**(o-1)+(0.581909066959)
        ref[2,3,1]=o*(0.133400791996)*x_ref[1]**(o-1)+(-0.234595457546)
        ref[2,4,0]=o*(-0.768789727431)*x_ref[0]**(o-1)+(0.669013649323)
        ref[2,4,1]=o*(-0.618484878747)*x_ref[1]**(o-1)+(-0.287461699457)
        ref[3,0,0]=o*(0.125603852132)*x_ref[0]**(o-1)+(0.83276119445)
        ref[3,0,1]=o*(-0.643188775199)*x_ref[1]**(o-1)+(0.228300434999)
        ref[3,1,0]=o*(0.645892506866)*x_ref[0]**(o-1)+(0.701922167913)
        ref[3,1,1]=o*(-0.283958147744)*x_ref[1]**(o-1)+(-0.781197564279)
        ref[3,2,0]=o*(-0.0995754594857)*x_ref[0]**(o-1)+(-0.106281614694)
        ref[3,2,1]=o*(0.00912723779796)*x_ref[1]**(o-1)+(0.841448365384)
        ref[3,3,0]=o*(-0.664740577186)*x_ref[0]**(o-1)+(0.100401840489)
        ref[3,3,1]=o*(0.334300978415)*x_ref[1]**(o-1)+(-0.383639183037)
        ref[3,4,0]=o*(0.949394733501)*x_ref[0]**(o-1)+(-0.0768203586407)
        ref[3,4,1]=o*(0.715238033192)*x_ref[1]**(o-1)+(-0.175178433047)
      else:
        arg[0,0]=(0.697509098917)*x[0]**o+(-0.571983680004)*x[0]+(0.456254556306)*x[1]**o+(0.407076527516)*x[1]+(-0.379511349609)*x[2]**o+(0.37799055755)*x[2]
        arg[0,1]=(-0.543310012054)*x[0]**o+(0.622613643381)*x[0]+(0.899028609397)*x[1]**o+(0.0358870746022)*x[1]+(0.923875380698)*x[2]**o+(-0.79605331054)*x[2]
        arg[0,2]=(0.613316685189)*x[0]**o+(0.308568047177)*x[0]+(0.0817110033202)*x[1]**o+(0.631167179752)*x[1]+(0.527259723046)*x[2]**o+(-0.44240882282)*x[2]
        arg[0,3]=(0.831261835833)*x[0]**o+(-0.0869775296331)*x[0]+(0.30622781536)*x[1]**o+(0.633056041347)*x[1]+(0.631243241273)*x[2]**o+(0.100112313541)*x[2]
        arg[0,4]=(-0.997030704248)*x[0]**o+(-0.374466395678)*x[0]+(0.0194535973217)*x[1]**o+(0.816505299829)*x[1]+(-0.412869831136)*x[2]**o+(-0.943976805293)*x[2]
        arg[1,0]=(0.555404162574)*x[0]**o+(-0.335389786458)*x[0]+(0.644585507787)*x[1]**o+(0.917280812233)*x[1]+(0.417410132456)*x[2]**o+(-0.26505427144)*x[2]
        arg[1,1]=(0.781185373116)*x[0]**o+(-0.852319927495)*x[0]+(-0.442528270016)*x[1]**o+(-0.538132919634)*x[1]+(-0.604047417588)*x[2]**o+(0.727395882535)*x[2]
        arg[1,2]=(-0.272462727471)*x[0]**o+(-0.834077558378)*x[0]+(0.763269297137)*x[1]**o+(-0.823180222291)*x[1]+(-0.162146758865)*x[2]**o+(0.595529366226)*x[2]
        arg[1,3]=(-0.0468429326976)*x[0]**o+(-0.179116342871)*x[0]+(-0.640563576973)*x[1]**o+(0.914070705704)*x[1]+(0.725297040984)*x[2]**o+(0.870302256055)*x[2]
        arg[1,4]=(-0.0632444730547)*x[0]**o+(-0.266315658984)*x[0]+(0.533681589116)*x[1]**o+(0.709939511175)*x[1]+(-0.60554532679)*x[2]**o+(0.915224044125)*x[2]
        arg[2,0]=(0.23330035938)*x[0]**o+(-0.385419740264)*x[0]+(0.120424890588)*x[1]**o+(0.591983224766)*x[1]+(0.925564960339)*x[2]**o+(-0.602528014193)*x[2]
        arg[2,1]=(0.786024569139)*x[0]**o+(0.619287163829)*x[0]+(-0.722187904611)*x[1]**o+(0.275352886478)*x[1]+(0.723591624164)*x[2]**o+(0.0909486746072)*x[2]
        arg[2,2]=(0.766293557291)*x[0]**o+(0.0610694643295)*x[0]+(0.375714644104)*x[1]**o+(-0.772092520637)*x[1]+(0.775058332825)*x[2]**o+(0.533525926942)*x[2]
        arg[2,3]=(-0.67254491898)*x[0]**o+(-0.0926113197516)*x[0]+(-0.615891770107)*x[1]**o+(-0.616600504392)*x[1]+(-0.808251600122)*x[2]**o+(-0.602309670223)*x[2]
        arg[2,4]=(0.80242562495)*x[0]**o+(0.359171734464)*x[0]+(-0.560256436586)*x[1]**o+(-0.420334736194)*x[1]+(0.871043977034)*x[2]**o+(0.156212055829)*x[2]
        arg[3,0]=(-0.0569856826934)*x[0]**o+(-0.381868544897)*x[0]+(-0.396013644801)*x[1]**o+(0.695329212849)*x[1]+(0.201188831017)*x[2]**o+(0.471078018432)*x[2]
        arg[3,1]=(0.28457474179)*x[0]**o+(-0.623305572154)*x[0]+(-0.442659858168)*x[1]**o+(0.725900635371)*x[1]+(-0.908206119008)*x[2]**o+(-0.190223696293)*x[2]
        arg[3,2]=(0.568043480074)*x[0]**o+(0.942235524274)*x[0]+(-0.720727900911)*x[1]**o+(0.771808109591)*x[1]+(-0.538996050264)*x[2]**o+(-0.641448383256)*x[2]
        arg[3,3]=(0.00707362989382)*x[0]**o+(0.139812417833)*x[0]+(-0.179986304531)*x[1]**o+(-0.546332565953)*x[1]+(-0.687783685855)*x[2]**o+(0.292513389166)*x[2]
        arg[3,4]=(0.657315930332)*x[0]**o+(0.0252304793386)*x[0]+(0.540737656651)*x[1]**o+(0.832327802479)*x[1]+(-0.822641904799)*x[2]**o+(-0.599972412377)*x[2]
        ref[0,0,0]=o*(0.697509098917)*x_ref[0]**(o-1)+(-0.571983680004)
        ref[0,0,1]=o*(0.456254556306)*x_ref[1]**(o-1)+(0.407076527516)
        ref[0,0,2]=o*(-0.379511349609)*x_ref[2]**(o-1)+(0.37799055755)
        ref[0,1,0]=o*(-0.543310012054)*x_ref[0]**(o-1)+(0.622613643381)
        ref[0,1,1]=o*(0.899028609397)*x_ref[1]**(o-1)+(0.0358870746022)
        ref[0,1,2]=o*(0.923875380698)*x_ref[2]**(o-1)+(-0.79605331054)
        ref[0,2,0]=o*(0.613316685189)*x_ref[0]**(o-1)+(0.308568047177)
        ref[0,2,1]=o*(0.0817110033202)*x_ref[1]**(o-1)+(0.631167179752)
        ref[0,2,2]=o*(0.527259723046)*x_ref[2]**(o-1)+(-0.44240882282)
        ref[0,3,0]=o*(0.831261835833)*x_ref[0]**(o-1)+(-0.0869775296331)
        ref[0,3,1]=o*(0.30622781536)*x_ref[1]**(o-1)+(0.633056041347)
        ref[0,3,2]=o*(0.631243241273)*x_ref[2]**(o-1)+(0.100112313541)
        ref[0,4,0]=o*(-0.997030704248)*x_ref[0]**(o-1)+(-0.374466395678)
        ref[0,4,1]=o*(0.0194535973217)*x_ref[1]**(o-1)+(0.816505299829)
        ref[0,4,2]=o*(-0.412869831136)*x_ref[2]**(o-1)+(-0.943976805293)
        ref[1,0,0]=o*(0.555404162574)*x_ref[0]**(o-1)+(-0.335389786458)
        ref[1,0,1]=o*(0.644585507787)*x_ref[1]**(o-1)+(0.917280812233)
        ref[1,0,2]=o*(0.417410132456)*x_ref[2]**(o-1)+(-0.26505427144)
        ref[1,1,0]=o*(0.781185373116)*x_ref[0]**(o-1)+(-0.852319927495)
        ref[1,1,1]=o*(-0.442528270016)*x_ref[1]**(o-1)+(-0.538132919634)
        ref[1,1,2]=o*(-0.604047417588)*x_ref[2]**(o-1)+(0.727395882535)
        ref[1,2,0]=o*(-0.272462727471)*x_ref[0]**(o-1)+(-0.834077558378)
        ref[1,2,1]=o*(0.763269297137)*x_ref[1]**(o-1)+(-0.823180222291)
        ref[1,2,2]=o*(-0.162146758865)*x_ref[2]**(o-1)+(0.595529366226)
        ref[1,3,0]=o*(-0.0468429326976)*x_ref[0]**(o-1)+(-0.179116342871)
        ref[1,3,1]=o*(-0.640563576973)*x_ref[1]**(o-1)+(0.914070705704)
        ref[1,3,2]=o*(0.725297040984)*x_ref[2]**(o-1)+(0.870302256055)
        ref[1,4,0]=o*(-0.0632444730547)*x_ref[0]**(o-1)+(-0.266315658984)
        ref[1,4,1]=o*(0.533681589116)*x_ref[1]**(o-1)+(0.709939511175)
        ref[1,4,2]=o*(-0.60554532679)*x_ref[2]**(o-1)+(0.915224044125)
        ref[2,0,0]=o*(0.23330035938)*x_ref[0]**(o-1)+(-0.385419740264)
        ref[2,0,1]=o*(0.120424890588)*x_ref[1]**(o-1)+(0.591983224766)
        ref[2,0,2]=o*(0.925564960339)*x_ref[2]**(o-1)+(-0.602528014193)
        ref[2,1,0]=o*(0.786024569139)*x_ref[0]**(o-1)+(0.619287163829)
        ref[2,1,1]=o*(-0.722187904611)*x_ref[1]**(o-1)+(0.275352886478)
        ref[2,1,2]=o*(0.723591624164)*x_ref[2]**(o-1)+(0.0909486746072)
        ref[2,2,0]=o*(0.766293557291)*x_ref[0]**(o-1)+(0.0610694643295)
        ref[2,2,1]=o*(0.375714644104)*x_ref[1]**(o-1)+(-0.772092520637)
        ref[2,2,2]=o*(0.775058332825)*x_ref[2]**(o-1)+(0.533525926942)
        ref[2,3,0]=o*(-0.67254491898)*x_ref[0]**(o-1)+(-0.0926113197516)
        ref[2,3,1]=o*(-0.615891770107)*x_ref[1]**(o-1)+(-0.616600504392)
        ref[2,3,2]=o*(-0.808251600122)*x_ref[2]**(o-1)+(-0.602309670223)
        ref[2,4,0]=o*(0.80242562495)*x_ref[0]**(o-1)+(0.359171734464)
        ref[2,4,1]=o*(-0.560256436586)*x_ref[1]**(o-1)+(-0.420334736194)
        ref[2,4,2]=o*(0.871043977034)*x_ref[2]**(o-1)+(0.156212055829)
        ref[3,0,0]=o*(-0.0569856826934)*x_ref[0]**(o-1)+(-0.381868544897)
        ref[3,0,1]=o*(-0.396013644801)*x_ref[1]**(o-1)+(0.695329212849)
        ref[3,0,2]=o*(0.201188831017)*x_ref[2]**(o-1)+(0.471078018432)
        ref[3,1,0]=o*(0.28457474179)*x_ref[0]**(o-1)+(-0.623305572154)
        ref[3,1,1]=o*(-0.442659858168)*x_ref[1]**(o-1)+(0.725900635371)
        ref[3,1,2]=o*(-0.908206119008)*x_ref[2]**(o-1)+(-0.190223696293)
        ref[3,2,0]=o*(0.568043480074)*x_ref[0]**(o-1)+(0.942235524274)
        ref[3,2,1]=o*(-0.720727900911)*x_ref[1]**(o-1)+(0.771808109591)
        ref[3,2,2]=o*(-0.538996050264)*x_ref[2]**(o-1)+(-0.641448383256)
        ref[3,3,0]=o*(0.00707362989382)*x_ref[0]**(o-1)+(0.139812417833)
        ref[3,3,1]=o*(-0.179986304531)*x_ref[1]**(o-1)+(-0.546332565953)
        ref[3,3,2]=o*(-0.687783685855)*x_ref[2]**(o-1)+(0.292513389166)
        ref[3,4,0]=o*(0.657315930332)*x_ref[0]**(o-1)+(0.0252304793386)
        ref[3,4,1]=o*(0.540737656651)*x_ref[1]**(o-1)+(0.832327802479)
        ref[3,4,2]=o*(-0.822641904799)*x_ref[2]**(o-1)+(-0.599972412377)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnContactOne_fromData_Solution_rank3(self):
      """
      tests gradient for rank 3 Data on the ReducedFunctionOnContactOne

      assumptions: Solution(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnContactOne
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=Solution(self.domain)
      x=w.getX()
      arg=Data(0,(6, 2, 2),w)
      ref=Data(0,(6, 2, 2)+(dim,),w_ref)
      if dim==2:
        arg[0,0,0]=(0.711259674136)*x[0]**o+(0.597099394118)*x[0]+(0.656676641605)*x[1]**o+(0.800065074626)*x[1]
        arg[0,0,1]=(0.410575880869)*x[0]**o+(0.0290305819624)*x[0]+(-0.746442034948)*x[1]**o+(0.074826200729)*x[1]
        arg[0,1,0]=(0.478073638149)*x[0]**o+(0.856920711223)*x[0]+(0.517173340088)*x[1]**o+(-0.677846282063)*x[1]
        arg[0,1,1]=(0.285231489647)*x[0]**o+(0.0756593965609)*x[0]+(-0.355221676478)*x[1]**o+(-0.520564308221)*x[1]
        arg[1,0,0]=(-0.368777104698)*x[0]**o+(0.474996103371)*x[0]+(0.675654207136)*x[1]**o+(-0.0324979517659)*x[1]
        arg[1,0,1]=(0.498857835281)*x[0]**o+(-0.73836840989)*x[0]+(0.362789682422)*x[1]**o+(0.315425076703)*x[1]
        arg[1,1,0]=(-0.325384820094)*x[0]**o+(-0.895297521761)*x[0]+(0.563090918504)*x[1]**o+(0.589834648825)*x[1]
        arg[1,1,1]=(0.0378060061714)*x[0]**o+(-0.429064920806)*x[0]+(-0.467324629077)*x[1]**o+(0.938161415082)*x[1]
        arg[2,0,0]=(-0.527827738902)*x[0]**o+(-0.534425169092)*x[0]+(-0.185111533531)*x[1]**o+(-0.810076656622)*x[1]
        arg[2,0,1]=(-0.221712302033)*x[0]**o+(0.883619587624)*x[0]+(-0.972912188123)*x[1]**o+(0.0780565750992)*x[1]
        arg[2,1,0]=(-0.752942706408)*x[0]**o+(-0.153790659605)*x[0]+(-0.398384592556)*x[1]**o+(0.657319049074)*x[1]
        arg[2,1,1]=(0.428492876383)*x[0]**o+(0.427090189076)*x[0]+(-0.017400284896)*x[1]**o+(-0.730635641841)*x[1]
        arg[3,0,0]=(-0.644602330168)*x[0]**o+(0.706532342264)*x[0]+(-0.64532460698)*x[1]**o+(0.850059843173)*x[1]
        arg[3,0,1]=(-0.63066688687)*x[0]**o+(0.578132047851)*x[0]+(0.413335880906)*x[1]**o+(0.611233278281)*x[1]
        arg[3,1,0]=(-0.247378556309)*x[0]**o+(-0.631688468936)*x[0]+(-0.898130068425)*x[1]**o+(0.147210661251)*x[1]
        arg[3,1,1]=(0.979026126394)*x[0]**o+(-0.231003559285)*x[0]+(-0.884530953901)*x[1]**o+(-0.453907922804)*x[1]
        arg[4,0,0]=(-0.584910281652)*x[0]**o+(-0.808929690751)*x[0]+(0.661854511996)*x[1]**o+(0.262336033771)*x[1]
        arg[4,0,1]=(0.32006961919)*x[0]**o+(0.407637671852)*x[0]+(-0.36617527544)*x[1]**o+(-0.28786191714)*x[1]
        arg[4,1,0]=(0.718670448416)*x[0]**o+(-0.836956284868)*x[0]+(0.694744974874)*x[1]**o+(-0.176920245996)*x[1]
        arg[4,1,1]=(-0.892867770142)*x[0]**o+(-0.439240069099)*x[0]+(0.960956271989)*x[1]**o+(-0.559541152716)*x[1]
        arg[5,0,0]=(-0.159459484106)*x[0]**o+(0.497366075466)*x[0]+(0.776343693655)*x[1]**o+(0.326882397775)*x[1]
        arg[5,0,1]=(-0.769197598992)*x[0]**o+(-0.155931232816)*x[0]+(0.306889959757)*x[1]**o+(0.283798117232)*x[1]
        arg[5,1,0]=(0.329987736778)*x[0]**o+(-0.181917315586)*x[0]+(0.896508353752)*x[1]**o+(0.505276687831)*x[1]
        arg[5,1,1]=(-0.805264678584)*x[0]**o+(0.1541429191)*x[0]+(0.759370357364)*x[1]**o+(-0.858941373648)*x[1]
        ref[0,0,0,0]=o*(0.711259674136)*x_ref[0]**(o-1)+(0.597099394118)
        ref[0,0,0,1]=o*(0.656676641605)*x_ref[1]**(o-1)+(0.800065074626)
        ref[0,0,1,0]=o*(0.410575880869)*x_ref[0]**(o-1)+(0.0290305819624)
        ref[0,0,1,1]=o*(-0.746442034948)*x_ref[1]**(o-1)+(0.074826200729)
        ref[0,1,0,0]=o*(0.478073638149)*x_ref[0]**(o-1)+(0.856920711223)
        ref[0,1,0,1]=o*(0.517173340088)*x_ref[1]**(o-1)+(-0.677846282063)
        ref[0,1,1,0]=o*(0.285231489647)*x_ref[0]**(o-1)+(0.0756593965609)
        ref[0,1,1,1]=o*(-0.355221676478)*x_ref[1]**(o-1)+(-0.520564308221)
        ref[1,0,0,0]=o*(-0.368777104698)*x_ref[0]**(o-1)+(0.474996103371)
        ref[1,0,0,1]=o*(0.675654207136)*x_ref[1]**(o-1)+(-0.0324979517659)
        ref[1,0,1,0]=o*(0.498857835281)*x_ref[0]**(o-1)+(-0.73836840989)
        ref[1,0,1,1]=o*(0.362789682422)*x_ref[1]**(o-1)+(0.315425076703)
        ref[1,1,0,0]=o*(-0.325384820094)*x_ref[0]**(o-1)+(-0.895297521761)
        ref[1,1,0,1]=o*(0.563090918504)*x_ref[1]**(o-1)+(0.589834648825)
        ref[1,1,1,0]=o*(0.0378060061714)*x_ref[0]**(o-1)+(-0.429064920806)
        ref[1,1,1,1]=o*(-0.467324629077)*x_ref[1]**(o-1)+(0.938161415082)
        ref[2,0,0,0]=o*(-0.527827738902)*x_ref[0]**(o-1)+(-0.534425169092)
        ref[2,0,0,1]=o*(-0.185111533531)*x_ref[1]**(o-1)+(-0.810076656622)
        ref[2,0,1,0]=o*(-0.221712302033)*x_ref[0]**(o-1)+(0.883619587624)
        ref[2,0,1,1]=o*(-0.972912188123)*x_ref[1]**(o-1)+(0.0780565750992)
        ref[2,1,0,0]=o*(-0.752942706408)*x_ref[0]**(o-1)+(-0.153790659605)
        ref[2,1,0,1]=o*(-0.398384592556)*x_ref[1]**(o-1)+(0.657319049074)
        ref[2,1,1,0]=o*(0.428492876383)*x_ref[0]**(o-1)+(0.427090189076)
        ref[2,1,1,1]=o*(-0.017400284896)*x_ref[1]**(o-1)+(-0.730635641841)
        ref[3,0,0,0]=o*(-0.644602330168)*x_ref[0]**(o-1)+(0.706532342264)
        ref[3,0,0,1]=o*(-0.64532460698)*x_ref[1]**(o-1)+(0.850059843173)
        ref[3,0,1,0]=o*(-0.63066688687)*x_ref[0]**(o-1)+(0.578132047851)
        ref[3,0,1,1]=o*(0.413335880906)*x_ref[1]**(o-1)+(0.611233278281)
        ref[3,1,0,0]=o*(-0.247378556309)*x_ref[0]**(o-1)+(-0.631688468936)
        ref[3,1,0,1]=o*(-0.898130068425)*x_ref[1]**(o-1)+(0.147210661251)
        ref[3,1,1,0]=o*(0.979026126394)*x_ref[0]**(o-1)+(-0.231003559285)
        ref[3,1,1,1]=o*(-0.884530953901)*x_ref[1]**(o-1)+(-0.453907922804)
        ref[4,0,0,0]=o*(-0.584910281652)*x_ref[0]**(o-1)+(-0.808929690751)
        ref[4,0,0,1]=o*(0.661854511996)*x_ref[1]**(o-1)+(0.262336033771)
        ref[4,0,1,0]=o*(0.32006961919)*x_ref[0]**(o-1)+(0.407637671852)
        ref[4,0,1,1]=o*(-0.36617527544)*x_ref[1]**(o-1)+(-0.28786191714)
        ref[4,1,0,0]=o*(0.718670448416)*x_ref[0]**(o-1)+(-0.836956284868)
        ref[4,1,0,1]=o*(0.694744974874)*x_ref[1]**(o-1)+(-0.176920245996)
        ref[4,1,1,0]=o*(-0.892867770142)*x_ref[0]**(o-1)+(-0.439240069099)
        ref[4,1,1,1]=o*(0.960956271989)*x_ref[1]**(o-1)+(-0.559541152716)
        ref[5,0,0,0]=o*(-0.159459484106)*x_ref[0]**(o-1)+(0.497366075466)
        ref[5,0,0,1]=o*(0.776343693655)*x_ref[1]**(o-1)+(0.326882397775)
        ref[5,0,1,0]=o*(-0.769197598992)*x_ref[0]**(o-1)+(-0.155931232816)
        ref[5,0,1,1]=o*(0.306889959757)*x_ref[1]**(o-1)+(0.283798117232)
        ref[5,1,0,0]=o*(0.329987736778)*x_ref[0]**(o-1)+(-0.181917315586)
        ref[5,1,0,1]=o*(0.896508353752)*x_ref[1]**(o-1)+(0.505276687831)
        ref[5,1,1,0]=o*(-0.805264678584)*x_ref[0]**(o-1)+(0.1541429191)
        ref[5,1,1,1]=o*(0.759370357364)*x_ref[1]**(o-1)+(-0.858941373648)
      else:
        arg[0,0,0]=(0.168268053227)*x[0]**o+(-0.693455720059)*x[0]+(-0.929660815724)*x[1]**o+(0.986095168154)*x[1]+(0.736239785757)*x[2]**o+(-0.852231596742)*x[2]
        arg[0,0,1]=(-0.246755690586)*x[0]**o+(0.374568513964)*x[0]+(-0.964930789849)*x[1]**o+(0.911595670675)*x[1]+(-0.450825843592)*x[2]**o+(0.109918389584)*x[2]
        arg[0,1,0]=(-0.733872890764)*x[0]**o+(-0.673737586895)*x[0]+(0.948528017502)*x[1]**o+(0.00135698010622)*x[1]+(0.960702320728)*x[2]**o+(-0.0223793346126)*x[2]
        arg[0,1,1]=(0.117470384547)*x[0]**o+(0.390065805504)*x[0]+(0.116939897886)*x[1]**o+(0.201756470627)*x[1]+(0.649311190776)*x[2]**o+(-0.388330674246)*x[2]
        arg[1,0,0]=(0.848074231014)*x[0]**o+(-0.431699971504)*x[0]+(0.956477578677)*x[1]**o+(0.522633753414)*x[1]+(0.147733403055)*x[2]**o+(0.136817362225)*x[2]
        arg[1,0,1]=(0.482934543775)*x[0]**o+(-0.358181242578)*x[0]+(-0.013088278343)*x[1]**o+(0.002654195003)*x[1]+(0.960898421715)*x[2]**o+(0.23166323571)*x[2]
        arg[1,1,0]=(-0.60469206115)*x[0]**o+(-0.449073005118)*x[0]+(-0.0774626329204)*x[1]**o+(-0.135772353437)*x[1]+(-0.796309060217)*x[2]**o+(-0.0601212417342)*x[2]
        arg[1,1,1]=(0.41742915222)*x[0]**o+(-0.907531578792)*x[0]+(-0.998018453394)*x[1]**o+(0.38863222527)*x[1]+(-0.941909949653)*x[2]**o+(-0.962025400733)*x[2]
        arg[2,0,0]=(0.677803680186)*x[0]**o+(0.493757303449)*x[0]+(-0.700353467324)*x[1]**o+(0.713489396377)*x[1]+(-0.147276750564)*x[2]**o+(-0.666815984705)*x[2]
        arg[2,0,1]=(-0.196166170445)*x[0]**o+(-0.776357160477)*x[0]+(0.531757851468)*x[1]**o+(-0.0951663105473)*x[1]+(0.296695659682)*x[2]**o+(0.132047740242)*x[2]
        arg[2,1,0]=(0.89703218788)*x[0]**o+(0.446461958293)*x[0]+(0.849781349832)*x[1]**o+(0.495003438762)*x[1]+(0.200866318394)*x[2]**o+(-0.239158244355)*x[2]
        arg[2,1,1]=(0.699816693)*x[0]**o+(-0.498016262468)*x[0]+(0.467212425781)*x[1]**o+(0.507210685133)*x[1]+(0.872000089805)*x[2]**o+(-0.608415132584)*x[2]
        arg[3,0,0]=(-0.858779999521)*x[0]**o+(-0.934307938564)*x[0]+(0.998531969194)*x[1]**o+(-0.10694369616)*x[1]+(0.565515051636)*x[2]**o+(-0.340328286843)*x[2]
        arg[3,0,1]=(-0.734447160975)*x[0]**o+(0.592969337009)*x[0]+(0.769648460523)*x[1]**o+(0.939994123398)*x[1]+(-0.14168879251)*x[2]**o+(-0.151602759825)*x[2]
        arg[3,1,0]=(-0.204447368694)*x[0]**o+(-0.149512701586)*x[0]+(0.496643987821)*x[1]**o+(0.137154021271)*x[1]+(-0.207451973465)*x[2]**o+(0.976289933313)*x[2]
        arg[3,1,1]=(-0.498939396392)*x[0]**o+(-0.388761371521)*x[0]+(0.918876234523)*x[1]**o+(0.326334103437)*x[1]+(0.135801853065)*x[2]**o+(-0.513268577694)*x[2]
        arg[4,0,0]=(0.383369953978)*x[0]**o+(0.262190952188)*x[0]+(0.226913840907)*x[1]**o+(0.625767074123)*x[1]+(0.0736409418752)*x[2]**o+(-0.681643359069)*x[2]
        arg[4,0,1]=(-0.00395633017219)*x[0]**o+(0.103598757494)*x[0]+(0.245388867438)*x[1]**o+(0.0199139065324)*x[1]+(-0.85935209669)*x[2]**o+(0.780770429677)*x[2]
        arg[4,1,0]=(0.93284113054)*x[0]**o+(0.192867707515)*x[0]+(0.354258046046)*x[1]**o+(0.0244899514488)*x[1]+(-0.00723308587137)*x[2]**o+(0.724287748378)*x[2]
        arg[4,1,1]=(-0.701870704251)*x[0]**o+(0.29146856048)*x[0]+(-0.677358067691)*x[1]**o+(-0.055827889309)*x[1]+(0.96248585097)*x[2]**o+(0.100526700803)*x[2]
        arg[5,0,0]=(-0.582058132348)*x[0]**o+(0.5354038569)*x[0]+(-0.608415656952)*x[1]**o+(0.700352801694)*x[1]+(-0.705438310252)*x[2]**o+(0.969824711925)*x[2]
        arg[5,0,1]=(-0.573326444971)*x[0]**o+(0.00490482707944)*x[0]+(0.300312254171)*x[1]**o+(-0.620154697788)*x[1]+(-0.0703788860867)*x[2]**o+(-0.608567609941)*x[2]
        arg[5,1,0]=(0.346782282755)*x[0]**o+(-0.022146949553)*x[0]+(0.548359292626)*x[1]**o+(0.314315074761)*x[1]+(0.164808336191)*x[2]**o+(-0.983018613943)*x[2]
        arg[5,1,1]=(-0.357126808896)*x[0]**o+(0.547191129837)*x[0]+(-0.0128153418859)*x[1]**o+(-0.199507147279)*x[1]+(-0.637546467191)*x[2]**o+(0.65056997574)*x[2]
        ref[0,0,0,0]=o*(0.168268053227)*x_ref[0]**(o-1)+(-0.693455720059)
        ref[0,0,0,1]=o*(-0.929660815724)*x_ref[1]**(o-1)+(0.986095168154)
        ref[0,0,0,2]=o*(0.736239785757)*x_ref[2]**(o-1)+(-0.852231596742)
        ref[0,0,1,0]=o*(-0.246755690586)*x_ref[0]**(o-1)+(0.374568513964)
        ref[0,0,1,1]=o*(-0.964930789849)*x_ref[1]**(o-1)+(0.911595670675)
        ref[0,0,1,2]=o*(-0.450825843592)*x_ref[2]**(o-1)+(0.109918389584)
        ref[0,1,0,0]=o*(-0.733872890764)*x_ref[0]**(o-1)+(-0.673737586895)
        ref[0,1,0,1]=o*(0.948528017502)*x_ref[1]**(o-1)+(0.00135698010622)
        ref[0,1,0,2]=o*(0.960702320728)*x_ref[2]**(o-1)+(-0.0223793346126)
        ref[0,1,1,0]=o*(0.117470384547)*x_ref[0]**(o-1)+(0.390065805504)
        ref[0,1,1,1]=o*(0.116939897886)*x_ref[1]**(o-1)+(0.201756470627)
        ref[0,1,1,2]=o*(0.649311190776)*x_ref[2]**(o-1)+(-0.388330674246)
        ref[1,0,0,0]=o*(0.848074231014)*x_ref[0]**(o-1)+(-0.431699971504)
        ref[1,0,0,1]=o*(0.956477578677)*x_ref[1]**(o-1)+(0.522633753414)
        ref[1,0,0,2]=o*(0.147733403055)*x_ref[2]**(o-1)+(0.136817362225)
        ref[1,0,1,0]=o*(0.482934543775)*x_ref[0]**(o-1)+(-0.358181242578)
        ref[1,0,1,1]=o*(-0.013088278343)*x_ref[1]**(o-1)+(0.002654195003)
        ref[1,0,1,2]=o*(0.960898421715)*x_ref[2]**(o-1)+(0.23166323571)
        ref[1,1,0,0]=o*(-0.60469206115)*x_ref[0]**(o-1)+(-0.449073005118)
        ref[1,1,0,1]=o*(-0.0774626329204)*x_ref[1]**(o-1)+(-0.135772353437)
        ref[1,1,0,2]=o*(-0.796309060217)*x_ref[2]**(o-1)+(-0.0601212417342)
        ref[1,1,1,0]=o*(0.41742915222)*x_ref[0]**(o-1)+(-0.907531578792)
        ref[1,1,1,1]=o*(-0.998018453394)*x_ref[1]**(o-1)+(0.38863222527)
        ref[1,1,1,2]=o*(-0.941909949653)*x_ref[2]**(o-1)+(-0.962025400733)
        ref[2,0,0,0]=o*(0.677803680186)*x_ref[0]**(o-1)+(0.493757303449)
        ref[2,0,0,1]=o*(-0.700353467324)*x_ref[1]**(o-1)+(0.713489396377)
        ref[2,0,0,2]=o*(-0.147276750564)*x_ref[2]**(o-1)+(-0.666815984705)
        ref[2,0,1,0]=o*(-0.196166170445)*x_ref[0]**(o-1)+(-0.776357160477)
        ref[2,0,1,1]=o*(0.531757851468)*x_ref[1]**(o-1)+(-0.0951663105473)
        ref[2,0,1,2]=o*(0.296695659682)*x_ref[2]**(o-1)+(0.132047740242)
        ref[2,1,0,0]=o*(0.89703218788)*x_ref[0]**(o-1)+(0.446461958293)
        ref[2,1,0,1]=o*(0.849781349832)*x_ref[1]**(o-1)+(0.495003438762)
        ref[2,1,0,2]=o*(0.200866318394)*x_ref[2]**(o-1)+(-0.239158244355)
        ref[2,1,1,0]=o*(0.699816693)*x_ref[0]**(o-1)+(-0.498016262468)
        ref[2,1,1,1]=o*(0.467212425781)*x_ref[1]**(o-1)+(0.507210685133)
        ref[2,1,1,2]=o*(0.872000089805)*x_ref[2]**(o-1)+(-0.608415132584)
        ref[3,0,0,0]=o*(-0.858779999521)*x_ref[0]**(o-1)+(-0.934307938564)
        ref[3,0,0,1]=o*(0.998531969194)*x_ref[1]**(o-1)+(-0.10694369616)
        ref[3,0,0,2]=o*(0.565515051636)*x_ref[2]**(o-1)+(-0.340328286843)
        ref[3,0,1,0]=o*(-0.734447160975)*x_ref[0]**(o-1)+(0.592969337009)
        ref[3,0,1,1]=o*(0.769648460523)*x_ref[1]**(o-1)+(0.939994123398)
        ref[3,0,1,2]=o*(-0.14168879251)*x_ref[2]**(o-1)+(-0.151602759825)
        ref[3,1,0,0]=o*(-0.204447368694)*x_ref[0]**(o-1)+(-0.149512701586)
        ref[3,1,0,1]=o*(0.496643987821)*x_ref[1]**(o-1)+(0.137154021271)
        ref[3,1,0,2]=o*(-0.207451973465)*x_ref[2]**(o-1)+(0.976289933313)
        ref[3,1,1,0]=o*(-0.498939396392)*x_ref[0]**(o-1)+(-0.388761371521)
        ref[3,1,1,1]=o*(0.918876234523)*x_ref[1]**(o-1)+(0.326334103437)
        ref[3,1,1,2]=o*(0.135801853065)*x_ref[2]**(o-1)+(-0.513268577694)
        ref[4,0,0,0]=o*(0.383369953978)*x_ref[0]**(o-1)+(0.262190952188)
        ref[4,0,0,1]=o*(0.226913840907)*x_ref[1]**(o-1)+(0.625767074123)
        ref[4,0,0,2]=o*(0.0736409418752)*x_ref[2]**(o-1)+(-0.681643359069)
        ref[4,0,1,0]=o*(-0.00395633017219)*x_ref[0]**(o-1)+(0.103598757494)
        ref[4,0,1,1]=o*(0.245388867438)*x_ref[1]**(o-1)+(0.0199139065324)
        ref[4,0,1,2]=o*(-0.85935209669)*x_ref[2]**(o-1)+(0.780770429677)
        ref[4,1,0,0]=o*(0.93284113054)*x_ref[0]**(o-1)+(0.192867707515)
        ref[4,1,0,1]=o*(0.354258046046)*x_ref[1]**(o-1)+(0.0244899514488)
        ref[4,1,0,2]=o*(-0.00723308587137)*x_ref[2]**(o-1)+(0.724287748378)
        ref[4,1,1,0]=o*(-0.701870704251)*x_ref[0]**(o-1)+(0.29146856048)
        ref[4,1,1,1]=o*(-0.677358067691)*x_ref[1]**(o-1)+(-0.055827889309)
        ref[4,1,1,2]=o*(0.96248585097)*x_ref[2]**(o-1)+(0.100526700803)
        ref[5,0,0,0]=o*(-0.582058132348)*x_ref[0]**(o-1)+(0.5354038569)
        ref[5,0,0,1]=o*(-0.608415656952)*x_ref[1]**(o-1)+(0.700352801694)
        ref[5,0,0,2]=o*(-0.705438310252)*x_ref[2]**(o-1)+(0.969824711925)
        ref[5,0,1,0]=o*(-0.573326444971)*x_ref[0]**(o-1)+(0.00490482707944)
        ref[5,0,1,1]=o*(0.300312254171)*x_ref[1]**(o-1)+(-0.620154697788)
        ref[5,0,1,2]=o*(-0.0703788860867)*x_ref[2]**(o-1)+(-0.608567609941)
        ref[5,1,0,0]=o*(0.346782282755)*x_ref[0]**(o-1)+(-0.022146949553)
        ref[5,1,0,1]=o*(0.548359292626)*x_ref[1]**(o-1)+(0.314315074761)
        ref[5,1,0,2]=o*(0.164808336191)*x_ref[2]**(o-1)+(-0.983018613943)
        ref[5,1,1,0]=o*(-0.357126808896)*x_ref[0]**(o-1)+(0.547191129837)
        ref[5,1,1,1]=o*(-0.0128153418859)*x_ref[1]**(o-1)+(-0.199507147279)
        ref[5,1,1,2]=o*(-0.637546467191)*x_ref[2]**(o-1)+(0.65056997574)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnContactOne_fromData_ReducedSolution_rank0(self):
      """
      tests gradient for rank 0 Data on the ReducedFunctionOnContactOne

      assumptions: ReducedSolution(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnContactOne
      """
      o=1
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=ReducedSolution(self.domain)
      x=w.getX()
      arg=Data(0,(),w)
      ref=Data(0,()+(dim,),w_ref)
      if dim==2:
        arg=(0.694260485776)*x[0]+(1.46246375886)*x[1]
        ref[0]=(0.694260485776)
        ref[1]=(1.46246375886)
      else:
        arg=(-1.10912081576)*x[0]+(1.19790363484)*x[1]+(0.555862453192)*x[2]
        ref[0]=(-1.10912081576)
        ref[1]=(1.19790363484)
        ref[2]=(0.555862453192)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),()+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnContactOne_fromData_ReducedSolution_rank1(self):
      """
      tests gradient for rank 1 Data on the ReducedFunctionOnContactOne

      assumptions: ReducedSolution(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnContactOne
      """
      o=1
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=ReducedSolution(self.domain)
      x=w.getX()
      arg=Data(0,(2,),w)
      ref=Data(0,(2,)+(dim,),w_ref)
      if dim==2:
        arg[0]=(-0.0963683715208)*x[0]+(-0.985421300426)*x[1]
        arg[1]=(0.50107481561)*x[0]+(0.296191075154)*x[1]
        ref[0,0]=(-0.0963683715208)
        ref[0,1]=(-0.985421300426)
        ref[1,0]=(0.50107481561)
        ref[1,1]=(0.296191075154)
      else:
        arg[0]=(0.790729361248)*x[0]+(0.3673431791)*x[1]+(0.031915702612)*x[2]
        arg[1]=(-0.218629391175)*x[0]+(-0.0619831001578)*x[1]+(-1.46460054046)*x[2]
        ref[0,0]=(0.790729361248)
        ref[0,1]=(0.3673431791)
        ref[0,2]=(0.031915702612)
        ref[1,0]=(-0.218629391175)
        ref[1,1]=(-0.0619831001578)
        ref[1,2]=(-1.46460054046)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnContactOne_fromData_ReducedSolution_rank2(self):
      """
      tests gradient for rank 2 Data on the ReducedFunctionOnContactOne

      assumptions: ReducedSolution(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnContactOne
      """
      o=1
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=ReducedSolution(self.domain)
      x=w.getX()
      arg=Data(0,(4, 5),w)
      ref=Data(0,(4, 5)+(dim,),w_ref)
      if dim==2:
        arg[0,0]=(0.102266041928)*x[0]+(0.962985129019)*x[1]
        arg[0,1]=(1.22474578409)*x[0]+(-0.211640772922)*x[1]
        arg[0,2]=(-0.51306749275)*x[0]+(0.652502950912)*x[1]
        arg[0,3]=(1.89516926008)*x[0]+(0.317996805009)*x[1]
        arg[0,4]=(0.562531430083)*x[0]+(-0.194650166716)*x[1]
        arg[1,0]=(0.344353002434)*x[0]+(-0.830671914713)*x[1]
        arg[1,1]=(0.984363231775)*x[0]+(-0.0773767796506)*x[1]
        arg[1,2]=(-0.893978692143)*x[0]+(1.43362006873)*x[1]
        arg[1,3]=(0.603459290036)*x[0]+(-0.527471281229)*x[1]
        arg[1,4]=(-0.768879816113)*x[0]+(0.670739267079)*x[1]
        arg[2,0]=(0.466692398942)*x[0]+(-0.315362658981)*x[1]
        arg[2,1]=(1.30065290708)*x[0]+(-0.202369755569)*x[1]
        arg[2,2]=(-0.114571246331)*x[0]+(1.30250121342)*x[1]
        arg[2,3]=(-0.243608494456)*x[0]+(-0.103398411275)*x[1]
        arg[2,4]=(-0.262568543724)*x[0]+(-0.23979204654)*x[1]
        arg[3,0]=(0.0334727960327)*x[0]+(-0.24547366383)*x[1]
        arg[3,1]=(0.829837477348)*x[0]+(-0.416646135702)*x[1]
        arg[3,2]=(1.43081322579)*x[0]+(0.574724874607)*x[1]
        arg[3,3]=(1.16303985686)*x[0]+(-0.915348714324)*x[1]
        arg[3,4]=(0.773764690591)*x[0]+(0.28049189996)*x[1]
        ref[0,0,0]=(0.102266041928)
        ref[0,0,1]=(0.962985129019)
        ref[0,1,0]=(1.22474578409)
        ref[0,1,1]=(-0.211640772922)
        ref[0,2,0]=(-0.51306749275)
        ref[0,2,1]=(0.652502950912)
        ref[0,3,0]=(1.89516926008)
        ref[0,3,1]=(0.317996805009)
        ref[0,4,0]=(0.562531430083)
        ref[0,4,1]=(-0.194650166716)
        ref[1,0,0]=(0.344353002434)
        ref[1,0,1]=(-0.830671914713)
        ref[1,1,0]=(0.984363231775)
        ref[1,1,1]=(-0.0773767796506)
        ref[1,2,0]=(-0.893978692143)
        ref[1,2,1]=(1.43362006873)
        ref[1,3,0]=(0.603459290036)
        ref[1,3,1]=(-0.527471281229)
        ref[1,4,0]=(-0.768879816113)
        ref[1,4,1]=(0.670739267079)
        ref[2,0,0]=(0.466692398942)
        ref[2,0,1]=(-0.315362658981)
        ref[2,1,0]=(1.30065290708)
        ref[2,1,1]=(-0.202369755569)
        ref[2,2,0]=(-0.114571246331)
        ref[2,2,1]=(1.30250121342)
        ref[2,3,0]=(-0.243608494456)
        ref[2,3,1]=(-0.103398411275)
        ref[2,4,0]=(-0.262568543724)
        ref[2,4,1]=(-0.23979204654)
        ref[3,0,0]=(0.0334727960327)
        ref[3,0,1]=(-0.24547366383)
        ref[3,1,0]=(0.829837477348)
        ref[3,1,1]=(-0.416646135702)
        ref[3,2,0]=(1.43081322579)
        ref[3,2,1]=(0.574724874607)
        ref[3,3,0]=(1.16303985686)
        ref[3,3,1]=(-0.915348714324)
        ref[3,4,0]=(0.773764690591)
        ref[3,4,1]=(0.28049189996)
      else:
        arg[0,0]=(-0.998409457516)*x[0]+(0.374200474533)*x[1]+(-0.397603453862)*x[2]
        arg[0,1]=(-1.48600938216)*x[0]+(1.46358462866)*x[1]+(-0.393381462291)*x[2]
        arg[0,2]=(1.08201727329)*x[0]+(0.065185376372)*x[1]+(-1.32483264357)*x[2]
        arg[0,3]=(-0.518441162)*x[0]+(0.364373161676)*x[1]+(-1.25875574919)*x[2]
        arg[0,4]=(-0.836980279478)*x[0]+(1.21655914685)*x[1]+(0.1586084291)*x[2]
        arg[1,0]=(0.760774732939)*x[0]+(0.515414129191)*x[1]+(-1.50192024303)*x[2]
        arg[1,1]=(-0.653360330499)*x[0]+(1.71417096347)*x[1]+(-0.169129173291)*x[2]
        arg[1,2]=(1.07221333767)*x[0]+(-1.07638348405)*x[1]+(1.13393461135)*x[2]
        arg[1,3]=(0.847567825055)*x[0]+(-0.0298335468796)*x[1]+(0.45122717832)*x[2]
        arg[1,4]=(-0.108027217492)*x[0]+(-1.12654142913)*x[1]+(-0.781718943065)*x[2]
        arg[2,0]=(0.408863322164)*x[0]+(0.100914804776)*x[1]+(-0.471567638444)*x[2]
        arg[2,1]=(-1.42194256762)*x[0]+(-0.348217894465)*x[1]+(-0.830561377367)*x[2]
        arg[2,2]=(1.36876795155)*x[0]+(0.125252389466)*x[1]+(0.00641454191902)*x[2]
        arg[2,3]=(0.135243193372)*x[0]+(-1.04394510102)*x[1]+(0.0223029076973)*x[2]
        arg[2,4]=(-0.969785158394)*x[0]+(-0.48178611106)*x[1]+(-0.0556576599006)*x[2]
        arg[3,0]=(1.39484073703)*x[0]+(-1.0132109886)*x[1]+(0.0205156989927)*x[2]
        arg[3,1]=(-0.92783313898)*x[0]+(-1.27904129731)*x[1]+(-0.817768402689)*x[2]
        arg[3,2]=(1.21718392423)*x[0]+(-0.984091647405)*x[1]+(0.458009888947)*x[2]
        arg[3,3]=(-0.812990754761)*x[0]+(-0.104941245044)*x[1]+(-0.996531826869)*x[2]
        arg[3,4]=(-0.28581988131)*x[0]+(-1.24321114539)*x[1]+(0.408464222517)*x[2]
        ref[0,0,0]=(-0.998409457516)
        ref[0,0,1]=(0.374200474533)
        ref[0,0,2]=(-0.397603453862)
        ref[0,1,0]=(-1.48600938216)
        ref[0,1,1]=(1.46358462866)
        ref[0,1,2]=(-0.393381462291)
        ref[0,2,0]=(1.08201727329)
        ref[0,2,1]=(0.065185376372)
        ref[0,2,2]=(-1.32483264357)
        ref[0,3,0]=(-0.518441162)
        ref[0,3,1]=(0.364373161676)
        ref[0,3,2]=(-1.25875574919)
        ref[0,4,0]=(-0.836980279478)
        ref[0,4,1]=(1.21655914685)
        ref[0,4,2]=(0.1586084291)
        ref[1,0,0]=(0.760774732939)
        ref[1,0,1]=(0.515414129191)
        ref[1,0,2]=(-1.50192024303)
        ref[1,1,0]=(-0.653360330499)
        ref[1,1,1]=(1.71417096347)
        ref[1,1,2]=(-0.169129173291)
        ref[1,2,0]=(1.07221333767)
        ref[1,2,1]=(-1.07638348405)
        ref[1,2,2]=(1.13393461135)
        ref[1,3,0]=(0.847567825055)
        ref[1,3,1]=(-0.0298335468796)
        ref[1,3,2]=(0.45122717832)
        ref[1,4,0]=(-0.108027217492)
        ref[1,4,1]=(-1.12654142913)
        ref[1,4,2]=(-0.781718943065)
        ref[2,0,0]=(0.408863322164)
        ref[2,0,1]=(0.100914804776)
        ref[2,0,2]=(-0.471567638444)
        ref[2,1,0]=(-1.42194256762)
        ref[2,1,1]=(-0.348217894465)
        ref[2,1,2]=(-0.830561377367)
        ref[2,2,0]=(1.36876795155)
        ref[2,2,1]=(0.125252389466)
        ref[2,2,2]=(0.00641454191902)
        ref[2,3,0]=(0.135243193372)
        ref[2,3,1]=(-1.04394510102)
        ref[2,3,2]=(0.0223029076973)
        ref[2,4,0]=(-0.969785158394)
        ref[2,4,1]=(-0.48178611106)
        ref[2,4,2]=(-0.0556576599006)
        ref[3,0,0]=(1.39484073703)
        ref[3,0,1]=(-1.0132109886)
        ref[3,0,2]=(0.0205156989927)
        ref[3,1,0]=(-0.92783313898)
        ref[3,1,1]=(-1.27904129731)
        ref[3,1,2]=(-0.817768402689)
        ref[3,2,0]=(1.21718392423)
        ref[3,2,1]=(-0.984091647405)
        ref[3,2,2]=(0.458009888947)
        ref[3,3,0]=(-0.812990754761)
        ref[3,3,1]=(-0.104941245044)
        ref[3,3,2]=(-0.996531826869)
        ref[3,4,0]=(-0.28581988131)
        ref[3,4,1]=(-1.24321114539)
        ref[3,4,2]=(0.408464222517)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnContactOne_fromData_ReducedSolution_rank3(self):
      """
      tests gradient for rank 3 Data on the ReducedFunctionOnContactOne

      assumptions: ReducedSolution(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnContactOne
      """
      o=1
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=ReducedSolution(self.domain)
      x=w.getX()
      arg=Data(0,(6, 2, 2),w)
      ref=Data(0,(6, 2, 2)+(dim,),w_ref)
      if dim==2:
        arg[0,0,0]=(0.39712204981)*x[0]+(-1.36315938849)*x[1]
        arg[0,0,1]=(0.654450268666)*x[0]+(-0.198258834351)*x[1]
        arg[0,1,0]=(0.21357757124)*x[0]+(0.193878132191)*x[1]
        arg[0,1,1]=(0.0762258436603)*x[0]+(-0.33284111684)*x[1]
        arg[1,0,0]=(-0.264232939297)*x[0]+(-0.726336076701)*x[1]
        arg[1,0,1]=(-0.179928817534)*x[0]+(-0.723247805844)*x[1]
        arg[1,1,0]=(0.923289681593)*x[0]+(0.986763135255)*x[1]
        arg[1,1,1]=(0.065387254507)*x[0]+(-0.710965008545)*x[1]
        arg[2,0,0]=(0.759853961917)*x[0]+(0.24486573839)*x[1]
        arg[2,0,1]=(-0.318336679378)*x[0]+(0.39328274922)*x[1]
        arg[2,1,0]=(-1.562818948)*x[0]+(-0.891340974738)*x[1]
        arg[2,1,1]=(0.0508006116584)*x[0]+(1.17654134987)*x[1]
        arg[3,0,0]=(-0.155883472458)*x[0]+(0.248809866836)*x[1]
        arg[3,0,1]=(0.287794710222)*x[0]+(-1.72525392296)*x[1]
        arg[3,1,0]=(0.00665202042795)*x[0]+(-0.0996395796968)*x[1]
        arg[3,1,1]=(-0.19809021298)*x[0]+(0.487549616652)*x[1]
        arg[4,0,0]=(0.764163773078)*x[0]+(-0.898694486894)*x[1]
        arg[4,0,1]=(-0.213042355119)*x[0]+(0.708925705544)*x[1]
        arg[4,1,0]=(1.55505564031)*x[0]+(-0.545746649289)*x[1]
        arg[4,1,1]=(-1.31623592165)*x[0]+(0.948772953354)*x[1]
        arg[5,0,0]=(0.221103671977)*x[0]+(0.866067107464)*x[1]
        arg[5,0,1]=(-0.0979530612779)*x[0]+(-0.371623102578)*x[1]
        arg[5,1,0]=(-0.348963169972)*x[0]+(-0.692055450872)*x[1]
        arg[5,1,1]=(-0.584053243695)*x[0]+(-0.487768032842)*x[1]
        ref[0,0,0,0]=(0.39712204981)
        ref[0,0,0,1]=(-1.36315938849)
        ref[0,0,1,0]=(0.654450268666)
        ref[0,0,1,1]=(-0.198258834351)
        ref[0,1,0,0]=(0.21357757124)
        ref[0,1,0,1]=(0.193878132191)
        ref[0,1,1,0]=(0.0762258436603)
        ref[0,1,1,1]=(-0.33284111684)
        ref[1,0,0,0]=(-0.264232939297)
        ref[1,0,0,1]=(-0.726336076701)
        ref[1,0,1,0]=(-0.179928817534)
        ref[1,0,1,1]=(-0.723247805844)
        ref[1,1,0,0]=(0.923289681593)
        ref[1,1,0,1]=(0.986763135255)
        ref[1,1,1,0]=(0.065387254507)
        ref[1,1,1,1]=(-0.710965008545)
        ref[2,0,0,0]=(0.759853961917)
        ref[2,0,0,1]=(0.24486573839)
        ref[2,0,1,0]=(-0.318336679378)
        ref[2,0,1,1]=(0.39328274922)
        ref[2,1,0,0]=(-1.562818948)
        ref[2,1,0,1]=(-0.891340974738)
        ref[2,1,1,0]=(0.0508006116584)
        ref[2,1,1,1]=(1.17654134987)
        ref[3,0,0,0]=(-0.155883472458)
        ref[3,0,0,1]=(0.248809866836)
        ref[3,0,1,0]=(0.287794710222)
        ref[3,0,1,1]=(-1.72525392296)
        ref[3,1,0,0]=(0.00665202042795)
        ref[3,1,0,1]=(-0.0996395796968)
        ref[3,1,1,0]=(-0.19809021298)
        ref[3,1,1,1]=(0.487549616652)
        ref[4,0,0,0]=(0.764163773078)
        ref[4,0,0,1]=(-0.898694486894)
        ref[4,0,1,0]=(-0.213042355119)
        ref[4,0,1,1]=(0.708925705544)
        ref[4,1,0,0]=(1.55505564031)
        ref[4,1,0,1]=(-0.545746649289)
        ref[4,1,1,0]=(-1.31623592165)
        ref[4,1,1,1]=(0.948772953354)
        ref[5,0,0,0]=(0.221103671977)
        ref[5,0,0,1]=(0.866067107464)
        ref[5,0,1,0]=(-0.0979530612779)
        ref[5,0,1,1]=(-0.371623102578)
        ref[5,1,0,0]=(-0.348963169972)
        ref[5,1,0,1]=(-0.692055450872)
        ref[5,1,1,0]=(-0.584053243695)
        ref[5,1,1,1]=(-0.487768032842)
      else:
        arg[0,0,0]=(-1.45023987007)*x[0]+(0.138479134523)*x[1]+(1.46404607112)*x[2]
        arg[0,0,1]=(-0.647908832568)*x[0]+(-0.503758830859)*x[1]+(1.23196203665)*x[2]
        arg[0,1,0]=(-0.0108286161243)*x[0]+(0.565615928686)*x[1]+(-0.357789821636)*x[2]
        arg[0,1,1]=(0.648224572901)*x[0]+(0.775857442933)*x[1]+(0.960991462312)*x[2]
        arg[1,0,0]=(0.340590670624)*x[0]+(0.0357759349963)*x[1]+(0.358139256621)*x[2]
        arg[1,0,1]=(0.569789735109)*x[0]+(1.40678949618)*x[1]+(-0.965577726422)*x[2]
        arg[1,1,0]=(-0.758717082212)*x[0]+(0.612968081377)*x[1]+(-0.417988159948)*x[2]
        arg[1,1,1]=(0.969867032567)*x[0]+(-0.0700234825891)*x[1]+(1.53879850558)*x[2]
        arg[2,0,0]=(-1.02952648125)*x[0]+(0.108642437375)*x[1]+(0.251073184196)*x[2]
        arg[2,0,1]=(0.794766888909)*x[0]+(1.50591346365)*x[1]+(-0.36870578891)*x[2]
        arg[2,1,0]=(-0.534487055503)*x[0]+(-1.09061679233)*x[1]+(0.799342633685)*x[2]
        arg[2,1,1]=(0.0435889213805)*x[0]+(-0.209888628166)*x[1]+(1.34633215915)*x[2]
        arg[3,0,0]=(-0.0344682106376)*x[0]+(-0.92386569455)*x[1]+(-0.551250384619)*x[2]
        arg[3,0,1]=(-0.168599962689)*x[0]+(0.204634495314)*x[1]+(-0.65426520271)*x[2]
        arg[3,1,0]=(-1.61759210628)*x[0]+(-0.5922211067)*x[1]+(-0.139092780207)*x[2]
        arg[3,1,1]=(-0.13862300062)*x[0]+(-1.45951050222)*x[1]+(0.300904423579)*x[2]
        arg[4,0,0]=(0.629590770742)*x[0]+(-0.217150209985)*x[1]+(-0.140384227583)*x[2]
        arg[4,0,1]=(-0.0461635416119)*x[0]+(0.525692990183)*x[1]+(-1.89728167146)*x[2]
        arg[4,1,0]=(-0.130297059668)*x[0]+(-0.138816250007)*x[1]+(1.26805054232)*x[2]
        arg[4,1,1]=(0.742488751566)*x[0]+(0.659272799907)*x[1]+(-0.370877917078)*x[2]
        arg[5,0,0]=(-0.521350561164)*x[0]+(-0.213669151076)*x[1]+(0.00949381597317)*x[2]
        arg[5,0,1]=(-0.951547526648)*x[0]+(-0.388340895795)*x[1]+(0.741997603334)*x[2]
        arg[5,1,0]=(-0.332922940005)*x[0]+(1.74852940259)*x[1]+(-0.484189519128)*x[2]
        arg[5,1,1]=(0.418660109098)*x[0]+(-0.690728767024)*x[1]+(-0.675947375912)*x[2]
        ref[0,0,0,0]=(-1.45023987007)
        ref[0,0,0,1]=(0.138479134523)
        ref[0,0,0,2]=(1.46404607112)
        ref[0,0,1,0]=(-0.647908832568)
        ref[0,0,1,1]=(-0.503758830859)
        ref[0,0,1,2]=(1.23196203665)
        ref[0,1,0,0]=(-0.0108286161243)
        ref[0,1,0,1]=(0.565615928686)
        ref[0,1,0,2]=(-0.357789821636)
        ref[0,1,1,0]=(0.648224572901)
        ref[0,1,1,1]=(0.775857442933)
        ref[0,1,1,2]=(0.960991462312)
        ref[1,0,0,0]=(0.340590670624)
        ref[1,0,0,1]=(0.0357759349963)
        ref[1,0,0,2]=(0.358139256621)
        ref[1,0,1,0]=(0.569789735109)
        ref[1,0,1,1]=(1.40678949618)
        ref[1,0,1,2]=(-0.965577726422)
        ref[1,1,0,0]=(-0.758717082212)
        ref[1,1,0,1]=(0.612968081377)
        ref[1,1,0,2]=(-0.417988159948)
        ref[1,1,1,0]=(0.969867032567)
        ref[1,1,1,1]=(-0.0700234825891)
        ref[1,1,1,2]=(1.53879850558)
        ref[2,0,0,0]=(-1.02952648125)
        ref[2,0,0,1]=(0.108642437375)
        ref[2,0,0,2]=(0.251073184196)
        ref[2,0,1,0]=(0.794766888909)
        ref[2,0,1,1]=(1.50591346365)
        ref[2,0,1,2]=(-0.36870578891)
        ref[2,1,0,0]=(-0.534487055503)
        ref[2,1,0,1]=(-1.09061679233)
        ref[2,1,0,2]=(0.799342633685)
        ref[2,1,1,0]=(0.0435889213805)
        ref[2,1,1,1]=(-0.209888628166)
        ref[2,1,1,2]=(1.34633215915)
        ref[3,0,0,0]=(-0.0344682106376)
        ref[3,0,0,1]=(-0.92386569455)
        ref[3,0,0,2]=(-0.551250384619)
        ref[3,0,1,0]=(-0.168599962689)
        ref[3,0,1,1]=(0.204634495314)
        ref[3,0,1,2]=(-0.65426520271)
        ref[3,1,0,0]=(-1.61759210628)
        ref[3,1,0,1]=(-0.5922211067)
        ref[3,1,0,2]=(-0.139092780207)
        ref[3,1,1,0]=(-0.13862300062)
        ref[3,1,1,1]=(-1.45951050222)
        ref[3,1,1,2]=(0.300904423579)
        ref[4,0,0,0]=(0.629590770742)
        ref[4,0,0,1]=(-0.217150209985)
        ref[4,0,0,2]=(-0.140384227583)
        ref[4,0,1,0]=(-0.0461635416119)
        ref[4,0,1,1]=(0.525692990183)
        ref[4,0,1,2]=(-1.89728167146)
        ref[4,1,0,0]=(-0.130297059668)
        ref[4,1,0,1]=(-0.138816250007)
        ref[4,1,0,2]=(1.26805054232)
        ref[4,1,1,0]=(0.742488751566)
        ref[4,1,1,1]=(0.659272799907)
        ref[4,1,1,2]=(-0.370877917078)
        ref[5,0,0,0]=(-0.521350561164)
        ref[5,0,0,1]=(-0.213669151076)
        ref[5,0,0,2]=(0.00949381597317)
        ref[5,0,1,0]=(-0.951547526648)
        ref[5,0,1,1]=(-0.388340895795)
        ref[5,0,1,2]=(0.741997603334)
        ref[5,1,0,0]=(-0.332922940005)
        ref[5,1,0,1]=(1.74852940259)
        ref[5,1,0,2]=(-0.484189519128)
        ref[5,1,1,0]=(0.418660109098)
        ref[5,1,1,1]=(-0.690728767024)
        ref[5,1,1,2]=(-0.675947375912)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnContactOne_fromData_ReducedContinuousFunction_rank0(self):
      """
      tests gradient for rank 0 Data on the ReducedFunctionOnContactOne

      assumptions: ReducedContinuousFunction(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnContactOne
      """
      o=1
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=ReducedContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(),w)
      ref=Data(0,()+(dim,),w_ref)
      if dim==2:
        arg=(0.694260485776)*x[0]+(1.46246375886)*x[1]
        ref[0]=(0.694260485776)
        ref[1]=(1.46246375886)
      else:
        arg=(-1.10912081576)*x[0]+(1.19790363484)*x[1]+(0.555862453192)*x[2]
        ref[0]=(-1.10912081576)
        ref[1]=(1.19790363484)
        ref[2]=(0.555862453192)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),()+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnContactOne_fromData_ReducedContinuousFunction_rank1(self):
      """
      tests gradient for rank 1 Data on the ReducedFunctionOnContactOne

      assumptions: ReducedContinuousFunction(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnContactOne
      """
      o=1
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=ReducedContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(2,),w)
      ref=Data(0,(2,)+(dim,),w_ref)
      if dim==2:
        arg[0]=(-0.0963683715208)*x[0]+(-0.985421300426)*x[1]
        arg[1]=(0.50107481561)*x[0]+(0.296191075154)*x[1]
        ref[0,0]=(-0.0963683715208)
        ref[0,1]=(-0.985421300426)
        ref[1,0]=(0.50107481561)
        ref[1,1]=(0.296191075154)
      else:
        arg[0]=(0.790729361248)*x[0]+(0.3673431791)*x[1]+(0.031915702612)*x[2]
        arg[1]=(-0.218629391175)*x[0]+(-0.0619831001578)*x[1]+(-1.46460054046)*x[2]
        ref[0,0]=(0.790729361248)
        ref[0,1]=(0.3673431791)
        ref[0,2]=(0.031915702612)
        ref[1,0]=(-0.218629391175)
        ref[1,1]=(-0.0619831001578)
        ref[1,2]=(-1.46460054046)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnContactOne_fromData_ReducedContinuousFunction_rank2(self):
      """
      tests gradient for rank 2 Data on the ReducedFunctionOnContactOne

      assumptions: ReducedContinuousFunction(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnContactOne
      """
      o=1
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=ReducedContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(4, 5),w)
      ref=Data(0,(4, 5)+(dim,),w_ref)
      if dim==2:
        arg[0,0]=(0.102266041928)*x[0]+(0.962985129019)*x[1]
        arg[0,1]=(1.22474578409)*x[0]+(-0.211640772922)*x[1]
        arg[0,2]=(-0.51306749275)*x[0]+(0.652502950912)*x[1]
        arg[0,3]=(1.89516926008)*x[0]+(0.317996805009)*x[1]
        arg[0,4]=(0.562531430083)*x[0]+(-0.194650166716)*x[1]
        arg[1,0]=(0.344353002434)*x[0]+(-0.830671914713)*x[1]
        arg[1,1]=(0.984363231775)*x[0]+(-0.0773767796506)*x[1]
        arg[1,2]=(-0.893978692143)*x[0]+(1.43362006873)*x[1]
        arg[1,3]=(0.603459290036)*x[0]+(-0.527471281229)*x[1]
        arg[1,4]=(-0.768879816113)*x[0]+(0.670739267079)*x[1]
        arg[2,0]=(0.466692398942)*x[0]+(-0.315362658981)*x[1]
        arg[2,1]=(1.30065290708)*x[0]+(-0.202369755569)*x[1]
        arg[2,2]=(-0.114571246331)*x[0]+(1.30250121342)*x[1]
        arg[2,3]=(-0.243608494456)*x[0]+(-0.103398411275)*x[1]
        arg[2,4]=(-0.262568543724)*x[0]+(-0.23979204654)*x[1]
        arg[3,0]=(0.0334727960327)*x[0]+(-0.24547366383)*x[1]
        arg[3,1]=(0.829837477348)*x[0]+(-0.416646135702)*x[1]
        arg[3,2]=(1.43081322579)*x[0]+(0.574724874607)*x[1]
        arg[3,3]=(1.16303985686)*x[0]+(-0.915348714324)*x[1]
        arg[3,4]=(0.773764690591)*x[0]+(0.28049189996)*x[1]
        ref[0,0,0]=(0.102266041928)
        ref[0,0,1]=(0.962985129019)
        ref[0,1,0]=(1.22474578409)
        ref[0,1,1]=(-0.211640772922)
        ref[0,2,0]=(-0.51306749275)
        ref[0,2,1]=(0.652502950912)
        ref[0,3,0]=(1.89516926008)
        ref[0,3,1]=(0.317996805009)
        ref[0,4,0]=(0.562531430083)
        ref[0,4,1]=(-0.194650166716)
        ref[1,0,0]=(0.344353002434)
        ref[1,0,1]=(-0.830671914713)
        ref[1,1,0]=(0.984363231775)
        ref[1,1,1]=(-0.0773767796506)
        ref[1,2,0]=(-0.893978692143)
        ref[1,2,1]=(1.43362006873)
        ref[1,3,0]=(0.603459290036)
        ref[1,3,1]=(-0.527471281229)
        ref[1,4,0]=(-0.768879816113)
        ref[1,4,1]=(0.670739267079)
        ref[2,0,0]=(0.466692398942)
        ref[2,0,1]=(-0.315362658981)
        ref[2,1,0]=(1.30065290708)
        ref[2,1,1]=(-0.202369755569)
        ref[2,2,0]=(-0.114571246331)
        ref[2,2,1]=(1.30250121342)
        ref[2,3,0]=(-0.243608494456)
        ref[2,3,1]=(-0.103398411275)
        ref[2,4,0]=(-0.262568543724)
        ref[2,4,1]=(-0.23979204654)
        ref[3,0,0]=(0.0334727960327)
        ref[3,0,1]=(-0.24547366383)
        ref[3,1,0]=(0.829837477348)
        ref[3,1,1]=(-0.416646135702)
        ref[3,2,0]=(1.43081322579)
        ref[3,2,1]=(0.574724874607)
        ref[3,3,0]=(1.16303985686)
        ref[3,3,1]=(-0.915348714324)
        ref[3,4,0]=(0.773764690591)
        ref[3,4,1]=(0.28049189996)
      else:
        arg[0,0]=(-0.998409457516)*x[0]+(0.374200474533)*x[1]+(-0.397603453862)*x[2]
        arg[0,1]=(-1.48600938216)*x[0]+(1.46358462866)*x[1]+(-0.393381462291)*x[2]
        arg[0,2]=(1.08201727329)*x[0]+(0.065185376372)*x[1]+(-1.32483264357)*x[2]
        arg[0,3]=(-0.518441162)*x[0]+(0.364373161676)*x[1]+(-1.25875574919)*x[2]
        arg[0,4]=(-0.836980279478)*x[0]+(1.21655914685)*x[1]+(0.1586084291)*x[2]
        arg[1,0]=(0.760774732939)*x[0]+(0.515414129191)*x[1]+(-1.50192024303)*x[2]
        arg[1,1]=(-0.653360330499)*x[0]+(1.71417096347)*x[1]+(-0.169129173291)*x[2]
        arg[1,2]=(1.07221333767)*x[0]+(-1.07638348405)*x[1]+(1.13393461135)*x[2]
        arg[1,3]=(0.847567825055)*x[0]+(-0.0298335468796)*x[1]+(0.45122717832)*x[2]
        arg[1,4]=(-0.108027217492)*x[0]+(-1.12654142913)*x[1]+(-0.781718943065)*x[2]
        arg[2,0]=(0.408863322164)*x[0]+(0.100914804776)*x[1]+(-0.471567638444)*x[2]
        arg[2,1]=(-1.42194256762)*x[0]+(-0.348217894465)*x[1]+(-0.830561377367)*x[2]
        arg[2,2]=(1.36876795155)*x[0]+(0.125252389466)*x[1]+(0.00641454191902)*x[2]
        arg[2,3]=(0.135243193372)*x[0]+(-1.04394510102)*x[1]+(0.0223029076973)*x[2]
        arg[2,4]=(-0.969785158394)*x[0]+(-0.48178611106)*x[1]+(-0.0556576599006)*x[2]
        arg[3,0]=(1.39484073703)*x[0]+(-1.0132109886)*x[1]+(0.0205156989927)*x[2]
        arg[3,1]=(-0.92783313898)*x[0]+(-1.27904129731)*x[1]+(-0.817768402689)*x[2]
        arg[3,2]=(1.21718392423)*x[0]+(-0.984091647405)*x[1]+(0.458009888947)*x[2]
        arg[3,3]=(-0.812990754761)*x[0]+(-0.104941245044)*x[1]+(-0.996531826869)*x[2]
        arg[3,4]=(-0.28581988131)*x[0]+(-1.24321114539)*x[1]+(0.408464222517)*x[2]
        ref[0,0,0]=(-0.998409457516)
        ref[0,0,1]=(0.374200474533)
        ref[0,0,2]=(-0.397603453862)
        ref[0,1,0]=(-1.48600938216)
        ref[0,1,1]=(1.46358462866)
        ref[0,1,2]=(-0.393381462291)
        ref[0,2,0]=(1.08201727329)
        ref[0,2,1]=(0.065185376372)
        ref[0,2,2]=(-1.32483264357)
        ref[0,3,0]=(-0.518441162)
        ref[0,3,1]=(0.364373161676)
        ref[0,3,2]=(-1.25875574919)
        ref[0,4,0]=(-0.836980279478)
        ref[0,4,1]=(1.21655914685)
        ref[0,4,2]=(0.1586084291)
        ref[1,0,0]=(0.760774732939)
        ref[1,0,1]=(0.515414129191)
        ref[1,0,2]=(-1.50192024303)
        ref[1,1,0]=(-0.653360330499)
        ref[1,1,1]=(1.71417096347)
        ref[1,1,2]=(-0.169129173291)
        ref[1,2,0]=(1.07221333767)
        ref[1,2,1]=(-1.07638348405)
        ref[1,2,2]=(1.13393461135)
        ref[1,3,0]=(0.847567825055)
        ref[1,3,1]=(-0.0298335468796)
        ref[1,3,2]=(0.45122717832)
        ref[1,4,0]=(-0.108027217492)
        ref[1,4,1]=(-1.12654142913)
        ref[1,4,2]=(-0.781718943065)
        ref[2,0,0]=(0.408863322164)
        ref[2,0,1]=(0.100914804776)
        ref[2,0,2]=(-0.471567638444)
        ref[2,1,0]=(-1.42194256762)
        ref[2,1,1]=(-0.348217894465)
        ref[2,1,2]=(-0.830561377367)
        ref[2,2,0]=(1.36876795155)
        ref[2,2,1]=(0.125252389466)
        ref[2,2,2]=(0.00641454191902)
        ref[2,3,0]=(0.135243193372)
        ref[2,3,1]=(-1.04394510102)
        ref[2,3,2]=(0.0223029076973)
        ref[2,4,0]=(-0.969785158394)
        ref[2,4,1]=(-0.48178611106)
        ref[2,4,2]=(-0.0556576599006)
        ref[3,0,0]=(1.39484073703)
        ref[3,0,1]=(-1.0132109886)
        ref[3,0,2]=(0.0205156989927)
        ref[3,1,0]=(-0.92783313898)
        ref[3,1,1]=(-1.27904129731)
        ref[3,1,2]=(-0.817768402689)
        ref[3,2,0]=(1.21718392423)
        ref[3,2,1]=(-0.984091647405)
        ref[3,2,2]=(0.458009888947)
        ref[3,3,0]=(-0.812990754761)
        ref[3,3,1]=(-0.104941245044)
        ref[3,3,2]=(-0.996531826869)
        ref[3,4,0]=(-0.28581988131)
        ref[3,4,1]=(-1.24321114539)
        ref[3,4,2]=(0.408464222517)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_grad_onReducedFunctionOnContactOne_fromData_ReducedContinuousFunction_rank3(self):
      """
      tests gradient for rank 3 Data on the ReducedFunctionOnContactOne

      assumptions: ReducedContinuousFunction(self.domain) exists
                   self.domain supports gradient on ReducedFunctionOnContactOne
      """
      o=1
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=ReducedContinuousFunction(self.domain)
      x=w.getX()
      arg=Data(0,(6, 2, 2),w)
      ref=Data(0,(6, 2, 2)+(dim,),w_ref)
      if dim==2:
        arg[0,0,0]=(0.39712204981)*x[0]+(-1.36315938849)*x[1]
        arg[0,0,1]=(0.654450268666)*x[0]+(-0.198258834351)*x[1]
        arg[0,1,0]=(0.21357757124)*x[0]+(0.193878132191)*x[1]
        arg[0,1,1]=(0.0762258436603)*x[0]+(-0.33284111684)*x[1]
        arg[1,0,0]=(-0.264232939297)*x[0]+(-0.726336076701)*x[1]
        arg[1,0,1]=(-0.179928817534)*x[0]+(-0.723247805844)*x[1]
        arg[1,1,0]=(0.923289681593)*x[0]+(0.986763135255)*x[1]
        arg[1,1,1]=(0.065387254507)*x[0]+(-0.710965008545)*x[1]
        arg[2,0,0]=(0.759853961917)*x[0]+(0.24486573839)*x[1]
        arg[2,0,1]=(-0.318336679378)*x[0]+(0.39328274922)*x[1]
        arg[2,1,0]=(-1.562818948)*x[0]+(-0.891340974738)*x[1]
        arg[2,1,1]=(0.0508006116584)*x[0]+(1.17654134987)*x[1]
        arg[3,0,0]=(-0.155883472458)*x[0]+(0.248809866836)*x[1]
        arg[3,0,1]=(0.287794710222)*x[0]+(-1.72525392296)*x[1]
        arg[3,1,0]=(0.00665202042795)*x[0]+(-0.0996395796968)*x[1]
        arg[3,1,1]=(-0.19809021298)*x[0]+(0.487549616652)*x[1]
        arg[4,0,0]=(0.764163773078)*x[0]+(-0.898694486894)*x[1]
        arg[4,0,1]=(-0.213042355119)*x[0]+(0.708925705544)*x[1]
        arg[4,1,0]=(1.55505564031)*x[0]+(-0.545746649289)*x[1]
        arg[4,1,1]=(-1.31623592165)*x[0]+(0.948772953354)*x[1]
        arg[5,0,0]=(0.221103671977)*x[0]+(0.866067107464)*x[1]
        arg[5,0,1]=(-0.0979530612779)*x[0]+(-0.371623102578)*x[1]
        arg[5,1,0]=(-0.348963169972)*x[0]+(-0.692055450872)*x[1]
        arg[5,1,1]=(-0.584053243695)*x[0]+(-0.487768032842)*x[1]
        ref[0,0,0,0]=(0.39712204981)
        ref[0,0,0,1]=(-1.36315938849)
        ref[0,0,1,0]=(0.654450268666)
        ref[0,0,1,1]=(-0.198258834351)
        ref[0,1,0,0]=(0.21357757124)
        ref[0,1,0,1]=(0.193878132191)
        ref[0,1,1,0]=(0.0762258436603)
        ref[0,1,1,1]=(-0.33284111684)
        ref[1,0,0,0]=(-0.264232939297)
        ref[1,0,0,1]=(-0.726336076701)
        ref[1,0,1,0]=(-0.179928817534)
        ref[1,0,1,1]=(-0.723247805844)
        ref[1,1,0,0]=(0.923289681593)
        ref[1,1,0,1]=(0.986763135255)
        ref[1,1,1,0]=(0.065387254507)
        ref[1,1,1,1]=(-0.710965008545)
        ref[2,0,0,0]=(0.759853961917)
        ref[2,0,0,1]=(0.24486573839)
        ref[2,0,1,0]=(-0.318336679378)
        ref[2,0,1,1]=(0.39328274922)
        ref[2,1,0,0]=(-1.562818948)
        ref[2,1,0,1]=(-0.891340974738)
        ref[2,1,1,0]=(0.0508006116584)
        ref[2,1,1,1]=(1.17654134987)
        ref[3,0,0,0]=(-0.155883472458)
        ref[3,0,0,1]=(0.248809866836)
        ref[3,0,1,0]=(0.287794710222)
        ref[3,0,1,1]=(-1.72525392296)
        ref[3,1,0,0]=(0.00665202042795)
        ref[3,1,0,1]=(-0.0996395796968)
        ref[3,1,1,0]=(-0.19809021298)
        ref[3,1,1,1]=(0.487549616652)
        ref[4,0,0,0]=(0.764163773078)
        ref[4,0,0,1]=(-0.898694486894)
        ref[4,0,1,0]=(-0.213042355119)
        ref[4,0,1,1]=(0.708925705544)
        ref[4,1,0,0]=(1.55505564031)
        ref[4,1,0,1]=(-0.545746649289)
        ref[4,1,1,0]=(-1.31623592165)
        ref[4,1,1,1]=(0.948772953354)
        ref[5,0,0,0]=(0.221103671977)
        ref[5,0,0,1]=(0.866067107464)
        ref[5,0,1,0]=(-0.0979530612779)
        ref[5,0,1,1]=(-0.371623102578)
        ref[5,1,0,0]=(-0.348963169972)
        ref[5,1,0,1]=(-0.692055450872)
        ref[5,1,1,0]=(-0.584053243695)
        ref[5,1,1,1]=(-0.487768032842)
      else:
        arg[0,0,0]=(-1.45023987007)*x[0]+(0.138479134523)*x[1]+(1.46404607112)*x[2]
        arg[0,0,1]=(-0.647908832568)*x[0]+(-0.503758830859)*x[1]+(1.23196203665)*x[2]
        arg[0,1,0]=(-0.0108286161243)*x[0]+(0.565615928686)*x[1]+(-0.357789821636)*x[2]
        arg[0,1,1]=(0.648224572901)*x[0]+(0.775857442933)*x[1]+(0.960991462312)*x[2]
        arg[1,0,0]=(0.340590670624)*x[0]+(0.0357759349963)*x[1]+(0.358139256621)*x[2]
        arg[1,0,1]=(0.569789735109)*x[0]+(1.40678949618)*x[1]+(-0.965577726422)*x[2]
        arg[1,1,0]=(-0.758717082212)*x[0]+(0.612968081377)*x[1]+(-0.417988159948)*x[2]
        arg[1,1,1]=(0.969867032567)*x[0]+(-0.0700234825891)*x[1]+(1.53879850558)*x[2]
        arg[2,0,0]=(-1.02952648125)*x[0]+(0.108642437375)*x[1]+(0.251073184196)*x[2]
        arg[2,0,1]=(0.794766888909)*x[0]+(1.50591346365)*x[1]+(-0.36870578891)*x[2]
        arg[2,1,0]=(-0.534487055503)*x[0]+(-1.09061679233)*x[1]+(0.799342633685)*x[2]
        arg[2,1,1]=(0.0435889213805)*x[0]+(-0.209888628166)*x[1]+(1.34633215915)*x[2]
        arg[3,0,0]=(-0.0344682106376)*x[0]+(-0.92386569455)*x[1]+(-0.551250384619)*x[2]
        arg[3,0,1]=(-0.168599962689)*x[0]+(0.204634495314)*x[1]+(-0.65426520271)*x[2]
        arg[3,1,0]=(-1.61759210628)*x[0]+(-0.5922211067)*x[1]+(-0.139092780207)*x[2]
        arg[3,1,1]=(-0.13862300062)*x[0]+(-1.45951050222)*x[1]+(0.300904423579)*x[2]
        arg[4,0,0]=(0.629590770742)*x[0]+(-0.217150209985)*x[1]+(-0.140384227583)*x[2]
        arg[4,0,1]=(-0.0461635416119)*x[0]+(0.525692990183)*x[1]+(-1.89728167146)*x[2]
        arg[4,1,0]=(-0.130297059668)*x[0]+(-0.138816250007)*x[1]+(1.26805054232)*x[2]
        arg[4,1,1]=(0.742488751566)*x[0]+(0.659272799907)*x[1]+(-0.370877917078)*x[2]
        arg[5,0,0]=(-0.521350561164)*x[0]+(-0.213669151076)*x[1]+(0.00949381597317)*x[2]
        arg[5,0,1]=(-0.951547526648)*x[0]+(-0.388340895795)*x[1]+(0.741997603334)*x[2]
        arg[5,1,0]=(-0.332922940005)*x[0]+(1.74852940259)*x[1]+(-0.484189519128)*x[2]
        arg[5,1,1]=(0.418660109098)*x[0]+(-0.690728767024)*x[1]+(-0.675947375912)*x[2]
        ref[0,0,0,0]=(-1.45023987007)
        ref[0,0,0,1]=(0.138479134523)
        ref[0,0,0,2]=(1.46404607112)
        ref[0,0,1,0]=(-0.647908832568)
        ref[0,0,1,1]=(-0.503758830859)
        ref[0,0,1,2]=(1.23196203665)
        ref[0,1,0,0]=(-0.0108286161243)
        ref[0,1,0,1]=(0.565615928686)
        ref[0,1,0,2]=(-0.357789821636)
        ref[0,1,1,0]=(0.648224572901)
        ref[0,1,1,1]=(0.775857442933)
        ref[0,1,1,2]=(0.960991462312)
        ref[1,0,0,0]=(0.340590670624)
        ref[1,0,0,1]=(0.0357759349963)
        ref[1,0,0,2]=(0.358139256621)
        ref[1,0,1,0]=(0.569789735109)
        ref[1,0,1,1]=(1.40678949618)
        ref[1,0,1,2]=(-0.965577726422)
        ref[1,1,0,0]=(-0.758717082212)
        ref[1,1,0,1]=(0.612968081377)
        ref[1,1,0,2]=(-0.417988159948)
        ref[1,1,1,0]=(0.969867032567)
        ref[1,1,1,1]=(-0.0700234825891)
        ref[1,1,1,2]=(1.53879850558)
        ref[2,0,0,0]=(-1.02952648125)
        ref[2,0,0,1]=(0.108642437375)
        ref[2,0,0,2]=(0.251073184196)
        ref[2,0,1,0]=(0.794766888909)
        ref[2,0,1,1]=(1.50591346365)
        ref[2,0,1,2]=(-0.36870578891)
        ref[2,1,0,0]=(-0.534487055503)
        ref[2,1,0,1]=(-1.09061679233)
        ref[2,1,0,2]=(0.799342633685)
        ref[2,1,1,0]=(0.0435889213805)
        ref[2,1,1,1]=(-0.209888628166)
        ref[2,1,1,2]=(1.34633215915)
        ref[3,0,0,0]=(-0.0344682106376)
        ref[3,0,0,1]=(-0.92386569455)
        ref[3,0,0,2]=(-0.551250384619)
        ref[3,0,1,0]=(-0.168599962689)
        ref[3,0,1,1]=(0.204634495314)
        ref[3,0,1,2]=(-0.65426520271)
        ref[3,1,0,0]=(-1.61759210628)
        ref[3,1,0,1]=(-0.5922211067)
        ref[3,1,0,2]=(-0.139092780207)
        ref[3,1,1,0]=(-0.13862300062)
        ref[3,1,1,1]=(-1.45951050222)
        ref[3,1,1,2]=(0.300904423579)
        ref[4,0,0,0]=(0.629590770742)
        ref[4,0,0,1]=(-0.217150209985)
        ref[4,0,0,2]=(-0.140384227583)
        ref[4,0,1,0]=(-0.0461635416119)
        ref[4,0,1,1]=(0.525692990183)
        ref[4,0,1,2]=(-1.89728167146)
        ref[4,1,0,0]=(-0.130297059668)
        ref[4,1,0,1]=(-0.138816250007)
        ref[4,1,0,2]=(1.26805054232)
        ref[4,1,1,0]=(0.742488751566)
        ref[4,1,1,1]=(0.659272799907)
        ref[4,1,1,2]=(-0.370877917078)
        ref[5,0,0,0]=(-0.521350561164)
        ref[5,0,0,1]=(-0.213669151076)
        ref[5,0,0,2]=(0.00949381597317)
        ref[5,0,1,0]=(-0.951547526648)
        ref[5,0,1,1]=(-0.388340895795)
        ref[5,0,1,2]=(0.741997603334)
        ref[5,1,0,0]=(-0.332922940005)
        ref[5,1,0,1]=(1.74852940259)
        ref[5,1,0,2]=(-0.484189519128)
        ref[5,1,1,0]=(0.418660109098)
        ref[5,1,1,1]=(-0.690728767024)
        ref[5,1,1,2]=(-0.675947375912)
      res=grad(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(6, 2, 2)+(dim,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_div_onFunctionOnBoundary_fromData_ContinuousFunction(self):
      """
      tests divergence of Data on the FunctionOnBoundary

      assumptions: ContinuousFunction(self.domain) exists
                   self.domain supports div on FunctionOnBoundary
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=FunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=ContinuousFunction(self.domain)
      x=w.getX()
      arg=Vector(0,w)
      if dim==2:
        arg[0]=(-0.39999188185)*x[0]**o+(-0.0985302665504)*x[0]+(0.103912148113)*x[1]**o+(-0.440893151166)*x[1]
        arg[1]=(-0.550867128413)*x[0]**o+(-0.141593933069)*x[0]+(0.70592012062)*x[1]**o+(-0.836308099686)*x[1]
        ref=o*(-0.39999188185)*x_ref[0]**(o-1)+o*(0.70592012062)*x_ref[1]**(o-1)+(-0.934838366236)
      else:
        arg[0]=(-0.00405079499937)*x[0]**o+(-0.282117848793)*x[0]+(0.979898720034)*x[1]**o+(-0.418106638625)*x[1]+(-0.443550810851)*x[2]**o+(-0.114976349698)*x[2]
        arg[1]=(0.194746221496)*x[0]**o+(0.324772666848)*x[0]+(0.887813387362)*x[1]**o+(-0.9362867149)*x[1]+(-0.837328978457)*x[2]**o+(0.666079514358)*x[2]
        arg[2]=(0.974797445328)*x[0]**o+(0.00365347225195)*x[0]+(-0.285413216102)*x[1]**o+(-0.253930177142)*x[1]+(0.306713249275)*x[2]**o+(-0.651133960743)*x[2]
        ref=o*(-0.00405079499937)*x_ref[0]**(o-1)+o*(0.887813387362)*x_ref[1]**(o-1)+o*(0.306713249275)*x_ref[2]**(o-1)+(-1.86953852444)
      res=div(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertEqual(res.getFunctionSpace(),w_ref,"wrong function space of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_div_onFunctionOnBoundary_fromData_Solution(self):
      """
      tests divergence of Data on the FunctionOnBoundary

      assumptions: Solution(self.domain) exists
                   self.domain supports div on FunctionOnBoundary
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=FunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=Solution(self.domain)
      x=w.getX()
      arg=Vector(0,w)
      if dim==2:
        arg[0]=(-0.756094856241)*x[0]**o+(-0.185186427186)*x[0]+(0.15709960228)*x[1]**o+(-0.408372399703)*x[1]
        arg[1]=(-0.680793761252)*x[0]**o+(0.815275471992)*x[0]+(-0.0564602888317)*x[1]**o+(0.542507598499)*x[1]
        ref=o*(-0.756094856241)*x_ref[0]**(o-1)+o*(-0.0564602888317)*x_ref[1]**(o-1)+(0.357321171313)
      else:
        arg[0]=(-0.934829971573)*x[0]**o+(-0.202157515712)*x[0]+(0.972095997183)*x[1]**o+(0.430890291958)*x[1]+(0.973333736054)*x[2]**o+(0.563067835398)*x[2]
        arg[1]=(-0.676905980848)*x[0]**o+(0.721377714968)*x[0]+(-0.594993636371)*x[1]**o+(0.678979489168)*x[1]+(-0.491382641255)*x[2]**o+(-0.237396572727)*x[2]
        arg[2]=(-0.429697616397)*x[0]**o+(-0.8280062193)*x[0]+(0.549112225165)*x[1]**o+(0.73490904828)*x[1]+(0.543450722632)*x[2]**o+(-0.910092410543)*x[2]
        ref=o*(-0.934829971573)*x_ref[0]**(o-1)+o*(-0.594993636371)*x_ref[1]**(o-1)+o*(0.543450722632)*x_ref[2]**(o-1)+(-0.433270437087)
      res=div(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertEqual(res.getFunctionSpace(),w_ref,"wrong function space of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_div_onFunctionOnBoundary_fromData_ReducedSolution(self):
      """
      tests divergence of Data on the FunctionOnBoundary

      assumptions: ReducedSolution(self.domain) exists
                   self.domain supports div on FunctionOnBoundary
      """
      o=1
      dim=self.domain.getDim()
      w_ref=FunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=ReducedSolution(self.domain)
      x=w.getX()
      arg=Vector(0,w)
      if dim==2:
        arg[0]=(-0.701055390328)*x[0]+(-0.873109677704)*x[1]
        arg[1]=(-0.459521943793)*x[0]+(-1.63064815751)*x[1]
        ref=(-2.33170354784)
      else:
        arg[0]=(-0.408202035271)*x[0]+(-0.114769362644)*x[1]+(1.5510990077)*x[2]
        arg[1]=(0.17481433607)*x[0]+(-0.466969145604)*x[1]+(1.25289823435)*x[2]
        arg[2]=(-0.215477376297)*x[0]+(0.437173510517)*x[1]+(1.00334359062)*x[2]
        ref=(0.128172409746)
      res=div(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertEqual(res.getFunctionSpace(),w_ref,"wrong function space of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_div_onFunctionOnBoundary_fromData_ReducedContinuousFunction(self):
      """
      tests divergence of Data on the FunctionOnBoundary

      assumptions: ReducedContinuousFunction(self.domain) exists
                   self.domain supports div on FunctionOnBoundary
      """
      o=1
      dim=self.domain.getDim()
      w_ref=FunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=ReducedContinuousFunction(self.domain)
      x=w.getX()
      arg=Vector(0,w)
      if dim==2:
        arg[0]=(-0.701055390328)*x[0]+(-0.873109677704)*x[1]
        arg[1]=(-0.459521943793)*x[0]+(-1.63064815751)*x[1]
        ref=(-2.33170354784)
      else:
        arg[0]=(-0.408202035271)*x[0]+(-0.114769362644)*x[1]+(1.5510990077)*x[2]
        arg[1]=(0.17481433607)*x[0]+(-0.466969145604)*x[1]+(1.25289823435)*x[2]
        arg[2]=(-0.215477376297)*x[0]+(0.437173510517)*x[1]+(1.00334359062)*x[2]
        ref=(0.128172409746)
      res=div(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertEqual(res.getFunctionSpace(),w_ref,"wrong function space of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_div_onReducedFunctionOnBoundary_fromData_ContinuousFunction(self):
      """
      tests divergence of Data on the ReducedFunctionOnBoundary

      assumptions: ContinuousFunction(self.domain) exists
                   self.domain supports div on ReducedFunctionOnBoundary
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=ContinuousFunction(self.domain)
      x=w.getX()
      arg=Vector(0,w)
      if dim==2:
        arg[0]=(-0.39999188185)*x[0]**o+(-0.0985302665504)*x[0]+(0.103912148113)*x[1]**o+(-0.440893151166)*x[1]
        arg[1]=(-0.550867128413)*x[0]**o+(-0.141593933069)*x[0]+(0.70592012062)*x[1]**o+(-0.836308099686)*x[1]
        ref=o*(-0.39999188185)*x_ref[0]**(o-1)+o*(0.70592012062)*x_ref[1]**(o-1)+(-0.934838366236)
      else:
        arg[0]=(-0.00405079499937)*x[0]**o+(-0.282117848793)*x[0]+(0.979898720034)*x[1]**o+(-0.418106638625)*x[1]+(-0.443550810851)*x[2]**o+(-0.114976349698)*x[2]
        arg[1]=(0.194746221496)*x[0]**o+(0.324772666848)*x[0]+(0.887813387362)*x[1]**o+(-0.9362867149)*x[1]+(-0.837328978457)*x[2]**o+(0.666079514358)*x[2]
        arg[2]=(0.974797445328)*x[0]**o+(0.00365347225195)*x[0]+(-0.285413216102)*x[1]**o+(-0.253930177142)*x[1]+(0.306713249275)*x[2]**o+(-0.651133960743)*x[2]
        ref=o*(-0.00405079499937)*x_ref[0]**(o-1)+o*(0.887813387362)*x_ref[1]**(o-1)+o*(0.306713249275)*x_ref[2]**(o-1)+(-1.86953852444)
      res=div(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertEqual(res.getFunctionSpace(),w_ref,"wrong function space of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_div_onReducedFunctionOnBoundary_fromData_Solution(self):
      """
      tests divergence of Data on the ReducedFunctionOnBoundary

      assumptions: Solution(self.domain) exists
                   self.domain supports div on ReducedFunctionOnBoundary
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=Solution(self.domain)
      x=w.getX()
      arg=Vector(0,w)
      if dim==2:
        arg[0]=(-0.756094856241)*x[0]**o+(-0.185186427186)*x[0]+(0.15709960228)*x[1]**o+(-0.408372399703)*x[1]
        arg[1]=(-0.680793761252)*x[0]**o+(0.815275471992)*x[0]+(-0.0564602888317)*x[1]**o+(0.542507598499)*x[1]
        ref=o*(-0.756094856241)*x_ref[0]**(o-1)+o*(-0.0564602888317)*x_ref[1]**(o-1)+(0.357321171313)
      else:
        arg[0]=(-0.934829971573)*x[0]**o+(-0.202157515712)*x[0]+(0.972095997183)*x[1]**o+(0.430890291958)*x[1]+(0.973333736054)*x[2]**o+(0.563067835398)*x[2]
        arg[1]=(-0.676905980848)*x[0]**o+(0.721377714968)*x[0]+(-0.594993636371)*x[1]**o+(0.678979489168)*x[1]+(-0.491382641255)*x[2]**o+(-0.237396572727)*x[2]
        arg[2]=(-0.429697616397)*x[0]**o+(-0.8280062193)*x[0]+(0.549112225165)*x[1]**o+(0.73490904828)*x[1]+(0.543450722632)*x[2]**o+(-0.910092410543)*x[2]
        ref=o*(-0.934829971573)*x_ref[0]**(o-1)+o*(-0.594993636371)*x_ref[1]**(o-1)+o*(0.543450722632)*x_ref[2]**(o-1)+(-0.433270437087)
      res=div(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertEqual(res.getFunctionSpace(),w_ref,"wrong function space of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_div_onReducedFunctionOnBoundary_fromData_ReducedSolution(self):
      """
      tests divergence of Data on the ReducedFunctionOnBoundary

      assumptions: ReducedSolution(self.domain) exists
                   self.domain supports div on ReducedFunctionOnBoundary
      """
      o=1
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=ReducedSolution(self.domain)
      x=w.getX()
      arg=Vector(0,w)
      if dim==2:
        arg[0]=(-0.701055390328)*x[0]+(-0.873109677704)*x[1]
        arg[1]=(-0.459521943793)*x[0]+(-1.63064815751)*x[1]
        ref=(-2.33170354784)
      else:
        arg[0]=(-0.408202035271)*x[0]+(-0.114769362644)*x[1]+(1.5510990077)*x[2]
        arg[1]=(0.17481433607)*x[0]+(-0.466969145604)*x[1]+(1.25289823435)*x[2]
        arg[2]=(-0.215477376297)*x[0]+(0.437173510517)*x[1]+(1.00334359062)*x[2]
        ref=(0.128172409746)
      res=div(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertEqual(res.getFunctionSpace(),w_ref,"wrong function space of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_div_onReducedFunctionOnBoundary_fromData_ReducedContinuousFunction(self):
      """
      tests divergence of Data on the ReducedFunctionOnBoundary

      assumptions: ReducedContinuousFunction(self.domain) exists
                   self.domain supports div on ReducedFunctionOnBoundary
      """
      o=1
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnBoundary(self.domain)
      x_ref=w_ref.getX()
      w=ReducedContinuousFunction(self.domain)
      x=w.getX()
      arg=Vector(0,w)
      if dim==2:
        arg[0]=(-0.701055390328)*x[0]+(-0.873109677704)*x[1]
        arg[1]=(-0.459521943793)*x[0]+(-1.63064815751)*x[1]
        ref=(-2.33170354784)
      else:
        arg[0]=(-0.408202035271)*x[0]+(-0.114769362644)*x[1]+(1.5510990077)*x[2]
        arg[1]=(0.17481433607)*x[0]+(-0.466969145604)*x[1]+(1.25289823435)*x[2]
        arg[2]=(-0.215477376297)*x[0]+(0.437173510517)*x[1]+(1.00334359062)*x[2]
        ref=(0.128172409746)
      res=div(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertEqual(res.getFunctionSpace(),w_ref,"wrong function space of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_div_onFunctionOnContactZero_fromData_ContinuousFunction(self):
      """
      tests divergence of Data on the FunctionOnContactZero

      assumptions: ContinuousFunction(self.domain) exists
                   self.domain supports div on FunctionOnContactZero
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=FunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=ContinuousFunction(self.domain)
      x=w.getX()
      arg=Vector(0,w)
      if dim==2:
        arg[0]=(-0.168949755871)*x[0]**o+(-0.850028843808)*x[0]+(-0.120402543124)*x[1]**o+(-0.962848557803)*x[1]
        arg[1]=(-0.654809749448)*x[0]**o+(-0.86782287971)*x[0]+(0.063297622975)*x[1]**o+(0.400298481087)*x[1]
        ref=o*(-0.168949755871)*x_ref[0]**(o-1)+o*(0.063297622975)*x_ref[1]**(o-1)+(-0.449730362722)
      else:
        arg[0]=(-0.171176882625)*x[0]**o+(-0.983025148621)*x[0]+(-0.287555867477)*x[1]**o+(-0.689164237089)*x[1]+(0.700322207054)*x[2]**o+(0.224056812199)*x[2]
        arg[1]=(-0.112978574269)*x[0]**o+(-0.858210458939)*x[0]+(-0.9204250284)*x[1]**o+(0.123297295575)*x[1]+(-0.824406652345)*x[2]**o+(-0.514156554116)*x[2]
        arg[2]=(0.51215310895)*x[0]**o+(-0.484568237326)*x[0]+(0.324174170946)*x[1]**o+(0.00636990564332)*x[1]+(0.640205070676)*x[2]**o+(0.642111592847)*x[2]
        ref=o*(-0.171176882625)*x_ref[0]**(o-1)+o*(-0.9204250284)*x_ref[1]**(o-1)+o*(0.640205070676)*x_ref[2]**(o-1)+(-0.217616260198)
      res=div(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertEqual(res.getFunctionSpace(),w_ref,"wrong function space of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_div_onFunctionOnContactZero_fromData_Solution(self):
      """
      tests divergence of Data on the FunctionOnContactZero

      assumptions: Solution(self.domain) exists
                   self.domain supports div on FunctionOnContactZero
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=FunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=Solution(self.domain)
      x=w.getX()
      arg=Vector(0,w)
      if dim==2:
        arg[0]=(-0.878817592363)*x[0]**o+(-0.670917442592)*x[0]+(0.497874113437)*x[1]**o+(-0.923717382234)*x[1]
        arg[1]=(-0.26042852826)*x[0]**o+(0.0668495878627)*x[0]+(-0.24188250168)*x[1]**o+(-0.189346966858)*x[1]
        ref=o*(-0.878817592363)*x_ref[0]**(o-1)+o*(-0.24188250168)*x_ref[1]**(o-1)+(-0.86026440945)
      else:
        arg[0]=(-0.853829042745)*x[0]**o+(0.708253823804)*x[0]+(-0.420888906754)*x[1]**o+(0.94422817266)*x[1]+(-0.0454733411462)*x[2]**o+(-0.588636328569)*x[2]
        arg[1]=(0.502105411994)*x[0]**o+(0.618635348918)*x[0]+(-0.459898919811)*x[1]**o+(0.0206615239957)*x[1]+(-0.479378221929)*x[2]**o+(-0.0383028811998)*x[2]
        arg[2]=(-0.624273042239)*x[0]**o+(0.11218158851)*x[0]+(0.300065081794)*x[1]**o+(-0.823140829548)*x[1]+(-0.537442909756)*x[2]**o+(-0.537901446348)*x[2]
        ref=o*(-0.853829042745)*x_ref[0]**(o-1)+o*(-0.459898919811)*x_ref[1]**(o-1)+o*(-0.537442909756)*x_ref[2]**(o-1)+(0.191013901452)
      res=div(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertEqual(res.getFunctionSpace(),w_ref,"wrong function space of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_div_onFunctionOnContactZero_fromData_ReducedSolution(self):
      """
      tests divergence of Data on the FunctionOnContactZero

      assumptions: ReducedSolution(self.domain) exists
                   self.domain supports div on FunctionOnContactZero
      """
      o=1
      dim=self.domain.getDim()
      w_ref=FunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=ReducedSolution(self.domain)
      x=w.getX()
      arg=Vector(0,w)
      if dim==2:
        arg[0]=(1.40908912517)*x[0]+(0.980544777047)*x[1]
        arg[1]=(1.54735707911)*x[0]+(0.136617363775)*x[1]
        ref=(1.54570648895)
      else:
        arg[0]=(0.542899657951)*x[0]+(0.445471953165)*x[1]+(0.832668361385)*x[2]
        arg[1]=(-0.658976315278)*x[0]+(0.467903824571)*x[1]+(-1.00818943414)*x[2]
        arg[2]=(-1.10271841197)*x[0]+(1.48792855886)*x[1]+(-0.560275626738)*x[2]
        ref=(0.450527855784)
      res=div(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertEqual(res.getFunctionSpace(),w_ref,"wrong function space of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_div_onFunctionOnContactZero_fromData_ReducedContinuousFunction(self):
      """
      tests divergence of Data on the FunctionOnContactZero

      assumptions: ReducedContinuousFunction(self.domain) exists
                   self.domain supports div on FunctionOnContactZero
      """
      o=1
      dim=self.domain.getDim()
      w_ref=FunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=ReducedContinuousFunction(self.domain)
      x=w.getX()
      arg=Vector(0,w)
      if dim==2:
        arg[0]=(1.40908912517)*x[0]+(0.980544777047)*x[1]
        arg[1]=(1.54735707911)*x[0]+(0.136617363775)*x[1]
        ref=(1.54570648895)
      else:
        arg[0]=(0.542899657951)*x[0]+(0.445471953165)*x[1]+(0.832668361385)*x[2]
        arg[1]=(-0.658976315278)*x[0]+(0.467903824571)*x[1]+(-1.00818943414)*x[2]
        arg[2]=(-1.10271841197)*x[0]+(1.48792855886)*x[1]+(-0.560275626738)*x[2]
        ref=(0.450527855784)
      res=div(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertEqual(res.getFunctionSpace(),w_ref,"wrong function space of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_div_onReducedFunctionOnContactZero_fromData_ContinuousFunction(self):
      """
      tests divergence of Data on the ReducedFunctionOnContactZero

      assumptions: ContinuousFunction(self.domain) exists
                   self.domain supports div on ReducedFunctionOnContactZero
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=ContinuousFunction(self.domain)
      x=w.getX()
      arg=Vector(0,w)
      if dim==2:
        arg[0]=(-0.168949755871)*x[0]**o+(-0.850028843808)*x[0]+(-0.120402543124)*x[1]**o+(-0.962848557803)*x[1]
        arg[1]=(-0.654809749448)*x[0]**o+(-0.86782287971)*x[0]+(0.063297622975)*x[1]**o+(0.400298481087)*x[1]
        ref=o*(-0.168949755871)*x_ref[0]**(o-1)+o*(0.063297622975)*x_ref[1]**(o-1)+(-0.449730362722)
      else:
        arg[0]=(-0.171176882625)*x[0]**o+(-0.983025148621)*x[0]+(-0.287555867477)*x[1]**o+(-0.689164237089)*x[1]+(0.700322207054)*x[2]**o+(0.224056812199)*x[2]
        arg[1]=(-0.112978574269)*x[0]**o+(-0.858210458939)*x[0]+(-0.9204250284)*x[1]**o+(0.123297295575)*x[1]+(-0.824406652345)*x[2]**o+(-0.514156554116)*x[2]
        arg[2]=(0.51215310895)*x[0]**o+(-0.484568237326)*x[0]+(0.324174170946)*x[1]**o+(0.00636990564332)*x[1]+(0.640205070676)*x[2]**o+(0.642111592847)*x[2]
        ref=o*(-0.171176882625)*x_ref[0]**(o-1)+o*(-0.9204250284)*x_ref[1]**(o-1)+o*(0.640205070676)*x_ref[2]**(o-1)+(-0.217616260198)
      res=div(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertEqual(res.getFunctionSpace(),w_ref,"wrong function space of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_div_onReducedFunctionOnContactZero_fromData_Solution(self):
      """
      tests divergence of Data on the ReducedFunctionOnContactZero

      assumptions: Solution(self.domain) exists
                   self.domain supports div on ReducedFunctionOnContactZero
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=Solution(self.domain)
      x=w.getX()
      arg=Vector(0,w)
      if dim==2:
        arg[0]=(-0.878817592363)*x[0]**o+(-0.670917442592)*x[0]+(0.497874113437)*x[1]**o+(-0.923717382234)*x[1]
        arg[1]=(-0.26042852826)*x[0]**o+(0.0668495878627)*x[0]+(-0.24188250168)*x[1]**o+(-0.189346966858)*x[1]
        ref=o*(-0.878817592363)*x_ref[0]**(o-1)+o*(-0.24188250168)*x_ref[1]**(o-1)+(-0.86026440945)
      else:
        arg[0]=(-0.853829042745)*x[0]**o+(0.708253823804)*x[0]+(-0.420888906754)*x[1]**o+(0.94422817266)*x[1]+(-0.0454733411462)*x[2]**o+(-0.588636328569)*x[2]
        arg[1]=(0.502105411994)*x[0]**o+(0.618635348918)*x[0]+(-0.459898919811)*x[1]**o+(0.0206615239957)*x[1]+(-0.479378221929)*x[2]**o+(-0.0383028811998)*x[2]
        arg[2]=(-0.624273042239)*x[0]**o+(0.11218158851)*x[0]+(0.300065081794)*x[1]**o+(-0.823140829548)*x[1]+(-0.537442909756)*x[2]**o+(-0.537901446348)*x[2]
        ref=o*(-0.853829042745)*x_ref[0]**(o-1)+o*(-0.459898919811)*x_ref[1]**(o-1)+o*(-0.537442909756)*x_ref[2]**(o-1)+(0.191013901452)
      res=div(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertEqual(res.getFunctionSpace(),w_ref,"wrong function space of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_div_onReducedFunctionOnContactZero_fromData_ReducedSolution(self):
      """
      tests divergence of Data on the ReducedFunctionOnContactZero

      assumptions: ReducedSolution(self.domain) exists
                   self.domain supports div on ReducedFunctionOnContactZero
      """
      o=1
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=ReducedSolution(self.domain)
      x=w.getX()
      arg=Vector(0,w)
      if dim==2:
        arg[0]=(1.40908912517)*x[0]+(0.980544777047)*x[1]
        arg[1]=(1.54735707911)*x[0]+(0.136617363775)*x[1]
        ref=(1.54570648895)
      else:
        arg[0]=(0.542899657951)*x[0]+(0.445471953165)*x[1]+(0.832668361385)*x[2]
        arg[1]=(-0.658976315278)*x[0]+(0.467903824571)*x[1]+(-1.00818943414)*x[2]
        arg[2]=(-1.10271841197)*x[0]+(1.48792855886)*x[1]+(-0.560275626738)*x[2]
        ref=(0.450527855784)
      res=div(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertEqual(res.getFunctionSpace(),w_ref,"wrong function space of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_div_onReducedFunctionOnContactZero_fromData_ReducedContinuousFunction(self):
      """
      tests divergence of Data on the ReducedFunctionOnContactZero

      assumptions: ReducedContinuousFunction(self.domain) exists
                   self.domain supports div on ReducedFunctionOnContactZero
      """
      o=1
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactZero(self.domain)
      x_ref=w_ref.getX()
      w=ReducedContinuousFunction(self.domain)
      x=w.getX()
      arg=Vector(0,w)
      if dim==2:
        arg[0]=(1.40908912517)*x[0]+(0.980544777047)*x[1]
        arg[1]=(1.54735707911)*x[0]+(0.136617363775)*x[1]
        ref=(1.54570648895)
      else:
        arg[0]=(0.542899657951)*x[0]+(0.445471953165)*x[1]+(0.832668361385)*x[2]
        arg[1]=(-0.658976315278)*x[0]+(0.467903824571)*x[1]+(-1.00818943414)*x[2]
        arg[2]=(-1.10271841197)*x[0]+(1.48792855886)*x[1]+(-0.560275626738)*x[2]
        ref=(0.450527855784)
      res=div(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertEqual(res.getFunctionSpace(),w_ref,"wrong function space of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_div_onFunctionOnContactOne_fromData_ContinuousFunction(self):
      """
      tests divergence of Data on the FunctionOnContactOne

      assumptions: ContinuousFunction(self.domain) exists
                   self.domain supports div on FunctionOnContactOne
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=FunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=ContinuousFunction(self.domain)
      x=w.getX()
      arg=Vector(0,w)
      if dim==2:
        arg[0]=(-0.506403770066)*x[0]**o+(0.32584268281)*x[0]+(-0.83529844868)*x[1]**o+(0.83697332673)*x[1]
        arg[1]=(-0.85254932286)*x[0]**o+(0.751060747065)*x[0]+(-0.672601723159)*x[1]**o+(0.33751172176)*x[1]
        ref=o*(-0.506403770066)*x_ref[0]**(o-1)+o*(-0.672601723159)*x_ref[1]**(o-1)+(0.66335440457)
      else:
        arg[0]=(-0.437811901761)*x[0]**o+(-0.135276240019)*x[0]+(0.683969739116)*x[1]**o+(-0.207547375093)*x[1]+(0.028594861031)*x[2]**o+(0.721966907461)*x[2]
        arg[1]=(0.315283027578)*x[0]**o+(0.724158692434)*x[0]+(-0.746372201791)*x[1]**o+(-0.370798791131)*x[1]+(-0.677893413238)*x[2]**o+(0.645317237187)*x[2]
        arg[2]=(0.0795681320657)*x[0]**o+(-0.165210743397)*x[0]+(0.866175461075)*x[1]**o+(0.10183311172)*x[1]+(-0.642389179022)*x[2]**o+(-0.917391184653)*x[2]
        ref=o*(-0.437811901761)*x_ref[0]**(o-1)+o*(-0.746372201791)*x_ref[1]**(o-1)+o*(-0.642389179022)*x_ref[2]**(o-1)+(-1.4234662158)
      res=div(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertEqual(res.getFunctionSpace(),w_ref,"wrong function space of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_div_onFunctionOnContactOne_fromData_Solution(self):
      """
      tests divergence of Data on the FunctionOnContactOne

      assumptions: Solution(self.domain) exists
                   self.domain supports div on FunctionOnContactOne
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=FunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=Solution(self.domain)
      x=w.getX()
      arg=Vector(0,w)
      if dim==2:
        arg[0]=(0.46385553428)*x[0]**o+(-0.91930502543)*x[0]+(0.316745110613)*x[1]**o+(-0.0996899204895)*x[1]
        arg[1]=(-0.473415736992)*x[0]**o+(0.514718374433)*x[0]+(-0.473429315265)*x[1]**o+(-0.194316615233)*x[1]
        ref=o*(0.46385553428)*x_ref[0]**(o-1)+o*(-0.473429315265)*x_ref[1]**(o-1)+(-1.11362164066)
      else:
        arg[0]=(0.740236725813)*x[0]**o+(0.887898498849)*x[0]+(-0.44803045798)*x[1]**o+(0.160930903094)*x[1]+(-0.530527194219)*x[2]**o+(0.0622347651074)*x[2]
        arg[1]=(0.36748785661)*x[0]**o+(-0.618052241987)*x[0]+(-0.57186325537)*x[1]**o+(-0.180576934525)*x[1]+(-0.381568503551)*x[2]**o+(0.0356882174068)*x[2]
        arg[2]=(0.070144257808)*x[0]**o+(0.823052625211)*x[0]+(-0.426522615959)*x[1]**o+(-0.294700653199)*x[1]+(0.209922433427)*x[2]**o+(-0.532056800218)*x[2]
        ref=o*(0.740236725813)*x_ref[0]**(o-1)+o*(-0.57186325537)*x_ref[1]**(o-1)+o*(0.209922433427)*x_ref[2]**(o-1)+(0.175264764106)
      res=div(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertEqual(res.getFunctionSpace(),w_ref,"wrong function space of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_div_onFunctionOnContactOne_fromData_ReducedSolution(self):
      """
      tests divergence of Data on the FunctionOnContactOne

      assumptions: ReducedSolution(self.domain) exists
                   self.domain supports div on FunctionOnContactOne
      """
      o=1
      dim=self.domain.getDim()
      w_ref=FunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=ReducedSolution(self.domain)
      x=w.getX()
      arg=Vector(0,w)
      if dim==2:
        arg[0]=(0.0337229572599)*x[0]+(0.820391566535)*x[1]
        arg[1]=(0.640567267185)*x[0]+(1.03537999206)*x[1]
        ref=(1.06910294932)
      else:
        arg[0]=(-0.0797501374913)*x[0]+(-0.798826730006)*x[1]+(-0.590979881432)*x[2]
        arg[1]=(-0.414547879032)*x[0]+(0.845538994985)*x[1]+(-1.21203164133)*x[2]
        arg[2]=(-0.438232052406)*x[0]+(-0.35977163998)*x[1]+(-1.01489636413)*x[2]
        ref=(-0.249107506635)
      res=div(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertEqual(res.getFunctionSpace(),w_ref,"wrong function space of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_div_onFunctionOnContactOne_fromData_ReducedContinuousFunction(self):
      """
      tests divergence of Data on the FunctionOnContactOne

      assumptions: ReducedContinuousFunction(self.domain) exists
                   self.domain supports div on FunctionOnContactOne
      """
      o=1
      dim=self.domain.getDim()
      w_ref=FunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=ReducedContinuousFunction(self.domain)
      x=w.getX()
      arg=Vector(0,w)
      if dim==2:
        arg[0]=(0.0337229572599)*x[0]+(0.820391566535)*x[1]
        arg[1]=(0.640567267185)*x[0]+(1.03537999206)*x[1]
        ref=(1.06910294932)
      else:
        arg[0]=(-0.0797501374913)*x[0]+(-0.798826730006)*x[1]+(-0.590979881432)*x[2]
        arg[1]=(-0.414547879032)*x[0]+(0.845538994985)*x[1]+(-1.21203164133)*x[2]
        arg[2]=(-0.438232052406)*x[0]+(-0.35977163998)*x[1]+(-1.01489636413)*x[2]
        ref=(-0.249107506635)
      res=div(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertEqual(res.getFunctionSpace(),w_ref,"wrong function space of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_div_onReducedFunctionOnContactOne_fromData_ContinuousFunction(self):
      """
      tests divergence of Data on the ReducedFunctionOnContactOne

      assumptions: ContinuousFunction(self.domain) exists
                   self.domain supports div on ReducedFunctionOnContactOne
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=ContinuousFunction(self.domain)
      x=w.getX()
      arg=Vector(0,w)
      if dim==2:
        arg[0]=(-0.506403770066)*x[0]**o+(0.32584268281)*x[0]+(-0.83529844868)*x[1]**o+(0.83697332673)*x[1]
        arg[1]=(-0.85254932286)*x[0]**o+(0.751060747065)*x[0]+(-0.672601723159)*x[1]**o+(0.33751172176)*x[1]
        ref=o*(-0.506403770066)*x_ref[0]**(o-1)+o*(-0.672601723159)*x_ref[1]**(o-1)+(0.66335440457)
      else:
        arg[0]=(-0.437811901761)*x[0]**o+(-0.135276240019)*x[0]+(0.683969739116)*x[1]**o+(-0.207547375093)*x[1]+(0.028594861031)*x[2]**o+(0.721966907461)*x[2]
        arg[1]=(0.315283027578)*x[0]**o+(0.724158692434)*x[0]+(-0.746372201791)*x[1]**o+(-0.370798791131)*x[1]+(-0.677893413238)*x[2]**o+(0.645317237187)*x[2]
        arg[2]=(0.0795681320657)*x[0]**o+(-0.165210743397)*x[0]+(0.866175461075)*x[1]**o+(0.10183311172)*x[1]+(-0.642389179022)*x[2]**o+(-0.917391184653)*x[2]
        ref=o*(-0.437811901761)*x_ref[0]**(o-1)+o*(-0.746372201791)*x_ref[1]**(o-1)+o*(-0.642389179022)*x_ref[2]**(o-1)+(-1.4234662158)
      res=div(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertEqual(res.getFunctionSpace(),w_ref,"wrong function space of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_div_onReducedFunctionOnContactOne_fromData_Solution(self):
      """
      tests divergence of Data on the ReducedFunctionOnContactOne

      assumptions: Solution(self.domain) exists
                   self.domain supports div on ReducedFunctionOnContactOne
      """
      o=self.order
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=Solution(self.domain)
      x=w.getX()
      arg=Vector(0,w)
      if dim==2:
        arg[0]=(0.46385553428)*x[0]**o+(-0.91930502543)*x[0]+(0.316745110613)*x[1]**o+(-0.0996899204895)*x[1]
        arg[1]=(-0.473415736992)*x[0]**o+(0.514718374433)*x[0]+(-0.473429315265)*x[1]**o+(-0.194316615233)*x[1]
        ref=o*(0.46385553428)*x_ref[0]**(o-1)+o*(-0.473429315265)*x_ref[1]**(o-1)+(-1.11362164066)
      else:
        arg[0]=(0.740236725813)*x[0]**o+(0.887898498849)*x[0]+(-0.44803045798)*x[1]**o+(0.160930903094)*x[1]+(-0.530527194219)*x[2]**o+(0.0622347651074)*x[2]
        arg[1]=(0.36748785661)*x[0]**o+(-0.618052241987)*x[0]+(-0.57186325537)*x[1]**o+(-0.180576934525)*x[1]+(-0.381568503551)*x[2]**o+(0.0356882174068)*x[2]
        arg[2]=(0.070144257808)*x[0]**o+(0.823052625211)*x[0]+(-0.426522615959)*x[1]**o+(-0.294700653199)*x[1]+(0.209922433427)*x[2]**o+(-0.532056800218)*x[2]
        ref=o*(0.740236725813)*x_ref[0]**(o-1)+o*(-0.57186325537)*x_ref[1]**(o-1)+o*(0.209922433427)*x_ref[2]**(o-1)+(0.175264764106)
      res=div(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertEqual(res.getFunctionSpace(),w_ref,"wrong function space of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_div_onReducedFunctionOnContactOne_fromData_ReducedSolution(self):
      """
      tests divergence of Data on the ReducedFunctionOnContactOne

      assumptions: ReducedSolution(self.domain) exists
                   self.domain supports div on ReducedFunctionOnContactOne
      """
      o=1
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=ReducedSolution(self.domain)
      x=w.getX()
      arg=Vector(0,w)
      if dim==2:
        arg[0]=(0.0337229572599)*x[0]+(0.820391566535)*x[1]
        arg[1]=(0.640567267185)*x[0]+(1.03537999206)*x[1]
        ref=(1.06910294932)
      else:
        arg[0]=(-0.0797501374913)*x[0]+(-0.798826730006)*x[1]+(-0.590979881432)*x[2]
        arg[1]=(-0.414547879032)*x[0]+(0.845538994985)*x[1]+(-1.21203164133)*x[2]
        arg[2]=(-0.438232052406)*x[0]+(-0.35977163998)*x[1]+(-1.01489636413)*x[2]
        ref=(-0.249107506635)
      res=div(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertEqual(res.getFunctionSpace(),w_ref,"wrong function space of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_div_onReducedFunctionOnContactOne_fromData_ReducedContinuousFunction(self):
      """
      tests divergence of Data on the ReducedFunctionOnContactOne

      assumptions: ReducedContinuousFunction(self.domain) exists
                   self.domain supports div on ReducedFunctionOnContactOne
      """
      o=1
      dim=self.domain.getDim()
      w_ref=ReducedFunctionOnContactOne(self.domain)
      x_ref=w_ref.getX()
      w=ReducedContinuousFunction(self.domain)
      x=w.getX()
      arg=Vector(0,w)
      if dim==2:
        arg[0]=(0.0337229572599)*x[0]+(0.820391566535)*x[1]
        arg[1]=(0.640567267185)*x[0]+(1.03537999206)*x[1]
        ref=(1.06910294932)
      else:
        arg[0]=(-0.0797501374913)*x[0]+(-0.798826730006)*x[1]+(-0.590979881432)*x[2]
        arg[1]=(-0.414547879032)*x[0]+(0.845538994985)*x[1]+(-1.21203164133)*x[2]
        arg[2]=(-0.438232052406)*x[0]+(-0.35977163998)*x[1]+(-1.01489636413)*x[2]
        ref=(-0.249107506635)
      res=div(arg,where=w_ref)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertEqual(res.getFunctionSpace(),w_ref,"wrong function space of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")

