# $Id: mk-constants.py,v 1.7 2008/01/26 01:31:55 wiml Exp $
#
# Python libpcap
# Copyright (C) 2004,2007 Wim Lewis
# Based on:
#   PY-libpcap (C) 1998, Aaron L. Rhodes
#   constants.i (C) 2001,2002, David Margrave
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the BSD Licence. See the file COPYING
# for details.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

linktypes = (
'DLT_NULL',
'DLT_EN10MB',
'DLT_EN3MB',
'DLT_AX25',
'DLT_PRONET',
'DLT_CHAOS',
'DLT_ARCNET',
'DLT_ARCNET_LINUX',
'DLT_SLIP',
'DLT_SLIP_BSDOS',
'DLT_FDDI',
'DLT_HIPPI',
'DLT_ATM_RFC1483',
'DLT_RAW',
'DLT_PPP',
'DLT_PPP_BSDOS',
'DLT_PPP_SERIAL',
'DLT_PPP_ETHER',
'DLT_C_HDLC',
# 'DLT_CHDLC',   # CHDLC is a compatibility alias for C_HDLC
'DLT_HDLC',
'DLT_ATM_CLIP',
'DLT_IEEE802',
'DLT_IEEE802_11',
'DLT_IEEE802_11_RADIO',
'DLT_IEEE802_11_RADIO_AVS',
'DLT_LOOP',
'DLT_LINUX_SLL',
'DLT_LTALK',
'DLT_ECONET',
'DLT_IPFILTER',
'DLT_PFLOG',
'DLT_PFSYNC',
'DLT_CISCO_IOS',
'DLT_PRISM_HEADER',
'DLT_AIRONET_HEADER',
'DLT_ENC',
'DLT_APPLE_IP_OVER_IEEE1394',
'DLT_AURORA',
'DLT_DOCSIS',
'DLT_FRELAY',
'DLT_IP_OVER_FC',
'DLT_JUNIPER_ATM1',
'DLT_JUNIPER_ATM2',
'DLT_JUNIPER_ES',
'DLT_JUNIPER_GGSN',
'DLT_JUNIPER_MFR',
'DLT_JUNIPER_MLFR',
'DLT_JUNIPER_MLPPP',
'DLT_JUNIPER_MONITOR',
'DLT_JUNIPER_SERVICES',
'DLT_LINUX_IRDA',
'DLT_RIO',
'DLT_SUNATM',
'DLT_SYMANTEC_FIREWALL',
'DLT_TZSP',
'DLT_REDBACK_SMARTEDGE',
'DLT_OLD_PFLOG',
'DLT_HHDLC',
'DLT_PCI_EXP',
'DLT_MTP2_WITH_PHDR',
'DLT_MTP2',
'DLT_MTP3',
'DLT_SCCP',
'DLT_IBM_SP',
'DLT_IBM_SN',
'DLT_BACNET_MS_TP',
'DLT_LINUX_PPP_WITHDIRECTION',   # Replaced by DLT_PPP_PPPD
'DLT_GPRS_LLC',
'DLT_GPF_T',
'DLT_GPF_F',
'DLT_GCOM_T1E1',
'DLT_GCOM_SERIAL',
'DLT_JUNIPER_PIC_PEER',
'DLT_ERF_ETH',
'DLT_ERF_POS',
'DLT_LINUX_LAPD',
'DLT_JUNIPER_ETHER',
'DLT_JUNIPER_PPP',
'DLT_JUNIPER_PPPOE',
'DLT_JUNIPER_PPPOE_ATM',
'DLT_JUNIPER_FRELAY',
'DLT_JUNIPER_CHDLC',
'DLT_JUNIPER_ISM',
'DLT_JUNIPER_ST',
'DLT_JUNIPER_VP',
'DLT_PPP_PPPD',
'DLT_MFR',
'DLT_A429',
'DLT_A653_ICM',
'DLT_USB',
'DLT_USB_LINUX',
'DLT_CAN20B',
'DLT_BLUETOOTH_HCI_H4',
'DLT_BLUETOOTH_HCI_H4_WITH_PHDR',
'DLT_IEEE802_16_MAC_CPS',
'DLT_IEEE802_16_MAC_CPS_RADIO',
'DLT_IEEE802_15_4_LINUX',
'DLT_IEEE802_15_4',
'DLT_PPI',
'DLT_SITA',
'DLT_ERF',
'DLT_RAIF1',
'DLT_IPMB',
'DLT_AX25_KISS',
'DLT_LAPD',
'DLT_PPP_WITH_DIR',
'DLT_C_HDLC_WITH_DIR',
'DLT_FRELAY_WITH_DIR',
'DLT_LAPB_WITH_DIR',
'DLT_IPMB_LINUX',
)


import string
fp = open('constants.c', 'w')
fp.write('/* Automatically generated from\n')
rcs = '   $Id: mk-constants.py,v 1.7 2008/01/26 01:31:55 wiml Exp $\n'
fp.write(string.replace(rcs, '$', ''))
fp.write('   Do not edit this file directly, it will be overwritten \n*/\n\n')
fp.write('static struct { const char *name; long value; } ')
fp.write(' const pcapmodule_DLT[] = {\n')
for dlt in linktypes:
    fp.write('#ifdef %s\n' % (dlt,))
    fp.write('{ "%s", (%s) },\n' % (dlt,dlt))
    fp.write('#endif\n')
fp.write('{ NULL, 0 }\n};\n')

fp.close()

