# PySNMP SMI module. Autogenerated from smidump -f python PKTC-IETF-MTA-MIB
# by libsmi2pysnmp-0.1.3 at Mon Apr  2 20:39:27 2012,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ValueSizeConstraint")
( docsDevSoftwareGroupV2, ) = mibBuilder.importSymbols("DOCS-CABLE-DEVICE-MIB", "docsDevSoftwareGroupV2")
( DocsX509ASN1DEREncodedCertificate, docsBpi2CodeDownloadGroup, ) = mibBuilder.importSymbols("DOCS-IETF-BPI2-MIB", "DocsX509ASN1DEREncodedCertificate", "docsBpi2CodeDownloadGroup")
( ifPhysAddress, ) = mibBuilder.importSymbols("IF-MIB", "ifPhysAddress")
( InetAddress, InetAddressType, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddress", "InetAddressType")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( sysDescr, ) = mibBuilder.importSymbols("SNMPv2-MIB", "sysDescr")
( Bits, Counter32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, ObjectIdentity, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "ObjectIdentity", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "mib-2")
( RowStatus, TextualConvention, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "TextualConvention", "TruthValue")
( LongUtf8String, ) = mibBuilder.importSymbols("SYSAPPL-MIB", "LongUtf8String")

# Types

class PktcMtaDevProvEncryptAlg(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(0,1,3,2,4,)
    namedValues = NamedValues(("none", 0), ("des64CbcMode", 1), ("t3Des192CbcMode", 2), ("aes128CbcMode", 3), ("aes256CbcMode", 4), )
    

# Objects

pktcIetfMtaMib = ModuleIdentity((1, 3, 6, 1, 2, 1, 140)).setRevisions(("2006-09-18 00:00",))
if mibBuilder.loadTexts: pktcIetfMtaMib.setOrganization("IETF IP over Cable Data Network Working Group")
if mibBuilder.loadTexts: pktcIetfMtaMib.setContactInfo("Eugene Nechamkin\nBroadcom Corporation,\n200-13711 International Place,\n\n\n\nRichmond, BC, V6V 2Z8\nCANADA\nPhone: +1 604 233 8500\nEmail: enechamkin@broadcom.com\n\nJean-Francois Mule\nCable Television Laboratories, Inc.\n858 Coal Creek Circle\nLouisville, CO 80027-9750\nU.S.A.\nPhone: +1 303 661 9100\nEmail: jf.mule@cablelabs.com\n\nIETF IPCDN Working Group\nGeneral Discussion: ipcdn@ietf.org\nSubscribe: http://www.ietf.org/mailman/listinfo/ipcdn\nArchive: ftp://ftp.ietf.org/ietf-mail-archive/ipcdn\nCo-Chair: Jean-Francois Mule, jf.mule@cablelabs.com\nCo-Chair: Richard Woundy, Richard_Woundy@cable.comcast.com")
if mibBuilder.loadTexts: pktcIetfMtaMib.setDescription("This MIB module defines the basic management object\nfor the Multimedia Terminal Adapter devices compliant\nwith PacketCable and IPCablecom requirements.\n\nCopyright (C) The IETF Trust (2006).  This version of\nthis MIB module is part of RFC 4682; see the RFC itself for\nfull legal notices.")
pktcMtaNotification = MibIdentifier((1, 3, 6, 1, 2, 1, 140, 0))
pktcMtaMibObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 140, 1))
pktcMtaDevBase = MibIdentifier((1, 3, 6, 1, 2, 1, 140, 1, 1))
pktcMtaDevResetNow = MibScalar((1, 3, 6, 1, 2, 1, 140, 1, 1, 1), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: pktcMtaDevResetNow.setDescription(" This object controls the MTA software reset.\nReading this object always returns 'false'.  Setting this\nobject to 'true' causes the device to reset immediately\nand the following actions to occur:\n   1.  All connections (if present) are flushed locally.\n   2.  All current actions such as ringing immediately\n       terminate.\n   3.  Requests for signaling notifications, such as\n       notification based on digit map recognition, are\n       flushed.\n   4.  All endpoints are disabled.\n   5.  The provisioning flow is started at step MTA-1.\nIf a value is written into an instance of\npktcMtaDevResetNow, the agent MUST NOT retain the supplied\nvalue across MTA re-initializations or reboots.")
pktcMtaDevSerialNumber = MibScalar((1, 3, 6, 1, 2, 1, 140, 1, 1, 2), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pktcMtaDevSerialNumber.setDescription(" This object specifies the manufacturer's serial\nnumber of this MTA.  The value of this object MUST be\nidentical to the value specified in DHCP option 43,\nsub-option 4.  The list of sub-options for DHCP option\n43 are defined in the PacketCable MTA Device\nProvisioning Specification.")
pktcMtaDevSwCurrentVers = MibScalar((1, 3, 6, 1, 2, 1, 140, 1, 1, 3), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pktcMtaDevSwCurrentVers.setDescription(" This object identifies the software version currently\noperating in the MTA.\nThe MTA MUST return a string descriptive of the current\nsoftware load.  This object should use the syntax\ndefined by the individual vendor to identify the software\nversion.  The data presented in this object MUST be\nidentical to the software version information contained\nin the 'sysDescr' MIB object of the MTA.  The value of\nthis object MUST be identical to the value specified in\nDHCP option 43, sub-option 6.  The list of sub-options for\nDHCP option 43 are defined in the PacketCable MTA Device\nProvisioning Specification.")
pktcMtaDevFQDN = MibScalar((1, 3, 6, 1, 2, 1, 140, 1, 1, 4), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pktcMtaDevFQDN.setDescription(" This object contains the Fully Qualified Domain Name for\nthis MTA.  The MTA FQDN is used to uniquely identify the\ndevice to the PacketCable back office elements.")
pktcMtaDevEndPntCount = MibScalar((1, 3, 6, 1, 2, 1, 140, 1, 1, 5), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pktcMtaDevEndPntCount.setDescription(" This object contains the number of physical endpoints for\nthis MTA.")
pktcMtaDevEnabled = MibScalar((1, 3, 6, 1, 2, 1, 140, 1, 1, 6), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: pktcMtaDevEnabled.setDescription(" This object contains the MTA Admin Status of this device.\nIf this object is set to 'true', the MTA is\nadministratively enabled, and the MTA MUST be able to\ninteract with the PacketCable entities, such as CMS,\nProvisioning Server, KDC, and other MTAs and MGs on all\nPacketCable interfaces.\nIf this object is set to 'false', the MTA is\nadministratively disabled, and the MTA MUST perform the\nfollowing actions for all endpoints:\n    - Shut down all media sessions, if present.\n    - Shut down Network Control Signaling (NCS)\n    signaling by following the Restart in\n    Progress procedures in the PacketCable NCS\n    specification.\nThe MTA must execute all actions required to\nenable or disable the telephony services for all\nendpoints immediately upon receipt of an SNMP SET\noperation.\n\nAdditionally, the MTA MUST maintain the SNMP Interface\nfor management and also the SNMP Key management interface.\nAlso, the MTA MUST NOT continue Kerberized key management\nwith CMSes until this object is set to 'true'.\nNote: MTAs MUST renew the CMS Kerberos tickets according\nto the PacketCable Security or IPCablecom Specification.\nIf a value is written into an instance of\npktcMtaDevEnabled, the agent MUST NOT retain the supplied\nvalue across MTA re-initializations or reboots.")
pktcMtaDevTypeIdentifier = MibScalar((1, 3, 6, 1, 2, 1, 140, 1, 1, 7), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pktcMtaDevTypeIdentifier.setDescription(" This object provides the MTA device type identifier.  The\nvalue of this object must be a copy of the DHCP option 60\nvalue exchanged between the MTA and the DHCP server.  The\nDHCP option 60 value contains an ASCII-encoded string\nidentifying capabilities of the MTA as defined in the\nPacketCable MTA Device Provisioning Specification.")
pktcMtaDevProvisioningState = MibScalar((1, 3, 6, 1, 2, 1, 140, 1, 1, 8), Integer().subtype(subtypeSpec=SingleValueConstraint(6,4,3,7,5,2,1,)).subtype(namedValues=NamedValues(("pass", 1), ("inProgress", 2), ("failConfigFileError", 3), ("passWithWarnings", 4), ("passWithIncompleteParsing", 5), ("failureInternalError", 6), ("failureOtherReason", 7), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pktcMtaDevProvisioningState.setDescription(" This object indicates the completion state of the MTA\ndevice provisioning process.\n\npass:\nIf the configuration file could be parsed successfully\nand the MTA is able to reflect the same in its\nMIB, the MTA MUST return the value 'pass'.\n\ninProgress:\nIf the MTA is in the process of being provisioned,\nthe MTA MUST return the value 'inProgress'.\n\nfailConfigFileError:\nIf the configuration file was in error due to incorrect\nvalues in the mandatory parameters, the MTA MUST reject\nthe configuration file, and the MTA MUST return the value\n\n\n\n'failConfigFileError'.\n\npassWithWarnings:\nIf the configuration file had proper values for all the\nmandatory parameters but has errors in any of the optional\nparameters (this includes any vendor-specific Object\nIdentifiers (OIDs) that are incorrect or not known\nto the MTA), the MTA MUST return the value\n'passWithWarnings'.\n\npassWithIncompleteParsing:\nIf the configuration file is valid but the MTA cannot\nreflect the same in its configuration (for example, too\nmany entries caused memory exhaustion), it must accept\nthe CMS configuration entries related, and the MTA MUST\nreturn the value 'passWithIncompleteParsing'.\n\nfailureInternalError:\nIf the configuration file cannot be parsed due to an\nInternal error, the MTA MUST return the value\n'failureInternalError'.\n\nfailureOtherReason:\nIf the MTA cannot accept the configuration file for any\nother reason than the ones stated above, the MTA MUST\nreturn the value 'failureOtherReason'.\n\nWhen a final SNMP INFORM is sent as part of Step 25 of the\nMTA Provisioning process, this parameter is also included\nin the final INFORM message.")
pktcMtaDevHttpAccess = MibScalar((1, 3, 6, 1, 2, 1, 140, 1, 1, 9), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pktcMtaDevHttpAccess.setDescription(" This object indicates whether the HTTP protocol is\nsupported for the MTA configuration file transfer.")
pktcMtaDevProvisioningTimer = MibScalar((1, 3, 6, 1, 2, 1, 140, 1, 1, 10), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 30)).clone(10)).setMaxAccess("readwrite").setUnits("minutes")
if mibBuilder.loadTexts: pktcMtaDevProvisioningTimer.setDescription(" This object defines the time interval for the provisioning\nflow to complete.  The MTA MUST finish all provisioning\noperations starting from the moment when an MTA receives\nits DHCP ACK and ending at the moment when the MTA\ndownloads its configuration file (e.g., MTA5 to MTA23)\nwithin the period of time set by this object.\nFailure to comply with this condition constitutes\na provisioning flow failure.  If the object is set to 0,\nthe MTA MUST ignore the provisioning timer condition.\nIf a value is written into an instance of\npktcMtaDevProvisioningTimer, the agent MUST NOT retain the\nsupplied value across MTA re-initializations or reboots.")
pktcMtaDevProvisioningCounter = MibScalar((1, 3, 6, 1, 2, 1, 140, 1, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pktcMtaDevProvisioningCounter.setDescription("This object counts the number of times the\nprovisioning cycle has looped through step MTA-1.")
pktcMtaDevErrorOidsTable = MibTable((1, 3, 6, 1, 2, 1, 140, 1, 1, 12))
if mibBuilder.loadTexts: pktcMtaDevErrorOidsTable.setDescription(" This table contains the list of configuration errors or\nwarnings the MTA encountered when parsing the\nconfiguration file it received from the Provisioning\nServer.\nFor each error, an entry is created in this table,\ncontaining the configuration parameters the MTA rejected\nand the associated reason (e.g., wrong or unknown OID,\ninappropriate object values).  If the MTA\ndid not report a provisioning state of 'pass(1)' in\nthe pktcMtaDevProvisioningState object, this table MUST be\npopulated for each error or warning instance.  Even if\ndifferent parameters share the same error type (e.g., all\nrealm name configuration parameters are invalid), all\nobserved errors or warnings must be reported as\ndifferent instances.  Errors are placed into the table in\nno particular order.  The table MUST be cleared each time\n\n\n\nthe MTA reboots.")
pktcMtaDevErrorOidsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 140, 1, 1, 12, 1)).setIndexNames((0, "PKTC-IETF-MTA-MIB", "pktcMtaDevErrorOidIndex"))
if mibBuilder.loadTexts: pktcMtaDevErrorOidsEntry.setDescription(" This entry contains the necessary information the MTA MUST\nattempt to provide in case of configuration file errors or\nwarnings.")
pktcMtaDevErrorOidIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 140, 1, 1, 12, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 1024))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pktcMtaDevErrorOidIndex.setDescription(" This object is the index of the MTA configuration error\ntable.  It is an integer value that starts at value '1'\nand is incremented for each encountered configuration\nfile error or warning.\n\nThe maximum number of errors or warnings that can be\nrecorded in the pktcMtaDevErrorOidsTable is set to 1024 as\na configuration file is usually validated by operators\nbefore deployment.  Given the possible number of\nconfiguration parameter assignments in the MTA\nconfiguration file, 1024 is perceived as a sufficient\nlimit even with future extensions.\n\nIf the number of the errors in the configuration file\nexceeds 1024, all errors beyond the 1024th one MUST\nbe ignored and not be reflected in the\npktcMtaDevErrorOidsTable.")
pktcMtaDevErrorOid = MibTableColumn((1, 3, 6, 1, 2, 1, 140, 1, 1, 12, 1, 2), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pktcMtaDevErrorOid.setDescription(" This object contains a human readable representation\n(character string) of the OID corresponding to the\nconfiguration file parameter that caused the particular\nerror.\nFor example, if the value of the pktcMtaDevEnabled object\nin the configuration file caused an error, then this\nobject instance will contain the human-readable string of\n'1.3.6.1.2.1.140.1.1.6.0'.\nIf the MTA generated an error because it was not able\nto recognize a particular OID, then this object\ninstance would contain an empty value (zero-length\nstring).\nFor example, if the value of an OID in the configuration\nfile was interpreted by the MTA as being 1.2.3.4.5, and if\nthe MTA was not able to recognize this OID as a valid one,\nthis object instance will contain a zero-length string.\n\nIf the number of errors in the configuration file exceeds\n1024, then for all subsequent errors, the\npktcMtaDevErrorOid of the table's 1024th entry MUST\ncontain a human-readable representation of the\npktcMtaDevErrorsTooManyErrors object; i.e., the string\n'1.3.6.1.2.1.140.1.1.4.1.0'.\nNote that the syntax of this object is SnmpAdminString\ninstead of OBJECT IDENTIFIER because the object value may\nnot be a valid OID due to human or configuration tool\nencoding errors.")
pktcMtaDevErrorValue = MibTableColumn((1, 3, 6, 1, 2, 1, 140, 1, 1, 12, 1, 3), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pktcMtaDevErrorValue.setDescription(" This object contains the value of the OID corresponding to\nthe configuration file parameter that caused the error.\nIf the MTA cannot recognize the OID of the\nconfiguration parameter causing the error, then this\nobject instance contains the OID itself as interpreted\nby the MTA in human-readable representation.\nIf the MTA can recognize the OID but generate an error due\nto a wrong value of the parameter, then the object\n\n\n\ninstance contains the erroneous value of the parameter as\nread from the configuration file.\nIn both cases, the value of this object must be\nrepresented in human-readable form as a character string.\nFor example, if the value of the pktcMtaDevEnabled object\nin the configuration file was 3 (invalid value), then the\npktcMtaDevErrorValue object instance will contain the\nhuman-readable (string) representation of value '3'.\nSimilarly, if the OID in the configuration file has been\ninterpreted by the MTA as being 1.2.3.4.5 and the MTA\ncannot recognize this OID as a valid one, then this\npktcMtaDevErrorValue object instance will contain human\nreadable (string) representation of value '1.2.3.4.5'.\n\nIf the number of errors in the configuration file exceeds\n1024, then for all subsequent errors, the\npktcMtaDevErrorValue of the table's 1024th entry MUST\ncontain a human-readable representation of the\npktcMtaDevErrorsTooManyErrors object; i.e., the string\n'1.3.6.1.2.1.140.1.1.4.1.0'.")
pktcMtaDevErrorReason = MibTableColumn((1, 3, 6, 1, 2, 1, 140, 1, 1, 12, 1, 4), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pktcMtaDevErrorReason.setDescription(" This object indicates the reason for the error or warning,\nas per the MTA's interpretation, in human-readable form.\nFor example:\n'VALUE NOT IN RANGE', 'VALUE DOES NOT MATCH TYPE',\n'UNSUPPORTED VALUE', 'LAST 4 BITS MUST BE SET TO ZERO',\n'OUT OF MEMORY - CANNOT STORE'.\nThis object may also contain vendor specific errors for\nprivate vendor OIDs and any proprietary error codes or\nmessages that can help diagnose configuration errors.\n\nIf the number of errors in the configuration file exceeds\n1024, then for all subsequent errors, the\npktcMtaDevErrorReason of the table's 1024th entry MUST\ncontain a human-readable string indicating the reason\nfor an error; for example,\n'Too many errors in the configuration file'.")
pktcMtaDevServer = MibIdentifier((1, 3, 6, 1, 2, 1, 140, 1, 2))
pktcMtaDevDhcpServerAddressType = MibScalar((1, 3, 6, 1, 2, 1, 140, 1, 2, 1), InetAddressType().clone('ipv4')).setMaxAccess("readonly")
if mibBuilder.loadTexts: pktcMtaDevDhcpServerAddressType.setDescription(" This object contains the Internet address type for the\nPacketCable DHCP servers specified in MTA MIB.")
pktcMtaDevServerDhcp1 = MibScalar((1, 3, 6, 1, 2, 1, 140, 1, 2, 2), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pktcMtaDevServerDhcp1.setDescription(" This object contains the Internet Address of the primary\nDHCP server the MTA uses during provisioning.\nThe type of this address is determined by the value of\nthe pktcMtaDevDhcpServerAddressType object.\nWhen the latter has the value 'ipv4(1)', this object\ncontains the IP address of the primary DHCP\nserver.  It is provided by the CM to the MTA via the DHCP\noption code 122, sub-option 1, as defined in RFC 3495.\n\nThe behavior of this object when the value of\npktcMtaDevDhcpServerAddressType is other than 'ipv4(1)'\nis not presently specified, but it may be specified\nin future versions of this MIB module.\nIf this object is of value\n0.0.0.0, the MTA MUST stop all provisioning\nattempts, as well as all other activities.\nIf this object is of value 255.255.255.255, it means\nthat there was no preference given for the primary\nDHCP server, and, the MTA must follow the logic of\nRFC2131, and the value of DHCP option 122,\nsub-option 2, must be ignored.")
pktcMtaDevServerDhcp2 = MibScalar((1, 3, 6, 1, 2, 1, 140, 1, 2, 3), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pktcMtaDevServerDhcp2.setDescription(" This object contains the Internet Address of the secondary\nDHCP server the MTA uses during provisioning.\nThe type of this address is determined by the value of\nthe pktcMtaDevDhcpServerAddressType object.\nWhen the latter has the value 'ipv4(1)', this object\ncontains the IP address of the secondary DHCP\nserver.  It is provided by the CM to the MTA via the DHCP\noption code 122, sub-option 2, as defined in RFC 3495.\n\nThe behavior of this object when the value of\npktcMtaDevDhcpServerAddressType is other than 'ipv4(1)'\nis not presently specified, but it may be specified\nin future versions of this MIB module.\nIf there was no secondary DHCP server provided in DHCP\nOption 122, sub-option 2, this object must return the value\n0.0.0.0.")
pktcMtaDevDnsServerAddressType = MibScalar((1, 3, 6, 1, 2, 1, 140, 1, 2, 4), InetAddressType().clone('ipv4')).setMaxAccess("readonly")
if mibBuilder.loadTexts: pktcMtaDevDnsServerAddressType.setDescription(" This object contains the Internet address type for the\nPacketCable DNS servers specified in MTA MIB.")
pktcMtaDevServerDns1 = MibScalar((1, 3, 6, 1, 2, 1, 140, 1, 2, 5), InetAddress()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: pktcMtaDevServerDns1.setDescription(" This object contains the IP Address of the primary\nDNS server to be used by the MTA.  The type of this address\nis determined by the value of the\npktcMtaDevDnsServerAddressType object.\nWhen the latter has the value 'ipv4(1)', this object\ncontains the IP address of the primary DNS server.\nAs defined in RFC 2132, PacketCable-compliant MTAs receive\nthe IP addresses of the DNS Servers in DHCP option 6.\nThe behavior of this object when the value of\npktcMtaDevDnsServerAddressType is other than 'ipv4(1)'\n\n\n\nis not presently specified, but it may be specified\nin future versions of this MIB module.\nIf a value is written into an instance of\npktcMtaDevServerDns1, the agent MUST NOT retain the\nsupplied value across MTA re-initializations or reboots.")
pktcMtaDevServerDns2 = MibScalar((1, 3, 6, 1, 2, 1, 140, 1, 2, 6), InetAddress()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: pktcMtaDevServerDns2.setDescription(" This object contains the IP Address of the secondary\nDNS server to be used by the MTA.  The type of this address\nis determined by the value of the\npktcMtaDevDnsServerAddressType object.\nWhen the latter has the value 'ipv4(1)', this object\ncontains the IP address of the secondary DNS\nserver.  As defined in RFC 2132, PacketCable-compliant MTAs\nreceive the IP addresses of the DNS Servers in DHCP\noption 6.\nThe behavior of this object when the value of\npktcMtaDevDnsServerAddressType is other than 'ipv4(1)'\nis not presently specified, but it may be specified\nin future versions of this MIB module.\nIf a value is written into an instance of\npktcMtaDevServerDns2, the agent MUST NOT retain the\nsupplied value across MTA re-initializations or reboots.")
pktcMtaDevTimeServerAddressType = MibScalar((1, 3, 6, 1, 2, 1, 140, 1, 2, 7), InetAddressType().clone('ipv4')).setMaxAccess("readonly")
if mibBuilder.loadTexts: pktcMtaDevTimeServerAddressType.setDescription(" This object contains the Internet address type for the\nPacketCable Time servers specified in MTA MIB.")
pktcMtaDevTimeServer = MibScalar((1, 3, 6, 1, 2, 1, 140, 1, 2, 8), InetAddress()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: pktcMtaDevTimeServer.setDescription(" This object contains the Internet Address of the Time\nServer used by an S-MTA for Time Synchronization.  The type\nof this address is determined by the value of the\npktcMtaDevTimeServerAddressType object.\nWhen the latter has the value 'ipv4(1)', this object\ncontains the IP address of the Time Server used for Time\nSynchronization.\nIn the case of an S-MTA, this object must be\npopulated with a value other than 0.0.0.0 as obtained\nfrom DHCP option 4.  The protocol by which the time of day\nMUST be retrieved is defined in RFC 868.\nIn the case of an E-MTA, this object must contain a\nvalue of 0.0.0.0 if the address type is 'ipv4(1)' since\nan E-MTA does not use the Time Protocol for time\nsynchronization (an E-MTA uses the time retrieved by the\nDOCSIS cable modem).\nThe behavior of this object when the value of\npktcMtaDevTimeServerAddressType is other than 'ipv4(1)'\nis not presently specified, but it may be specified in\nfuture versions of this MIB module.\nIf a value is written into an instance of\npktcMtaDevTimeServer, the agent MUST NOT retain the\nsupplied value across MTA re-initializations or reboots.")
pktcMtaDevConfigFile = MibScalar((1, 3, 6, 1, 2, 1, 140, 1, 2, 9), SnmpAdminString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: pktcMtaDevConfigFile.setDescription(" This object specifies the MTA device configuration file\ninformation, including the access method, the server name,\nand the configuration file name.  The value of this object\nis the Uniform Resource Locator (URL) of the configuration\nfile for TFTP or HTTP download.\nIf this object value is a TFTP URL, it must be formatted\nas defined in RFC 3617.\nIf this object value is an HTTP URL, it must be formatted\nas defined in RFC 2616.\nIf the MTA SNMP Enrollment mechanism is used, then the MTA\nmust download the file provided by the Provisioning Server\n\n\n\nduring provisioning via an SNMP SET on this object.\nIf the MTA SNMP Enrollment mechanism is not used, this\nobject MUST contain the URL value corresponding to the\n'siaddr' and 'file' fields received in the DHCP ACK to\nlocate the configuration file: the 'siaddr' and 'file'\nfields represent the host and file of the TFTP URL,\nrespectively.  In this case, the MTA MUST return an\n'inconsistentValue' error in response to SNMP SET\noperations.\nThe MTA MUST return a zero-length string if the server\naddress (host part of the URL) is unknown.\nIf a value is written into an instance of\npktcMtaDevConfigFile, the agent MUST NOT retain the\nsupplied value across MTA re-initializations or reboots.")
pktcMtaDevSnmpEntity = MibScalar((1, 3, 6, 1, 2, 1, 140, 1, 2, 10), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pktcMtaDevSnmpEntity.setDescription(" This object contains the FQDN of the SNMP entity of the\nProvisioning Server.  When the MTA SNMP Enrollment\nMechanism is used, this object represents the server that\nthe MTA communicates with, that it receives the\nconfiguration file URL from, and that it sends the\nenrollment notification to.  The SNMP entity is also the\ndestination entity for all the provisioning\nnotifications.  It may be used for post-provisioning\nSNMP operations.  During the provisioning phase, this\nSNMP entity FQDN is supplied to the MTA via DHCP option\n122, sub-option 3, as defined in RFC 3495.  The MTA must\nresolve the FQDN value before its very first network\ninteraction with the SNMP entity during the provisioning\nphase.")
pktcMtaDevProvConfigHash = MibScalar((1, 3, 6, 1, 2, 1, 140, 1, 2, 11), OctetString().subtype(subtypeSpec=ValueSizeConstraint(20, 20)).setFixedLength(20)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: pktcMtaDevProvConfigHash.setDescription(" This object contains the hash value of the contents of the\nconfiguration file.\nThe authentication algorithm is Secure Hashing Algorithm\n1 (SHA-1), and the length is 160 bits.  The hash\ncalculation MUST follow the requirements defined in the\nPacketCable Security Specification.  When the MTA SNMP\nEnrollment mechanism is used, this hash value is\ncalculated and sent to the MTA prior to sending the\nconfig file.  This object value is then provided by the\nProvisioning server via an SNMP SET operation.\nWhen the MTA SNMP Enrollment mechanism is not in use, the\nhash value is provided in the configuration file itself,\nand it is also calculated by the MTA.  This object value\nMUST represent the hash value calculated by the MTA.\nWhen the MTA SNMP Enrollment mechanism is not in use, the\nMTA must reject all SNMP SET operations on this object and\nreturn an 'inconsistentValue' error.\nIf a value is written into an instance of\npktcMtaDevProvConfigHash, the agent MUST NOT retain the\nsupplied value across MTA re-initializations or reboots.")
pktcMtaDevProvConfigKey = MibScalar((1, 3, 6, 1, 2, 1, 140, 1, 2, 12), OctetString().subtype(subtypeSpec=ValueSizeConstraint(32, 32)).setFixedLength(32)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: pktcMtaDevProvConfigKey.setDescription(" This object contains the key used to encrypt/decrypt\nthe configuration file when secure SNMPv3 provisioning\nis used.\nThe value of this object is provided along with the\nconfiguration file information (pktcMtaDevConfigFile)\nand hash (pktcMtaDevProvConfigHash) by the Provisioning\nServer via SNMP SET once the configuration file has been\ncreated, as defined by the PacketCable Security\nspecification.\n\nThe privacy algorithm is defined by the\npktcMtaDevProvConfigEncryptAlg MIB object.  The\nMTA requirements related to the privacy algorithm are\ndefined in the PacketCable Security Specification.\n\nIf this object is set at any other provisioning step than\nthat allowed by the PacketCable MTA Device\n\n\n\nProvisioning Specification, the MTA SHOULD return\nan 'inconsistentValue' error.\nThis object must not be used in non secure provisioning\nmode.  In non-secure provisioning modes, the MTA SHOULD\nreturn an 'inconsistentValue' in response to SNMP SET\noperations, and the MTA SHOULD return a zero-length\nstring in response to SNMP GET operations.\nIf a value is written into an instance of\npktcMtaDevProvConfigKey, the agent MUST NOT retain the\nsupplied value across MTA re-initializations or reboots.")
pktcMtaDevProvConfigEncryptAlg = MibScalar((1, 3, 6, 1, 2, 1, 140, 1, 2, 13), PktcMtaDevProvEncryptAlg().clone('des64CbcMode')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: pktcMtaDevProvConfigEncryptAlg.setDescription(" This object defines the encryption algorithm used for\nprivacy protection of the MTA Configuration File content.")
pktcMtaDevProvSolicitedKeyTimeout = MibScalar((1, 3, 6, 1, 2, 1, 140, 1, 2, 14), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 180)).clone(3)).setMaxAccess("readwrite").setUnits("seconds")
if mibBuilder.loadTexts: pktcMtaDevProvSolicitedKeyTimeout.setDescription(" This object defines a Kerberos Key Management timer on the\nMTA.  It is the time period during which the MTA saves the\nnonce and Server Kerberos Principal Identifier to match an\nAP Request and its associated AP Reply response from the\nProvisioning Server.\nAfter the timeout has been exceeded, the client discards\nthis (nonce, Server Kerberos Principal Identifier) pair,\nafter which it will no longer accept a matching AP Reply.\nThis timer only applies when the Provisioning Server\ninitiated key management for SNMPv3 (with a\nWake Up message).\nIf this object is set to a zero value, the MTA MUST return\nan 'inconsistentValue' in response to SNMP SET operations.\nThis object should not be used in non-secure provisioning\nmodes.  In non-secure provisioning modes, the MTA MUST\nreturn an 'inconsistentValue' in response to SNMP SET\noperations, and the MTA MUST return a zero value in\n\n\n\nresponse to SNMP GET operations.\nIf a value is written into an instance of\npktcMtaDevProvSolicitedKeyTimeout, the agent MUST NOT\nretain the supplied value across MTA re-initializations\nor reboots.")
pktcMtaDevProvUnsolicitedKeyMaxTimeout = MibScalar((1, 3, 6, 1, 2, 1, 140, 1, 2, 15), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 600)).clone(600)).setMaxAccess("readonly").setUnits("seconds")
if mibBuilder.loadTexts: pktcMtaDevProvUnsolicitedKeyMaxTimeout.setDescription(" This object defines the timeout value that applies to\nan MTA-initiated AP-REQ/REP key management exchange with\nthe Provisioning Server in SNMPv3 provisioning.\nIt is the maximum timeout value, and it may not be exceeded\nin the exponential back-off algorithm.  If the DHCP option\n\n\n\ncode 122, sub-option 5, is provided to the MTA, it\noverwrites this value.\nIn non-secure provisioning modes, the MTA MUST\nreturn a zero value in response to SNMP GET\noperations.")
pktcMtaDevProvUnsolicitedKeyNomTimeout = MibScalar((1, 3, 6, 1, 2, 1, 140, 1, 2, 16), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 600)).clone(3)).setMaxAccess("readonly").setUnits("seconds")
if mibBuilder.loadTexts: pktcMtaDevProvUnsolicitedKeyNomTimeout.setDescription(" This object defines the starting value of the timeout\nfor the AP-REQ/REP Backoff and Retry mechanism\nwith exponential timeout in SNMPv3 provisioning.\nIf the DHCP option code 122, sub-option 5, is provided\nthe MTA, it overwrites this value.\nIn non-secure provisioning modes, the MTA MUST\nreturn a zero value in response to SNMP GET\noperations.")
pktcMtaDevProvUnsolicitedKeyMaxRetries = MibScalar((1, 3, 6, 1, 2, 1, 140, 1, 2, 17), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 32)).clone(8)).setMaxAccess("readonly")
if mibBuilder.loadTexts: pktcMtaDevProvUnsolicitedKeyMaxRetries.setDescription(" This object contains a retry counter that applies to\nan MTA-initiated AP-REQ/REP key management exchange with\nthe Provisioning Server in secure SNMPv3 provisioning.\nIt is the maximum number of retries before the MTA stops\nattempting to establish a Security Association with\nProvisioning Server.\nIf the DHCP option code 122, sub-option 5, is provided to\nthe MTA, it overwrites this value.\nIf this object is set to a zero value, the MTA MUST return\nan 'inconsistentValue' in response to SNMP SET operations.\nIn non-secure provisioning modes, the MTA MUST\nreturn a zero value in response to SNMP GET\noperations.")
pktcMtaDevProvKerbRealmName = MibScalar((1, 3, 6, 1, 2, 1, 140, 1, 2, 18), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(1, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pktcMtaDevProvKerbRealmName.setDescription(" This object contains the name of the associated\nprovisioning Kerberos realm acquired during the MTA4\nprovisioning step (DHCP Ack) for SNMPv3 provisioning.\nThe uppercase ASCII representation of the associated\nKerberos realm name MUST be used by both the Manager (SNMP\nentity) and the MTA.\nThe Kerberos realm name for the Provisioning Server is\nsupplied to the MTA via DHCP option code 122, sub-option 6,\nas defined in RFC 3495.  In secure SNMP provisioning mode,\nthe value of the Kerberos realm name for the Provisioning\nServer supplied in the MTA configuration file must match\nthe value supplied in the DHCP option code 122,\nsub-option 6.  Otherwise, the value of this object must\ncontain the value supplied in DHCP Option 122,\nsub-option 6.")
pktcMtaDevProvState = MibScalar((1, 3, 6, 1, 2, 1, 140, 1, 2, 19), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,4,2,)).subtype(namedValues=NamedValues(("operational", 1), ("waitingForSnmpSetInfo", 2), ("waitingForTftpAddrResponse", 3), ("waitingForConfigFile", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pktcMtaDevProvState.setDescription(" This object defines the MTA provisioning state.\nIf the state is:\n\n  'operational(1)', the device has completed the loading\n   and processing of the initialization parameters.\n\n  'waitingForSnmpSetInfo(2)', the device is waiting on\n   its configuration file download access information.\n   Note that this state is only reported when the MTA\n\n\n\n   SNMP enrollment mechanism is used.\n\n  'waitingForTftpAddrResponse(3)', the device has sent a\n   DNS request to resolve the server providing the\n   configuration file, and it is awaiting for a response.\n   Note that this state is only reported when the MTA\n   SNMP enrollment mechanism is used.\n\n  'waitingForConfigFile(4)', the device has sent a\n  request via TFTP or HTTP for the download of its\n  configuration file, and it is awaiting for a response or\n  the file download is in progress.")
pktcMtaDevSecurity = MibIdentifier((1, 3, 6, 1, 2, 1, 140, 1, 3))
pktcMtaDevManufacturerCertificate = MibScalar((1, 3, 6, 1, 2, 1, 140, 1, 3, 1), DocsX509ASN1DEREncodedCertificate()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pktcMtaDevManufacturerCertificate.setDescription(" This object contains the MTA Manufacturer Certificate.\nThe object value must be the ASN.1 DER encoding of the MTA\nmanufacturer's X.509 public key certificate.  The MTA\nManufacturer Certificate is issued to each MTA\nmanufacturer and is installed into each MTA at the time of\nmanufacture or with a secure code download.  The specific\nrequirements related to this certificate are defined in\nthe PacketCable or IPCablecom Security specifications.")
pktcMtaDevCertificate = MibScalar((1, 3, 6, 1, 2, 1, 140, 1, 3, 2), DocsX509ASN1DEREncodedCertificate()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pktcMtaDevCertificate.setDescription(" This object contains the MTA Device Certificate.\nThe object value must be the ASN.1 DER encoding of the\nMTA's X.509 public-key certificate issued by the\nmanufacturer and installed into the MTA at the time of\n\n\n\nmanufacture or with a secure code download.\nThis certificate contains the MTA MAC address.  The\nspecific requirements related to this certificate are\ndefined in the PacketCable or IPCablecom Security\nspecifications.")
pktcMtaDevCorrelationId = MibScalar((1, 3, 6, 1, 2, 1, 140, 1, 3, 3), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pktcMtaDevCorrelationId.setDescription(" This object contains a correlation ID, an arbitrary value\ngenerated by the MTA that will be exchanged as part of the\ndevice capability data to the Provisioning Application.\nThis random value is used as an identifier to correlate\nrelated events in the MTA provisioning sequence.\nThis value is intended for use only during the MTA\ninitialization and configuration file download.")
pktcMtaDevTelephonyRootCertificate = MibScalar((1, 3, 6, 1, 2, 1, 140, 1, 3, 4), DocsX509ASN1DEREncodedCertificate()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pktcMtaDevTelephonyRootCertificate.setDescription(" This object contains the telephony Service Provider Root\ncertificate.  The object value is the ASN.1 DER encoding of\nthe IP Telephony Service Provider Root X.509 public key\ncertificate.  This certification is stored in the MTA\nnon-volatile memory and can be updated with a secure code\ndownload.  This certificate is used to validate the initial\nAS Reply received by the MTA from the Key Distribution\nCenter (KDC) during the MTA initialization.  The specific\nrequirements related to this certificate are defined in\nthe PacketCable or IPCablecom Security specifications.")
pktcMtaDevRealmAvailSlot = MibScalar((1, 3, 6, 1, 2, 1, 140, 1, 3, 5), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 64))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pktcMtaDevRealmAvailSlot.setDescription(" This object contains the index number of the first\navailable entry in the realm table (pktcMtaDevRealmTable).\nIf all the entries in the realm table have been assigned,\nthis object contains the value of zero.\nA management station should create new entries in the\nrealm table, using the following procedure:\n\nFirst, issue a management protocol retrieval operation\nto determine the value of the first available index in the\nrealm table (pktcMtaDevRealmAvailSlot).\n\nSecond, issue a management protocol SET operation\nto create an instance of the pktcMtaDevRealmStatus\nobject by setting its value to 'createAndWait(5)'.\n\nThird, if the SET operation succeeded, continue\nmodifying the object instances corresponding to the newly\ncreated conceptual row, without fear of collision with\nother management stations.  When all necessary conceptual\ncolumns of the row are properly populated (via SET\noperations or default values), the management station may\nSET the pktcMtaDevRealmStatus object to 'active(1)'.")
pktcMtaDevRealmTable = MibTable((1, 3, 6, 1, 2, 1, 140, 1, 3, 6))
if mibBuilder.loadTexts: pktcMtaDevRealmTable.setDescription(" This object contains the realm table.\nThe CMS table (pktcMtaDevCmsTable) and the realm table\n(pktcMtaDevRealmTable) are used for managing the MTA-CMS\nSecurity Associations.  The realm table defines the\nKerberos realms for the Application Servers (CMSes and the\nProvisioning Server).")
pktcMtaDevRealmEntry = MibTableRow((1, 3, 6, 1, 2, 1, 140, 1, 3, 6, 1)).setIndexNames((0, "PKTC-IETF-MTA-MIB", "pktcMtaDevRealmIndex"))
if mibBuilder.loadTexts: pktcMtaDevRealmEntry.setDescription(" This table entry object lists the MTA security parameters\nfor a single Kerberos realm.  The conceptual rows MUST NOT\npersist across MTA reboots.")
pktcMtaDevRealmIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 140, 1, 3, 6, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 64))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pktcMtaDevRealmIndex.setDescription(" This object defines the realm table index.")
pktcMtaDevRealmName = MibTableColumn((1, 3, 6, 1, 2, 1, 140, 1, 3, 6, 1, 2), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(1, 255))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pktcMtaDevRealmName.setDescription(" This object identifies the Kerberos realm name in all\ncapitals.  The MTA MUST prohibit the instantiation of any\ntwo rows with identical Kerberos realm names.  The MTA MUST\nalso verify that any search operation involving Kerberos\nrealm names is done using the uppercase ASCII\nrepresentation of the characters.")
pktcMtaDevRealmPkinitGracePeriod = MibTableColumn((1, 3, 6, 1, 2, 1, 140, 1, 3, 6, 1, 3), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(15, 600)).clone(15)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pktcMtaDevRealmPkinitGracePeriod.setDescription(" This object contains the PKINIT Grace Period.  For the\npurpose of key management with Application Servers (CMSes\n\n\n\nor the Provisioning Server), the MTA must utilize the\nPKINIT exchange to obtain Application Server tickets.  The\nMTA may utilize the PKINIT exchange to obtain Ticket\nGranting Tickets (TGTs), which are then used to obtain\nApplication Server tickets in a TGS exchange.\nThe PKINIT exchange occurs according to the current Ticket\nExpiration Time (TicketEXP) and on the PKINIT Grace Period\n(PKINITGP).  The MTA MUST initiate the PKINIT exchange at\nthe time: TicketEXP - PKINITGP.")
pktcMtaDevRealmTgsGracePeriod = MibTableColumn((1, 3, 6, 1, 2, 1, 140, 1, 3, 6, 1, 4), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 600)).clone(10)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pktcMtaDevRealmTgsGracePeriod.setDescription(" This object contains the Ticket Granting Server Grace\nPeriod (TGSGP).  The Ticket Granting Server (TGS)\nRequest/Reply exchange may be performed by the MTA\non demand whenever an Application Server ticket is\nneeded to establish security parameters.  If the MTA\npossesses a ticket that corresponds to the Provisioning\nServer or a CMS that currently exists in the CMS table,\nthe MTA MUST initiate the TGS Request/Reply exchange\nat the time: TicketEXP - TGSGP.")
pktcMtaDevRealmOrgName = MibTableColumn((1, 3, 6, 1, 2, 1, 140, 1, 3, 6, 1, 5), LongUtf8String()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pktcMtaDevRealmOrgName.setDescription(" This object contains the X.500 organization name attribute\nas defined in the subject name of the service provider\ncertificate.")
pktcMtaDevRealmUnsolicitedKeyMaxTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 140, 1, 3, 6, 1, 6), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 600)).clone(100)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pktcMtaDevRealmUnsolicitedKeyMaxTimeout.setDescription(" This object specifies the maximum time the MTA will\nattempt to perform the exponential back-off algorithm.\nThis timer only applies when the MTA initiated key\nmanagement.  If the DHCP option code 122, sub-option 4, is\nprovided to the MTA, it overwrites this value.\n\nUnsolicited key updates are retransmitted according to an\nexponential back-off mechanism using two timers and a\nmaximum retry counter for AS replies.\nThe initial retransmission timer value is the nominal\ntimer value (pktcMtaDevRealmUnsolicitedKeyNomTimeout).  The\nretransmissions occur with an exponentially increasing\ninterval that caps at the maximum timeout value\n(pktcMtaDevRealmUnsolicitedKeyMaxTimeout).\nRetransmissions stop when the maximum retry counter is\nreached (pktcMatDevRealmUnsolicitedMaxRetries).\n\nFor example, with values of 3 seconds for the nominal\ntimer, 20 seconds for the maximum timeout, and 5 retries\nmax, retransmission intervals will be 3 s, 6 s,\n12 s, 20 s, and 20 s, and retransmissions then stop because\nthe maximum number of retries has been reached.")
pktcMtaDevRealmUnsolicitedKeyNomTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 140, 1, 3, 6, 1, 7), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(100, 600000)).clone(3000)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pktcMtaDevRealmUnsolicitedKeyNomTimeout.setDescription(" This object specifies the initial timeout value\nfor the AS-REQ/AS-REP exponential back-off and retry\nmechanism.  If the DHCP option code 122, sub-option 4, is\nprovided to the MTA, it overwrites this value.\nThis value should account for the average roundtrip\ntime between the MTA and the KDC, as well as the\nprocessing delay on the KDC.\n\n\n\n\nUnsolicited key updates are retransmitted according to an\nexponential back-off mechanism using two timers and a\nmaximum retry counter for AS replies.\nThe initial retransmission timer value is the nominal\ntimer value (pktcMtaDevRealmUnsolicitedKeyNomTimeout).  The\nretransmissions occur with an exponentially increasing\ninterval that caps at the maximum timeout value\n(pktcMtaDevRealmUnsolicitedKeyMaxTimeout).\nRetransmissions stop when the maximum retry counter is\nreached (pktcMatDevRealmUnsolicitedMaxRetries).\n\nFor example, with values of 3 seconds for the nominal\ntimer, 20 seconds for the maximum timeout, and 5 retries\nmax, in retransmission intervals will be 3 s, 6 s,\n12 s, 20 s, and 20 s; retransmissions then stop because\nthe maximum number of retries has been reached.")
pktcMtaDevRealmUnsolicitedKeyMaxRetries = MibTableColumn((1, 3, 6, 1, 2, 1, 140, 1, 3, 6, 1, 8), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 1024)).clone(5)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pktcMtaDevRealmUnsolicitedKeyMaxRetries.setDescription(" This object specifies the maximum number of retries the\nMTA attempts to obtain a ticket from the KDC.\n\nUnsolicited key updates are retransmitted according to an\nexponential back-off mechanism using two timers and a\nmaximum retry counter for AS replies.\nThe initial retransmission timer value is the nominal\ntimer value (pktcMtaDevRealmUnsolicitedKeyNomTimeout).  The\nretransmissions occur with an exponentially increasing\ninterval that caps at the maximum timeout value\n(pktcMtaDevRealmUnsolicitedKeyMaxTimeout).\nRetransmissions stop when the maximum retry counter is\nreached (pktcMatDevRealmUnsolicitedMaxRetries).\n\nFor example, with values of 3 seconds for the nominal\ntimer, 20 seconds for the maximum timeout, and 5 retries\nmax, retransmission intervals will be 3 s, 6 s,\n12 s, 20 s, and 20 s; retransmissions then stop because\nthe maximum number of retries has been reached.")
pktcMtaDevRealmStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 140, 1, 3, 6, 1, 9), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pktcMtaDevRealmStatus.setDescription(" This object defines the row status of this realm in the\nrealm table (pktcMtaDevRealmTable).\n\nAn entry in this table is not qualified for activation\nuntil the object instances of all corresponding columns\nhave been initialized, either by default values, or via\nexplicit SET operations.  Until all object instances in\nthis row are initialized, the status value for this realm\nmust be 'notReady(3)'.\nIn particular, two columnar objects must be explicitly\nSET: the realm name (pktcMtaDevRealmName) and the\norganization name (pktcMtaDevRealmOrgName).  Once these 2\nobjects have been set and the row status is SET to\n'active(1)', the MTA MUST NOT allow any modification of\nthese 2 object values.\nThe value of this object has no effect on whether other\ncolumnar objects in this row can be modified.")
pktcMtaDevCmsAvailSlot = MibScalar((1, 3, 6, 1, 2, 1, 140, 1, 3, 7), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pktcMtaDevCmsAvailSlot.setDescription(" This object contains the index number of the first\navailable entry in the CMS table (pktcMtaDevCmsTable).\nIf all the entries in the CMS table have been assigned,\nthis object contains the value of zero.\nA management station should create new entries in the\nCMS table, using the following procedure:\n\nFirst, issue a management protocol retrieval operation\nto determine the value of the first available index in the\nCMS table (pktcMtaDevCmsAvailSlot).\n\nSecond, issue a management protocol SET operation\nto create an instance of the pktcMtaDevCmsStatus\nobject by setting its value to 'createAndWait(5)'.\n\nThird, if the SET operation succeeded, continue\nmodifying the object instances corresponding to the newly\ncreated conceptual row, without fear of collision with\nother management stations.  When all necessary conceptual\ncolumns of the row are properly populated (via SET\noperations or default values), the management station may\nSET the pktcMtaDevCmsStatus object to 'active(1)'.")
pktcMtaDevCmsTable = MibTable((1, 3, 6, 1, 2, 1, 140, 1, 3, 8))
if mibBuilder.loadTexts: pktcMtaDevCmsTable.setDescription(" This object defines the CMS table.\nThe CMS table (pktcMtaDevCmsTable) and the realm table\n(pktcMtaDevRealmTable) are used for managing security\nbetween the MTA and CMSes.  Each CMS table entry defines\na CMS the managed MTA is allowed to communicate with\nand contains security parameters for key management with\nthat CMS.")
pktcMtaDevCmsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 140, 1, 3, 8, 1)).setIndexNames((0, "PKTC-IETF-MTA-MIB", "pktcMtaDevCmsIndex"))
if mibBuilder.loadTexts: pktcMtaDevCmsEntry.setDescription(" This table entry object lists the MTA key management\nparameters used when establishing Security Associations\nwith a CMS.  The conceptual rows MUST NOT persist across\nMTA reboots.")
pktcMtaDevCmsIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 140, 1, 3, 8, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 128))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pktcMtaDevCmsIndex.setDescription(" This object defines the CMS table index.")
pktcMtaDevCmsFqdn = MibTableColumn((1, 3, 6, 1, 2, 1, 140, 1, 3, 8, 1, 2), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(1, 255))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pktcMtaDevCmsFqdn.setDescription(" This object specifies the CMS FQDN.  The MTA must\nprohibit the instantiation of any two rows with identical\nFQDNs.  The MTA must also verify that any search and/or\ncomparison operation involving a CMS FQDN is case\ninsensitive.  The MTA must resolve the CMS FQDN as required\n by the corresponding PacketCable Specifications.")
pktcMtaDevCmsKerbRealmName = MibTableColumn((1, 3, 6, 1, 2, 1, 140, 1, 3, 8, 1, 3), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(1, 255))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pktcMtaDevCmsKerbRealmName.setDescription(" This object identifies the Kerberos realm name in uppercase\ncharacters associated with the CMS defined in this\n\n\n\nconceptual row.  The object value is a reference\npoint to the corresponding Kerberos realm name in the\nrealm table (pktcMtaDevRealmTable).")
pktcMtaDevCmsMaxClockSkew = MibTableColumn((1, 3, 6, 1, 2, 1, 140, 1, 3, 8, 1, 4), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 1800)).clone(300)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pktcMtaDevCmsMaxClockSkew.setDescription(" This object specifies the maximum allowable clock skew\nbetween the MTA and the CMS defined in this row.")
pktcMtaDevCmsSolicitedKeyTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 140, 1, 3, 8, 1, 5), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(100, 30000)).clone(1000)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pktcMtaDevCmsSolicitedKeyTimeout.setDescription(" This object defines a Kerberos Key Management timer on the\nMTA.  It is the time period during which the MTA saves the\nnonce and Server Kerberos Principal Identifier to match an\nAP Request and its associated AP Reply response from the\nCMS.  This timer only applies when the CMS initiated key\nmanagement (with a Wake Up message or a Rekey message).")
pktcMtaDevCmsUnsolicitedKeyMaxTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 140, 1, 3, 8, 1, 6), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 600)).clone(600)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pktcMtaDevCmsUnsolicitedKeyMaxTimeout.setDescription(" This object defines the timeout value that only applies\nto an MTA-initiated key management exchange.  It is the\nmaximum timeout, and it may not be exceeded in the\nexponential back-off algorithm.")
pktcMtaDevCmsUnsolicitedKeyNomTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 140, 1, 3, 8, 1, 7), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(100, 30000)).clone(500)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pktcMtaDevCmsUnsolicitedKeyNomTimeout.setDescription(" This object defines the starting value of the timeout\nfor an MTA-initiated key management.  It should account for\nthe average roundtrip time between the MTA and the CMS and\nthe processing time on the CMS.")
pktcMtaDevCmsUnsolicitedKeyMaxRetries = MibTableColumn((1, 3, 6, 1, 2, 1, 140, 1, 3, 8, 1, 8), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 1024)).clone(5)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pktcMtaDevCmsUnsolicitedKeyMaxRetries.setDescription(" This object contains the maximum number of retries before\nthe MTA stops attempting to establish a Security\nAssociation with the CMS.")
pktcMtaDevCmsIpsecCtrl = MibTableColumn((1, 3, 6, 1, 2, 1, 140, 1, 3, 8, 1, 9), TruthValue().clone('true')).setMaxAccess("readonly")
if mibBuilder.loadTexts: pktcMtaDevCmsIpsecCtrl.setDescription(" This object specifies the MTA IPSec control flag.\nIf the object value is 'true', the MTA must use Kerberos\nKey Management and IPsec to communicate with this CMS.  If\nit is 'false', IPSec Signaling Security and Kerberos key\nmanagement are disabled for this specific CMS.")
pktcMtaDevCmsStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 140, 1, 3, 8, 1, 10), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pktcMtaDevCmsStatus.setDescription(" This object defines the row status associated with this\nparticular CMS in the CMS table (pktcMtaDevCmsTable).\n\nAn entry in this table is not qualified for activation\nuntil the object instances of all corresponding columns\nhave been initialized, either by default values or via\nexplicit SET operations.  Until all object instances in\nthis row are initialized, the status value for this realm\nmust be 'notReady(3)'.\nIn particular, two columnar objects must be SET: the\nCMS FQDN (pktcMtaDevCmsFqdn) and the Kerberos realm name\n(pktcMtaDevCmsKerbRealmName).  Once these 2 objects have\nbeen set and the row status is SET to 'active(1)', the MTA\nMUST NOT allow any modification of these 2 object values.\n\nThe value of this object has no effect on\nwhether other columnar objects in this row can be\nmodified.")
pktcMtaDevResetKrbTickets = MibScalar((1, 3, 6, 1, 2, 1, 140, 1, 3, 9), Bits().subtype(namedValues=NamedValues(("invalidateProvOnReboot", 0), ("invalidateAllCmsOnReboot", 1), )).clone(())).setMaxAccess("readwrite")
if mibBuilder.loadTexts: pktcMtaDevResetKrbTickets.setDescription(" This object defines a Kerberos Ticket Control Mask that\ninstructs the MTA to invalidate the specific Application\n\n\n\nServer Kerberos ticket(s) that are stored locally in the\nMTA NVRAM (non-volatile or persistent memory).\nIf the MTA does not store Kerberos tickets in NVRAM, it\nMUST ignore setting of this object and MUST report a BITS\nvalue of zero when the object is read.\nIf the MTA supports Kerberos tickets storage in NVRAM, the\nobject value is encoded as follows:\n- Setting the invalidateProvOnReboot bit (bit 0) to 1\n  means that the MTA MUST invalidate the Kerberos\n  Application Ticket(s) for the Provisioning Application\n  at the next MTA reboot if secure SNMP provisioning mode\n  is used.  In non-secure provisioning modes, the MTA MUST\n  return an 'inconsistentValue' in response to SNMP SET\n  operations with a bit 0 set to 1.\n- Setting the invalidateAllCmsOnReboot bit (bit 1) to 1\n  means that the MTA MUST invalidate the Kerberos\n  Application Ticket(s) for all CMSes currently assigned\n  to the MTA endpoints.\nIf a value is written into an instance of\npktcMtaDevResetKrbTickets, the agent MUST retain the\nsupplied value across an MTA re-initialization or\nreboot.")
pktcMtaDevErrors = MibIdentifier((1, 3, 6, 1, 2, 1, 140, 1, 4))
pktcMtaDevErrorsTooManyErrors = ObjectIdentity((1, 3, 6, 1, 2, 1, 140, 1, 4, 1))
if mibBuilder.loadTexts: pktcMtaDevErrorsTooManyErrors.setDescription("This object defines the OID corresponding to the error\ncondition when too many errors are encountered in the\nMTA configuration file during provisioning.")
pktcMtaConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 140, 2))
pktcMtaCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 140, 2, 1))
pktcMtaGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 140, 2, 2))

# Augmentions

# Notifications

pktcMtaDevProvisioningEnrollment = NotificationType((1, 3, 6, 1, 2, 1, 140, 0, 1)).setObjects(*(("PKTC-IETF-MTA-MIB", "pktcMtaDevTypeIdentifier"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevCorrelationId"), ("IF-MIB", "ifPhysAddress"), ("SNMPv2-MIB", "sysDescr"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevSwCurrentVers"), ) )
if mibBuilder.loadTexts: pktcMtaDevProvisioningEnrollment.setDescription(" This INFORM notification is issued by the MTA to initiate\nthe PacketCable provisioning process when the MTA SNMP\nenrollment mechanism is used.\nIt contains the system description, the current software\nversion, the MTA device type identifier, the MTA MAC\naddress (obtained in the MTA ifTable in the ifPhysAddress\nobject that corresponds to the ifIndex 1), and a\ncorrelation ID.")
pktcMtaDevProvisioningStatus = NotificationType((1, 3, 6, 1, 2, 1, 140, 0, 2)).setObjects(*(("PKTC-IETF-MTA-MIB", "pktcMtaDevProvisioningState"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevCorrelationId"), ("IF-MIB", "ifPhysAddress"), ) )
if mibBuilder.loadTexts: pktcMtaDevProvisioningStatus.setDescription(" This INFORM notification may be issued by the MTA to\nconfirm the completion of the PacketCable provisioning\nprocess, and to report its provisioning completion\nstatus.\nIt contains the MTA MAC address (obtained in the MTA\nifTable in the ifPhysAddress object that corresponds\nto the ifIndex 1), a correlation ID and the MTA\nprovisioning state as defined in\npktcMtaDevProvisioningState.")

# Groups

pktcMtaGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 140, 2, 2, 1)).setObjects(*(("PKTC-IETF-MTA-MIB", "pktcMtaDevRealmUnsolicitedKeyMaxTimeout"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevTimeServerAddressType"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevServerDns2"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevServerDns1"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevSnmpEntity"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevProvConfigEncryptAlg"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevServerDhcp2"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevServerDhcp1"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevSerialNumber"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevCmsIpsecCtrl"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevProvUnsolicitedKeyMaxRetries"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevCmsUnsolicitedKeyMaxRetries"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevErrorValue"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevRealmUnsolicitedKeyNomTimeout"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevProvConfigKey"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevRealmPkinitGracePeriod"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevSwCurrentVers"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevCmsSolicitedKeyTimeout"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevFQDN"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevCmsAvailSlot"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevCmsUnsolicitedKeyNomTimeout"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevErrorOid"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevRealmStatus"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevDhcpServerAddressType"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevProvSolicitedKeyTimeout"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevRealmUnsolicitedKeyMaxRetries"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevProvisioningTimer"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevProvisioningState"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevCertificate"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevCmsUnsolicitedKeyMaxTimeout"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevProvState"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevProvKerbRealmName"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevTypeIdentifier"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevRealmAvailSlot"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevConfigFile"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevDnsServerAddressType"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevCmsMaxClockSkew"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevCmsKerbRealmName"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevProvisioningCounter"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevEnabled"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevTelephonyRootCertificate"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevManufacturerCertificate"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevProvUnsolicitedKeyNomTimeout"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevRealmTgsGracePeriod"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevCmsFqdn"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevTimeServer"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevRealmName"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevResetKrbTickets"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevProvConfigHash"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevCmsStatus"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevCorrelationId"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevResetNow"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevProvUnsolicitedKeyMaxTimeout"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevHttpAccess"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevErrorReason"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevEndPntCount"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevRealmOrgName"), ) )
if mibBuilder.loadTexts: pktcMtaGroup.setDescription(" A collection of objects for managing PacketCable or\nIPCablecom MTA implementations.")
pktcMtaNotificationGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 140, 2, 2, 2)).setObjects(*(("PKTC-IETF-MTA-MIB", "pktcMtaDevProvisioningEnrollment"), ("PKTC-IETF-MTA-MIB", "pktcMtaDevProvisioningStatus"), ) )
if mibBuilder.loadTexts: pktcMtaNotificationGroup.setDescription(" A collection of notifications dealing with the change of\nMTA provisioning status.")

# Compliances

pktcMtaBasicCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 140, 2, 1, 1)).setObjects(*(("PKTC-IETF-MTA-MIB", "pktcMtaGroup"), ("PKTC-IETF-MTA-MIB", "pktcMtaNotificationGroup"), ) )
if mibBuilder.loadTexts: pktcMtaBasicCompliance.setDescription(" The compliance statement for MTA devices that implement\nPacketCable or IPCablecom requirements.\n\nThis compliance statement applies to MTA implementations\nthat support PacketCable 1.0 or IPCablecom requirements,\nwhich are not IPv6-capable at the time of this\n\n\n\nRFC publication.")
pktcMtaBasicSmtaCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 140, 2, 1, 2)).setObjects(*(("PKTC-IETF-MTA-MIB", "pktcMtaGroup"), ("DOCS-CABLE-DEVICE-MIB", "docsDevSoftwareGroupV2"), ("PKTC-IETF-MTA-MIB", "pktcMtaNotificationGroup"), ("DOCS-IETF-BPI2-MIB", "docsBpi2CodeDownloadGroup"), ) )
if mibBuilder.loadTexts: pktcMtaBasicSmtaCompliance.setDescription(" The compliance statement for S-MTA devices\nthat implement PacketCable or IPCablecom requirements.\n\nThis compliance statement applies to S-MTA implementations\nthat support PacketCable or IPCablecom requirements,\nwhich are not IPv6-capable at the time of this\nRFC publication.")

# Exports

# Module identity
mibBuilder.exportSymbols("PKTC-IETF-MTA-MIB", PYSNMP_MODULE_ID=pktcIetfMtaMib)

# Types
mibBuilder.exportSymbols("PKTC-IETF-MTA-MIB", PktcMtaDevProvEncryptAlg=PktcMtaDevProvEncryptAlg)

# Objects
mibBuilder.exportSymbols("PKTC-IETF-MTA-MIB", pktcIetfMtaMib=pktcIetfMtaMib, pktcMtaNotification=pktcMtaNotification, pktcMtaMibObjects=pktcMtaMibObjects, pktcMtaDevBase=pktcMtaDevBase, pktcMtaDevResetNow=pktcMtaDevResetNow, pktcMtaDevSerialNumber=pktcMtaDevSerialNumber, pktcMtaDevSwCurrentVers=pktcMtaDevSwCurrentVers, pktcMtaDevFQDN=pktcMtaDevFQDN, pktcMtaDevEndPntCount=pktcMtaDevEndPntCount, pktcMtaDevEnabled=pktcMtaDevEnabled, pktcMtaDevTypeIdentifier=pktcMtaDevTypeIdentifier, pktcMtaDevProvisioningState=pktcMtaDevProvisioningState, pktcMtaDevHttpAccess=pktcMtaDevHttpAccess, pktcMtaDevProvisioningTimer=pktcMtaDevProvisioningTimer, pktcMtaDevProvisioningCounter=pktcMtaDevProvisioningCounter, pktcMtaDevErrorOidsTable=pktcMtaDevErrorOidsTable, pktcMtaDevErrorOidsEntry=pktcMtaDevErrorOidsEntry, pktcMtaDevErrorOidIndex=pktcMtaDevErrorOidIndex, pktcMtaDevErrorOid=pktcMtaDevErrorOid, pktcMtaDevErrorValue=pktcMtaDevErrorValue, pktcMtaDevErrorReason=pktcMtaDevErrorReason, pktcMtaDevServer=pktcMtaDevServer, pktcMtaDevDhcpServerAddressType=pktcMtaDevDhcpServerAddressType, pktcMtaDevServerDhcp1=pktcMtaDevServerDhcp1, pktcMtaDevServerDhcp2=pktcMtaDevServerDhcp2, pktcMtaDevDnsServerAddressType=pktcMtaDevDnsServerAddressType, pktcMtaDevServerDns1=pktcMtaDevServerDns1, pktcMtaDevServerDns2=pktcMtaDevServerDns2, pktcMtaDevTimeServerAddressType=pktcMtaDevTimeServerAddressType, pktcMtaDevTimeServer=pktcMtaDevTimeServer, pktcMtaDevConfigFile=pktcMtaDevConfigFile, pktcMtaDevSnmpEntity=pktcMtaDevSnmpEntity, pktcMtaDevProvConfigHash=pktcMtaDevProvConfigHash, pktcMtaDevProvConfigKey=pktcMtaDevProvConfigKey, pktcMtaDevProvConfigEncryptAlg=pktcMtaDevProvConfigEncryptAlg, pktcMtaDevProvSolicitedKeyTimeout=pktcMtaDevProvSolicitedKeyTimeout, pktcMtaDevProvUnsolicitedKeyMaxTimeout=pktcMtaDevProvUnsolicitedKeyMaxTimeout, pktcMtaDevProvUnsolicitedKeyNomTimeout=pktcMtaDevProvUnsolicitedKeyNomTimeout, pktcMtaDevProvUnsolicitedKeyMaxRetries=pktcMtaDevProvUnsolicitedKeyMaxRetries, pktcMtaDevProvKerbRealmName=pktcMtaDevProvKerbRealmName, pktcMtaDevProvState=pktcMtaDevProvState, pktcMtaDevSecurity=pktcMtaDevSecurity, pktcMtaDevManufacturerCertificate=pktcMtaDevManufacturerCertificate, pktcMtaDevCertificate=pktcMtaDevCertificate, pktcMtaDevCorrelationId=pktcMtaDevCorrelationId, pktcMtaDevTelephonyRootCertificate=pktcMtaDevTelephonyRootCertificate, pktcMtaDevRealmAvailSlot=pktcMtaDevRealmAvailSlot, pktcMtaDevRealmTable=pktcMtaDevRealmTable, pktcMtaDevRealmEntry=pktcMtaDevRealmEntry, pktcMtaDevRealmIndex=pktcMtaDevRealmIndex, pktcMtaDevRealmName=pktcMtaDevRealmName, pktcMtaDevRealmPkinitGracePeriod=pktcMtaDevRealmPkinitGracePeriod, pktcMtaDevRealmTgsGracePeriod=pktcMtaDevRealmTgsGracePeriod, pktcMtaDevRealmOrgName=pktcMtaDevRealmOrgName, pktcMtaDevRealmUnsolicitedKeyMaxTimeout=pktcMtaDevRealmUnsolicitedKeyMaxTimeout, pktcMtaDevRealmUnsolicitedKeyNomTimeout=pktcMtaDevRealmUnsolicitedKeyNomTimeout, pktcMtaDevRealmUnsolicitedKeyMaxRetries=pktcMtaDevRealmUnsolicitedKeyMaxRetries, pktcMtaDevRealmStatus=pktcMtaDevRealmStatus, pktcMtaDevCmsAvailSlot=pktcMtaDevCmsAvailSlot, pktcMtaDevCmsTable=pktcMtaDevCmsTable, pktcMtaDevCmsEntry=pktcMtaDevCmsEntry, pktcMtaDevCmsIndex=pktcMtaDevCmsIndex, pktcMtaDevCmsFqdn=pktcMtaDevCmsFqdn, pktcMtaDevCmsKerbRealmName=pktcMtaDevCmsKerbRealmName, pktcMtaDevCmsMaxClockSkew=pktcMtaDevCmsMaxClockSkew, pktcMtaDevCmsSolicitedKeyTimeout=pktcMtaDevCmsSolicitedKeyTimeout, pktcMtaDevCmsUnsolicitedKeyMaxTimeout=pktcMtaDevCmsUnsolicitedKeyMaxTimeout, pktcMtaDevCmsUnsolicitedKeyNomTimeout=pktcMtaDevCmsUnsolicitedKeyNomTimeout, pktcMtaDevCmsUnsolicitedKeyMaxRetries=pktcMtaDevCmsUnsolicitedKeyMaxRetries, pktcMtaDevCmsIpsecCtrl=pktcMtaDevCmsIpsecCtrl, pktcMtaDevCmsStatus=pktcMtaDevCmsStatus, pktcMtaDevResetKrbTickets=pktcMtaDevResetKrbTickets, pktcMtaDevErrors=pktcMtaDevErrors, pktcMtaDevErrorsTooManyErrors=pktcMtaDevErrorsTooManyErrors, pktcMtaConformance=pktcMtaConformance, pktcMtaCompliances=pktcMtaCompliances, pktcMtaGroups=pktcMtaGroups)

# Notifications
mibBuilder.exportSymbols("PKTC-IETF-MTA-MIB", pktcMtaDevProvisioningEnrollment=pktcMtaDevProvisioningEnrollment, pktcMtaDevProvisioningStatus=pktcMtaDevProvisioningStatus)

# Groups
mibBuilder.exportSymbols("PKTC-IETF-MTA-MIB", pktcMtaGroup=pktcMtaGroup, pktcMtaNotificationGroup=pktcMtaNotificationGroup)

# Compliances
mibBuilder.exportSymbols("PKTC-IETF-MTA-MIB", pktcMtaBasicCompliance=pktcMtaBasicCompliance, pktcMtaBasicSmtaCompliance=pktcMtaBasicSmtaCompliance)
