#ifndef VISUAL_BOX_H
#define VISUAL_BOX_H

// Copyright (c) 2000, 2001, 2002, 2003 by David Scherer and others.
// See the file license.txt for complete license terms.
// See the file authors.txt for a complete list of contributors.

#include "prim.h"
#include "exceptions.h"

namespace visual {

class box : public Primitive
{
 private:
	double width, height;
	
 public:
	inline box() : width(1.0), height(1.0) {}
	box( const box& other) 
		: Primitive( other), width( other.width), height( other.height) 
	{}

	inline double get_width()
	{ return width; }

	inline void set_width( double w)
	{ write_lock L( mtx); width = w; }

	inline double get_height()
	{return height; }

	inline void set_height( double h)
	{ write_lock L( mtx); height = h; }

	inline double get_length()
	{ return axis.mag(); }
	
	inline void set_length( double l)
	{
		if (!axis)
			throw python::ZeroDivisionError("Degenerate primitive");
		axis = axis * (l / axis.mag());
	}

	inline vector get_size()
	{ return getScale(); }

	inline void set_size( vector v)
	{	
		axis = axis.norm() * v.x;
		write_lock L( mtx);
		height = v.y;
		width = v.z;
	}

	inline void set_size_t( boost::python::object t) { this->set_size( vector(t)); }

	virtual vector getScale();
	virtual double rayIntersect( const vector& camera, const vector& ray);
	virtual void glRender( rView& view);
};


} // !namespace visual

#endif // !VISUAL_BOX_H
