// Copyright (c) 2000, 2001, 2002, 2003 by David Scherer and others.
// See the file license.txt for complete license terms.
// See the file authors.txt for a complete list of contributors.
#include "cylmodel.h"
#include "cvisual.h"
#include <cmath>

namespace visual {

cyl_model::cyl_model( int sides)
{
	nverts = 2*sides;
	verts = new float[3*nverts];
	proj = new vertex[nverts];
	color = new float[4*nverts];

	float *v = verts;
	float da = 2*pi/(sides-1);
	float sn = 0.0, cn = 1.0, temp;
	float sinda = std::sin(da), cosda = std::cos(da);
	for(int s=0;s<sides;s++) {

		v[0] = 0.0;
		v[1] = sn;
		v[2] = cn;
		v+=3;

		v[0] = 2.0;
		v[1] = sn;
		v[2] = cn;
		v+=3;

		temp = sn*cosda+cn*sinda; // sin(a+da) = sin(a)cos(da)+cos(a)sin(da)
		cn = cn*cosda-sn*sinda;   // cos(a+da) = cos(a)cos(da)-sin(a)sin(da)
		sn = temp;
	}	
}
	
cyl_model& 
cyl_model::get(int sides) 
{
	static cyl_model* models[100];
	if (sides>=100) 
		sides=99;
	if (!models[sides])
		models[sides] = new cyl_model(sides);
	return *models[sides];
}
	
	
} // !namespace visual
