#
# $Header: /usr/local/cvsroot/pythondoc/formatters/XMLFormatter.py,v 1.2 1999/05/01 01:16:27 daniel Exp $
#
# Copyright (C) Daniel Larsson
# All Rights Reserved.
#
# See copyright notice in the file 'LICENSE.TXT', which should have accompanied
# this distribution.
#

#
# TODO:
# - Split file so there's one file per module
# - DTD
# - ...

__author__ = "Daniel Larsson, Daniel.Larsson@telia.com"

import pythondoc.version
import format_init

formatter_name = "XML"

def init(options):
    global _options
    _options = options
    # Register formatter
    format_init.add_formatter(formatter_name, XMLFormatter)


HEADER = \
'''<?xml version="1.0"?>

<!-- Generated by %s %s -->

''' % ("pythondoc.XMLFormatter", pythondoc.version.__version__)

class XMLFormatter:
    def document(self, doctree):
	modulename = doctree.attribute('id')

	dir = _options.read_value('main', 'directory')[1]
	filename = modulename+'.xml'
	if dir:
	    import os
	    filename = os.path.join(dir, filename)

	self.file = open(filename, 'w')
	self.file.write(HEADER)
	self.file.write(str(doctree))

    def index(self, doctree):
	pass

    def finish(self):
	pass

#
# $Log: XMLFormatter.py,v $
# Revision 1.2  1999/05/01 01:16:27  daniel
# Removed Windows style line endings.
#
# 
# *****************  Version 4  *****************
# User: Daniel       Date: 98-12-13   Time: 16:17
# Updated in $/Pythondoc/formatters
# New email address.
# Use 'id' instead of 'path' attribute.
# 
# *****************  Version 3  *****************
# User: Daniel       Date: 98-08-06   Time: 17:04
# Updated in $/Pythondoc/formatters
# Added header and footer.
# Corrected code.
# Now stores file in user given directory.
# 

