/*
 *  fbmenu.cc
 *
 *  Copyright (C) 1998	Jiann-Ching Liu
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "qe_config.h"
#include "filebuffer.h"
#include "colors.h"
#include "messages.h"
#include "menu.h"


menu e_menubar;
menu c_menubar;

void
filebuffer::init_menu (void)
{
  e_menubar.add_menu (N_("File"));	//  c_menubar.add_menu("F)ɮ");
  e_menubar.add_menu (N_("Edit"));	//  c_menubar.add_menu("E)s");
  e_menubar.add_menu (N_("Mark"));	//  c_menubar.add_menu("M)аO");
  e_menubar.add_menu (N_("Search"));	//  c_menubar.add_menu("S)jM");
  e_menubar.add_menu (N_("Goto"));	//  c_menubar.add_menu("G)");
//  e_menubar.add_menu(N_("Option"));  //  c_menubar.add_menu("G)ﶵ");
  e_menubar.add_menu (N_("Window"));	//  c_menubar.add_menu("W)");
  e_menubar.add_menu (N_("Help"));	//  c_menubar.add_menu("H)U");

  e_menubar.add_item (N_("File"), N_("&Dir (Load file)"),
		      &filebuffer::cmd_dir);
  e_menubar.add_item (N_("File"), N_(""), (int (filebuffer::*)(void)) NULL);
  e_menubar.add_item (N_("File"), N_("&New file"), &filebuffer::cmd_new);
  e_menubar.add_item (N_("File"), N_("&Save file"), &filebuffer::cmd_save);
  e_menubar.add_item (N_("File"), N_("&Quit file (Close file)"),
		      &filebuffer::cmd_quit);
  e_menubar.add_item (N_("File"), "", (int (filebuffer::*)(void)) NULL);
  e_menubar.add_item (N_("File"), N_("&Blankcompress:"),
		      &filebuffer::cmd_toggle_blankcompress,
		      &filebuffer::menu_blankcompress);
  e_menubar.add_item (N_("File"), N_("Dir so&rt by: "),
		      &filebuffer::cmd_toggle_dirsort,
		      &filebuffer::menu_dirsort);
  e_menubar.add_item (N_("File"), "", (int (filebuffer::*)(void)) NULL);
  e_menubar.add_item (N_("File"), N_("S&hell ..."), &filebuffer::cmd_shell);
  e_menubar.add_item (N_("File"), "", (int (filebuffer::*)(void)) NULL);
  e_menubar.add_item (N_("File"), N_("&Exit QE (save all and quit)"),
		      &filebuffer::cmd_save_all_quit);
  e_menubar.add_item (N_("File"), N_("E&xit QE (quit all without save)"),
		      &filebuffer::cmd_quit_all);

  e_menubar.add_item (N_("Edit"), N_("&Edit"), &filebuffer::cmd_cursor_data);
  e_menubar.add_item (N_("Edit"), "", (int (filebuffer::*)(void)) NULL);
  e_menubar.add_item (N_("Edit"), N_("&Insert Line"),
		      &filebuffer::cmd_insertline);
  e_menubar.add_item (N_("Edit"), N_("Delete &Line"),
		      &filebuffer::cmd_deleteline);
  e_menubar.add_item (N_("Edit"), N_(""), (int (filebuffer::*)(void)) NULL);
  e_menubar.add_item (N_("Edit"), N_("Erase &Begin Line"),
		      &filebuffer::cmd_erase_begin);
  e_menubar.add_item (N_("Edit"), N_("Erase E&nd Line"),
		      &filebuffer::cmd_erase_end);
  e_menubar.add_item (N_("Edit"), N_("Delete &Character"),
		      &filebuffer::cmd_delchar);
  e_menubar.add_item (N_("Edit"), N_("&Rubout Character"),
		      &filebuffer::cmd_rubout);
  e_menubar.add_item (N_("Edit"), N_(""), (int (filebuffer::*)(void)) NULL);
  e_menubar.add_item (N_("Edit"), N_("&Split"), &filebuffer::cmd_split);
  e_menubar.add_item (N_("Edit"), N_("&Join"), &filebuffer::cmd_join);
  e_menubar.add_item (N_("Edit"), N_("Edit qe.pr&o"), &filebuffer::cmd_pro);
  e_menubar.add_item (N_("Mark"), N_("Mark &Line"),
		      &filebuffer::cmd_markline);
  e_menubar.add_item (N_("Mark"), N_("Mark &Block"),
		      &filebuffer::cmd_markblock);
  e_menubar.add_item (N_("Mark"), N_("&Un mark"), &filebuffer::cmd_unmark);
  e_menubar.add_item (N_("Mark"), N_(""), (int (filebuffer::*)(void)) NULL);
  e_menubar.add_item (N_("Mark"), N_("&Copy Mark"),
		      &filebuffer::cmd_copymark);
  e_menubar.add_item (N_("Mark"), N_("O&verlay Block"),
		      &filebuffer::cmd_overlayblock);
  e_menubar.add_item (N_("Mark"), N_("&Move Mark"),
		      &filebuffer::cmd_movemark);
  e_menubar.add_item (N_("Mark"), N_("&Delete Mark"),
		      &filebuffer::cmd_deletemark);
  e_menubar.add_item (N_("Mark"), N_("&Push mark"),
		      &filebuffer::cmd_pushmark);
  e_menubar.add_item (N_("Mark"), N_("P&op mark"), &filebuffer::cmd_popmark);
  e_menubar.add_item (N_("Mark"), N_("Clear mar&k"),
		      &filebuffer::cmd_clear_marks);
  e_menubar.add_item (N_("Mark"), N_(""), (int (filebuffer::*)(void)) NULL);
  e_menubar.add_item (N_("Mark"), N_("&Shift Left"),
		      &filebuffer::cmd_shiftleft);
  e_menubar.add_item (N_("Mark"), N_("Shift &Right"),
		      &filebuffer::cmd_shiftright);
  e_menubar.add_item (N_("Mark"), N_("&Fill mark"),
		      &filebuffer::cmd_fillmark);
  e_menubar.add_item (N_("Mark"), N_("&Uppercase"),
		      &filebuffer::cmd_uppercase);
  e_menubar.add_item (N_("Mark"), N_("&Lowercase"),
		      &filebuffer::cmd_lowercase);
  e_menubar.add_item (N_("Search"), N_("&Find ..."), &filebuffer::cmd_search);
  e_menubar.add_item (N_("Search"), N_(""), (int (filebuffer::*)(void)) NULL);
  e_menubar.add_item (N_("Search"), N_("&Search case: "),
		      &filebuffer::cmd_toggle_searchcase,
		      &filebuffer::menu_searchcase);
  e_menubar.add_item (N_("Goto"), N_("Cursor &Command"),
		      &filebuffer::cmd_cursor_cmd);
  e_menubar.add_item (N_("Goto"), N_("Cursor &Data"),
		      &filebuffer::cmd_cursor_data);
  e_menubar.add_item (N_("Goto"), N_(""), (int (filebuffer::*)(void)) NULL);
  e_menubar.add_item (N_("Goto"), N_("&Goto ...."),
		      &filebuffer::cmd_gotoline);
  e_menubar.add_item (N_("Goto"), N_(""), (int (filebuffer::*)(void)) NULL);
  e_menubar.add_item (N_("Goto"), N_("&Begin of file"), &filebuffer::cmd_top);
  e_menubar.add_item (N_("Goto"), N_("&End of file"),
		      &filebuffer::cmd_bottom);
  e_menubar.add_item (N_("Goto"), N_(""), (int (filebuffer::*)(void)) NULL);
  e_menubar.add_item (N_("Goto"), N_("&Top of screen"),
		      &filebuffer::cmd_top_edge);
  e_menubar.add_item (N_("Goto"), N_("B&ottom of screen"),
		      &filebuffer::cmd_bottom_edge);
  e_menubar.add_item (N_("Goto"), N_(""), (int (filebuffer::*)(void)) NULL);
  e_menubar.add_item (N_("Goto"), N_("Be&gin of mark"),
		      &filebuffer::cmd_beginmark);
  e_menubar.add_item (N_("Goto"), N_("End of &mark"),
		      &filebuffer::cmd_endmark);
  e_menubar.add_item (N_("Goto"), N_(""), (int (filebuffer::*)(void)) NULL);
  e_menubar.add_item (N_("Goto"), N_("Begin of &line"),
		      &filebuffer::cmd_beginline);
  e_menubar.add_item (N_("Goto"), N_("End of li&ne"),
		      &filebuffer::cmd_endline);

  e_menubar.add_item (N_("Window"), N_("&Next file"), &filebuffer::cmd_edit);
//    e_menubar.add_item(N_("Window"), N_(""),     (int (filebuffer::*)(void)) NULL);
//  e_menubar.add_item(N_("Window"), N_("&English Mode"),  &filebuffer::cmd_lang_english);
//  e_menubar.add_item(N_("Window"), N_("&Chinese Mode"),  &filebuffer::cmd_lang_big5);
//    e_menubar.add_item(N_("Window"), N_("&Language: "),  &filebuffer::cmd_lang_big5, &filebuffer::menu_language);
//    e_menubar.add_item(N_("Window"), N_(""),     (int (filebuffer::*)(void)) NULL);
//    e_menubar.add_item(N_("Window"), N_("&Insert Mode"),  &filebuffer::cmd_insert_mode);
//  e_menubar.add_item(N_("Window"), N_("&Replace Mode"),  &filebuffer::cmd_replace_mode);
  e_menubar.add_item (N_("Window"), N_("&Input Mode: "),
		      &filebuffer::cmd_insert_toggle,
		      &filebuffer::menu_inputmode);
  e_menubar.add_item (N_("Window"), N_(""), (int (filebuffer::*)(void)) NULL);
  e_menubar.add_item (N_("Window"), N_("Command &History"),
		      &filebuffer::cmd_history);
  e_menubar.add_item (N_("Window"), N_("History &Key: "),
		      &filebuffer::cmd_toggle_historykey,
		      &filebuffer::menu_historykey);
  e_menubar.add_item (N_("Help"), N_("&About ..."), &filebuffer::cmd_about);
  e_menubar.add_item (N_("Help"), N_(""), (int (filebuffer::*)(void)) NULL);
  e_menubar.add_item (N_("Help"), N_("&Help ..."), &filebuffer::cmd_help);
//  e_menubar.add_item(N_("Help"), N_("&Edit qe.pro"),   &filebuffer::cmd_pro);
}

int
filebuffer::cmd_menu (void)
{
  int
    rtnval = 0;

  write_workbuffer (QE_IF_NECESSARY);

  do
    {
      display_messages (MSG_MENU_USAGE);

      keep_in_menu = MENU_IN_MENU;

      rtnval = e_menubar.active (win, screen_y, screen_x, this);

    }
  while (keep_in_menu == MENU_KEEP_IN_MENU);

  if (keep_in_menu == MENU_IN_MENU)
    keep_in_menu = MENU_NOT_IN_MENU;

//  display_messages();

  return rtnval;
}

static char
  mbuf[50];

char *
filebuffer::menu_inputmode (const char *str)
{
  if (input_mode == 1)
    {
      sprintf (mbuf, "%s %s", str, _("Insert"));
    }
  else
    {
      sprintf (mbuf, "%s %s", str, _("Replace"));
    }
  return mbuf;
}

char *
filebuffer::menu_blankcompress (const char *str)
{
  if (blank_compress == 1)
    {
      sprintf (mbuf, "%s %s", str, _("on"));
    }
  else
    {
      sprintf (mbuf, "%s %s", str, _("off"));
    }
  return mbuf;
}

char *
filebuffer::menu_historykey (const char *str)
{
  if (history_key == HISTORY_KEY_NONE)
    {
      sprintf (mbuf, "%s%s", str, _("NONE"));
    }
  else if (history_key == HISTORY_KEY_UP)
    {
      sprintf (mbuf, "%s%s", str, _("UP"));
    }
  else if (history_key == HISTORY_KEY_DOWN)
    {
      sprintf (mbuf, "%s%s", str, _("DOWN"));
    }
  else if (history_key == HISTORY_KEY_BOTH)
    {
      sprintf (mbuf, "%s%s", str, _("BOTH"));
    }
  return mbuf;
}

char *
filebuffer::menu_dirsort (const char *str)
{
  if (dir_sort == DIR_SORT_BY_NAME)
    {
      sprintf (mbuf, "%s%s", str, _("NAME"));
    }
  else if (dir_sort == DIR_SORT_BY_TIME)
    {
      sprintf (mbuf, "%s%s", str, _("TIME"));
    }
  else if (dir_sort == DIR_SORT_BY_SIZE)
    {
      sprintf (mbuf, "%s%s", str, _("SIZE"));
    }
  return mbuf;
}

char *
filebuffer::menu_searchcase (const char *str)
{
  if (search_case == 1)
    {
      sprintf (mbuf, "%s%s", str, _("EXACT"));
    }
  else
    {
      sprintf (mbuf, "%s%s", str, _("ANY"));
    }
  return mbuf;
}

/*
char *filebuffer::menu_language(const char *str) {
    if (big5msg_flag == 1) {
	sprintf(mbuf, "%s%s", str, _("ENGLISH"));
    } else {
	sprintf(mbuf, "%s%s", str, _("CHINESE"));
    }
    return mbuf;
}
*/
