/*
 * Decompiled with CFR 0.152.
 */
package king.tool.edmap;

import driftwood.gui.ReflectiveAction;
import driftwood.gui.TablePane;
import driftwood.isosurface.CrystalVertexSource;
import driftwood.isosurface.LowResolutionVertexSource;
import driftwood.isosurface.MarchingCubes;
import driftwood.r3.Transform;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import king.KMessage;
import king.KinCanvas;
import king.KingMain;
import king.ToolBox;
import king.core.Engine;
import king.core.KGroup;
import king.core.KList;
import king.core.KPaint;
import king.core.KPalette;
import king.core.KView;
import king.core.Kinemage;
import king.core.Transformable;
import king.tool.edmap.EDMapPlotter;

public class EDMapWindow
implements ChangeListener,
ActionListener,
Transformable {
    DecimalFormat df1 = new DecimalFormat("0.0");
    protected KingMain kMain;
    protected KinCanvas kCanvas;
    ToolBox parent;
    CrystalVertexSource map;
    MarchingCubes mc1;
    MarchingCubes mc2;
    EDMapPlotter plotter1;
    EDMapPlotter plotter2;
    String title;
    protected JDialog dialog;
    JSlider extent;
    JSlider slider1;
    JSlider slider2;
    JCheckBox label1;
    JCheckBox label2;
    JComboBox color1;
    JComboBox color2;
    JCheckBox useTriangles;
    JCheckBox useLowRes;
    JButton discard;
    JButton export;
    float ctrX;
    float ctrY;
    float ctrZ;

    public EDMapWindow(ToolBox toolBox, CrystalVertexSource crystalVertexSource, String string) {
        this.parent = toolBox;
        this.kMain = toolBox.kMain;
        this.kCanvas = toolBox.kCanvas;
        toolBox.transformables.add(this);
        this.map = crystalVertexSource;
        this.title = string;
        this.ctrZ = Float.NaN;
        this.ctrY = Float.NaN;
        this.ctrX = Float.NaN;
        Object object = MarchingCubes.MODE_TRIANGLE;
        this.plotter1 = new EDMapPlotter(false, object);
        this.plotter2 = new EDMapPlotter(false, object);
        this.buildGUI();
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.kMain.getTopWindow());
        this.dialog.setVisible(true);
    }

    void buildGUI() {
        this.dialog = new JDialog(this.kMain.getTopWindow(), this.title + " - EDMap", false);
        this.dialog.setDefaultCloseOperation(0);
        this.label1 = new JCheckBox("1.2 sigma", true);
        this.label2 = new JCheckBox("3.0 sigma", false);
        this.color1 = new JComboBox<Object>(this.kMain.getKinemage().getAllPaintMap().values().toArray());
        this.color1.setSelectedItem(KPalette.gray);
        this.color2 = new JComboBox<Object>(this.kMain.getKinemage().getAllPaintMap().values().toArray());
        this.color2.setSelectedItem(KPalette.purple);
        this.extent = new JSlider(0, 30, 10);
        this.extent.setMajorTickSpacing(10);
        this.extent.setMinorTickSpacing(2);
        this.extent.setPaintTicks(true);
        this.extent.setPaintLabels(true);
        this.slider1 = new JSlider(-80, 80, 12);
        this.slider1.setMajorTickSpacing(10);
        this.slider1.setPaintTicks(true);
        this.slider1.setPaintLabels(false);
        this.slider2 = new JSlider(-80, 80, 30);
        this.slider2.setMajorTickSpacing(10);
        this.slider2.setPaintTicks(true);
        this.slider2.setPaintLabels(false);
        this.useTriangles = new JCheckBox(new ReflectiveAction("Translucent surface", null, this, "onTriangles"));
        this.useTriangles.setToolTipText("Enables a translucent triangle-mesh surface; use with Best rendering quality.");
        this.useLowRes = new JCheckBox(new ReflectiveAction("Coarser mesh", null, this, "onCoarseMesh"));
        this.discard = new JButton(new ReflectiveAction("Discard this map", null, this, "onMapDiscard"));
        this.export = new JButton(new ReflectiveAction("Export to kinemage", null, this, "onMapExport"));
        this.label1.addActionListener(this);
        this.label2.addActionListener(this);
        this.color1.addActionListener(this);
        this.color2.addActionListener(this);
        this.extent.addChangeListener(this);
        this.slider1.addChangeListener(this);
        this.slider2.addChangeListener(this);
        TablePane tablePane = new TablePane();
        tablePane.save().hfill(true).addCell(this.extent, 2, 1).restore();
        tablePane.newRow();
        tablePane.add(TablePane.strut(0, 8));
        tablePane.newRow();
        tablePane.add(this.label1);
        tablePane.add(this.color1);
        tablePane.newRow();
        tablePane.save().hfill(true).addCell(this.slider1, 2, 1).restore();
        tablePane.newRow();
        tablePane.add(TablePane.strut(0, 4));
        tablePane.newRow();
        tablePane.add(this.label2);
        tablePane.add(this.color2);
        tablePane.newRow();
        tablePane.save().hfill(true).addCell(this.slider2, 2, 1).restore();
        tablePane.newRow();
        tablePane.add(TablePane.strut(0, 4));
        tablePane.newRow();
        tablePane.add((Component)this.useTriangles, 2, 1);
        tablePane.newRow();
        tablePane.add((Component)this.useLowRes, 2, 1);
        tablePane.newRow();
        tablePane.center().hfill(true);
        tablePane.add((Component)this.export, 2, 1);
        tablePane.newRow();
        tablePane.add((Component)this.discard, 2, 1);
        this.dialog.setContentPane(tablePane);
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Presets");
        jMenu.setMnemonic(80);
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem(new ReflectiveAction("2Fo - Fc", null, this, "on2FoFc"));
        jMenuItem.setMnemonic(50);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(50, KingMain.MENU_ACCEL_MASK));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(new ReflectiveAction("Fo - Fc", null, this, "onFoFc"));
        jMenuItem.setMnemonic(49);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(49, KingMain.MENU_ACCEL_MASK));
        jMenu.add(jMenuItem);
        this.dialog.setJMenuBar(jMenuBar);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        double d = this.calcSliderValue(this.slider1);
        this.label1.setText(this.df1.format(d) + " sigma");
        d = this.calcSliderValue(this.slider2);
        this.label2.setText(this.df1.format(d) + " sigma");
        if (!(this.extent.getValueIsAdjusting() || this.slider1.getValueIsAdjusting() || this.slider2.getValueIsAdjusting())) {
            this.updateMesh();
            this.kMain.publish(new KMessage(this.kMain.getKinemage(), 1));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.kMain.publish(new KMessage(this.kMain.getKinemage(), 1));
    }

    public void onTriangles(ActionEvent actionEvent) {
        this.updateMesh();
        this.kMain.publish(new KMessage(this.kMain.getKinemage(), 1));
    }

    public void onCoarseMesh(ActionEvent actionEvent) {
        this.updateMesh();
        this.kMain.publish(new KMessage(this.kMain.getKinemage(), 1));
    }

    double calcSliderValue(JSlider jSlider) {
        int n = jSlider.getValue();
        if (-60 <= n && n <= 60) {
            return (double)n / 10.0;
        }
        if (n > 60) {
            return 6.0 + (double)(n - 60) * 2.0;
        }
        if (n < -60) {
            return -(6.0 + (double)(-n - 60) * 2.0);
        }
        throw new Error("assertion failure");
    }

    protected boolean centerChanged() {
        KView kView = this.kMain.getView();
        if (kView == null) {
            return false;
        }
        float[] fArray = kView.getCenter();
        boolean bl = this.ctrX != fArray[0] || this.ctrY != fArray[1] || this.ctrZ != fArray[2];
        this.ctrX = fArray[0];
        this.ctrY = fArray[1];
        this.ctrZ = fArray[2];
        return bl;
    }

    protected void updateMesh() {
        if (Float.isNaN(this.ctrX) || Float.isNaN(this.ctrY) || Float.isNaN(this.ctrZ)) {
            return;
        }
        Object object = this.useTriangles.isSelected() ? MarchingCubes.MODE_TRIANGLE : MarchingCubes.MODE_MESH;
        this.plotter1 = new EDMapPlotter(false, object);
        this.plotter2 = new EDMapPlotter(false, object);
        double d = (double)this.extent.getValue() / 2.0;
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        if (this.useLowRes.isSelected()) {
            LowResolutionVertexSource lowResolutionVertexSource = new LowResolutionVertexSource(this.map, 2);
            this.mc1 = new MarchingCubes(lowResolutionVertexSource, lowResolutionVertexSource, this.plotter1, object);
            this.mc2 = new MarchingCubes(lowResolutionVertexSource, lowResolutionVertexSource, this.plotter2, object);
            lowResolutionVertexSource.findVertexForPoint((double)this.ctrX - d, (double)this.ctrY - d, (double)this.ctrZ - d, nArray);
            lowResolutionVertexSource.findVertexForPoint((double)this.ctrX + d, (double)this.ctrY + d, (double)this.ctrZ + d, nArray2);
        } else {
            this.mc1 = new MarchingCubes(this.map, this.map, this.plotter1, object);
            this.mc2 = new MarchingCubes(this.map, this.map, this.plotter2, object);
            this.map.findVertexForPoint((double)this.ctrX - d, (double)this.ctrY - d, (double)this.ctrZ - d, nArray);
            this.map.findVertexForPoint((double)this.ctrX + d, (double)this.ctrY + d, (double)this.ctrZ + d, nArray2);
        }
        double d2 = this.calcSliderValue(this.slider1);
        this.mc1.march(nArray[0], nArray[1], nArray[2], nArray2[0], nArray2[1], nArray2[2], d2 * this.map.sigma);
        d2 = this.calcSliderValue(this.slider2);
        this.mc2.march(nArray[0], nArray[1], nArray[2], nArray2[0], nArray2[1], nArray2[2], d2 * this.map.sigma);
    }

    public void doTransform(Engine engine, Transform transform) {
        KList kList;
        if (this.centerChanged()) {
            this.updateMesh();
        }
        if ((kList = this.plotter1.getList()) != null && this.label1.isSelected()) {
            kList.setColor((KPaint)this.color1.getSelectedItem());
            kList.doTransform(engine, transform);
        }
        if ((kList = this.plotter2.getList()) != null && this.label2.isSelected()) {
            kList.setColor((KPaint)this.color2.getSelectedItem());
            kList.doTransform(engine, transform);
        }
    }

    public void on2FoFc(ActionEvent actionEvent) {
        this.slider1.setValue(12);
        this.slider2.setValue(30);
        this.color1.setSelectedItem(KPalette.gray);
        this.color2.setSelectedItem(KPalette.purple);
        this.updateMesh();
        this.kMain.publish(new KMessage(this.kMain.getKinemage(), 1));
    }

    public void onFoFc(ActionEvent actionEvent) {
        this.slider1.setValue(-35);
        this.slider2.setValue(35);
        this.color1.setSelectedItem(KPalette.orange);
        this.color2.setSelectedItem(KPalette.sky);
        this.label1.setSelected(true);
        this.label2.setSelected(true);
        this.updateMesh();
        this.kMain.publish(new KMessage(this.kMain.getKinemage(), 1));
    }

    public void onMapDiscard(ActionEvent actionEvent) {
        this.dialog.dispose();
        this.parent.transformables.remove(this);
        this.kMain.publish(new KMessage(this.kMain.getKinemage(), 1));
    }

    public void onMapExport(ActionEvent actionEvent) {
        Kinemage kinemage = this.kMain.getKinemage();
        KGroup kGroup = new KGroup("ED map");
        kinemage.add(kGroup);
        kinemage.setModified(true);
        KGroup kGroup2 = new KGroup("ED map");
        kGroup2.setHasButton(false);
        kGroup.add(kGroup2);
        KList kList = this.plotter1.getList();
        this.plotter1.freeList();
        KList kList2 = this.plotter2.getList();
        this.plotter2.freeList();
        if (kList != null && this.label1.isSelected()) {
            kList.setParent(kGroup2);
            kGroup2.add(kList);
        }
        if (kList2 != null && this.label2.isSelected()) {
            kList2.setParent(kGroup2);
            kGroup2.add(kList2);
        }
        this.updateMesh();
    }
}

