/*
 * Decompiled with CFR 0.152.
 */
package molikin.kingplugin;

import driftwood.gui.ReflectiveAction;
import driftwood.gui.SuffixFileFilter;
import driftwood.moldb2.CifReader;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.PdbReader;
import driftwood.util.SoftLog;
import driftwood.util.StreamTank;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import king.FileDropHandler;
import king.Plugin;
import king.ToolBox;
import king.core.Kinemage;
import molikin.Quickin;
import molikin.logic.BallAndStickLogic;
import molikin.logic.Logic;
import molikin.logic.RibbonLogic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickinPlugin
extends Plugin {
    int kinNumber = 1;
    SuffixFileFilter pdbFilter;
    SuffixFileFilter cifFilter;
    SuffixFileFilter allFilter;
    JFileChooser openChooser;

    public QuickinPlugin(ToolBox toolBox) {
        super(toolBox);
        this.buildFilter();
        if (this.kMain.getApplet() == null) {
            this.buildFileChooser();
        }
        this.kMain.getFileDropHandler().addFileDropListener(new CoordFileOpen("Make lots kinemage", Quickin.getLotsLogic()));
        BallAndStickLogic ballAndStickLogic = Quickin.getLotsLogic();
        ballAndStickLogic.doPseudoBB = true;
        ballAndStickLogic.doBackbone = false;
        ballAndStickLogic.doSidechains = false;
        ballAndStickLogic.doHydrogens = false;
        this.kMain.getFileDropHandler().addFileDropListener(new CoordFileOpen("Make pseudo-backbone kinemage", ballAndStickLogic));
        this.kMain.getFileDropHandler().addFileDropListener(new CoordFileOpen("Make ribbons kinemage", Quickin.getRibbonLogic()));
    }

    public void buildFilter() {
        this.allFilter = new SuffixFileFilter("PDB and mmCIF files");
        this.allFilter.addSuffix(".pdb");
        this.allFilter.addSuffix(".xyz");
        this.allFilter.addSuffix(".ent");
        this.allFilter.addSuffix(".cif");
        this.allFilter.addSuffix(".mmcif");
        this.allFilter.addSuffix(".pdb.gz");
        this.allFilter.addSuffix(".xyz.gz");
        this.allFilter.addSuffix(".ent.gz");
        this.allFilter.addSuffix(".cif.gz");
        this.allFilter.addSuffix(".mmcif.gz");
        this.pdbFilter = new SuffixFileFilter("Protein Data Bank (PDB) files");
        this.pdbFilter.addSuffix(".pdb");
        this.pdbFilter.addSuffix(".xyz");
        this.pdbFilter.addSuffix(".ent");
        this.pdbFilter.addSuffix(".pdb.gz");
        this.pdbFilter.addSuffix(".xyz.gz");
        this.pdbFilter.addSuffix(".ent.gz");
        this.cifFilter = new SuffixFileFilter("mmCIF files");
        this.cifFilter.addSuffix(".cif");
        this.cifFilter.addSuffix(".mmcif");
        this.cifFilter.addSuffix(".cif.gz");
        this.cifFilter.addSuffix(".mmcif.gz");
    }

    private void buildFileChooser() {
        String string = System.getProperty("user.dir");
        this.openChooser = new JFileChooser();
        this.openChooser.addChoosableFileFilter(this.allFilter);
        this.openChooser.addChoosableFileFilter(this.pdbFilter);
        this.openChooser.addChoosableFileFilter(this.cifFilter);
        this.openChooser.setFileFilter(this.allFilter);
        if (string != null) {
            this.openChooser.setCurrentDirectory(new File(string));
        }
    }

    public void onLots(ActionEvent actionEvent) {
        CoordinateFile coordinateFile = this.onOpenFile();
        if (coordinateFile != null) {
            this.buildKinemage(null, coordinateFile, Quickin.getLotsLogic());
        }
    }

    public void onRibbons(ActionEvent actionEvent) {
        CoordinateFile coordinateFile = this.onOpenFile();
        if (coordinateFile != null) {
            RibbonLogic ribbonLogic = Quickin.getRibbonLogic();
            ribbonLogic.secondaryStructure = coordinateFile.getSecondaryStructure();
            this.buildKinemage(null, coordinateFile, ribbonLogic);
        }
    }

    public void onPseudo(ActionEvent actionEvent) {
        CoordinateFile coordinateFile = this.onOpenFile();
        if (coordinateFile != null) {
            BallAndStickLogic ballAndStickLogic = Quickin.getLotsLogic();
            ballAndStickLogic.doPseudoBB = true;
            ballAndStickLogic.doBackbone = false;
            ballAndStickLogic.doSidechains = false;
            ballAndStickLogic.doHydrogens = false;
            this.buildKinemage(null, coordinateFile, ballAndStickLogic);
        }
    }

    public void onResidue(ActionEvent actionEvent) {
        CoordinateFile coordinateFile = this.onOpenFile();
        if (coordinateFile != null) {
            BallAndStickLogic ballAndStickLogic = Quickin.getLotsLogic();
            ballAndStickLogic.doHydrogens = false;
            ballAndStickLogic.colorBy = BallAndStickLogic.COLOR_BY_RES_TYPE;
            this.buildKinemage(null, coordinateFile, ballAndStickLogic);
        }
    }

    public void onRibbonLots(ActionEvent actionEvent) {
        CoordinateFile coordinateFile = this.onOpenFile();
        if (coordinateFile != null) {
            Logic[] logicArray = new Logic[]{Quickin.getLotsLogic(), Quickin.getRibbonLogic()};
            ((RibbonLogic)logicArray[1]).secondaryStructure = coordinateFile.getSecondaryStructure();
            this.buildKinemage(null, coordinateFile, logicArray);
        }
    }

    public CoordinateFile onOpenFile() {
        if (0 == this.openChooser.showOpenDialog(this.kMain.getTopWindow())) {
            try {
                File file = this.openChooser.getSelectedFile();
                if (file != null && file.exists()) {
                    if (this.cifFilter.accept(file)) {
                        return Quickin.readCIF(file);
                    }
                    return Quickin.readPDB(file);
                }
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this.kMain.getTopWindow(), "An I/O error occurred while loading the file:\n" + iOException.getMessage(), "Sorry!", 0);
                iOException.printStackTrace(SoftLog.err);
            }
        }
        return null;
    }

    public CoordinateFile readPDB(InputStream inputStream) throws IOException {
        PdbReader pdbReader = new PdbReader();
        CoordinateFile coordinateFile = pdbReader.read(inputStream);
        return coordinateFile;
    }

    public CoordinateFile readCIF(InputStream inputStream) throws IOException {
        CifReader cifReader = new CifReader();
        CoordinateFile coordinateFile = cifReader.read(inputStream);
        return coordinateFile;
    }

    @Override
    public void loadFileFromCmdline(ArrayList<File> arrayList) {
        for (File file : arrayList) {
            try {
                CoordinateFile coordinateFile = null;
                if (this.pdbFilter.accept(file)) {
                    coordinateFile = Quickin.readPDB(file);
                } else if (this.cifFilter.accept(file)) {
                    coordinateFile = Quickin.readCIF(file);
                }
                if (coordinateFile == null) continue;
                Logic[] logicArray = new Logic[]{Quickin.getLotsLogic(), Quickin.getRibbonLogic()};
                ((RibbonLogic)logicArray[1]).secondaryStructure = coordinateFile.getSecondaryStructure();
                this.buildKinemage(null, coordinateFile, logicArray);
            }
            catch (IOException iOException) {
                iOException.printStackTrace(SoftLog.err);
            }
        }
    }

    @Override
    public void loadFromURL(URL uRL) {
        String string = null;
        try {
            string = uRL.getFile();
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setAllowUserInteraction(false);
            uRLConnection.connect();
            int n = uRLConnection.getContentLength();
            SuffixFileFilter suffixFileFilter = new SuffixFileFilter("GZipped files");
            suffixFileFilter.addSuffix(".gz");
            CoordinateFile coordinateFile = null;
            if (this.pdbFilter.accept(string)) {
                coordinateFile = this.readPDB(uRLConnection.getInputStream());
            } else if (this.cifFilter.accept(string)) {
                coordinateFile = this.readCIF(uRLConnection.getInputStream());
            }
            int n2 = 5000000;
            if (suffixFileFilter.accept(string)) {
                n2 = 1000000;
            }
            if (coordinateFile != null) {
                if (n < n2) {
                    Logic[] logicArray = new Logic[]{Quickin.getLotsLogic(), Quickin.getRibbonLogic()};
                    ((RibbonLogic)logicArray[1]).secondaryStructure = coordinateFile.getSecondaryStructure();
                    this.buildKinemage(null, coordinateFile, logicArray);
                } else {
                    JOptionPane.showMessageDialog(this.kMain.getTopWindow(), "Your input file may have been truncated for display in this applet due to limited memory.  If you see less of the structure\nthan you expect, try increasing the amount of memory available for Java applets or download the standalone version of KiNG.", "Warning", 2);
                    RibbonLogic ribbonLogic = Quickin.getRibbonLogic();
                    ribbonLogic.secondaryStructure = coordinateFile.getSecondaryStructure();
                    this.buildKinemage(null, coordinateFile, new Logic[]{ribbonLogic}, 5);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace(SoftLog.err);
            JOptionPane.showMessageDialog(this.kMain.getTopWindow(), "The file '" + string + "'\ncould not be opened due to an exception:\n" + iOException.getMessage(), "Error", 0);
        }
    }

    public void loadStream(InputStream inputStream, int n) {
    }

    void buildKinemage(Kinemage kinemage, CoordinateFile coordinateFile, Logic logic) {
        this.buildKinemage(kinemage, coordinateFile, new Logic[]{logic});
    }

    void buildKinemage(Kinemage kinemage, CoordinateFile coordinateFile, Logic[] logicArray) {
        this.buildKinemage(kinemage, coordinateFile, logicArray, coordinateFile.getModels().size());
    }

    void buildKinemage(Kinemage kinemage, CoordinateFile coordinateFile, Logic[] logicArray, int n) {
        StreamTank streamTank = new StreamTank();
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(streamTank));
        printWriter.println("@kinemage " + this.kinNumber++);
        printWriter.println("@onewidth");
        Quickin.printKinemage(printWriter, coordinateFile, logicArray, n);
        coordinateFile = null;
        printWriter.flush();
        streamTank.close();
        this.kMain.getKinIO().loadStream(streamTank.getInputStream(), streamTank.size(), kinemage);
    }

    public String toString() {
        return "To quick kin...";
    }

    @Override
    public JMenuItem getToolsMenuItem() {
        JMenu jMenu = new JMenu(this.toString());
        JMenuItem jMenuItem = new JMenuItem(new ReflectiveAction("Lots (MC-SC-H)", null, this, "onLots"));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(new ReflectiveAction("Ribbons", null, this, "onRibbons"));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(new ReflectiveAction("Pseudo-backbone", null, this, "onPseudo"));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(new ReflectiveAction("Separate res", null, this, "onResidue"));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(new ReflectiveAction("Lots+Ribbons", null, this, "onRibbonLots"));
        jMenu.add(jMenuItem);
        return jMenu;
    }

    @Override
    public URL getHelpURL() {
        return null;
    }

    @Override
    public String getHelpAnchor() {
        return null;
    }

    private class CoordFileOpen
    implements FileDropHandler.Listener {
        String menuText;
        Logic logic;

        public CoordFileOpen(String string, Logic logic) {
            this.menuText = string;
            this.logic = logic;
        }

        public String toString() {
            return this.menuText;
        }

        public boolean canHandleDroppedFile(File file) {
            return QuickinPlugin.this.pdbFilter.accept(file) || QuickinPlugin.this.cifFilter.accept(file);
        }

        public void handleDroppedFile(File file) {
            try {
                CoordinateFile coordinateFile = null;
                if (QuickinPlugin.this.pdbFilter.accept(file)) {
                    coordinateFile = Quickin.readPDB(file);
                } else if (QuickinPlugin.this.cifFilter.accept(file)) {
                    coordinateFile = Quickin.readCIF(file);
                }
                if (this.logic instanceof RibbonLogic) {
                    ((RibbonLogic)this.logic).secondaryStructure = coordinateFile.getSecondaryStructure();
                }
                QuickinPlugin.this.buildKinemage(null, coordinateFile, this.logic);
            }
            catch (IOException iOException) {
                iOException.printStackTrace(SoftLog.err);
            }
        }
    }
}

