/***************************************************************************
 *   Copyright (C) 2006-2008 by Tomasz Moń                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; under version 2 of the License.         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/

#ifndef QTSCROB_H
#define QTSCROB_H

#include <QtGui>
#include <QApplication>
#include <QMainWindow>
#include <QMessageBox>
#include <QByteArray>
#include <QtDebug>
#include <QSettings>
#include <QDateTimeEdit>
#include <QLabel>
#include "libscrobble.h"
#include "threadscrobble.h"

#define MHOD_TITLE 1
#define MHOD_ALBUM 3
#define MHOD_ARTIST 4

struct configuration {
	QString username, password, lastDirectory, proxy_host, proxy_pass, proxy_user;
	int utc_offset, proxy_port, timeout, connect_timeout;
	bool checkAutoOpen, checkDelPlayList, tz_override, proxy_winauth;
};

class Settings;
class About;
class Help;
class Progress;
class Console;
class QApplication;
class QTableWidget;
class QTableWidgetItem;
class QMenu;
class QAction;
class QWidget;
class QStringList;
class QSettings;
class QTranslator;
class QLabel;
class QDateTimeEdit;

class QTScrob : public QMainWindow {
		Q_OBJECT
	protected:

	private:
		Settings *winSettings;
		About *winAbout;
		Help *winHelp;
		Progress *winProgress;
		Console *winConsole;
		QAction *actOpen;
		QAction *actOpeniTunes;
		QAction *actExit;
		QAction *actHelp;
		QAction *actAbout;
		QAction *actAboutQt;
		QAction *actSettings;
		QAction *actConsole;
		QWidget *centralWidget;
		QTableWidget *logTable;
		QPushButton *btnOpen;
		QPushButton *btnOpeniTunes;
		QPushButton *btnDelete;
		QPushButton *btnSubmit;
		QMenuBar *menuBar;
		QMenu *menuHelp;
		QMenu *menuGlobal;
		QStatusBar *statusbar;
		QLabel *lblStatus;
		QDateTimeEdit *DTedit;
		QPushButton *btnRecalcDT;
#ifdef HAVE_MTP
		QAction *actOpenMTP;
		QPushButton *btnOpenMTP;
#endif

		QStringList tableLabels;
		int	items;
		bool	lastDateChecked;
		bool	timeless;
		QDateTime baseDT;
		QDateTime lastDate;

		void setupWidgets();
		void connectSlots();
		void set_open_buttons();

		//Play Counts
		quint32 entrylen, playcount, dateplayed, bookmark;
		qint32 songs;
		bool passchanged;

	public slots:
		void readSettings();
		void saveSettings();
		void setupWindow();
		void readWindow();
		void saveWindow();
		void passEdited(const QString&);
		void help();
		void about();
		void aboutQt();
		void open();
		void parse(QString);
		void openiTunesDB();
		void parseiTunesDB(QString);
		void console();
#ifdef HAVE_MTP
		void openMTP();
		void parseMTP();
#endif
		void deleteRow();
		void changeRow(int, int);
		void scrobble();
		void settings();
		void recalcDT();
		void updatebaseDT(QDateTime);
		void loadtable();
		void scrobbled();

	public:
		ThreadScrobble *scrob;
		configuration conf;
		QFile file;

		/**
		 * Default Constructor
		 */
		QTScrob(QWidget *parent = 0);

		/**
		 * Default Destructor
		 */
		~QTScrob();
		void resizeEvent(QResizeEvent *);
};

#endif
