echo
echo "*** wcs2.sh ***"

echo "Starting DS9..."
if [ `xpaaccess ds9` = no ]; then
    ds9 &

    i=1
    while [ "$i" -le 30 ]
	do
	sleep 2
	if [ `xpaaccess ds9` = yes ]; then
	    break
	fi

	i=`expr $i + 1`
    done
fi

testit () {
    echo "Testing $1"
    xpaset -p ds9 fits $1
    xpaset -p ds9 wcs sky fk5
    xpaset -p ds9 align yes
    read
    xpaset -p ds9 wcs sky galactic
    read
    xpaset -p ds9 frame clear
}

# load default image
xpaset -p ds9 grid yes
xpaset -p ds9 wcs skyformat deg

echo "AST"
testit wcs2/ast.fits

echo "STScI DSS"
testit wcs2/wcen.fits.gz

echo "Old SCAMP"
testit wcs2/ngc6819.fits

echo "TAN+ PV"
testit wcs2/paucam_0_0_t7_0_science.fits

echo "TAN PV2_1=0 PV2_2=0"
testit wcs2/a68.fits

echo "ZPN+ PV"
testit wcs2/UKIDDS_K_3219_606_17_67_3.fits

echo "TNX"
testit wcs2/30s_01.fits

echo "ZPX"
testit wcs2/E5.3090.fits

echo "TAN-SIP"
testit wcs2/sst.fits
testit wcs2/mos8.fits

echo "SAO Plate"
testit wcs2/ac.fits
testit wcs2/crts_short.fits

#echo "TAB"
#testit wcs2/sparse.fits

echo "WCSDEP"
testit wcs2/ngc6819.fits

echo "HPX"
testit wcs2/wmap.fits

echo "GLON-ZEA"
testit wcs2/South_galactic.fits

echo "RA-CAR"
testit wcs2/CAR_model.fits
testit wcs2/car_01.fits

echo "GLON-CAR"
testit wcs2/GLM_00350+0115_mosaic_I4_cutout_14706.fits

echo "IRAF"
testit wcs2/obj011.fits

xpaset -p ds9 quit


