from __future__ import print_function
from _mock import _Mock




compilers = _Mock()

platform = 'linux2'

class FCompiler(_Mock):
  pass
  EXECUTABLE = 'executable'
  SHARED_LIBRARY = 'shared_library'
  SHARED_OBJECT = 'shared_object'
  compile_switch = '-c'
  exe_extension = ''
  library_switch = '-o '
  module_include_switch = '-I'
  obj_extension = '.o'
  object_switch = '-o '
  shared_lib_extension = '.so'
  shared_lib_format = '%s%s'
  static_lib_extension = '.a'
  static_lib_format = 'lib%s%s'

class PGroupFCompiler(_Mock):
  pass
  EXECUTABLE = 'executable'
  SHARED_LIBRARY = 'shared_library'
  SHARED_OBJECT = 'shared_object'
  compile_switch = '-c'
  compiler_type = 'pg'
  description = 'Portland Group Fortran Compiler'
  exe_extension = ''
  library_switch = '-o '
  module_dir_switch = '-module '
  module_include_switch = '-I'
  obj_extension = '.o'
  object_switch = '-o '
  shared_lib_extension = '.so'
  shared_lib_format = '%s%s'
  static_lib_extension = '.a'
  static_lib_format = 'lib%s%s'
  version_pattern = '\\s*pg(f77|f90|hpf|fortran) (?P<version>[\\d.-]+).*'

