// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2008 - INRIA - Simon LIPP <simon.lipp@scilab.org>
// Copyright (C) 2010 - DIGITEO - Pierre MARECHAL
//
// This file must be used under the terms of the CeCILL.
// This source file is licensed as described in the file COPYING, which
// you should have received as part of this distribution. The terms
// are also available at
// http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt

// Generate a loader file for the help

function tbx_build_help_loader(moduletitle,path)

    rhs = argn(2);

    // Number of input arguments

    if and(rhs<> [1 2]) then
        error(msprintf(gettext("%s: Wrong number of input arguments: %d to %d expected.\n"),"tbx_build_help_loader",1,2));
    end

    // Input argument N°1
    // → toolbox_title

    if type(moduletitle) <> 10 then
        error(msprintf(gettext("%s: Wrong type for input argument #%d: A string expected.\n"),"tbx_build_help_loader",1));
    end

    if size(moduletitle,"*") <> 1 then
        error(msprintf(gettext("%s: Wrong size for input argument #%d: A string expected.\n"),"tbx_build_help_loader",1));
    end

    // Input argument N°2
    // → path

    if rhs<2 then
        path = pwd();

    else
        if type(path) <> 10 then
            error(msprintf(gettext("%s: Wrong type for input argument #%d: A string expected.\n"),"tbx_build_help_loader",1));
        end

        if size(path,"*") <> 1 then
            error(msprintf(gettext("%s: Wrong size for input argument #%d: A string expected.\n"),"tbx_build_help_loader",1));
        end

        if ~isdir(path) then
            error(msprintf(gettext("%s: The directory ''%s'' doesn''t exist or is not read accessible.\n"),"tbx_build_help_loader",path));
        end
    end

    // build the loader file

    loadertxt = [
      "// This file is released under the 3-clause BSD license. See COPYING-BSD.",
      "// Generated by tbx_build_help_loader: Please, do not edit this file",
      "",
      "add_help_chapter("""+toolbox_title+""",get_absolute_file_path(""addchapter.sce""),%F);",
      "clear add_help_chapter;"];

    loaderfile = pathconvert(path+"/addchapter.sce",%F);

    if ~mputl(loadertxt,loaderfile) then
        error(msprintf(gettext("%s: The file %s cannot been created, please check if you have write access on this file.\n"),"tbx_build_help_loader",loaderfile));
    end

endfunction
