/*
 * Copyright (C) 2014-2016 Olzhas Rakhimov
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/// @file parameter.cc
/// Implementation of expression parameters.

#include "parameter.h"

#include "error.h"

namespace scram {
namespace mef {

Parameter::Parameter(std::string name, std::string base_path,
                     RoleSpecifier role)
    : Expression({}),
      Element(std::move(name)),
      Role(role, std::move(base_path)),
      Id(*this, *this),
      unit_(kUnitless),
      unused_(true),
      expression_(nullptr) {}

void Parameter::expression(const ExpressionPtr& expression) {
  if (expression_)
    throw LogicError("Parameter expression is already set.");
  expression_ = expression.get();
  Expression::AddArg(expression);
}

}  // namespace mef
}  // namespace scram
