#!/usr/bin/env cwl-runner

# This CWL file was automatically generated using CTDConverter.
# Visit https://github.com/WorkflowConversion/CTDConverter for more information.

baseCommand: casbar
class: CommandLineTool
cwlVersion: v1.0
doc: "SNP and methylation level calling in mapped bisulfite read data.\n\n\n\nFor\
  \ more information, visit http://www.seqan.de"
inputs:
- doc: Filename for output output file
  id: param_output_filename
  inputBinding:
    prefix: -output
  label: Filename for output output file
  type: string
- doc: Filename for bed output file
  id: param_bed_filename
  inputBinding:
    prefix: -bed
  label: Filename for bed output file
  type: string
- default: 'false'
  doc: Keep non-unique reads.
  id: param_multi
  inputBinding:
    prefix: -multi
  label: Keep non-unique reads.
  type:
  - 'null'
  - string
- default: '0'
  doc: Maximal number of matches allowed to pile up at the same genome position.
  id: param_max-pile
  inputBinding:
    prefix: -max-pile
  label: Maximal number of matches allowed to pile up at the same genome position.
  type:
  - 'null'
  - int
- default: 'false'
  doc: Do pile up correction on merged lanes.
  id: param_merged-max-pile
  inputBinding:
    prefix: -merged-max-pile
  label: Do pile up correction on merged lanes.
  type:
  - 'null'
  - string
- default: '6'
  doc: Minimal required number of reads covering a candidate position.
  id: param_min-coverage
  inputBinding:
    prefix: -min-coverage
  label: Minimal required number of reads covering a candidate position.
  type:
  - 'null'
  - int
- default: '0'
  doc: Exclude read positions within eb base pairs of read borders for SNP calling.
  id: param_exclude-border
  inputBinding:
    prefix: -exclude-border
  label: Exclude read positions within eb base pairs of read borders for SNP calling.
  type:
  - 'null'
  - int
- default: 'false'
  doc: Keep suboptimal reads.
  id: param_suboptimal
  inputBinding:
    prefix: -suboptimal
  label: Keep suboptimal reads.
  type:
  - 'null'
  - string
- default: '100000'
  doc: Genomic window size for parsing reads (concerns memory consumption, choose
    smaller windows for higher coverage).
  id: param_parse-window-size
  inputBinding:
    prefix: -parse-window-size
  label: Genomic window size for parsing reads (concerns memory consumption, choose
    smaller windows for higher coverage).
  type:
  - 'null'
  - int
- doc: Genomic intervals to analyze. E.g. 21:1000-2000.
  id: param_intervals
  inputBinding:
    prefix: -intervals
  label: Genomic intervals to analyze. E.g. 21:1000-2000.
  type:
  - 'null'
  - string
- default: '0.998'
  doc: Bisulfite conversion rate.
  id: param_bs-conv-rate
  inputBinding:
    prefix: -bs-conv-rate
  label: Bisulfite conversion rate.
  type:
  - 'null'
  - double
- default: '3'
  doc: Minimal number of deviating bases for calling.
  id: param_min-mutations
  inputBinding:
    prefix: -min-mutations
  label: Minimal number of deviating bases for calling.
  type:
  - 'null'
  - int
- default: '10.0'
  doc: Minimal average quality for calling.
  id: param_min-quality
  inputBinding:
    prefix: -min-quality
  label: Minimal average quality for calling.
  type:
  - 'null'
  - double
- default: '1'
  doc: Minimum base call quality for a match to be considered.
  id: param_min-map-quality
  inputBinding:
    prefix: -min-map-quality
  label: Minimum base call quality for a match to be considered.
  type:
  - 'null'
  - int
- default: '0.005'
  doc: Heterozygous SNP probability to compute genotype prior probabilities.
  id: param_prob-hetero-snp
  inputBinding:
    prefix: -prob-hetero-snp
  label: Heterozygous SNP probability to compute genotype prior probabilities.
  type:
  - 'null'
  - double
- default: '0.0005'
  doc: Homozygous SNP probability to compute genotype prior probabilities.
  id: param_prob-homo-snp
  inputBinding:
    prefix: -prob-homo-snp
  label: Homozygous SNP probability to compute genotype prior probabilities.
  type:
  - 'null'
  - double
- default: '9.0'
  doc: Minimum score to call.
  id: param_min-score
  inputBinding:
    prefix: -min-score
  label: Minimum score to call.
  type:
  - 'null'
  - double
- default: '0.7'
  doc: Minimum genotype probability to call.
  id: param_min-prob
  inputBinding:
    prefix: -min-prob
  label: Minimum genotype probability to call.
  type:
  - 'null'
  - double
- default: 'false'
  doc: Use empirical error frequencies of Illumina sequencing data to compute likelihoods
    in bayesian model (corresponding to Dohm et al. 2008).
  id: param_ns-errors-calling
  inputBinding:
    prefix: -ns-errors-calling
  label: Use empirical error frequencies of Illumina sequencing data to compute likelihoods
    in bayesian model (corresponding to Dohm et al. 2008).
  type:
  - 'null'
  - string
- default: 'false'
  doc: Enable verbose output.
  id: param_verbose
  inputBinding:
    prefix: -verbose
  label: Enable verbose output.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Enable very verbose output.
  id: param_very-verbose
  inputBinding:
    prefix: -very-verbose
  label: Enable very verbose output.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Set verbosity to a minimum.
  id: param_quiet
  inputBinding:
    prefix: -quiet
  label: Set verbosity to a minimum.
  type:
  - 'null'
  - string
- doc: A reference genome file.
  id: param_argument-0
  inputBinding:
    prefix: -argument-0
  label: A reference genome file.
  type: File
- doc: SAM input file containing four-letter read alignments (must be sorted by coordinates).
  id: param_argument-1
  inputBinding:
    prefix: -argument-1
  label: SAM input file containing four-letter read alignments (must be sorted by
    coordinates).
  type: File
label: SNP and methylation level calling
outputs:
- doc: Output file for SNPs.
  id: param_output
  label: Output file for SNPs.
  outputBinding:
    glob: $(inputs.param_output_filename)
  type: File
- doc: Bed output file for methylation level calls.
  id: param_bed
  label: Bed output file for methylation level calls.
  outputBinding:
    glob: $(inputs.param_bed_filename)
  type: File
