#ifndef DRAGDROPATOMSDLG_H
#define DRAGDROPATOMSDLG_H

#include <QtGui>
#include "molecule.h"

class DragAtom  : public QLabel {
public:
        DragAtom(const int index,const QString &text, QColor c=Qt::lightGray, QWidget *parent=0);
        QString labelText() const;
        int index() const;
        QColor color() const;

private:
        QString m_labelText;
        int m_index;
        QColor m_c;
};

class DragDropAtomsDialog : public QDialog {
Q_OBJECT
public:
    DragDropAtomsDialog(Molecule &mole, const QList<int> &reference, QList<int> *target, QWidget *parent = 0, Qt::WindowFlags f = 0);
    QLineEdit *resiResiClass;
    QSpinBox *resiNrSpin;
    QComboBox *resiFinder;
    QPushButton * ok;
signals:
         void pairs(const QString &);
public slots:
         void grossRC(const QString &text);
         void renameRNchanged(int ii);
};

class DragDropAtoms : public QWidget {
Q_OBJECT
public:
         DragDropAtoms(Molecule &mole, const QList<int> &reference, QList<int> *target, QWidget *parent = 0);

signals:
         void pairs(const QString &);
protected:
	 void dragEnterEvent(QDragEnterEvent *event);
	 void dragMoveEvent(QDragMoveEvent *event);
	 void dropEvent(QDropEvent *event);
	 void mousePressEvent(QMouseEvent *event);
        // void mouseMoveEvent(QMouseEvent *event);
 private:
         int itemheight,current;
         QStringList dadas;
	 Molecule m_mole;
         QList<int> *m_target;
         QList<int> m_reference;
         QList<DragAtom *> dragAtoms;
 };
#endif
