/* book.c generated by valac 0.34.2, the Vala compiler
 * generated from book.vala, do not modify */

/*
 * Copyright (C) 2009-2015 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <cairo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <cairo-ps.h>
#include <zlib.h>
#include <gobject/gvaluecollector.h>


#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;
typedef struct _BookPrivate BookPrivate;

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))
#define __g_list_free__page_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__page_unref0_ (var), NULL)))
#define _g_byte_array_unref0(var) ((var == NULL) ? NULL : (var = (g_byte_array_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

#define TYPE_PS_WRITER (ps_writer_get_type ())
#define PS_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PS_WRITER, PsWriter))
#define PS_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PS_WRITER, PsWriterClass))
#define IS_PS_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PS_WRITER))
#define IS_PS_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PS_WRITER))
#define PS_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PS_WRITER, PsWriterClass))

typedef struct _PsWriter PsWriter;
typedef struct _PsWriterClass PsWriterClass;
typedef struct _PsWriterPrivate PsWriterPrivate;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _ps_writer_unref0(var) ((var == NULL) ? NULL : (var = (ps_writer_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_PDF_WRITER (pdf_writer_get_type ())
#define PDF_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PDF_WRITER, PDFWriter))
#define PDF_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PDF_WRITER, PDFWriterClass))
#define IS_PDF_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PDF_WRITER))
#define IS_PDF_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PDF_WRITER))
#define PDF_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PDF_WRITER, PDFWriterClass))

typedef struct _PDFWriter PDFWriter;
typedef struct _PDFWriterClass PDFWriterClass;
typedef struct _PDFWriterPrivate PDFWriterPrivate;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _pdf_writer_unref0(var) ((var == NULL) ? NULL : (var = (pdf_writer_unref (var), NULL)))
typedef struct _ParamSpecBook ParamSpecBook;
typedef struct _ParamSpecPDFWriter ParamSpecPDFWriter;
typedef struct _ParamSpecPsWriter ParamSpecPsWriter;

struct _Book {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BookPrivate * priv;
};

struct _BookClass {
	GTypeClass parent_class;
	void (*finalize) (Book *self);
};

struct _BookPrivate {
	GList* pages;
	gboolean needs_saving_;
	GByteArray* jpeg_data;
};

struct _PsWriter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PsWriterPrivate * priv;
	cairo_surface_t* surface;
	GFileOutputStream* stream;
};

struct _PsWriterClass {
	GTypeClass parent_class;
	void (*finalize) (PsWriter *self);
};

struct _PDFWriter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PDFWriterPrivate * priv;
	gsize offset;
	guint* object_offsets;
	gint object_offsets_length1;
	gint _object_offsets_size_;
};

struct _PDFWriterClass {
	GTypeClass parent_class;
	void (*finalize) (PDFWriter *self);
};

struct _ParamSpecBook {
	GParamSpec parent_instance;
};

struct _PDFWriterPrivate {
	GFileOutputStream* stream;
};

struct _ParamSpecPDFWriter {
	GParamSpec parent_instance;
};

struct _ParamSpecPsWriter {
	GParamSpec parent_instance;
};


static gpointer book_parent_class = NULL;
static gpointer pdf_writer_parent_class = NULL;
static gpointer ps_writer_parent_class = NULL;

gpointer book_ref (gpointer instance);
void book_unref (gpointer instance);
GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_book (GValue* value, gpointer v_object);
void value_take_book (GValue* value, gpointer v_object);
gpointer value_get_book (const GValue* value);
GType book_get_type (void) G_GNUC_CONST;
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
#define BOOK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BOOK, BookPrivate))
enum  {
	BOOK_DUMMY_PROPERTY
};
static void book_page_changed_cb (Book* self, Page* page);
static void _book_page_changed_cb_page_pixels_changed (Page* _sender, gpointer self);
static void _book_page_changed_cb_page_crop_changed (Page* _sender, gpointer self);
static void _page_unref0_ (gpointer var);
static void _g_list_free__page_unref0_ (GList* self);
Book* book_new (void);
Book* book_construct (GType object_type);
void book_clear (Book* self);
void book_set_needs_saving (Book* self, gboolean value);
void book_append_page (Book* self, Page* page);
void book_move_page (Book* self, Page* page, guint location);
void book_reverse (Book* self);
void book_combine_sides (Book* self);
guint book_get_n_pages (Book* self);
void book_combine_sides_reverse (Book* self);
void book_delete_page (Book* self, Page* page);
Page* book_get_page (Book* self, gint page_number);
guint book_get_page_index (Book* self, Page* page);
static GFile* book_make_indexed_file (Book* self, const gchar* uri, gint i);
static void book_save_multi_file (Book* self, const gchar* type, gint quality, GFile* file, GError** error);
void page_save (Page* self, const gchar* type, gint quality, GFile* file, GError** error);
static void book_save_ps_pdf_surface (Book* self, cairo_surface_t* surface, GdkPixbuf* image, gdouble dpi);
static void book_save_ps (Book* self, GFile* file, GError** error);
gpointer ps_writer_ref (gpointer instance);
void ps_writer_unref (gpointer instance);
GParamSpec* param_spec_ps_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_ps_writer (GValue* value, gpointer v_object);
void value_take_ps_writer (GValue* value, gpointer v_object);
gpointer value_get_ps_writer (const GValue* value);
GType ps_writer_get_type (void) G_GNUC_CONST;
PsWriter* ps_writer_new (GFileOutputStream* stream);
PsWriter* ps_writer_construct (GType object_type, GFileOutputStream* stream);
GdkPixbuf* page_get_image (Page* self, gboolean apply_crop);
gint page_get_dpi (Page* self);
static guint8* book_compress_zlib (Book* self, guint8* data, int data_length1, int* result_length1);
static guint8* book_compress_jpeg (Book* self, GdkPixbuf* image, gint quality, gint dpi, int* result_length1);
static gboolean book_write_pixbuf_data (Book* self, guint8* buf, int buf_length1, GError** error);
static gboolean _book_write_pixbuf_data_gdk_pixbuf_save_func (guint8* buf, gsize buf_length1, GError** error, gpointer self);
static void book_save_pdf (Book* self, GFile* file, gint quality, GError** error);
gpointer pdf_writer_ref (gpointer instance);
void pdf_writer_unref (gpointer instance);
GParamSpec* param_spec_pdf_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pdf_writer (GValue* value, gpointer v_object);
void value_take_pdf_writer (GValue* value, gpointer v_object);
gpointer value_get_pdf_writer (const GValue* value);
GType pdf_writer_get_type (void) G_GNUC_CONST;
PDFWriter* pdf_writer_new (GFileOutputStream* stream);
PDFWriter* pdf_writer_construct (GType object_type, GFileOutputStream* stream);
guint pdf_writer_add_object (PDFWriter* self);
void pdf_writer_write_string (PDFWriter* self, const gchar* text);
void pdf_writer_start_object (PDFWriter* self, guint index);
gboolean page_get_is_color (Page* self);
gint page_get_depth (Page* self);
static guint8* _vala_array_dup1 (guint8* self, int length);
static guint8* _vala_array_dup2 (guint8* self, int length);
void pdf_writer_write (PDFWriter* self, guint8* data, int data_length1);
static gint book_next_empty_object (PDFWriter* writer, gint start);
void book_save (Book* self, const gchar* type, gint quality, GFile* file, GError** error);
gboolean book_get_needs_saving (Book* self);
static void g_cclosure_user_marshal_VOID__PAGE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void book_finalize (Book* obj);
#define PDF_WRITER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PDF_WRITER, PDFWriterPrivate))
enum  {
	PDF_WRITER_DUMMY_PROPERTY
};
static void pdf_writer_finalize (PDFWriter* obj);
enum  {
	PS_WRITER_DUMMY_PROPERTY
};
static cairo_status_t ps_writer_write_cairo_data (PsWriter* self, guint8* data, int data_length1);
static cairo_status_t _ps_writer_write_cairo_data_cairo_write_func_t (gpointer self, guchar* data, int data_length1);
static void ps_writer_finalize (PsWriter* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _page_ref0 (gpointer self) {
#line 45 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return self ? page_ref (self) : NULL;
#line 251 "book.c"
}


static void _book_page_changed_cb_page_pixels_changed (Page* _sender, gpointer self) {
#line 47 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	book_page_changed_cb ((Book*) self, _sender);
#line 258 "book.c"
}


static void _book_page_changed_cb_page_crop_changed (Page* _sender, gpointer self) {
#line 48 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	book_page_changed_cb ((Book*) self, _sender);
#line 265 "book.c"
}


static void _page_unref0_ (gpointer var) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	(var == NULL) ? NULL : (var = (page_unref (var), NULL));
#line 272 "book.c"
}


static void _g_list_free__page_unref0_ (GList* self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_list_foreach (self, (GFunc) _page_unref0_, NULL);
#line 14 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_list_free (self);
#line 281 "book.c"
}


Book* book_construct (GType object_type) {
	Book* self = NULL;
#line 38 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self = (Book*) g_type_create_instance (object_type);
#line 40 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	__g_list_free__page_unref0_0 (self->priv->pages);
#line 40 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv->pages = NULL;
#line 38 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return self;
#line 295 "book.c"
}


Book* book_new (void) {
#line 38 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return book_construct (TYPE_BOOK);
#line 302 "book.c"
}


void book_clear (Book* self) {
	GList* _tmp0_ = NULL;
#line 52 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 54 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = self->priv->pages;
#line 312 "book.c"
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
#line 54 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		page_collection = _tmp0_;
#line 54 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
#line 320 "book.c"
			Page* _tmp1_ = NULL;
			Page* page = NULL;
#line 54 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			_tmp1_ = _page_ref0 ((Page*) page_it->data);
#line 54 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			page = _tmp1_;
#line 327 "book.c"
			{
				Page* _tmp2_ = NULL;
				guint _tmp3_ = 0U;
				Page* _tmp4_ = NULL;
				guint _tmp5_ = 0U;
#line 56 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp2_ = page;
#line 56 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
#line 56 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _book_page_changed_cb_page_pixels_changed, self);
#line 57 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp4_ = page;
#line 57 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp5_, NULL, FALSE);
#line 57 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _book_page_changed_cb_page_crop_changed, self);
#line 54 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_page_unref0 (page);
#line 347 "book.c"
			}
		}
	}
#line 59 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	__g_list_free__page_unref0_0 (self->priv->pages);
#line 59 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv->pages = NULL;
#line 60 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_emit_by_name (self, "cleared");
#line 357 "book.c"
}


static void book_page_changed_cb (Book* self, Page* page) {
#line 63 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 63 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (page != NULL);
#line 65 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 368 "book.c"
}


void book_append_page (Book* self, Page* page) {
	Page* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	Page* _tmp3_ = NULL;
	Page* _tmp4_ = NULL;
#line 68 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 68 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (page != NULL);
#line 70 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = page;
#line 70 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_connect (_tmp0_, "pixels-changed", (GCallback) _book_page_changed_cb_page_pixels_changed, self);
#line 71 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = page;
#line 71 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_connect (_tmp1_, "crop-changed", (GCallback) _book_page_changed_cb_page_crop_changed, self);
#line 73 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = page;
#line 73 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3_ = _page_ref0 (_tmp2_);
#line 73 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv->pages = g_list_append (self->priv->pages, _tmp3_);
#line 74 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp4_ = page;
#line 74 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_emit_by_name (self, "page-added", _tmp4_);
#line 75 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 402 "book.c"
}


void book_move_page (Book* self, Page* page, guint location) {
	Page* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
#line 78 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 78 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (page != NULL);
#line 80 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = page;
#line 80 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv->pages = g_list_remove (self->priv->pages, _tmp0_);
#line 81 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = page;
#line 81 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = _page_ref0 (_tmp1_);
#line 81 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3_ = location;
#line 81 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv->pages = g_list_insert (self->priv->pages, _tmp2_, (gint) _tmp3_);
#line 82 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_emit_by_name (self, "reordered");
#line 83 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 431 "book.c"
}


void book_reverse (Book* self) {
	GList* new_pages = NULL;
	GList* _tmp0_ = NULL;
	GList* _tmp4_ = NULL;
#line 86 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 88 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	new_pages = NULL;
#line 89 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = self->priv->pages;
#line 445 "book.c"
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
#line 89 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		page_collection = _tmp0_;
#line 89 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
#line 453 "book.c"
			Page* _tmp1_ = NULL;
			Page* page = NULL;
#line 89 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			_tmp1_ = _page_ref0 ((Page*) page_it->data);
#line 89 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			page = _tmp1_;
#line 460 "book.c"
			{
				Page* _tmp2_ = NULL;
				Page* _tmp3_ = NULL;
#line 90 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp2_ = page;
#line 90 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp3_ = _page_ref0 (_tmp2_);
#line 90 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				new_pages = g_list_prepend (new_pages, _tmp3_);
#line 89 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_page_unref0 (page);
#line 472 "book.c"
			}
		}
	}
#line 91 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp4_ = new_pages;
#line 91 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	new_pages = NULL;
#line 91 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	__g_list_free__page_unref0_0 (self->priv->pages);
#line 91 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv->pages = _tmp4_;
#line 93 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_emit_by_name (self, "reordered");
#line 94 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 86 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	__g_list_free__page_unref0_0 (new_pages);
#line 490 "book.c"
}


void book_combine_sides (Book* self) {
	guint n_front = 0U;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	GList* new_pages = NULL;
	GList* _tmp19_ = NULL;
#line 97 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 99 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = book_get_n_pages (self);
#line 99 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = _tmp0_;
#line 99 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = book_get_n_pages (self);
#line 99 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3_ = _tmp2_;
#line 99 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	n_front = _tmp1_ - (_tmp3_ / 2);
#line 100 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	new_pages = NULL;
#line 516 "book.c"
	{
		gint i = 0;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		i = 0;
#line 521 "book.c"
		{
			gboolean _tmp4_ = FALSE;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			_tmp4_ = TRUE;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			while (TRUE) {
#line 528 "book.c"
				gint _tmp6_ = 0;
				guint _tmp7_ = 0U;
				guint _tmp8_ = 0U;
				gint _tmp9_ = 0;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!_tmp4_) {
#line 535 "book.c"
					gint _tmp5_ = 0;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp5_ = i;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					i = _tmp5_ + 1;
#line 541 "book.c"
				}
#line 101 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp4_ = FALSE;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp6_ = i;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp7_ = book_get_n_pages (self);
#line 101 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp8_ = _tmp7_;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!(((guint) _tmp6_) < _tmp8_)) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					break;
#line 555 "book.c"
				}
#line 103 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp9_ = i;
#line 103 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if ((_tmp9_ % 2) == 0) {
#line 561 "book.c"
					GList* _tmp10_ = NULL;
					gint _tmp11_ = 0;
					gconstpointer _tmp12_ = NULL;
					Page* _tmp13_ = NULL;
#line 104 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp10_ = self->priv->pages;
#line 104 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp11_ = i;
#line 104 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp12_ = g_list_nth_data (_tmp10_, (guint) (_tmp11_ / 2));
#line 104 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp13_ = _page_ref0 ((Page*) _tmp12_);
#line 104 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					new_pages = g_list_append (new_pages, _tmp13_);
#line 576 "book.c"
				} else {
					GList* _tmp14_ = NULL;
					guint _tmp15_ = 0U;
					gint _tmp16_ = 0;
					gconstpointer _tmp17_ = NULL;
					Page* _tmp18_ = NULL;
#line 106 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp14_ = self->priv->pages;
#line 106 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp15_ = n_front;
#line 106 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp16_ = i;
#line 106 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp17_ = g_list_nth_data (_tmp14_, _tmp15_ + (_tmp16_ / 2));
#line 106 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp18_ = _page_ref0 ((Page*) _tmp17_);
#line 106 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					new_pages = g_list_append (new_pages, _tmp18_);
#line 595 "book.c"
				}
			}
		}
	}
#line 108 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp19_ = new_pages;
#line 108 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	new_pages = NULL;
#line 108 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	__g_list_free__page_unref0_0 (self->priv->pages);
#line 108 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv->pages = _tmp19_;
#line 110 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_emit_by_name (self, "reordered");
#line 111 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 97 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	__g_list_free__page_unref0_0 (new_pages);
#line 614 "book.c"
}


void book_combine_sides_reverse (Book* self) {
	GList* new_pages = NULL;
	GList* _tmp16_ = NULL;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 116 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	new_pages = NULL;
#line 625 "book.c"
	{
		gint i = 0;
#line 117 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		i = 0;
#line 630 "book.c"
		{
			gboolean _tmp0_ = FALSE;
#line 117 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			_tmp0_ = TRUE;
#line 117 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			while (TRUE) {
#line 637 "book.c"
				gint _tmp2_ = 0;
				guint _tmp3_ = 0U;
				guint _tmp4_ = 0U;
				gint _tmp5_ = 0;
#line 117 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!_tmp0_) {
#line 644 "book.c"
					gint _tmp1_ = 0;
#line 117 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp1_ = i;
#line 117 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					i = _tmp1_ + 1;
#line 650 "book.c"
				}
#line 117 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp0_ = FALSE;
#line 117 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp2_ = i;
#line 117 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp3_ = book_get_n_pages (self);
#line 117 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp4_ = _tmp3_;
#line 117 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!(((guint) _tmp2_) < _tmp4_)) {
#line 117 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					break;
#line 664 "book.c"
				}
#line 119 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp5_ = i;
#line 119 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if ((_tmp5_ % 2) == 0) {
#line 670 "book.c"
					GList* _tmp6_ = NULL;
					gint _tmp7_ = 0;
					gconstpointer _tmp8_ = NULL;
					Page* _tmp9_ = NULL;
#line 120 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp6_ = self->priv->pages;
#line 120 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp7_ = i;
#line 120 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp8_ = g_list_nth_data (_tmp6_, (guint) (_tmp7_ / 2));
#line 120 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp9_ = _page_ref0 ((Page*) _tmp8_);
#line 120 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					new_pages = g_list_append (new_pages, _tmp9_);
#line 685 "book.c"
				} else {
					GList* _tmp10_ = NULL;
					guint _tmp11_ = 0U;
					guint _tmp12_ = 0U;
					gint _tmp13_ = 0;
					gconstpointer _tmp14_ = NULL;
					Page* _tmp15_ = NULL;
#line 122 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp10_ = self->priv->pages;
#line 122 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp11_ = book_get_n_pages (self);
#line 122 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp12_ = _tmp11_;
#line 122 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp13_ = i;
#line 122 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp14_ = g_list_nth_data (_tmp10_, (_tmp12_ - 1) - (_tmp13_ / 2));
#line 122 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp15_ = _page_ref0 ((Page*) _tmp14_);
#line 122 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					new_pages = g_list_append (new_pages, _tmp15_);
#line 707 "book.c"
				}
			}
		}
	}
#line 124 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp16_ = new_pages;
#line 124 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	new_pages = NULL;
#line 124 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	__g_list_free__page_unref0_0 (self->priv->pages);
#line 124 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv->pages = _tmp16_;
#line 126 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_emit_by_name (self, "reordered");
#line 127 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 114 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	__g_list_free__page_unref0_0 (new_pages);
#line 726 "book.c"
}


void book_delete_page (Book* self, Page* page) {
	Page* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	Page* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	Page* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
#line 130 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 130 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (page != NULL);
#line 132 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = page;
#line 132 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp1_, NULL, FALSE);
#line 132 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _book_page_changed_cb_page_pixels_changed, self);
#line 133 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = page;
#line 133 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
#line 133 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _book_page_changed_cb_page_crop_changed, self);
#line 134 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp4_ = page;
#line 134 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv->pages = g_list_remove (self->priv->pages, _tmp4_);
#line 135 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5_ = page;
#line 135 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_emit_by_name (self, "page-removed", _tmp5_);
#line 136 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 763 "book.c"
}


Page* book_get_page (Book* self, gint page_number) {
	Page* result = NULL;
	gint _tmp0_ = 0;
	GList* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gconstpointer _tmp6_ = NULL;
	Page* _tmp7_ = NULL;
#line 139 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 141 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = page_number;
#line 141 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (_tmp0_ < 0) {
#line 780 "book.c"
		GList* _tmp1_ = NULL;
		guint _tmp2_ = 0U;
		gint _tmp3_ = 0;
#line 142 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp1_ = self->priv->pages;
#line 142 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp2_ = g_list_length (_tmp1_);
#line 142 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp3_ = page_number;
#line 142 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		page_number = ((gint) _tmp2_) + _tmp3_;
#line 792 "book.c"
	}
#line 143 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp4_ = self->priv->pages;
#line 143 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5_ = page_number;
#line 143 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp6_ = g_list_nth_data (_tmp4_, (guint) _tmp5_);
#line 143 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp7_ = _page_ref0 ((Page*) _tmp6_);
#line 143 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	result = _tmp7_;
#line 143 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return result;
#line 806 "book.c"
}


guint book_get_page_index (Book* self, Page* page) {
	guint result = 0U;
	GList* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 146 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 146 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (page != NULL, 0U);
#line 148 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = self->priv->pages;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = page;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = g_list_index (_tmp0_, _tmp1_);
#line 148 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	result = (guint) _tmp2_;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return result;
#line 829 "book.c"
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1017 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1018 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 1018 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 1018 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
#line 1018 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1020 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 1020 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 854 "book.c"
		gchar* _tmp4_ = NULL;
#line 1021 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 1021 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 1021 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 862 "book.c"
	} else {
#line 1023 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = -1;
#line 1023 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 868 "book.c"
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
#line 1328 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1329 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1329 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1329 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1330 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1330 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 902 "book.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1331 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1331 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1331 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 911 "book.c"
	}
#line 1333 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1333 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 917 "book.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1334 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1334 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1334 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 926 "book.c"
	}
#line 1336 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1336 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 932 "book.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1336 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1336 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1336 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 941 "book.c"
	} else {
#line 1336 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 945 "book.c"
	}
#line 1336 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp8_, NULL);
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp13_ = end;
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp13_ >= ((glong) 0)) {
#line 953 "book.c"
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp14_ = end;
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp12_ = _tmp14_ <= _tmp15_;
#line 962 "book.c"
	} else {
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp12_ = FALSE;
#line 966 "book.c"
	}
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1338 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp16_ = start;
#line 1338 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp17_ = end;
#line 1338 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
#line 1339 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1339 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1339 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1339 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
#line 1339 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp21_;
#line 1339 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 988 "book.c"
}


static GFile* book_make_indexed_file (Book* self, const gchar* uri, gint i) {
	GFile* result = NULL;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	gchar* basename = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* prefix = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* suffix = NULL;
	gchar* _tmp8_ = NULL;
	gint extension_index = 0;
	const gchar* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint width = 0;
	guint _tmp26_ = 0U;
	guint _tmp27_ = 0U;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	gchar* number_format = NULL;
	gint _tmp33_ = 0;
	gchar* _tmp34_ = NULL;
	gchar* filename = NULL;
	const gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	gchar* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	gchar* _tmp46_ = NULL;
	const gchar* _tmp47_ = NULL;
	GFile* _tmp48_ = NULL;
#line 151 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 151 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 153 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = book_get_n_pages (self);
#line 153 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = _tmp0_;
#line 153 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (_tmp1_ == ((guint) 1)) {
#line 1044 "book.c"
		const gchar* _tmp2_ = NULL;
		GFile* _tmp3_ = NULL;
#line 154 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp2_ = uri;
#line 154 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp3_ = g_file_new_for_uri (_tmp2_);
#line 154 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		result = _tmp3_;
#line 154 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		return result;
#line 1055 "book.c"
	}
#line 157 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp4_ = uri;
#line 157 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5_ = g_path_get_basename (_tmp4_);
#line 157 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	basename = _tmp5_;
#line 158 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp6_ = uri;
#line 158 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 158 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	prefix = _tmp7_;
#line 158 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp8_ = g_strdup ("");
#line 158 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	suffix = _tmp8_;
#line 159 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp9_ = basename;
#line 159 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp10_ = string_last_index_of_char (_tmp9_, (gunichar) '.', 0);
#line 159 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	extension_index = _tmp10_;
#line 160 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp11_ = extension_index;
#line 160 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (_tmp11_ >= 0) {
#line 1083 "book.c"
		const gchar* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		const gchar* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		const gchar* _tmp22_ = NULL;
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
		gchar* _tmp25_ = NULL;
#line 162 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp12_ = basename;
#line 162 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp13_ = extension_index;
#line 162 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp14_ = basename;
#line 162 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp15_ = strlen (_tmp14_);
#line 162 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp16_ = _tmp15_;
#line 162 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp17_ = string_slice (_tmp12_, (glong) _tmp13_, (glong) _tmp16_);
#line 162 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_g_free0 (suffix);
#line 162 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		suffix = _tmp17_;
#line 163 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp18_ = uri;
#line 163 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp19_ = uri;
#line 163 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp20_ = strlen (_tmp19_);
#line 163 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp21_ = _tmp20_;
#line 163 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp22_ = suffix;
#line 163 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp23_ = strlen (_tmp22_);
#line 163 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp24_ = _tmp23_;
#line 163 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp25_ = string_slice (_tmp18_, (glong) 0, (glong) (_tmp21_ - _tmp24_));
#line 163 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_g_free0 (prefix);
#line 163 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		prefix = _tmp25_;
#line 1134 "book.c"
	}
#line 165 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp26_ = book_get_n_pages (self);
#line 165 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp27_ = _tmp26_;
#line 165 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp28_ = g_strdup_printf ("%u", _tmp27_);
#line 165 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp29_ = _tmp28_;
#line 165 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp30_ = strlen (_tmp29_);
#line 165 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp31_ = _tmp30_;
#line 165 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp32_ = _tmp31_;
#line 165 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp29_);
#line 165 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	width = _tmp32_;
#line 166 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp33_ = width;
#line 166 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp34_ = g_strdup_printf ("%%0%dd", _tmp33_);
#line 166 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	number_format = _tmp34_;
#line 167 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp35_ = prefix;
#line 167 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp36_ = g_strconcat (_tmp35_, "-", NULL);
#line 167 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp37_ = _tmp36_;
#line 167 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp38_ = number_format;
#line 167 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp39_ = i;
#line 167 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp40_ = g_strdup_printf (_tmp38_, _tmp39_ + 1);
#line 167 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp41_ = _tmp40_;
#line 167 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp42_ = g_strconcat (_tmp37_, _tmp41_, NULL);
#line 167 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp43_ = _tmp42_;
#line 167 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp44_ = suffix;
#line 167 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp45_ = g_strconcat (_tmp43_, _tmp44_, NULL);
#line 167 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp46_ = _tmp45_;
#line 167 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp43_);
#line 167 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp41_);
#line 167 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp37_);
#line 167 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	filename = _tmp46_;
#line 168 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp47_ = filename;
#line 168 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp48_ = g_file_new_for_uri (_tmp47_);
#line 168 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	result = _tmp48_;
#line 168 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (filename);
#line 168 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (number_format);
#line 168 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (suffix);
#line 168 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (prefix);
#line 168 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (basename);
#line 168 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return result;
#line 1210 "book.c"
}


static void book_save_multi_file (Book* self, const gchar* type, gint quality, GFile* file, GError** error) {
	GError * _inner_error_ = NULL;
#line 171 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 171 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (type != NULL);
#line 171 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (file != NULL);
#line 1222 "book.c"
	{
		gint i = 0;
#line 173 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		i = 0;
#line 1227 "book.c"
		{
			gboolean _tmp0_ = FALSE;
#line 173 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			_tmp0_ = TRUE;
#line 173 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			while (TRUE) {
#line 1234 "book.c"
				gint _tmp2_ = 0;
				guint _tmp3_ = 0U;
				guint _tmp4_ = 0U;
				Page* page = NULL;
				gint _tmp5_ = 0;
				Page* _tmp6_ = NULL;
				Page* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				GFile* _tmp10_ = NULL;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_ = NULL;
				gint _tmp13_ = 0;
				GFile* _tmp14_ = NULL;
				GFile* _tmp15_ = NULL;
				gint _tmp16_ = 0;
#line 173 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!_tmp0_) {
#line 1253 "book.c"
					gint _tmp1_ = 0;
#line 173 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp1_ = i;
#line 173 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					i = _tmp1_ + 1;
#line 1259 "book.c"
				}
#line 173 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp0_ = FALSE;
#line 173 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp2_ = i;
#line 173 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp3_ = book_get_n_pages (self);
#line 173 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp4_ = _tmp3_;
#line 173 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!(((guint) _tmp2_) < _tmp4_)) {
#line 173 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					break;
#line 1273 "book.c"
				}
#line 175 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp5_ = i;
#line 175 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp6_ = book_get_page (self, _tmp5_);
#line 175 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				page = _tmp6_;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp7_ = page;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp8_ = type;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp9_ = quality;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp10_ = file;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp11_ = g_file_get_uri (_tmp10_);
#line 176 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp12_ = _tmp11_;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp13_ = i;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp14_ = book_make_indexed_file (self, _tmp12_, _tmp13_);
#line 176 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp15_ = _tmp14_;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				page_save (_tmp7_, _tmp8_, _tmp9_, _tmp15_, &_inner_error_);
#line 176 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_object_unref0 (_tmp15_);
#line 176 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp12_);
#line 176 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 176 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					g_propagate_error (error, _inner_error_);
#line 176 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_page_unref0 (page);
#line 176 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					return;
#line 1313 "book.c"
				}
#line 177 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp16_ = i;
#line 177 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				g_signal_emit_by_name (self, "saving", _tmp16_);
#line 173 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_page_unref0 (page);
#line 1321 "book.c"
			}
		}
	}
}


static void book_save_ps_pdf_surface (Book* self, cairo_surface_t* surface, GdkPixbuf* image, gdouble dpi) {
	cairo_t* context = NULL;
	cairo_surface_t* _tmp0_ = NULL;
	cairo_t* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	GdkPixbuf* _tmp4_ = NULL;
	cairo_pattern_t* _tmp5_ = NULL;
#line 181 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 181 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (surface != NULL);
#line 181 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (image != NULL);
#line 183 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = surface;
#line 183 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = cairo_create (_tmp0_);
#line 183 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	context = _tmp1_;
#line 184 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = dpi;
#line 184 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3_ = dpi;
#line 184 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	cairo_scale (context, 72.0 / _tmp2_, 72.0 / _tmp3_);
#line 185 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp4_ = image;
#line 185 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	gdk_cairo_set_source_pixbuf (context, _tmp4_, (gdouble) 0, (gdouble) 0);
#line 186 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5_ = cairo_get_source (context);
#line 186 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	cairo_pattern_set_filter (_tmp5_, CAIRO_FILTER_BEST);
#line 187 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	cairo_paint (context);
#line 181 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_cairo_destroy0 (context);
#line 1366 "book.c"
}


static gpointer _cairo_surface_reference0 (gpointer self) {
#line 194 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return self ? cairo_surface_reference (self) : NULL;
#line 1373 "book.c"
}


static void book_save_ps (Book* self, GFile* file, GError** error) {
	GFileOutputStream* stream = NULL;
	GFile* _tmp0_ = NULL;
	GFileOutputStream* _tmp1_ = NULL;
	PsWriter* writer = NULL;
	PsWriter* _tmp2_ = NULL;
	cairo_surface_t* surface = NULL;
	PsWriter* _tmp3_ = NULL;
	cairo_surface_t* _tmp4_ = NULL;
	cairo_surface_t* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 190 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 190 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (file != NULL);
#line 192 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = file;
#line 192 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = g_file_replace (_tmp0_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
#line 192 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	stream = _tmp1_;
#line 192 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 192 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_propagate_error (error, _inner_error_);
#line 192 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		return;
#line 1404 "book.c"
	}
#line 193 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = ps_writer_new (stream);
#line 193 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	writer = _tmp2_;
#line 194 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3_ = writer;
#line 194 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp4_ = _tmp3_->surface;
#line 194 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5_ = _cairo_surface_reference0 (_tmp4_);
#line 194 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	surface = _tmp5_;
#line 1418 "book.c"
	{
		gint i = 0;
#line 196 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		i = 0;
#line 1423 "book.c"
		{
			gboolean _tmp6_ = FALSE;
#line 196 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			_tmp6_ = TRUE;
#line 196 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			while (TRUE) {
#line 1430 "book.c"
				gint _tmp8_ = 0;
				guint _tmp9_ = 0U;
				guint _tmp10_ = 0U;
				Page* page = NULL;
				gint _tmp11_ = 0;
				Page* _tmp12_ = NULL;
				GdkPixbuf* image = NULL;
				Page* _tmp13_ = NULL;
				GdkPixbuf* _tmp14_ = NULL;
				gdouble width = 0.0;
				GdkPixbuf* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
				Page* _tmp18_ = NULL;
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
				gdouble height = 0.0;
				GdkPixbuf* _tmp21_ = NULL;
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
				Page* _tmp24_ = NULL;
				gint _tmp25_ = 0;
				gint _tmp26_ = 0;
				cairo_surface_t* _tmp27_ = NULL;
				gdouble _tmp28_ = 0.0;
				gdouble _tmp29_ = 0.0;
				cairo_surface_t* _tmp30_ = NULL;
				GdkPixbuf* _tmp31_ = NULL;
				Page* _tmp32_ = NULL;
				gint _tmp33_ = 0;
				gint _tmp34_ = 0;
				cairo_surface_t* _tmp35_ = NULL;
				gint _tmp36_ = 0;
#line 196 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!_tmp6_) {
#line 1466 "book.c"
					gint _tmp7_ = 0;
#line 196 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp7_ = i;
#line 196 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					i = _tmp7_ + 1;
#line 1472 "book.c"
				}
#line 196 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp6_ = FALSE;
#line 196 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp8_ = i;
#line 196 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp9_ = book_get_n_pages (self);
#line 196 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp10_ = _tmp9_;
#line 196 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!(((guint) _tmp8_) < _tmp10_)) {
#line 196 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					break;
#line 1486 "book.c"
				}
#line 198 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp11_ = i;
#line 198 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp12_ = book_get_page (self, _tmp11_);
#line 198 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				page = _tmp12_;
#line 199 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp13_ = page;
#line 199 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp14_ = page_get_image (_tmp13_, TRUE);
#line 199 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				image = _tmp14_;
#line 200 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp15_ = image;
#line 200 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp16_ = gdk_pixbuf_get_width (_tmp15_);
#line 200 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp17_ = _tmp16_;
#line 200 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp18_ = page;
#line 200 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp19_ = page_get_dpi (_tmp18_);
#line 200 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp20_ = _tmp19_;
#line 200 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				width = (_tmp17_ * 72.0) / _tmp20_;
#line 201 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp21_ = image;
#line 201 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp22_ = gdk_pixbuf_get_height (_tmp21_);
#line 201 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp23_ = _tmp22_;
#line 201 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp24_ = page;
#line 201 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp25_ = page_get_dpi (_tmp24_);
#line 201 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp26_ = _tmp25_;
#line 201 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				height = (_tmp23_ * 72.0) / _tmp26_;
#line 202 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp27_ = surface;
#line 202 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp28_ = width;
#line 202 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp29_ = height;
#line 202 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				cairo_ps_surface_set_size (_tmp27_, _tmp28_, _tmp29_);
#line 203 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp30_ = surface;
#line 203 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp31_ = image;
#line 203 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp32_ = page;
#line 203 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp33_ = page_get_dpi (_tmp32_);
#line 203 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp34_ = _tmp33_;
#line 203 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				book_save_ps_pdf_surface (self, _tmp30_, _tmp31_, (gdouble) _tmp34_);
#line 204 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp35_ = surface;
#line 204 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				cairo_surface_show_page (_tmp35_);
#line 205 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp36_ = i;
#line 205 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				g_signal_emit_by_name (self, "saving", _tmp36_);
#line 196 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_object_unref0 (image);
#line 196 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_page_unref0 (page);
#line 1560 "book.c"
			}
		}
	}
#line 190 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_cairo_surface_destroy0 (surface);
#line 190 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_ps_writer_unref0 (writer);
#line 190 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_object_unref0 (stream);
#line 1570 "book.c"
}


static guint8* book_compress_zlib (Book* self, guint8* data, int data_length1, int* result_length1) {
	guint8* result = NULL;
	z_stream stream = {0};
	guint8* out_data = NULL;
	guint8* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	guint8* _tmp1_ = NULL;
	gint out_data_length1 = 0;
	gint _out_data_size_ = 0;
	guint8* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	z_stream _tmp7_ = {0};
	guint _tmp8_ = 0U;
	guint n_written = 0U;
	guint8* _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	z_stream _tmp11_ = {0};
	guint _tmp12_ = 0U;
	guint _tmp13_ = 0U;
	gint _tmp14_ = 0;
	guint8* _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
#line 209 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 211 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	deflateInit (&stream, (gint) Z_BEST_COMPRESSION);
#line 212 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = data;
#line 212 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0__length1 = data_length1;
#line 212 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = g_new0 (guint8, _tmp0__length1);
#line 212 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	out_data = _tmp1_;
#line 212 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	out_data_length1 = _tmp0__length1;
#line 212 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_out_data_size_ = out_data_length1;
#line 214 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = data;
#line 214 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2__length1 = data_length1;
#line 214 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	stream.next_in = _tmp2_;
#line 214 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	stream.avail_in = _tmp2__length1;
#line 215 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3_ = out_data;
#line 215 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3__length1 = out_data_length1;
#line 215 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	stream.next_out = _tmp3_;
#line 215 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	stream.avail_out = _tmp3__length1;
#line 216 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	while (TRUE) {
#line 1632 "book.c"
		z_stream _tmp4_ = {0};
		guint _tmp5_ = 0U;
		gint _tmp6_ = 0;
#line 216 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp4_ = stream;
#line 216 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp5_ = _tmp4_.avail_in;
#line 216 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		if (!(_tmp5_ > ((guint) 0))) {
#line 216 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			break;
#line 1644 "book.c"
		}
#line 218 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp6_ = deflate (&stream, (gint) Z_FINISH);
#line 218 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		if (_tmp6_ == ((gint) Z_STREAM_ERROR)) {
#line 219 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			break;
#line 1652 "book.c"
		}
	}
#line 222 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp7_ = stream;
#line 222 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp8_ = _tmp7_.avail_in;
#line 222 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (_tmp8_ > ((guint) 0)) {
#line 1661 "book.c"
		guint8* _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
#line 223 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp9_ = NULL;
#line 223 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp9__length1 = 0;
#line 223 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		if (result_length1) {
#line 223 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			*result_length1 = _tmp9__length1;
#line 1672 "book.c"
		}
#line 223 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		result = _tmp9_;
#line 223 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		out_data = (g_free (out_data), NULL);
#line 223 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		deflateEnd (&stream);
#line 223 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		return result;
#line 1682 "book.c"
	}
#line 225 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp10_ = data;
#line 225 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp10__length1 = data_length1;
#line 225 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp11_ = stream;
#line 225 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp12_ = _tmp11_.avail_out;
#line 225 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	n_written = _tmp10__length1 - _tmp12_;
#line 226 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp13_ = n_written;
#line 226 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp14_ = (gint) _tmp13_;
#line 226 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	out_data = g_renew (guint8, out_data, (gint) _tmp13_);
#line 226 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	(_tmp14_ > out_data_length1) ? memset (out_data + out_data_length1, 0, sizeof (guint8) * (_tmp14_ - out_data_length1)) : NULL;
#line 226 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	out_data_length1 = _tmp14_;
#line 226 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_out_data_size_ = _tmp14_;
#line 228 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp15_ = out_data;
#line 228 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp15__length1 = out_data_length1;
#line 228 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (result_length1) {
#line 228 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		*result_length1 = _tmp15__length1;
#line 1714 "book.c"
	}
#line 228 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	result = _tmp15_;
#line 228 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	deflateEnd (&stream);
#line 228 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return result;
#line 1722 "book.c"
}


static gboolean _book_write_pixbuf_data_gdk_pixbuf_save_func (guint8* buf, gsize buf_length1, GError** error, gpointer self) {
	gboolean result;
	result = book_write_pixbuf_data ((Book*) self, buf, buf_length1, error);
#line 240 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return result;
#line 1731 "book.c"
}


static guint8* book_compress_jpeg (Book* self, GdkPixbuf* image, gint quality, gint dpi, int* result_length1) {
	guint8* result = NULL;
	GByteArray* _tmp0_ = NULL;
	gchar** keys = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint keys_length1 = 0;
	gint _keys_size_ = 0;
	gchar** values = NULL;
	gint _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gchar* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gchar* _tmp12_ = NULL;
	gchar** _tmp13_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	guint8* data = NULL;
	GByteArray* _tmp15_ = NULL;
	guint8* _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gint data_length1 = 0;
	gint _data_size_ = 0;
	guint8* _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	GError * _inner_error_ = NULL;
#line 233 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 233 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (image != NULL, NULL);
#line 235 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = g_byte_array_new ();
#line 235 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_byte_array_unref0 (self->priv->jpeg_data);
#line 235 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv->jpeg_data = _tmp0_;
#line 236 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = g_strdup ("quality");
#line 236 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = g_strdup ("density-unit");
#line 236 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3_ = g_strdup ("x-density");
#line 236 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp4_ = g_strdup ("y-density");
#line 236 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5_ = g_new0 (gchar*, 5 + 1);
#line 236 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5_[0] = _tmp1_;
#line 236 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5_[1] = _tmp2_;
#line 236 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5_[2] = _tmp3_;
#line 236 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5_[3] = _tmp4_;
#line 236 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5_[4] = NULL;
#line 236 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	keys = _tmp5_;
#line 236 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	keys_length1 = 5;
#line 236 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_keys_size_ = keys_length1;
#line 237 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp6_ = quality;
#line 237 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp7_ = g_strdup_printf ("%d", _tmp6_);
#line 237 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp8_ = g_strdup ("dots-per-inch");
#line 237 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp9_ = dpi;
#line 237 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp10_ = g_strdup_printf ("%d", _tmp9_);
#line 237 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp11_ = dpi;
#line 237 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp12_ = g_strdup_printf ("%d", _tmp11_);
#line 237 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp13_ = g_new0 (gchar*, 5 + 1);
#line 237 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp13_[0] = _tmp7_;
#line 237 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp13_[1] = _tmp8_;
#line 237 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp13_[2] = _tmp10_;
#line 237 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp13_[3] = _tmp12_;
#line 237 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp13_[4] = NULL;
#line 237 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	values = _tmp13_;
#line 237 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	values_length1 = 5;
#line 237 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_values_size_ = values_length1;
#line 1834 "book.c"
	{
		GdkPixbuf* _tmp14_ = NULL;
#line 240 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp14_ = image;
#line 240 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		gdk_pixbuf_save_to_callbackv (_tmp14_, _book_write_pixbuf_data_gdk_pixbuf_save_func, self, "jpeg", keys, values, &_inner_error_);
#line 240 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1843 "book.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
#line 238 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		e = _inner_error_;
#line 238 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_inner_error_ = NULL;
#line 238 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_g_error_free0 (e);
#line 1857 "book.c"
	}
	__finally0:
#line 238 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 238 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 238 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 238 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 238 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_clear_error (&_inner_error_);
#line 238 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		return NULL;
#line 1872 "book.c"
	}
#line 245 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp15_ = self->priv->jpeg_data;
#line 245 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp16_ = _tmp15_->data;
#line 245 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp16__length1 = _tmp15_->len;
#line 245 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp15_->data = NULL;
#line 245 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp15_->len = 0;
#line 245 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	data = _tmp16_;
#line 245 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	data_length1 = _tmp16__length1;
#line 245 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_data_size_ = data_length1;
#line 246 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_byte_array_unref0 (self->priv->jpeg_data);
#line 246 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv->jpeg_data = NULL;
#line 248 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp17_ = data;
#line 248 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp17__length1 = data_length1;
#line 248 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (result_length1) {
#line 248 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		*result_length1 = _tmp17__length1;
#line 1902 "book.c"
	}
#line 248 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	result = _tmp17_;
#line 248 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 248 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 248 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return result;
#line 1912 "book.c"
}


static gboolean book_write_pixbuf_data (Book* self, guint8* buf, int buf_length1, GError** error) {
	gboolean result = FALSE;
	GByteArray* _tmp0_ = NULL;
	guint8* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
#line 251 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 253 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = self->priv->jpeg_data;
#line 253 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = buf;
#line 253 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1__length1 = buf_length1;
#line 253 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_byte_array_append (_tmp0_, _tmp1_, _tmp1__length1);
#line 254 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	result = TRUE;
#line 254 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return result;
#line 1935 "book.c"
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* str = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 941 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, 7);
#line 941 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	str = (gchar*) _tmp0_;
#line 942 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = str;
#line 942 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_unichar_to_utf8 (self, _tmp1_);
#line 943 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = str;
#line 943 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 1956 "book.c"
}


static guint8* _vala_array_dup1 (guint8* self, int length) {
#line 494 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 1963 "book.c"
}


static guint8* _vala_array_dup2 (guint8* self, int length) {
#line 501 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 1970 "book.c"
}


static void book_save_pdf (Book* self, GFile* file, gint quality, GError** error) {
	gchar* id = NULL;
	gchar* _tmp0_ = NULL;
	GFileOutputStream* stream = NULL;
	GFile* _tmp9_ = NULL;
	GFileOutputStream* _tmp10_ = NULL;
	PDFWriter* writer = NULL;
	PDFWriter* _tmp11_ = NULL;
	guint catalog_number = 0U;
	PDFWriter* _tmp12_ = NULL;
	guint _tmp13_ = 0U;
	guint metadata_number = 0U;
	PDFWriter* _tmp14_ = NULL;
	guint _tmp15_ = 0U;
	guint pages_number = 0U;
	PDFWriter* _tmp16_ = NULL;
	guint _tmp17_ = 0U;
	guint info_number = 0U;
	PDFWriter* _tmp18_ = NULL;
	guint _tmp19_ = 0U;
	guint* page_numbers = NULL;
	guint _tmp20_ = 0U;
	guint _tmp21_ = 0U;
	guint* _tmp22_ = NULL;
	gint page_numbers_length1 = 0;
	gint _page_numbers_size_ = 0;
	guint* page_image_numbers = NULL;
	guint _tmp23_ = 0U;
	guint _tmp24_ = 0U;
	guint* _tmp25_ = NULL;
	gint page_image_numbers_length1 = 0;
	gint _page_image_numbers_size_ = 0;
	guint* page_content_numbers = NULL;
	guint _tmp26_ = 0U;
	guint _tmp27_ = 0U;
	guint* _tmp28_ = NULL;
	gint page_content_numbers_length1 = 0;
	gint _page_content_numbers_size_ = 0;
	guint struct_tree_root_number = 0U;
	PDFWriter* _tmp49_ = NULL;
	guint _tmp50_ = 0U;
	PDFWriter* _tmp51_ = NULL;
	PDFWriter* _tmp52_ = NULL;
	PDFWriter* _tmp53_ = NULL;
	guint _tmp54_ = 0U;
	PDFWriter* _tmp55_ = NULL;
	guint _tmp56_ = 0U;
	gchar* _tmp57_ = NULL;
	gchar* _tmp58_ = NULL;
	PDFWriter* _tmp59_ = NULL;
	PDFWriter* _tmp60_ = NULL;
	PDFWriter* _tmp61_ = NULL;
	guint _tmp62_ = 0U;
	gchar* _tmp63_ = NULL;
	gchar* _tmp64_ = NULL;
	PDFWriter* _tmp65_ = NULL;
	PDFWriter* _tmp66_ = NULL;
	guint _tmp67_ = 0U;
	gchar* _tmp68_ = NULL;
	gchar* _tmp69_ = NULL;
	PDFWriter* _tmp70_ = NULL;
	guint _tmp71_ = 0U;
	gchar* _tmp72_ = NULL;
	gchar* _tmp73_ = NULL;
	PDFWriter* _tmp74_ = NULL;
	PDFWriter* _tmp75_ = NULL;
	GDateTime* now = NULL;
	GDateTime* _tmp76_ = NULL;
	gchar* date_string = NULL;
	GDateTime* _tmp77_ = NULL;
	gchar* _tmp78_ = NULL;
	gchar* metadata = NULL;
	gchar* _tmp79_ = NULL;
	gchar* _tmp80_ = NULL;
	const gchar* _tmp81_ = NULL;
	const gchar* _tmp82_ = NULL;
	const gchar* _tmp83_ = NULL;
	gchar* _tmp84_ = NULL;
	gchar* _tmp85_ = NULL;
	PDFWriter* _tmp86_ = NULL;
	PDFWriter* _tmp87_ = NULL;
	guint _tmp88_ = 0U;
	PDFWriter* _tmp89_ = NULL;
	guint _tmp90_ = 0U;
	gchar* _tmp91_ = NULL;
	gchar* _tmp92_ = NULL;
	PDFWriter* _tmp93_ = NULL;
	PDFWriter* _tmp94_ = NULL;
	PDFWriter* _tmp95_ = NULL;
	PDFWriter* _tmp96_ = NULL;
	const gchar* _tmp97_ = NULL;
	gint _tmp98_ = 0;
	gint _tmp99_ = 0;
	gchar* _tmp100_ = NULL;
	gchar* _tmp101_ = NULL;
	PDFWriter* _tmp102_ = NULL;
	PDFWriter* _tmp103_ = NULL;
	PDFWriter* _tmp104_ = NULL;
	const gchar* _tmp105_ = NULL;
	PDFWriter* _tmp106_ = NULL;
	PDFWriter* _tmp107_ = NULL;
	PDFWriter* _tmp108_ = NULL;
	PDFWriter* _tmp109_ = NULL;
	PDFWriter* _tmp110_ = NULL;
	guint _tmp111_ = 0U;
	PDFWriter* _tmp112_ = NULL;
	guint _tmp113_ = 0U;
	gchar* _tmp114_ = NULL;
	gchar* _tmp115_ = NULL;
	PDFWriter* _tmp116_ = NULL;
	PDFWriter* _tmp117_ = NULL;
	PDFWriter* _tmp118_ = NULL;
	PDFWriter* _tmp130_ = NULL;
	PDFWriter* _tmp131_ = NULL;
	guint _tmp132_ = 0U;
	guint _tmp133_ = 0U;
	gchar* _tmp134_ = NULL;
	gchar* _tmp135_ = NULL;
	PDFWriter* _tmp136_ = NULL;
	PDFWriter* _tmp137_ = NULL;
	PDFWriter* _tmp475_ = NULL;
	PDFWriter* _tmp476_ = NULL;
	guint _tmp477_ = 0U;
	PDFWriter* _tmp478_ = NULL;
	guint _tmp479_ = 0U;
	gchar* _tmp480_ = NULL;
	gchar* _tmp481_ = NULL;
	PDFWriter* _tmp482_ = NULL;
	PDFWriter* _tmp483_ = NULL;
	gchar* _tmp484_ = NULL;
	gchar* _tmp485_ = NULL;
	PDFWriter* _tmp486_ = NULL;
	PDFWriter* _tmp487_ = NULL;
	PDFWriter* _tmp488_ = NULL;
	gsize xref_offset = 0UL;
	PDFWriter* _tmp489_ = NULL;
	gsize _tmp490_ = 0UL;
	PDFWriter* _tmp491_ = NULL;
	PDFWriter* _tmp492_ = NULL;
	PDFWriter* _tmp493_ = NULL;
	guint* _tmp494_ = NULL;
	gint _tmp494__length1 = 0;
	gchar* _tmp495_ = NULL;
	gchar* _tmp496_ = NULL;
	PDFWriter* _tmp497_ = NULL;
	PDFWriter* _tmp498_ = NULL;
	gint _tmp499_ = 0;
	gchar* _tmp500_ = NULL;
	gchar* _tmp501_ = NULL;
	PDFWriter* _tmp524_ = NULL;
	PDFWriter* _tmp525_ = NULL;
	PDFWriter* _tmp526_ = NULL;
	PDFWriter* _tmp527_ = NULL;
	PDFWriter* _tmp528_ = NULL;
	guint* _tmp529_ = NULL;
	gint _tmp529__length1 = 0;
	gchar* _tmp530_ = NULL;
	gchar* _tmp531_ = NULL;
	PDFWriter* _tmp532_ = NULL;
	guint _tmp533_ = 0U;
	gchar* _tmp534_ = NULL;
	gchar* _tmp535_ = NULL;
	PDFWriter* _tmp536_ = NULL;
	guint _tmp537_ = 0U;
	gchar* _tmp538_ = NULL;
	gchar* _tmp539_ = NULL;
	PDFWriter* _tmp540_ = NULL;
	const gchar* _tmp541_ = NULL;
	const gchar* _tmp542_ = NULL;
	gchar* _tmp543_ = NULL;
	gchar* _tmp544_ = NULL;
	PDFWriter* _tmp545_ = NULL;
	PDFWriter* _tmp546_ = NULL;
	PDFWriter* _tmp547_ = NULL;
	gsize _tmp548_ = 0UL;
	gchar* _tmp549_ = NULL;
	gchar* _tmp550_ = NULL;
	PDFWriter* _tmp551_ = NULL;
	GError * _inner_error_ = NULL;
#line 257 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 257 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (file != NULL);
#line 260 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = g_strdup ("");
#line 260 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	id = _tmp0_;
#line 2161 "book.c"
	{
		gint i = 0;
#line 261 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		i = 0;
#line 2166 "book.c"
		{
			gboolean _tmp1_ = FALSE;
#line 261 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			_tmp1_ = TRUE;
#line 261 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			while (TRUE) {
#line 2173 "book.c"
				gint _tmp3_ = 0;
				const gchar* _tmp4_ = NULL;
				guint32 _tmp5_ = 0U;
				gchar* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_ = NULL;
#line 261 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!_tmp1_) {
#line 2182 "book.c"
					gint _tmp2_ = 0;
#line 261 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp2_ = i;
#line 261 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					i = _tmp2_ + 1;
#line 2188 "book.c"
				}
#line 261 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp1_ = FALSE;
#line 261 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp3_ = i;
#line 261 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!(_tmp3_ < 4)) {
#line 261 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					break;
#line 2198 "book.c"
				}
#line 262 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp4_ = id;
#line 262 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp5_ = g_random_int ();
#line 262 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp6_ = g_strdup_printf ("%08x", (guint) _tmp5_);
#line 262 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp7_ = _tmp6_;
#line 262 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp8_ = g_strconcat (_tmp4_, _tmp7_, NULL);
#line 262 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (id);
#line 262 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				id = _tmp8_;
#line 262 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp7_);
#line 2216 "book.c"
			}
		}
	}
#line 264 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp9_ = file;
#line 264 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp10_ = g_file_replace (_tmp9_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
#line 264 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	stream = _tmp10_;
#line 264 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 264 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_propagate_error (error, _inner_error_);
#line 264 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_g_free0 (id);
#line 264 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		return;
#line 2234 "book.c"
	}
#line 265 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp11_ = pdf_writer_new (stream);
#line 265 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	writer = _tmp11_;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp12_ = writer;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp13_ = pdf_writer_add_object (_tmp12_);
#line 268 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	catalog_number = _tmp13_;
#line 269 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp14_ = writer;
#line 269 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp15_ = pdf_writer_add_object (_tmp14_);
#line 269 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	metadata_number = _tmp15_;
#line 270 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp16_ = writer;
#line 270 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp17_ = pdf_writer_add_object (_tmp16_);
#line 270 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pages_number = _tmp17_;
#line 271 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp18_ = writer;
#line 271 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp19_ = pdf_writer_add_object (_tmp18_);
#line 271 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	info_number = _tmp19_;
#line 272 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp20_ = book_get_n_pages (self);
#line 272 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp21_ = _tmp20_;
#line 272 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp22_ = g_new0 (guint, _tmp21_);
#line 272 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	page_numbers = _tmp22_;
#line 272 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	page_numbers_length1 = _tmp21_;
#line 272 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_page_numbers_size_ = page_numbers_length1;
#line 273 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp23_ = book_get_n_pages (self);
#line 273 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp24_ = _tmp23_;
#line 273 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp25_ = g_new0 (guint, _tmp24_);
#line 273 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	page_image_numbers = _tmp25_;
#line 273 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	page_image_numbers_length1 = _tmp24_;
#line 273 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_page_image_numbers_size_ = page_image_numbers_length1;
#line 274 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp26_ = book_get_n_pages (self);
#line 274 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp27_ = _tmp26_;
#line 274 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp28_ = g_new0 (guint, _tmp27_);
#line 274 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	page_content_numbers = _tmp28_;
#line 274 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	page_content_numbers_length1 = _tmp27_;
#line 274 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_page_content_numbers_size_ = page_content_numbers_length1;
#line 2300 "book.c"
	{
		gint i = 0;
#line 275 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		i = 0;
#line 2305 "book.c"
		{
			gboolean _tmp29_ = FALSE;
#line 275 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			_tmp29_ = TRUE;
#line 275 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			while (TRUE) {
#line 2312 "book.c"
				gint _tmp31_ = 0;
				guint _tmp32_ = 0U;
				guint _tmp33_ = 0U;
				guint* _tmp34_ = NULL;
				gint _tmp34__length1 = 0;
				gint _tmp35_ = 0;
				PDFWriter* _tmp36_ = NULL;
				guint _tmp37_ = 0U;
				guint _tmp38_ = 0U;
				guint* _tmp39_ = NULL;
				gint _tmp39__length1 = 0;
				gint _tmp40_ = 0;
				PDFWriter* _tmp41_ = NULL;
				guint _tmp42_ = 0U;
				guint _tmp43_ = 0U;
				guint* _tmp44_ = NULL;
				gint _tmp44__length1 = 0;
				gint _tmp45_ = 0;
				PDFWriter* _tmp46_ = NULL;
				guint _tmp47_ = 0U;
				guint _tmp48_ = 0U;
#line 275 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!_tmp29_) {
#line 2336 "book.c"
					gint _tmp30_ = 0;
#line 275 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp30_ = i;
#line 275 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					i = _tmp30_ + 1;
#line 2342 "book.c"
				}
#line 275 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp29_ = FALSE;
#line 275 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp31_ = i;
#line 275 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp32_ = book_get_n_pages (self);
#line 275 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp33_ = _tmp32_;
#line 275 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!(((guint) _tmp31_) < _tmp33_)) {
#line 275 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					break;
#line 2356 "book.c"
				}
#line 277 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp34_ = page_numbers;
#line 277 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp34__length1 = page_numbers_length1;
#line 277 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp35_ = i;
#line 277 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp36_ = writer;
#line 277 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp37_ = pdf_writer_add_object (_tmp36_);
#line 277 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp34_[_tmp35_] = _tmp37_;
#line 277 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp38_ = _tmp34_[_tmp35_];
#line 278 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp39_ = page_image_numbers;
#line 278 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp39__length1 = page_image_numbers_length1;
#line 278 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp40_ = i;
#line 278 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp41_ = writer;
#line 278 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp42_ = pdf_writer_add_object (_tmp41_);
#line 278 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp39_[_tmp40_] = _tmp42_;
#line 278 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp43_ = _tmp39_[_tmp40_];
#line 279 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp44_ = page_content_numbers;
#line 279 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp44__length1 = page_content_numbers_length1;
#line 279 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp45_ = i;
#line 279 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp46_ = writer;
#line 279 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp47_ = pdf_writer_add_object (_tmp46_);
#line 279 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp44_[_tmp45_] = _tmp47_;
#line 279 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp48_ = _tmp44_[_tmp45_];
#line 2400 "book.c"
			}
		}
	}
#line 281 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp49_ = writer;
#line 281 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp50_ = pdf_writer_add_object (_tmp49_);
#line 281 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	struct_tree_root_number = _tmp50_;
#line 284 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp51_ = writer;
#line 284 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp51_, "%PDF-1.3\n");
#line 287 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp52_ = writer;
#line 287 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp52_, "%\xe2\xe3\xcf\xd3\n");
#line 290 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp53_ = writer;
#line 290 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp54_ = catalog_number;
#line 290 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_start_object (_tmp53_, _tmp54_);
#line 291 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp55_ = writer;
#line 291 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp56_ = catalog_number;
#line 291 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp57_ = g_strdup_printf ("%u 0 obj\n", _tmp56_);
#line 291 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp58_ = _tmp57_;
#line 291 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp55_, _tmp58_);
#line 291 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp58_);
#line 292 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp59_ = writer;
#line 292 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp59_, "<<\n");
#line 293 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp60_ = writer;
#line 293 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp60_, "/Type /Catalog\n");
#line 294 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp61_ = writer;
#line 294 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp62_ = metadata_number;
#line 294 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp63_ = g_strdup_printf ("/Metadata %u 0 R\n", _tmp62_);
#line 294 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp64_ = _tmp63_;
#line 294 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp61_, _tmp64_);
#line 294 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp64_);
#line 295 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp65_ = writer;
#line 295 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp65_, "/MarkInfo << /Marked true >>\n");
#line 296 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp66_ = writer;
#line 296 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp67_ = struct_tree_root_number;
#line 296 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp68_ = g_strdup_printf ("/StructTreeRoot %u 0 R\n", _tmp67_);
#line 296 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp69_ = _tmp68_;
#line 296 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp66_, _tmp69_);
#line 296 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp69_);
#line 297 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp70_ = writer;
#line 297 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp71_ = pages_number;
#line 297 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp72_ = g_strdup_printf ("/Pages %u 0 R\n", _tmp71_);
#line 297 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp73_ = _tmp72_;
#line 297 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp70_, _tmp73_);
#line 297 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp73_);
#line 298 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp74_ = writer;
#line 298 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp74_, ">>\n");
#line 299 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp75_ = writer;
#line 299 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp75_, "endobj\n");
#line 302 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp76_ = g_date_time_new_now_local ();
#line 302 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	now = _tmp76_;
#line 303 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp77_ = now;
#line 303 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp78_ = g_date_time_format (_tmp77_, "%FT%H:%M:%S%:z");
#line 303 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	date_string = _tmp78_;
#line 305 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp79_ = g_unichar_to_string ((gunichar) 0xFEFF);
#line 305 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp80_ = _tmp79_;
#line 305 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp81_ = date_string;
#line 305 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp82_ = date_string;
#line 305 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp83_ = date_string;
#line 305 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp84_ = g_strdup_printf ("<?xpacket begin=\"%s\" id=\"W5M0MpCehiHzreSzNTczkc9d\"?>\n" \
"<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n" \
"         xmlns:xmp=\"http://ns.adobe.com/xap/1.0/\">\n" \
"  <rdf:Description rdf:about=\"\"\n" \
"                   xmlns:pdfaid=\"http://www.aiim.org/pdfa/ns/id/\"\n" \
"                   xmlns:xmp=\"http://ns.adobe.com/xap/1.0/\">\n" \
"    <pdfaid:part>1</pdfaid:part>\n" \
"    <pdfaid:conformance>A</pdfaid:conformance>\n" \
"    <xmp:CreatorTool>Simple Scan %s</xmp:CreatorTool>\n" \
"    <xmp:CreateDate>%s</xmp:CreateDate>\n" \
"    <xmp:ModifyDate>%s</xmp:ModifyDate>\n" \
"    <xmp:MetadataDate>%s</xmp:MetadataDate>\n" \
"  </rdf:Description>\n" \
"</rdf:RDF>\n" \
"<?xpacket end=\"w\"?>", _tmp80_, VERSION, _tmp81_, _tmp82_, _tmp83_);
#line 305 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp85_ = _tmp84_;
#line 305 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp80_);
#line 305 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	metadata = _tmp85_;
#line 320 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp86_ = writer;
#line 320 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp86_, "\n");
#line 321 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp87_ = writer;
#line 321 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp88_ = metadata_number;
#line 321 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_start_object (_tmp87_, _tmp88_);
#line 322 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp89_ = writer;
#line 322 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp90_ = metadata_number;
#line 322 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp91_ = g_strdup_printf ("%u 0 obj\n", _tmp90_);
#line 322 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp92_ = _tmp91_;
#line 322 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp89_, _tmp92_);
#line 322 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp92_);
#line 323 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp93_ = writer;
#line 323 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp93_, "<<\n");
#line 324 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp94_ = writer;
#line 324 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp94_, "/Type /Metadata\n");
#line 325 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp95_ = writer;
#line 325 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp95_, "/Subtype /XML\n");
#line 326 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp96_ = writer;
#line 326 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp97_ = metadata;
#line 326 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp98_ = strlen (_tmp97_);
#line 326 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp99_ = _tmp98_;
#line 326 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp100_ = g_strdup_printf ("/Length %u\n", (guint) _tmp99_);
#line 326 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp101_ = _tmp100_;
#line 326 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp96_, _tmp101_);
#line 326 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp101_);
#line 327 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp102_ = writer;
#line 327 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp102_, ">>\n");
#line 328 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp103_ = writer;
#line 328 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp103_, "stream\n");
#line 329 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp104_ = writer;
#line 329 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp105_ = metadata;
#line 329 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp104_, _tmp105_);
#line 330 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp106_ = writer;
#line 330 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp106_, "\n");
#line 331 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp107_ = writer;
#line 331 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp107_, "endstream\n");
#line 332 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp108_ = writer;
#line 332 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp108_, "endobj\n");
#line 335 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp109_ = writer;
#line 335 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp109_, "\n");
#line 336 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp110_ = writer;
#line 336 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp111_ = pages_number;
#line 336 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_start_object (_tmp110_, _tmp111_);
#line 337 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp112_ = writer;
#line 337 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp113_ = pages_number;
#line 337 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp114_ = g_strdup_printf ("%u 0 obj\n", _tmp113_);
#line 337 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp115_ = _tmp114_;
#line 337 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp112_, _tmp115_);
#line 337 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp115_);
#line 338 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp116_ = writer;
#line 338 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp116_, "<<\n");
#line 339 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp117_ = writer;
#line 339 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp117_, "/Type /Pages\n");
#line 340 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp118_ = writer;
#line 340 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp118_, "/Kids [");
#line 2630 "book.c"
	{
		gint i = 0;
#line 341 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		i = 0;
#line 2635 "book.c"
		{
			gboolean _tmp119_ = FALSE;
#line 341 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			_tmp119_ = TRUE;
#line 341 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			while (TRUE) {
#line 2642 "book.c"
				gint _tmp121_ = 0;
				guint _tmp122_ = 0U;
				guint _tmp123_ = 0U;
				PDFWriter* _tmp124_ = NULL;
				guint* _tmp125_ = NULL;
				gint _tmp125__length1 = 0;
				gint _tmp126_ = 0;
				guint _tmp127_ = 0U;
				gchar* _tmp128_ = NULL;
				gchar* _tmp129_ = NULL;
#line 341 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!_tmp119_) {
#line 2655 "book.c"
					gint _tmp120_ = 0;
#line 341 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp120_ = i;
#line 341 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					i = _tmp120_ + 1;
#line 2661 "book.c"
				}
#line 341 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp119_ = FALSE;
#line 341 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp121_ = i;
#line 341 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp122_ = book_get_n_pages (self);
#line 341 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp123_ = _tmp122_;
#line 341 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!(((guint) _tmp121_) < _tmp123_)) {
#line 341 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					break;
#line 2675 "book.c"
				}
#line 342 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp124_ = writer;
#line 342 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp125_ = page_numbers;
#line 342 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp125__length1 = page_numbers_length1;
#line 342 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp126_ = i;
#line 342 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp127_ = _tmp125_[_tmp126_];
#line 342 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp128_ = g_strdup_printf (" %u 0 R", _tmp127_);
#line 342 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp129_ = _tmp128_;
#line 342 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp124_, _tmp129_);
#line 342 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp129_);
#line 2695 "book.c"
			}
		}
	}
#line 343 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp130_ = writer;
#line 343 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp130_, " ]\n");
#line 344 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp131_ = writer;
#line 344 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp132_ = book_get_n_pages (self);
#line 344 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp133_ = _tmp132_;
#line 344 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp134_ = g_strdup_printf ("/Count %u\n", _tmp133_);
#line 344 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp135_ = _tmp134_;
#line 344 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp131_, _tmp135_);
#line 344 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp135_);
#line 345 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp136_ = writer;
#line 345 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp136_, ">>\n");
#line 346 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp137_ = writer;
#line 346 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp137_, "endobj\n");
#line 2725 "book.c"
	{
		gint i = 0;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		i = 0;
#line 2730 "book.c"
		{
			gboolean _tmp138_ = FALSE;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			_tmp138_ = TRUE;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			while (TRUE) {
#line 2737 "book.c"
				gint _tmp140_ = 0;
				guint _tmp141_ = 0U;
				guint _tmp142_ = 0U;
				Page* page = NULL;
				gint _tmp143_ = 0;
				Page* _tmp144_ = NULL;
				GdkPixbuf* image = NULL;
				Page* _tmp145_ = NULL;
				GdkPixbuf* _tmp146_ = NULL;
				gint width = 0;
				GdkPixbuf* _tmp147_ = NULL;
				gint _tmp148_ = 0;
				gint _tmp149_ = 0;
				gint height = 0;
				GdkPixbuf* _tmp150_ = NULL;
				gint _tmp151_ = 0;
				gint _tmp152_ = 0;
				guint8* pixels = NULL;
				GdkPixbuf* _tmp153_ = NULL;
				guint8* _tmp154_ = NULL;
				gint pixels_length1 = 0;
				gint _pixels_size_ = 0;
				gdouble page_width = 0.0;
				gint _tmp155_ = 0;
				Page* _tmp156_ = NULL;
				gint _tmp157_ = 0;
				gint _tmp158_ = 0;
				gdouble page_height = 0.0;
				gint _tmp159_ = 0;
				Page* _tmp160_ = NULL;
				gint _tmp161_ = 0;
				gint _tmp162_ = 0;
				gint depth = 0;
				gchar* color_space = NULL;
				gchar* _tmp163_ = NULL;
				gchar* filter = NULL;
				gchar* width_buffer = NULL;
				gchar* _tmp164_ = NULL;
				gint width_buffer_length1 = 0;
				gint _width_buffer_size_ = 0;
				gchar* height_buffer = NULL;
				gchar* _tmp165_ = NULL;
				gint height_buffer_length1 = 0;
				gint _height_buffer_size_ = 0;
				guint8* data = NULL;
				gint data_length1 = 0;
				gint _data_size_ = 0;
				Page* _tmp166_ = NULL;
				gboolean _tmp167_ = FALSE;
				gboolean _tmp168_ = FALSE;
				guint8* compressed_data = NULL;
				guint8* _tmp322_ = NULL;
				gint _tmp322__length1 = 0;
				gint _tmp323_ = 0;
				guint8* _tmp324_ = NULL;
				gint compressed_data_length1 = 0;
				gint _compressed_data_size_ = 0;
				guint8* _tmp325_ = NULL;
				gint _tmp325__length1 = 0;
				PDFWriter* _tmp343_ = NULL;
				PDFWriter* _tmp344_ = NULL;
				guint* _tmp345_ = NULL;
				gint _tmp345__length1 = 0;
				gint _tmp346_ = 0;
				guint _tmp347_ = 0U;
				PDFWriter* _tmp348_ = NULL;
				guint* _tmp349_ = NULL;
				gint _tmp349__length1 = 0;
				gint _tmp350_ = 0;
				guint _tmp351_ = 0U;
				gchar* _tmp352_ = NULL;
				gchar* _tmp353_ = NULL;
				PDFWriter* _tmp354_ = NULL;
				PDFWriter* _tmp355_ = NULL;
				PDFWriter* _tmp356_ = NULL;
				guint _tmp357_ = 0U;
				gchar* _tmp358_ = NULL;
				gchar* _tmp359_ = NULL;
				PDFWriter* _tmp360_ = NULL;
				gint _tmp361_ = 0;
				guint* _tmp362_ = NULL;
				gint _tmp362__length1 = 0;
				gint _tmp363_ = 0;
				guint _tmp364_ = 0U;
				gchar* _tmp365_ = NULL;
				gchar* _tmp366_ = NULL;
				PDFWriter* _tmp367_ = NULL;
				gdouble _tmp368_ = 0.0;
				gchar* _tmp369_ = NULL;
				gint _tmp369__length1 = 0;
				const gchar* _tmp370_ = NULL;
				gdouble _tmp371_ = 0.0;
				gchar* _tmp372_ = NULL;
				gint _tmp372__length1 = 0;
				const gchar* _tmp373_ = NULL;
				gchar* _tmp374_ = NULL;
				gchar* _tmp375_ = NULL;
				PDFWriter* _tmp376_ = NULL;
				guint* _tmp377_ = NULL;
				gint _tmp377__length1 = 0;
				gint _tmp378_ = 0;
				guint _tmp379_ = 0U;
				gchar* _tmp380_ = NULL;
				gchar* _tmp381_ = NULL;
				PDFWriter* _tmp382_ = NULL;
				PDFWriter* _tmp383_ = NULL;
				PDFWriter* _tmp384_ = NULL;
				PDFWriter* _tmp385_ = NULL;
				guint* _tmp386_ = NULL;
				gint _tmp386__length1 = 0;
				gint _tmp387_ = 0;
				guint _tmp388_ = 0U;
				PDFWriter* _tmp389_ = NULL;
				guint* _tmp390_ = NULL;
				gint _tmp390__length1 = 0;
				gint _tmp391_ = 0;
				guint _tmp392_ = 0U;
				gchar* _tmp393_ = NULL;
				gchar* _tmp394_ = NULL;
				PDFWriter* _tmp395_ = NULL;
				PDFWriter* _tmp396_ = NULL;
				PDFWriter* _tmp397_ = NULL;
				PDFWriter* _tmp398_ = NULL;
				gint _tmp399_ = 0;
				gchar* _tmp400_ = NULL;
				gchar* _tmp401_ = NULL;
				PDFWriter* _tmp402_ = NULL;
				gint _tmp403_ = 0;
				gchar* _tmp404_ = NULL;
				gchar* _tmp405_ = NULL;
				PDFWriter* _tmp406_ = NULL;
				const gchar* _tmp407_ = NULL;
				gchar* _tmp408_ = NULL;
				gchar* _tmp409_ = NULL;
				PDFWriter* _tmp410_ = NULL;
				gint _tmp411_ = 0;
				gchar* _tmp412_ = NULL;
				gchar* _tmp413_ = NULL;
				PDFWriter* _tmp414_ = NULL;
				guint8* _tmp415_ = NULL;
				gint _tmp415__length1 = 0;
				gchar* _tmp416_ = NULL;
				gchar* _tmp417_ = NULL;
				const gchar* _tmp418_ = NULL;
				PDFWriter* _tmp423_ = NULL;
				PDFWriter* _tmp424_ = NULL;
				PDFWriter* _tmp425_ = NULL;
				guint8* _tmp426_ = NULL;
				gint _tmp426__length1 = 0;
				PDFWriter* _tmp427_ = NULL;
				PDFWriter* _tmp428_ = NULL;
				PDFWriter* _tmp429_ = NULL;
				PDFWriter* _tmp430_ = NULL;
				PDFWriter* _tmp431_ = NULL;
				guint _tmp432_ = 0U;
				PDFWriter* _tmp433_ = NULL;
				guint _tmp434_ = 0U;
				gchar* _tmp435_ = NULL;
				gchar* _tmp436_ = NULL;
				PDFWriter* _tmp437_ = NULL;
				PDFWriter* _tmp438_ = NULL;
				PDFWriter* _tmp439_ = NULL;
				PDFWriter* _tmp440_ = NULL;
				gchar* command = NULL;
				gdouble _tmp441_ = 0.0;
				gchar* _tmp442_ = NULL;
				gint _tmp442__length1 = 0;
				const gchar* _tmp443_ = NULL;
				gdouble _tmp444_ = 0.0;
				gchar* _tmp445_ = NULL;
				gint _tmp445__length1 = 0;
				const gchar* _tmp446_ = NULL;
				gint _tmp447_ = 0;
				gchar* _tmp448_ = NULL;
				PDFWriter* _tmp449_ = NULL;
				PDFWriter* _tmp450_ = NULL;
				guint* _tmp451_ = NULL;
				gint _tmp451__length1 = 0;
				gint _tmp452_ = 0;
				guint _tmp453_ = 0U;
				PDFWriter* _tmp454_ = NULL;
				guint* _tmp455_ = NULL;
				gint _tmp455__length1 = 0;
				gint _tmp456_ = 0;
				guint _tmp457_ = 0U;
				gchar* _tmp458_ = NULL;
				gchar* _tmp459_ = NULL;
				PDFWriter* _tmp460_ = NULL;
				PDFWriter* _tmp461_ = NULL;
				const gchar* _tmp462_ = NULL;
				gint _tmp463_ = 0;
				gint _tmp464_ = 0;
				gchar* _tmp465_ = NULL;
				gchar* _tmp466_ = NULL;
				PDFWriter* _tmp467_ = NULL;
				PDFWriter* _tmp468_ = NULL;
				PDFWriter* _tmp469_ = NULL;
				const gchar* _tmp470_ = NULL;
				PDFWriter* _tmp471_ = NULL;
				PDFWriter* _tmp472_ = NULL;
				PDFWriter* _tmp473_ = NULL;
				gint _tmp474_ = 0;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!_tmp138_) {
#line 2942 "book.c"
					gint _tmp139_ = 0;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp139_ = i;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					i = _tmp139_ + 1;
#line 2948 "book.c"
				}
#line 348 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp138_ = FALSE;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp140_ = i;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp141_ = book_get_n_pages (self);
#line 348 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp142_ = _tmp141_;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!(((guint) _tmp140_) < _tmp142_)) {
#line 348 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					break;
#line 2962 "book.c"
				}
#line 350 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp143_ = i;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp144_ = book_get_page (self, _tmp143_);
#line 350 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				page = _tmp144_;
#line 351 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp145_ = page;
#line 351 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp146_ = page_get_image (_tmp145_, TRUE);
#line 351 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				image = _tmp146_;
#line 352 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp147_ = image;
#line 352 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp148_ = gdk_pixbuf_get_width (_tmp147_);
#line 352 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp149_ = _tmp148_;
#line 352 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				width = _tmp149_;
#line 353 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp150_ = image;
#line 353 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp151_ = gdk_pixbuf_get_height (_tmp150_);
#line 353 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp152_ = _tmp151_;
#line 353 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				height = _tmp152_;
#line 354 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp153_ = image;
#line 354 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp154_ = gdk_pixbuf_get_pixels (_tmp153_);
#line 354 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pixels = _tmp154_;
#line 354 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pixels_length1 = -1;
#line 354 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_pixels_size_ = pixels_length1;
#line 355 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp155_ = width;
#line 355 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp156_ = page;
#line 355 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp157_ = page_get_dpi (_tmp156_);
#line 355 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp158_ = _tmp157_;
#line 355 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				page_width = (_tmp155_ * 72.0) / _tmp158_;
#line 356 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp159_ = height;
#line 356 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp160_ = page;
#line 356 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp161_ = page_get_dpi (_tmp160_);
#line 356 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp162_ = _tmp161_;
#line 356 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				page_height = (_tmp159_ * 72.0) / _tmp162_;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				depth = 8;
#line 359 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp163_ = g_strdup ("DeviceRGB");
#line 359 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				color_space = _tmp163_;
#line 360 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				filter = NULL;
#line 361 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp164_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
#line 361 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				width_buffer = _tmp164_;
#line 361 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				width_buffer_length1 = G_ASCII_DTOSTR_BUF_SIZE;
#line 361 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_width_buffer_size_ = width_buffer_length1;
#line 362 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp165_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
#line 362 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				height_buffer = _tmp165_;
#line 362 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				height_buffer_length1 = G_ASCII_DTOSTR_BUF_SIZE;
#line 362 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_height_buffer_size_ = height_buffer_length1;
#line 364 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp166_ = page;
#line 364 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp167_ = page_get_is_color (_tmp166_);
#line 364 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp168_ = _tmp167_;
#line 364 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (_tmp168_) {
#line 3054 "book.c"
					gchar* _tmp169_ = NULL;
					gint data_length = 0;
					gint _tmp170_ = 0;
					gint _tmp171_ = 0;
					gint _tmp172_ = 0;
					guint8* _tmp173_ = NULL;
#line 366 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					depth = 8;
#line 367 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp169_ = g_strdup ("DeviceRGB");
#line 367 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_g_free0 (color_space);
#line 367 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					color_space = _tmp169_;
#line 368 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp170_ = height;
#line 368 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp171_ = width;
#line 368 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					data_length = (_tmp170_ * _tmp171_) * 3;
#line 369 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp172_ = data_length;
#line 369 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp173_ = g_new0 (guint8, _tmp172_);
#line 369 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					data = (g_free (data), NULL);
#line 369 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					data = _tmp173_;
#line 369 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					data_length1 = _tmp172_;
#line 369 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_data_size_ = data_length1;
#line 3087 "book.c"
					{
						gint row = 0;
#line 370 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						row = 0;
#line 3092 "book.c"
						{
							gboolean _tmp174_ = FALSE;
#line 370 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp174_ = TRUE;
#line 370 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							while (TRUE) {
#line 3099 "book.c"
								gint _tmp176_ = 0;
								gint _tmp177_ = 0;
								gint in_offset = 0;
								gint _tmp178_ = 0;
								GdkPixbuf* _tmp179_ = NULL;
								gint _tmp180_ = 0;
								gint _tmp181_ = 0;
								gint out_offset = 0;
								gint _tmp182_ = 0;
								gint _tmp183_ = 0;
#line 370 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								if (!_tmp174_) {
#line 3112 "book.c"
									gint _tmp175_ = 0;
#line 370 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									_tmp175_ = row;
#line 370 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									row = _tmp175_ + 1;
#line 3118 "book.c"
								}
#line 370 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								_tmp174_ = FALSE;
#line 370 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								_tmp176_ = row;
#line 370 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								_tmp177_ = height;
#line 370 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								if (!(_tmp176_ < _tmp177_)) {
#line 370 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									break;
#line 3130 "book.c"
								}
#line 372 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								_tmp178_ = row;
#line 372 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								_tmp179_ = image;
#line 372 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								_tmp180_ = gdk_pixbuf_get_rowstride (_tmp179_);
#line 372 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								_tmp181_ = _tmp180_;
#line 372 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								in_offset = _tmp178_ * _tmp181_;
#line 373 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								_tmp182_ = row;
#line 373 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								_tmp183_ = width;
#line 373 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								out_offset = (_tmp182_ * _tmp183_) * 3;
#line 3148 "book.c"
								{
									gint x = 0;
#line 374 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									x = 0;
#line 3153 "book.c"
									{
										gboolean _tmp184_ = FALSE;
#line 374 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp184_ = TRUE;
#line 374 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										while (TRUE) {
#line 3160 "book.c"
											gint _tmp186_ = 0;
											gint _tmp187_ = 0;
											gint in_o = 0;
											gint _tmp188_ = 0;
											gint _tmp189_ = 0;
											gint out_o = 0;
											gint _tmp190_ = 0;
											gint _tmp191_ = 0;
											guint8* _tmp192_ = NULL;
											gint _tmp192__length1 = 0;
											gint _tmp193_ = 0;
											guint8* _tmp194_ = NULL;
											gint _tmp194__length1 = 0;
											gint _tmp195_ = 0;
											guint8 _tmp196_ = 0U;
											guint8 _tmp197_ = 0U;
											guint8* _tmp198_ = NULL;
											gint _tmp198__length1 = 0;
											gint _tmp199_ = 0;
											guint8* _tmp200_ = NULL;
											gint _tmp200__length1 = 0;
											gint _tmp201_ = 0;
											guint8 _tmp202_ = 0U;
											guint8 _tmp203_ = 0U;
											guint8* _tmp204_ = NULL;
											gint _tmp204__length1 = 0;
											gint _tmp205_ = 0;
											guint8* _tmp206_ = NULL;
											gint _tmp206__length1 = 0;
											gint _tmp207_ = 0;
											guint8 _tmp208_ = 0U;
											guint8 _tmp209_ = 0U;
#line 374 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											if (!_tmp184_) {
#line 3195 "book.c"
												gint _tmp185_ = 0;
#line 374 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp185_ = x;
#line 374 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												x = _tmp185_ + 1;
#line 3201 "book.c"
											}
#line 374 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp184_ = FALSE;
#line 374 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp186_ = x;
#line 374 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp187_ = width;
#line 374 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											if (!(_tmp186_ < _tmp187_)) {
#line 374 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												break;
#line 3213 "book.c"
											}
#line 376 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp188_ = in_offset;
#line 376 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp189_ = x;
#line 376 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											in_o = _tmp188_ + (_tmp189_ * 3);
#line 377 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp190_ = out_offset;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp191_ = x;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											out_o = _tmp190_ + (_tmp191_ * 3);
#line 379 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp192_ = data;
#line 379 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp192__length1 = data_length1;
#line 379 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp193_ = out_o;
#line 379 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp194_ = pixels;
#line 379 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp194__length1 = pixels_length1;
#line 379 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp195_ = in_o;
#line 379 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp196_ = _tmp194_[_tmp195_];
#line 379 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp192_[_tmp193_] = _tmp196_;
#line 379 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp197_ = _tmp192_[_tmp193_];
#line 380 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp198_ = data;
#line 380 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp198__length1 = data_length1;
#line 380 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp199_ = out_o;
#line 380 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp200_ = pixels;
#line 380 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp200__length1 = pixels_length1;
#line 380 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp201_ = in_o;
#line 380 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp202_ = _tmp200_[_tmp201_ + 1];
#line 380 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp198_[_tmp199_ + 1] = _tmp202_;
#line 380 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp203_ = _tmp198_[_tmp199_ + 1];
#line 381 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp204_ = data;
#line 381 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp204__length1 = data_length1;
#line 381 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp205_ = out_o;
#line 381 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp206_ = pixels;
#line 381 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp206__length1 = pixels_length1;
#line 381 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp207_ = in_o;
#line 381 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp208_ = _tmp206_[_tmp207_ + 2];
#line 381 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp204_[_tmp205_ + 2] = _tmp208_;
#line 381 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp209_ = _tmp204_[_tmp205_ + 2];
#line 3281 "book.c"
										}
									}
								}
							}
						}
					}
				} else {
					Page* _tmp210_ = NULL;
					gint _tmp211_ = 0;
					gint _tmp212_ = 0;
#line 385 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp210_ = page;
#line 385 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp211_ = page_get_depth (_tmp210_);
#line 385 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp212_ = _tmp211_;
#line 385 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					if (_tmp212_ == 2) {
#line 3300 "book.c"
						gint shift_count = 0;
						gchar* _tmp213_ = NULL;
						gint data_length = 0;
						gint _tmp214_ = 0;
						gint _tmp215_ = 0;
						gint _tmp216_ = 0;
						guint8* _tmp217_ = NULL;
						gint offset = 0;
#line 387 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						shift_count = 6;
#line 388 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						depth = 2;
#line 389 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp213_ = g_strdup ("DeviceGray");
#line 389 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_g_free0 (color_space);
#line 389 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						color_space = _tmp213_;
#line 390 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp214_ = height;
#line 390 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp215_ = width;
#line 390 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						data_length = _tmp214_ * (((_tmp215_ * 2) + 7) / 8);
#line 391 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp216_ = data_length;
#line 391 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp217_ = g_new0 (guint8, _tmp216_);
#line 391 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						data = (g_free (data), NULL);
#line 391 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						data = _tmp217_;
#line 391 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						data_length1 = _tmp216_;
#line 391 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_data_size_ = data_length1;
#line 392 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						offset = 0;
#line 3339 "book.c"
						{
							gint row = 0;
#line 393 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							row = 0;
#line 3344 "book.c"
							{
								gboolean _tmp218_ = FALSE;
#line 393 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								_tmp218_ = TRUE;
#line 393 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								while (TRUE) {
#line 3351 "book.c"
									gint _tmp220_ = 0;
									gint _tmp221_ = 0;
									gint _tmp222_ = 0;
									gint in_offset = 0;
									gint _tmp224_ = 0;
									GdkPixbuf* _tmp225_ = NULL;
									gint _tmp226_ = 0;
									gint _tmp227_ = 0;
#line 393 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									if (!_tmp218_) {
#line 3362 "book.c"
										gint _tmp219_ = 0;
#line 393 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp219_ = row;
#line 393 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										row = _tmp219_ + 1;
#line 3368 "book.c"
									}
#line 393 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									_tmp218_ = FALSE;
#line 393 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									_tmp220_ = row;
#line 393 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									_tmp221_ = height;
#line 393 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									if (!(_tmp220_ < _tmp221_)) {
#line 393 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										break;
#line 3380 "book.c"
									}
#line 396 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									_tmp222_ = shift_count;
#line 396 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									if (_tmp222_ != 6) {
#line 3386 "book.c"
										gint _tmp223_ = 0;
#line 398 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp223_ = offset;
#line 398 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										offset = _tmp223_ + 1;
#line 399 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										shift_count = 6;
#line 3394 "book.c"
									}
#line 402 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									_tmp224_ = row;
#line 402 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									_tmp225_ = image;
#line 402 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									_tmp226_ = gdk_pixbuf_get_rowstride (_tmp225_);
#line 402 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									_tmp227_ = _tmp226_;
#line 402 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									in_offset = _tmp224_ * _tmp227_;
#line 3406 "book.c"
									{
										gint x = 0;
#line 403 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										x = 0;
#line 3411 "book.c"
										{
											gboolean _tmp228_ = FALSE;
#line 403 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp228_ = TRUE;
#line 403 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											while (TRUE) {
#line 3418 "book.c"
												gint _tmp230_ = 0;
												gint _tmp231_ = 0;
												gint _tmp232_ = 0;
												guint8 p = 0U;
												guint8* _tmp236_ = NULL;
												gint _tmp236__length1 = 0;
												gint _tmp237_ = 0;
												gint _tmp238_ = 0;
												guint8 _tmp239_ = 0U;
												guint8 _tmp240_ = 0U;
												gint _tmp255_ = 0;
#line 403 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												if (!_tmp228_) {
#line 3432 "book.c"
													gint _tmp229_ = 0;
#line 403 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp229_ = x;
#line 403 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													x = _tmp229_ + 1;
#line 3438 "book.c"
												}
#line 403 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp228_ = FALSE;
#line 403 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp230_ = x;
#line 403 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp231_ = width;
#line 403 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												if (!(_tmp230_ < _tmp231_)) {
#line 403 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													break;
#line 3450 "book.c"
												}
#line 406 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp232_ = shift_count;
#line 406 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												if (_tmp232_ == 6) {
#line 3456 "book.c"
													guint8* _tmp233_ = NULL;
													gint _tmp233__length1 = 0;
													gint _tmp234_ = 0;
													guint8 _tmp235_ = 0U;
#line 407 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp233_ = data;
#line 407 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp233__length1 = data_length1;
#line 407 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp234_ = offset;
#line 407 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp233_[_tmp234_] = (guint8) 0;
#line 407 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp235_ = _tmp233_[_tmp234_];
#line 3471 "book.c"
												}
#line 410 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp236_ = pixels;
#line 410 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp236__length1 = pixels_length1;
#line 410 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp237_ = in_offset;
#line 410 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp238_ = x;
#line 410 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp239_ = _tmp236_[_tmp237_ + (_tmp238_ * 3)];
#line 410 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												p = _tmp239_;
#line 411 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp240_ = p;
#line 411 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												if (((gint) _tmp240_) >= 192) {
#line 3489 "book.c"
													guint8* _tmp241_ = NULL;
													gint _tmp241__length1 = 0;
													gint _tmp242_ = 0;
													gint _tmp243_ = 0;
													guint8 _tmp244_ = 0U;
#line 412 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp241_ = data;
#line 412 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp241__length1 = data_length1;
#line 412 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp242_ = offset;
#line 412 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp243_ = shift_count;
#line 412 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp241_[_tmp242_] |= (guint8) (3 << _tmp243_);
#line 412 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp244_ = _tmp241_[_tmp242_];
#line 3507 "book.c"
												} else {
													guint8 _tmp245_ = 0U;
#line 413 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp245_ = p;
#line 413 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													if (((gint) _tmp245_) >= 128) {
#line 3514 "book.c"
														guint8* _tmp246_ = NULL;
														gint _tmp246__length1 = 0;
														gint _tmp247_ = 0;
														gint _tmp248_ = 0;
														guint8 _tmp249_ = 0U;
#line 414 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp246_ = data;
#line 414 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp246__length1 = data_length1;
#line 414 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp247_ = offset;
#line 414 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp248_ = shift_count;
#line 414 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp246_[_tmp247_] |= (guint8) (2 << _tmp248_);
#line 414 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp249_ = _tmp246_[_tmp247_];
#line 3532 "book.c"
													} else {
														guint8 _tmp250_ = 0U;
#line 415 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp250_ = p;
#line 415 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														if (((gint) _tmp250_) >= 64) {
#line 3539 "book.c"
															guint8* _tmp251_ = NULL;
															gint _tmp251__length1 = 0;
															gint _tmp252_ = 0;
															gint _tmp253_ = 0;
															guint8 _tmp254_ = 0U;
#line 416 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
															_tmp251_ = data;
#line 416 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
															_tmp251__length1 = data_length1;
#line 416 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
															_tmp252_ = offset;
#line 416 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
															_tmp253_ = shift_count;
#line 416 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
															_tmp251_[_tmp252_] |= (guint8) (1 << _tmp253_);
#line 416 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
															_tmp254_ = _tmp251_[_tmp252_];
#line 3557 "book.c"
														}
													}
												}
#line 419 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp255_ = shift_count;
#line 419 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												if (_tmp255_ == 0) {
#line 3565 "book.c"
													gint _tmp256_ = 0;
#line 421 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp256_ = offset;
#line 421 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													offset = _tmp256_ + 1;
#line 422 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													shift_count = 6;
#line 3573 "book.c"
												} else {
													gint _tmp257_ = 0;
#line 425 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp257_ = shift_count;
#line 425 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													shift_count = _tmp257_ - 2;
#line 3580 "book.c"
												}
											}
										}
									}
								}
							}
						}
					} else {
						Page* _tmp258_ = NULL;
						gint _tmp259_ = 0;
						gint _tmp260_ = 0;
#line 429 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp258_ = page;
#line 429 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp259_ = page_get_depth (_tmp258_);
#line 429 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp260_ = _tmp259_;
#line 429 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						if (_tmp260_ == 1) {
#line 3600 "book.c"
							gint mask = 0;
							gchar* _tmp261_ = NULL;
							gint data_length = 0;
							gint _tmp262_ = 0;
							gint _tmp263_ = 0;
							gint _tmp264_ = 0;
							guint8* _tmp265_ = NULL;
							gint offset = 0;
#line 431 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							mask = 0x80;
#line 433 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							depth = 1;
#line 434 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp261_ = g_strdup ("DeviceGray");
#line 434 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_g_free0 (color_space);
#line 434 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							color_space = _tmp261_;
#line 435 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp262_ = height;
#line 435 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp263_ = width;
#line 435 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							data_length = _tmp262_ * ((_tmp263_ + 7) / 8);
#line 436 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp264_ = data_length;
#line 436 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp265_ = g_new0 (guint8, _tmp264_);
#line 436 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							data = (g_free (data), NULL);
#line 436 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							data = _tmp265_;
#line 436 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							data_length1 = _tmp264_;
#line 436 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_data_size_ = data_length1;
#line 437 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							offset = 0;
#line 3639 "book.c"
							{
								gint row = 0;
#line 438 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								row = 0;
#line 3644 "book.c"
								{
									gboolean _tmp266_ = FALSE;
#line 438 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									_tmp266_ = TRUE;
#line 438 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									while (TRUE) {
#line 3651 "book.c"
										gint _tmp268_ = 0;
										gint _tmp269_ = 0;
										gint _tmp270_ = 0;
										gint in_offset = 0;
										gint _tmp272_ = 0;
										GdkPixbuf* _tmp273_ = NULL;
										gint _tmp274_ = 0;
										gint _tmp275_ = 0;
#line 438 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										if (!_tmp266_) {
#line 3662 "book.c"
											gint _tmp267_ = 0;
#line 438 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp267_ = row;
#line 438 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											row = _tmp267_ + 1;
#line 3668 "book.c"
										}
#line 438 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp266_ = FALSE;
#line 438 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp268_ = row;
#line 438 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp269_ = height;
#line 438 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										if (!(_tmp268_ < _tmp269_)) {
#line 438 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											break;
#line 3680 "book.c"
										}
#line 441 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp270_ = mask;
#line 441 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										if (_tmp270_ != 0x80) {
#line 3686 "book.c"
											gint _tmp271_ = 0;
#line 443 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp271_ = offset;
#line 443 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											offset = _tmp271_ + 1;
#line 444 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											mask = 0x80;
#line 3694 "book.c"
										}
#line 447 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp272_ = row;
#line 447 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp273_ = image;
#line 447 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp274_ = gdk_pixbuf_get_rowstride (_tmp273_);
#line 447 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp275_ = _tmp274_;
#line 447 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										in_offset = _tmp272_ * _tmp275_;
#line 3706 "book.c"
										{
											gint x = 0;
#line 448 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											x = 0;
#line 3711 "book.c"
											{
												gboolean _tmp276_ = FALSE;
#line 448 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp276_ = TRUE;
#line 448 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												while (TRUE) {
#line 3718 "book.c"
													gint _tmp278_ = 0;
													gint _tmp279_ = 0;
													gint _tmp280_ = 0;
													guint8* _tmp284_ = NULL;
													gint _tmp284__length1 = 0;
													gint _tmp285_ = 0;
													gint _tmp286_ = 0;
													guint8 _tmp287_ = 0U;
													gint _tmp292_ = 0;
													gint _tmp293_ = 0;
#line 448 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													if (!_tmp276_) {
#line 3731 "book.c"
														gint _tmp277_ = 0;
#line 448 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp277_ = x;
#line 448 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														x = _tmp277_ + 1;
#line 3737 "book.c"
													}
#line 448 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp276_ = FALSE;
#line 448 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp278_ = x;
#line 448 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp279_ = width;
#line 448 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													if (!(_tmp278_ < _tmp279_)) {
#line 448 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														break;
#line 3749 "book.c"
													}
#line 451 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp280_ = mask;
#line 451 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													if (_tmp280_ == 0x80) {
#line 3755 "book.c"
														guint8* _tmp281_ = NULL;
														gint _tmp281__length1 = 0;
														gint _tmp282_ = 0;
														guint8 _tmp283_ = 0U;
#line 452 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp281_ = data;
#line 452 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp281__length1 = data_length1;
#line 452 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp282_ = offset;
#line 452 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp281_[_tmp282_] = (guint8) 0;
#line 452 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp283_ = _tmp281_[_tmp282_];
#line 3770 "book.c"
													}
#line 455 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp284_ = pixels;
#line 455 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp284__length1 = pixels_length1;
#line 455 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp285_ = in_offset;
#line 455 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp286_ = x;
#line 455 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp287_ = _tmp284_[_tmp285_ + (_tmp286_ * 3)];
#line 455 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													if (((gint) _tmp287_) != 0) {
#line 3784 "book.c"
														guint8* _tmp288_ = NULL;
														gint _tmp288__length1 = 0;
														gint _tmp289_ = 0;
														gint _tmp290_ = 0;
														guint8 _tmp291_ = 0U;
#line 456 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp288_ = data;
#line 456 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp288__length1 = data_length1;
#line 456 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp289_ = offset;
#line 456 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp290_ = mask;
#line 456 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp288_[_tmp289_] |= (guint8) _tmp290_;
#line 456 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp291_ = _tmp288_[_tmp289_];
#line 3802 "book.c"
													}
#line 459 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp292_ = mask;
#line 459 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													mask = _tmp292_ >> 1;
#line 460 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp293_ = mask;
#line 460 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													if (_tmp293_ == 0) {
#line 3812 "book.c"
														gint _tmp294_ = 0;
#line 462 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp294_ = offset;
#line 462 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														offset = _tmp294_ + 1;
#line 463 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														mask = 0x80;
#line 3820 "book.c"
													}
												}
											}
										}
									}
								}
							}
						} else {
							gchar* _tmp295_ = NULL;
							gint data_length = 0;
							gint _tmp296_ = 0;
							gint _tmp297_ = 0;
							gint _tmp298_ = 0;
							guint8* _tmp299_ = NULL;
#line 470 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							depth = 8;
#line 471 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp295_ = g_strdup ("DeviceGray");
#line 471 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_g_free0 (color_space);
#line 471 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							color_space = _tmp295_;
#line 472 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp296_ = height;
#line 472 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp297_ = width;
#line 472 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							data_length = _tmp296_ * _tmp297_;
#line 473 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp298_ = data_length;
#line 473 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp299_ = g_new0 (guint8, _tmp298_);
#line 473 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							data = (g_free (data), NULL);
#line 473 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							data = _tmp299_;
#line 473 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							data_length1 = _tmp298_;
#line 473 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_data_size_ = data_length1;
#line 3861 "book.c"
							{
								gint row = 0;
#line 474 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								row = 0;
#line 3866 "book.c"
								{
									gboolean _tmp300_ = FALSE;
#line 474 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									_tmp300_ = TRUE;
#line 474 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									while (TRUE) {
#line 3873 "book.c"
										gint _tmp302_ = 0;
										gint _tmp303_ = 0;
										gint in_offset = 0;
										gint _tmp304_ = 0;
										GdkPixbuf* _tmp305_ = NULL;
										gint _tmp306_ = 0;
										gint _tmp307_ = 0;
										gint out_offset = 0;
										gint _tmp308_ = 0;
										gint _tmp309_ = 0;
#line 474 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										if (!_tmp300_) {
#line 3886 "book.c"
											gint _tmp301_ = 0;
#line 474 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp301_ = row;
#line 474 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											row = _tmp301_ + 1;
#line 3892 "book.c"
										}
#line 474 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp300_ = FALSE;
#line 474 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp302_ = row;
#line 474 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp303_ = height;
#line 474 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										if (!(_tmp302_ < _tmp303_)) {
#line 474 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											break;
#line 3904 "book.c"
										}
#line 476 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp304_ = row;
#line 476 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp305_ = image;
#line 476 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp306_ = gdk_pixbuf_get_rowstride (_tmp305_);
#line 476 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp307_ = _tmp306_;
#line 476 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										in_offset = _tmp304_ * _tmp307_;
#line 477 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp308_ = row;
#line 477 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp309_ = width;
#line 477 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										out_offset = _tmp308_ * _tmp309_;
#line 3922 "book.c"
										{
											gint x = 0;
#line 478 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											x = 0;
#line 3927 "book.c"
											{
												gboolean _tmp310_ = FALSE;
#line 478 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp310_ = TRUE;
#line 478 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												while (TRUE) {
#line 3934 "book.c"
													gint _tmp312_ = 0;
													gint _tmp313_ = 0;
													guint8* _tmp314_ = NULL;
													gint _tmp314__length1 = 0;
													gint _tmp315_ = 0;
													gint _tmp316_ = 0;
													guint8* _tmp317_ = NULL;
													gint _tmp317__length1 = 0;
													gint _tmp318_ = 0;
													gint _tmp319_ = 0;
													guint8 _tmp320_ = 0U;
													guint8 _tmp321_ = 0U;
#line 478 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													if (!_tmp310_) {
#line 3949 "book.c"
														gint _tmp311_ = 0;
#line 478 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp311_ = x;
#line 478 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														x = _tmp311_ + 1;
#line 3955 "book.c"
													}
#line 478 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp310_ = FALSE;
#line 478 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp312_ = x;
#line 478 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp313_ = width;
#line 478 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													if (!(_tmp312_ < _tmp313_)) {
#line 478 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														break;
#line 3967 "book.c"
													}
#line 479 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp314_ = data;
#line 479 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp314__length1 = data_length1;
#line 479 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp315_ = out_offset;
#line 479 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp316_ = x;
#line 479 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp317_ = pixels;
#line 479 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp317__length1 = pixels_length1;
#line 479 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp318_ = in_offset;
#line 479 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp319_ = x;
#line 479 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp320_ = _tmp317_[_tmp318_ + (_tmp319_ * 3)];
#line 479 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp314_[_tmp315_ + _tmp316_] = _tmp320_;
#line 479 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp321_ = _tmp314_[_tmp315_ + _tmp316_];
#line 3991 "book.c"
												}
											}
										}
									}
								}
							}
						}
					}
				}
#line 484 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp322_ = data;
#line 484 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp322__length1 = data_length1;
#line 484 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp324_ = book_compress_zlib (self, _tmp322_, _tmp322__length1, &_tmp323_);
#line 484 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				compressed_data = _tmp324_;
#line 484 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				compressed_data_length1 = _tmp323_;
#line 484 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_compressed_data_size_ = compressed_data_length1;
#line 485 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp325_ = compressed_data;
#line 485 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp325__length1 = compressed_data_length1;
#line 485 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (_tmp325_ != NULL) {
#line 4019 "book.c"
					gint _tmp326_ = 0;
					const gchar* _tmp339_ = NULL;
#line 488 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp326_ = depth;
#line 488 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					if (_tmp326_ > 1) {
#line 4026 "book.c"
						guint8* jpeg_data = NULL;
						GdkPixbuf* _tmp327_ = NULL;
						gint _tmp328_ = 0;
						Page* _tmp329_ = NULL;
						gint _tmp330_ = 0;
						gint _tmp331_ = 0;
						gint _tmp332_ = 0;
						guint8* _tmp333_ = NULL;
						gint jpeg_data_length1 = 0;
						gint _jpeg_data_size_ = 0;
						guint8* _tmp334_ = NULL;
						gint _tmp334__length1 = 0;
						guint8* _tmp335_ = NULL;
						gint _tmp335__length1 = 0;
#line 490 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp327_ = image;
#line 490 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp328_ = quality;
#line 490 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp329_ = page;
#line 490 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp330_ = page_get_dpi (_tmp329_);
#line 490 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp331_ = _tmp330_;
#line 490 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp333_ = book_compress_jpeg (self, _tmp327_, _tmp328_, _tmp331_, &_tmp332_);
#line 490 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						jpeg_data = _tmp333_;
#line 490 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						jpeg_data_length1 = _tmp332_;
#line 490 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_jpeg_data_size_ = jpeg_data_length1;
#line 491 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp334_ = jpeg_data;
#line 491 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp334__length1 = jpeg_data_length1;
#line 491 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp335_ = compressed_data;
#line 491 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp335__length1 = compressed_data_length1;
#line 491 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						if (_tmp334__length1 < _tmp335__length1) {
#line 4069 "book.c"
							gchar* _tmp336_ = NULL;
							guint8* _tmp337_ = NULL;
							gint _tmp337__length1 = 0;
							guint8* _tmp338_ = NULL;
							gint _tmp338__length1 = 0;
#line 493 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp336_ = g_strdup ("DCTDecode");
#line 493 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_g_free0 (filter);
#line 493 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							filter = _tmp336_;
#line 494 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp337_ = jpeg_data;
#line 494 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp337__length1 = jpeg_data_length1;
#line 494 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp338_ = (_tmp337_ != NULL) ? _vala_array_dup1 (_tmp337_, _tmp337__length1) : ((gpointer) _tmp337_);
#line 494 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp338__length1 = _tmp337__length1;
#line 494 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							data = (g_free (data), NULL);
#line 494 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							data = _tmp338_;
#line 494 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							data_length1 = _tmp338__length1;
#line 494 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_data_size_ = data_length1;
#line 4097 "book.c"
						}
#line 488 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						jpeg_data = (g_free (jpeg_data), NULL);
#line 4101 "book.c"
					}
#line 498 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp339_ = filter;
#line 498 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					if (_tmp339_ == NULL) {
#line 4107 "book.c"
						gchar* _tmp340_ = NULL;
						guint8* _tmp341_ = NULL;
						gint _tmp341__length1 = 0;
						guint8* _tmp342_ = NULL;
						gint _tmp342__length1 = 0;
#line 500 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp340_ = g_strdup ("FlateDecode");
#line 500 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_g_free0 (filter);
#line 500 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						filter = _tmp340_;
#line 501 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp341_ = compressed_data;
#line 501 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp341__length1 = compressed_data_length1;
#line 501 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp342_ = (_tmp341_ != NULL) ? _vala_array_dup2 (_tmp341_, _tmp341__length1) : ((gpointer) _tmp341_);
#line 501 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp342__length1 = _tmp341__length1;
#line 501 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						data = (g_free (data), NULL);
#line 501 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						data = _tmp342_;
#line 501 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						data_length1 = _tmp342__length1;
#line 501 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_data_size_ = data_length1;
#line 4135 "book.c"
					}
				}
#line 506 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp343_ = writer;
#line 506 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp343_, "\n");
#line 507 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp344_ = writer;
#line 507 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp345_ = page_numbers;
#line 507 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp345__length1 = page_numbers_length1;
#line 507 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp346_ = i;
#line 507 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp347_ = _tmp345_[_tmp346_];
#line 507 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_start_object (_tmp344_, _tmp347_);
#line 508 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp348_ = writer;
#line 508 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp349_ = page_numbers;
#line 508 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp349__length1 = page_numbers_length1;
#line 508 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp350_ = i;
#line 508 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp351_ = _tmp349_[_tmp350_];
#line 508 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp352_ = g_strdup_printf ("%u 0 obj\n", _tmp351_);
#line 508 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp353_ = _tmp352_;
#line 508 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp348_, _tmp353_);
#line 508 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp353_);
#line 509 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp354_ = writer;
#line 509 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp354_, "<<\n");
#line 510 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp355_ = writer;
#line 510 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp355_, "/Type /Page\n");
#line 511 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp356_ = writer;
#line 511 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp357_ = pages_number;
#line 511 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp358_ = g_strdup_printf ("/Parent %u 0 R\n", _tmp357_);
#line 511 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp359_ = _tmp358_;
#line 511 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp356_, _tmp359_);
#line 511 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp359_);
#line 512 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp360_ = writer;
#line 512 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp361_ = i;
#line 512 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp362_ = page_image_numbers;
#line 512 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp362__length1 = page_image_numbers_length1;
#line 512 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp363_ = i;
#line 512 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp364_ = _tmp362_[_tmp363_];
#line 512 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp365_ = g_strdup_printf ("/Resources << /XObject << /Im%d %u 0 R >> >>\n", _tmp361_, _tmp364_);
#line 512 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp366_ = _tmp365_;
#line 512 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp360_, _tmp366_);
#line 512 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp366_);
#line 513 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp367_ = writer;
#line 513 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp368_ = page_width;
#line 513 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp369_ = width_buffer;
#line 513 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp369__length1 = width_buffer_length1;
#line 513 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp370_ = g_ascii_formatd (_tmp369_, _tmp369__length1, "%.2f", _tmp368_);
#line 513 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp371_ = page_height;
#line 513 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp372_ = height_buffer;
#line 513 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp372__length1 = height_buffer_length1;
#line 513 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp373_ = g_ascii_formatd (_tmp372_, _tmp372__length1, "%.2f", _tmp371_);
#line 513 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp374_ = g_strdup_printf ("/MediaBox [ 0 0 %s %s ]\n", _tmp370_, _tmp373_);
#line 513 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp375_ = _tmp374_;
#line 513 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp367_, _tmp375_);
#line 513 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp375_);
#line 514 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp376_ = writer;
#line 514 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp377_ = page_content_numbers;
#line 514 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp377__length1 = page_content_numbers_length1;
#line 514 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp378_ = i;
#line 514 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp379_ = _tmp377_[_tmp378_];
#line 514 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp380_ = g_strdup_printf ("/Contents %u 0 R\n", _tmp379_);
#line 514 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp381_ = _tmp380_;
#line 514 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp376_, _tmp381_);
#line 514 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp381_);
#line 515 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp382_ = writer;
#line 515 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp382_, ">>\n");
#line 516 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp383_ = writer;
#line 516 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp383_, "endobj\n");
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp384_ = writer;
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp384_, "\n");
#line 520 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp385_ = writer;
#line 520 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp386_ = page_image_numbers;
#line 520 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp386__length1 = page_image_numbers_length1;
#line 520 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp387_ = i;
#line 520 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp388_ = _tmp386_[_tmp387_];
#line 520 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_start_object (_tmp385_, _tmp388_);
#line 521 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp389_ = writer;
#line 521 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp390_ = page_image_numbers;
#line 521 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp390__length1 = page_image_numbers_length1;
#line 521 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp391_ = i;
#line 521 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp392_ = _tmp390_[_tmp391_];
#line 521 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp393_ = g_strdup_printf ("%u 0 obj\n", _tmp392_);
#line 521 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp394_ = _tmp393_;
#line 521 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp389_, _tmp394_);
#line 521 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp394_);
#line 522 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp395_ = writer;
#line 522 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp395_, "<<\n");
#line 523 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp396_ = writer;
#line 523 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp396_, "/Type /XObject\n");
#line 524 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp397_ = writer;
#line 524 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp397_, "/Subtype /Image\n");
#line 525 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp398_ = writer;
#line 525 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp399_ = width;
#line 525 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp400_ = g_strdup_printf ("/Width %d\n", _tmp399_);
#line 525 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp401_ = _tmp400_;
#line 525 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp398_, _tmp401_);
#line 525 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp401_);
#line 526 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp402_ = writer;
#line 526 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp403_ = height;
#line 526 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp404_ = g_strdup_printf ("/Height %d\n", _tmp403_);
#line 526 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp405_ = _tmp404_;
#line 526 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp402_, _tmp405_);
#line 526 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp405_);
#line 527 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp406_ = writer;
#line 527 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp407_ = color_space;
#line 527 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp408_ = g_strdup_printf ("/ColorSpace /%s\n", _tmp407_);
#line 527 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp409_ = _tmp408_;
#line 527 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp406_, _tmp409_);
#line 527 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp409_);
#line 528 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp410_ = writer;
#line 528 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp411_ = depth;
#line 528 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp412_ = g_strdup_printf ("/BitsPerComponent %d\n", _tmp411_);
#line 528 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp413_ = _tmp412_;
#line 528 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp410_, _tmp413_);
#line 528 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp413_);
#line 529 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp414_ = writer;
#line 529 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp415_ = data;
#line 529 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp415__length1 = data_length1;
#line 529 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp416_ = g_strdup_printf ("/Length %d\n", _tmp415__length1);
#line 529 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp417_ = _tmp416_;
#line 529 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp414_, _tmp417_);
#line 529 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp417_);
#line 530 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp418_ = filter;
#line 530 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (_tmp418_ != NULL) {
#line 4376 "book.c"
					PDFWriter* _tmp419_ = NULL;
					const gchar* _tmp420_ = NULL;
					gchar* _tmp421_ = NULL;
					gchar* _tmp422_ = NULL;
#line 531 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp419_ = writer;
#line 531 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp420_ = filter;
#line 531 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp421_ = g_strdup_printf ("/Filter /%s\n", _tmp420_);
#line 531 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp422_ = _tmp421_;
#line 531 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					pdf_writer_write_string (_tmp419_, _tmp422_);
#line 531 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_g_free0 (_tmp422_);
#line 4393 "book.c"
				}
#line 532 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp423_ = writer;
#line 532 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp423_, ">>\n");
#line 533 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp424_ = writer;
#line 533 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp424_, "stream\n");
#line 534 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp425_ = writer;
#line 534 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp426_ = data;
#line 534 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp426__length1 = data_length1;
#line 534 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write (_tmp425_, _tmp426_, _tmp426__length1);
#line 535 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp427_ = writer;
#line 535 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp427_, "\n");
#line 536 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp428_ = writer;
#line 536 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp428_, "endstream\n");
#line 537 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp429_ = writer;
#line 537 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp429_, "endobj\n");
#line 540 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp430_ = writer;
#line 540 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp430_, "\n");
#line 541 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp431_ = writer;
#line 541 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp432_ = struct_tree_root_number;
#line 541 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_start_object (_tmp431_, _tmp432_);
#line 542 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp433_ = writer;
#line 542 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp434_ = struct_tree_root_number;
#line 542 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp435_ = g_strdup_printf ("%u 0 obj\n", _tmp434_);
#line 542 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp436_ = _tmp435_;
#line 542 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp433_, _tmp436_);
#line 542 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp436_);
#line 543 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp437_ = writer;
#line 543 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp437_, "<<\n");
#line 544 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp438_ = writer;
#line 544 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp438_, "/Type /StructTreeRoot\n");
#line 545 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp439_ = writer;
#line 545 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp439_, ">>\n");
#line 546 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp440_ = writer;
#line 546 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp440_, "endobj\n");
#line 549 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp441_ = page_width;
#line 549 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp442_ = width_buffer;
#line 549 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp442__length1 = width_buffer_length1;
#line 549 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp443_ = g_ascii_formatd (_tmp442_, _tmp442__length1, "%f", _tmp441_);
#line 549 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp444_ = page_height;
#line 549 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp445_ = height_buffer;
#line 549 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp445__length1 = height_buffer_length1;
#line 549 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp446_ = g_ascii_formatd (_tmp445_, _tmp445__length1, "%f", _tmp444_);
#line 549 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp447_ = i;
#line 549 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp448_ = g_strdup_printf ("q\n%s 0 0 %s 0 0 cm\n/Im%d Do\nQ", _tmp443_, _tmp446_, _tmp447_);
#line 549 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				command = _tmp448_;
#line 550 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp449_ = writer;
#line 550 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp449_, "\n");
#line 551 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp450_ = writer;
#line 551 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp451_ = page_content_numbers;
#line 551 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp451__length1 = page_content_numbers_length1;
#line 551 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp452_ = i;
#line 551 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp453_ = _tmp451_[_tmp452_];
#line 551 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_start_object (_tmp450_, _tmp453_);
#line 552 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp454_ = writer;
#line 552 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp455_ = page_content_numbers;
#line 552 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp455__length1 = page_content_numbers_length1;
#line 552 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp456_ = i;
#line 552 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp457_ = _tmp455_[_tmp456_];
#line 552 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp458_ = g_strdup_printf ("%u 0 obj\n", _tmp457_);
#line 552 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp459_ = _tmp458_;
#line 552 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp454_, _tmp459_);
#line 552 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp459_);
#line 553 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp460_ = writer;
#line 553 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp460_, "<<\n");
#line 554 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp461_ = writer;
#line 554 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp462_ = command;
#line 554 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp463_ = strlen (_tmp462_);
#line 554 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp464_ = _tmp463_;
#line 554 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp465_ = g_strdup_printf ("/Length %d\n", _tmp464_);
#line 554 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp466_ = _tmp465_;
#line 554 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp461_, _tmp466_);
#line 554 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp466_);
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp467_ = writer;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp467_, ">>\n");
#line 556 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp468_ = writer;
#line 556 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp468_, "stream\n");
#line 557 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp469_ = writer;
#line 557 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp470_ = command;
#line 557 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp469_, _tmp470_);
#line 558 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp471_ = writer;
#line 558 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp471_, "\n");
#line 559 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp472_ = writer;
#line 559 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp472_, "endstream\n");
#line 560 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp473_ = writer;
#line 560 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp473_, "endobj\n");
#line 562 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp474_ = i;
#line 562 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				g_signal_emit_by_name (self, "saving", _tmp474_);
#line 348 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (command);
#line 348 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				compressed_data = (g_free (compressed_data), NULL);
#line 348 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				data = (g_free (data), NULL);
#line 348 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				height_buffer = (g_free (height_buffer), NULL);
#line 348 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				width_buffer = (g_free (width_buffer), NULL);
#line 348 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (filter);
#line 348 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (color_space);
#line 348 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_object_unref0 (image);
#line 348 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_page_unref0 (page);
#line 4585 "book.c"
			}
		}
	}
#line 566 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp475_ = writer;
#line 566 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp475_, "\n");
#line 567 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp476_ = writer;
#line 567 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp477_ = info_number;
#line 567 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_start_object (_tmp476_, _tmp477_);
#line 568 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp478_ = writer;
#line 568 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp479_ = info_number;
#line 568 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp480_ = g_strdup_printf ("%u 0 obj\n", _tmp479_);
#line 568 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp481_ = _tmp480_;
#line 568 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp478_, _tmp481_);
#line 568 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp481_);
#line 569 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp482_ = writer;
#line 569 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp482_, "<<\n");
#line 570 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp483_ = writer;
#line 570 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp484_ = g_strdup_printf ("/Creator (Simple Scan %s)\n", VERSION);
#line 570 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp485_ = _tmp484_;
#line 570 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp483_, _tmp485_);
#line 570 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp485_);
#line 571 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp486_ = writer;
#line 571 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp486_, ">>\n");
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp487_ = writer;
#line 572 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp487_, "endobj\n");
#line 575 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp488_ = writer;
#line 575 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp488_, "\n");
#line 576 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp489_ = writer;
#line 576 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp490_ = _tmp489_->offset;
#line 576 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	xref_offset = _tmp490_;
#line 577 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp491_ = writer;
#line 577 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp491_, "xref\n");
#line 578 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp492_ = writer;
#line 578 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp493_ = writer;
#line 578 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp494_ = _tmp493_->object_offsets;
#line 578 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp494__length1 = _tmp493_->object_offsets_length1;
#line 578 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp495_ = g_strdup_printf ("0 %zu\n", (gsize) (_tmp494__length1 + 1));
#line 578 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp496_ = _tmp495_;
#line 578 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp492_, _tmp496_);
#line 578 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp496_);
#line 579 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp497_ = writer;
#line 579 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp498_ = writer;
#line 579 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp499_ = book_next_empty_object (_tmp498_, 0);
#line 579 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp500_ = g_strdup_printf ("%010zu 65535 f \n", (gsize) _tmp499_);
#line 579 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp501_ = _tmp500_;
#line 579 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp497_, _tmp501_);
#line 579 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp501_);
#line 4677 "book.c"
	{
		gint i = 0;
#line 580 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		i = 0;
#line 4682 "book.c"
		{
			gboolean _tmp502_ = FALSE;
#line 580 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			_tmp502_ = TRUE;
#line 580 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			while (TRUE) {
#line 4689 "book.c"
				gint _tmp504_ = 0;
				PDFWriter* _tmp505_ = NULL;
				guint* _tmp506_ = NULL;
				gint _tmp506__length1 = 0;
				PDFWriter* _tmp507_ = NULL;
				guint* _tmp508_ = NULL;
				gint _tmp508__length1 = 0;
				gint _tmp509_ = 0;
				guint _tmp510_ = 0U;
#line 580 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!_tmp502_) {
#line 4701 "book.c"
					gint _tmp503_ = 0;
#line 580 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp503_ = i;
#line 580 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					i = _tmp503_ + 1;
#line 4707 "book.c"
				}
#line 580 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp502_ = FALSE;
#line 580 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp504_ = i;
#line 580 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp505_ = writer;
#line 580 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp506_ = _tmp505_->object_offsets;
#line 580 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp506__length1 = _tmp505_->object_offsets_length1;
#line 580 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!(_tmp504_ < _tmp506__length1)) {
#line 580 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					break;
#line 4723 "book.c"
				}
#line 581 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp507_ = writer;
#line 581 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp508_ = _tmp507_->object_offsets;
#line 581 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp508__length1 = _tmp507_->object_offsets_length1;
#line 581 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp509_ = i;
#line 581 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp510_ = _tmp508_[_tmp509_];
#line 581 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (_tmp510_ == ((guint) 0)) {
#line 4737 "book.c"
					PDFWriter* _tmp511_ = NULL;
					PDFWriter* _tmp512_ = NULL;
					gint _tmp513_ = 0;
					gint _tmp514_ = 0;
					gchar* _tmp515_ = NULL;
					gchar* _tmp516_ = NULL;
#line 582 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp511_ = writer;
#line 582 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp512_ = writer;
#line 582 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp513_ = i;
#line 582 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp514_ = book_next_empty_object (_tmp512_, _tmp513_ + 1);
#line 582 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp515_ = g_strdup_printf ("%010zu 65535 f \n", (gsize) _tmp514_);
#line 582 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp516_ = _tmp515_;
#line 582 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					pdf_writer_write_string (_tmp511_, _tmp516_);
#line 582 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_g_free0 (_tmp516_);
#line 4760 "book.c"
				} else {
					PDFWriter* _tmp517_ = NULL;
					PDFWriter* _tmp518_ = NULL;
					guint* _tmp519_ = NULL;
					gint _tmp519__length1 = 0;
					gint _tmp520_ = 0;
					guint _tmp521_ = 0U;
					gchar* _tmp522_ = NULL;
					gchar* _tmp523_ = NULL;
#line 584 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp517_ = writer;
#line 584 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp518_ = writer;
#line 584 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp519_ = _tmp518_->object_offsets;
#line 584 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp519__length1 = _tmp518_->object_offsets_length1;
#line 584 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp520_ = i;
#line 584 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp521_ = _tmp519_[_tmp520_];
#line 584 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp522_ = g_strdup_printf ("%010zu 00000 n \n", (gsize) _tmp521_);
#line 584 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp523_ = _tmp522_;
#line 584 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					pdf_writer_write_string (_tmp517_, _tmp523_);
#line 584 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_g_free0 (_tmp523_);
#line 4790 "book.c"
				}
			}
		}
	}
#line 587 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp524_ = writer;
#line 587 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp524_, "\n");
#line 588 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp525_ = writer;
#line 588 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp525_, "trailer\n");
#line 589 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp526_ = writer;
#line 589 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp526_, "<<\n");
#line 590 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp527_ = writer;
#line 590 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp528_ = writer;
#line 590 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp529_ = _tmp528_->object_offsets;
#line 590 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp529__length1 = _tmp528_->object_offsets_length1;
#line 590 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp530_ = g_strdup_printf ("/Size %zu\n", (gsize) (_tmp529__length1 + 1));
#line 590 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp531_ = _tmp530_;
#line 590 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp527_, _tmp531_);
#line 590 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp531_);
#line 591 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp532_ = writer;
#line 591 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp533_ = info_number;
#line 591 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp534_ = g_strdup_printf ("/Info %u 0 R\n", _tmp533_);
#line 591 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp535_ = _tmp534_;
#line 591 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp532_, _tmp535_);
#line 591 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp535_);
#line 592 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp536_ = writer;
#line 592 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp537_ = catalog_number;
#line 592 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp538_ = g_strdup_printf ("/Root %u 0 R\n", _tmp537_);
#line 592 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp539_ = _tmp538_;
#line 592 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp536_, _tmp539_);
#line 592 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp539_);
#line 593 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp540_ = writer;
#line 593 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp541_ = id;
#line 593 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp542_ = id;
#line 593 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp543_ = g_strdup_printf ("/ID [<%s> <%s>]\n", _tmp541_, _tmp542_);
#line 593 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp544_ = _tmp543_;
#line 593 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp540_, _tmp544_);
#line 593 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp544_);
#line 594 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp545_ = writer;
#line 594 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp545_, ">>\n");
#line 595 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp546_ = writer;
#line 595 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp546_, "startxref\n");
#line 596 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp547_ = writer;
#line 596 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp548_ = xref_offset;
#line 596 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp549_ = g_strdup_printf ("%zu\n", _tmp548_);
#line 596 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp550_ = _tmp549_;
#line 596 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp547_, _tmp550_);
#line 596 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp550_);
#line 597 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp551_ = writer;
#line 597 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp551_, "%%EOF\n");
#line 257 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (metadata);
#line 257 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (date_string);
#line 257 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_date_time_unref0 (now);
#line 257 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	page_content_numbers = (g_free (page_content_numbers), NULL);
#line 257 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	page_image_numbers = (g_free (page_image_numbers), NULL);
#line 257 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	page_numbers = (g_free (page_numbers), NULL);
#line 257 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_pdf_writer_unref0 (writer);
#line 257 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_object_unref0 (stream);
#line 257 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (id);
#line 4903 "book.c"
}


static gint book_next_empty_object (PDFWriter* writer, gint start) {
	gint result = 0;
#line 600 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (writer != NULL, 0);
#line 4911 "book.c"
	{
		gint i = 0;
		gint _tmp0_ = 0;
#line 602 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp0_ = start;
#line 602 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		i = _tmp0_;
#line 4919 "book.c"
		{
			gboolean _tmp1_ = FALSE;
#line 602 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			_tmp1_ = TRUE;
#line 602 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			while (TRUE) {
#line 4926 "book.c"
				gint _tmp3_ = 0;
				PDFWriter* _tmp4_ = NULL;
				guint* _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				PDFWriter* _tmp6_ = NULL;
				guint* _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				gint _tmp8_ = 0;
				guint _tmp9_ = 0U;
#line 602 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!_tmp1_) {
#line 4938 "book.c"
					gint _tmp2_ = 0;
#line 602 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp2_ = i;
#line 602 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					i = _tmp2_ + 1;
#line 4944 "book.c"
				}
#line 602 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp1_ = FALSE;
#line 602 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp3_ = i;
#line 602 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp4_ = writer;
#line 602 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp5_ = _tmp4_->object_offsets;
#line 602 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp5__length1 = _tmp4_->object_offsets_length1;
#line 602 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!(_tmp3_ < _tmp5__length1)) {
#line 602 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					break;
#line 4960 "book.c"
				}
#line 603 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp6_ = writer;
#line 603 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp7_ = _tmp6_->object_offsets;
#line 603 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp7__length1 = _tmp6_->object_offsets_length1;
#line 603 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp8_ = i;
#line 603 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp9_ = _tmp7_[_tmp8_];
#line 603 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (_tmp9_ == ((guint) 0)) {
#line 4974 "book.c"
					gint _tmp10_ = 0;
#line 604 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp10_ = i;
#line 604 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					result = _tmp10_ + 1;
#line 604 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					return result;
#line 4982 "book.c"
				}
			}
		}
	}
#line 605 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	result = 0;
#line 605 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return result;
#line 4991 "book.c"
}


void book_save (Book* self, const gchar* type, gint quality, GFile* file, GError** error) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
#line 610 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	static GQuark _tmp2_label0 = 0;
#line 610 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	static GQuark _tmp2_label1 = 0;
#line 610 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	static GQuark _tmp2_label2 = 0;
#line 610 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	static GQuark _tmp2_label3 = 0;
#line 610 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	static GQuark _tmp2_label4 = 0;
#line 5009 "book.c"
	GError * _inner_error_ = NULL;
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (type != NULL);
#line 608 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (file != NULL);
#line 610 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = type;
#line 610 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = _tmp0_;
#line 610 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 610 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (((_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("jpeg")))) || (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("png"))))) || (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("tiff"))))) {
#line 610 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		switch (0) {
#line 5027 "book.c"
			default:
			{
				const gchar* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				GFile* _tmp6_ = NULL;
#line 615 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp4_ = type;
#line 615 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp5_ = quality;
#line 615 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp6_ = file;
#line 615 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				book_save_multi_file (self, _tmp4_, _tmp5_, _tmp6_, &_inner_error_);
#line 615 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 615 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					g_propagate_error (error, _inner_error_);
#line 615 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					return;
#line 5047 "book.c"
				}
#line 616 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				break;
#line 5051 "book.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("ps")))) {
#line 610 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		switch (0) {
#line 5057 "book.c"
			default:
			{
				GFile* _tmp7_ = NULL;
#line 618 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp7_ = file;
#line 618 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				book_save_ps (self, _tmp7_, &_inner_error_);
#line 618 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 618 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					g_propagate_error (error, _inner_error_);
#line 618 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					return;
#line 5071 "book.c"
				}
#line 619 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				break;
#line 5075 "book.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("pdf")))) {
#line 610 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		switch (0) {
#line 5081 "book.c"
			default:
			{
				GFile* _tmp8_ = NULL;
				gint _tmp9_ = 0;
#line 621 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp8_ = file;
#line 621 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp9_ = quality;
#line 621 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				book_save_pdf (self, _tmp8_, _tmp9_, &_inner_error_);
#line 621 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 621 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					g_propagate_error (error, _inner_error_);
#line 621 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					return;
#line 5098 "book.c"
				}
#line 622 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				break;
#line 5102 "book.c"
			}
		}
	}
}


guint book_get_n_pages (Book* self) {
	guint result;
	GList* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
#line 16 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 16 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = self->priv->pages;
#line 16 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = g_list_length (_tmp0_);
#line 16 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	result = _tmp1_;
#line 16 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return result;
#line 5123 "book.c"
}


gboolean book_get_needs_saving (Book* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 21 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 21 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = self->priv->needs_saving_;
#line 21 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	result = _tmp0_;
#line 21 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return result;
#line 5138 "book.c"
}


void book_set_needs_saving (Book* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 22 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 24 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = self->priv->needs_saving_;
#line 24 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = value;
#line 24 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (_tmp0_ == _tmp1_) {
#line 25 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		return;
#line 5156 "book.c"
	}
#line 26 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = value;
#line 26 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv->needs_saving_ = _tmp2_;
#line 27 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_emit_by_name (self, "needs-saving-changed");
#line 5164 "book.c"
}


static void g_cclosure_user_marshal_VOID__PAGE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__PAGE) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__PAGE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (n_param_values == 2);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		data1 = closure->data;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		data2 = param_values->data[0].v_pointer;
#line 5183 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		data1 = param_values->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		data2 = closure->data;
#line 5189 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	callback = (GMarshalFunc_VOID__PAGE) (marshal_data ? marshal_data : cc->callback);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	callback (data1, value_get_page (param_values + 1), data2);
#line 5195 "book.c"
}


static void value_book_init (GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	value->data[0].v_pointer = NULL;
#line 5202 "book.c"
}


static void value_book_free_value (GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		book_unref (value->data[0].v_pointer);
#line 5211 "book.c"
	}
}


static void value_book_copy_value (const GValue* src_value, GValue* dest_value) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (src_value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		dest_value->data[0].v_pointer = book_ref (src_value->data[0].v_pointer);
#line 5221 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		dest_value->data[0].v_pointer = NULL;
#line 5225 "book.c"
	}
}


static gpointer value_book_peek_pointer (const GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return value->data[0].v_pointer;
#line 5233 "book.c"
}


static gchar* value_book_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (collect_values[0].v_pointer) {
#line 5240 "book.c"
		Book* object;
		object = collect_values[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		if (object->parent_instance.g_class == NULL) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5247 "book.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5251 "book.c"
		}
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = book_ref (object);
#line 5255 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 5259 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return NULL;
#line 5263 "book.c"
}


static gchar* value_book_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Book** object_p;
	object_p = collect_values[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (!object_p) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 5274 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (!value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		*object_p = NULL;
#line 5280 "book.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		*object_p = value->data[0].v_pointer;
#line 5284 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		*object_p = book_ref (value->data[0].v_pointer);
#line 5288 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return NULL;
#line 5292 "book.c"
}


GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecBook* spec;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_BOOK), NULL);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return G_PARAM_SPEC (spec);
#line 5306 "book.c"
}


gpointer value_get_book (const GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BOOK), NULL);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return value->data[0].v_pointer;
#line 5315 "book.c"
}


void value_set_book (GValue* value, gpointer v_object) {
	Book* old;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BOOK));
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	old = value->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (v_object) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BOOK));
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		book_ref (value->data[0].v_pointer);
#line 5335 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 5339 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (old) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		book_unref (old);
#line 5345 "book.c"
	}
}


void value_take_book (GValue* value, gpointer v_object) {
	Book* old;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BOOK));
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	old = value->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (v_object) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BOOK));
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 5364 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 5368 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (old) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		book_unref (old);
#line 5374 "book.c"
	}
}


static void book_class_init (BookClass * klass) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	book_parent_class = g_type_class_peek_parent (klass);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	((BookClass *) klass)->finalize = book_finalize;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_type_class_add_private (klass, sizeof (BookPrivate));
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_new ("page_added", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__PAGE, G_TYPE_NONE, 1, TYPE_PAGE);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_new ("page_removed", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__PAGE, G_TYPE_NONE, 1, TYPE_PAGE);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_new ("reordered", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_new ("cleared", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_new ("needs_saving_changed", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_new ("saving", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
#line 5398 "book.c"
}


static void book_instance_init (Book * self) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv = BOOK_GET_PRIVATE (self);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->ref_count = 1;
#line 5407 "book.c"
}


static void book_finalize (Book* obj) {
	Book * self;
	GList* _tmp0_ = NULL;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BOOK, Book);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_handlers_destroy (self);
#line 45 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = self->priv->pages;
#line 5420 "book.c"
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
#line 45 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		page_collection = _tmp0_;
#line 45 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
#line 5428 "book.c"
			Page* _tmp1_ = NULL;
			Page* page = NULL;
#line 45 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			_tmp1_ = _page_ref0 ((Page*) page_it->data);
#line 45 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			page = _tmp1_;
#line 5435 "book.c"
			{
				Page* _tmp2_ = NULL;
				guint _tmp3_ = 0U;
				Page* _tmp4_ = NULL;
				guint _tmp5_ = 0U;
#line 47 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp2_ = page;
#line 47 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
#line 47 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _book_page_changed_cb_page_pixels_changed, self);
#line 48 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp4_ = page;
#line 48 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp5_, NULL, FALSE);
#line 48 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _book_page_changed_cb_page_crop_changed, self);
#line 45 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_page_unref0 (page);
#line 5455 "book.c"
			}
		}
	}
#line 14 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	__g_list_free__page_unref0_0 (self->priv->pages);
#line 231 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_byte_array_unref0 (self->priv->jpeg_data);
#line 5463 "book.c"
}


GType book_get_type (void) {
	static volatile gsize book_type_id__volatile = 0;
	if (g_once_init_enter (&book_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_book_init, value_book_free_value, value_book_copy_value, value_book_peek_pointer, "p", value_book_collect_value, "p", value_book_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BookClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) book_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Book), 0, (GInstanceInitFunc) book_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType book_type_id;
		book_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Book", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&book_type_id__volatile, book_type_id);
	}
	return book_type_id__volatile;
}


gpointer book_ref (gpointer instance) {
	Book* self;
	self = instance;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_atomic_int_inc (&self->ref_count);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return instance;
#line 5488 "book.c"
}


void book_unref (gpointer instance) {
	Book* self;
	self = instance;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		BOOK_GET_CLASS (self)->finalize (self);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 5501 "book.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 635 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return self ? g_object_ref (self) : NULL;
#line 5509 "book.c"
}


PDFWriter* pdf_writer_construct (GType object_type, GFileOutputStream* stream) {
	PDFWriter* self = NULL;
	GFileOutputStream* _tmp0_ = NULL;
	GFileOutputStream* _tmp1_ = NULL;
	guint* _tmp2_ = NULL;
#line 633 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (stream != NULL, NULL);
#line 633 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self = (PDFWriter*) g_type_create_instance (object_type);
#line 635 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = stream;
#line 635 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 635 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_object_unref0 (self->priv->stream);
#line 635 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv->stream = _tmp1_;
#line 636 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = g_new0 (guint, 0);
#line 636 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->object_offsets = (g_free (self->object_offsets), NULL);
#line 636 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->object_offsets = _tmp2_;
#line 636 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->object_offsets_length1 = 0;
#line 636 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->_object_offsets_size_ = self->object_offsets_length1;
#line 633 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return self;
#line 5542 "book.c"
}


PDFWriter* pdf_writer_new (GFileOutputStream* stream) {
#line 633 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return pdf_writer_construct (TYPE_PDF_WRITER, stream);
#line 5549 "book.c"
}


void pdf_writer_write (PDFWriter* self, guint8* data, int data_length1) {
	gsize _tmp4_ = 0UL;
	guint8* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	GError * _inner_error_ = NULL;
#line 639 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 5560 "book.c"
	{
		GFileOutputStream* _tmp0_ = NULL;
		guint8* _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
#line 643 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp0_ = self->priv->stream;
#line 643 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp1_ = data;
#line 643 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp1__length1 = data_length1;
#line 643 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_output_stream_write_all ((GOutputStream*) _tmp0_, _tmp1_, (gsize) _tmp1__length1, NULL, NULL, &_inner_error_);
#line 643 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5575 "book.c"
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 641 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		e = _inner_error_;
#line 641 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_inner_error_ = NULL;
#line 647 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp2_ = e;
#line 647 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp3_ = _tmp2_->message;
#line 647 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_warning ("book.vala:647: Error writing PDF: %s", _tmp3_);
#line 641 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_g_error_free0 (e);
#line 5597 "book.c"
	}
	__finally1:
#line 641 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 641 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 641 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_clear_error (&_inner_error_);
#line 641 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		return;
#line 5608 "book.c"
	}
#line 649 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp4_ = self->offset;
#line 649 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5_ = data;
#line 649 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5__length1 = data_length1;
#line 649 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->offset = _tmp4_ + _tmp5__length1;
#line 5618 "book.c"
}


static gchar* string_to_utf8 (const gchar* self, int* result_length1) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gint _result__length1 = 0;
	gint __result__size_ = 0;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
#line 1405 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1406 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1406 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1406 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
#line 1406 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1406 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_result__length1 = _tmp1_ + 1;
#line 1406 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	__result__size_ = _result__length1;
#line 1407 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp3_ = _result__length1;
#line 1407 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_result__length1 = _tmp3_ - 1;
#line 1408 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp4_ = _result_;
#line 1408 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp4__length1 = _result__length1;
#line 1408 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp5_ = strlen (self);
#line 1408 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp6_ = _tmp5_;
#line 1408 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	memcpy (_tmp4_, self, (gsize) _tmp6_);
#line 1409 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp7_ = _result_;
#line 1409 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp7__length1 = _result__length1;
#line 1409 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1409 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		*result_length1 = _tmp7__length1;
#line 5673 "book.c"
	}
#line 1409 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp7_;
#line 1409 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 5679 "book.c"
}


void pdf_writer_write_string (PDFWriter* self, const gchar* text) {
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
#line 652 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 652 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (text != NULL);
#line 654 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = text;
#line 654 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = string_to_utf8 (_tmp0_, &_tmp1_);
#line 654 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3_ = (guint8*) _tmp2_;
#line 654 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3__length1 = (_tmp1_ * sizeof (gchar)) / sizeof (guint8);
#line 654 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write (self, _tmp3_, (_tmp1_ * sizeof (gchar)) / sizeof (guint8));
#line 654 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3_ = (g_free (_tmp3_), NULL);
#line 5705 "book.c"
}


guint pdf_writer_add_object (PDFWriter* self) {
	guint result = 0U;
	guint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp1_ = 0;
	gint index = 0;
	guint* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	guint* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint _tmp4_ = 0U;
#line 657 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 659 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = self->object_offsets;
#line 659 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0__length1 = self->object_offsets_length1;
#line 659 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = _tmp0__length1 + 1;
#line 659 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->object_offsets = g_renew (guint, self->object_offsets, _tmp0__length1 + 1);
#line 659 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	(_tmp1_ > self->object_offsets_length1) ? memset (self->object_offsets + self->object_offsets_length1, 0, sizeof (guint) * (_tmp1_ - self->object_offsets_length1)) : NULL;
#line 659 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->object_offsets_length1 = _tmp1_;
#line 659 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->_object_offsets_size_ = _tmp1_;
#line 660 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = self->object_offsets;
#line 660 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2__length1 = self->object_offsets_length1;
#line 660 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	index = _tmp2__length1 - 1;
#line 661 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3_ = self->object_offsets;
#line 661 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3__length1 = self->object_offsets_length1;
#line 661 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3_[index] = (guint) 0;
#line 661 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp4_ = _tmp3_[index];
#line 662 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	result = (guint) (index + 1);
#line 662 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return result;
#line 5754 "book.c"
}


void pdf_writer_start_object (PDFWriter* self, guint index) {
	guint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	guint _tmp1_ = 0U;
	gsize _tmp2_ = 0UL;
	guint _tmp3_ = 0U;
#line 665 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 667 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = self->object_offsets;
#line 667 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0__length1 = self->object_offsets_length1;
#line 667 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = index;
#line 667 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = self->offset;
#line 667 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_[_tmp1_ - 1] = (guint) _tmp2_;
#line 667 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3_ = _tmp0_[_tmp1_ - 1];
#line 5778 "book.c"
}


static void value_pdf_writer_init (GValue* value) {
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	value->data[0].v_pointer = NULL;
#line 5785 "book.c"
}


static void value_pdf_writer_free_value (GValue* value) {
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (value->data[0].v_pointer) {
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		pdf_writer_unref (value->data[0].v_pointer);
#line 5794 "book.c"
	}
}


static void value_pdf_writer_copy_value (const GValue* src_value, GValue* dest_value) {
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (src_value->data[0].v_pointer) {
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		dest_value->data[0].v_pointer = pdf_writer_ref (src_value->data[0].v_pointer);
#line 5804 "book.c"
	} else {
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		dest_value->data[0].v_pointer = NULL;
#line 5808 "book.c"
	}
}


static gpointer value_pdf_writer_peek_pointer (const GValue* value) {
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return value->data[0].v_pointer;
#line 5816 "book.c"
}


static gchar* value_pdf_writer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (collect_values[0].v_pointer) {
#line 5823 "book.c"
		PDFWriter* object;
		object = collect_values[0].v_pointer;
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		if (object->parent_instance.g_class == NULL) {
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5830 "book.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5834 "book.c"
		}
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = pdf_writer_ref (object);
#line 5838 "book.c"
	} else {
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 5842 "book.c"
	}
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return NULL;
#line 5846 "book.c"
}


static gchar* value_pdf_writer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PDFWriter** object_p;
	object_p = collect_values[0].v_pointer;
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (!object_p) {
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 5857 "book.c"
	}
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (!value->data[0].v_pointer) {
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		*object_p = NULL;
#line 5863 "book.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		*object_p = value->data[0].v_pointer;
#line 5867 "book.c"
	} else {
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		*object_p = pdf_writer_ref (value->data[0].v_pointer);
#line 5871 "book.c"
	}
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return NULL;
#line 5875 "book.c"
}


GParamSpec* param_spec_pdf_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPDFWriter* spec;
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PDF_WRITER), NULL);
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return G_PARAM_SPEC (spec);
#line 5889 "book.c"
}


gpointer value_get_pdf_writer (const GValue* value) {
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PDF_WRITER), NULL);
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return value->data[0].v_pointer;
#line 5898 "book.c"
}


void value_set_pdf_writer (GValue* value, gpointer v_object) {
	PDFWriter* old;
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PDF_WRITER));
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	old = value->data[0].v_pointer;
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (v_object) {
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PDF_WRITER));
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		pdf_writer_ref (value->data[0].v_pointer);
#line 5918 "book.c"
	} else {
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 5922 "book.c"
	}
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (old) {
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		pdf_writer_unref (old);
#line 5928 "book.c"
	}
}


void value_take_pdf_writer (GValue* value, gpointer v_object) {
	PDFWriter* old;
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PDF_WRITER));
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	old = value->data[0].v_pointer;
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (v_object) {
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PDF_WRITER));
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 5947 "book.c"
	} else {
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 5951 "book.c"
	}
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (old) {
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		pdf_writer_unref (old);
#line 5957 "book.c"
	}
}


static void pdf_writer_class_init (PDFWriterClass * klass) {
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_parent_class = g_type_class_peek_parent (klass);
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	((PDFWriterClass *) klass)->finalize = pdf_writer_finalize;
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_type_class_add_private (klass, sizeof (PDFWriterPrivate));
#line 5969 "book.c"
}


static void pdf_writer_instance_init (PDFWriter * self) {
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv = PDF_WRITER_GET_PRIVATE (self);
#line 629 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->offset = (gsize) 0;
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->ref_count = 1;
#line 5980 "book.c"
}


static void pdf_writer_finalize (PDFWriter* obj) {
	PDFWriter * self;
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PDF_WRITER, PDFWriter);
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_handlers_destroy (self);
#line 630 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->object_offsets = (g_free (self->object_offsets), NULL);
#line 631 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_object_unref0 (self->priv->stream);
#line 5994 "book.c"
}


GType pdf_writer_get_type (void) {
	static volatile gsize pdf_writer_type_id__volatile = 0;
	if (g_once_init_enter (&pdf_writer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_pdf_writer_init, value_pdf_writer_free_value, value_pdf_writer_copy_value, value_pdf_writer_peek_pointer, "p", value_pdf_writer_collect_value, "p", value_pdf_writer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PDFWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pdf_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PDFWriter), 0, (GInstanceInitFunc) pdf_writer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType pdf_writer_type_id;
		pdf_writer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PDFWriter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&pdf_writer_type_id__volatile, pdf_writer_type_id);
	}
	return pdf_writer_type_id__volatile;
}


gpointer pdf_writer_ref (gpointer instance) {
	PDFWriter* self;
	self = instance;
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_atomic_int_inc (&self->ref_count);
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return instance;
#line 6019 "book.c"
}


void pdf_writer_unref (gpointer instance) {
	PDFWriter* self;
	self = instance;
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		PDF_WRITER_GET_CLASS (self)->finalize (self);
#line 627 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 6032 "book.c"
	}
}


static cairo_status_t _ps_writer_write_cairo_data_cairo_write_func_t (gpointer self, guchar* data, int data_length1) {
	cairo_status_t result;
	result = ps_writer_write_cairo_data ((PsWriter*) self, data, data_length1);
#line 679 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return result;
#line 6042 "book.c"
}


PsWriter* ps_writer_construct (GType object_type, GFileOutputStream* stream) {
	PsWriter* self = NULL;
	GFileOutputStream* _tmp0_ = NULL;
	GFileOutputStream* _tmp1_ = NULL;
	cairo_surface_t* _tmp2_ = NULL;
#line 676 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (stream != NULL, NULL);
#line 676 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self = (PsWriter*) g_type_create_instance (object_type);
#line 678 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = stream;
#line 678 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 678 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_object_unref0 (self->stream);
#line 678 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->stream = _tmp1_;
#line 679 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = cairo_ps_surface_create_for_stream (_ps_writer_write_cairo_data_cairo_write_func_t, self, (gdouble) 0, (gdouble) 0);
#line 679 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_cairo_surface_destroy0 (self->surface);
#line 679 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->surface = _tmp2_;
#line 676 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return self;
#line 6071 "book.c"
}


PsWriter* ps_writer_new (GFileOutputStream* stream) {
#line 676 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return ps_writer_construct (TYPE_PS_WRITER, stream);
#line 6078 "book.c"
}


static cairo_status_t ps_writer_write_cairo_data (PsWriter* self, guint8* data, int data_length1) {
	cairo_status_t result = 0;
	GError * _inner_error_ = NULL;
#line 682 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 6087 "book.c"
	{
		GFileOutputStream* _tmp0_ = NULL;
		guint8* _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
#line 686 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp0_ = self->stream;
#line 686 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp1_ = data;
#line 686 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp1__length1 = data_length1;
#line 686 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_output_stream_write_all ((GOutputStream*) _tmp0_, _tmp1_, (gsize) _tmp1__length1, NULL, NULL, &_inner_error_);
#line 686 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6102 "book.c"
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 684 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		e = _inner_error_;
#line 684 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_inner_error_ = NULL;
#line 690 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp2_ = e;
#line 690 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp3_ = _tmp2_->message;
#line 690 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_warning ("book.vala:690: Error writing data: %s", _tmp3_);
#line 691 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		result = CAIRO_STATUS_WRITE_ERROR;
#line 691 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_g_error_free0 (e);
#line 691 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		return result;
#line 6128 "book.c"
	}
	__finally2:
#line 684 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 684 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 684 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_clear_error (&_inner_error_);
#line 684 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		return 0;
#line 6139 "book.c"
	}
#line 694 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	result = CAIRO_STATUS_SUCCESS;
#line 694 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return result;
#line 6145 "book.c"
}


static void value_ps_writer_init (GValue* value) {
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	value->data[0].v_pointer = NULL;
#line 6152 "book.c"
}


static void value_ps_writer_free_value (GValue* value) {
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (value->data[0].v_pointer) {
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		ps_writer_unref (value->data[0].v_pointer);
#line 6161 "book.c"
	}
}


static void value_ps_writer_copy_value (const GValue* src_value, GValue* dest_value) {
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (src_value->data[0].v_pointer) {
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		dest_value->data[0].v_pointer = ps_writer_ref (src_value->data[0].v_pointer);
#line 6171 "book.c"
	} else {
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		dest_value->data[0].v_pointer = NULL;
#line 6175 "book.c"
	}
}


static gpointer value_ps_writer_peek_pointer (const GValue* value) {
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return value->data[0].v_pointer;
#line 6183 "book.c"
}


static gchar* value_ps_writer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (collect_values[0].v_pointer) {
#line 6190 "book.c"
		PsWriter* object;
		object = collect_values[0].v_pointer;
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		if (object->parent_instance.g_class == NULL) {
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 6197 "book.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 6201 "book.c"
		}
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = ps_writer_ref (object);
#line 6205 "book.c"
	} else {
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 6209 "book.c"
	}
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return NULL;
#line 6213 "book.c"
}


static gchar* value_ps_writer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PsWriter** object_p;
	object_p = collect_values[0].v_pointer;
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (!object_p) {
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 6224 "book.c"
	}
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (!value->data[0].v_pointer) {
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		*object_p = NULL;
#line 6230 "book.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		*object_p = value->data[0].v_pointer;
#line 6234 "book.c"
	} else {
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		*object_p = ps_writer_ref (value->data[0].v_pointer);
#line 6238 "book.c"
	}
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return NULL;
#line 6242 "book.c"
}


GParamSpec* param_spec_ps_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPsWriter* spec;
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PS_WRITER), NULL);
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return G_PARAM_SPEC (spec);
#line 6256 "book.c"
}


gpointer value_get_ps_writer (const GValue* value) {
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PS_WRITER), NULL);
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return value->data[0].v_pointer;
#line 6265 "book.c"
}


void value_set_ps_writer (GValue* value, gpointer v_object) {
	PsWriter* old;
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PS_WRITER));
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	old = value->data[0].v_pointer;
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (v_object) {
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PS_WRITER));
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		ps_writer_ref (value->data[0].v_pointer);
#line 6285 "book.c"
	} else {
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 6289 "book.c"
	}
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (old) {
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		ps_writer_unref (old);
#line 6295 "book.c"
	}
}


void value_take_ps_writer (GValue* value, gpointer v_object) {
	PsWriter* old;
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PS_WRITER));
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	old = value->data[0].v_pointer;
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (v_object) {
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PS_WRITER));
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 6314 "book.c"
	} else {
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 6318 "book.c"
	}
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (old) {
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		ps_writer_unref (old);
#line 6324 "book.c"
	}
}


static void ps_writer_class_init (PsWriterClass * klass) {
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	ps_writer_parent_class = g_type_class_peek_parent (klass);
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	((PsWriterClass *) klass)->finalize = ps_writer_finalize;
#line 6334 "book.c"
}


static void ps_writer_instance_init (PsWriter * self) {
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->ref_count = 1;
#line 6341 "book.c"
}


static void ps_writer_finalize (PsWriter* obj) {
	PsWriter * self;
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PS_WRITER, PsWriter);
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_handlers_destroy (self);
#line 673 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_cairo_surface_destroy0 (self->surface);
#line 674 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_object_unref0 (self->stream);
#line 6355 "book.c"
}


GType ps_writer_get_type (void) {
	static volatile gsize ps_writer_type_id__volatile = 0;
	if (g_once_init_enter (&ps_writer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_ps_writer_init, value_ps_writer_free_value, value_ps_writer_copy_value, value_ps_writer_peek_pointer, "p", value_ps_writer_collect_value, "p", value_ps_writer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PsWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ps_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PsWriter), 0, (GInstanceInitFunc) ps_writer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType ps_writer_type_id;
		ps_writer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PsWriter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&ps_writer_type_id__volatile, ps_writer_type_id);
	}
	return ps_writer_type_id__volatile;
}


gpointer ps_writer_ref (gpointer instance) {
	PsWriter* self;
	self = instance;
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_atomic_int_inc (&self->ref_count);
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return instance;
#line 6380 "book.c"
}


void ps_writer_unref (gpointer instance) {
	PsWriter* self;
	self = instance;
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		PS_WRITER_GET_CLASS (self)->finalize (self);
#line 671 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 6393 "book.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



