# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Git
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/v5/texpdf_format.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: LaTeX formatting template, unicode utf-8 version, used for pdf

=end
module SiSU_TeX_Pdf
  require_relative 'texpdf_parts'                        # texpdf_parts.rb
  @@table_pg_break_counter=1
  class BareUrls
    include SiSU_Parts_TeXpdf
    def initialize(md,dob=nil)
      @md,@dob=md,dob
    end
    def bare_urls
      @dob.obj=@dob.obj.gsub(/#{Mx[:url_o]}([a-zA-Z0-9._-]+\@[a-zA-Z0-9_-]+?\.[a-zA-Z0-9._-]+)#{Mx[:url_c]}/,
         "#{url_decoration.tex_open}\\begin{scriptsize}\\email{\\1}#{url_decoration.tex_close}")
      @dob.tmp=@dob.tmp.gsub(/(^|[^\\])_/m,'\1\_'). #watch may not work
        gsub(/(^|[^#{Mx[:lnk_c]}])#{Mx[:url_o]}_?(?:\\?_)?(\S+?)#{Mx[:url_c]}/m,
          "\\1#{url_decoration.tex_open}\\begin{scriptsize}\\url{\\2}\\end{scriptsize}#{url_decoration.tex_close}")
      @dob
    end
    def bare_urls_in_code
      @dob.tmp=@dob.tmp.gsub(/(^|[^\\])_/m,'\1\_'). #watch may not work
        gsub(/(https?:\/\/\S+?)([{]|[.,;)\]]?(?: |$))/m,
          '\begin{scriptsize}\url{\1}\end{scriptsize}\2')
      @dob
    end
  end
  class FormatTextObject
    include SiSU_Parts_TeXpdf
    attr_accessor :string,:string1,:orientation,:url,:dir,:tex
    @@sys=SiSU_Env::SystemCall.new
    @@tex_pattern_margin_number=/\\begin\{tiny\}\\hspace\{0mm\}\\end\{tiny\}\{\\marginpar.+?\}\}\}/
    @@tableheader={
      'a4' => { p: 0, l: 0 },
      'a5' => { p: 0, l: 0 },
      'b5' => { p: 0, l: 0 },
      'letter' => { p: 0, l: 0 },
      'legal' => { p: 0, l: 0 }
    }
    @@sys=SiSU_Env::SystemCall.new
    def initialize(md,dob=nil)
      @md,@dob=md,dob
      if defined? @md.image \
      and @md.image =~/center/
        @center_begin,@center_end='\begin{center}','\end{center}'
      else @center_begin,@center_end='',''
      end
      @start_table=''
      @tx=SiSU_Env::GetInit.new.tex
      @env ||=SiSU_Env::InfoEnv.new(@md.fns)
      @tex2pdf=@@tex3pdf ||=SiSU_Env::SystemCall.new.tex2pdf_engine
      @make ||=SiSU_Env::ProcessingSettings.new(@md)
    end
    def ocn_display(dob)
      show_ocn=(@make.build.ocn?) \
      ? dob.ocn
      : ''
      "\\begin{tiny}\\hspace{0mm}\\end{tiny}{\\marginpar{\\begin{tiny}\\hspace{0mm}\\hypertarget{#{dob.ocn}}{#{show_ocn}}\\end{tiny}}}" #ocn object citation numbering
    end
    def table_special_characters(r)
      r=r.gsub(/#{Mx[:tc_p]}/mu,'&').
        gsub(/#{Mx[:tc_c]}/m,'\\\\\\').
        gsub(/%/,'\%').
        gsub(/#{Mx[:fa_bold_o]}(.+?)#{Mx[:fa_bold_c]}/,'\begin{bfseries}\1 \end{bfseries}').
        gsub(/#{Mx[:fa_italics_o]}(.+?)#{Mx[:fa_italics_c]}/,'\emph{\1}').
        gsub(/#{Mx[:fa_underscore_o]}(.+?)#{Mx[:fa_underscore_c]}/,'\uline{\1}'). # ulem
        gsub(/#{Mx[:fa_cite_o]}(.+?)#{Mx[:fa_cite_c]}/,"``\\1''"). # quote #CHECK
        gsub(/#{Mx[:fa_insert_o]}(.+?)#{Mx[:fa_insert_c]}/,'\uline{\1}'). # ulem
        gsub(/#{Mx[:fa_strike_o]}(.+?)#{Mx[:fa_strike_c]}/,'\sout{\1}'). # ulem
        gsub(/#{Mx[:fa_superscript_o]}(.+?)#{Mx[:fa_superscript_c]}/,"\$^{\\textrm{\\1}}\$").
        gsub(/#{Mx[:fa_subscript_o]}(.+?)#{Mx[:fa_subscript_c]}/,"\$_{\\textrm{\\1}}\$")
    end
    def longtable_landscape
      end_table='\end{longtable}'
      row_break='\\\\\\'
      if @dob.is==:table
        tw=case @dob.tmp[:paper_size]
        when /a4/i      then @tx.a4.landscape.w     #European default, SiSU default
        when /letter/i  then @tx.letter.landscape.w #U.S. default
        when /legal/i   then @tx.legal.landscape.w  #U.S. alternative
        when /book|b5/i then @tx.b5.landscape.w     #book default - larger
        when /a5/i      then @tx.a5.landscape.w
        else             @tx.a4.landscape.w     #default currently A4
        end
        textwidth=(tw.to_i/2) - 24
        colW=[]
        colW << '{'
        @dob.widths.each  do |x|
          x=(x.to_i * textwidth)/100
          col_w=x.to_s # x.gsub(/.+/,'l\|') #unless x.nil?
          colW << "p{#{col_w}mm}" if col_w
        end
        colW << '}'
        colW=colW.join
        start_table="\n\\setlength{\\LTleft}{0pt}\n\\setlength{\\LTright}{\\fill}\n" +
          "\\begin{tiny}\n\\begin{longtable}#{colW}\n"
        rows=@dob.obj.split(/#{Mx[:br_nl]}/)
        if @dob.head_ #result imperfect, check on
          rows[0]=rows[0].gsub(/(^|.+?)(?:#{Mx[:tc_p]}|$)/u,'\bfseries \1&').
            gsub(/&\s*$/," #{row_break} \\hline\\endhead #{row_break}")
        end
        rows_new=[]
        rows.each do |r|
          r=table_special_characters(r)
          r=r.gsub(/$/," #{row_break}\n") unless r =~/#{row_break*2}$/
          if r=~/\<!f(.+?)!\>/ # not tested table footer if any
            tablefoot=$1
            r=r.gsub(/\<!f(.+?)!\>/,'')
            r="#{r} \\multicolumn{#{@dob.cols}}{l}{\\tiny #{tablefoot}} \\\\ \\hline\n\\endfoot\n\\hline\n"
          end
          rows_new << r
        end
        table=rows_new.join #@dob[:ao].obj=rows.join
        ocn_display(@dob) + start_table + table + " #{end_table}\n\\end{tiny}"
      else ''
      end
    end
    def longtable_portrait
      end_table='\end{longtable}'
      row_break='\\\\\\'
      if @dob.is==:table
        tw=case @dob.tmp[:paper_size]
        when /a4/i      then @tx.a4.portrait.w     #European default, SiSU default
        when /letter/i  then @tx.letter.portrait.w #U.S. default
        when /legal/i   then @tx.legal.portrait.w  #U.S. alternative
        when /book|b5/i then @tx.b5.portrait.w     #book default - larger
        when /a5/i      then @tx.a5.portrait.w
        else             @tx.a4.portrait.w         #default currently A4
        end
        textwidth=tw.to_i - 20
        colW=[]
        colW << '{'
        @dob.widths.each do |x|
          x=(x.to_i * textwidth)/100 #x=(x.to_i/100.0 * 160)
          col_w=x.to_s # x.gsub(/.+/,'l\|') #unless x.nil?
          colW << "p{#{col_w}mm}" if col_w
        end
        colW << '}'
        colW=colW.join
        start_table="\n\\setlength{\\LTleft}{0pt}\n\\setlength{\\LTright}{\\fill}\n" +
          "\\begin{tiny}\n\\begin{longtable}#{colW}\n"
        rows=@dob.obj.split(/#{Mx[:br_nl]}/)
        if @dob.head_
          rows[0]=rows[0].gsub(/(^|.+?)(?:#{Mx[:tc_p]}|$)/u,'\bfseries \1&').
            gsub(/&\s*$/," #{row_break} \\hline\\endhead #{row_break}")
        end
        rows_new=[]
        rows.each do |r|
          r=table_special_characters(r)
          r=r.gsub(/$/," #{row_break}\n") unless r =~/#{row_break*2}$/
          if r=~/\<!f(.+?)!\>/ # not tested table footer if any
            tablefoot=$1
            r=r.gsub(/\<!f(.+?)!\>/,'')
            r="#{r} \\multicolumn{#{@dob.cols}}{l}{\\tiny #{tablefoot}} \\\\ \\hline\n\\endfoot\n\\hline\n"
          end
          rows_new << r
        end
        table=rows_new.join #@dob[:ao].obj=rows.join
        ocn_display(@dob) + start_table + table + " #{end_table}\n\\end{tiny}"
      else ''
      end
    end
    def remove_footnotes(cont_ln)
      cont_ln=if cont_ln =~/\\[Ff]ootnote/m
        cont_ln.gsub(/\s*\\[Ff]ootnote\[\d+\]\{%\s+.+?\}\s*/m,' ').
          gsub(/\s*\\[Ff]ootnote[A]\{[*+]+\d*\}\{%\S+.+?\}\s*/m,' ')
      else cont_ln
      end
    end
    def title_level_A
      dob=@dob
      dob.tmp=dob.tmp.strip if dob.tmp
      dob.tmp=dob.tmp.gsub(/\\begin\{(bfseries|itshape)\}(.+?)\\end\{\1\}/m,'\2').
        gsub(/#{Mx[:url_o]}|#{Mx[:url_c]}/,'')
      cont_ln=dob.tmp.dup
      cont_ln=cont_ln.gsub(/\\begin\{(monosp)\}(.+?)\\end\{\1\}/m,'\2').
        gsub(@@tex_pattern_margin_number,'')
      cont_ln=remove_footnotes(cont_ln)
      cont_ln=cont_ln.gsub(/\{[\\]+(&)\}/,'\\1')
      titleset=''
      dob.tmp=dob.tmp.gsub(/^(.*)\n?$/m,
        "#{titleset}\\part*{\\1}
\\markboth{#{@md.title.full}}\n")
      dob
    end
    def section_heading_level(dob)
      dob.tmp=dob.tmp.strip if dob.tmp
      dob.tmp=dob.tmp.gsub(/\\begin\{(bfseries|itshape)\}(.+?)\\end\{\1\}/m,'\2').
        gsub(/#{Mx[:url_o]}|#{Mx[:url_c]}/,'')
      cont_ln=dob.tmp.dup
      cont_ln=cont_ln.gsub(/\\begin\{(monosp)\}(.+?)\\end\{\1\}/m,'\2').
        gsub(@@tex_pattern_margin_number,'')
      cont_ln=remove_footnotes(cont_ln)
      cont_ln=cont_ln.gsub(/\{[\\]+(&)\}/,'\\1')
      dob.tmp=dob.tmp.gsub(/^(.*)\n?$/m,
        "\\clearpage
\\part*{\\1}
\\addcontentsline{toc}{part}{#{cont_ln}}
\\markboth{#{@md.title.full}}\n")
      dob
    end
    def heading_dev_null(dob)
      dob.tmp,dob.obj='',''
      dob
    end
    def heading_sublevels(dob)
      if dob.lv=='1'
        sect='section'
        tocadd=%{\\addcontentsline{toc}{section}}
        pre=''
        post=''
        headadd=%{\n\\markright{#{@md.title.full}}}
      elsif dob.lv=='2'
        sect='subsection'
        tocadd=%{\\addcontentsline{toc}{subsection}}
        pre=''
        post=" \\\\\n"
        headadd=''
      elsif dob.lv=='3'
        sect='subsubsection'
        tocadd=%{\\addcontentsline{toc}{subsubsection}}
        pre='' #pre='~~~~'
        post=" \\\\\n"
        headadd=''
      end
      dob.tmp=dob.tmp.strip if dob.tmp
      dob.tmp=dob.tmp.gsub(/\\begin\{(bfseries|itshape)\}(.+?)\\end\{\1\}/m,'\2').
        gsub(/#{Mx[:url_o]}|#{Mx[:url_c]}/,'')
      cont_ln=dob.tmp.dup
      cont_ln=cont_ln.gsub(/\\begin\{(monosp)\}(.+?)\\end\{\1\}/m,'\2').
        gsub(@@tex_pattern_margin_number,'').
        gsub(/#{Tex[:backslash]*2}/,"#{Tex[:backslash]*4}"). # added w42
        gsub(/\\footnote\[\d+\]\{%.+?\\end\{scriptsize\}\s*\}/m,''). #arbitrary bugfix, revisit should not be necessary, eg. wta.1994 2004w22
        gsub(/\\Footnote[A]\{[*+]+\d*\}\{%.+?\\end\{scriptsize\}\s*\}/m,'') #arbitrary bugfix, revisit should not be necessary, eg. wta.1994 2004w22
      if dob.name =~/endnotes/
        dob.tmp=dob.tmp.gsub(/.+/m,'')
      end
      cont_ln=remove_footnotes(cont_ln)
      cont_ln=cont_ln.gsub(/\{[\\]+(&)\}/,'\\1')
      dob.tmp=dob.tmp.gsub(/^(.*)?\n?$/m,
        "\\#{sect}*{\\1}
#{tocadd}{#{pre}#{cont_ln}#{post}}#{headadd}")
      dob
    end
    def section_heading_level_B
      section_heading_level(@dob)
    end
    def section_heading_level_C
      section_heading_level(@dob)
    end
    def section_heading_level_D
      section_heading_level(@dob)
    end
    def heading_level_1
      if not @dob.use_ == :dummy
        heading_sublevels(@dob)
      else
        heading_dev_null(@dob)
      end
    end
    def heading_level_2
      heading_sublevels(@dob)
    end
    def heading_level_3
      heading_sublevels(@dob)
    end
    def heading_level_4
      heading_sublevels(@dob)
    end
    def hang
      case @dob.indent
      when /0/
        case @dob.hang
        when /0/ then indent,hang='0mm', '0mm'
        when /1/ then indent,hang='0mm','10mm'
        when /2/ then indent,hang='0mm','20mm'
        when /3/ then indent,hang='0mm','30mm'
        when /4/ then indent,hang='0mm','40mm'
        when /5/ then indent,hang='0mm','50mm'
        when /6/ then indent,hang='0mm','60mm'
        when /7/ then indent,hang='0mm','70mm'
        when /8/ then indent,hang='0mm','80mm'
        when /9/ then indent,hang='0mm','90mm'
        end
      when /1/
        case @dob.hang
        when /0/ then indent,hang='10mm','-10mm'
        when /1/ then indent,hang='10mm',  '0mm'
        when /2/ then indent,hang='10mm', '10mm'
        when /3/ then indent,hang='10mm', '20mm'
        when /4/ then indent,hang='10mm', '30mm'
        when /5/ then indent,hang='10mm', '40mm'
        when /6/ then indent,hang='10mm', '50mm'
        when /7/ then indent,hang='10mm', '60mm'
        when /8/ then indent,hang='10mm', '70mm'
        when /9/ then indent,hang='10mm', '80mm'
        end
      when /2/
        case @dob.hang
        when /0/ then indent,hang='20mm','-20mm'
        when /1/ then indent,hang='20mm','-10mm'
        when /2/ then indent,hang='20mm',  '0mm'
        when /3/ then indent,hang='20mm', '10mm'
        when /4/ then indent,hang='20mm', '20mm'
        when /5/ then indent,hang='20mm', '30mm'
        when /6/ then indent,hang='20mm', '40mm'
        when /7/ then indent,hang='20mm', '50mm'
        when /8/ then indent,hang='20mm', '60mm'
        when /9/ then indent,hang='20mm', '70mm'
        end
      when /3/
        case @dob.hang
        when /0/ then indent,hang='30mm','-30mm'
        when /1/ then indent,hang='30mm','-20mm'
        when /2/ then indent,hang='30mm','-10mm'
        when /3/ then indent,hang='30mm',  '0mm'
        when /4/ then indent,hang='30mm', '10mm'
        when /5/ then indent,hang='30mm', '20mm'
        when /6/ then indent,hang='30mm', '30mm'
        when /7/ then indent,hang='30mm', '40mm'
        when /8/ then indent,hang='30mm', '50mm'
        when /9/ then indent,hang='30mm', '60mm'
        end
      when /4/
        case @dob.hang
        when /0/ then indent,hang='40mm','-40mm'
        when /1/ then indent,hang='40mm','-30mm'
        when /2/ then indent,hang='40mm','-20mm'
        when /3/ then indent,hang='40mm','-10mm'
        when /4/ then indent,hang='40mm',  '0mm'
        when /5/ then indent,hang='40mm', '10mm'
        when /6/ then indent,hang='40mm', '20mm'
        when /7/ then indent,hang='40mm', '30mm'
        when /8/ then indent,hang='40mm', '40mm'
        when /9/ then indent,hang='40mm', '50mm'
        end
      when /5/
        case @dob.hang
        when /0/ then indent,hang='50mm','-50mm'
        when /1/ then indent,hang='50mm','-40mm'
        when /2/ then indent,hang='50mm','-30mm'
        when /3/ then indent,hang='50mm','-20mm'
        when /4/ then indent,hang='50mm','-10mm'
        when /5/ then indent,hang='50mm',  '0mm'
        when /6/ then indent,hang='50mm', '10mm'
        when /7/ then indent,hang='50mm', '20mm'
        when /8/ then indent,hang='50mm', '30mm'
        when /9/ then indent,hang='50mm', '40mm'
        end
      when /6/
        case @dob.hang
        when /0/ then indent,hang='60mm','-60mm'
        when /1/ then indent,hang='60mm','-50mm'
        when /2/ then indent,hang='60mm','-40mm'
        when /3/ then indent,hang='60mm','-30mm'
        when /4/ then indent,hang='60mm','-20mm'
        when /5/ then indent,hang='60mm','-10mm'
        when /6/ then indent,hang='60mm',  '0mm'
        when /7/ then indent,hang='60mm', '10mm'
        when /8/ then indent,hang='60mm', '20mm'
        when /9/ then indent,hang='60mm', '30mm'
        end
      when /7/
        case @dob.hang
        when /0/ then indent,hang='70mm','-70mm'
        when /1/ then indent,hang='70mm','-60mm'
        when /2/ then indent,hang='70mm','-50mm'
        when /3/ then indent,hang='70mm','-40mm'
        when /4/ then indent,hang='70mm','-30mm'
        when /5/ then indent,hang='70mm','-20mm'
        when /6/ then indent,hang='70mm','-10mm'
        when /7/ then indent,hang='70mm',  '0mm'
        when /8/ then indent,hang='70mm', '10mm'
        when /9/ then indent,hang='70mm', '20mm'
        end
      when /8/
        case @dob.hang
        when /0/ then indent,hang='80mm','-80mm'
        when /1/ then indent,hang='80mm','-70mm'
        when /2/ then indent,hang='80mm','-60mm'
        when /3/ then indent,hang='80mm','-50mm'
        when /4/ then indent,hang='80mm','-40mm'
        when /5/ then indent,hang='80mm','-30mm'
        when /6/ then indent,hang='80mm','-20mm'
        when /7/ then indent,hang='80mm','-10mm'
        when /8/ then indent,hang='80mm',  '0mm'
        when /9/ then indent,hang='80mm', '10mm'
        end
      when /9/
        case @dob.hang
        when /0/ then indent,hang='90mm','-90mm'
        when /1/ then indent,hang='90mm','-80mm'
        when /2/ then indent,hang='90mm','-70mm'
        when /3/ then indent,hang='90mm','-60mm'
        when /4/ then indent,hang='90mm','-50mm'
        when /5/ then indent,hang='90mm','-40mm'
        when /6/ then indent,hang='90mm','-30mm'
        when /7/ then indent,hang='90mm','-20mm'
        when /8/ then indent,hang='90mm','-10mm'
        when /9/ then indent,hang='90mm',  '0mm'
        end
      end
      "\\begin{ParagraphHang}{#{indent}}{#{hang}}#{@dob.tmp} \\end{ParagraphHang}}"
    end
    def indent
      indent=case @dob.indent
      when /1/ then '0mm'
      when /2/ then '10mm'
      when /3/ then '20mm'
      when /4/ then '30mm'
      when /5/ then '40mm'
      when /6/ then '50mm'
      when /7/ then '60mm'
      when /8/ then '70mm'
      when /9/ then '80mm'
      end
      "\\begin{ParagraphIndent}{#{indent}}#{@dob.tmp} \\end{ParagraphIndent}}"
    end
    def bullet
      blt=if @dob.indent
        indent=case @dob.indent
        when /1/ then '0em'
        when /2/ then '1.0em'
        when /3/ then '2.0em'
        when /4/ then '3.0em'
        when /5/ then '4.0em'
        when /6/ then '5.0em'
        when /7/ then '6.0em'
        when /8/ then '7.0em'
        when /9/ then '8.0em'
        else      '-1.0em'
        end
        "\\begin{Bullet}{#{indent}}$\\txtbullet$\\hspace{\\enspace}#{@dob.tmp}\\end{Bullet}"
      else
        "\\begin{Bullet}{-5mm}$\\txtbullet$\\hspace{\\enspace}#{@dob.tmp}\\end{Bullet}"
      end
      blt
    end
    def symbol_graphic
      dir=SiSU_Env::InfoEnv.new(@md.fns)
      image='c_' + /<:=\s*(\S+?)\s*>/m.match(@txt).captures.join + '.png' #watch
      if FileTest.file?("#{dir.path.image_source_include}/#{image}")
        @txt.gsub!(/<:=\s*(\S+?)\s*>/,
          "\\includegraphics*[width=11pt]{#{dir.path.image_source_include}/c_\\1.png}")
      else
        SiSU_Screen::Ansi.new(
          @md.opt.act[:color_state][:set],
          "ERROR - image:",
          %{"#{image}" missing},
          "search path: #{dir.path.image_source_include}"
        ).error2 unless @md.opt.act[:quiet][:set]==:on
        @txt.gsub!(/#{Mx[:lnk_o]}\S+\.(png|jpg|gif).+?#{Mx[:lnk_c]}#{Mx[:url_o]}\S+?#{Mx[:url_c]}/,'') # fragile match operator\\ fragile !
      end
    end
    def url_str_internal(str,idx=nil)
      map_nametags=SiSU_Particulars::CombinedSingleton.instance.get_map_nametags(@md).nametags_map #p map_nametags
      rgx_url_internal=/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}#{Mx[:rel_o]}#?\S+?#{Mx[:rel_c]}/m
      while str =~/#{Mx[:lnk_o]}([^#{Mx[:lnk_o]}#{Mx[:lnk_c]}]+)#{Mx[:lnk_c]}#{Mx[:rel_o]}:(\S+?)#{Mx[:rel_c]}/m
        link,url=$1,$2
        link,url=link.strip,url.strip
        link.gsub!(/&/,"#{Xx[:protect]}&")
        url="#{@env.url.root}/" + url
        str.sub!(/#{Mx[:lnk_o]}[^#{Mx[:lnk_o]}#{Mx[:lnk_c]}]+#{Mx[:lnk_c]}#{Mx[:rel_o]}:\S+?#{Mx[:rel_c]}/m,
          "#{url_decoration.tex_open}\\href{#{url}}{#{link}}#{url_decoration.tex_close}")
      end
      while str =~/#{Mx[:lnk_o]}([^#{Mx[:lnk_o]}#{Mx[:lnk_c]}]+)#{Mx[:lnk_c]}#{Mx[:rel_o]}#?(\S+?)#{Mx[:rel_c]}/m
        link,url=$1,$2
        link,url=link.strip,url.strip
        link.gsub!(/&/,"#{Xx[:protect]}&")
        url.gsub!(/\\_/,'_')
        ocn_lnk=if map_nametags[url] \
        and map_nametags[url][:ocn]
          map_nametags[url][:ocn]
        else nil
        end
        ocn_lnk=(url=~/^\d+$/ ? url : ocn_lnk)
        if ocn_lnk and not ocn_lnk.empty?
          idx \
          ? (str.sub!(rgx_url_internal,"\\hyperlink{#{ocn_lnk}}{#{link}}"))
          : (str.sub!(rgx_url_internal,"#{url_decoration.tex_open}\\hyperlink{#{ocn_lnk}}{#{link}}#{url_decoration.tex_close}"))
        else
          puts %{name tag: "#{url}" not found}
          str.sub!(rgx_url_internal,"#{link}")
        end
        #[keep] code that follows uses nametags directly, currently nametags converted to their ocn, related code: |texpdf.rb|@|hypertargets|
        #idx \
        #? (str.sub!(rgx_url_internal,"\\hyperlink{#{url}}{#{link}}")) \
        #: (str.sub!(rgx_url_internal,"#{url_decoration.tex_open}\\hyperlink{#{url}}{#{link}}#{url_decoration.tex_close}"))
      end
      str=str.gsub(/#{Xx[:protect]}/,'')
    end
    def url_str(str)
      rgx_url_generic=/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}#{Mx[:url_o]}\S+?#{Mx[:url_c]}/m
      while str =~rgx_url_generic
        if str=~rgx_url_generic
          regx_url=%r/#{Mx[:lnk_o]}(.+?)#{Mx[:lnk_c]}#{Mx[:url_o]}(\S+?)#{Mx[:url_c]}/m
          z,url=regx_url.match(str).captures if str =~regx_url
          url=url.strip
          link=z.strip
          link.gsub!(/&/,"#{Xx[:protect]}&")
          str.sub!(rgx_url_generic,"#{url_decoration.tex_open}\\href{#{url}}{#{link}}#{url_decoration.tex_close}")
          str=str.gsub(/#{Xx[:protect]}/,'')
          str
        else str
        end
        str
      end
      str
    end
    def url_with_txt(dob)
      rgx_url_generic=/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}#{Mx[:url_o]}\S+?#{Mx[:url_c]}/m
      while dob.tmp =~rgx_url_generic
        if dob.tmp=~rgx_url_generic
          if dob.tmp =~/#{Mx[:lnk_o]}(?:.+?)#{Mx[:lnk_c]}#{Mx[:url_o]}\S+?#{Mx[:url_c]}/m
            regx_url=%r/#{Mx[:lnk_o]}(.+?)#{Mx[:lnk_c]}#{Mx[:url_o]}(\S+?)#{Mx[:url_c]}/m
            punctuate=/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}#{Mx[:url_o]}\S+?#{Mx[:url_c]}/m.match(dob.tmp).captures.join
          else
            regx_url=%r/#{Mx[:lnk_o]}(.+?)#{Mx[:lnk_c]}#{Mx[:url_o]}(\S+?)#{Mx[:url_c]}/m
            punctuate=''
          end
          z,url=regx_url.match(dob.tmp).captures if dob.tmp =~regx_url
          url=url.strip
          link=z.strip
          link.gsub!(/&/,"#{Xx[:protect]}&")
          dob.tmp.sub!(rgx_url_generic,"#{url_decoration.tex_open}\\href{#{url}}{#{link}}#{url_decoration.tex_close}#{punctuate}")
          dob.tmp.gsub!(/#{Xx[:protect]}/,'')
          #dob.tmp=dob.tmp.sub(rgx_url_generic,"#{url_decoration.tex_open}\\href{#{url}}{#{link}}#{url_decoration.tex_close}#{punctuate}").
          #  gsub(/#{Xx[:protect]}/,'')
          dob
        else dob
        end
        dob
      end
      dob
    end
    def urls_txt_and_images
      dob=@dob
      dir=SiSU_Env::InfoEnv.new(@md.fns)
      @dm={
        'a4'=>     @tx.a4.landscape.img_px,
        'letter'=> @tx.letter.landscape.img_px,
        'legal'=>  @tx.legal.landscape.img_px,
        'b5'=>     @tx.b5.landscape.img_px,
        'a5'=>     @tx.a5.landscape.img_px
      }
      images_hash={ }
      generic_rgx=/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}(?:#{Mx[:url_o]}\S+?#{Mx[:url_c]}|image\b)/m
      rgx_url_generic=/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}#{Mx[:url_o]}\S+?#{Mx[:url_c]}/m
      #url_bare_rgx=/#{Mx[:url_o]}\S+?#{Mx[:url_c]}/m
      url_image_rgx=/#{Mx[:lnk_o]}[a-zA-Z0-9_\\-]+\.(?:png|jpg|gif).+?#{Mx[:lnk_c]}#{Mx[:url_o]}\S+?#{Mx[:url_c]}/m
      image_rgx=/#{Mx[:lnk_o]}[a-zA-Z0-9_\\-]+\.(?:png|jpg|gif).+?#{Mx[:lnk_c]}image/m
      @md.papersize_array.each do |ps|
        images_hash[ps] = dob.tmp
        while images_hash[ps] =~generic_rgx
          if dob.tmp =~rgx_url_generic \
          and dob.tmp !~/\.(?:png|jpg|gif)|#{Mx[:lnk_c]}image\b/m
            dob=url_with_txt(dob)
          elsif images_hash[ps]=~generic_rgx
            if dob.tmp=~rgx_url_generic
              if images_hash[ps] =~/#{Mx[:lnk_o]}(?:.+?)#{Mx[:lnk_c]}#{Mx[:url_o]}\S+?#{Mx[:url_c]}/m
                regx_url=%r/#{Mx[:lnk_o]}(.+?)#{Mx[:lnk_c]}#{Mx[:url_o]}(\S+?)#{Mx[:url_c]}/m
                punctuate=/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}#{Mx[:url_o]}\S+?#{Mx[:url_c]}/m.match(images_hash[ps]).captures.join
              else
                regx_url=%r/#{Mx[:lnk_o]}(.+?)#{Mx[:lnk_c]}#{Mx[:url_o]}(\S+?)#{Mx[:url_c]}/m
                punctuate=''
              end
              z,url=regx_url.match(images_hash[ps]).captures if images_hash[ps] =~regx_url
              url=url.strip
            else
              if images_hash[ps] =~/#{Mx[:lnk_o]}(?:.+?)#{Mx[:lnk_c]}image\.[^'"\s]+?(?:[;.,]?(?:\s|$)|(?:\s|$))/m
                regx_url=%r/#{Mx[:lnk_o]}(.+?)#{Mx[:lnk_c]}image\.[^'"\s]+?(?:[;.,]?(?:\s|$)|(?:\s|$))/m
                punctuate=/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}image\.[^'"\s]+?([;.,]?(?:\s|$))/m.match(images_hash[ps]).captures.join
              else
                regx_url=%r/#{Mx[:lnk_o]}(.+?)#{Mx[:lnk_c]}image/m
                punctuate=''
              end
              z=regx_url.match(images_hash[ps])[1] if images_hash[ps] =~regx_url
              url=''
            end
            if images_hash[ps] =~/#{Mx[:lnk_o]}\s*\S+\.?(?:png|jpg|gif)/m \
            and images_hash[ps]=~/\s+\d+x\d+(\s+|\s*#{Mx[:lnk_c]})/m
              image=z.scan(/\S+/)[0] #image,x,y=z.scan(/\S+/)
              image.gsub!(/\\/,'')
              w=((z =~/\s(\d+)x\d*/) ? z[/\s(\d+)x\d*/,1] : 200)
              width={}
              width['a4'] =     ((w.to_i > @dm['a4'])     ? @dm['a4'] :     w)
              width['letter'] = ((w.to_i > @dm['letter']) ? @dm['letter'] : w)
              width['legal'] =  ((w.to_i > @dm['legal'])  ? @dm['legal'] :  w)
              width['a5'] =     ((w.to_i > @dm['a5'])     ? @dm['a5'] :     w)
              width['b5'] =     ((w.to_i > @dm['b5'])     ? @dm['b5'] :     w)
              c=z[/``(.+?)''/m,1]
              hsp="\n{\\color{mywhite} .}&~\n" # ~ character for hardspace
              caption=(c ?  "{\\\\\ \n\\begin{scriptsize}#{hsp*3}#{c}\\end{scriptsize}&}" : '')
            elsif images_hash[ps] =~/#{Mx[:lnk_o]}\s*(\S+\.?\.(?:png|jpg|gif))/m
              SiSU_Screen::Ansi.new(
                @md.opt.act[:color_state][:set],
                %{document built without image: "#{$1}" as image dimensions not provided (either image not found or neither imagemagick nor graphicsmagick is installed)?\n}
              ).print_grey #unless @md.opt.act[:quiet][:set]==:on
              images_hash[ps].gsub!(/#{Mx[:lnk_o]}\s*(\S+\.?\.(?:png|jpg|gif))/,'[image]')
            end
            if image #most images fc etc. #% clean up !
              if FileTest.file?("#{dir.path.image_source_include}/#{image}")
                case images_hash[ps]
                when url_image_rgx
                  images_hash[ps].sub!(url_image_rgx,
                    "#{@center_begin}\\\n\\href{#{url}}\n{\\includegraphics*[width=#{width[ps]}pt]{#{dir.path.image_source_include}/#{image}}}#{caption}#{@center_end}")
                when image_rgx
                  images_hash[ps].sub!(image_rgx,
                    "#{@center_begin}\\\n\\includegraphics*[width=#{width[ps]}pt]{#{dir.path.image_source_include}/#{image}}#{caption}#{@center_end}")
                end
                images_hash[ps]
              elsif @md.opt.f_pth[:pth] =~/\/\S+?\/sisupod\/\S+?\/sisupod\/doc/
                pt=/(\/\S+?\/sisupod\/\S+?\/sisupod)\/doc/.match(@md.opt.f_pth[:pth])[1]
                img_src=pt + '/image'
                if FileTest.file?("#{img_src}/#{image}")
                  case images_hash[ps]
                  when url_image_rgx
                    images_hash[ps].sub!(url_image_rgx,
                      "#{@center_begin}\\\n\\href{#{url}}{\\includegraphics*[width=#{width[ps]}pt]{#{img_src}/#{image}}}#{caption} #{@center_end}")
                  when image_rgx
                    images_hash[ps].sub!(image_rgx,
                      "#{@center_begin}\\\n\\includegraphics*[width=#{width[ps]}pt]{#{img_src}/#{image}}#{caption} #{@center_end}")
                  end
                  images_hash[ps]
                end

              elsif @md.fns =~/\.(?:ssm\.)?sst$/ \
              and FileTest.file?("#{dir.path.image_source_include_local}/#{image}")
                case images_hash[ps]
                when url_image_rgx
                  images_hash[ps].sub!(url_image_rgx,
                    "#{@center_begin}\\\n\\href{#{url}}{\\includegraphics*[width=#{width[ps]}pt]{#{dir.path.image_source_include_local}/#{image}}}#{caption} #{@center_end}")
                when image_rgx
                  images_hash[ps].sub!(image_rgx,
                    "#{@center_begin}\\\n\\includegraphics*[width=#{width[ps]}pt]{#{dir.path.image_source_include_local}/#{image}}#{caption} #{@center_end}")
                end
                images_hash[ps]
              elsif @md.fns =~/\.-ss[tm]$/ \
              and FileTest.file?("#{dir.path.image_source_include_remote}/#{image}")
                case images_hash[ps]
                when url_image_rgx
                  images_hash[ps].sub!(url_image_rgx,
                    "#{@center_begin}\\\n\\href{#{url}}{\\includegraphics*[width=#{width[ps]}pt]{#{dir.path.image_source_include_remote}/#{image}}}#{caption}#{@center_end}")
                when image_rgx
                  images_hash[ps].sub!(image_rgx,
                    "#{@center_begin}\\\n\\includegraphics*[width=#{width[ps]}pt]{#{dir.path.image_source_include_remote}/#{image}}#{caption}#{@center_end}")
                end
                images_hash[ps]
              else
                SiSU_Screen::Ansi.new(
                  @md.opt.act[:color_state][:set],
                  "ERROR - image:",
                  %{"#{image}" missing},
                  "search locations: #{dir.path.image_source_include_local}, #{dir.path.image_source_include_remote} and #{dir.path.image_source_include}"
                ).error2 unless @md.opt.act[:quiet][:set]==:on
                if images_hash[ps] =~url_image_rgx \
                or images_hash[ps] =~image_rgx
                  images_hash[ps]=''
                end
                images_hash[ps]
              end
            else
              link=z.strip #[/(.+?)\\/m,1]
              images_hash[ps]="\\href{#{url}}{#{link}}#{punctuate}" if images_hash[ps] =~/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}#{Mx[:url_o]}\S+?#{Mx[:url_c]}/
              images_hash[ps]
            end
          else images_hash[ps]
          end
          images_hash[ps] #=ocn_display(dob) + images_hash[ps]
        end #while loop
        images_hash
      end
      use_images_hash={}
      images_hash.each do |k,t|
        use_images_hash[k]={ l: t, p: t}
      end
      dob.tmp=use_images_hash
      dob
    end
    def title
      title=SiSU_TeX_Pdf::SpecialCharacters.new(@md,@md.title.full).special_characters_safe
      "\n\\title{#{title}}"
    end
    def title_landscape
      title
    end
    def title_portrait
      title
    end
  end
  class FormatHead
    require_relative 'prog_text_translation'        # prog_text_translation.rb
    def initialize(md,t_o)
      @md,@t_o=md,t_o
      @env=SiSU_Env::InfoEnv.new(@md.fns)
      if t_o.is_a?(Hash)
        @txt =t_o[:txt]            || nil
        @subtitle=t_o[:subtitle]   || nil
        @ps=t_o[:paper_size]       || nil
        @ocn=t_o[:ocn]             || nil
        @layout=t_o[:orientation]  || nil
      else
        p t_o.class
        p caller
      end
      @tx=SiSU_Env::GetInit.new.tex
      @tex2pdf=@@tex3pdf ||=SiSU_Env::SystemCall.new.tex2pdf_engine
      @ps=@txt if @txt=~/(?:a4|letter|legal|book|a5|b5)/i
      @lang ||=SiSU_i18n::Languages.new #.list[@md.opt.lng][:xlp]
      @author=if defined? @md.creator.author \
      and @md.creator.author=~/\S+/
        SiSU_TeX_Pdf::SpecialCharacters.new(@md,@md.creator.author).special_characters_safe
      else ''
      end
      @subject=if defined? @md.classify.subject \
      and @md.classify.subject=~/\S+/
        SiSU_TeX_Pdf::SpecialCharacters.new(@md,@md.classify.subject).special_characters_safe
      else ''
      end
      @keywords=if defined? @md.classify.keywords \
      and @md.classify.keywords=~/\S+/
        SiSU_TeX_Pdf::SpecialCharacters.new(@md,@md.classify.keywords).special_characters_safe
      else ''
      end
    end
    def tex_head_lang #babel 18n
      lang_char_arr=@md.i18n
      mainlang_char=if @md.i18n == Array \
      and @md.i18n.length > 0
        lang_char_arr.slice(0)
      else @md.opt.lng
      end
      mainlang=@lang.list[mainlang_char][:xlp]
      otherlang=if mainlang != 'english'
        [ @lang.list['en'][:xlp] ]
      else []
      end
      if lang_char_arr.length > 0
        lang_char_arr.slice(1..9).each { |ch| otherlang << @lang.list[ch][:xlp] }
        otherlang=otherlang.uniq
      end
      otherlang=otherlang.join(',')
      { mainlang: mainlang, otherlang: otherlang }
    end
    def tex_head_encode
      texpdf_fontface=if defined? @md.make.texpdf_fontface.main \
      and not @md.make.texpdf_fontface.main.nil? \
      and @md.make.texpdf_fontface.main=~/\S{3,}/
        @md.make.texpdf_fontface.main
      else @env.font.texpdf.main
      end
      texpdf_fontface_sans=if defined? @md.make.texpdf_fontface.sans \
      and not @md.make.texpdf_fontface.sans.nil? \
      and @md.make.texpdf_fontface.sans=~/\S{3,}/                                  # not used
        @md.make.texpdf_fontface.sans
      else @env.font.texpdf.sans
      end
      texpdf_fontface_serif=if defined? @md.make.texpdf_fontface.serif \
      and not @md.make.texpdf_fontface.serif.nil? \
      and @md.make.texpdf_fontface.serif=~/\S{3,}/                                 # not used
        @md.make.texpdf_fontface.serif
      else @env.font.texpdf.serif
      end
      texpdf_fontface_mono=if defined? @md.make.texpdf_fontface.mono \
      and not @md.make.texpdf_fontface.mono.nil? \
      and @md.make.texpdf_fontface.mono=~/\S{3,}/
        @md.make.texpdf_fontface.mono
      else @env.font.texpdf.mono
      end
      texpdf_fontface_cjk=if @md.opt.lng =~/zh/ \
      and defined? @md.make.texpdf_fontface.cjk_zh \
      and not @md.make.texpdf_fontface.cjk_zh.nil? \
      and @md.make.texpdf_fontface.cjk_zh=~/\S{3,}/
        @md.make.texpdf_fontface.cjk_zh
      elsif @md.opt.lng =~/ja/ \
      and defined? @md.make.texpdf_fontface.cjk_ja \
      and not @md.make.texpdf_fontface.cjk_ja.nil? \
      and @md.make.texpdf_fontface.cjk_ja=~/\S{3,}/
        @md.make.texpdf_fontface.cjk_ja
      elsif @md.opt.lng =~/ko/ \
      and defined? @md.make.texpdf_fontface.cjk_ko \
      and not @md.make.texpdf_fontface.cjk_ko.nil? \
      and @md.make.texpdf_fontface.cjk_ko=~/\S{3,}/
        @md.make.texpdf_fontface.cjk_ko
      elsif @md.opt.lng =~/(?:zh|ja|ko)/ \
      and defined? @md.make.texpdf_fontface.cjk \
      and not @md.make.texpdf_fontface.cjk.nil? \
      and @md.make.texpdf_fontface.cjk=~/\S{3,}/
        @md.make.texpdf_fontface.cjk
      else
        case @md.opt.lng
        when /zh/ then @env.font.texpdf.cjk_zh
        when /ja/ then @env.font.texpdf.cjk_ja
        when /ko/ then @env.font.texpdf.cjk_ko
        else @env.font.texpdf.cjk
        end
      end
      # you may wish to check selected font against available fonts:
      # fc-list :outline -f "%{family}\n"
      # fc-list :lang=ja
      case @tex2pdf
      when /xe/
        if @md.opt.lng =~/(?:zh|ja|ko)/
          <<-WOK
\\usepackage{ucs, fontspec, xltxtra, xunicode, xeCJK}
\\setmainCJKlanguage{#{tex_head_lang[:mainlang]}}
\\setCJKmainfont{#{texpdf_fontface_cjk}}
\\XeTeXlinebreaklocale "#{tex_head_lang[:mainlang]}"
\\XeTeXlinebreakskip = 0pt plus 1pt
\\setotherlanguage{#{tex_head_lang[:otherlang]}}
\\setmainfont{#{texpdf_fontface}}
\\setmonofont[Scale=0.85]{#{texpdf_fontface_mono}}
          WOK
        else
          <<-WOK
\\usepackage{polyglossia, ucs, fontspec, xltxtra, xunicode}
\\setmainlanguage{#{tex_head_lang[:mainlang]}}
\\setotherlanguage{#{tex_head_lang[:otherlang]}}
\\setmainfont{#{texpdf_fontface}}
\\setmonofont[Scale=0.85]{#{texpdf_fontface_mono}}
% \\setsansfont{#{texpdf_fontface_sans}}
% \\setromanfont{#{texpdf_fontface_serif}}
          WOK
        end
      when /pdf/
        if @md.file_encoding =~ /iso-?8859/i                                   #% iso8859
          <<-WOK
% \\usepackage[latin1]{inputenc}
\\usepackage{fontspec}
          WOK
        else                                                                   #% utf-8 assumed
        <<-WOK
\\usepackage{babel}
\\usepackage{ucs}
\\usepackage[utf8x]{inputenc}
          WOK
        end
      end
    end
    def tex_head_info
      generator="Generated by: #{@md.sisu_version[:project]} #{@md.sisu_version[:version]} of #{@md.sisu_version[:date_stamp]} (#{@md.sisu_version[:date]})" if @md.sisu_version[:version]
      lastdone="Last Generated on: #{Time.now}"
      rubyv="Ruby version: #{@md.ruby_version}"
      <<-WOK
%% SiSU (Linux & Ruby - \"better ways\") LaTeX output
%% #{generator}
%% #{rubyv}
%% LaTeX output
%% #{lastdone}
%% SiSU http://www.jus.uio.no/sisu
      WOK
    end
    def tex_head_paper_portrait(d)
      multicol=(@md.book_idx ? '\usepackage{multicol}' : '')
      <<-WOK
#{tex_head_info}
\\documentclass[#{d[:fontsize]},#{d[:papertype]},titlepage]{scrartcl}        %with titlepage
\\setlength{\\textheight}{#{d[:textheight]}mm} \\setlength{\\textwidth}{#{d[:textwidth]}mm}
\\setlength{\\oddsidemargin}{#{d[:oddsidemargin]}} \\setlength{\\evensidemargin}{#{d[:evensidemargin]}}
\\setlength{\\topmargin}{#{d[:topmargin]}} \\setlength{\\headheight}{#{d[:headheight]}}
\\setlength{\\headsep}{#{d[:headsep]}}
\\setlength{\\marginparsep}{#{d[:marginparsep]}}
\\setlength{\\marginparwidth}{#{d[:marginparwidth]}}
#{multicol}
      WOK
    end
    def tex_head_paper_landscape(d)
      <<-WOK
#{tex_head_info}
\\documentclass[#{d[:fontsize]},#{d[:papertype]},landscape,titlepage,twocolumn]{scrartcl}        %with titlepage
\\setlength{\\textheight}{#{d[:textheight]}mm} \\setlength{\\textwidth}{#{d[:textwidth]}mm}
\\setlength{\\oddsidemargin}{#{d[:oddsidemargin]}} \\setlength{\\evensidemargin}{#{d[:evensidemargin]}}
\\setlength{\\topmargin}{#{d[:topmargin]}} \\setlength{\\headheight}{#{d[:headheight]}}
\\setlength{\\headsep}{#{d[:headsep]}}
\\setlength{\\columnsep}{#{d[:columnsep]}}
\\setlength{\\marginparsep}{#{d[:marginparsep]}}
\\setlength{\\marginparwidth}{#{d[:marginparwidth]}}
      WOK
    end
    def tex_head_paper_portrait_dvi(d)
      <<-WOK
#{tex_head_info}
\\documentclass[#{d[:fontsize]},#{d[:papertype]},titlepage]{scrartcl}      %with titlepage
\\setlength{\\textheight}{#{d[:textheight]}mm} \\setlength{\\textwidth}{#{d[:textwidth]}mm}
\\setlength{\\oddsidemargin}{#{d[:oddsidemargin]}} \\setlength{\\evensidemargin}{#{d[:evensidemargin]}}
\\setlength{\\topmargin}{#{d[:topmargin]}} \\setlength{\\headheight}{#{d[:headheight]}}
\\setlength{\\headsep}{#{d[:headsep]}}
\\setlength{\\marginparsep}{#{d[:marginparsep]}}
\\setlength{\\marginparwidth}{#{d[:marginparwidth]}}
      WOK
    end
    def tex_head_paper_dimensions
      d={}
      fontsize_set=if defined? @env.font.texpdf.size(@md.opt.act[:pdf_font_size]) \
      and not @env.font.texpdf.size(@md.opt.act[:pdf_font_size]).nil?
        @env.font.texpdf.size(@md.opt.act[:pdf_font_size])
      else :na
      end
      case @layout
      when :portrait
        fontsize=(fontsize_set==:na) ? '11pt' : (fontsize_set + 'pt')
        d[:papertype],d[:fontsize]='a4paper',fontsize
        d[:oddsidemargin],d[:evensidemargin],d[:topmargin]='0mm','0mm','-12pt'
        d[:headheight],d[:headsep],d[:columnsep]='12pt','35pt',''
        d[:marginparsep],d[:marginparwidth]='4mm','8mm'
        case @ps #@md.papersize
        when /a4/i           #European default, SiSU default
          fontsize=(fontsize_set==:na) ? '12pt' : (fontsize_set + 'pt')
          d[:papertype],d[:fontsize]='a4paper',fontsize
          d[:textheight],d[:textwidth]=@tx.a4.portrait.h,@tx.a4.portrait.w
        when /letter/i   #U.S. default
          fontsize=(fontsize_set==:na) ? '12pt' : (fontsize_set + 'pt')
          d[:papertype],d[:fontsize]='letterpaper',fontsize
          d[:textheight],d[:textwidth]=@tx.letter.portrait.h,@tx.letter.portrait.w
        when /legal/i     #U.S. alternative
          fontsize=(fontsize_set==:na) ? '12pt' : (fontsize_set + 'pt')
          d[:papertype],d[:fontsize]='legalpaper',fontsize
          d[:textheight],d[:textwidth]=@tx.legal.portrait.h,@tx.legal.portrait.w
        when /book|b5/i   #book default - larger
          fontsize=(fontsize_set==:na) ? '11pt' : (fontsize_set + 'pt')
          d[:papertype],d[:fontsize]='b5paper',fontsize
          d[:oddsidemargin],d[:evensidemargin],d[:topmargin]='-4mm','-4mm','-36pt'
          d[:headheight],d[:headsep],d[:columnsep]='12pt','20pt',''
          d[:textheight],d[:textwidth]=@tx.b5.portrait.h,@tx.b5.portrait.w
        when /a5/i
          fontsize=(fontsize_set==:na) ? '11pt' : (fontsize_set + 'pt')
          d[:papertype],d[:fontsize]='a5paper',fontsize
          d[:oddsidemargin],d[:evensidemargin],d[:topmargin]='-4mm','-4mm','-36pt'
          d[:headheight],d[:headsep],d[:columnsep]='11pt','12pt',''
          d[:marginparsep],d[:marginparwidth]='4mm','6mm'
          d[:textheight],d[:textwidth]=@tx.a5.portrait.h,@tx.a5.portrait.w
        else           #default currently A4
          fontsize=(fontsize_set==:na) ? '12pt' : (fontsize_set + 'pt')
          d[:papertype],d[:fontsize]='a4paper',fontsize
          d[:textheight],d[:textwidth]=@tx.a4.portrait.h,@tx.a4.portrait.w
        end
      when :landscape
        fontsize=(fontsize_set==:na) ? '11pt' : (fontsize_set + 'pt')
        d[:papertype],d[:fontsize]='a4paper',fontsize
        d[:oddsidemargin],d[:evensidemargin],d[:topmargin]='6mm','6mm','-12mm'
        d[:headheight],d[:headsep],d[:columnsep]='12pt','20pt','40pt'
        d[:marginparsep],d[:marginparwidth]='4mm','8mm'
        case @ps #@md.papersize
        when /a4/i                            #European default, SiSU default
          fontsize=(fontsize_set==:na) ? '11pt' : (fontsize_set + 'pt')
          d[:papertype],d[:fontsize]='a4paper',fontsize
          d[:textheight],d[:textwidth]=@tx.a4.landscape.h,@tx.a4.landscape.w
        when /letter/i                    #U.S. default
          fontsize=(fontsize_set==:na) ? '11pt' : (fontsize_set + 'pt')
          d[:papertype],d[:fontsize]='letterpaper',fontsize
          d[:textheight],d[:textwidth]=@tx.letter.landscape.h,@tx.letter.landscape.w
        when /legal/i #U.S. alternative
          fontsize=(fontsize_set==:na) ? '11pt' : (fontsize_set + 'pt')
          d[:papertype],d[:fontsize],d[:columnsep]='legalpaper',fontsize,'48pt'
          d[:textheight],d[:textwidth]=@tx.legal.landscape.h,@tx.legal.landscape.w
        when /book|b5/i       #book default - larger
          fontsize=(fontsize_set==:na) ? '11pt' : (fontsize_set + 'pt')
          d[:papertype],d[:fontsize],d[:columnsep]='b5paper',fontsize,'35pt'
          d[:textheight],d[:textwidth]=@tx.b5.landscape.h,@tx.b5.landscape.w
        when /a5/i
          fontsize=(fontsize_set==:na) ? '10pt' : (fontsize_set + 'pt')
          d[:papertype],d[:fontsize],d[:columnsep]='a5paper',fontsize,'32pt'
          d[:textheight],d[:textwidth]=@tx.a5.landscape.h,@tx.a5.landscape.w
        else                            #default currently A4
          fontsize=(fontsize_set==:na) ? '12pt' : (fontsize_set + 'pt')
          d[:papertype],d[:fontsize]='a4paper',fontsize
          d[:textheight],d[:textwidth]=@tx.a4.landscape.h,@tx.a4.landscape.w
        end
      end
      d
    end
    def tex_head_paper
      case @layout
      when :portrait
        tex_head_paper_portrait(tex_head_paper_dimensions)
      when :landscape
        tex_head_paper_landscape(tex_head_paper_dimensions)
      end
    end
    def hyperlinks_monochrome
      <<-WOK
  colorlinks=true,
  urlcolor=myblack,
  filecolor=myblack,
  linkcolor=myblack,
      WOK
    end
    def hyperlinks_colored
      <<-WOK
  colorlinks=true,
  urlcolor=myblue,    % \\href{...}{...}   external url
  filecolor=mygreen,  % \\href{...}        local file
  linkcolor=myred,    % \\href{...} and \\pageref{...}
      WOK
    end
    def hyperlinks_color?
      case @layout
      when :portrait  then hyperlinks_monochrome
        if @env.texpdf_hyperlinks(@md.opt.act[:pdf_hyperlink_colors]).portrait != :na
          case @env.texpdf_hyperlinks(@md.opt.act[:pdf_hyperlink_colors]).portrait
          when :color then hyperlinks_colored
          when :mono  then hyperlinks_monochrome
          else p __LINE__.to_s + ':error'
          end
        else               hyperlinks_monochrome
        end
      when :landscape
        if @env.texpdf_hyperlinks(@md.opt.act[:pdf_hyperlink_colors]).landscape != :na
          case @env.texpdf_hyperlinks(@md.opt.act[:pdf_hyperlink_colors]).landscape
          when :color then hyperlinks_colored
          when :mono  then hyperlinks_monochrome
          else p __LINE__.to_s + ':error'
          end
        else               hyperlinks_colored
        end
      end
    end
    def tex_head_pdftex
      author=if defined? @md.creator.author \
      and @md.creator.author=~/\S+/
        SiSU_TeX_Pdf::SpecialCharacters.new(@md,@md.creator.author).special_characters_safe_no_urls
      else ''
      end
      <<-WOK
\\usepackage{alltt}
\\usepackage{thumbpdf}
\\usepackage[#{@tex2pdf},
  #{hyperlinks_color?.strip}
  pdftitle={#{@txt}},
  pdfauthor={#{author}},
  pdfsubject={#{@subject}},
  pdfkeywords={#{@keywords}},
  pageanchor=true,
  plainpages=true,
  pdfpagelabels=true,
  pagebackref,
  bookmarks=true,
  bookmarksopen=true,
  pdfmenubar=true,
  pdfpagemode=UseOutline,
  pdffitwindow=true,
  pdfwindowui=true,
  plainpages=false,
%  pdfusetitle=true,
%  pdfpagelayout=SinglePage,
%  pdfpagelayout=TwoColumnRight,
%  pdfpagelayout=TwoColumnLeft,
%  pdfstartpage=3,
  pdfstartview=FitH
]
{hyperref}
%% trace lost characters
% \\tracinglostchars = 1
% \\tracingonline = 1
\\usepackage[usenames]{color}
\\definecolor{myblack}{rgb}{0,0,0}
\\definecolor{myred}{rgb}{0.75,0,0}
\\definecolor{mygreen}{rgb}{0,0.5,0}
\\definecolor{myblue}{rgb}{0,0,0.5}
\\definecolor{mywhite}{rgb}{1,1,1}
\\usepackage{url}
\\urlstyle{sf}
%\\usepackage{breakurl}
        WOK
    end
    def tex_head_codeblock(codeblock_box_type)
      codeblock_box=if codeblock_box_type=='listings'
        <<-WOK
\\usepackage{listings}
\\usepackage{color}
\\usepackage{textcomp}
        WOK
      elsif codeblock_box_type=='boites'
        "\\usepackage{boites}"
      else
        "\\usepackage{boites}"
      end
      codeblock_box
    end
    def tex_head_misc
      <<-WOK
\\usepackage{textcomp}
\\usepackage[parfill]{parskip}
\\usepackage[normalem]{ulem}
\\usepackage{soul}
\\usepackage{longtable}
\\usepackage[tc]{titlepic}
\\usepackage{graphicx}
\\makeatletter
\\parindent0pt
%\\usepackage{mathptmx}
\\usepackage{amssymb}
% amssymb used for backslash
      WOK
    end
    def document_head_with_orientation(codeblock_box_type)
      endnotes=("\\usepackage{endnotes}" if @txt =~/endnotes?/) || '' #not implemented see also def endnotes
      @lang.list[@md.i18n[0]][:xlp]
      <<-WOK
#{tex_head_paper}
#{tex_head_encode}
#{tex_head_pdftex}
#{tex_head_misc}
#{tex_head_codeblock(codeblock_box_type)}
\\setcounter{secnumdepth}{2}
\\setcounter{tocdepth}{4}
\\makeatletter
#{endnotes}
\\usepackage[multiple,ragged]{footmisc}
\\setlength\\footnotemargin{12pt}
\\usepackage[para]{manyfoot}
\\DeclareNewFootnote{A}
%\\DeclareNewFootnote[para]{A}
\\newenvironment{ParagraphIndent}[1]%
{
\\begin{list}{}{%
\\setlength\\topsep{0pt}%
\\addtolength{\\leftmargin}{#1}
\\setlength\\parsep{0pt plus 1pt}%
}
\\item[]
}
{\\end{list}}

\\newenvironment{ParagraphHang}[2]%
{
\\begin{list}{}{%
\\setlength\\topsep{0pt}%
\\addtolength{\\leftmargin}{#1}
\\itemindent=#2
\\setlength\\parsep{0pt plus 1pt}%
}
\\item[]
}
{\\end{list}}

\\newenvironment{Bullet}[1]%
{
\\begin{list}{}{%
\\setlength\\topsep{0pt}%
\\addtolength{\\leftmargin}{#1}
\\itemindent=-1em
\\setlength\\parsep{0pt plus 1pt}%
}
\\item[]
}
{\\end{list}}
\\usepackage{fancyhdr}
\\lhead{}
\\renewcommand{\\part}{\\\@startsection
  {part}{1}{-2mm}%
  {-\\baselineskip}{0.5\\baselineskip}%
  {\\bfseries\\large\\upshape\\raggedright}}
\\renewcommand{\\section}{\\\@startsection
  {section}{2}{-2mm}%
  {-\\baselineskip}{0.5\\baselineskip}%
  {\\bfseries\\large\\upshape\\raggedright}}
\\renewcommand{\\subsection}{\\\@startsection
  {subsection}{3}{-2mm}%
  {-\\baselineskip}{0.5\\baselineskip}%
  {\\bfseries\\large\\upshape\\raggedright}}
\\renewcommand{\\subsubsection}{\\\@startsection
  {subsubsection}{4}{-2mm}%
  {-\\baselineskip}{0.5\\baselineskip}%
  {\\normalfont\\normalsize\\bfseries\\raggedright}}
\\renewcommand{\\paragraph}{\\\@startsection
  {paragraph}{5}{-2mm}%
  {-\\baselineskip}{0.5\\baselineskip}%
  {\\normalfont\\normalsize\\itshape\\raggedright}}
\\renewcommand{\\subparagraph}{\\\@startsection
  {subparagraph}%{6}%{-2mm}%
  {-\\baselineskip}{0.5\\baselineskip}%
  {\\normalfont\\normalsize\\itshape\\raggedright}}
% \\makeatother
\\selectlanguage{#{@lang.list[@md.i18n[0]][:xlp]}}
      WOK
    end
    def a4generic
    end
  end
  class SpecialCharacters
    include SiSU_Parts_TeXpdf
    def initialize(md,str,is=:default)
      @md,@txt,@is=md,str,is
      @tex2pdf=@@tex3pdf ||=SiSU_Env::SystemCall.new.tex2pdf_engine
    end
    def xetex_code_listings(str,is=:default)                                 # ~ ^ $ & % _ { }  #LaTeX special characters - KEEP list
      word=str.scan(/\S+|\n/) #unless line =~/^(?:@\S|%+\s)/
      para_array=[]
      str=if word
        word.each do |w| # _ - / # | : ! ^ ~
          w=w.gsub(/#{Mx[:gl_o]}#lt#{Mx[:gl_c]}/,'<').gsub(/#{Mx[:gl_o]}#gt#{Mx[:gl_c]}/,'>').
            gsub(/[\\]?~/,'~').
            gsub(/[#{Mx[:br_line]}#{Mx[:br_paragraph]}]/,"\n").              #watch
            gsub(/#{Mx[:gl_o]}#(?:126|152)#{Mx[:gl_c]}/,'~').                #126 usual
            gsub(/\\?\||#{Mx[:gl_o]}#124#{Mx[:gl_c]}/,'|')                   #unless is=='code' #unless w=~/<~\d+;(?:[ohmu]|[0-6]:)\d+;\w\d+>/ # | SiSU not really special sisu character but done, also LaTeX
          para_array << w
        end
        str=para_array.join(' ')
        str=str.strip unless is==:code
        str
      else ''
      end
      str=str.gsub(/\s*#{Mx[:mk_o]}:name#\S+?#{Mx[:mk_c]}\s*/,' ').
        gsub(/.+?<-#>/,'').
        gsub(/#{Mx[:br_eof]}/,'').
        gsub(/#{Mx[:br_endnotes]}/,'').
      #problem sequence ->
        gsub(/&(?:lt|#060);/,'<').                                           # < SiSU special character also LaTeX
        gsub(/#{Mx[:gl_o]}#(?:gt|062)#{Mx[:gl_c]}/,'>').                     # > SiSU special character also LaTeX
        gsub(/#{Mx[:gl_o]}#123#{Mx[:gl_c]}/,'{').                            # { SiSU special character also LaTeX
        gsub(/#{Mx[:gl_o]}#125#{Mx[:gl_c]}/,'}').                            # } SiSU special character also LaTeX
        gsub(/#{Mx[:gl_o]}#(?:126|152)#{Mx[:gl_c]}/,'~').                    # ~ SiSU special character also LaTeX
        gsub(/#{Mx[:gl_o]}#035#{Mx[:gl_c]}/,'#').                            # SiSU special character also LaTeX
        gsub(/#{Mx[:gl_o]}#033#{Mx[:gl_c]}/,'!').                            # ! SiSU not really special sisu character but done, also LaTeX
       #gsub(/(^|\s)\*\s/,'\1\asterisk ').                                   # * should you wish to escape astrisk e.g. describing \*{bold}*
        gsub(/#{Mx[:gl_o]}#042#{Mx[:gl_c]}/,'*').                            # * should you wish to escape astrisk e.g. describing \*{bold}*
        gsub(/#{Mx[:gl_o]}#045#{Mx[:gl_c]}/,'-').                            # - SiSU special character also LaTeX
        gsub(/#{Mx[:gl_o]}#043#{Mx[:gl_c]}/,'+').                            # + SiSU special character also LaTeX
        gsub(/#{Mx[:gl_o]}#044#{Mx[:gl_c]}/,',').                            # + SiSU special character also LaTeX
        gsub(/#{Mx[:gl_o]}#038#{Mx[:gl_c]}/,'&').                            #unless @txt=~/<:code>/  # / SiSU special character also LaTeX
        gsub(/#{Mx[:gl_o]}#047#{Mx[:gl_c]}/,'/').                            # / SiSU special character also LaTeX
        gsub(/#{Mx[:gl_o]}#092#{Mx[:gl_c]}/,'\\').                           # \ SiSU special character also LaTeX
        gsub(/#{Mx[:gl_o]}#095#{Mx[:gl_c]}/,'_').                            # _ SiSU special character also LaTeX
        gsub(/#{Mx[:gl_o]}#124#{Mx[:gl_c]}/,'|').                            # | SiSU not really special sisu character but done, also LaTeX
        gsub(/#{Mx[:gl_o]}#058#{Mx[:gl_c]}/,':').                            # : SiSU not really special sisu character but done, also LaTeX
        gsub(/#{Mx[:gl_o]}#094#{Mx[:gl_c]}|\^/,'^').                         # ^ SiSU not really special sisu character but done, also LaTeX
      ##watch placement, problem sequence ^
        gsub(/<sup><font face=symbol>&atild;<\/font><\/sup>/,' ').
        gsub(/\\copy(right|mark)?/,'<=copymark>')                            # ok problem with superscript
    end
    def xetex_special_characters_1(str,is=:default)                          # ~ ^ $ & % _ { }  #LaTeX special characters - KEEP list
      word=str.scan(/\S+|\n/) #unless line =~/^(?:@\S|%+\s)/
      para_array=[]
      str=if word
        word.each do |w| # _ - / # | : ! ^ ~
          if w !~/https?:/ \
          and w=~/\/\S+?\// \
          and w.length > 6
            w=w.gsub(/([_.\/])/,'\1\-')
          end
          w=w.gsub(/#{Mx[:gl_o]}#lt#{Mx[:gl_c]}/,'<').gsub(/#{Mx[:gl_o]}#gt#{Mx[:gl_c]}/,'>').
            gsub(/[\\]?~/,'<=tilde>').
            gsub(/[#{Mx[:br_line]}#{Mx[:br_paragraph]}]/,' \newline ').      #watch
            gsub(/#{Mx[:gl_o]}#(?:126|152)#{Mx[:gl_c]}/,'<=tilde>').         #126 usual
            gsub(/\\?\||#{Mx[:gl_o]}#124#{Mx[:gl_c]}/,'\pipe')               #unless is=='code' #unless w=~/<~\d+;(?:[ohmu]|[0-6]:)\d+;\w\d+>/ # | SiSU not really special sisu character but done, also LaTeX
          if w !~/#{Mx[:rel_o]}/ \
          and w !~/#{Mx[:gl_o]}#/
            w=w.gsub(/\#/,'<=hash>')
          end
          para_array << w
        end
        str=para_array.join(' ')
        str=str.strip unless is==:code
        str
      else ''
      end
      str=str.gsub(/\s*#{Mx[:mk_o]}:name#\S+?#{Mx[:mk_c]}\s*/,' ').
        gsub(/.+?<-#>/,'').
        gsub(/#{Mx[:br_eof]}/,'').
        gsub(/#{Mx[:br_endnotes]}/,'')
      #problem sequence ->
      str=str.gsub(/&(?:nbsp);|#{Mx[:nbsp]}/,'\hardspace') unless is==:code  # < SiSU special character also LaTeX
      str=str.gsub(/&(?:lt|#060);/,'\lt').                                   # < SiSU special character also LaTeX
        gsub(/#{Mx[:gl_o]}#(?:gt|062)#{Mx[:gl_c]}/,'\gt').                   # > SiSU special character also LaTeX
        gsub(/#{Mx[:gl_o]}#123#{Mx[:gl_c]}/,'\curlyopen').                   # { SiSU special character also LaTeX
        gsub(/#{Mx[:gl_o]}#125#{Mx[:gl_c]}/,'\curlyclose').                  # } SiSU special character also LaTeX
        gsub(/#{Mx[:gl_o]}#(?:126|152)#{Mx[:gl_c]}/,'<=tilde>').             # ~ SiSU special character also LaTeX
        gsub(/#{Mx[:gl_o]}#035#{Mx[:gl_c]}/,'\#').                           # # SiSU special character also LaTeX
        gsub(/#{Mx[:gl_o]}#033#{Mx[:gl_c]}/,'!').                            # ! SiSU not really special sisu character but done, also LaTeX
        gsub(/(^|\s)\*\s/,'\1\asterisk ').                                   # * should you wish to escape astrisk e.g. describing \*{bold}*
        gsub(/#{Mx[:gl_o]}#042#{Mx[:gl_c]}/,'\*').                           # * should you wish to escape astrisk e.g. describing \*{bold}*
        gsub(/#{Mx[:gl_o]}#045#{Mx[:gl_c]}/,'-').                            # - SiSU special character also LaTeX
        gsub(/#{Mx[:gl_o]}#043#{Mx[:gl_c]}/,'+').                            # + SiSU special character also LaTeX
        gsub(/#{Mx[:gl_o]}#044#{Mx[:gl_c]}/,',').                            # + SiSU special character also LaTeX
        gsub(/#{Mx[:gl_o]}#038#{Mx[:gl_c]}/,'<=amp>'). #unless @txt=~/<:code>/  # / SiSU special character also LaTeX
        gsub(/#{Mx[:gl_o]}#047#{Mx[:gl_c]}/,'\slash').                       # / SiSU special character also LaTeX
        gsub(/#{Mx[:gl_o]}#092#{Mx[:gl_c]}/,'\textbackslash').               # \ SiSU special character also LaTeX
        gsub(/#{Mx[:gl_o]}#095#{Mx[:gl_c]}/,'<=underscore>').                # _ SiSU special character also LaTeX
        gsub(/#{Mx[:gl_o]}#124#{Mx[:gl_c]}/,'|').                            # | SiSU not really special sisu character but done, also LaTeX
        gsub(/#{Mx[:gl_o]}#058#{Mx[:gl_c]}/,':').                            # : SiSU not really special sisu character but done, also LaTeX
        gsub(/#{Mx[:gl_o]}#094#{Mx[:gl_c]}|\^/,'\caret').                    # ^ SiSU not really special sisu character but done, also LaTeX
      ##watch placement, problem sequence ^
        gsub(/<sup><font face=symbol>&atild;<\/font><\/sup>/,' ').
        gsub(/\\copy(right|mark)?/,'<=copymark>') # ok problem with superscript
    end
    def xetex_special_characters_2(str,is=:default)
      str=str.gsub(/#{Mx[:gl_o]}#156#{Mx[:gl_c]}/,'\oe ').
        gsub(/\$/,'\$').
        gsub(/\#/,'\#').
        gsub(/\%/,'\%').
        gsub(/\~/,'\~') #revist, should not be necessary to mark remaining tildes
      if str !~/^\s*#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}image\s/
        str=str.gsub(/_/,'\_')
      end
      str=str.gsub(/\{/,'\{').
        gsub(/\}/,'\}')
      str=if is==:code
        str.gsub(/&/,'{\\\&}').
          gsub(/\\~(\\\{)/,'{$\tilde$}\1').
          gsub(/(\\\})\\~/,'\1{$\tilde$}').
          gsub(/\\~(\[)/,'{$\tilde$}\1').
          gsub(/(\])\\~/,'\1{$\tilde$}').
          gsub(/<=tilde>/,'{$\tilde$}').
          gsub(/<=hash>/,'{\#}')
      else
        str.gsub(/&nbsp;|#{Mx[:nbsp]}/,'~'). # ~ character for hardspace
          gsub(/&/,'<=amp>')
      end
      str=str.gsub(/&\S+?;/,' ').
        gsub(/§/u,'\S'). #latex: space between next character not preserved? #str.gsub(/§ /,'\S ')
        gsub(/£/u,'\pounds').
        gsub(/<a href=".+?">/,' ').
        gsub(/<\/a>/,' ')
      unless is==:no_urls
        str=str.gsub(/((?:^|\s)#{Mx[:lnk_c]})#{Mx[:url_o]}(\S+?)#{Mx[:url_c]}/,
            '\1\begin{scriptsize}\url{\2}\end{scriptsize}\3'). #special case \{ e.g. \}http://url
          gsub(/#{Mx[:url_o]}\\_(\S+?)#{Mx[:url_c]}/,
            '\begin{scriptsize}\url{\1}\end{scriptsize}'). #special case \{ e.g. \}http://url
          gsub(/#{Mx[:url_o]}_(\S+?)#{Mx[:url_c]}/,
            '\begin{scriptsize}\\url{\1}\end{scriptsize}') #specially escaped url no decoration
      end
      if is !=:code \
      and is !=:no_urls
        str=str.gsub(/(^|#{Mx[:gl_c]}|\s)((?:https?|file|ftp):\/\/\S+?\.[^'"\s]+?)([;.,]?(?=\s|$))/,
          "\\1#{url_decoration.tex_open}\\begin{scriptsize}\\url{\\2}\\end{scriptsize}#{url_decoration.tex_close}\\3") #url matching with decoration <url> positive lookahead, sequence issue with { linked }http://url cannot use \b at start
      end
      str=str.gsub(/<:ee>/,'').
        gsub(/<!>/,' ').  #proposed change, insert, but may be redundant
        gsub(/<(br|p)>|<\/\s*(br|p)>|<(br|p)\s*\/>/," #{Tex[:backslash]*2} "). # Work Area
        gsub(/#{Mx[:fa_bold_o]}(.+?)#{Mx[:fa_bold_c]}/,'\begin{bfseries}\1 \end{bfseries}').
        gsub(/<h\d+>(.+?)<\/h\d+>/,'\begin{bfseries}\1 \end{bfseries}').
        gsub(/#{Mx[:fa_italics_o]}(.+?)#{Mx[:fa_italics_c]}/,'\emph{\1}').
        gsub(/#{Mx[:fa_underscore_o]}(.+?)#{Mx[:fa_underscore_c]}/,'\uline{\1}'). # ulem
        gsub(/#{Mx[:fa_cite_o]}(.+?)#{Mx[:fa_cite_c]}/,"``\\1''"). # quote #CHECK
        gsub(/#{Mx[:fa_insert_o]}(.+?)#{Mx[:fa_insert_c]}/,'\uline{\1}'). # ulem
        gsub(/#{Mx[:fa_strike_o]}(.+?)#{Mx[:fa_strike_c]}/,'\sout{\1}'). # ulem
        gsub(/#{Mx[:fa_superscript_o]}(.+?)#{Mx[:fa_superscript_c]}/,"\$^{\\textrm{\\1}}\$").
        gsub(/#{Mx[:fa_subscript_o]}(.+?)#{Mx[:fa_subscript_c]}/,"\$_{\\textrm{\\1}}\$").
        gsub(/#{Mx[:fa_monospace_o]}(.+?)#{Mx[:fa_monospace_c]}/,'\begin{monosp}\1\end{monosp}')
      unless is==:code
        str=str.gsub(/"(.+?)"/,'“\1”').  # quote marks / quotations open & close " need condition exclude for code
          gsub(/\s+"/,' “').                                # open "
          gsub(/^(#{Mx[:lv_o]}[1-6-]:\S*?#{Mx[:lv_c]}|<.+?>)?\s*"/,'\1“'). #fix Mx[:lv_o] # open "
          gsub(/"(\s|\.|,|:|;)/,'”\1').                     # close "
          gsub(/"(#{Mx[:lv_o]}[1-6-]:\S*?#{Mx[:lv_c]}|<.+?>)?\s*$/,'”\1'). #fix Mx[:lv_o] # close "
          gsub(/"(\.|,)/,'”').                              # close "
          gsub(/\s+'/,' `').                                # open '
          gsub(/^(#{Mx[:lv_o]}[1-6-]:\S*?#{Mx[:lv_c]}|<.+?>)?\s*'/,'\1`') #fix Mx[:lv_o] # open '
      end
      str=str.gsub(/(<font.*?>|<\/font>)/,'').
        gsub(/\s*#{Mx[:fa_superscript_o]}(\S+?)#{Mx[:fa_superscript_c]}/,'^\1')
      str
    end
    def xetex_special_characters_3(str)
      str=str.gsub(/<br(\s*[^\/][^>])/,'\1'). # clean up, incredibly messy :-( footnote indents, problems if match exists in ordinary paragraphs? check! Work Area 200501 a bit tricky as must be able to match multiple times, and to clean remainder
        gsub(/([^<][^b][^r]\s+)\/>/,'\1') # clean up, incredibly messy :-( footnote indents, problems if match exists in ordinary paragraphs? check! Work Area 200501 a bit tricky as must be able to match multiple times, and to clean remainder
      while str =~/(https?:\/\/\S+?)(?:<=tilde>\S+)+/ #tilde in urls \href treated differently from text #FIX
        str=str.gsub(/(https?:\/\/\S+?)(?:<=tilde>(\S+))+/,'\1~\2')
      end
      str=str.gsub(/<=tilde>/,'{$\tilde$}').
        gsub(/(https?:\/\/\S+?)(?:(?:<=hash>)(\S+))+/,'\1#\2'). #hash in urls \href treated differently from text #FIX
        gsub(/<=hash>/,'{\#}')
      while str =~/(https?:\/\/\S+?)(?:<=amp>\S+)+/ #amp in urls \href treated differently from text #FIX
        str=str.gsub(/(https?:\/\/\S+?)(?:<=amp>(\S+))+/,'\1&\2')
      end
      str=str.gsub(/<=amp>/,'{\\\&}'). #changed ... 2005
        gsub(/<=copymark>\s*(.+)/,
          '^\copyright \textnormal{\1} \2') # watch likely to be problematic
      str
    end
    def special_characters_safe_close(str)
      str=str.gsub(/<=tilde>/,'{$\tilde$}').
        gsub(/<=hash>/,'{\#}').
        gsub(/<=amp>/,'{\\\&}'). #changed ... 2005
        gsub(/<=copymark>\s*(.+)/,
          '^\copyright \textnormal{\1} \2') # watch likely to be problematic
    end
    def special_characters_code_fix(str)
      str=str.gsub(/<=tilde>/,'{$\tilde$}')
      str
    end
    def special_characters_unsafe_1(str) #depreciated, make obsolete
      # some substitutions are sequence sensitive, rearrange with care.
      str=str.gsub(/\\textbackslash (copyright|clearpage|newpage)/,"\\\\\\1")  #kludge bad solution, find out where tail is sent through specChar !
      str
    end
    def special_characters                                                   # special characters - some substitutions are sequence sensitive, rearrange with care
      str,is=@txt,@is
      str=xetex_special_characters_1(str,is) unless str.nil?
      str=special_characters_unsafe_1(str) unless str.nil? #xetex_special_characters_unsafe_1(@txt)
      str=xetex_special_characters_2(str,is) unless str.nil? #issues with xetex
      str=xetex_special_characters_3(str) unless str.nil?
      @txt=str
    end
    def special_word_break_points
      str=@txt
      str=str.gsub(/([_,.;:\/|=])/,'\1\-').
        gsub(/(--)(\S{4,})/,'\1\-\2')
      @txt=str
    end
    def special_number_break_points
      str=@txt
      str=str.gsub(/([0-9a-f]{8})/i,'\1\-')
      @txt=str
    end
    def special_characters_safe                                              # special characters - some substitutions are sequence sensitive, rearrange with care
      str,is=@txt,@is
      str=xetex_special_characters_1(str,is) unless str.nil?
      str=xetex_special_characters_2(str,is) unless str.nil?                 # remove this to start with, causes issues
      str=special_characters_safe_close(str) unless str.nil?
      @txt=str
    end
    def special_characters_safe_no_urls
      str,is=@txt,:no_urls
      str=xetex_special_characters_1(str,is) unless str.nil?
      str=xetex_special_characters_2(str,is) unless str.nil? # remove this to start with, causes issues
      str=special_characters_safe_close(str) unless str.nil?
      @txt=str
    end
    def characters_code_listings                                             # special characters - some substitutions are sequence sensitive, rearrange with care
      str,is=@txt,@is
      str=xetex_code_listings(str,is) unless str.nil?
      @txt=str
    end
    def special_characters_code
      str=@txt
      str=str.gsub(/ \\\\([ #{Mx[:br_nl]}]+|$)/,' \textbackslash\textbackslash\hardspace\1')
      str
    end
  end
  class UseTeX
    include SiSU_Parts_TeXpdf
    attr_accessor :url,:txt,:date
    def initialize(md)
      @md=md
      @date=SiSU_Env::InfoDate.new # #{@date.year}
      @copymark='{\\begin{footnotesize}\\raisebox{1ex}{\\copyright}\\end{footnotesize}}'
    end
    def skip
      "\n\\vspace*{\\smallskipamount} \n"
    end
    def paraskip_normal
      '\setlength{\parskip}{1ex plus0.5ex minus0.2ex}'
    end
    def paraskip_small
      '\setlength{\parskip}{0.5ex plus0.2ex minus0.1ex}'
    end
    def paraskip_tiny
      '\setlength{\parskip}{0.1ex plus0.1ex minus0.1ex}'
    end
    def skip_small
      "\\smallskip{}"
    end
    def skip_small_vspace
      "\n\\vspace*{\\smallskipamount} \n"
    end
    def skip_small_footnote
    end
    def skip_medium
      "\n\\medskip{}\n\n"
    end
    def skip_dummy
      "\n"
    end
    def header
      "\\lhead[ ]{ }\n" +
      "\\chead[ \\fancyplain{} \\bfseries \\footnotesize \\leftmark ]{ \\fancyplain{} \\bfseries \\footnotesize \\rightmark }\n" +
      "\\rhead[ ]{ }\n"
    end
    def footer
      "\\lfoot[\\textrm{\\thepage}]{\\tiny \\href{#{@md.footer_links[:left][:url]}}{#{@md.footer_links[:left][:say]}}}\n" +
      "\\cfoot{\\href{#{@md.footer_links[:center][:url]}}{#{@md.footer_links[:center][:say]}}}\n" +
      "\\rfoot[\\tiny \\href{}{}]{\\textrm{\\thepage}}\n"
    end
    def site
      if not the_url.home.empty? \
      and not the_url.home_txt.empty?
        "\n\\date{\\begin{tiny} \\end{tiny}}"
      else ''
      end
    end
    def owner_chapter
      "Contact Details for Original Promulgating Authority"
    end
    #BOOK standard dimensions - 229x156
    def newpage(orientation)
      case orientation
      when :landscape # using longtable latex package
        <<-WOK
\\clearpage
        WOK
      when :portrait
        <<-WOK
\\newpage
        WOK
      end
    end
    def sisu_rights
      v=SiSU_Env::InfoVersion.instance.get_version
      base_prog_txt=if @md.base_program
        case @md.base_program
        when /kdissert/i then "\n\\\\ This document prepared using \\href{http://freehackers.org/~tnagy/kdissert/}{Kdissert \\ http://freehackers.org/~tnagy/kdissert/ } \\\\ Kdissert is Document Mapping software by Thomas Nagy"
        else ''
        end
      else ''
      end
      <<-WOK
\\\\ ~
{\\begin{footnotesize}#{base_prog_txt}
\\\\ Generated by \\href{http://www.jus.uio.no/sisu}{SiSU} \\begin{tiny}[ #{v[:project]} #{v[:version]} of #{v[:date_stamp]} ]\\end{tiny} \\href{http://www.jus.uio.no/sisu}{www.jus.uio.no/sisu}
\\\\ Copyright #{@copymark} 1997, current #{@date.year_static} Ralph Amissah, All Rights Reserved.
\\\\ SiSU is software for document structuring, publishing and search (with object citation numbering), \\href{http://www.sisudoc.org}{www.sisudoc.org}
\\\\ SiSU is released under \\href{http://www.fsf.org/licenses/gpl.html}{GPL 3 } or later, #{url_brace.tex_open}\\href{http://www.fsf.org/licenses/gpl.html}{http://www.fsf.org/licenses/gpl.html}#{url_brace.tex_close}.
{\\end{footnotesize}
\\\\
      WOK
    end
    def doc_sc_info_footnote_full
      <<-WOK
\\footnote{%\nGenerated by \\href{http://www.jus.uio.no/sisu}{SiSU \\ www.jus.uio.no/sisu }\\ \\newline \\scriptsize{Document version information: \\emph{sourcefile} \\uline{#{@md.fnstex}}; \\emph{version} \\uline{#{@md.sc_number}}; \\emph{date} \\uline{#{@md.sc_date}}; \\emph{time} \\uline{#{@md.sc_time}}}}
      WOK
    end
    def doc_sc_info_footnote_brief
      " \\footnote{%\nGenerated by \\href{http://www.jus.uio.no/sisu}{SiSU} \\ \\href{http://www.jus.uio.no/sisu}{www.jus.uio.no/sisu} \\newline \\href{http://www.sisudoc.org}{www.sisudoc.org} \\\n}"
    end
    def doc_sc_info
      v=SiSU_Env::InfoVersion.instance.get_version
      <<-WOK
\\\\
{\\begin{footnotesize}
Document version information: \\\\
\\emph{sourcefile} \\uline{#{@md.fnstex}}; \\emph{version} \\uline{#{@md.sc_number}}; \\emph{date} \\uline{#{@md.sc_date}}; \\emph{time} \\uline{#{@md.sc_time}} \\\\
Generated by \\href{http://www.jus.uio.no/sisu}{SiSU www.jus.uio.no/sisu }\\- version information: \\\\
\\uline{ #{v[:project]} #{v[:version]} of #{v[:date_stamp]}}
\\end{footnotesize}}&
      WOK
    end
    def doc_no_sc_info
      v=SiSU_Env::InfoVersion.instance.get_version
      <<-WOK
\\\\
{\\begin{small}
Document information: \\\\
\\emph{sourcefile} \\uline{#{@md.fnstex}} \\\\
Generated by \\href{http://www.jus.uio.no/sisu}{SiSU www.jus.uio.no/sisu } \\\\ version information: \\
\\uline{ #{v[:project]} #{v[:version]} of #{v[:date_stamp]}}

\\end{small}}&
      WOK
    end
    def endnotes #not used should be inserted before MetaData section which preceeds doc_tail, but is "part of document"
      <<-WOK
\\subsection*{Endnotes}
\\addcontentsline{toc}{section}{Endnotes}
\\
\\listofendnotes
      WOK
    end
  end
end
__END__
#ack usepackage texpdf*
#ack usepackage texpdf* |ack '\{.+?\}'
#see sisu_texpdf_usepackage.rb
  alltt.sty
  amssymb.sty
  babel.sty
  boites.sty
  color.sty
  endnotes.sty
  fancyhdr.sty
  fontspec.sty
  footmisc.sty
  graphicx.sty
  inputenc.sty
  listings.sty
  longtable.sty
  manyfoot.sty
  multicol.sty
  parskip.sty
  polyglossia.sty
  soul.sty
  textcomp.sty
  thumbpdf.sty
  titlepic.sty
  ucs.sty
  ulem.sty
  url.sty
  xetex.sty
  xltxtra.sty
  xunicode.sty
---
texlive-latex-base
texlive-base
texlive-latex-extra
texlive-latex-recommended
texlive-xetex
texlive-generic-recommended
---
texlive-latex-base:
    /usr/share/texlive/texmf-dist/tex/generic/babel/babel.sty
    /usr/share/texlive/texmf-dist/tex/latex/base/alltt.sty
    /usr/share/texlive/texmf-dist/tex/latex/base/inputenc.sty
    /usr/share/texlive/texmf-dist/tex/latex/base/textcomp.sty
    /usr/share/texlive/texmf-dist/tex/latex/fancyhdr/fancyhdr.sty
    /usr/share/texlive/texmf-dist/tex/latex/graphics/color.sty
    /usr/share/texlive/texmf-dist/tex/latex/graphics/graphicx.sty
    /usr/share/texlive/texmf-dist/tex/latex/tools/longtable.sty
    /usr/share/texlive/texmf-dist/tex/latex/tools/multicol.sty
---
texlive-base:
    /usr/share/texlive/texmf-dist/tex/latex/amsfonts/amssymb.sty
---
texlive-latex-extra:
    /usr/share/texlive/texmf-dist/tex/latex/boites/boites.sty
    /usr/share/texlive/texmf-dist/tex/latex/endnotes/endnotes.sty
    /usr/share/texlive/texmf-dist/tex/latex/footmisc/footmisc.sty
    /usr/share/texlive/texmf-dist/tex/latex/ncctools/manyfoot.sty
    /usr/share/texlive/texmf-dist/tex/latex/soul/soul.sty
    /usr/share/texlive/texmf-dist/tex/latex/titlepic/titlepic.sty
    /usr/share/texlive/texmf-dist/tex/latex/ucs/ucs.sty
---
texlive-latex-recommended:
    /usr/share/texlive/texmf-dist/tex/generic/thumbpdf/thumbpdf.sty
    /usr/share/texlive/texmf-dist/tex/latex/fontspec/fontspec.sty
    /usr/share/texlive/texmf-dist/tex/latex/listings/listings.sty
    /usr/share/texlive/texmf-dist/tex/latex/parskip/parskip.sty
    /usr/share/texlive/texmf-dist/tex/latex/url/url.sty
---
texlive-xetex:
    /usr/share/texlive/texmf-dist/tex/latex/xltxtra/xltxtra.sty
    /usr/share/texlive/texmf-dist/tex/xelatex/polyglossia/polyglossia.sty
    /usr/share/texlive/texmf-dist/tex/xelatex/xunicode/xunicode.sty
---
texlive-generic-recommended:
    /usr/share/texlive/texmf-dist/tex/generic/ulem/ulem.sty
