/* # skkinput (Simple Kana-Kanji Input)
 * imsendbuf.c --- XIM Porotocol Send Buffer
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <X11/Intrinsic.h>
#include <X11/Xfuncs.h>
#include "imsendbuf.h"
#include "im.h"

#define MAX_IMSENDBUF_FREELIST_LEN	(20)

static struct _imsendbuf *imsendbuf_freelisttop = NULL ;
static int imsendbuf_freelistlen = 0 ;

extern void commitString( IMIC *icp, struct myChar *str, int sync ) ;
extern void imSendbackKey( IMIC *icp, XKeyEvent *ev, int sync ) ;

static struct _imsendbuf *IMSendBufPrepare( void )
{
  struct _imsendbuf *node ;
  if( imsendbuf_freelisttop != NULL ){
    node                  = imsendbuf_freelisttop ;
    imsendbuf_freelisttop = imsendbuf_freelisttop->next ;
  } else {
    node = malloc( sizeof( struct _imsendbuf ) ) ;
  }
  if( node != NULL ){
    node->type = IM_SEND_EMPTY ;
    node->next = NULL ;
  }
  return node ;
}

static void IMSendBufFree( struct _imsendbuf *node )
{
  if( node == NULL )
    return ;
  if( node->type == IM_SEND_STRING )
    close_kanjibuffer( &( node->data.commit ) ) ;
  node->type = IM_SEND_EMPTY ;
  if( imsendbuf_freelistlen < MAX_IMSENDBUF_FREELIST_LEN ){
    node->next            = imsendbuf_freelisttop ;
    imsendbuf_freelisttop = node ;
    imsendbuf_freelistlen ++ ;
  } else {
    free( node ) ;
  }
  return ;
}

/*
 *  sendbuffer ȤƸƤФʤФʤʤؿ
 *----
 *()
 * freelist ν򤷤Ƥ롣freelist Ȥͳˤ malloc, free
 * η֤ˤ®٤㲼򤱤뤿Ǥ롣Ϥɤ٤ޤ freelist
 * ĹȤɤΤ¬ʤФʤʤȤǤ뤬ߤϤƤ
 * ʤim ǻȤäƤơޤ٤褦ȡ freelist Ĺ䤹
 * Ȳ뤫⤷ʤ
 */
int IMSendBufInit( void )
{
  imsendbuf_freelisttop = NULL ;
  imsendbuf_freelistlen = 0 ;
  return True ;
}

int IMSendBufCommit( IMIC *icp, struct myChar *text, int length )
{
  struct imsendbuf  *sendbuf = &icp->send_buf ;
  struct _imsendbuf *node ;
  if( sendbuf->last == NULL ){
    if( ( sendbuf->top = sendbuf->last = IMSendBufPrepare() ) == NULL )
      return False ;
    sendbuf->last->type = IM_SEND_STRING ;
    init_kanjibuffer( &( sendbuf->last->data.commit ) ) ;
    add_kanjiStringToKanjiBuffer
      ( &( sendbuf->last->data.commit ), text, length ) ;
  } else {
    if( sendbuf->last->type == IM_SEND_STRING ){
      add_kanjiStringToKanjiBuffer
	( &( sendbuf->last->data.commit ), text, length ) ;
    } else {
      if( ( node = IMSendBufPrepare() ) == NULL )
	return False ;
      sendbuf->last->next = node ;
      sendbuf->last       = node ;
	
      node->type             = IM_SEND_STRING ;
      init_kanjibuffer( &( node->data.commit ) ) ;
      add_kanjiStringToKanjiBuffer
	( &( node->data.commit ), text, length ) ;
    }
  }
  return True ;
}

int IMSendBufEvent( IMIC *icp, XKeyEvent *ev )
{
  struct imsendbuf  *sendbuf = &icp->send_buf ;
  struct _imsendbuf *node ;
  if( ( node = IMSendBufPrepare() ) == NULL )
    return False ;
  if( sendbuf->last == NULL ){
    sendbuf->top = sendbuf->last = node ;
  } else {
    sendbuf->last->next = node ;
    sendbuf->last       = node ;
  }
  node->type               = IM_SEND_EVENT ;
  memcpy( &( node->data.event ), ev, sizeof( XKeyEvent ) ) ;
  return True ;
}

void IMSendBufDiscard( IMIC *icp, int num )
{
  struct imsendbuf  *sendbuf = &icp->send_buf ;
  struct _imsendbuf *node, *nextnode ;
  /* Ƭ֤˥ե꡼ƹԤ*/
  node = sendbuf->top ;
  while( num > 0 && node != NULL ){
    nextnode = node->next ;
    IMSendBufFree( node ) ;
    node     = nextnode ;
    num -- ;
  }
  /* Ƭ򹹿롣*/
  sendbuf->top = node ;
  /* last Ͼ˥ꥹȤκǸؤ褦ˤʤäƤΤǡƬ NULL ˤʤ
   * Ȥϡlast  NULL ˤʤʤФʤʤ*/
  if( node == NULL )
    sendbuf->last = NULL ;
  return ;
}

void IMSendBufFlush( IMIC *icp )
{
  struct imsendbuf  *sendbuf = &icp->send_buf ;
  struct _imsendbuf *node ;
  /* Ƭ֤˥ե꡼ƹԤ*/
  node = sendbuf->top ;
  if( node == NULL )
    return ;
  switch( node->type ){
  case IM_SEND_STRING :
    commitString( icp, node->data.commit.buffer, True ) ;
    icp->state |= IC_COMMIT_WAIT ;
    break ;
  case IM_SEND_EVENT :
    /* Ѵ饤Ȥؤ롣*/
    imSendbackKey( icp, &( node->data.event ), True ) ;
    icp->state |= IC_COMMIT_WAIT ;
    break ;
  default :
    break ;
  }
  IMSendBufDiscard( icp, 1 ) ;
  return ;
}

