/* # skkinput (Simple Kana-Kanji Input)
 * ctext.c --- About compound text
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <limits.h>
#include "commondef.h"
#include "kanji.h"

enum {
	CHARSET_DUMMY = -1,
	/* 94 ʸ硣*/
	CHARSET94_LEFT_HALF_OF_ISO8859 = 0,
	CHARSET94_RIGHT_HALF_OF_JISX0201_1976,
	CHARSET94_LEFT_HALF_OF_JISX0201_1976,
	
	/* 96 ʸ硣*/
	CHARSET96_RIGHT_HALF_OF_ISO8859_1,
	CHARSET96_RIGHT_HALF_OF_ISO8859_2,
	CHARSET96_RIGHT_HALF_OF_ISO8859_3,
	CHARSET96_RIGHT_HALF_OF_ISO8859_4,
	CHARSET96_RIGHT_HALF_OF_ISO8859_5,
	CHARSET96_RIGHT_HALF_OF_ISO8859_6,
	CHARSET96_RIGHT_HALF_OF_ISO8859_7,
	CHARSET96_RIGHT_HALF_OF_ISO8859_8,
	CHARSET96_RIGHT_HALF_OF_ISO8859_9,
	
	/* 94^2 ʸ硣*/
	CHARSET94_2_JISX0208_1978,
	CHARSET94_2_JISX0208_1983,
	CHARSET94_2_JISX0212_1990,
	CHARSET94_2_GB2312_1980_CHINA,
	CHARSET94_2_KSC5601_1987_KOREAN,
} ;

int	string2ctextn (
	register struct myChar*		string,
	register int				nstring,
	register unsigned char*		cstr)
{
	int current_glcode, current_grcode, length ;
  /* Charset94  l{F} */
#if 0
	static unsigned char charset94EscapeStrings[ 3 ] = 
	{ 0x42, 0x49, 0x4A } ;
#endif
	/* Charset94^2  l{F} */
	static unsigned char charset94_2EscapeStrings
		[ CHARSET_KSC5601_1987 - CHARSET_JISX0208_1978 + 1 ] =
	{ 0x40, 0x42, 0x44, 0x41, 0x43 } ;
	/* Charset96  l{F} */
	static unsigned char charset96EscapeStrings
		[ CHARSET_ISO8859_9 - CHARSET_ISO8859_1 + 1 ] =
	{ 0x41, 0x42, 0x43, 0x44, 0x4C, 0x47, 0x46, 0x48, 0x4D } ;
	length   = 0 ;
	
	/* encoding Ϻǽ顢ǤʤͤˤʤäƤ롣*/
	current_glcode = CHARSET_DUMMY ;
	current_grcode = CHARSET_DUMMY ;
	
	while (nstring > 0 && !IS_END_OF_STRING (*string)){
		switch( string->charset ){
		case CHARSET_ISO8859_1 :
		case CHARSET_ISO8859_2 :
		case CHARSET_ISO8859_3 :
		case CHARSET_ISO8859_4 :
		case CHARSET_ISO8859_5 :
		case CHARSET_ISO8859_6 :
		case CHARSET_ISO8859_7 :
		case CHARSET_ISO8859_8 :
		case CHARSET_ISO8859_9 :
			/* left half of iso8859 charsets */
			if( string->chara >= 0x20 && string->chara <= 0x7F ){
				/* ǽʸξˤ charset  ASCII ˶Ū˰ư롣*/
				if( current_glcode != CHARSET94_LEFT_HALF_OF_ISO8859 ){
					if( cstr != NULL ){	  
						*cstr ++ = 0x1B ; /* 01/11 */
						*cstr ++ = 0x28 ; /* 02/08 */
						*cstr ++ = 0x42 ; /* 04/02 */
					}
					length += 3 ;
					current_glcode = CHARSET94_LEFT_HALF_OF_ISO8859 ;
				}
			} else if( string->chara >= 0xA0 && string->chara <= 0xFF ){
				/* right half of iso8859 charsets */
				if( current_grcode != 
					( CHARSET96_RIGHT_HALF_OF_ISO8859_1 + 
					  ( string->charset - CHARSET_ISO8859_1 ) ) ){
					if( cstr != NULL ){	  
						*cstr ++ = 0x1B ; /* 01/11 */
						*cstr ++ = 0x2D ; /* 02/13 */
						*cstr ++ = charset96EscapeStrings
							[ string->charset - CHARSET_ISO8859_1 ] ;
					}
					length += 3 ;
					current_grcode = CHARSET96_RIGHT_HALF_OF_ISO8859_1 + 
						( string->charset - CHARSET_ISO8859_1 ) ;
				}
			}
			/* Ⱦ̤Ф˻Ȥʤ(^^;;; */
			if( cstr != NULL )
				*cstr ++ = ( string->chara ) ;
			length ++ ;
			string ++ ;
			nstring -- ;
			break ;
			
		case CHARSET_JISX0201_1976 :
			/* left half of JISX0201-1976 */
			if( string->chara >= 0x20 && string->chara <= 0x7F ){
				if( current_glcode != CHARSET94_LEFT_HALF_OF_JISX0201_1976 ){
					if( cstr != NULL ){	  
						*cstr ++ = 0x1B ; /* 01/11 */
						*cstr ++ = 0x28 ; /* 02/08 */
						*cstr ++ = 0x4A ; /* 04/10 */
					}
					length += 3 ;
					current_glcode = CHARSET94_LEFT_HALF_OF_JISX0201_1976 ;
				}
			} else if( string->chara >= 0xA0 && string->chara <= 0xFF ){
				if( current_grcode != CHARSET94_RIGHT_HALF_OF_JISX0201_1976 ){
					if( cstr != NULL ){	  
						*cstr ++ = 0x1B ; /* 01/11 */
						*cstr ++ = 0x29 ; /* 02/09 */
						*cstr ++ = 0x49 ; /* 04/09 */
					}
					length += 3 ;
					current_grcode = CHARSET94_RIGHT_HALF_OF_JISX0201_1976 ;
				}
			}
			if( cstr != NULL )
				*cstr ++ = ( string->chara ) ;
			length ++ ;
			string ++ ;
			nstring -- ;
			break ;
			
		case CHARSET_JISX0208_1978 :
		case CHARSET_JISX0208_1983 :
		case CHARSET_JISX0212_1990 :
		case CHARSET_GB2312_1980 :
		case CHARSET_KSC5601_1987 :
			if( current_grcode != 
				( CHARSET94_2_JISX0208_1978 + 
				  ( string->charset - CHARSET_JISX0208_1978 ) ) ){
				if( cstr != NULL ){	  
					*cstr ++ = 0x1B ; /* 01/11 */
					*cstr ++ = 0x24 ; /* 02/04 */
					*cstr ++ = 0x29 ; /* 02/09 */
					*cstr ++ = charset94_2EscapeStrings
						[ string->charset - CHARSET_JISX0208_1978 ] ;
				}
				current_grcode = CHARSET94_2_JISX0208_1978 + 
					( string->charset - CHARSET_JISX0208_1978 ) ;
				length += 4 ;
			}
			if( cstr != NULL ){
				/* Ⱦ̤Ф˻Ȥʤ(^^;;; */
				*cstr ++ = ( ( ( string->chara ) >> 8 ) & 0x7F ) | 0x80 ;
				*cstr ++ = ( ( string->chara & 0x007F ) ) | 0x80 ;
			}
			length += 2 ;
			string ++ ;
			nstring -- ;
			break ;
			/* ⤷ȡcharset 뤫⤷ʤ͡*/
		default :
			string ++ ;
			nstring -- ;
			break ;
		}
	}
	return length ;
}

/*
 * charset ʤ string  Compound Text Ѵؿ
 */
int	string2ctext (
	register struct myChar*		string,
	register unsigned char*		cstr)
{
	return	string2ctextn (string, INT_MAX, cstr) ;
}

