#!/bin/sh
# Package a Smurf tarball into RPM packages
# Careful with this script!! It needs to be run as root to build RPMs.
# In particular an "rm -rf $TMPDIR" is done

RPMROOT=/usr/src/RPM
PKGDIR=.
TMPDIR=${PKGDIR}/packtmp

if test ! -e "./$0" ; then
    echo "Run this script from within the package directory"
    exit 1
fi

if test -z "$1" -o ! -e "$1" ; then
    echo "Usage: $0 smurf-x.xx.x.tar.gz"
    exit 1
fi

if test $LOGNAME != "root" ; then
    echo "Should be run as root to build RPMs"
    exit 1
fi

SMURFDIR=`basename $1 .tar.gz`

# Unset LINGUAS so all languages will be built
unset LINGUAS

rm -rf ${TMPDIR} && \
mkdir ${TMPDIR} && \

tar -C ${TMPDIR} -xzf $1 && \

cat ${TMPDIR}/${SMURFDIR}/smurf.spec \
    | sed 's|^\./configure.*$|& --disable-alsa-support --with-audiofile'\
' --disable-awe-caching|' \
    >${TMPDIR}/smurf-binary-rpm.spec && \

mv ${TMPDIR}/${SMURFDIR}/smurf.spec ${TMPDIR}/smurf-binary-rpm.spec \
    ${RPMROOT}/SPECS/ && \

cp $1 ${RPMROOT}/SOURCES/ && \

rpm -bs ${RPMROOT}/SPECS/smurf.spec && \
rpm -bb ${RPMROOT}/SPECS/smurf-binary-rpm.spec && \

find ${RPMROOT}/RPMS/ -name "smurf*.rpm" -exec mv {} ${PKGDIR} ';' && \
find ${RPMROOT}/SRPMS/ -name "smurf*.rpm" -exec mv {} ${PKGDIR} ';' && \

rm -rf ${TMPDIR}

exit 0
